/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    SslHandlerCoalescingBufferQueue(Channel channel2, int initSize, boolean wantsDirectBuffer) {
        super(channel2, initSize);
        this.wantsDirectBuffer = wantsDirectBuffer;
    }

    protected abstract int wrapDataSize();

    @Override
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        return SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(cumulation, next, this.wrapDataSize()) ? cumulation : this.copyAndCompose(alloc, cumulation, next);
    }

    @Override
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first2, int bufferSize) {
        ByteBuf newFirst = this.wantsDirectBuffer ? allocator.directBuffer(bufferSize) : allocator.heapBuffer(bufferSize);
        try {
            newFirst.writeBytes(first2);
        }
        catch (Throwable cause) {
            newFirst.release();
            PlatformDependent.throwException(cause);
        }
        assert (!first2.isReadable());
        first2.release();
        return newFirst;
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return null;
    }

    private static boolean attemptCopyToCumulation(ByteBuf cumulation, ByteBuf next, int wrapDataSize) {
        int inReadableBytes = next.readableBytes();
        if (inReadableBytes == 0) {
            next.release();
            return true;
        }
        int cumulationCapacity = cumulation.capacity();
        if (wrapDataSize - cumulation.readableBytes() >= inReadableBytes && (cumulation.isWritable(inReadableBytes) && cumulationCapacity >= wrapDataSize || cumulationCapacity < wrapDataSize && ByteBufUtil.ensureWritableSuccess(cumulation.ensureWritable(inReadableBytes, false)))) {
            cumulation.writeBytes(next);
            next.release();
            return true;
        }
        return false;
    }
}

