package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.AssignmentPermissionAndActiveUserSubmitterUid;
import com.ustadmobile.lib.db.composites.CoursePermissionAndEnrolment;
import com.ustadmobile.lib.db.composites.CoursePermissionAndListDetail;
import com.ustadmobile.lib.db.composites.PermissionPair;
import com.ustadmobile.lib.db.composites.PermissionTriple;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CoursePermission;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CoursePermissionDao_Impl extends CoursePermissionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CoursePermission> __insertionAdapterOfCoursePermission;

  private final SharedSQLiteStatement __preparedStmtOfSetDeleted;

  public CoursePermissionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCoursePermission = new EntityInsertionAdapter<CoursePermission>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CoursePermission` (`cpUid`,`cpLastModified`,`cpClazzUid`,`cpToEnrolmentRole`,`cpToPersonUid`,`cpToGroupUid`,`cpPermissionsFlag`,`cpIsDeleted`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CoursePermission entity) {
        statement.bindLong(1, entity.getCpUid());
        statement.bindLong(2, entity.getCpLastModified());
        statement.bindLong(3, entity.getCpClazzUid());
        statement.bindLong(4, entity.getCpToEnrolmentRole());
        statement.bindLong(5, entity.getCpToPersonUid());
        statement.bindLong(6, entity.getCpToGroupUid());
        statement.bindLong(7, entity.getCpPermissionsFlag());
        final int _tmp = entity.getCpIsDeleted() ? 1 : 0;
        statement.bindLong(8, _tmp);
      }
    };
    this.__preparedStmtOfSetDeleted = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CoursePermission\n"
                + "           SET cpIsDeleted = ?,\n"
                + "               cpLastModified = ?\n"
                + "         WHERE cpUid = ?  \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object upsertAsync(final CoursePermission coursePermission,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCoursePermission.insert(coursePermission);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object setDeleted(final long cpUid, final boolean isDeleted, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetDeleted.acquire();
        int _argIndex = 1;
        final int _tmp = isDeleted ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cpUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfSetDeleted.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, CoursePermissionAndListDetail> findByClazzUidAsPagingSource(
      final long clazzUid, final boolean includeDeleted) {
    final String _sql = "\n"
            + "        SELECT CoursePermission.*, Person.*, PersonPicture.*\n"
            + "          FROM CoursePermission\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personUid = CoursePermission.cpToPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE CoursePermission.cpClazzUid = ? \n"
            + "           AND (CAST(? AS INTEGER) = 1 OR NOT CoursePermission.cpIsDeleted) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return new LimitOffsetPagingSource<CoursePermissionAndListDetail>(_statement, __db, "CoursePermission", "Person", "PersonPicture") {
      @Override
      @NonNull
      protected List<CoursePermissionAndListDetail> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow(cursor, "cpUid");
        final int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cpLastModified");
        final int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "cpClazzUid");
        final int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "cpToEnrolmentRole");
        final int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "cpToPersonUid");
        final int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "cpToGroupUid");
        final int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(cursor, "cpPermissionsFlag");
        final int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "cpIsDeleted");
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(cursor, "isPersonalAccount");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUid");
        final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureLct");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureThumbnailUri");
        final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
        final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureActive");
        final List<CoursePermissionAndListDetail> _result = new ArrayList<CoursePermissionAndListDetail>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CoursePermissionAndListDetail _item;
          final CoursePermission _tmpCoursePermission;
          if (!(cursor.isNull(_cursorIndexOfCpUid) && cursor.isNull(_cursorIndexOfCpLastModified) && cursor.isNull(_cursorIndexOfCpClazzUid) && cursor.isNull(_cursorIndexOfCpToEnrolmentRole) && cursor.isNull(_cursorIndexOfCpToPersonUid) && cursor.isNull(_cursorIndexOfCpToGroupUid) && cursor.isNull(_cursorIndexOfCpPermissionsFlag) && cursor.isNull(_cursorIndexOfCpIsDeleted))) {
            final long _tmpCpUid;
            _tmpCpUid = cursor.getLong(_cursorIndexOfCpUid);
            final long _tmpCpLastModified;
            _tmpCpLastModified = cursor.getLong(_cursorIndexOfCpLastModified);
            final long _tmpCpClazzUid;
            _tmpCpClazzUid = cursor.getLong(_cursorIndexOfCpClazzUid);
            final int _tmpCpToEnrolmentRole;
            _tmpCpToEnrolmentRole = cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
            final long _tmpCpToPersonUid;
            _tmpCpToPersonUid = cursor.getLong(_cursorIndexOfCpToPersonUid);
            final long _tmpCpToGroupUid;
            _tmpCpToGroupUid = cursor.getLong(_cursorIndexOfCpToGroupUid);
            final long _tmpCpPermissionsFlag;
            _tmpCpPermissionsFlag = cursor.getLong(_cursorIndexOfCpPermissionsFlag);
            final boolean _tmpCpIsDeleted;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfCpIsDeleted);
            _tmpCpIsDeleted = _tmp_1 != 0;
            _tmpCoursePermission = new CoursePermission(_tmpCpUid,_tmpCpLastModified,_tmpCpClazzUid,_tmpCpToEnrolmentRole,_tmpCpToPersonUid,_tmpCpToGroupUid,_tmpCpPermissionsFlag,_tmpCpIsDeleted);
          } else {
            _tmpCoursePermission = null;
          }
          final Person _tmpPerson;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp_2 != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_3 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_4;
            _tmp_4 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_4 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpPerson = null;
          }
          final PersonPicture _tmpPersonPicture;
          if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp_5;
            _tmp_5 = cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp_5 != 0;
            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _tmpPersonPicture = null;
          }
          _item = new CoursePermissionAndListDetail(_tmpCoursePermission,_tmpPerson,_tmpPersonPicture);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findByUidAndClazzUid(final long uid, final long clazzUid,
      final Continuation<? super CoursePermission> $completion) {
    final String _sql = "\n"
            + "        SELECT CoursePermission.*\n"
            + "          FROM CoursePermission\n"
            + "         WHERE CoursePermission.cpUid = ?\n"
            + "           AND CoursePermission.cpClazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CoursePermission>() {
      @Override
      @Nullable
      public CoursePermission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpUid");
          final int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cpLastModified");
          final int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpClazzUid");
          final int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToEnrolmentRole");
          final int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToPersonUid");
          final int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToGroupUid");
          final int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "cpPermissionsFlag");
          final int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cpIsDeleted");
          final CoursePermission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCpUid;
            _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
            final long _tmpCpLastModified;
            _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
            final long _tmpCpClazzUid;
            _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
            final int _tmpCpToEnrolmentRole;
            _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
            final long _tmpCpToPersonUid;
            _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
            final long _tmpCpToGroupUid;
            _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
            final long _tmpCpPermissionsFlag;
            _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
            final boolean _tmpCpIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
            _tmpCpIsDeleted = _tmp != 0;
            _result = new CoursePermission(_tmpCpUid,_tmpCpLastModified,_tmpCpClazzUid,_tmpCpToEnrolmentRole,_tmpCpToPersonUid,_tmpCpToGroupUid,_tmpCpPermissionsFlag,_tmpCpIsDeleted);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<CoursePermission> findByUidAndClazzUidAsFlow(final long uid, final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT CoursePermission.*\n"
            + "          FROM CoursePermission\n"
            + "         WHERE CoursePermission.cpUid = ?\n"
            + "           AND CoursePermission.cpClazzUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CoursePermission"}, new Callable<CoursePermission>() {
      @Override
      @Nullable
      public CoursePermission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpUid");
          final int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cpLastModified");
          final int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpClazzUid");
          final int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToEnrolmentRole");
          final int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToPersonUid");
          final int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToGroupUid");
          final int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "cpPermissionsFlag");
          final int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cpIsDeleted");
          final CoursePermission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCpUid;
            _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
            final long _tmpCpLastModified;
            _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
            final long _tmpCpClazzUid;
            _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
            final int _tmpCpToEnrolmentRole;
            _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
            final long _tmpCpToPersonUid;
            _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
            final long _tmpCpToGroupUid;
            _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
            final long _tmpCpPermissionsFlag;
            _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
            final boolean _tmpCpIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
            _tmpCpIsDeleted = _tmp != 0;
            _result = new CoursePermission(_tmpCpUid,_tmpCpLastModified,_tmpCpClazzUid,_tmpCpToEnrolmentRole,_tmpCpToPersonUid,_tmpCpToGroupUid,_tmpCpPermissionsFlag,_tmpCpIsDeleted);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object personHasPermissionWithClazzByEnrolmentUidEntities2(final long accountPersonUid,
      final long clazzEnrolmentUid,
      final Continuation<? super List<CoursePermissionAndEnrolment>> $completion) {
    final String _sql = "\n"
            + "       SELECT CoursePermission.*, ClazzEnrolment_ForAccountPerson.*\n"
            + "         FROM CoursePermission\n"
            + "              \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "        WHERE CoursePermission.cpClazzUid = (\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n"
            + "                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n"
            + "                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n"
            + "    )\n"
            + "          AND (CoursePermission.cpToPersonUid = ? \n"
            + "               OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzEnrolmentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CoursePermissionAndEnrolment>>() {
      @Override
      @NonNull
      public List<CoursePermissionAndEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpUid");
          final int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cpLastModified");
          final int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpClazzUid");
          final int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToEnrolmentRole");
          final int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToPersonUid");
          final int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToGroupUid");
          final int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "cpPermissionsFlag");
          final int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cpIsDeleted");
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentInviteUid");
          final List<CoursePermissionAndEnrolment> _result = new ArrayList<CoursePermissionAndEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CoursePermissionAndEnrolment _item;
            final CoursePermission _tmpCoursePermission;
            if (!(_cursor.isNull(_cursorIndexOfCpUid) && _cursor.isNull(_cursorIndexOfCpLastModified) && _cursor.isNull(_cursorIndexOfCpClazzUid) && _cursor.isNull(_cursorIndexOfCpToEnrolmentRole) && _cursor.isNull(_cursorIndexOfCpToPersonUid) && _cursor.isNull(_cursorIndexOfCpToGroupUid) && _cursor.isNull(_cursorIndexOfCpPermissionsFlag) && _cursor.isNull(_cursorIndexOfCpIsDeleted))) {
              final long _tmpCpUid;
              _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
              final long _tmpCpLastModified;
              _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
              final long _tmpCpClazzUid;
              _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
              final int _tmpCpToEnrolmentRole;
              _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
              final long _tmpCpToPersonUid;
              _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
              final long _tmpCpToGroupUid;
              _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
              final long _tmpCpPermissionsFlag;
              _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
              final boolean _tmpCpIsDeleted;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
              _tmpCpIsDeleted = _tmp != 0;
              _tmpCoursePermission = new CoursePermission(_tmpCpUid,_tmpCpLastModified,_tmpCpClazzUid,_tmpCpToEnrolmentRole,_tmpCpToPersonUid,_tmpCpToGroupUid,_tmpCpPermissionsFlag,_tmpCpIsDeleted);
            } else {
              _tmpCoursePermission = null;
            }
            final ClazzEnrolment _tmpClazzEnrolment;
            if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && _cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
              _tmpClazzEnrolment = new ClazzEnrolment();
              final long _tmpClazzEnrolmentUid;
              _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
              _tmpClazzEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
              final long _tmpClazzEnrolmentPersonUid;
              _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
              _tmpClazzEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
              final long _tmpClazzEnrolmentClazzUid;
              _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
              _tmpClazzEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
              final long _tmpClazzEnrolmentDateJoined;
              _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
              _tmpClazzEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
              final long _tmpClazzEnrolmentDateLeft;
              _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
              _tmpClazzEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
              final int _tmpClazzEnrolmentRole;
              _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
              _tmpClazzEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
              final float _tmpClazzEnrolmentAttendancePercentage;
              _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
              _tmpClazzEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
              final boolean _tmpClazzEnrolmentActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
              _tmpClazzEnrolmentActive = _tmp_1 != 0;
              _tmpClazzEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
              final long _tmpClazzEnrolmentLeavingReasonUid;
              _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
              _tmpClazzEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
              final int _tmpClazzEnrolmentOutcome;
              _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
              _tmpClazzEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
              final long _tmpClazzEnrolmentLocalChangeSeqNum;
              _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
              _tmpClazzEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
              final long _tmpClazzEnrolmentMasterChangeSeqNum;
              _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
              _tmpClazzEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
              final int _tmpClazzEnrolmentLastChangedBy;
              _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
              _tmpClazzEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
              final long _tmpClazzEnrolmentLct;
              _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
              _tmpClazzEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
              final long _tmpClazzEnrolmentInviteUid;
              _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
              _tmpClazzEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
            } else {
              _tmpClazzEnrolment = null;
            }
            _item = new CoursePermissionAndEnrolment(_tmpCoursePermission,_tmpClazzEnrolment);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object userHasEnrolmentEditPermission(final long accountPersonUid,
      final long clazzEnrolmentUid, final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT CASE ? \n"
            + "                WHEN 0 THEN (SELECT EXISTS(\n"
            + "                         SELECT 1\n"
            + "                           FROM SystemPermission\n"
            + "                          WHERE ? != 0 \n"
            + "                            AND SystemPermission.spToPersonUid = ?\n"
            + "                            AND (SystemPermission.spPermissionsFlag & 2048) > 0\n"
            + "                            AND NOT SystemPermission.spIsDeleted))\n"
            + "                ELSE (\n"
            + "                  SELECT (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = (\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n"
            + "                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n"
            + "                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n"
            + "    )), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = (\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n"
            + "                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n"
            + "                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n"
            + "    )\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         \n"
            + "                         (\n"
            + "        CASE (\n"
            + "        SELECT ClazzEnrolment.clazzEnrolmentRole\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentUid = ?         \n"
            + "    )\n"
            + "             WHEN 1000 THEN 8\n"
            + "             ELSE 8\n"
            + "        END     \n"
            + "    )\n"
            + "                         \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     \n"
            + "                         (\n"
            + "        CASE (\n"
            + "        SELECT ClazzEnrolment.clazzEnrolmentRole\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentUid = ?         \n"
            + "    )\n"
            + "             WHEN 1000 THEN 8\n"
            + "             ELSE 8\n"
            + "        END     \n"
            + "    )\n"
            + "                         \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "     \n"
            + "                )\n"
            + "               END \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzEnrolmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzEnrolmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, clazzEnrolmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzEnrolmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzEnrolmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object personHasPermissionWithClazzEntities2(final long accountPersonUid,
      final long clazzUid,
      final Continuation<? super List<CoursePermissionAndEnrolment>> $completion) {
    final String _sql = "\n"
            + "       SELECT CoursePermission.*, ClazzEnrolment_ForAccountPerson.*\n"
            + "         FROM CoursePermission\n"
            + "              \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "        WHERE (? = 0 OR CoursePermission.cpClazzUid = ?)\n"
            + "          AND (CoursePermission.cpToPersonUid = ? \n"
            + "               OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CoursePermissionAndEnrolment>>() {
      @Override
      @NonNull
      public List<CoursePermissionAndEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpUid");
          final int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cpLastModified");
          final int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpClazzUid");
          final int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToEnrolmentRole");
          final int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToPersonUid");
          final int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToGroupUid");
          final int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "cpPermissionsFlag");
          final int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cpIsDeleted");
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentInviteUid");
          final List<CoursePermissionAndEnrolment> _result = new ArrayList<CoursePermissionAndEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CoursePermissionAndEnrolment _item;
            final CoursePermission _tmpCoursePermission;
            if (!(_cursor.isNull(_cursorIndexOfCpUid) && _cursor.isNull(_cursorIndexOfCpLastModified) && _cursor.isNull(_cursorIndexOfCpClazzUid) && _cursor.isNull(_cursorIndexOfCpToEnrolmentRole) && _cursor.isNull(_cursorIndexOfCpToPersonUid) && _cursor.isNull(_cursorIndexOfCpToGroupUid) && _cursor.isNull(_cursorIndexOfCpPermissionsFlag) && _cursor.isNull(_cursorIndexOfCpIsDeleted))) {
              final long _tmpCpUid;
              _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
              final long _tmpCpLastModified;
              _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
              final long _tmpCpClazzUid;
              _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
              final int _tmpCpToEnrolmentRole;
              _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
              final long _tmpCpToPersonUid;
              _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
              final long _tmpCpToGroupUid;
              _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
              final long _tmpCpPermissionsFlag;
              _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
              final boolean _tmpCpIsDeleted;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
              _tmpCpIsDeleted = _tmp != 0;
              _tmpCoursePermission = new CoursePermission(_tmpCpUid,_tmpCpLastModified,_tmpCpClazzUid,_tmpCpToEnrolmentRole,_tmpCpToPersonUid,_tmpCpToGroupUid,_tmpCpPermissionsFlag,_tmpCpIsDeleted);
            } else {
              _tmpCoursePermission = null;
            }
            final ClazzEnrolment _tmpClazzEnrolment;
            if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && _cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
              _tmpClazzEnrolment = new ClazzEnrolment();
              final long _tmpClazzEnrolmentUid;
              _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
              _tmpClazzEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
              final long _tmpClazzEnrolmentPersonUid;
              _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
              _tmpClazzEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
              final long _tmpClazzEnrolmentClazzUid;
              _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
              _tmpClazzEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
              final long _tmpClazzEnrolmentDateJoined;
              _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
              _tmpClazzEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
              final long _tmpClazzEnrolmentDateLeft;
              _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
              _tmpClazzEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
              final int _tmpClazzEnrolmentRole;
              _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
              _tmpClazzEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
              final float _tmpClazzEnrolmentAttendancePercentage;
              _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
              _tmpClazzEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
              final boolean _tmpClazzEnrolmentActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
              _tmpClazzEnrolmentActive = _tmp_1 != 0;
              _tmpClazzEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
              final long _tmpClazzEnrolmentLeavingReasonUid;
              _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
              _tmpClazzEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
              final int _tmpClazzEnrolmentOutcome;
              _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
              _tmpClazzEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
              final long _tmpClazzEnrolmentLocalChangeSeqNum;
              _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
              _tmpClazzEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
              final long _tmpClazzEnrolmentMasterChangeSeqNum;
              _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
              _tmpClazzEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
              final int _tmpClazzEnrolmentLastChangedBy;
              _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
              _tmpClazzEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
              final long _tmpClazzEnrolmentLct;
              _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
              _tmpClazzEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
              final long _tmpClazzEnrolmentInviteUid;
              _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
              _tmpClazzEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
            } else {
              _tmpClazzEnrolment = null;
            }
            _item = new CoursePermissionAndEnrolment(_tmpCoursePermission,_tmpClazzEnrolment);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Boolean> personHasPermissionWithClazzAsFlow2(final long accountPersonUid,
      final long clazzUid, final long permission) {
    final String _sql = "\n"
            + "        SELECT (? != 0 AND ? != 0)\n"
            + "          AND  (\n"
            + "         (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "    )            \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, permission);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz", "CoursePermission",
        "ClazzEnrolment", "SystemPermission"}, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<PermissionPair> personHasPermissionWithClazzPairAsFlow(final long accountPersonUid,
      final long clazzUid, final long firstPermission, final long secondPermission) {
    final String _sql = "\n"
            + "        SELECT (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS firstPermission,\n"
            + "               (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS secondPermission\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 20);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, secondPermission);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, secondPermission);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz", "CoursePermission",
        "ClazzEnrolment", "SystemPermission"}, new Callable<PermissionPair>() {
      @Override
      @NonNull
      public PermissionPair call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstPermission = 0;
          final int _cursorIndexOfSecondPermission = 1;
          final PermissionPair _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpFirstPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFirstPermission);
            _tmpFirstPermission = _tmp != 0;
            final boolean _tmpSecondPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSecondPermission);
            _tmpSecondPermission = _tmp_1 != 0;
            _result = new PermissionPair(_tmpFirstPermission,_tmpSecondPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object personHasPermissionWithClazzPairAsync(final long accountPersonUid,
      final long clazzUid, final long firstPermission, final long secondPermission,
      final Continuation<? super PermissionPair> $completion) {
    final String _sql = "\n"
            + "        SELECT (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS firstPermission,\n"
            + "               (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS secondPermission\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 20);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, secondPermission);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, secondPermission);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PermissionPair>() {
      @Override
      @NonNull
      public PermissionPair call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstPermission = 0;
          final int _cursorIndexOfSecondPermission = 1;
          final PermissionPair _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpFirstPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFirstPermission);
            _tmpFirstPermission = _tmp != 0;
            final boolean _tmpSecondPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSecondPermission);
            _tmpSecondPermission = _tmp_1 != 0;
            _result = new PermissionPair(_tmpFirstPermission,_tmpSecondPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<PermissionTriple> personHasPermissionWithClazzTripleAsFlow(
      final long accountPersonUid, final long clazzUid, final long firstPermission,
      final long secondPermission, final long thirdPermission) {
    final String _sql = "\n"
            + "        SELECT (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS firstPermission,\n"
            + "               (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS secondPermission,\n"
            + "               (    (? != 0 AND ? != 0)\n"
            + "                AND ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "               ) AS thirdPermission\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 30);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 11;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, secondPermission);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, secondPermission);
    _argIndex = 21;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 22;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 23;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 24;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 25;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 26;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 27;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 28;
    _statement.bindLong(_argIndex, thirdPermission);
    _argIndex = 29;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 30;
    _statement.bindLong(_argIndex, thirdPermission);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz", "CoursePermission",
        "ClazzEnrolment", "SystemPermission"}, new Callable<PermissionTriple>() {
      @Override
      @NonNull
      public PermissionTriple call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstPermission = 0;
          final int _cursorIndexOfSecondPermission = 1;
          final int _cursorIndexOfThirdPermission = 2;
          final PermissionTriple _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpFirstPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFirstPermission);
            _tmpFirstPermission = _tmp != 0;
            final boolean _tmpSecondPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSecondPermission);
            _tmpSecondPermission = _tmp_1 != 0;
            final boolean _tmpThirdPermission;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfThirdPermission);
            _tmpThirdPermission = _tmp_2 != 0;
            _result = new PermissionTriple(_tmpFirstPermission,_tmpSecondPermission,_tmpThirdPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object personHasPermissionWithClazzAsync2(final long accountPersonUid, final long clazzUid,
      final long permission, final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT (? != 0 AND ? != 0)\n"
            + "          AND  (\n"
            + "         (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "    )            \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, permission);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findApplicableCoursePermissionEntitiesForAccountPerson(final long accountPersonUid,
      final Continuation<? super List<CoursePermission>> $completion) {
    final String _sql = "\n"
            + "        /* Get CoursePermissions given to the active user based on their enrolment role*/\n"
            + "        SELECT CoursePermission.*\n"
            + "          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n"
            + "               JOIN CoursePermission \n"
            + "                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n"
            + "                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n"
            + "         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n"
            + "         UNION\n"
            + "        /* Get ClazzUids where the active user can view members based a grant directly to them */\n"
            + "        SELECT CoursePermission.*\n"
            + "          FROM CoursePermission\n"
            + "         WHERE CoursePermission.cpToPersonUid  = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CoursePermission>>() {
      @Override
      @NonNull
      public List<CoursePermission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpUid");
          final int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cpLastModified");
          final int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpClazzUid");
          final int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToEnrolmentRole");
          final int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToPersonUid");
          final int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cpToGroupUid");
          final int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "cpPermissionsFlag");
          final int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cpIsDeleted");
          final List<CoursePermission> _result = new ArrayList<CoursePermission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CoursePermission _item;
            final long _tmpCpUid;
            _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
            final long _tmpCpLastModified;
            _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
            final long _tmpCpClazzUid;
            _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
            final int _tmpCpToEnrolmentRole;
            _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
            final long _tmpCpToPersonUid;
            _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
            final long _tmpCpToGroupUid;
            _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
            final long _tmpCpPermissionsFlag;
            _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
            final boolean _tmpCpIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
            _tmpCpIsDeleted = _tmp != 0;
            _item = new CoursePermission(_tmpCpUid,_tmpCpLastModified,_tmpCpClazzUid,_tmpCpToEnrolmentRole,_tmpCpToPersonUid,_tmpCpToGroupUid,_tmpCpPermissionsFlag,_tmpCpIsDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<AssignmentPermissionAndActiveUserSubmitterUid> userPermissionsForAssignmentSubmitterUid(
      final long accountPersonUid, final long assignmentUid, final long clazzUid,
      final long submitterUid) {
    final String _sql = "\n"
            + "        WITH \n"
            + "        AccountSubmitterUid(accountSubmitterUid) AS \n"
            + "        (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "    ,\n"
            + "             CanMarkSubmitter(canMark) AS\n"
            + "             (SELECT CASE (SELECT ClazzAssignment.caMarkingType\n"
            + "                             FROM ClazzAssignment\n"
            + "                            WHERE ClazzAssignment.caUid = ?)\n"
            + "                           WHEN 2 THEN \n"
            + "                                EXISTS(SELECT 1\n"
            + "                                         FROM PeerReviewerAllocation\n"
            + "                                        WHERE PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n"
            + "                                          AND PeerReviewerAllocation.praMarkerSubmitterUid =\n"
            + "                                              (SELECT AccountSubmitterUid.accountSubmitterUid\n"
            + "                                                 FROM AccountSubmitterUid))\n"
            + "                           ELSE ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         256\n"
            + "                                 \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     256\n"
            + "                                 \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                          END)\n"
            + "\n"
            + "             \n"
            + "                    /* Can edit */\n"
            + "             SELECT (     (? != 0 AND ? != 0 AND ? != 0 AND ? != 0)\n"
            + "                      AND (SELECT CanMarkSubmitter.canMark \n"
            + "                            FROM CanMarkSubmitter)) AS canMark,\n"
            + "                    /* can view */   \n"
            + "                    (     (? != 0 AND ? != 0 AND ? != 0 AND ? != 0)\n"
            + "                      AND (     (SELECT CanMarkSubmitter.canMark\n"
            + "                                   FROM CanMarkSubmitter)\n"
            + "                             OR (SELECT ? = \n"
            + "                                  (SELECT AccountSubmitterUid.accountSubmitterUid\n"
            + "                                     FROM AccountSubmitterUid))\n"
            + "                             OR ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                                 \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                                 \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ))               \n"
            + "                    ) AS canView,\n"
            + "                    ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         4\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     4\n"
            + "                     \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "                    ) AS canModerate,\n"
            + "                    (SELECT accountSubmitterUid\n"
            + "                       FROM AccountSubmitterUid) AS activeUserSubmitterUid\n"
            + "             \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 39);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 22;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 23;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 24;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 25;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 26;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 27;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 28;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 29;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 30;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 31;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 32;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 33;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 34;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 35;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 36;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 37;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 38;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 39;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzAssignment", "ClazzEnrolment",
        "CourseGroupMember", "PeerReviewerAllocation", "Clazz", "CoursePermission",
        "SystemPermission"}, new Callable<AssignmentPermissionAndActiveUserSubmitterUid>() {
      @Override
      @NonNull
      public AssignmentPermissionAndActiveUserSubmitterUid call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCanMark = 0;
          final int _cursorIndexOfCanView = 1;
          final int _cursorIndexOfCanModerate = 2;
          final int _cursorIndexOfActiveUserSubmitterUid = 3;
          final AssignmentPermissionAndActiveUserSubmitterUid _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpCanMark;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCanMark);
            _tmpCanMark = _tmp != 0;
            final boolean _tmpCanView;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCanView);
            _tmpCanView = _tmp_1 != 0;
            final boolean _tmpCanModerate;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCanModerate);
            _tmpCanModerate = _tmp_2 != 0;
            final long _tmpActiveUserSubmitterUid;
            _tmpActiveUserSubmitterUid = _cursor.getLong(_cursorIndexOfActiveUserSubmitterUid);
            _result = new AssignmentPermissionAndActiveUserSubmitterUid(_tmpCanMark,_tmpCanView,_tmpCanModerate,_tmpActiveUserSubmitterUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
