package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.PersonAndListDisplayDetails;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.composites.PersonNames;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonAndDisplayDetail;
import com.ustadmobile.lib.db.entities.PersonAuth;
import com.ustadmobile.lib.db.entities.PersonGroup;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.PersonUidAndPasswordHash;
import com.ustadmobile.lib.db.entities.TransferJobItem;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonDao_Impl extends PersonDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Person> __insertionAdapterOfPerson;

  private final EntityInsertionAdapter<Person> __insertionAdapterOfPerson_1;

  private final EntityInsertionAdapter<PersonAuth> __insertionAdapterOfPersonAuth;

  private final EntityInsertionAdapter<PersonGroup> __insertionAdapterOfPersonGroup;

  private final EntityInsertionAdapter<PersonGroupMember> __insertionAdapterOfPersonGroupMember;

  private final EntityDeletionOrUpdateAdapter<Person> __updateAdapterOfPerson;

  private final SharedSQLiteStatement __preparedStmtOfUpdateUsername;

  public PersonDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPerson = new EntityInsertionAdapter<Person>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Person` (`personUid`,`username`,`firstNames`,`lastName`,`emailAddr`,`phoneNum`,`gender`,`active`,`isPersonalAccount`,`dateOfBirth`,`personAddress`,`personOrgId`,`personGroupUid`,`personLct`,`personCountry`,`personType`,`personMasterChangeSeqNum`,`personLocalChangeSeqNum`,`personLastChangedBy`,`admin`,`personNotes`,`fatherName`,`fatherNumber`,`motherName`,`motherNum`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Person entity) {
        statement.bindLong(1, entity.getPersonUid());
        if (entity.getUsername() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getUsername());
        }
        if (entity.getFirstNames() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getFirstNames());
        }
        if (entity.getLastName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getLastName());
        }
        if (entity.getEmailAddr() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getEmailAddr());
        }
        if (entity.getPhoneNum() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPhoneNum());
        }
        statement.bindLong(7, entity.getGender());
        final int _tmp = entity.getActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
        final int _tmp_1 = entity.isPersonalAccount() ? 1 : 0;
        statement.bindLong(9, _tmp_1);
        statement.bindLong(10, entity.getDateOfBirth());
        if (entity.getPersonAddress() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getPersonAddress());
        }
        if (entity.getPersonOrgId() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getPersonOrgId());
        }
        statement.bindLong(13, entity.getPersonGroupUid());
        statement.bindLong(14, entity.getPersonLct());
        if (entity.getPersonCountry() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getPersonCountry());
        }
        statement.bindLong(16, entity.getPersonType());
        statement.bindLong(17, entity.getPersonMasterChangeSeqNum());
        statement.bindLong(18, entity.getPersonLocalChangeSeqNum());
        statement.bindLong(19, entity.getPersonLastChangedBy());
        final int _tmp_2 = entity.getAdmin() ? 1 : 0;
        statement.bindLong(20, _tmp_2);
        if (entity.getPersonNotes() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getPersonNotes());
        }
        if (entity.getFatherName() == null) {
          statement.bindNull(22);
        } else {
          statement.bindString(22, entity.getFatherName());
        }
        if (entity.getFatherNumber() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getFatherNumber());
        }
        if (entity.getMotherName() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getMotherName());
        }
        if (entity.getMotherNum() == null) {
          statement.bindNull(25);
        } else {
          statement.bindString(25, entity.getMotherNum());
        }
      }
    };
    this.__insertionAdapterOfPerson_1 = new EntityInsertionAdapter<Person>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `Person` (`personUid`,`username`,`firstNames`,`lastName`,`emailAddr`,`phoneNum`,`gender`,`active`,`isPersonalAccount`,`dateOfBirth`,`personAddress`,`personOrgId`,`personGroupUid`,`personLct`,`personCountry`,`personType`,`personMasterChangeSeqNum`,`personLocalChangeSeqNum`,`personLastChangedBy`,`admin`,`personNotes`,`fatherName`,`fatherNumber`,`motherName`,`motherNum`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Person entity) {
        statement.bindLong(1, entity.getPersonUid());
        if (entity.getUsername() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getUsername());
        }
        if (entity.getFirstNames() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getFirstNames());
        }
        if (entity.getLastName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getLastName());
        }
        if (entity.getEmailAddr() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getEmailAddr());
        }
        if (entity.getPhoneNum() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPhoneNum());
        }
        statement.bindLong(7, entity.getGender());
        final int _tmp = entity.getActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
        final int _tmp_1 = entity.isPersonalAccount() ? 1 : 0;
        statement.bindLong(9, _tmp_1);
        statement.bindLong(10, entity.getDateOfBirth());
        if (entity.getPersonAddress() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getPersonAddress());
        }
        if (entity.getPersonOrgId() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getPersonOrgId());
        }
        statement.bindLong(13, entity.getPersonGroupUid());
        statement.bindLong(14, entity.getPersonLct());
        if (entity.getPersonCountry() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getPersonCountry());
        }
        statement.bindLong(16, entity.getPersonType());
        statement.bindLong(17, entity.getPersonMasterChangeSeqNum());
        statement.bindLong(18, entity.getPersonLocalChangeSeqNum());
        statement.bindLong(19, entity.getPersonLastChangedBy());
        final int _tmp_2 = entity.getAdmin() ? 1 : 0;
        statement.bindLong(20, _tmp_2);
        if (entity.getPersonNotes() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getPersonNotes());
        }
        if (entity.getFatherName() == null) {
          statement.bindNull(22);
        } else {
          statement.bindString(22, entity.getFatherName());
        }
        if (entity.getFatherNumber() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getFatherNumber());
        }
        if (entity.getMotherName() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getMotherName());
        }
        if (entity.getMotherNum() == null) {
          statement.bindNull(25);
        } else {
          statement.bindString(25, entity.getMotherNum());
        }
      }
    };
    this.__insertionAdapterOfPersonAuth = new EntityInsertionAdapter<PersonAuth>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonAuth` (`personAuthUid`,`passwordHash`,`personAuthStatus`) VALUES (nullif(?, 0),?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonAuth entity) {
        statement.bindLong(1, entity.getPersonAuthUid());
        if (entity.getPasswordHash() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPasswordHash());
        }
        statement.bindLong(3, entity.getPersonAuthStatus());
      }
    };
    this.__insertionAdapterOfPersonGroup = new EntityInsertionAdapter<PersonGroup>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroup` (`groupUid`,`groupMasterCsn`,`groupLocalCsn`,`groupLastChangedBy`,`groupLct`,`groupName`,`groupActive`,`personGroupFlag`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonGroup entity) {
        statement.bindLong(1, entity.getGroupUid());
        statement.bindLong(2, entity.getGroupMasterCsn());
        statement.bindLong(3, entity.getGroupLocalCsn());
        statement.bindLong(4, entity.getGroupLastChangedBy());
        statement.bindLong(5, entity.getGroupLct());
        if (entity.getGroupName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getGroupName());
        }
        final int _tmp = entity.getGroupActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getPersonGroupFlag());
      }
    };
    this.__insertionAdapterOfPersonGroupMember = new EntityInsertionAdapter<PersonGroupMember>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroupMember` (`groupMemberUid`,`groupMemberActive`,`groupMemberPersonUid`,`groupMemberGroupUid`,`groupMemberMasterCsn`,`groupMemberLocalCsn`,`groupMemberLastChangedBy`,`groupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonGroupMember entity) {
        statement.bindLong(1, entity.getGroupMemberUid());
        final int _tmp = entity.getGroupMemberActive() ? 1 : 0;
        statement.bindLong(2, _tmp);
        statement.bindLong(3, entity.getGroupMemberPersonUid());
        statement.bindLong(4, entity.getGroupMemberGroupUid());
        statement.bindLong(5, entity.getGroupMemberMasterCsn());
        statement.bindLong(6, entity.getGroupMemberLocalCsn());
        statement.bindLong(7, entity.getGroupMemberLastChangedBy());
        statement.bindLong(8, entity.getGroupMemberLct());
      }
    };
    this.__updateAdapterOfPerson = new EntityDeletionOrUpdateAdapter<Person>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Person` SET `personUid` = ?,`username` = ?,`firstNames` = ?,`lastName` = ?,`emailAddr` = ?,`phoneNum` = ?,`gender` = ?,`active` = ?,`isPersonalAccount` = ?,`dateOfBirth` = ?,`personAddress` = ?,`personOrgId` = ?,`personGroupUid` = ?,`personLct` = ?,`personCountry` = ?,`personType` = ?,`personMasterChangeSeqNum` = ?,`personLocalChangeSeqNum` = ?,`personLastChangedBy` = ?,`admin` = ?,`personNotes` = ?,`fatherName` = ?,`fatherNumber` = ?,`motherName` = ?,`motherNum` = ? WHERE `personUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Person entity) {
        statement.bindLong(1, entity.getPersonUid());
        if (entity.getUsername() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getUsername());
        }
        if (entity.getFirstNames() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getFirstNames());
        }
        if (entity.getLastName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getLastName());
        }
        if (entity.getEmailAddr() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getEmailAddr());
        }
        if (entity.getPhoneNum() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPhoneNum());
        }
        statement.bindLong(7, entity.getGender());
        final int _tmp = entity.getActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
        final int _tmp_1 = entity.isPersonalAccount() ? 1 : 0;
        statement.bindLong(9, _tmp_1);
        statement.bindLong(10, entity.getDateOfBirth());
        if (entity.getPersonAddress() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getPersonAddress());
        }
        if (entity.getPersonOrgId() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getPersonOrgId());
        }
        statement.bindLong(13, entity.getPersonGroupUid());
        statement.bindLong(14, entity.getPersonLct());
        if (entity.getPersonCountry() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getPersonCountry());
        }
        statement.bindLong(16, entity.getPersonType());
        statement.bindLong(17, entity.getPersonMasterChangeSeqNum());
        statement.bindLong(18, entity.getPersonLocalChangeSeqNum());
        statement.bindLong(19, entity.getPersonLastChangedBy());
        final int _tmp_2 = entity.getAdmin() ? 1 : 0;
        statement.bindLong(20, _tmp_2);
        if (entity.getPersonNotes() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getPersonNotes());
        }
        if (entity.getFatherName() == null) {
          statement.bindNull(22);
        } else {
          statement.bindString(22, entity.getFatherName());
        }
        if (entity.getFatherNumber() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getFatherNumber());
        }
        if (entity.getMotherName() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getMotherName());
        }
        if (entity.getMotherNum() == null) {
          statement.bindNull(25);
        } else {
          statement.bindString(25, entity.getMotherNum());
        }
        statement.bindLong(26, entity.getPersonUid());
      }
    };
    this.__preparedStmtOfUpdateUsername = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Person\n"
                + "           SET username = ?,\n"
                + "               personLct = ?\n"
                + "         WHERE Person.personUid = ?  \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Person entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfPerson.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Person entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPerson.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Person> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPerson.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<Person> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPerson.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insertOrReplace(final Person person, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPerson_1.insert(person);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertPersonAuth(final PersonAuth personAuth) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonAuth.insert(personAuth);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertPersonGroup(final PersonGroup personGroup,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonGroup.insertAndReturnId(personGroup);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insertPersonGroupMember(final PersonGroupMember personGroupMember,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonGroupMember.insertAndReturnId(personGroupMember);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final Person entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPerson.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Person entity, final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPerson.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateUsername(final long personUid, final String username, final long currentTime,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateUsername.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, username);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, currentTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateUsername.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object countUsername(final String username,
      final Continuation<? super Integer> $completion) {
    final String _sql = "SELECT COUNT(*) FROM Person where Person.username = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, username);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findUidAndPasswordHashAsync(final String username,
      final Continuation<? super PersonUidAndPasswordHash> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.personUid, Person.firstNames, Person.lastName, \n"
            + "               PersonAuth.passwordHash\n"
            + "          FROM Person\n"
            + "               JOIN PersonAuth\n"
            + "                    ON Person.personUid = PersonAuth.personAuthUid\n"
            + "         WHERE Person.username = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, username);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonUidAndPasswordHash>() {
      @Override
      @Nullable
      public PersonUidAndPasswordHash call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = 0;
          final int _cursorIndexOfFirstNames = 1;
          final int _cursorIndexOfLastName = 2;
          final int _cursorIndexOfPasswordHash = 3;
          final PersonUidAndPasswordHash _result;
          if (_cursor.moveToFirst()) {
            _result = new PersonUidAndPasswordHash();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpPasswordHash;
            if (_cursor.isNull(_cursorIndexOfPasswordHash)) {
              _tmpPasswordHash = null;
            } else {
              _tmpPasswordHash = _cursor.getString(_cursorIndexOfPasswordHash);
            }
            _result.setPasswordHash(_tmpPasswordHash);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUsernameAndPasswordHash2(final String username, final String passwordHash,
      final Continuation<? super Person> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*\n"
            + "          FROM Person\n"
            + "               JOIN PersonAuth2\n"
            + "                    ON Person.personUid = PersonAuth2.pauthUid\n"
            + "         WHERE Person.username = ? \n"
            + "               AND PersonAuth2.pauthAuth = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindString(_argIndex, username);
    _argIndex = 2;
    _statement.bindString(_argIndex, passwordHash);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      @Nullable
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final Person _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Person findByUsername(final String username) {
    final String _sql = "SELECT Person.* FROM PERSON Where Person.username = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final Person _result;
      if (_cursor.moveToFirst()) {
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        final boolean _tmpIsPersonalAccount;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
        _tmpIsPersonalAccount = _tmp_1 != 0;
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        final boolean _tmpAdmin;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_2 != 0;
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUsernameAsync(final String username,
      final Continuation<? super Person> $completion) {
    final String _sql = "SELECT Person.* FROM PERSON Where Person.username = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, username);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      @Nullable
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final Person _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findSystemAccount(final long nodeId,
      final Continuation<? super Person> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*\n"
            + "          FROM Person\n"
            + "         WHERE Person.dateOfBirth = ?\n"
            + "           AND Person.personType = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, nodeId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      @Nullable
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final Person _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Person findByUid(final long uid) {
    final String _sql = "SELECT * FROM PERSON WHERE Person.personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final Person _result;
      if (_cursor.moveToFirst()) {
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        final boolean _tmpIsPersonalAccount;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
        _tmpIsPersonalAccount = _tmp_1 != 0;
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        final boolean _tmpAdmin;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_2 != 0;
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidWithPicture(final long accountPersonUid,
      final Continuation<? super PersonAndPicture> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                    ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid = ?           \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonAndPicture>() {
      @Override
      @Nullable
      public PersonAndPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonAndPicture _result;
          if (_cursor.moveToFirst()) {
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _result = new PersonAndPicture(_tmpPerson,_tmpPicture);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<PersonAndPicture> findByUidWithPictureAsFlow(final long uid) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                    ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid = ?           \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person",
        "PersonPicture"}, new Callable<PersonAndPicture>() {
      @Override
      @Nullable
      public PersonAndPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonAndPicture _result;
          if (_cursor.moveToFirst()) {
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _result = new PersonAndPicture(_tmpPerson,_tmpPicture);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<Person> findByUidLive(final long uid) {
    final String _sql = "SELECT * From Person WHERE personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person"}, new Callable<Person>() {
      @Override
      @Nullable
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final Person _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super Person> $completion) {
    final String _sql = "SELECT * FROM Person WHERE personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      @Nullable
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final Person _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Person> findByUidAsFlow(final long uid) {
    final String _sql = "SELECT * FROM Person WHERE personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person"}, new Callable<Person>() {
      @Override
      @Nullable
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final Person _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<PersonAndListDisplayDetails> findPersonsWithPermissionAsList(final long timestamp,
      final long excludeClazz, final List<Long> excludeSelected, final long accountPersonUid,
      final int sortOrder, final String searchText) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("         WITH CanViewPersonUidsViaCoursePermission(personUid) AS");
    _stringBuilder.append("\n");
    _stringBuilder.append("              /* Select personUids that can be viewed based on CoursePermission given the active user ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 for their enrolments ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              */");
    _stringBuilder.append("\n");
    _stringBuilder.append("              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      JOIN CoursePermission ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive");
    _stringBuilder.append("\n");
    _stringBuilder.append("              ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               UNION");
    _stringBuilder.append("\n");
    _stringBuilder.append("               /* Select personUids that can be viewed based on CoursePermission for the active user");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  where the CoursePermission is granted directly to them");
    _stringBuilder.append("\n");
    _stringBuilder.append("                */   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM CoursePermission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND CoursePermission.cpToPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("         SELECT Person.*, PersonPicture.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("           FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("                LEFT JOIN PersonPicture");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     ON PersonPicture.personPictureUid = Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("          WHERE /* Begin permission check */ ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                (         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      (");
    _stringBuilder.append("\n");
    _stringBuilder.append("        EXISTS(SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM SystemPermission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       8192");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    OR (Person.personUid IN ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                               (SELECT CanViewPersonUidsViaCoursePermission.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                  FROM CanViewPersonUidsViaCoursePermission))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    OR (Person.personUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("                )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                /* End permission check */");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR ");
    _stringBuilder.append("?");
    _stringBuilder.append(" NOT IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT clazzEnrolmentClazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      WHERE clazzEnrolmentPersonUid = Person.personUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ClazzEnrolment.clazzEnrolmentDateLeft");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND Person.personType = 0                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (Person.personUid NOT IN (");
    final int _inputSize = excludeSelected.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = '%' ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               OR Person.firstNames || ' ' || Person.lastName LIKE ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("      GROUP BY Person.personUid, PersonPicture.personPictureUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 1 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 3 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 2 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 4 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 14 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 9;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 10;
    _statement.bindLong(_argIndex, timestamp);
    _argIndex = 11;
    for (long _item : excludeSelected) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 11 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 12 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 13 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 14 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
      final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
      final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
      final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
      final List<PersonAndListDisplayDetails> _result = new ArrayList<PersonAndListDisplayDetails>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final PersonAndListDisplayDetails _item_1;
        final Person _tmpPerson;
        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
          final long _tmpPersonUid;
          _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
          final String _tmpUsername;
          if (_cursor.isNull(_cursorIndexOfUsername)) {
            _tmpUsername = null;
          } else {
            _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
          }
          final String _tmpFirstNames;
          if (_cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
          }
          final String _tmpLastName;
          if (_cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
          }
          final String _tmpEmailAddr;
          if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
            _tmpEmailAddr = null;
          } else {
            _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
          }
          final String _tmpPhoneNum;
          if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
            _tmpPhoneNum = null;
          } else {
            _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
          }
          final int _tmpGender;
          _tmpGender = _cursor.getInt(_cursorIndexOfGender);
          final boolean _tmpActive;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfActive);
          _tmpActive = _tmp != 0;
          final boolean _tmpIsPersonalAccount;
          final int _tmp_1;
          _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
          _tmpIsPersonalAccount = _tmp_1 != 0;
          final long _tmpDateOfBirth;
          _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
          final String _tmpPersonAddress;
          if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
            _tmpPersonAddress = null;
          } else {
            _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
          }
          final String _tmpPersonOrgId;
          if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
            _tmpPersonOrgId = null;
          } else {
            _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
          }
          final long _tmpPersonGroupUid;
          _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
          final long _tmpPersonLct;
          _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
          final String _tmpPersonCountry;
          if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
            _tmpPersonCountry = null;
          } else {
            _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
          }
          final int _tmpPersonType;
          _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
          final long _tmpPersonMasterChangeSeqNum;
          _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
          final long _tmpPersonLocalChangeSeqNum;
          _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
          final int _tmpPersonLastChangedBy;
          _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
          final boolean _tmpAdmin;
          final int _tmp_2;
          _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
          _tmpAdmin = _tmp_2 != 0;
          final String _tmpPersonNotes;
          if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
            _tmpPersonNotes = null;
          } else {
            _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
          }
          final String _tmpFatherName;
          if (_cursor.isNull(_cursorIndexOfFatherName)) {
            _tmpFatherName = null;
          } else {
            _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
          }
          final String _tmpFatherNumber;
          if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
            _tmpFatherNumber = null;
          } else {
            _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
          }
          final String _tmpMotherName;
          if (_cursor.isNull(_cursorIndexOfMotherName)) {
            _tmpMotherName = null;
          } else {
            _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
          }
          final String _tmpMotherNum;
          if (_cursor.isNull(_cursorIndexOfMotherNum)) {
            _tmpMotherNum = null;
          } else {
            _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
          }
          _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
        } else {
          _tmpPerson = null;
        }
        final PersonPicture _tmpPicture;
        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
          final long _tmpPersonPictureUid;
          _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
          final long _tmpPersonPictureLct;
          _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
          final String _tmpPersonPictureUri;
          if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
            _tmpPersonPictureUri = null;
          } else {
            _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
          }
          final String _tmpPersonPictureThumbnailUri;
          if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
            _tmpPersonPictureThumbnailUri = null;
          } else {
            _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
          }
          final int _tmpFileSize;
          _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
          final boolean _tmpPersonPictureActive;
          final int _tmp_3;
          _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
          _tmpPersonPictureActive = _tmp_3 != 0;
          _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
        } else {
          _tmpPicture = null;
        }
        _item_1 = new PersonAndListDisplayDetails(_tmpPerson,_tmpPicture);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public PagingSource<Integer, PersonAndListDisplayDetails> findPersonsWithPermissionAsPagingSource(
      final long timestamp, final long excludeClazz, final List<Long> excludeSelected,
      final long accountPersonUid, final int sortOrder, final String searchText) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("         WITH CanViewPersonUidsViaCoursePermission(personUid) AS");
    _stringBuilder.append("\n");
    _stringBuilder.append("              /* Select personUids that can be viewed based on CoursePermission given the active user ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 for their enrolments ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              */");
    _stringBuilder.append("\n");
    _stringBuilder.append("              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      JOIN CoursePermission ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive");
    _stringBuilder.append("\n");
    _stringBuilder.append("              ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               UNION");
    _stringBuilder.append("\n");
    _stringBuilder.append("               /* Select personUids that can be viewed based on CoursePermission for the active user");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  where the CoursePermission is granted directly to them");
    _stringBuilder.append("\n");
    _stringBuilder.append("                */   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM CoursePermission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND CoursePermission.cpToPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("         SELECT Person.*, PersonPicture.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("           FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("                LEFT JOIN PersonPicture");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     ON PersonPicture.personPictureUid = Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("          WHERE /* Begin permission check */ ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                (         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      (");
    _stringBuilder.append("\n");
    _stringBuilder.append("        EXISTS(SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM SystemPermission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       8192");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    OR (Person.personUid IN ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                               (SELECT CanViewPersonUidsViaCoursePermission.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                  FROM CanViewPersonUidsViaCoursePermission))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    OR (Person.personUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("                )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                /* End permission check */");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR ");
    _stringBuilder.append("?");
    _stringBuilder.append(" NOT IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT clazzEnrolmentClazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      WHERE clazzEnrolmentPersonUid = Person.personUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ClazzEnrolment.clazzEnrolmentDateLeft");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND Person.personType = 0                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (Person.personUid NOT IN (");
    final int _inputSize = excludeSelected.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = '%' ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               OR Person.firstNames || ' ' || Person.lastName LIKE ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("      GROUP BY Person.personUid, PersonPicture.personPictureUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 1 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 3 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 2 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 4 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 14 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 9;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 10;
    _statement.bindLong(_argIndex, timestamp);
    _argIndex = 11;
    for (long _item : excludeSelected) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 11 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 12 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 13 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 14 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<PersonAndListDisplayDetails>(_statement, __db, "ClazzEnrolment", "CoursePermission", "Person", "PersonPicture", "SystemPermission") {
      @Override
      @NonNull
      protected List<PersonAndListDisplayDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(cursor, "isPersonalAccount");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUid");
        final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureLct");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureThumbnailUri");
        final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
        final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureActive");
        final List<PersonAndListDisplayDetails> _result = new ArrayList<PersonAndListDisplayDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final PersonAndListDisplayDetails _item_1;
          final Person _tmpPerson;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpPerson = null;
          }
          final PersonPicture _tmpPicture;
          if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp_3 != 0;
            _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _tmpPicture = null;
          }
          _item_1 = new PersonAndListDisplayDetails(_tmpPerson,_tmpPicture);
          _result.add(_item_1);
        }
        return _result;
      }
    };
  }

  @Override
  public Flow<PersonAndDisplayDetail> findByUidWithDisplayDetailsLive(final long personUid,
      final long activeUserPersonUid) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonParentJoin.* \n"
            + "          FROM Person\n"
            + "     LEFT JOIN PersonParentJoin on ppjUid = (\n"
            + "                SELECT ppjUid \n"
            + "                  FROM PersonParentJoin\n"
            + "                 WHERE ppjMinorPersonUid = ? \n"
            + "                       AND ppjParentPersonUid = ? \n"
            + "                LIMIT 1)     \n"
            + "         WHERE Person.personUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, activeUserPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person",
        "PersonParentJoin"}, new Callable<PersonAndDisplayDetail>() {
      @Override
      @Nullable
      public PersonAndDisplayDetail call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final PersonAndDisplayDetail _result;
          if (_cursor.moveToFirst()) {
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonParentJoin _tmpParentJoin;
            if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
              final long _tmpPpjUid;
              _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
              final long _tmpPpjPcsn;
              _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
              final long _tmpPpjLcsn;
              _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
              final int _tmpPpjLcb;
              _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
              final long _tmpPpjLct;
              _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
              final long _tmpPpjParentPersonUid;
              _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
              final long _tmpPpjMinorPersonUid;
              _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
              final int _tmpPpjRelationship;
              _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
              final String _tmpPpjEmail;
              if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
                _tmpPpjEmail = null;
              } else {
                _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
              }
              final String _tmpPpjPhone;
              if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
                _tmpPpjPhone = null;
              } else {
                _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
              }
              final boolean _tmpPpjInactive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPpjInactive);
              _tmpPpjInactive = _tmp_3 != 0;
              final int _tmpPpjStatus;
              _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
              final long _tmpPpjApprovalTiemstamp;
              _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
              final String _tmpPpjApprovalIpAddr;
              if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
                _tmpPpjApprovalIpAddr = null;
              } else {
                _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
              }
              _tmpParentJoin = new PersonParentJoin(_tmpPpjUid,_tmpPpjPcsn,_tmpPpjLcsn,_tmpPpjLcb,_tmpPpjLct,_tmpPpjParentPersonUid,_tmpPpjMinorPersonUid,_tmpPpjRelationship,_tmpPpjEmail,_tmpPpjPhone,_tmpPpjInactive,_tmpPpjStatus,_tmpPpjApprovalTiemstamp,_tmpPpjApprovalIpAddr);
            } else {
              _tmpParentJoin = null;
            }
            _result = new PersonAndDisplayDetail(_tmpPerson,_tmpParentJoin,null,null);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<PersonAndDisplayDetail> findByUidWithDisplayDetailsFlow(final long personUid,
      final long accountPersonUid) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonParentJoin.* , PersonPicture.*, TransferJobItem.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonParentJoin \n"
            + "                    ON ppjUid =\n"
            + "                    (SELECT ppjUid \n"
            + "                       FROM PersonParentJoin\n"
            + "                      WHERE ppjMinorPersonUid = ? \n"
            + "                        AND ppjParentPersonUid = ? \n"
            + "                      LIMIT 1)  \n"
            + "               LEFT JOIN PersonPicture\n"
            + "                    ON PersonPicture.personPictureUid = ?\n"
            + "               LEFT JOIN TransferJobItem\n"
            + "                    ON TransferJobItem.tjiUid = \n"
            + "                       (SELECT TransferJobItem.tjiUid\n"
            + "                          FROM TransferJobItem\n"
            + "                         WHERE TransferJobItem.tjiEntityUid = ?\n"
            + "                           AND TransferJobItem.tjiTableId = 50\n"
            + "                           AND TransferJobItem.tjiEntityEtag = PersonPicture.personPictureLct\n"
            + "                           AND TransferJobItem.tjiStatus != 21\n"
            + "                         LIMIT 1)\n"
            + "                          \n"
            + "         WHERE Person.personUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, personUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person", "PersonParentJoin",
        "PersonPicture", "TransferJobItem"}, new Callable<PersonAndDisplayDetail>() {
      @Override
      @Nullable
      public PersonAndDisplayDetail call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final PersonAndDisplayDetail _result;
          if (_cursor.moveToFirst()) {
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonParentJoin _tmpParentJoin;
            if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
              final long _tmpPpjUid;
              _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
              final long _tmpPpjPcsn;
              _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
              final long _tmpPpjLcsn;
              _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
              final int _tmpPpjLcb;
              _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
              final long _tmpPpjLct;
              _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
              final long _tmpPpjParentPersonUid;
              _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
              final long _tmpPpjMinorPersonUid;
              _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
              final int _tmpPpjRelationship;
              _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
              final String _tmpPpjEmail;
              if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
                _tmpPpjEmail = null;
              } else {
                _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
              }
              final String _tmpPpjPhone;
              if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
                _tmpPpjPhone = null;
              } else {
                _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
              }
              final boolean _tmpPpjInactive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPpjInactive);
              _tmpPpjInactive = _tmp_3 != 0;
              final int _tmpPpjStatus;
              _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
              final long _tmpPpjApprovalTiemstamp;
              _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
              final String _tmpPpjApprovalIpAddr;
              if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
                _tmpPpjApprovalIpAddr = null;
              } else {
                _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
              }
              _tmpParentJoin = new PersonParentJoin(_tmpPpjUid,_tmpPpjPcsn,_tmpPpjLcsn,_tmpPpjLcb,_tmpPpjLct,_tmpPpjParentPersonUid,_tmpPpjMinorPersonUid,_tmpPpjRelationship,_tmpPpjEmail,_tmpPpjPhone,_tmpPpjInactive,_tmpPpjStatus,_tmpPpjApprovalTiemstamp,_tmpPpjApprovalIpAddr);
            } else {
              _tmpParentJoin = null;
            }
            final PersonPicture _tmpPersonPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_4 != 0;
              _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPersonPicture = null;
            }
            final TransferJobItem _tmpPersonPictureTransferJobItem;
            if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
              final int _tmpTjiUid;
              _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
              final int _tmpTjiTjUid;
              _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
              final long _tmpTjTotalSize;
              _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
              final long _tmpTjTransferred;
              _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
              final int _tmpTjAttemptCount;
              _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
              final String _tmpTjiSrc;
              if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
                _tmpTjiSrc = null;
              } else {
                _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
              }
              final String _tmpTjiDest;
              if (_cursor.isNull(_cursorIndexOfTjiDest)) {
                _tmpTjiDest = null;
              } else {
                _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
              }
              final int _tmpTjiType;
              _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
              final int _tmpTjiStatus;
              _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
              final int _tmpTjiTableId;
              _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
              final long _tmpTjiEntityUid;
              _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
              final long _tmpTjiEntityEtag;
              _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
              final long _tmpTjiLockIdToRelease;
              _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
              final String _tmpTjiPartialTmpFile;
              if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
                _tmpTjiPartialTmpFile = null;
              } else {
                _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
              }
              _tmpPersonPictureTransferJobItem = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            } else {
              _tmpPersonPictureTransferJobItem = null;
            }
            _result = new PersonAndDisplayDetail(_tmpPerson,_tmpParentJoin,_tmpPersonPicture,_tmpPersonPictureTransferJobItem);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Person> getAllPerson() {
    final String _sql = "SELECT * FROM Person";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final List<Person> _result = new ArrayList<Person>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Person _item;
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        final boolean _tmpIsPersonalAccount;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
        _tmpIsPersonalAccount = _tmp_1 != 0;
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        final boolean _tmpAdmin;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_2 != 0;
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _item = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<PersonNames> getNamesByUid(final long uid) {
    final String _sql = "\n"
            + "        SELECT Person.firstNames, Person.lastName\n"
            + "          FROM Person\n"
            + "         WHERE Person.personUid = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person"}, new Callable<PersonNames>() {
      @Override
      @Nullable
      public PersonNames call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstNames = 0;
          final int _cursorIndexOfLastName = 1;
          final PersonNames _result;
          if (_cursor.moveToFirst()) {
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result = new PersonNames(_tmpFirstNames,_tmpLastName);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getNamesByUidAsync(final long uid,
      final Continuation<? super PersonNames> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.firstNames, Person.lastName\n"
            + "          FROM Person\n"
            + "         WHERE Person.personUid = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonNames>() {
      @Override
      @Nullable
      public PersonNames call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstNames = 0;
          final int _cursorIndexOfLastName = 1;
          final PersonNames _result;
          if (_cursor.moveToFirst()) {
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result = new PersonNames(_tmpFirstNames,_tmpLastName);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getMinorByParentPersonUidAsync(final long uid,
      final Continuation<? super List<Person>> $completion) {
    final String _sql = "\n"
            + "          SELECT Person.*\n"
            + "             FROM Person\n"
            + "             LEFT JOIN PersonParentJoin ON Person.personUid = PersonParentJoin.ppjMinorPersonUid\n"
            + "              WHERE PersonParentJoin.ppjParentPersonUid =  ?  \n"
            + "     ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Person>>() {
      @Override
      @Nullable
      public List<Person> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final List<Person> _result = new ArrayList<Person>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Person _item;
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _item = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object selectExistingUsernames(final List<String> usernames,
      final Continuation<? super List<String>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT Person.username");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE Person.username IN (");
    final int _inputSize = usernames.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : usernames) {
      _statement.bindString(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<String>>() {
      @Override
      @NonNull
      public List<String> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<String> _result = new ArrayList<String>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final String _item_1;
            if (_cursor.isNull(0)) {
              _item_1 = null;
            } else {
              _item_1 = _cursor.getString(0);
            }
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
