package com.ustadmobile.core.db.dao;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ScopedGrant;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ScopedGrantDao_Impl extends ScopedGrantDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ScopedGrant> __insertionAdapterOfScopedGrant;

  public ScopedGrantDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfScopedGrant = new EntityInsertionAdapter<ScopedGrant>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ScopedGrant` (`sgUid`,`sgPcsn`,`sgLcsn`,`sgLcb`,`sgLct`,`sgTableId`,`sgEntityUid`,`sgPermissions`,`sgGroupUid`,`sgIndex`,`sgFlags`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ScopedGrant entity) {
        statement.bindLong(1, entity.getSgUid());
        statement.bindLong(2, entity.getSgPcsn());
        statement.bindLong(3, entity.getSgLcsn());
        statement.bindLong(4, entity.getSgLcb());
        statement.bindLong(5, entity.getSgLct());
        statement.bindLong(6, entity.getSgTableId());
        statement.bindLong(7, entity.getSgEntityUid());
        statement.bindLong(8, entity.getSgPermissions());
        statement.bindLong(9, entity.getSgGroupUid());
        statement.bindLong(10, entity.getSgIndex());
        statement.bindLong(11, entity.getSgFlags());
      }
    };
  }

  @Override
  public Object insertAsync(final ScopedGrant scopedGrant,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfScopedGrant.insertAndReturnId(scopedGrant);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insertListAsync(final List<? extends ScopedGrant> scopedGrantList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfScopedGrant.insert(scopedGrantList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
