package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.SiteTerms;
import com.ustadmobile.lib.db.entities.SiteTermsWithLanguage;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class SiteTermsDao_Impl extends SiteTermsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<SiteTerms> __insertionAdapterOfSiteTerms;

  private final EntityInsertionAdapter<SiteTerms> __insertionAdapterOfSiteTerms_1;

  private final EntityDeletionOrUpdateAdapter<SiteTerms> __updateAdapterOfSiteTerms;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public SiteTermsDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSiteTerms = new EntityInsertionAdapter<SiteTerms>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `SiteTerms` (`sTermsUid`,`termsHtml`,`sTermsLang`,`sTermsLangUid`,`sTermsActive`,`sTermsLastChangedBy`,`sTermsPrimaryCsn`,`sTermsLocalCsn`,`sTermsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SiteTerms entity) {
        statement.bindLong(1, entity.getSTermsUid());
        if (entity.getTermsHtml() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getTermsHtml());
        }
        if (entity.getSTermsLang() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSTermsLang());
        }
        statement.bindLong(4, entity.getSTermsLangUid());
        final int _tmp = entity.getSTermsActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        statement.bindLong(6, entity.getSTermsLastChangedBy());
        statement.bindLong(7, entity.getSTermsPrimaryCsn());
        statement.bindLong(8, entity.getSTermsLocalCsn());
        statement.bindLong(9, entity.getSTermsLct());
      }
    };
    this.__insertionAdapterOfSiteTerms_1 = new EntityInsertionAdapter<SiteTerms>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `SiteTerms` (`sTermsUid`,`termsHtml`,`sTermsLang`,`sTermsLangUid`,`sTermsActive`,`sTermsLastChangedBy`,`sTermsPrimaryCsn`,`sTermsLocalCsn`,`sTermsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SiteTerms entity) {
        statement.bindLong(1, entity.getSTermsUid());
        if (entity.getTermsHtml() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getTermsHtml());
        }
        if (entity.getSTermsLang() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSTermsLang());
        }
        statement.bindLong(4, entity.getSTermsLangUid());
        final int _tmp = entity.getSTermsActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        statement.bindLong(6, entity.getSTermsLastChangedBy());
        statement.bindLong(7, entity.getSTermsPrimaryCsn());
        statement.bindLong(8, entity.getSTermsLocalCsn());
        statement.bindLong(9, entity.getSTermsLct());
      }
    };
    this.__updateAdapterOfSiteTerms = new EntityDeletionOrUpdateAdapter<SiteTerms>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `SiteTerms` SET `sTermsUid` = ?,`termsHtml` = ?,`sTermsLang` = ?,`sTermsLangUid` = ?,`sTermsActive` = ?,`sTermsLastChangedBy` = ?,`sTermsPrimaryCsn` = ?,`sTermsLocalCsn` = ?,`sTermsLct` = ? WHERE `sTermsUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SiteTerms entity) {
        statement.bindLong(1, entity.getSTermsUid());
        if (entity.getTermsHtml() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getTermsHtml());
        }
        if (entity.getSTermsLang() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSTermsLang());
        }
        statement.bindLong(4, entity.getSTermsLangUid());
        final int _tmp = entity.getSTermsActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        statement.bindLong(6, entity.getSTermsLastChangedBy());
        statement.bindLong(7, entity.getSTermsPrimaryCsn());
        statement.bindLong(8, entity.getSTermsLocalCsn());
        statement.bindLong(9, entity.getSTermsLct());
        statement.bindLong(10, entity.getSTermsUid());
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE SiteTerms \n"
                + "           SET sTermsActive = ?,\n"
                + "               sTermsLct = ?\n"
                + "         WHERE sTermsUid = ?\n"
                + "        ";
        return _query;
      }
    };
  }

  @Override
  public Object insertListAsync(final List<? extends SiteTerms> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSiteTerms.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insertAsync(final SiteTerms siteTerms,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfSiteTerms.insertAndReturnId(siteTerms);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertList(final List<? extends SiteTerms> termList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSiteTerms_1.insert(termList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateListAsync(final List<? extends SiteTerms> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfSiteTerms.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateActiveByUid(final long sTermsUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, sTermsUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findSiteTerms(final String langCode,
      final Continuation<? super SiteTerms> $completion) {
    final String _sql = "\n"
            + "        SELECT * FROM SiteTerms WHERE sTermsUid = coalesce(\n"
            + "            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = ? LIMIT 1),\n"
            + "            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = 'en' LIMIT 1),\n"
            + "            0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, langCode);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SiteTerms>() {
      @Override
      @Nullable
      public SiteTerms call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsUid");
          final int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "termsHtml");
          final int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLang");
          final int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLangUid");
          final int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsActive");
          final int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLastChangedBy");
          final int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsPrimaryCsn");
          final int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLocalCsn");
          final int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLct");
          final SiteTerms _result;
          if (_cursor.moveToFirst()) {
            _result = new SiteTerms();
            final long _tmpSTermsUid;
            _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
            _result.setSTermsUid(_tmpSTermsUid);
            final String _tmpTermsHtml;
            if (_cursor.isNull(_cursorIndexOfTermsHtml)) {
              _tmpTermsHtml = null;
            } else {
              _tmpTermsHtml = _cursor.getString(_cursorIndexOfTermsHtml);
            }
            _result.setTermsHtml(_tmpTermsHtml);
            final String _tmpSTermsLang;
            if (_cursor.isNull(_cursorIndexOfSTermsLang)) {
              _tmpSTermsLang = null;
            } else {
              _tmpSTermsLang = _cursor.getString(_cursorIndexOfSTermsLang);
            }
            _result.setSTermsLang(_tmpSTermsLang);
            final long _tmpSTermsLangUid;
            _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
            _result.setSTermsLangUid(_tmpSTermsLangUid);
            final boolean _tmpSTermsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
            _tmpSTermsActive = _tmp != 0;
            _result.setSTermsActive(_tmpSTermsActive);
            final int _tmpSTermsLastChangedBy;
            _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
            _result.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
            final long _tmpSTermsPrimaryCsn;
            _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
            _result.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
            final long _tmpSTermsLocalCsn;
            _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
            _result.setSTermsLocalCsn(_tmpSTermsLocalCsn);
            final long _tmpSTermsLct;
            _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
            _result.setSTermsLct(_tmpSTermsLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super SiteTerms> $completion) {
    final String _sql = "SELECT * FROM SiteTerms WHERE sTermsUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SiteTerms>() {
      @Override
      @Nullable
      public SiteTerms call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsUid");
          final int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "termsHtml");
          final int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLang");
          final int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLangUid");
          final int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsActive");
          final int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLastChangedBy");
          final int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsPrimaryCsn");
          final int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLocalCsn");
          final int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLct");
          final SiteTerms _result;
          if (_cursor.moveToFirst()) {
            _result = new SiteTerms();
            final long _tmpSTermsUid;
            _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
            _result.setSTermsUid(_tmpSTermsUid);
            final String _tmpTermsHtml;
            if (_cursor.isNull(_cursorIndexOfTermsHtml)) {
              _tmpTermsHtml = null;
            } else {
              _tmpTermsHtml = _cursor.getString(_cursorIndexOfTermsHtml);
            }
            _result.setTermsHtml(_tmpTermsHtml);
            final String _tmpSTermsLang;
            if (_cursor.isNull(_cursorIndexOfSTermsLang)) {
              _tmpSTermsLang = null;
            } else {
              _tmpSTermsLang = _cursor.getString(_cursorIndexOfSTermsLang);
            }
            _result.setSTermsLang(_tmpSTermsLang);
            final long _tmpSTermsLangUid;
            _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
            _result.setSTermsLangUid(_tmpSTermsLangUid);
            final boolean _tmpSTermsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
            _tmpSTermsActive = _tmp != 0;
            _result.setSTermsActive(_tmpSTermsActive);
            final int _tmpSTermsLastChangedBy;
            _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
            _result.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
            final long _tmpSTermsPrimaryCsn;
            _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
            _result.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
            final long _tmpSTermsLocalCsn;
            _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
            _result.setSTermsLocalCsn(_tmpSTermsLocalCsn);
            final long _tmpSTermsLct;
            _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
            _result.setSTermsLct(_tmpSTermsLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<SiteTerms>> findAllTermsAsListFlow(final int activeOnly) {
    final String _sql = "\n"
            + "        SELECT SiteTerms.*\n"
            + "          FROM SiteTerms\n"
            + "         WHERE ? = 0 \n"
            + "            OR CAST(sTermsActive AS INTEGER) = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, activeOnly);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"SiteTerms"}, new Callable<List<SiteTerms>>() {
      @Override
      @NonNull
      public List<SiteTerms> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsUid");
          final int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "termsHtml");
          final int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLang");
          final int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLangUid");
          final int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsActive");
          final int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLastChangedBy");
          final int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsPrimaryCsn");
          final int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLocalCsn");
          final int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLct");
          final List<SiteTerms> _result = new ArrayList<SiteTerms>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final SiteTerms _item;
            _item = new SiteTerms();
            final long _tmpSTermsUid;
            _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
            _item.setSTermsUid(_tmpSTermsUid);
            final String _tmpTermsHtml;
            if (_cursor.isNull(_cursorIndexOfTermsHtml)) {
              _tmpTermsHtml = null;
            } else {
              _tmpTermsHtml = _cursor.getString(_cursorIndexOfTermsHtml);
            }
            _item.setTermsHtml(_tmpTermsHtml);
            final String _tmpSTermsLang;
            if (_cursor.isNull(_cursorIndexOfSTermsLang)) {
              _tmpSTermsLang = null;
            } else {
              _tmpSTermsLang = _cursor.getString(_cursorIndexOfSTermsLang);
            }
            _item.setSTermsLang(_tmpSTermsLang);
            final long _tmpSTermsLangUid;
            _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
            _item.setSTermsLangUid(_tmpSTermsLangUid);
            final boolean _tmpSTermsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
            _tmpSTermsActive = _tmp != 0;
            _item.setSTermsActive(_tmpSTermsActive);
            final int _tmpSTermsLastChangedBy;
            _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
            _item.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
            final long _tmpSTermsPrimaryCsn;
            _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
            _item.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
            final long _tmpSTermsLocalCsn;
            _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
            _item.setSTermsLocalCsn(_tmpSTermsLocalCsn);
            final long _tmpSTermsLct;
            _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
            _item.setSTermsLct(_tmpSTermsLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllTerms(final int activeOnly,
      final Continuation<? super List<? extends SiteTerms>> $completion) {
    final String _sql = "\n"
            + "        SELECT SiteTerms.*\n"
            + "          FROM SiteTerms\n"
            + "         WHERE ? = 0 \n"
            + "            OR CAST(sTermsActive AS INTEGER) = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, activeOnly);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SiteTerms>>() {
      @Override
      @NonNull
      public List<SiteTerms> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsUid");
          final int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "termsHtml");
          final int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLang");
          final int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLangUid");
          final int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsActive");
          final int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLastChangedBy");
          final int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsPrimaryCsn");
          final int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLocalCsn");
          final int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLct");
          final List<SiteTerms> _result = new ArrayList<SiteTerms>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final SiteTerms _item;
            _item = new SiteTerms();
            final long _tmpSTermsUid;
            _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
            _item.setSTermsUid(_tmpSTermsUid);
            final String _tmpTermsHtml;
            if (_cursor.isNull(_cursorIndexOfTermsHtml)) {
              _tmpTermsHtml = null;
            } else {
              _tmpTermsHtml = _cursor.getString(_cursorIndexOfTermsHtml);
            }
            _item.setTermsHtml(_tmpTermsHtml);
            final String _tmpSTermsLang;
            if (_cursor.isNull(_cursorIndexOfSTermsLang)) {
              _tmpSTermsLang = null;
            } else {
              _tmpSTermsLang = _cursor.getString(_cursorIndexOfSTermsLang);
            }
            _item.setSTermsLang(_tmpSTermsLang);
            final long _tmpSTermsLangUid;
            _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
            _item.setSTermsLangUid(_tmpSTermsLangUid);
            final boolean _tmpSTermsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
            _tmpSTermsActive = _tmp != 0;
            _item.setSTermsActive(_tmpSTermsActive);
            final int _tmpSTermsLastChangedBy;
            _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
            _item.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
            final long _tmpSTermsPrimaryCsn;
            _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
            _item.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
            final long _tmpSTermsLocalCsn;
            _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
            _item.setSTermsLocalCsn(_tmpSTermsLocalCsn);
            final long _tmpSTermsLct;
            _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
            _item.setSTermsLct(_tmpSTermsLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllWithLanguageAsList(
      final Continuation<? super List<SiteTermsWithLanguage>> $completion) {
    final String _sql = "SELECT SiteTerms.*, Language.*\n"
            + "        FROM SiteTerms\n"
            + "        LEFT JOIN Language ON SiteTerms.sTermsLangUid = Language.langUid\n"
            + "        WHERE CAST(sTermsActive AS INTEGER) = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SiteTermsWithLanguage>>() {
      @Override
      @NonNull
      public List<SiteTermsWithLanguage> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsUid");
          final int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "termsHtml");
          final int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLang");
          final int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLangUid");
          final int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsActive");
          final int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLastChangedBy");
          final int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsPrimaryCsn");
          final int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLocalCsn");
          final int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final List<SiteTermsWithLanguage> _result = new ArrayList<SiteTermsWithLanguage>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final SiteTermsWithLanguage _item;
            final Language _tmpStLanguage;
            if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpStLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpStLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpStLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpStLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpStLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpStLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpStLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp != 0;
              _tmpStLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpStLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpStLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpStLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpStLanguage.setLangLct(_tmpLangLct);
            } else {
              _tmpStLanguage = null;
            }
            _item = new SiteTermsWithLanguage();
            final long _tmpSTermsUid;
            _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
            _item.setSTermsUid(_tmpSTermsUid);
            final String _tmpTermsHtml;
            if (_cursor.isNull(_cursorIndexOfTermsHtml)) {
              _tmpTermsHtml = null;
            } else {
              _tmpTermsHtml = _cursor.getString(_cursorIndexOfTermsHtml);
            }
            _item.setTermsHtml(_tmpTermsHtml);
            final String _tmpSTermsLang;
            if (_cursor.isNull(_cursorIndexOfSTermsLang)) {
              _tmpSTermsLang = null;
            } else {
              _tmpSTermsLang = _cursor.getString(_cursorIndexOfSTermsLang);
            }
            _item.setSTermsLang(_tmpSTermsLang);
            final long _tmpSTermsLangUid;
            _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
            _item.setSTermsLangUid(_tmpSTermsLangUid);
            final boolean _tmpSTermsActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSTermsActive);
            _tmpSTermsActive = _tmp_1 != 0;
            _item.setSTermsActive(_tmpSTermsActive);
            final int _tmpSTermsLastChangedBy;
            _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
            _item.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
            final long _tmpSTermsPrimaryCsn;
            _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
            _item.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
            final long _tmpSTermsLocalCsn;
            _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
            _item.setSTermsLocalCsn(_tmpSTermsLocalCsn);
            final long _tmpSTermsLct;
            _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
            _item.setSTermsLct(_tmpSTermsLct);
            _item.setStLanguage(_tmpStLanguage);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAvailableSiteTermLanguages(final int active,
      final Continuation<? super List<String>> $completion) {
    final String _sql = "\n"
            + "        SELECT SiteTerms.sTermsLang\n"
            + "          FROM SiteTerms\n"
            + "         WHERE CAST(SiteTerms.sTermsActive AS INTEGER) = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, active);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<String>>() {
      @Override
      @NonNull
      public List<String> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<String> _result = new ArrayList<String>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final String _item;
            if (_cursor.isNull(0)) {
              _item = null;
            } else {
              _item = _cursor.getString(0);
            }
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findLatestByLanguage(final String lang,
      final Continuation<? super SiteTerms> $completion) {
    final String _sql = "\n"
            + "        SELECT SiteTerms.*\n"
            + "          FROM SiteTerms\n"
            + "         WHERE SiteTerms.sTermsLang = ?\n"
            + "           AND CAST(SiteTerms.sTermsActive AS INTEGER) = 1\n"
            + "      ORDER BY SiteTerms.sTermsLct DESC\n"
            + "         LIMIT 1     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, lang);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SiteTerms>() {
      @Override
      @Nullable
      public SiteTerms call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsUid");
          final int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "termsHtml");
          final int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLang");
          final int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLangUid");
          final int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsActive");
          final int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLastChangedBy");
          final int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsPrimaryCsn");
          final int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLocalCsn");
          final int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sTermsLct");
          final SiteTerms _result;
          if (_cursor.moveToFirst()) {
            _result = new SiteTerms();
            final long _tmpSTermsUid;
            _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
            _result.setSTermsUid(_tmpSTermsUid);
            final String _tmpTermsHtml;
            if (_cursor.isNull(_cursorIndexOfTermsHtml)) {
              _tmpTermsHtml = null;
            } else {
              _tmpTermsHtml = _cursor.getString(_cursorIndexOfTermsHtml);
            }
            _result.setTermsHtml(_tmpTermsHtml);
            final String _tmpSTermsLang;
            if (_cursor.isNull(_cursorIndexOfSTermsLang)) {
              _tmpSTermsLang = null;
            } else {
              _tmpSTermsLang = _cursor.getString(_cursorIndexOfSTermsLang);
            }
            _result.setSTermsLang(_tmpSTermsLang);
            final long _tmpSTermsLangUid;
            _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
            _result.setSTermsLangUid(_tmpSTermsLangUid);
            final boolean _tmpSTermsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
            _tmpSTermsActive = _tmp != 0;
            _result.setSTermsActive(_tmpSTermsActive);
            final int _tmpSTermsLastChangedBy;
            _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
            _result.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
            final long _tmpSTermsPrimaryCsn;
            _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
            _result.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
            final long _tmpSTermsLocalCsn;
            _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
            _result.setSTermsLocalCsn(_tmpSTermsLocalCsn);
            final long _tmpSTermsLct;
            _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
            _result.setSTermsLct(_tmpSTermsLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
