package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.StatementEntityJson;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class StatementEntityJsonDao_Impl extends StatementEntityJsonDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StatementEntityJson> __insertionAdapterOfStatementEntityJson;

  public StatementEntityJsonDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStatementEntityJson = new EntityInsertionAdapter<StatementEntityJson>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `StatementEntityJson` (`stmtJsonIdHi`,`stmtJsonIdLo`,`stmtEtag`,`fullStatement`) VALUES (?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StatementEntityJson entity) {
        statement.bindLong(1, entity.getStmtJsonIdHi());
        statement.bindLong(2, entity.getStmtJsonIdLo());
        statement.bindLong(3, entity.getStmtEtag());
        if (entity.getFullStatement() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getFullStatement());
        }
      }
    };
  }

  @Override
  public Object insertOrIgnoreListAsync(final List<StatementEntityJson> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStatementEntityJson.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object getStatements(final long stmtJsonIdHi, final long stmtJsonIdLo,
      final Continuation<? super List<StatementEntityJson>> $completion) {
    final String _sql = "\n"
            + "        SELECT StatementEntityJson.*\n"
            + "          FROM StatementEntityJson\n"
            + "         WHERE (    (? = 0 AND ? = 0) \n"
            + "                 OR (stmtJsonIdHi = ? AND stmtJsonIdLo = ?))\n"
            + "                  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, stmtJsonIdHi);
    _argIndex = 2;
    _statement.bindLong(_argIndex, stmtJsonIdLo);
    _argIndex = 3;
    _statement.bindLong(_argIndex, stmtJsonIdHi);
    _argIndex = 4;
    _statement.bindLong(_argIndex, stmtJsonIdLo);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntityJson>>() {
      @Override
      @NonNull
      public List<StatementEntityJson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStmtJsonIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "stmtJsonIdHi");
          final int _cursorIndexOfStmtJsonIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "stmtJsonIdLo");
          final int _cursorIndexOfStmtEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "stmtEtag");
          final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "fullStatement");
          final List<StatementEntityJson> _result = new ArrayList<StatementEntityJson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntityJson _item;
            final long _tmpStmtJsonIdHi;
            _tmpStmtJsonIdHi = _cursor.getLong(_cursorIndexOfStmtJsonIdHi);
            final long _tmpStmtJsonIdLo;
            _tmpStmtJsonIdLo = _cursor.getLong(_cursorIndexOfStmtJsonIdLo);
            final long _tmpStmtEtag;
            _tmpStmtEtag = _cursor.getLong(_cursorIndexOfStmtEtag);
            final String _tmpFullStatement;
            if (_cursor.isNull(_cursorIndexOfFullStatement)) {
              _tmpFullStatement = null;
            } else {
              _tmpFullStatement = _cursor.getString(_cursorIndexOfFullStatement);
            }
            _item = new StatementEntityJson(_tmpStmtJsonIdHi,_tmpStmtJsonIdLo,_tmpStmtEtag,_tmpFullStatement);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
