package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.CourseTerminology
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

public class CourseTerminologyDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: CourseTerminologyDao,
) : CourseTerminologyDao() {
  override fun findAllCourseTerminologyPagingSource(): PagingSource<Int, CourseTerminology> =
      _dao.findAllCourseTerminologyPagingSource()

  override fun findAllCourseTerminologyList(): List<CourseTerminology> =
      _dao.findAllCourseTerminologyList()

  override suspend fun getTerminologyForClazz(clazzUid: Long): CourseTerminology? =
      _dao.getTerminologyForClazz(clazzUid)

  override suspend fun getTerminologyForAssignment(assignmentUid: Long): CourseTerminology? =
      _dao.getTerminologyForAssignment(assignmentUid)

  override suspend fun findByUidAsync(uid: Long): CourseTerminology? = _dao.findByUidAsync(uid)

  override suspend fun updateAsync(entity: CourseTerminology): Int {
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  override suspend fun upsertAsync(entity: CourseTerminology): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ctUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(450)
      entity.ctUid = _newPk
    }
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.upsertAsync(entity)
    return entity.ctUid
  }

  public override fun insert(entity: CourseTerminology): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ctUid == 0L) {
      val _newPk = _pkManager.nextId(450)
      entity.ctUid = _newPk
    }
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.ctUid
  }

  public override suspend fun insertAsync(entity: CourseTerminology): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ctUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(450)
      entity.ctUid = _newPk
    }
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.ctUid
  }

  public override fun insertList(entityList: List<CourseTerminology>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.ctUid == 0L) {
        val _newPk = _pkManager.nextId(450)
        it.ctUid = _newPk
        _generatedPks += _newPk
      }
      it.ctLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: CourseTerminology) {
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
