package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.composites.StudentResultAndCourseBlockSourcedId
import com.ustadmobile.lib.db.entities.StudentResult
import kotlin.Any
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class StudentResultDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertListAsync(list: List<StudentResult>)

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertAsync(studentResult: StudentResult)

  @Query(`value` =
      "\n        SELECT StudentResult.*,\n               CourseBlock.cbSourcedId AS cbSourcedId\n          FROM StudentResult\n               LEFT JOIN CourseBlock\n                         ON StudentResult.srCourseBlockUid = CourseBlock.cbUid \n         WHERE StudentResult.srClazzUid = :clazzUid\n           AND StudentResult.srStudentPersonUid = :studentPersonUid\n           AND :accountPersonUid = :accountPersonUid\n    ")
  public actual abstract suspend fun findByClazzAndStudent(
    clazzUid: Long,
    studentPersonUid: Long,
    accountPersonUid: Long,
  ): List<StudentResultAndCourseBlockSourcedId>

  @Query(`value` =
      "\n        SELECT COALESCE(\n               (SELECT StudentResult.srUid  \n                  FROM StudentResult \n                 WHERE srSourcedId = :sourcedId), 0)\n    ")
  public actual abstract suspend fun findUidBySourcedId(sourcedId: String): Long

  @Query(`value` =
      "\n        SELECT EXISTS(\n               SELECT StudentResult.srUid\n                 FROM StudentResult\n                WHERE StudentResult.srUid = :srUid)\n    ")
  public actual abstract suspend fun existsByUid(srUid: Long): Boolean
}
