package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class ActivityLangMapEntryDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertList(entities: List<ActivityLangMapEntry>)

  @Query(`value` =
      "\n        INSERT OR REPLACE \n        INTO ActivityLangMapEntry(almeActivityUid, almeHash, almeLangCode, almePropName, almeValue, almeAieHash, almeLastMod)\n        SELECT :almeActivityUid AS almeActivityUid,\n               :almeHash AS almeHash,\n               :almeLangCode AS almeLangCode,\n               :almePropName AS almePropName,\n               :almeValue AS almeValue,\n               :almeAieHash AS almeAieHash,\n               :almeLastMod AS almeLastMod\n         WHERE EXISTS(SELECT 1\n                        FROM ActivityInteractionEntity\n                       WHERE ActivityInteractionEntity.aieActivityUid = :almeActivityUid\n                         AND ActivityInteractionEntity.aieHash = :almeAieHash)\n          \n    ")
  public actual abstract suspend fun upsertIfInteractionEntityExists(
    almeActivityUid: Long,
    almeHash: Long,
    almePropName: String?,
    almeLangCode: String?,
    almeValue: String?,
    almeAieHash: Long,
    almeLastMod: Long,
  )

  @Query(`value` =
      "\n        UPDATE ActivityLangMapEntry\n           SET almeValue = :almeValue,\n               almeLastMod = :almeLastMod\n         WHERE almeActivityUid = :almeActivityUid\n           AND almeHash = :almeHash\n           AND almeValue != :almeValue       \n    ")
  public actual abstract suspend fun updateIfChanged(
    almeActivityUid: Long,
    almeHash: Long,
    almeValue: String?,
    almeLastMod: Long,
  )

  @Query(`value` =
      "\n        SELECT ActivityLangMapEntry.*\n          FROM ActivityLangMapEntry\n         WHERE ActivityLangMapEntry.almeActivityUid = :activityUid\n    ")
  public actual abstract suspend fun findAllByActivityUid(activityUid: Long):
      List<ActivityLangMapEntry>
}
