/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0007\u001a\u001f\u0010\u0004\u001a\u0004\u0018\u00010\b*\u00020\u00072\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0007\u00a2\u0006\u0002\u0010\t\u001a\u0011\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0003\u00a2\u0006\u0002\u0010\f\u001a\u0011\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0007\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0003\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0007\u001a\u0012\u0010\u0010\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u0007\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0003\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0007\u001a\u0012\u0010\u0017\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0016\u001a\u0012\u0010\u0019\u001a\u00020\b*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000f\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u0003\u001a\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u0016H\u0000\u001a\u0012\u0010\u001d\u001a\u00020\b*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0016\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0001*\u00020\u0003\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0001*\u00020\u0007\u00a8\u0006 "}, d2={"cacheControl", "", "Lio/ktor/http/HeaderValue;", "Lio/ktor/http/HttpMessage;", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "Lio/ktor/http/HttpMessageBuilder;", "", "(Lio/ktor/http/HttpMessageBuilder;Ljava/nio/charset/Charset;)Lkotlin/Unit;", "contentLength", "", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "length", "", "contentType", "Lio/ktor/http/ContentType;", "type", "cookies", "Lio/ktor/http/Cookie;", "etag", "", "ifNoneMatch", "value", "maxAge", "seconds", "setCookie", "splitSetCookieHeader", "userAgent", "content", "vary", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHttpMessageProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpMessageProperties.kt\nio/ktor/http/HttpMessagePropertiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1360#3:174\n1446#3,2:175\n1549#3:177\n1620#3,3:178\n1448#3,3:181\n1360#3:184\n1446#3,2:185\n1549#3:187\n1620#3,3:188\n1448#3,3:191\n1360#3:194\n1446#3,5:195\n1549#3:200\n1620#3,3:201\n1549#3:204\n1620#3,3:205\n*S KotlinDebug\n*F\n+ 1 HttpMessageProperties.kt\nio/ktor/http/HttpMessagePropertiesKt\n*L\n64#1:174\n64#1:175,2\n65#1:177\n65#1:178,3\n64#1:181,3\n91#1:184\n91#1:185,2\n92#1:187\n92#1:188,3\n91#1:191,3\n104#1:194\n104#1:195,5\n105#1:200\n105#1:201,3\n112#1:204\n112#1:205,3\n*E\n"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(@NotNull HttpMessageBuilder $this$contentType, @NotNull ContentType type2) {
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        $this$contentType.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type2.toString());
    }

    @Deprecated(message="Content-Length is controlled by underlying engine. Don't specify it explicitly.", level=DeprecationLevel.ERROR)
    public static final void contentLength(@NotNull HttpMessageBuilder $this$contentLength, int length) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        $this$contentLength.getHeaders().set(HttpHeaders.INSTANCE.getContentLength(), String.valueOf(length));
    }

    @Deprecated(message="Use content with particular content type and charset instead", level=DeprecationLevel.ERROR)
    @Nullable
    public static final Unit charset(@NotNull HttpMessageBuilder $this$charset, @NotNull Charset charset) {
        Unit unit;
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        if (contentType2 != null) {
            ContentType it = contentType2;
            boolean bl = false;
            HttpMessagePropertiesKt.contentType($this$charset, ContentTypesKt.withCharset(it, charset));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $this$maxAge, int seconds) {
        Intrinsics.checkNotNullParameter($this$maxAge, "<this>");
        $this$maxAge.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age=" + seconds);
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $this$ifNoneMatch, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$ifNoneMatch, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$ifNoneMatch.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $this$userAgent, @NotNull String content2) {
        Intrinsics.checkNotNullParameter($this$userAgent, "<this>");
        Intrinsics.checkNotNullParameter(content2, "content");
        $this$userAgent.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content2);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $this$etag) {
        Intrinsics.checkNotNullParameter($this$etag, "<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter($this$vary, "<this>");
        List<String> list2 = $this$vary.getHeaders().getAll(HttpHeaders.INSTANCE.getVary());
        if (list2 != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                String varyKeys = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)varyKeys, stringArray, false, 0, 6, null);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessageBuilder $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $this$etag) {
        Intrinsics.checkNotNullParameter($this$etag, "<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter($this$vary, "<this>");
        List<String> list2 = $this$vary.getHeaders().getAll(HttpHeaders.INSTANCE.getVary());
        if (list2 != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                String varyKeys = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)varyKeys, stringArray, false, 0, 6, null);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessage $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $this$setCookie) {
        List list;
        Intrinsics.checkNotNullParameter($this$setCookie, "<this>");
        List<String> list2 = $this$setCookie.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = HttpMessagePropertiesKt.splitSetCookieHeader(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $this$cookies) {
        List list;
        Intrinsics.checkNotNullParameter($this$cookies, "<this>");
        List<String> list2 = $this$cookies.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<HeaderValue> cacheControl(@NotNull HttpMessage $this$cacheControl) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$cacheControl, "<this>");
                object = $this$cacheControl.getHeaders().get(HttpHeaders.INSTANCE.getCacheControl());
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List<HeaderValue> list = HttpHeaderValueParserKt.parseHeaderValue(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<String> splitSetCookieHeader(@NotNull String $this$splitSetCookieHeader) {
        Intrinsics.checkNotNullParameter($this$splitSetCookieHeader, "<this>");
        int comma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', 0, false, 6, null);
        if (comma == -1) {
            return CollectionsKt.listOf($this$splitSetCookieHeader);
        }
        List result2 = new ArrayList();
        int current = 0;
        int equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, '=', comma, false, 4, null);
        int semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ';', comma, false, 4, null);
        while (current < $this$splitSetCookieHeader.length() && comma > 0) {
            int nextComma;
            block11: {
                block10: {
                    if (equals < comma) {
                        equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, '=', comma, false, 4, null);
                    }
                    nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', comma + 1, false, 4, null);
                    while (nextComma >= 0 && nextComma < equals) {
                        comma = nextComma;
                        nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', nextComma + 1, false, 4, null);
                    }
                    if (semicolon < comma) {
                        semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ';', comma, false, 4, null);
                    }
                    if (equals < 0) {
                        Collection collection = result2;
                        String string = $this$splitSetCookieHeader.substring(current);
                        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                        collection.add(string);
                        return result2;
                    }
                    if (semicolon == -1) break block10;
                    if (semicolon <= equals) break block11;
                }
                Collection collection = result2;
                String string = $this$splitSetCookieHeader.substring(current, comma);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                collection.add(string);
                current = comma + 1;
            }
            comma = nextComma;
        }
        if (current < $this$splitSetCookieHeader.length()) {
            Collection collection = result2;
            String string = $this$splitSetCookieHeader.substring(current);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            collection.add(string);
        }
        return result2;
    }
}

