/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.local.LocalAddress;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;

final class LocalChannelRegistry {
    private static final ConcurrentMap<LocalAddress, Channel> boundChannels = PlatformDependent.newConcurrentHashMap();

    static LocalAddress register(Channel channel2, LocalAddress oldLocalAddress, SocketAddress localAddress2) {
        Channel boundChannel;
        if (oldLocalAddress != null) {
            throw new ChannelException("already bound");
        }
        if (!(localAddress2 instanceof LocalAddress)) {
            throw new ChannelException("unsupported address type: " + StringUtil.simpleClassName(localAddress2));
        }
        LocalAddress addr = (LocalAddress)localAddress2;
        if (LocalAddress.ANY.equals(addr)) {
            addr = new LocalAddress(channel2);
        }
        if ((boundChannel = boundChannels.putIfAbsent(addr, channel2)) != null) {
            throw new ChannelException("address already in use by: " + boundChannel);
        }
        return addr;
    }

    static Channel get(SocketAddress localAddress2) {
        return (Channel)boundChannels.get(localAddress2);
    }

    static void unregister(LocalAddress localAddress2) {
        boundChannels.remove(localAddress2);
    }

    private LocalChannelRegistry() {
    }
}

