/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private static final int HASH_CODE_PRIME = 31;
    private HttpMethod method;
    private String uri;

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod method2, String uri2) {
        this(httpVersion, method2, uri2, DefaultHttpHeadersFactory.headersFactory().newHeaders());
    }

    @Deprecated
    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod method2, String uri2, boolean validateHeaders) {
        this(httpVersion, method2, uri2, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders));
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod method2, String uri2, HttpHeadersFactory headersFactory) {
        this(httpVersion, method2, uri2, headersFactory.newHeaders());
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod method2, String uri2, HttpHeaders headers2) {
        super(httpVersion, headers2);
        this.method = ObjectUtil.checkNotNull(method2, "method");
        this.uri = ObjectUtil.checkNotNull(uri2, "uri");
    }

    @Override
    @Deprecated
    public HttpMethod getMethod() {
        return this.method();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    @Deprecated
    public String getUri() {
        return this.uri();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpRequest setMethod(HttpMethod method2) {
        this.method = ObjectUtil.checkNotNull(method2, "method");
        return this;
    }

    @Override
    public HttpRequest setUri(String uri2) {
        this.uri = ObjectUtil.checkNotNull(uri2, "uri");
        return this;
    }

    @Override
    public HttpRequest setProtocolVersion(HttpVersion version2) {
        super.setProtocolVersion(version2);
        return this;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + this.method.hashCode();
        result2 = 31 * result2 + this.uri.hashCode();
        result2 = 31 * result2 + super.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttpRequest)) {
            return false;
        }
        DefaultHttpRequest other = (DefaultHttpRequest)o;
        return this.method().equals(other.method()) && this.uri().equalsIgnoreCase(other.uri()) && super.equals(o);
    }

    public String toString() {
        return HttpMessageUtil.appendRequest(new StringBuilder(256), this).toString();
    }
}

