/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.duplex.MwsDuplexAccess;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.ws.RealWebSocket;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import okhttp3.mockwebserver.internal.duplex.DuplexResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u007f2\u00020\u00012\u00020\u0002:\u0007\u007f\u0080\u0001\u0081\u0001\u0082\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020HH\u0014J\b\u0010J\u001a\u00020HH\u0014J\b\u0010K\u001a\u00020HH\u0016J\u0018\u0010L\u001a\u00020H2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\u001cH\u0002J\u000e\u0010O\u001a\u00020H2\u0006\u0010P\u001a\u00020QJ\r\u0010\"\u001a\u00020\rH\u0007\u00a2\u0006\u0002\bRJ\r\u00103\u001a\u00020\rH\u0007\u00a2\u0006\u0002\bSJ0\u0010T\u001a\u00020H2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u0002062\u0006\u0010P\u001a\u00020QH\u0002J\u0006\u0010Z\u001a\u00020HJ\u0010\u0010[\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001cH\u0002J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007\u00a2\u0006\u0002\b]J\u0010\u0010^\u001a\u00020H2\u0006\u0010U\u001a\u00020VH\u0002J(\u0010_\u001a\u0002062\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010M\u001a\u00020\rH\u0002J\u0006\u0010`\u001a\u00020HJ\u0006\u0010a\u001a\u00020HJ\u0010\u0010b\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001cH\u0002J\u0015\u0010\n\u001a\u00020H2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\bcJ\u0015\u0010)\u001a\u00020H2\u0006\u0010%\u001a\u00020&H\u0007\u00a2\u0006\u0002\bdJ\u001b\u00100\u001a\u00020H2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007\u00a2\u0006\u0002\b]J\u0015\u0010=\u001a\u00020H2\u0006\u0010:\u001a\u000209H\u0007\u00a2\u0006\u0002\beJ\u0006\u0010f\u001a\u00020HJ\u0010\u0010g\u001a\u00020H2\u0006\u0010h\u001a\u00020\u0007H\u0002J\u0016\u0010i\u001a\u00020H2\u0006\u0010j\u001a\u00020k2\u0006\u0010!\u001a\u00020\rJ\u0010\u0010i\u001a\u00020H2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010i\u001a\u00020H2\b\b\u0002\u0010!\u001a\u00020\rH\u0007J\u0006\u0010l\u001a\u000206J\u0018\u0010l\u001a\u0004\u0018\u0001062\u0006\u0010m\u001a\u00020\u00072\u0006\u0010n\u001a\u00020oJ8\u0010p\u001a\u00020H2\u0006\u0010q\u001a\u00020Q2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010r\u001a\u00020\u00072\u0006\u0010s\u001a\u00020&H\u0002J\u0006\u0010t\u001a\u00020uJ\b\u0010v\u001a\u00020\u0015H\u0016J\u000e\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020\u0015J\u0016\u0010z\u001a\u00020H2\u0006\u0010?\u001a\u00020@2\u0006\u0010F\u001a\u00020&J\u0018\u0010{\u001a\u00020H2\u0006\u0010W\u001a\u00020X2\u0006\u0010|\u001a\u00020}H\u0002J \u0010~\u001a\u00020H2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020X2\u0006\u0010P\u001a\u00020QH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001a\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001f\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010 0  \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010 0 \u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R2\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010#R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010:\u001a\u0004\u0018\u0001092\b\u0010+\u001a\u0004\u0018\u0001098F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001"}, d2={"Lokhttp3/mockwebserver/MockWebServer;", "Lorg/junit/rules/ExternalResource;", "Ljava/io/Closeable;", "()V", "atomicRequestCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "bodyLimit", "", "getBodyLimit", "()J", "setBodyLimit", "(J)V", "clientAuth", "", "dispatcher", "Lokhttp3/mockwebserver/Dispatcher;", "getDispatcher", "()Lokhttp3/mockwebserver/Dispatcher;", "setDispatcher", "(Lokhttp3/mockwebserver/Dispatcher;)V", "hostName", "", "getHostName", "()Ljava/lang/String;", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "openClientSockets", "", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "", "openConnections", "Lokhttp3/internal/http2/Http2Connection;", "port", "getPort", "()I", "portField", "protocolNegotiationEnabled", "", "getProtocolNegotiationEnabled", "()Z", "setProtocolNegotiationEnabled", "(Z)V", "value", "", "Lokhttp3/Protocol;", "protocols", "()Ljava/util/List;", "setProtocols", "(Ljava/util/List;)V", "requestCount", "getRequestCount", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lokhttp3/mockwebserver/RecordedRequest;", "serverSocket", "Ljava/net/ServerSocket;", "Ljavax/net/ServerSocketFactory;", "serverSocketFactory", "getServerSocketFactory", "()Ljavax/net/ServerSocketFactory;", "setServerSocketFactory", "(Ljavax/net/ServerSocketFactory;)V", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "started", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunnerBackend", "Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "tunnelProxy", "acceptConnections", "", "after", "before", "close", "dispatchBookkeepingRequest", "sequenceNumber", "socket", "enqueue", "response", "Lokhttp3/mockwebserver/MockResponse;", "-deprecated_port", "-deprecated_requestCount", "handleWebSocketUpgrade", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "request", "noClientAuth", "processHandshakeFailure", "raw", "-deprecated_protocols", "readEmptyLine", "readRequest", "requestClientAuth", "requireClientAuth", "serveConnection", "-deprecated_bodyLimit", "-deprecated_protocolNegotiationEnabled", "-deprecated_serverSocketFactory", "shutdown", "sleepIfDelayed", "delayMs", "start", "inetAddress", "Ljava/net/InetAddress;", "takeRequest", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "throttledTransfer", "policy", "byteCount", "isRequest", "toProxyAddress", "Ljava/net/Proxy;", "toString", "url", "Lokhttp3/HttpUrl;", "path", "useHttps", "writeHeaders", "headers", "Lokhttp3/Headers;", "writeHttpResponse", "Companion", "Http2SocketHandler", "SocketHandler", "TruncatingBuffer", "mockwebserver"})
@SourceDebugExtension(value={"SMAP\nMockWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServer.kt\nokhttp3/mockwebserver/MockWebServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n*L\n1#1,1168:1\n1#2:1169\n90#3,13:1170\n90#3,13:1183\n*S KotlinDebug\n*F\n+ 1 MockWebServer.kt\nokhttp3/mockwebserver/MockWebServer\n*L\n394#1:1170,13\n469#1:1183,13\n*E\n"})
public final class MockWebServer
extends ExternalResource
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner.RealBackend taskRunnerBackend = new TaskRunner.RealBackend(Util.threadFactory("MockWebServer TaskRunner", false));
    @NotNull
    private final TaskRunner taskRunner = new TaskRunner(this.taskRunnerBackend);
    @NotNull
    private final LinkedBlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Http2Connection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private final AtomicInteger atomicRequestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    @Nullable
    private ServerSocketFactory serverSocketFactory;
    @Nullable
    private ServerSocket serverSocket;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    private boolean tunnelProxy;
    private int clientAuth;
    @NotNull
    private Dispatcher dispatcher = new QueueDispatcher();
    private int portField = -1;
    @Nullable
    private InetSocketAddress inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    @NotNull
    private List<? extends Protocol> protocols;
    private boolean started;
    private static final int CLIENT_AUTH_NONE = 0;
    private static final int CLIENT_AUTH_REQUESTED = 1;
    private static final int CLIENT_AUTH_REQUIRED = 2;
    @NotNull
    private static final Companion.UNTRUSTED_TRUST_MANAGER.1 UNTRUSTED_TRUST_MANAGER;
    private static final Logger logger;

    public MockWebServer() {
        Protocol[] protocolArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        this.protocols = Util.immutableListOf(protocolArray);
    }

    public final int getRequestCount() {
        return this.atomicRequestCount.get();
    }

    public final long getBodyLimit() {
        return this.bodyLimit;
    }

    public final void setBodyLimit(long l) {
        this.bodyLimit = l;
    }

    @Nullable
    public final ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null && this.started) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        return this.serverSocketFactory;
    }

    public final void setServerSocketFactory(@Nullable ServerSocketFactory value) {
        if (!(!this.started)) {
            boolean bl = false;
            String string = "serverSocketFactory must not be set after start()";
            throw new IllegalStateException(string.toString());
        }
        this.serverSocketFactory = value;
    }

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "<set-?>");
        this.dispatcher = dispatcher;
    }

    public final int getPort() {
        this.before();
        return this.portField;
    }

    @NotNull
    public final String getHostName() {
        this.before();
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        Intrinsics.checkNotNull(inetSocketAddress);
        String string = inetSocketAddress.getAddress().getCanonicalHostName();
        Intrinsics.checkNotNullExpressionValue(string, "inetSocketAddress!!.address.canonicalHostName");
        return string;
    }

    public final boolean getProtocolNegotiationEnabled() {
        return this.protocolNegotiationEnabled;
    }

    public final void setProtocolNegotiationEnabled(boolean bl) {
        this.protocolNegotiationEnabled = bl;
    }

    @JvmName(name="protocols")
    @NotNull
    public final List<Protocol> protocols() {
        return this.protocols;
    }

    public final void setProtocols(@NotNull List<? extends Protocol> value) {
        Intrinsics.checkNotNullParameter(value, "value");
        List<? extends Protocol> protocolList = Util.toImmutableList(value);
        if (!(!protocolList.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) || protocolList.size() == 1)) {
            boolean $i$a$-require-MockWebServer$protocols$42 = false;
            String $i$a$-require-MockWebServer$protocols$42 = "protocols containing h2_prior_knowledge cannot use other protocols: " + protocolList;
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$42.toString());
        }
        if (!(protocolList.contains((Object)Protocol.HTTP_1_1) || protocolList.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE))) {
            boolean $i$a$-require-MockWebServer$protocols$52 = false;
            String $i$a$-require-MockWebServer$protocols$52 = "protocols doesn't contain http/1.1: " + protocolList;
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$52.toString());
        }
        Intrinsics.checkNotNull(protocolList, "null cannot be cast to non-null type kotlin.collections.List<okhttp3.Protocol?>");
        if (!(!protocolList.contains(null))) {
            boolean bl = false;
            String string = "protocols must not contain null";
            throw new IllegalArgumentException(string.toString());
        }
        this.protocols = protocolList;
    }

    @Override
    protected synchronized void before() {
        if (this.started) {
            return;
        }
        try {
            MockWebServer.start$default(this, 0, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="port", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_port")
    public final int -deprecated_port() {
        return this.getPort();
    }

    @NotNull
    public final Proxy toProxyAddress() {
        this.before();
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        Intrinsics.checkNotNull(inetSocketAddress);
        InetSocketAddress address2 = new InetSocketAddress(inetSocketAddress.getAddress().getCanonicalHostName(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address2);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.serverSocketFactory = serverSocketFactory }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_serverSocketFactory")
    public final void -deprecated_serverSocketFactory(@NotNull ServerSocketFactory serverSocketFactory) {
        Intrinsics.checkNotNullParameter(serverSocketFactory, "serverSocketFactory");
        MockWebServer $this$setServerSocketFactory_u24lambda_u244 = this;
        boolean bl = false;
        $this$setServerSocketFactory_u24lambda_u244.setServerSocketFactory(serverSocketFactory);
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
        Intrinsics.checkNotNull(httpUrl);
        return httpUrl;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.bodyLimit = bodyLimit }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_bodyLimit")
    public final void -deprecated_bodyLimit(long bodyLimit) {
        MockWebServer $this$setBodyLimit_u24lambda_u245 = this;
        boolean bl = false;
        $this$setBodyLimit_u24lambda_u245.bodyLimit = bodyLimit;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.protocolNegotiationEnabled = protocolNegotiationEnabled }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocolNegotiationEnabled")
    public final void -deprecated_protocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        MockWebServer $this$setProtocolNegotiationEnabled_u24lambda_u246 = this;
        boolean bl = false;
        $this$setProtocolNegotiationEnabled_u24lambda_u246.protocolNegotiationEnabled = protocolNegotiationEnabled;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.protocols = protocols }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocols")
    public final void -deprecated_protocols(@NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter(protocols, "protocols");
        MockWebServer $this$setProtocols_u24lambda_u247 = this;
        boolean bl = false;
        $this$setProtocols_u24lambda_u247.setProtocols(protocols);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="protocols", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocols")
    @NotNull
    public final List<Protocol> -deprecated_protocols() {
        return this.protocols;
    }

    public final void useHttps(@NotNull SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        Intrinsics.checkNotNullParameter(sslSocketFactory, "sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public final void noClientAuth() {
        this.clientAuth = 0;
    }

    public final void requestClientAuth() {
        this.clientAuth = 1;
    }

    public final void requireClientAuth() {
        this.clientAuth = 2;
    }

    @NotNull
    public final RecordedRequest takeRequest() throws InterruptedException {
        RecordedRequest recordedRequest = this.requestQueue.take();
        Intrinsics.checkNotNullExpressionValue(recordedRequest, "requestQueue.take()");
        return recordedRequest;
    }

    @Nullable
    public final RecordedRequest takeRequest(long timeout2, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        return this.requestQueue.poll(timeout2, unit);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="requestCount", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_requestCount")
    public final int -deprecated_requestCount() {
        return this.getRequestCount();
    }

    public final void enqueue(@NotNull MockResponse response2) {
        Intrinsics.checkNotNullParameter(response2, "response");
        Dispatcher dispatcher = this.dispatcher;
        Intrinsics.checkNotNull(dispatcher, "null cannot be cast to non-null type okhttp3.mockwebserver.QueueDispatcher");
        ((QueueDispatcher)dispatcher).enqueueResponse(response2.clone());
    }

    @JvmOverloads
    public final void start(int port2) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkNotNullExpressionValue(inetAddress, "getByName(\"localhost\")");
        this.start(inetAddress, port2);
    }

    public static /* synthetic */ void start$default(MockWebServer mockWebServer, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockWebServer.start(n);
    }

    public final void start(@NotNull InetAddress inetAddress, int port2) throws IOException {
        Intrinsics.checkNotNullParameter(inetAddress, "inetAddress");
        this.start(new InetSocketAddress(inetAddress, port2));
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void start(InetSocketAddress inetSocketAddress) throws IOException {
        void name$iv;
        void $this$iv;
        if (!(!this.started)) {
            boolean $i$a$-require-MockWebServer$start$22 = false;
            String $i$a$-require-MockWebServer$start$22 = "start() already called";
            throw new IllegalArgumentException($i$a$-require-MockWebServer$start$22.toString());
        }
        this.started = true;
        this.inetSocketAddress = inetSocketAddress;
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        Intrinsics.checkNotNull(serverSocketFactory);
        ServerSocket serverSocket = this.serverSocket = serverSocketFactory.createServerSocket();
        Intrinsics.checkNotNull(serverSocket);
        serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        ServerSocket serverSocket2 = this.serverSocket;
        Intrinsics.checkNotNull(serverSocket2);
        serverSocket2.bind(inetSocketAddress, 50);
        ServerSocket serverSocket3 = this.serverSocket;
        Intrinsics.checkNotNull(serverSocket3);
        this.portField = serverSocket3.getLocalPort();
        TaskQueue taskQueue = this.taskRunner.newQueue();
        String $i$a$-require-MockWebServer$start$22 = "MockWebServer " + this.portField;
        boolean cancelable$iv = false;
        long delayNanos$iv = 0L;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task((String)name$iv, cancelable$iv, this){
            final /* synthetic */ MockWebServer this$0;
            {
                this.this$0 = mockWebServer;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " starting to accept connections");
                    MockWebServer.access$acceptConnections(this.this$0);
                }
                catch (Throwable e) {
                    MockWebServer.access$getLogger$cp().log(Level.WARNING, this.this$0 + " failed unexpectedly", e);
                }
                ServerSocket serverSocket = MockWebServer.access$getServerSocket$p(this.this$0);
                if (serverSocket != null) {
                    Util.closeQuietly(serverSocket);
                }
                Iterator<E> openClientSocket = MockWebServer.access$getOpenClientSockets$p(this.this$0).iterator();
                while (openClientSocket.hasNext()) {
                    E e = openClientSocket.next();
                    Intrinsics.checkNotNullExpressionValue(e, "openClientSocket.next()");
                    Util.closeQuietly((Socket)e);
                    openClientSocket.remove();
                }
                Iterator<E> httpConnection = MockWebServer.access$getOpenConnections$p(this.this$0).iterator();
                while (httpConnection.hasNext()) {
                    E e = httpConnection.next();
                    Intrinsics.checkNotNullExpressionValue(e, "httpConnection.next()");
                    Util.closeQuietly((Closeable)e);
                    httpConnection.remove();
                }
                this.this$0.getDispatcher().shutdown();
                return -1L;
            }
        }, delayNanos$iv);
    }

    private final void acceptConnections() throws Exception {
        while (true) {
            Socket socket = null;
            try {
                ServerSocket serverSocket = this.serverSocket;
                Intrinsics.checkNotNull(serverSocket);
                Socket socket2 = serverSocket.accept();
                Intrinsics.checkNotNullExpressionValue(socket2, "serverSocket!!.accept()");
                socket = socket2;
            }
            catch (SocketException e) {
                logger.fine(this + " done accepting connections: " + e.getMessage());
                return;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                this.dispatchBookkeepingRequest(0, socket);
                socket.close();
                continue;
            }
            this.openClientSockets.add(socket);
            this.serveConnection(socket);
        }
    }

    public final synchronized void shutdown() throws IOException {
        if (!this.started) {
            return;
        }
        if (!(this.serverSocket != null)) {
            boolean $i$a$-require-MockWebServer$shutdown$22 = false;
            String $i$a$-require-MockWebServer$shutdown$22 = "shutdown() before start()";
            throw new IllegalArgumentException($i$a$-require-MockWebServer$shutdown$22.toString());
        }
        ServerSocket serverSocket = this.serverSocket;
        Intrinsics.checkNotNull(serverSocket);
        serverSocket.close();
        for (TaskQueue queue : this.taskRunner.activeQueues()) {
            if (queue.idleLatch().await(5L, TimeUnit.SECONDS)) continue;
            throw new IOException("Gave up waiting for queue to shut down");
        }
        this.taskRunnerBackend.shutdown();
    }

    @Override
    protected synchronized void after() {
        try {
            this.shutdown();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "MockWebServer shutdown failed", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serveConnection(Socket raw) {
        void name$iv;
        void $this$iv;
        TaskQueue taskQueue = this.taskRunner.newQueue();
        String string = "MockWebServer " + raw.getRemoteSocketAddress();
        boolean cancelable$iv = false;
        long delayNanos$iv = 0L;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task((String)name$iv, cancelable$iv, this, raw){
            final /* synthetic */ MockWebServer this$0;
            final /* synthetic */ Socket $raw$inlined;
            {
                this.this$0 = mockWebServer;
                this.$raw$inlined = socket;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.new SocketHandler(this.$raw$inlined).handle();
                }
                catch (IOException e) {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " connection from " + this.$raw$inlined.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    MockWebServer.access$getLogger$cp().log(Level.SEVERE, this.this$0 + " connection from " + this.$raw$inlined.getInetAddress() + " crashed", e);
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    private final void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{UNTRUSTED_TRUST_MANAGER};
        context.init(null, trustManagerArray, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        Socket socket = sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        Intrinsics.checkNotNull(socket, "null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        SSLSocket socket2 = (SSLSocket)socket;
        try {
            socket2.startHandshake();
            throw new AssertionError();
        }
        catch (IOException iOException) {
            socket2.close();
            return;
        }
    }

    private final void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        RecordedRequest request2 = new RecordedRequest("", Headers.Companion.of(new String[0]), CollectionsKt.emptyList(), 0L, new Buffer(), sequenceNumber, socket, null, 128, null);
        this.atomicRequestCount.incrementAndGet();
        this.requestQueue.add(request2);
        this.dispatcher.dispatch(request2);
    }

    private final RecordedRequest readRequest(Socket socket, BufferedSource source2, BufferedSink sink2, int sequenceNumber) throws IOException {
        String request2 = null;
        request2 = "";
        Headers.Builder headers2 = new Headers.Builder();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        List chunkSizes = new ArrayList();
        IOException failure = null;
        try {
            String header2;
            request2 = source2.readUtf8LineStrict();
            if (((CharSequence)request2).length() == 0) {
                throw new ProtocolException("no request because the stream is exhausted");
            }
            while (!(((CharSequence)(header2 = source2.readUtf8LineStrict())).length() == 0)) {
                String lowercaseHeader;
                Internal.addHeaderLenient(headers2, header2);
                String string = header2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                Intrinsics.checkNotNullExpressionValue(string.toLowerCase(locale), "this as java.lang.String).toLowerCase(locale)");
                if (contentLength == -1L && StringsKt.startsWith$default(lowercaseHeader, "content-length:", false, 2, null)) {
                    String string2 = header2.substring(15);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                    contentLength = Long.parseLong(((Object)StringsKt.trim((CharSequence)string2)).toString());
                }
                if (StringsKt.startsWith$default(lowercaseHeader, "transfer-encoding:", false, 2, null)) {
                    String string3 = lowercaseHeader.substring(18);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                    if (Intrinsics.areEqual(((Object)StringsKt.trim((CharSequence)string3)).toString(), "chunked")) {
                        chunked = true;
                    }
                }
                if (!StringsKt.startsWith$default(lowercaseHeader, "expect:", false, 2, null)) continue;
                String string4 = lowercaseHeader.substring(7);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                if (!StringsKt.equals(((Object)StringsKt.trim((CharSequence)string4)).toString(), "100-continue", true)) continue;
                expectContinue = true;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (expectContinue && socketPolicy == SocketPolicy.EXPECT_CONTINUE || socketPolicy == SocketPolicy.CONTINUE_ALWAYS) {
                sink2.writeUtf8("HTTP/1.1 100 Continue\r\n");
                sink2.writeUtf8("Content-Length: 0\r\n");
                sink2.writeUtf8("\r\n");
                sink2.flush();
            }
            boolean hasBody = false;
            MockResponse policy = this.dispatcher.peek();
            if (policy.getSocketPolicy() != SocketPolicy.DO_NOT_READ_REQUEST_BODY) {
                if (contentLength != -1L) {
                    hasBody = contentLength > 0L;
                    this.throttledTransfer(policy, socket, source2, Okio.buffer(requestBody), contentLength, true);
                } else if (chunked) {
                    hasBody = true;
                    while (true) {
                        int chunkSize;
                        if ((chunkSize = Integer.parseInt(((Object)StringsKt.trim((CharSequence)source2.readUtf8LineStrict())).toString(), CharsKt.checkRadix(16))) == 0) {
                            this.readEmptyLine(source2);
                            break;
                        }
                        chunkSizes.add(chunkSize);
                        this.throttledTransfer(policy, socket, source2, Okio.buffer(requestBody), chunkSize, true);
                        this.readEmptyLine(source2);
                    }
                }
            }
            String method2 = StringsKt.substringBefore$default(request2, ' ', null, 2, null);
            if (!(!hasBody || HttpMethod.permitsRequestBody(method2))) {
                boolean bl = false;
                String string = "Request must not have a body: " + request2;
                throw new IllegalArgumentException(string.toString());
            }
        }
        catch (IOException e) {
            failure = e;
        }
        return new RecordedRequest(request2, headers2.build(), chunkSizes, requestBody.getReceivedByteCount$mockwebserver(), requestBody.getBuffer$mockwebserver(), sequenceNumber, socket, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleWebSocketUpgrade(Socket socket, BufferedSource source2, BufferedSink sink2, RecordedRequest request2, MockResponse response2) throws IOException {
        String key2;
        String string = key2 = request2.getHeader("Sec-WebSocket-Key");
        Intrinsics.checkNotNull(string);
        response2.setHeader("Sec-WebSocket-Accept", WebSocketProtocol.INSTANCE.acceptHeader(string));
        this.writeHttpResponse(socket, sink2, response2);
        String scheme2 = request2.getTlsVersion() != null ? "https" : "http";
        String authority = request2.getHeader("Host");
        Request fancyRequest = new Request.Builder().url(scheme2 + "://" + authority + '/').headers(request2.getHeaders()).build();
        char[] cArray = new char[]{' '};
        List statusParts = StringsKt.split$default((CharSequence)response2.getStatus(), cArray, false, 3, 2, null);
        Response fancyResponse = new Response.Builder().code(Integer.parseInt((String)statusParts.get(1))).message((String)statusParts.get(2)).headers(response2.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        CountDownLatch connectionClose = new CountDownLatch(1);
        RealWebSocket.Streams streams2 = new RealWebSocket.Streams(source2, sink2, connectionClose){
            final /* synthetic */ CountDownLatch $connectionClose;
            {
                this.$connectionClose = $connectionClose;
                super(false, $source, $sink);
            }

            public void close() {
                this.$connectionClose.countDown();
            }
        };
        WebSocketListener webSocketListener = response2.getWebSocketListener();
        Intrinsics.checkNotNull(webSocketListener);
        RealWebSocket webSocket2 = new RealWebSocket(this.taskRunner, fancyRequest, webSocketListener, new SecureRandom(), 0L, WebSocketExtensions.Companion.parse(response2.getHeaders()), 0L);
        WebSocketListener webSocketListener2 = response2.getWebSocketListener();
        Intrinsics.checkNotNull(webSocketListener2);
        webSocketListener2.onOpen(webSocket2, fancyResponse);
        StringBuilder stringBuilder = new StringBuilder().append("MockWebServer WebSocket ");
        String string2 = request2.getPath();
        Intrinsics.checkNotNull(string2);
        String name = stringBuilder.append(string2).toString();
        webSocket2.initReaderAndWriter(name, streams2);
        try {
            webSocket2.loopReader();
            connectionClose.await();
        }
        catch (IOException e) {
            webSocket2.failWebSocket(e, null);
        }
        finally {
            Util.closeQuietly(source2);
        }
    }

    private final void writeHttpResponse(Socket socket, BufferedSink sink2, MockResponse response2) throws IOException {
        this.sleepIfDelayed(response2.getHeadersDelay(TimeUnit.MILLISECONDS));
        sink2.writeUtf8(response2.getStatus());
        sink2.writeUtf8("\r\n");
        this.writeHeaders(sink2, response2.getHeaders());
        Buffer buffer = response2.getBody();
        if (buffer == null) {
            return;
        }
        Buffer body2 = buffer;
        this.sleepIfDelayed(response2.getBodyDelay(TimeUnit.MILLISECONDS));
        this.throttledTransfer(response2, socket, body2, sink2, body2.size(), false);
        if (StringsKt.equals("chunked", response2.getHeaders().get("Transfer-Encoding"), true)) {
            this.writeHeaders(sink2, response2.getTrailers());
        }
    }

    private final void writeHeaders(BufferedSink sink2, Headers headers2) throws IOException {
        for (Pair<String, String> pair : headers2) {
            String name = pair.component1();
            String value = pair.component2();
            sink2.writeUtf8(name);
            sink2.writeUtf8(": ");
            sink2.writeUtf8(value);
            sink2.writeUtf8("\r\n");
        }
        sink2.writeUtf8("\r\n");
        sink2.flush();
    }

    private final void sleepIfDelayed(long delayMs) {
        if (delayMs != 0L) {
            Thread.sleep(delayMs);
        }
    }

    private final void throttledTransfer(MockResponse policy, Socket socket, BufferedSource source2, BufferedSink sink2, long byteCount, boolean isRequest) throws IOException {
        boolean disconnectHalfway;
        long byteCountNum = byteCount;
        if (byteCountNum == 0L) {
            return;
        }
        Buffer buffer = new Buffer();
        long bytesPerPeriod = policy.getThrottleBytesPerPeriod();
        long periodDelayMs = policy.getThrottlePeriod(TimeUnit.MILLISECONDS);
        long halfByteCount = byteCountNum / (long)2;
        boolean bl = isRequest ? policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_REQUEST_BODY : (disconnectHalfway = policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
        while (!socket.isClosed()) {
            long read2;
            for (long b2 = 0L; b2 < bytesPerPeriod; b2 += read2) {
                long toRead = Math.min(byteCountNum, bytesPerPeriod - b2);
                if (disconnectHalfway) {
                    toRead = Math.min(toRead, byteCountNum - halfByteCount);
                }
                if ((read2 = source2.read(buffer, toRead)) == -1L) {
                    return;
                }
                sink2.write(buffer, read2);
                sink2.flush();
                if (!disconnectHalfway || (byteCountNum -= read2) != halfByteCount) continue;
                socket.close();
                return;
            }
            this.sleepIfDelayed(periodDelayMs);
        }
    }

    private final void readEmptyLine(BufferedSource source2) throws IOException {
        String line = source2.readUtf8LineStrict();
        if (!(((CharSequence)line).length() == 0)) {
            boolean bl = false;
            String string = "Expected empty but was: " + line;
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        return "MockWebServer[" + this.portField + ']';
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockWebServer.start$default(this, 0, 1, null);
    }

    public static final /* synthetic */ void access$acceptConnections(MockWebServer $this) {
        $this.acceptConnections();
    }

    public static final /* synthetic */ ServerSocket access$getServerSocket$p(MockWebServer $this) {
        return $this.serverSocket;
    }

    static {
        MwsDuplexAccess.instance = new MwsDuplexAccess(){

            public void setBody(@NotNull MockResponse mockResponse, @NotNull DuplexResponseBody duplexResponseBody) {
                Intrinsics.checkNotNullParameter(mockResponse, "mockResponse");
                Intrinsics.checkNotNullParameter(duplexResponseBody, "duplexResponseBody");
                mockResponse.setBody(duplexResponseBody);
            }
        };
        UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

            @NotNull
            public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                Intrinsics.checkNotNullParameter(chain, "chain");
                Intrinsics.checkNotNullParameter(authType, "authType");
                throw new CertificateException();
            }

            @NotNull
            public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                Intrinsics.checkNotNullParameter(chain, "chain");
                Intrinsics.checkNotNullParameter(authType, "authType");
                throw new AssertionError();
            }

            @NotNull
            public X509Certificate[] getAcceptedIssuers() {
                throw new AssertionError();
            }
        };
        logger = Logger.getLogger(MockWebServer.class.getName());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/mockwebserver/MockWebServer$Companion;", "", "()V", "CLIENT_AUTH_NONE", "", "CLIENT_AUTH_REQUESTED", "CLIENT_AUTH_REQUIRED", "UNTRUSTED_TRUST_MANAGER", "okhttp3/mockwebserver/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1", "Lokhttp3/mockwebserver/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mockwebserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lokhttp3/mockwebserver/MockWebServer$Http2SocketHandler;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "socket", "Ljava/net/Socket;", "protocol", "Lokhttp3/Protocol;", "(Lokhttp3/mockwebserver/MockWebServer;Ljava/net/Socket;Lokhttp3/Protocol;)V", "sequenceNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "onStream", "", "stream", "Lokhttp3/internal/http2/Http2Stream;", "pushPromises", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "promises", "", "Lokhttp3/mockwebserver/PushPromise;", "readRequest", "writeResponse", "response", "Lokhttp3/mockwebserver/MockResponse;", "mockwebserver"})
    @SourceDebugExtension(value={"SMAP\nMockWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServer.kt\nokhttp3/mockwebserver/MockWebServer$Http2SocketHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1168:1\n1855#2,2:1169\n*S KotlinDebug\n*F\n+ 1 MockWebServer.kt\nokhttp3/mockwebserver/MockWebServer$Http2SocketHandler\n*L\n1029#1:1169,2\n*E\n"})
    private final class Http2SocketHandler
    extends Http2Connection.Listener {
        @NotNull
        private final Socket socket;
        @NotNull
        private final Protocol protocol;
        @NotNull
        private final AtomicInteger sequenceNumber;

        public Http2SocketHandler(@NotNull Socket socket, Protocol protocol) {
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
            this.socket = socket;
            this.protocol = protocol;
            this.sequenceNumber = new AtomicInteger();
        }

        @Override
        public void onStream(@NotNull Http2Stream stream) throws IOException {
            Intrinsics.checkNotNullParameter(stream, "stream");
            MockResponse peekedResponse = MockWebServer.this.getDispatcher().peek();
            if (peekedResponse.getSocketPolicy() == SocketPolicy.RESET_STREAM_AT_START) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber.getAndIncrement(), this.socket);
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(peekedResponse.getHttp2ErrorCode());
                Intrinsics.checkNotNull((Object)errorCode);
                stream.close(errorCode, null);
                return;
            }
            RecordedRequest request2 = this.readRequest(stream);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request2);
            if (request2.getFailure() != null) {
                return;
            }
            MockResponse response2 = MockWebServer.this.getDispatcher().dispatch(request2);
            SocketPolicy socketPolicy = response2.getSocketPolicy();
            if (socketPolicy == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                this.socket.close();
                return;
            }
            this.writeResponse(stream, request2, response2);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request2 + " and responded: " + response2 + " protocol is " + (Object)((Object)this.protocol));
            }
            switch (WhenMappings.$EnumSwitchMapping$0[socketPolicy.ordinal()]) {
                case 1: {
                    stream.getConnection().shutdown(ErrorCode.NO_ERROR);
                    break;
                }
                case 2: {
                    ErrorCode errorCode = ErrorCode.Companion.fromHttp2(response2.getHttp2ErrorCode());
                    Intrinsics.checkNotNull((Object)errorCode);
                    stream.close(errorCode, null);
                }
            }
        }

        private final RecordedRequest readRequest(Http2Stream stream) throws IOException {
            Headers streamHeaders = stream.takeHeaders();
            Headers.Builder httpHeaders = new Headers.Builder();
            String method2 = "<:method omitted>";
            String path = "<:path omitted>";
            boolean readBody = true;
            for (Pair<String, String> pair : streamHeaders) {
                String name = pair.component1();
                String value = pair.component2();
                if (Intrinsics.areEqual(name, ":method")) {
                    method2 = value;
                } else if (Intrinsics.areEqual(name, ":path")) {
                    path = value;
                } else if (this.protocol == Protocol.HTTP_2 || this.protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    httpHeaders.add(name, value);
                } else {
                    throw new IllegalStateException();
                }
                if (!Intrinsics.areEqual(name, "expect") || !StringsKt.equals(value, "100-continue", true)) continue;
                readBody = false;
            }
            Headers headers2 = httpHeaders.build();
            MockResponse peek = MockWebServer.this.getDispatcher().peek();
            if (!readBody && peek.getSocketPolicy() == SocketPolicy.EXPECT_CONTINUE) {
                List<Header> continueHeaders = CollectionsKt.listOf(new Header(Header.RESPONSE_STATUS, ByteString.Companion.encodeUtf8("100 Continue")));
                stream.writeHeaders(continueHeaders, false, true);
                stream.getConnection().flush();
                readBody = true;
            }
            Iterable $this$forEach$iv = peek.getInformationalResponses$mockwebserver();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MockResponse it = (MockResponse)element$iv;
                boolean bl = false;
                List<Header> informationalHeader = CollectionsKt.listOf(new Header(Header.RESPONSE_STATUS, StringsKt.replace$default(it.getStatus(), "HTTP/1.1 ", "", false, 4, null)));
                stream.writeHeaders(informationalHeader, false, true);
                stream.getConnection().flush();
            }
            Buffer body2 = new Buffer();
            String requestLine = method2 + ' ' + path + " HTTP/1.1";
            IOException exception = null;
            if (readBody && !peek.isDuplex() && peek.getSocketPolicy() != SocketPolicy.DO_NOT_READ_REQUEST_BODY) {
                try {
                    String contentLengthString;
                    String string = contentLengthString = headers2.get("content-length");
                    long byteCount = string != null ? Long.parseLong(string) : Long.MAX_VALUE;
                    MockWebServer.this.throttledTransfer(peek, this.socket, Okio.buffer(stream.getSource()), body2, byteCount, true);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            return new RecordedRequest(requestLine, headers2, CollectionsKt.emptyList(), body2.size(), body2, this.sequenceNumber.getAndIncrement(), this.socket, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeResponse(Http2Stream stream, RecordedRequest request2, MockResponse response2) throws IOException {
            Settings settings = response2.getSettings();
            stream.getConnection().setSettings(settings);
            if (response2.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            List http2Headers = new ArrayList();
            char[] cArray = new char[]{' '};
            List statusParts = StringsKt.split$default((CharSequence)response2.getStatus(), cArray, false, 3, 2, null);
            long headersDelayMs = response2.getHeadersDelay(TimeUnit.MILLISECONDS);
            long bodyDelayMs = response2.getBodyDelay(TimeUnit.MILLISECONDS);
            if (statusParts.size() < 2) {
                throw new AssertionError((Object)("Unexpected status: " + response2.getStatus()));
            }
            http2Headers.add(new Header(Header.RESPONSE_STATUS, (String)statusParts.get(1)));
            Headers headers2 = response2.getHeaders();
            for (Pair<String, String> pair : headers2) {
                String name = pair.component1();
                String value = pair.component2();
                http2Headers.add(new Header(name, value));
            }
            Headers trailers = response2.getTrailers();
            MockWebServer.this.sleepIfDelayed(headersDelayMs);
            Buffer body2 = response2.getBody();
            boolean outFinished = body2 == null && response2.getPushPromises().isEmpty() && !response2.isDuplex();
            boolean flushHeaders = body2 == null || bodyDelayMs != 0L;
            if (!(!outFinished || trailers.size() == 0)) {
                boolean bl = false;
                String string = "unsupported: no body and non-empty trailers " + trailers;
                throw new IllegalArgumentException(string.toString());
            }
            stream.writeHeaders(http2Headers, outFinished, flushHeaders);
            if (trailers.size() > 0) {
                stream.enqueueTrailers(trailers);
            }
            this.pushPromises(stream, request2, response2.getPushPromises());
            if (body2 != null) {
                Closeable closeable = Okio.buffer(stream.getSink());
                MockWebServer mockWebServer = MockWebServer.this;
                Throwable throwable = null;
                try {
                    BufferedSink sink2 = (BufferedSink)closeable;
                    boolean bl = false;
                    mockWebServer.sleepIfDelayed(bodyDelayMs);
                    mockWebServer.throttledTransfer(response2, this.socket, body2, sink2, body2.size(), false);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            } else if (response2.isDuplex()) {
                DuplexResponseBody duplexResponseBody = response2.getDuplexResponseBody();
                Intrinsics.checkNotNull(duplexResponseBody);
                DuplexResponseBody duplexResponseBody2 = duplexResponseBody;
                duplexResponseBody2.onRequest(request2, stream);
            } else if (!outFinished) {
                stream.close(ErrorCode.NO_ERROR, null);
            }
        }

        private final void pushPromises(Http2Stream stream, RecordedRequest request2, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                List pushedHeaders = new ArrayList();
                pushedHeaders.add(new Header(Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.path()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.method()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.path()));
                Headers pushPromiseHeaders = pushPromise.headers();
                for (Pair<String, String> pair : pushPromiseHeaders) {
                    String name = pair.component1();
                    String value = pair.component2();
                    pushedHeaders.add(new Header(name, value));
                }
                String requestLine = pushPromise.method() + ' ' + pushPromise.path() + " HTTP/1.1";
                List chunkSizes = CollectionsKt.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.headers(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket, null, 128, null));
                boolean hasBody = pushPromise.response().getBody() != null;
                Http2Stream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, request2, pushPromise.response());
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SocketPolicy.values().length];
                try {
                    nArray[SocketPolicy.DISCONNECT_AT_END.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketPolicy.DO_NOT_READ_REQUEST_BODY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/mockwebserver/MockWebServer$SocketHandler;", "", "raw", "Ljava/net/Socket;", "(Lokhttp3/mockwebserver/MockWebServer;Ljava/net/Socket;)V", "sequenceNumber", "", "createTunnel", "", "handle", "processOneRequest", "", "socket", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "mockwebserver"})
    @SourceDebugExtension(value={"SMAP\nMockWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServer.kt\nokhttp3/mockwebserver/MockWebServer$SocketHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1168:1\n1#2:1169\n*E\n"})
    public final class SocketHandler {
        @NotNull
        private final Socket raw;
        private int sequenceNumber;

        public SocketHandler(Socket raw) {
            Intrinsics.checkNotNullParameter(raw, "raw");
            this.raw = raw;
        }

        public final void handle() throws Exception {
            SocketPolicy socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
            Protocol protocol = Protocol.HTTP_1_1;
            Socket socket = null;
            if (MockWebServer.this.sslSocketFactory != null) {
                if (MockWebServer.this.tunnelProxy) {
                    this.createTunnel();
                }
                if (socketPolicy == SocketPolicy.FAIL_HANDSHAKE) {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, this.raw);
                    MockWebServer.this.processHandshakeFailure(this.raw);
                    return;
                }
                SSLSocketFactory sSLSocketFactory = MockWebServer.this.sslSocketFactory;
                Intrinsics.checkNotNull(sSLSocketFactory);
                Socket socket2 = sSLSocketFactory.createSocket(this.raw, this.raw.getInetAddress().getHostAddress(), this.raw.getPort(), true);
                Intrinsics.checkNotNullExpressionValue(socket2, "sslSocketFactory!!.creat\u2026          raw.port, true)");
                socket = socket2;
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(false);
                if (MockWebServer.this.clientAuth == 2) {
                    sslSocket.setNeedClientAuth(true);
                } else if (MockWebServer.this.clientAuth == 1) {
                    sslSocket.setWantClientAuth(true);
                }
                MockWebServer.this.openClientSockets.add(socket);
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    Platform.Companion.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.protocols());
                }
                sslSocket.startHandshake();
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    String protocolString;
                    String string = protocolString = Platform.Companion.get().getSelectedProtocol(sslSocket);
                    protocol = string != null ? Protocol.Companion.get(string) : Protocol.HTTP_1_1;
                    Platform.Companion.get().afterHandshake(sslSocket);
                }
                MockWebServer.this.openClientSockets.remove(this.raw);
            } else if (MockWebServer.this.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                socket = this.raw;
                protocol = Protocol.H2_PRIOR_KNOWLEDGE;
            } else {
                socket = this.raw;
            }
            if (socketPolicy == SocketPolicy.STALL_SOCKET_AT_START) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, socket);
                return;
            }
            if (protocol == Protocol.HTTP_2 || protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                Http2SocketHandler http2SocketHandler = new Http2SocketHandler(socket, protocol);
                Http2Connection connection = Http2Connection.Builder.socket$default(new Http2Connection.Builder(false, MockWebServer.this.taskRunner), socket, null, null, null, 14, null).listener(http2SocketHandler).build();
                Http2Connection.start$default(connection, false, MockWebServer.this.taskRunner, 1, null);
                MockWebServer.this.openConnections.add(connection);
                MockWebServer.this.openClientSockets.remove(socket);
                return;
            }
            if (protocol != Protocol.HTTP_1_1) {
                throw new AssertionError();
            }
            BufferedSource source2 = Okio.buffer(Okio.source(socket));
            BufferedSink sink2 = Okio.buffer(Okio.sink(socket));
            while (this.processOneRequest(socket, source2, sink2)) {
            }
            if (this.sequenceNumber == 0) {
                logger.warning(MockWebServer.this + " connection from " + this.raw.getInetAddress() + " didn't make a request");
            }
            socket.close();
            MockWebServer.this.openClientSockets.remove(socket);
        }

        private final void createTunnel() throws IOException, InterruptedException {
            SocketPolicy socketPolicy;
            BufferedSource source2 = Okio.buffer(Okio.source(this.raw));
            BufferedSink sink2 = Okio.buffer(Okio.sink(this.raw));
            do {
                socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
                if (this.processOneRequest(this.raw, source2, sink2)) continue;
                boolean bl = false;
                String string = "Tunnel without any CONNECT!";
                throw new IllegalStateException(string.toString());
            } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
        }

        private final boolean processOneRequest(Socket socket, BufferedSource source2, BufferedSink sink2) throws IOException, InterruptedException {
            boolean responseWantsWebSockets;
            if (source2.exhausted()) {
                return false;
            }
            RecordedRequest request2 = MockWebServer.this.readRequest(socket, source2, sink2, this.sequenceNumber);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request2);
            if (request2.getFailure() != null) {
                return false;
            }
            MockResponse response2 = MockWebServer.this.getDispatcher().dispatch(request2);
            if (response2.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                socket.close();
                return false;
            }
            if (response2.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                if (source2.exhausted()) {
                    return false;
                }
                throw new ProtocolException("unexpected data");
            }
            boolean reuseSocket = true;
            boolean requestWantsWebSockets = StringsKt.equals("Upgrade", request2.getHeader("Connection"), true) && StringsKt.equals("websocket", request2.getHeader("Upgrade"), true);
            boolean bl = responseWantsWebSockets = response2.getWebSocketListener() != null;
            if (requestWantsWebSockets && responseWantsWebSockets) {
                MockWebServer.this.handleWebSocketUpgrade(socket, source2, sink2, request2, response2);
                reuseSocket = false;
            } else {
                MockWebServer.this.writeHttpResponse(socket, sink2, response2);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request2 + " and responded: " + response2);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[response2.getSocketPolicy().ordinal()]) {
                case 1: 
                case 2: {
                    socket.close();
                    return false;
                }
                case 3: {
                    socket.shutdownInput();
                    break;
                }
                case 4: {
                    socket.shutdownOutput();
                    break;
                }
                case 5: {
                    MockWebServer.this.shutdown();
                }
            }
            int n = this.sequenceNumber;
            this.sequenceNumber = n + 1;
            return reuseSocket;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SocketPolicy.values().length];
                try {
                    nArray[SocketPolicy.DISCONNECT_AT_END.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketPolicy.DO_NOT_READ_REQUEST_BODY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketPolicy.SHUTDOWN_INPUT_AT_END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketPolicy.SHUTDOWN_OUTPUT_AT_END.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketPolicy.SHUTDOWN_SERVER_AFTER_RESPONSE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/mockwebserver/MockWebServer$TruncatingBuffer;", "Lokio/Sink;", "remainingByteCount", "", "(J)V", "buffer", "Lokio/Buffer;", "getBuffer$mockwebserver", "()Lokio/Buffer;", "receivedByteCount", "getReceivedByteCount$mockwebserver", "()J", "setReceivedByteCount$mockwebserver", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "byteCount", "mockwebserver"})
    private static final class TruncatingBuffer
    implements Sink {
        private long remainingByteCount;
        @NotNull
        private final Buffer buffer;
        private long receivedByteCount;

        public TruncatingBuffer(long remainingByteCount) {
            this.remainingByteCount = remainingByteCount;
            this.buffer = new Buffer();
        }

        @NotNull
        public final Buffer getBuffer$mockwebserver() {
            return this.buffer;
        }

        public final long getReceivedByteCount$mockwebserver() {
            return this.receivedByteCount;
        }

        public final void setReceivedByteCount$mockwebserver(long l) {
            this.receivedByteCount = l;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) throws IOException {
            long toSkip;
            Intrinsics.checkNotNullParameter(source2, "source");
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source2.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source2.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

