/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.Charsets;

public class ReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    @Deprecated
    public ReversedLinesFileReader(File file2) throws IOException {
        this(file2, 4096, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file2, Charset charset) throws IOException {
        this(file2, 4096, charset);
    }

    public ReversedLinesFileReader(File file2, int blockSize, Charset encoding) throws IOException {
        this.blockSize = blockSize;
        this.encoding = encoding;
        Charset charset = Charsets.toCharset(encoding);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        float maxBytesPerChar = charsetEncoder.maxBytesPerChar();
        if (maxBytesPerChar == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset == Charsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("Shift_JIS") || charset == Charset.forName("windows-31j") || charset == Charset.forName("x-windows-949") || charset == Charset.forName("gbk") || charset == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (charset == Charsets.UTF_16BE || charset == Charsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (charset == Charsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + encoding + " is not supported yet (feel free to " + "submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(encoding), "\n".getBytes(encoding), "\r".getBytes(encoding)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.randomAccessFile = new RandomAccessFile(file2, "r");
        this.totalByteLength = this.randomAccessFile.length();
        int lastBlockLength = (int)(this.totalByteLength % (long)blockSize);
        if (lastBlockLength > 0) {
            this.totalBlockCount = this.totalByteLength / (long)blockSize + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)blockSize;
            if (this.totalByteLength > 0L) {
                lastBlockLength = blockSize;
            }
        }
        this.currentFilePart = new FilePart(this.totalBlockCount, lastBlockLength, null);
    }

    public ReversedLinesFileReader(File file2, int blockSize, String encoding) throws IOException {
        this(file2, blockSize, Charsets.toCharset(encoding));
    }

    public String readLine() throws IOException {
        String line = this.currentFilePart.readLine();
        while (line == null) {
            this.currentFilePart = this.currentFilePart.rollOver();
            if (this.currentFilePart == null) break;
            line = this.currentFilePart.readLine();
        }
        if ("".equals(line) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            line = this.readLine();
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    private class FilePart {
        private final long no;
        private final byte[] data;
        private byte[] leftOver;
        private int currentLastBytePos;

        private FilePart(long no, int length, byte[] leftOverOfLastFilePart) throws IOException {
            this.no = no;
            int dataLength = length + (leftOverOfLastFilePart != null ? leftOverOfLastFilePart.length : 0);
            this.data = new byte[dataLength];
            long off = (no - 1L) * (long)ReversedLinesFileReader.this.blockSize;
            if (no > 0L) {
                ReversedLinesFileReader.this.randomAccessFile.seek(off);
                int countRead = ReversedLinesFileReader.this.randomAccessFile.read(this.data, 0, length);
                if (countRead != length) {
                    throw new IllegalStateException("Count of requested bytes and actually read bytes don't match");
                }
            }
            if (leftOverOfLastFilePart != null) {
                System.arraycopy(leftOverOfLastFilePart, 0, this.data, length, leftOverOfLastFilePart.length);
            }
            this.currentLastBytePos = this.data.length - 1;
            this.leftOver = null;
        }

        private FilePart rollOver() throws IOException {
            if (this.currentLastBytePos > -1) {
                throw new IllegalStateException("Current currentLastCharPos unexpectedly positive... last readLine() should have returned something! currentLastCharPos=" + this.currentLastBytePos);
            }
            if (this.no > 1L) {
                return new FilePart(this.no - 1L, ReversedLinesFileReader.this.blockSize, this.leftOver);
            }
            if (this.leftOver != null) {
                throw new IllegalStateException("Unexpected leftover of the last block: leftOverOfThisFilePart=" + new String(this.leftOver, ReversedLinesFileReader.this.encoding));
            }
            return null;
        }

        private String readLine() throws IOException {
            String line = null;
            boolean isLastFilePart = this.no == 1L;
            int i2 = this.currentLastBytePos;
            while (i2 > -1) {
                if (!isLastFilePart && i2 < ReversedLinesFileReader.this.avoidNewlineSplitBufferSize) {
                    this.createLeftOver();
                    break;
                }
                int newLineMatchByteCount = this.getNewLineMatchByteCount(this.data, i2);
                if (newLineMatchByteCount > 0) {
                    int lineStart = i2 + 1;
                    int lineLengthBytes = this.currentLastBytePos - lineStart + 1;
                    if (lineLengthBytes < 0) {
                        throw new IllegalStateException("Unexpected negative line length=" + lineLengthBytes);
                    }
                    byte[] lineData = new byte[lineLengthBytes];
                    System.arraycopy(this.data, lineStart, lineData, 0, lineLengthBytes);
                    line = new String(lineData, ReversedLinesFileReader.this.encoding);
                    this.currentLastBytePos = i2 - newLineMatchByteCount;
                    break;
                }
                if ((i2 -= ReversedLinesFileReader.this.byteDecrement) >= 0) continue;
                this.createLeftOver();
                break;
            }
            if (isLastFilePart && this.leftOver != null) {
                line = new String(this.leftOver, ReversedLinesFileReader.this.encoding);
                this.leftOver = null;
            }
            return line;
        }

        private void createLeftOver() {
            int lineLengthBytes = this.currentLastBytePos + 1;
            if (lineLengthBytes > 0) {
                this.leftOver = new byte[lineLengthBytes];
                System.arraycopy(this.data, 0, this.leftOver, 0, lineLengthBytes);
            } else {
                this.leftOver = null;
            }
            this.currentLastBytePos = -1;
        }

        private int getNewLineMatchByteCount(byte[] data2, int i2) {
            for (byte[] newLineSequence : ReversedLinesFileReader.this.newLineSequences) {
                boolean match = true;
                for (int j = newLineSequence.length - 1; j >= 0; --j) {
                    int k = i2 + j - (newLineSequence.length - 1);
                    match &= k >= 0 && data2[k] == newLineSequence[j];
                }
                if (!match) continue;
                return newLineSequence.length;
            }
            return 0;
        }
    }
}

