/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.osjava.sj.loader.CustomSJProperties;
import org.osjava.sj.loader.IniSJProperties;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.SJProperties;
import org.osjava.sj.loader.XmlSJProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioBasedJndiLoader
extends JndiLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(NioBasedJndiLoader.class);

    public NioBasedJndiLoader(Hashtable env) {
        super(env);
    }

    public void load(File fileOrDirectory, Context ctxt, boolean preserveRootFileNameAsContextName) throws NamingException, IOException {
        if ((fileOrDirectory = new File(fileOrDirectory.getAbsolutePath())).isDirectory()) {
            this.loadDirectory(fileOrDirectory, fileOrDirectory.getPath(), ctxt, null, "");
        } else {
            this.loadFile(fileOrDirectory.toPath(), ctxt, null, preserveRootFileNameAsContextName);
        }
    }

    public void loadJar(File jarFile, String rootDir, Context ctxt, boolean preserveFileNameAsContextName) throws IOException {
        Path path = Paths.get(jarFile.toURI());
        try (FileSystem fs = FileSystems.newFileSystem(path, null);){
            Files.walkFileTree(fs.getPath(rootDir, new String[0]), new MySimpleFileVisitor(rootDir, ctxt, "", preserveFileNameAsContextName));
        }
    }

    private void loadFile(Path path, Context ctxt, Context parentCtxt, boolean preserveFileNameAsContextName) throws IOException, NamingException {
        LOGGER.debug("Loading {}", (Object)path);
        String parentName = path.getFileName().toString();
        parentName = this.handleColonReplacement(parentName);
        Context subContext = ctxt;
        Properties properties2 = this.toProperties(path);
        String subName = null;
        if (this.isNotNamespacedTypeDefinition(properties2)) {
            subName = FilenameUtils.getBaseName(parentName);
            parentCtxt = subContext;
        } else if (!FilenameUtils.getBaseName(parentName).equals("default")) {
            parentName = FilenameUtils.getBaseName(parentName);
            if (preserveFileNameAsContextName) {
                subContext = ctxt.createSubcontext(parentName);
                parentCtxt = ctxt;
            }
            subName = parentName;
        }
        this.load(properties2, subContext, parentCtxt, subName);
    }

    public Properties toProperties(Path path) throws IOException {
        SJProperties properties2 = path.getFileName().toString().endsWith(".xml") ? new XmlSJProperties() : (path.getFileName().toString().endsWith(".ini") ? new IniSJProperties() : new CustomSJProperties());
        properties2.setDelimiter((String)this.environment.get("org.osjava.sj.delimiter"));
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            properties2.load(stream);
            SJProperties sJProperties = properties2;
            return sJProperties;
        }
    }

    private void loadDirectory(File directory, String platformSpecificRootDir, Context ctxt, Context parentCtxt, String subName) throws NamingException, IOException {
        Files.walkFileTree(directory.toPath(), new MySimpleFileVisitor(platformSpecificRootDir, ctxt, "", false));
    }

    class MySimpleFileVisitor
    extends SimpleFileVisitor<Path> {
        private final String platformSpecificRootDir;
        private final Context ctxt;
        private final String subName;
        private final ArrayList<Context> contexts = new ArrayList();
        private final boolean preserveRootFileNameAsContextName;

        MySimpleFileVisitor(String platformSpecificRootDir, Context ctxt, String subName, boolean preserveRootFileNameAsContextName) {
            if (StringUtils.endsWith(platformSpecificRootDir, File.separator)) {
                platformSpecificRootDir = platformSpecificRootDir.substring(0, platformSpecificRootDir.length() - 1);
            }
            this.platformSpecificRootDir = platformSpecificRootDir;
            this.ctxt = ctxt;
            this.subName = subName;
            this.contexts.add(this.ctxt);
            this.preserveRootFileNameAsContextName = preserveRootFileNameAsContextName;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            LOGGER.debug("preVisitDirectory: {}", (Object)dir);
            String dirString = dir.toString();
            if (StringUtils.endsWith(dirString, File.separator)) {
                dirString = dirString.substring(0, dirString.length() - 1);
            }
            if (!this.platformSpecificRootDir.equals(dirString)) {
                try {
                    String[] parts = StringUtils.split(dirString, File.separatorChar);
                    String subCtxName = parts[parts.length - 1];
                    if (!subCtxName.equals(".svn") && !subCtxName.equals("CVS")) {
                        subCtxName = NioBasedJndiLoader.this.handleColonReplacement(subCtxName);
                        this.contexts.add(this.contexts.get(this.contexts.size() - 1).createSubcontext(subCtxName));
                    }
                }
                catch (NamingException e) {
                    LOGGER.error("", e);
                }
            }
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            try {
                if (path.toString().equals(this.platformSpecificRootDir)) {
                    NioBasedJndiLoader.this.loadFile(path, this.contexts.get(this.contexts.size() - 1), null, this.preserveRootFileNameAsContextName);
                } else {
                    NioBasedJndiLoader.this.loadFile(path, this.contexts.get(this.contexts.size() - 1), null, true);
                }
            }
            catch (NamingException e) {
                LOGGER.error("path: {} ctxt: {} subName: {}", path, this.ctxt, this.subName);
                LOGGER.error("", e);
            }
            return super.visitFile(path, attrs);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file2, IOException exc) throws IOException {
            LOGGER.debug("visitFileFailed: {}", (Object)file2);
            return super.visitFileFailed(file2, exc);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            LOGGER.debug("postVisitDirectory: {}", (Object)dir);
            if (!this.platformSpecificRootDir.equals(dir.toString())) {
                this.contexts.remove(this.contexts.size() - 1);
            }
            return super.postVisitDirectory(dir, exc);
        }
    }
}

