/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.checkerframework.checker.index.qual.Positive;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.internal.Nullness;

public class PgParameterMetaData
implements ParameterMetaData {
    private final BaseConnection connection;
    private final int[] oids;

    public PgParameterMetaData(BaseConnection connection, int[] oids) {
        this.connection = connection;
        this.oids = oids;
    }

    @Override
    public String getParameterClassName(@Positive int param2) throws SQLException {
        this.checkParamIndex(param2);
        return this.connection.getTypeInfo().getJavaClass(this.oids[param2 - 1]);
    }

    @Override
    public int getParameterCount() {
        return this.oids.length;
    }

    @Override
    public int getParameterMode(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return 1;
    }

    @Override
    public int getParameterType(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return this.connection.getTypeInfo().getSQLType(this.oids[param2 - 1]);
    }

    @Override
    public String getParameterTypeName(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return Nullness.castNonNull(this.connection.getTypeInfo().getPGType(this.oids[param2 - 1]));
    }

    @Override
    public int getPrecision(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return 0;
    }

    @Override
    public int getScale(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return 0;
    }

    @Override
    public int isNullable(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return 2;
    }

    @Override
    public boolean isSigned(int param2) throws SQLException {
        this.checkParamIndex(param2);
        return this.connection.getTypeInfo().isSigned(this.oids[param2 - 1]);
    }

    private void checkParamIndex(int param2) throws PSQLException {
        if (param2 < 1 || param2 > this.oids.length) {
            throw new PSQLException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", param2, this.oids.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

