/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.schedule;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ClazzLogDao;
import com.ustadmobile.core.schedule.ClazzLogCreatorKt;
import com.ustadmobile.core.schedule.ClazzLogExtKt;
import com.ustadmobile.core.schedule.ScheduleExtKt;
import com.ustadmobile.core.util.ext.LocalDateTimeExtKt;
import com.ustadmobile.door.util.SystemTimeKt;
import com.ustadmobile.lib.db.entities.ClazzLog;
import com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndAndTerminology;
import com.ustadmobile.lib.db.entities.Holiday;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.Schedule;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"createClazzLogs", "", "Lcom/ustadmobile/core/db/UmAppDatabase;", "fromTime", "", "toTime", "clazzFilter", "matchLocalFromDay", "", "core"})
@SourceDebugExtension(value={"SMAP\nClazzLogCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClazzLogCreator.kt\ncom/ustadmobile/core/schedule/ClazzLogCreatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,117:1\n1855#2:118\n1549#2:126\n1620#2,3:127\n766#2:130\n857#2,2:131\n766#2:133\n857#2,2:134\n1855#2,2:136\n1747#2,3:138\n1856#2:141\n372#3,7:119\n*S KotlinDebug\n*F\n+ 1 ClazzLogCreator.kt\ncom/ustadmobile/core/schedule/ClazzLogCreatorKt\n*L\n32#1:118\n65#1:126\n65#1:127,3\n78#1:130\n78#1:131,2\n100#1:133\n100#1:134,2\n104#1:136,2\n111#1:138,3\n32#1:141\n47#1:119,7\n*E\n"})
public final class ClazzLogCreatorKt {
    /*
     * WARNING - void declaration
     */
    public static final void createClazzLogs(@NotNull UmAppDatabase $this$createClazzLogs, long fromTime, long toTime, long clazzFilter, boolean matchLocalFromDay) {
        Intrinsics.checkNotNullParameter((Object)$this$createClazzLogs, (String)"<this>");
        Map holidayCalendarHolidayLists = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$createClazzLogs.clazzDao().findClazzesWithEffectiveHolidayCalendarAndFilter(clazzFilter);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            ClazzWithHolidayCalendarAndAndTerminology clazz = (ClazzWithHolidayCalendarAndAndTerminology)element$iv;
            boolean bl = false;
            List alreadyCreatedClazzLogs = ClazzLogDao.findByClazzUidWithinTimeRange$default((ClazzLogDao)$this$createClazzLogs.clazzLogDao(), (long)clazz.getClazzUid(), (long)fromTime, (long)toTime, (int)0, (int)0, (int)24, null);
            String string = clazz.getClazzTimeZone();
            if (string == null) {
                string = "UTC";
            }
            String effectiveTimeZoneId = string;
            TimeZone effectiveTimeZone = TimeZone.Companion.of(effectiveTimeZoneId);
            LocalDateTime fromLocalDateTime = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(fromTime), (TimeZone)effectiveTimeZone);
            DayOfWeek fromDayOfWeekLocalX = fromLocalDateTime.getDayOfWeek();
            HolidayCalendar holidayCalendar = clazz.getHolidayCalendar();
            long holCalendarUid = holidayCalendar != null ? holidayCalendar.getUmCalendarUid() : 0L;
            Map map2 = holidayCalendarHolidayLists;
            Long key$iv = holCalendarUid;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = $this$createClazzLogs.holidayDao().findByHolidayCalendaUid(holCalendarUid);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List clazzHolidayList = (List)object;
            for (Schedule schedule : $this$createClazzLogs.scheduleDao().findAllSchedulesByClazzUidAsList(clazz.getClazzUid())) {
                boolean bl3;
                Collection clazzLog2;
                block13: {
                    void $this$filterTo$iv$iv;
                    Object element$iv$iv;
                    void $this$filterTo$iv$iv2;
                    Object endInstant;
                    Object item$iv$iv2;
                    void $this$mapTo$iv$iv;
                    Pair<Instant, Instant> pair = ScheduleExtKt.nextOccurenceX(schedule, effectiveTimeZone, TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(fromTime), (TimeZone)effectiveTimeZone));
                    Instant scheduleNextStart = (Instant)pair.component1();
                    Instant scheduleNextEnd = (Instant)pair.component2();
                    if (scheduleNextStart.toEpochMilliseconds() >= toTime) continue;
                    LocalDateTime scheduleNextLocalDateTime = TimeZoneKt.toLocalDateTime((Instant)scheduleNextStart, (TimeZone)effectiveTimeZone);
                    if (matchLocalFromDay && scheduleNextLocalDateTime.getDayOfWeek() != fromDayOfWeekLocalX) continue;
                    Iterable $this$map$iv = clazzHolidayList;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it;
                        Holiday holiday = (Holiday)item$iv$iv2;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        Instant startInstant = TimeZoneKt.toInstant((LocalDateTime)LocalDateTimeExtKt.toLocalMidnight(TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(it.getHolStartTime()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()))), (TimeZone)effectiveTimeZone);
                        endInstant = TimeZoneKt.toInstant((LocalDateTime)LocalDateTimeExtKt.toLocalEndOfDay(TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(it.getHolEndTime()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()))), (TimeZone)effectiveTimeZone);
                        collection.add(new Pair((Object)it, (Object)new Pair((Object)startInstant, endInstant)));
                    }
                    List holidayAndDateTimeRange = (List)destination$iv$iv;
                    Iterable $this$filter$iv = holidayAndDateTimeRange;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    item$iv$iv2 = $this$filterTo$iv$iv2.iterator();
                    while (item$iv$iv2.hasNext()) {
                        element$iv$iv = item$iv$iv2.next();
                        Pair it = (Pair)element$iv$iv;
                        boolean bl5 = false;
                        endInstant = (Pair)it.getSecond();
                        Instant holStart = (Instant)endInstant.component1();
                        Instant holEnd = (Instant)endInstant.component2();
                        if (!(holStart.compareTo(scheduleNextStart) < 0 && holEnd.compareTo(scheduleNextEnd) > 0)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List overlappingHolidays = (List)destination$iv$iv2;
                    long clazzLogDate = scheduleNextStart.toEpochMilliseconds();
                    Collection $this$createClazzLogs_u24lambda_u247_u24lambda_u243 = destination$iv$iv2 = new ClazzLog();
                    boolean bl6 = false;
                    $this$createClazzLogs_u24lambda_u247_u24lambda_u243.setLogDate(clazzLogDate);
                    $this$createClazzLogs_u24lambda_u247_u24lambda_u243.setClazzLogClazzUid(clazz.getClazzUid());
                    $this$createClazzLogs_u24lambda_u247_u24lambda_u243.setClazzLogScheduleUid(schedule.getScheduleUid());
                    $this$createClazzLogs_u24lambda_u247_u24lambda_u243.setClazzLogUid(ClazzLogExtKt.generateUid((ClazzLog)$this$createClazzLogs_u24lambda_u247_u24lambda_u243));
                    $this$createClazzLogs_u24lambda_u247_u24lambda_u243.setClazzLogCancelled(!((Collection)overlappingHolidays).isEmpty());
                    if ($this$createClazzLogs_u24lambda_u247_u24lambda_u243.getClazzLogCancelled()) {
                        $this$createClazzLogs_u24lambda_u247_u24lambda_u243.setCancellationNote(CollectionsKt.joinToString$default((Iterable)overlappingHolidays, null, null, null, (int)0, null, (Function1)createClazzLogs.1.clazzLog.1.1.INSTANCE, (int)31, null));
                    }
                    clazzLog2 = destination$iv$iv2;
                    Iterable $this$filter$iv2 = alreadyCreatedClazzLogs;
                    boolean $i$f$filter2 = false;
                    element$iv$iv = $this$filter$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        ClazzLog it = (ClazzLog)element$iv$iv2;
                        boolean bl7 = false;
                        if (!(it.getClazzLogScheduleUid() == schedule.getScheduleUid() && it.getClazzLogUid() != clazzLog2.getClazzLogUid())) continue;
                        destination$iv$iv3.add(element$iv$iv2);
                    }
                    List logsToReschedule = (List)destination$iv$iv3;
                    Iterable $this$forEach$iv2 = logsToReschedule;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        ClazzLog it = (ClazzLog)element$iv2;
                        boolean bl8 = false;
                        $this$createClazzLogs.clazzLogDao().updateStatusByClazzLogUid(it.getClazzLogUid(), 8, SystemTimeKt.systemTimeInMillis());
                        $this$createClazzLogs.clazzLogAttendanceRecordDao().updateRescheduledClazzLogUids(it.getClazzLogUid(), clazzLog2.getClazzLogUid(), SystemTimeKt.systemTimeInMillis());
                    }
                    Iterable $this$any$iv = alreadyCreatedClazzLogs;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            ClazzLog it = (ClazzLog)element$iv2;
                            boolean bl9 = false;
                            if (!(it.getClazzLogUid() == clazzLog2.getClazzLogUid())) continue;
                            bl3 = true;
                            break block13;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) continue;
                $this$createClazzLogs.clazzLogDao().insert((Object)clazzLog2);
            }
        }
    }

    public static /* synthetic */ void createClazzLogs$default(UmAppDatabase umAppDatabase, long l, long l2, long l3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            l3 = 0L;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        ClazzLogCreatorKt.createClazzLogs(umAppDatabase, l, l2, l3, bl);
    }
}

