package com.ustadmobile.core.db

import com.ustadmobile.door.`annotation`.ReplicateEntity
import com.ustadmobile.door.`annotation`.Trigger
import com.ustadmobile.door.ext.DoorDatabaseMetadata
import com.ustadmobile.door.replication.ReplicationEntityMetaData
import com.ustadmobile.door.replication.ReplicationFieldMetaData
import kotlin.Boolean
import kotlin.Int
import kotlin.LazyThreadSafetyMode
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.reflect.KClass

public class UmAppDatabase_DoorMetadata : DoorDatabaseMetadata<UmAppDatabase>() {
  override val dbClass: KClass<UmAppDatabase>
    get() = UmAppDatabase::class

  override val hasReadOnlyWrapper: Boolean
    get() = true

  override val version: Int
    get() = 202

  override val allTables: List<String> = listOf("ClazzLog", "ClazzLogAttendanceRecord", "Schedule",
      "HolidayCalendar", "Holiday", "Person", "Clazz", "ClazzEnrolment", "LeavingReason",
      "ContentEntry", "ContentEntryContentCategoryJoin", "ContentEntryParentChildJoin",
      "ContentEntryRelatedEntryJoin", "ContentCategorySchema", "ContentCategory", "Language",
      "LanguageVariant", "PersonAuth", "PersonGroup", "PersonGroupMember", "PersonPicture",
      "VerbEntity", "ActivityEntity", "StatementEntity", "ActorEntity", "SyncNode", "Comments",
      "Report", "Site", "SiteTerms", "PersonParentJoin", "ScopedGrant", "ErrorReport",
      "ClazzAssignment", "CourseAssignmentSubmission", "CourseAssignmentSubmissionFile",
      "CourseAssignmentMark", "PeerReviewerAllocation", "PersonAuth2", "UserSession", "ContentJob",
      "ContentEntryImportJob", "CourseBlock", "CourseTerminology", "CourseGroupSet",
      "CourseGroupMember", "ContentEntryPicture", "ActivityInteractionEntity", "CoursePicture",
      "DiscussionPost", "ExternalAppPermission", "Message", "StudentResult", "ContentEntryVersion",
      "TransferJob", "TransferJobItem", "CacheLockJoin", "OfflineItem",
      "OfflineItemPendingTransferJob", "DeletedItem", "EnrolmentRequest", "CoursePermission",
      "SystemPermission", "CourseBlockPicture", "ContentEntryPicture2", "TransferJobError",
      "VerbLangMapEntry", "GroupMemberActorJoin", "ActivityLangMapEntry", "ActivityExtensionEntity",
      "StatementContextActivityJoin", "XapiSessionEntity", "StatementEntityJson", "StateEntity",
      "StateDeleteCommand", "OutgoingReplication", "ReplicationOperation",
      "PendingRepositorySession", "DoorNode")


  override val replicateEntities: Map<Int, ReplicationEntityMetaData> by
      lazy(LazyThreadSafetyMode.NONE) {
        mapOf<Int, ReplicationEntityMetaData>(
        14 to ReplicationEntityMetaData(tableId = 14, 
        entityTableName = "ClazzLog", 
        receiveViewName = "ClazzLog_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("clazzLogUid",),
        entityVersionIdFieldName = "clazzLogLastChangedTime", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "clazzLogClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "logDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "timeRecorded",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogDone",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cancellationNote",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogCancelled",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogNumPresent",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogNumAbsent",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogNumPartial",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogScheduleUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogStatusFlag",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogMSQN",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogLCSN",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogLCB",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogLastChangedTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "clazzlog_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ClazzLog (clazzLogUid, clazzLogClazzUid, logDate, timeRecorded, clazzLogDone, cancellationNote, clazzLogCancelled, clazzLogNumPresent, clazzLogNumAbsent, clazzLogNumPartial, clazzLogScheduleUid, clazzLogStatusFlag, clazzLogMSQN, clazzLogLCSN, clazzLogLCB, clazzLogLastChangedTime) VALUES( NEW.clazzLogUid, NEW.clazzLogClazzUid, NEW.logDate, NEW.timeRecorded, NEW.clazzLogDone, NEW.cancellationNote, NEW.clazzLogCancelled, NEW.clazzLogNumPresent, NEW.clazzLogNumAbsent, NEW.clazzLogNumPartial, NEW.clazzLogScheduleUid, NEW.clazzLogStatusFlag, NEW.clazzLogMSQN, NEW.clazzLogLCSN, NEW.clazzLogLCB, NEW.clazzLogLastChangedTime) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ClazzLog (clazzLogUid, clazzLogClazzUid, logDate, timeRecorded, clazzLogDone, cancellationNote, clazzLogCancelled, clazzLogNumPresent, clazzLogNumAbsent, clazzLogNumPartial, clazzLogScheduleUid, clazzLogStatusFlag, clazzLogMSQN, clazzLogLCSN, clazzLogLCB, clazzLogLastChangedTime) VALUES( NEW.clazzLogUid, NEW.clazzLogClazzUid, NEW.logDate, NEW.timeRecorded, NEW.clazzLogDone, NEW.cancellationNote, NEW.clazzLogCancelled, NEW.clazzLogNumPresent, NEW.clazzLogNumAbsent, NEW.clazzLogNumPartial, NEW.clazzLogScheduleUid, NEW.clazzLogStatusFlag, NEW.clazzLogMSQN, NEW.clazzLogLCSN, NEW.clazzLogLCB, NEW.clazzLogLastChangedTime)  ON CONFLICT(clazzLogUid)  DO UPDATE SET clazzLogClazzUid = NEW.clazzLogClazzUid, logDate = NEW.logDate, timeRecorded = NEW.timeRecorded, clazzLogDone = NEW.clazzLogDone, cancellationNote = NEW.cancellationNote, clazzLogCancelled = NEW.clazzLogCancelled, clazzLogNumPresent = NEW.clazzLogNumPresent, clazzLogNumAbsent = NEW.clazzLogNumAbsent, clazzLogNumPartial = NEW.clazzLogNumPartial, clazzLogScheduleUid = NEW.clazzLogScheduleUid, clazzLogStatusFlag = NEW.clazzLogStatusFlag, clazzLogMSQN = NEW.clazzLogMSQN, clazzLogLCSN = NEW.clazzLogLCSN, clazzLogLCB = NEW.clazzLogLCB, clazzLogLastChangedTime = NEW.clazzLogLastChangedTime ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.clazzLogLastChangedTime AS BIGINT) >
            |                       COALESCE((SELECT ClazzLog_Existing.clazzLogLastChangedTime
            |                                   FROM ClazzLog ClazzLog_Existing
            |                                  WHERE ClazzLog_Existing.clazzLogUid = NEW.clazzLogUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.clazzLogLastChangedTime AS BIGINT) >
            |                       COALESCE((SELECT ClazzLog_Existing.clazzLogLastChangedTime
            |                                   FROM ClazzLog ClazzLog_Existing
            |                                  WHERE ClazzLog_Existing.clazzLogUid = NEW.clazzLogUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        15 to ReplicationEntityMetaData(tableId = 15, 
        entityTableName = "ClazzLogAttendanceRecord", 
        receiveViewName = "ClazzLogAttendanceRecord_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("clazzLogAttendanceRecordUid",),
        entityVersionIdFieldName = "clazzLogAttendanceRecordLastChangedTime", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordClazzLogUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "attendanceStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordLastChangedTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLogAttendanceRecordUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "clazzlogattendancerecord_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ClazzLogAttendanceRecord (clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES( NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ClazzLogAttendanceRecord (clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES( NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime)  ON CONFLICT(clazzLogAttendanceRecordUid)  DO UPDATE SET clazzLogAttendanceRecordClazzLogUid = NEW.clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid = NEW.clazzLogAttendanceRecordPersonUid, attendanceStatus = NEW.attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum = NEW.clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum = NEW.clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy = NEW.clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime = NEW.clazzLogAttendanceRecordLastChangedTime ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.clazzLogAttendanceRecordLastChangedTime AS BIGINT) >
            |                       COALESCE((SELECT ClazzLogAttendanceRecord_Existing.clazzLogAttendanceRecordLastChangedTime
            |                                   FROM ClazzLogAttendanceRecord ClazzLogAttendanceRecord_Existing
            |                                  WHERE ClazzLogAttendanceRecord_Existing.clazzLogAttendanceRecordUid = NEW.clazzLogAttendanceRecordUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.clazzLogAttendanceRecordLastChangedTime AS BIGINT) >
            |                       COALESCE((SELECT ClazzLogAttendanceRecord_Existing.clazzLogAttendanceRecordLastChangedTime
            |                                   FROM ClazzLogAttendanceRecord ClazzLogAttendanceRecord_Existing
            |                                  WHERE ClazzLogAttendanceRecord_Existing.clazzLogAttendanceRecordUid = NEW.clazzLogAttendanceRecordUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        21 to ReplicationEntityMetaData(tableId = 21, 
        entityTableName = "Schedule", 
        receiveViewName = "Schedule_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("scheduleUid",),
        entityVersionIdFieldName = "scheduleLastChangedTime", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "sceduleStartTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleEndTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleDay",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleMonth",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleFrequency",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleLastChangedTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scheduleUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "schedule_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Schedule (scheduleUid, sceduleStartTime, scheduleEndTime, scheduleDay, scheduleMonth, scheduleFrequency, umCalendarUid, scheduleClazzUid, scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum, scheduleLastChangedBy, scheduleLastChangedTime, scheduleActive) VALUES( NEW.scheduleUid, NEW.sceduleStartTime, NEW.scheduleEndTime, NEW.scheduleDay, NEW.scheduleMonth, NEW.scheduleFrequency, NEW.umCalendarUid, NEW.scheduleClazzUid, NEW.scheduleMasterChangeSeqNum, NEW.scheduleLocalChangeSeqNum, NEW.scheduleLastChangedBy, NEW.scheduleLastChangedTime, NEW.scheduleActive) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Schedule (scheduleUid, sceduleStartTime, scheduleEndTime, scheduleDay, scheduleMonth, scheduleFrequency, umCalendarUid, scheduleClazzUid, scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum, scheduleLastChangedBy, scheduleLastChangedTime, scheduleActive) VALUES( NEW.scheduleUid, NEW.sceduleStartTime, NEW.scheduleEndTime, NEW.scheduleDay, NEW.scheduleMonth, NEW.scheduleFrequency, NEW.umCalendarUid, NEW.scheduleClazzUid, NEW.scheduleMasterChangeSeqNum, NEW.scheduleLocalChangeSeqNum, NEW.scheduleLastChangedBy, NEW.scheduleLastChangedTime, NEW.scheduleActive)  ON CONFLICT(scheduleUid)  DO UPDATE SET sceduleStartTime = NEW.sceduleStartTime, scheduleEndTime = NEW.scheduleEndTime, scheduleDay = NEW.scheduleDay, scheduleMonth = NEW.scheduleMonth, scheduleFrequency = NEW.scheduleFrequency, umCalendarUid = NEW.umCalendarUid, scheduleClazzUid = NEW.scheduleClazzUid, scheduleMasterChangeSeqNum = NEW.scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum = NEW.scheduleLocalChangeSeqNum, scheduleLastChangedBy = NEW.scheduleLastChangedBy, scheduleLastChangedTime = NEW.scheduleLastChangedTime, scheduleActive = NEW.scheduleActive ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.scheduleLastChangedTime AS BIGINT) >
            |                       COALESCE((SELECT Schedule_Existing.scheduleLastChangedTime
            |                                   FROM Schedule Schedule_Existing
            |                                  WHERE Schedule_Existing.scheduleUid = NEW.scheduleUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.scheduleLastChangedTime AS BIGINT) >
            |                       COALESCE((SELECT Schedule_Existing.scheduleLastChangedTime
            |                                   FROM Schedule Schedule_Existing
            |                                  WHERE Schedule_Existing.scheduleUid = NEW.scheduleUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        28 to ReplicationEntityMetaData(tableId = 28, 
        entityTableName = "HolidayCalendar", 
        receiveViewName = "HolidayCalendar_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("umCalendarUid",),
        entityVersionIdFieldName = "umCalendarLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "umCalendarName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarCategory",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "umCalendarUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "holidaycalendar_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO HolidayCalendar (umCalendarUid, umCalendarName, umCalendarCategory, umCalendarActive, umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum, umCalendarLastChangedBy, umCalendarLct) VALUES( NEW.umCalendarUid, NEW.umCalendarName, NEW.umCalendarCategory, NEW.umCalendarActive, NEW.umCalendarMasterChangeSeqNum, NEW.umCalendarLocalChangeSeqNum, NEW.umCalendarLastChangedBy, NEW.umCalendarLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO HolidayCalendar (umCalendarUid, umCalendarName, umCalendarCategory, umCalendarActive, umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum, umCalendarLastChangedBy, umCalendarLct) VALUES( NEW.umCalendarUid, NEW.umCalendarName, NEW.umCalendarCategory, NEW.umCalendarActive, NEW.umCalendarMasterChangeSeqNum, NEW.umCalendarLocalChangeSeqNum, NEW.umCalendarLastChangedBy, NEW.umCalendarLct)  ON CONFLICT(umCalendarUid)  DO UPDATE SET umCalendarName = NEW.umCalendarName, umCalendarCategory = NEW.umCalendarCategory, umCalendarActive = NEW.umCalendarActive, umCalendarMasterChangeSeqNum = NEW.umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum = NEW.umCalendarLocalChangeSeqNum, umCalendarLastChangedBy = NEW.umCalendarLastChangedBy, umCalendarLct = NEW.umCalendarLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.umCalendarLct AS BIGINT) >
            |                       COALESCE((SELECT HolidayCalendar_Existing.umCalendarLct
            |                                   FROM HolidayCalendar HolidayCalendar_Existing
            |                                  WHERE HolidayCalendar_Existing.umCalendarUid = NEW.umCalendarUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.umCalendarLct AS BIGINT) >
            |                       COALESCE((SELECT HolidayCalendar_Existing.umCalendarLct
            |                                   FROM HolidayCalendar HolidayCalendar_Existing
            |                                  WHERE HolidayCalendar_Existing.umCalendarUid = NEW.umCalendarUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        99 to ReplicationEntityMetaData(tableId = 99, 
        entityTableName = "Holiday", 
        receiveViewName = "Holiday_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("holUid",),
        entityVersionIdFieldName = "holLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "holMasterCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holLocalCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holLastModBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holHolidayCalendarUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holStartTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holEndTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "holName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "holUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "holiday_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Holiday (holUid, holMasterCsn, holLocalCsn, holLastModBy, holLct, holActive, holHolidayCalendarUid, holStartTime, holEndTime, holName) VALUES( NEW.holUid, NEW.holMasterCsn, NEW.holLocalCsn, NEW.holLastModBy, NEW.holLct, NEW.holActive, NEW.holHolidayCalendarUid, NEW.holStartTime, NEW.holEndTime, NEW.holName) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Holiday (holUid, holMasterCsn, holLocalCsn, holLastModBy, holLct, holActive, holHolidayCalendarUid, holStartTime, holEndTime, holName) VALUES( NEW.holUid, NEW.holMasterCsn, NEW.holLocalCsn, NEW.holLastModBy, NEW.holLct, NEW.holActive, NEW.holHolidayCalendarUid, NEW.holStartTime, NEW.holEndTime, NEW.holName)  ON CONFLICT(holUid)  DO UPDATE SET holMasterCsn = NEW.holMasterCsn, holLocalCsn = NEW.holLocalCsn, holLastModBy = NEW.holLastModBy, holLct = NEW.holLct, holActive = NEW.holActive, holHolidayCalendarUid = NEW.holHolidayCalendarUid, holStartTime = NEW.holStartTime, holEndTime = NEW.holEndTime, holName = NEW.holName ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.holLct AS BIGINT) >
            |                       COALESCE((SELECT Holiday_Existing.holLct
            |                                   FROM Holiday Holiday_Existing
            |                                  WHERE Holiday_Existing.holUid = NEW.holUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.holLct AS BIGINT) >
            |                       COALESCE((SELECT Holiday_Existing.holLct
            |                                   FROM Holiday Holiday_Existing
            |                                  WHERE Holiday_Existing.holUid = NEW.holUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        9 to ReplicationEntityMetaData(tableId = 9, 
        entityTableName = "Person", 
        receiveViewName = "Person_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("personUid",),
        entityVersionIdFieldName = "personLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "username",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "firstNames",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "lastName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "emailAddr",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "phoneNum",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "gender",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "active",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "dateOfBirth",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personAddress",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "personOrgId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "personGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personCountry",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "personType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "admin",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personNotes",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "fatherName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "fatherNumber",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "motherName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "motherNum",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "personUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "person_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Person (personUid, username, firstNames, lastName, emailAddr, phoneNum, gender, active, dateOfBirth, personAddress, personOrgId, personGroupUid, personLct, personCountry, personType, personMasterChangeSeqNum, personLocalChangeSeqNum, personLastChangedBy, admin, personNotes, fatherName, fatherNumber, motherName, motherNum) VALUES( NEW.personUid, NEW.username, NEW.firstNames, NEW.lastName, NEW.emailAddr, NEW.phoneNum, NEW.gender, NEW.active, NEW.dateOfBirth, NEW.personAddress, NEW.personOrgId, NEW.personGroupUid, NEW.personLct, NEW.personCountry, NEW.personType, NEW.personMasterChangeSeqNum, NEW.personLocalChangeSeqNum, NEW.personLastChangedBy, NEW.admin, NEW.personNotes, NEW.fatherName, NEW.fatherNumber, NEW.motherName, NEW.motherNum) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Person (personUid, username, firstNames, lastName, emailAddr, phoneNum, gender, active, dateOfBirth, personAddress, personOrgId, personGroupUid, personLct, personCountry, personType, personMasterChangeSeqNum, personLocalChangeSeqNum, personLastChangedBy, admin, personNotes, fatherName, fatherNumber, motherName, motherNum) VALUES( NEW.personUid, NEW.username, NEW.firstNames, NEW.lastName, NEW.emailAddr, NEW.phoneNum, NEW.gender, NEW.active, NEW.dateOfBirth, NEW.personAddress, NEW.personOrgId, NEW.personGroupUid, NEW.personLct, NEW.personCountry, NEW.personType, NEW.personMasterChangeSeqNum, NEW.personLocalChangeSeqNum, NEW.personLastChangedBy, NEW.admin, NEW.personNotes, NEW.fatherName, NEW.fatherNumber, NEW.motherName, NEW.motherNum)  ON CONFLICT(personUid)  DO UPDATE SET username = NEW.username, firstNames = NEW.firstNames, lastName = NEW.lastName, emailAddr = NEW.emailAddr, phoneNum = NEW.phoneNum, gender = NEW.gender, active = NEW.active, dateOfBirth = NEW.dateOfBirth, personAddress = NEW.personAddress, personOrgId = NEW.personOrgId, personGroupUid = NEW.personGroupUid, personLct = NEW.personLct, personCountry = NEW.personCountry, personType = NEW.personType, personMasterChangeSeqNum = NEW.personMasterChangeSeqNum, personLocalChangeSeqNum = NEW.personLocalChangeSeqNum, personLastChangedBy = NEW.personLastChangedBy, admin = NEW.admin, personNotes = NEW.personNotes, fatherName = NEW.fatherName, fatherNumber = NEW.fatherNumber, motherName = NEW.motherName, motherNum = NEW.motherNum ",
            ),
            conditionSql = """
            |
            |             SELECT 
            |                    ((NEW.username IS NULL
            |                     OR (SELECT NOT EXISTS(
            |                            SELECT Person.personUid
            |                              FROM Person
            |                             WHERE Person.username = NEW.username))  
            |                     OR NEW.personUid = 
            |                        (SELECT Person.personUid
            |                           FROM Person
            |                          WHERE Person.username = NEW.username)))
            |                  AND CAST(NEW.personLct AS BIGINT) > 
            |                         (SELECT COALESCE(
            |                                  (SELECT Person.personLct
            |                                     FROM Person
            |                                    WHERE Person.personUid = CAST(NEW.personUid AS BIGINT)), 0))   
            |                            
            |         
            """.trimMargin(),
            conditionSqlPostgres = """
            |
            |             SELECT 
            |                    ((NEW.username IS NULL
            |                     OR (SELECT NOT EXISTS(
            |                            SELECT Person.personUid
            |                              FROM Person
            |                             WHERE Person.username = NEW.username))  
            |                     OR NEW.personUid = 
            |                        (SELECT Person.personUid
            |                           FROM Person
            |                          WHERE Person.username = NEW.username)))
            |                  AND CAST(NEW.personLct AS BIGINT) > 
            |                         (SELECT COALESCE(
            |                                  (SELECT Person.personLct
            |                                     FROM Person
            |                                    WHERE Person.personUid = CAST(NEW.personUid AS BIGINT)), 0))   
            |                            
            |         
            """.trimMargin(),
          ),),
        ),
        6 to ReplicationEntityMetaData(tableId = 6, 
        entityTableName = "Clazz", 
        receiveViewName = "Clazz_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("clazzUid",),
        entityVersionIdFieldName = "clazzLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "clazzName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzDesc",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "attendanceAverage",
            dbFieldType = 6,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzHolidayUMCalendarUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzScheuleUMCalendarUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "isClazzActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLocationUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzStartTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEndTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzFeatures",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzSchoolUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentPolicy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzTerminologyUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzTimeZone",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzStudentsPersonGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzTeachersPersonGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzPendingStudentsPersonGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzParentsPersonGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzCode",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzOwnerPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "clazz_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Clazz (clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzEnrolmentPolicy, clazzTerminologyUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode, clazzOwnerPersonUid) VALUES( NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzEnrolmentPolicy, NEW.clazzTerminologyUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode, NEW.clazzOwnerPersonUid) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Clazz (clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzEnrolmentPolicy, clazzTerminologyUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode, clazzOwnerPersonUid) VALUES( NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzEnrolmentPolicy, NEW.clazzTerminologyUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode, NEW.clazzOwnerPersonUid)  ON CONFLICT(clazzUid)  DO UPDATE SET clazzName = NEW.clazzName, clazzDesc = NEW.clazzDesc, attendanceAverage = NEW.attendanceAverage, clazzHolidayUMCalendarUid = NEW.clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid = NEW.clazzScheuleUMCalendarUid, isClazzActive = NEW.isClazzActive, clazzLocationUid = NEW.clazzLocationUid, clazzStartTime = NEW.clazzStartTime, clazzEndTime = NEW.clazzEndTime, clazzFeatures = NEW.clazzFeatures, clazzSchoolUid = NEW.clazzSchoolUid, clazzEnrolmentPolicy = NEW.clazzEnrolmentPolicy, clazzTerminologyUid = NEW.clazzTerminologyUid, clazzMasterChangeSeqNum = NEW.clazzMasterChangeSeqNum, clazzLocalChangeSeqNum = NEW.clazzLocalChangeSeqNum, clazzLastChangedBy = NEW.clazzLastChangedBy, clazzLct = NEW.clazzLct, clazzTimeZone = NEW.clazzTimeZone, clazzStudentsPersonGroupUid = NEW.clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid = NEW.clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid = NEW.clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid = NEW.clazzParentsPersonGroupUid, clazzCode = NEW.clazzCode, clazzOwnerPersonUid = NEW.clazzOwnerPersonUid ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.clazzLct AS BIGINT) >
            |                       COALESCE((SELECT Clazz_Existing.clazzLct
            |                                   FROM Clazz Clazz_Existing
            |                                  WHERE Clazz_Existing.clazzUid = NEW.clazzUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.clazzLct AS BIGINT) >
            |                       COALESCE((SELECT Clazz_Existing.clazzLct
            |                                   FROM Clazz Clazz_Existing
            |                                  WHERE Clazz_Existing.clazzUid = NEW.clazzUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        65 to ReplicationEntityMetaData(tableId = 65, 
        entityTableName = "ClazzEnrolment", 
        receiveViewName = "ClazzEnrolment_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("clazzEnrolmentUid",),
        entityVersionIdFieldName = "clazzEnrolmentLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentDateJoined",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentDateLeft",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentRole",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentAttendancePercentage",
            dbFieldType = 6,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentLeavingReasonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentOutcome",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "clazzEnrolmentUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "clazzenrolment_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ClazzEnrolment (clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy, clazzEnrolmentLct) VALUES( NEW.clazzEnrolmentUid, NEW.clazzEnrolmentPersonUid, NEW.clazzEnrolmentClazzUid, NEW.clazzEnrolmentDateJoined, NEW.clazzEnrolmentDateLeft, NEW.clazzEnrolmentRole, NEW.clazzEnrolmentAttendancePercentage, NEW.clazzEnrolmentActive, NEW.clazzEnrolmentLeavingReasonUid, NEW.clazzEnrolmentOutcome, NEW.clazzEnrolmentLocalChangeSeqNum, NEW.clazzEnrolmentMasterChangeSeqNum, NEW.clazzEnrolmentLastChangedBy, NEW.clazzEnrolmentLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ClazzEnrolment (clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy, clazzEnrolmentLct) VALUES( NEW.clazzEnrolmentUid, NEW.clazzEnrolmentPersonUid, NEW.clazzEnrolmentClazzUid, NEW.clazzEnrolmentDateJoined, NEW.clazzEnrolmentDateLeft, NEW.clazzEnrolmentRole, NEW.clazzEnrolmentAttendancePercentage, NEW.clazzEnrolmentActive, NEW.clazzEnrolmentLeavingReasonUid, NEW.clazzEnrolmentOutcome, NEW.clazzEnrolmentLocalChangeSeqNum, NEW.clazzEnrolmentMasterChangeSeqNum, NEW.clazzEnrolmentLastChangedBy, NEW.clazzEnrolmentLct)  ON CONFLICT(clazzEnrolmentUid)  DO UPDATE SET clazzEnrolmentPersonUid = NEW.clazzEnrolmentPersonUid, clazzEnrolmentClazzUid = NEW.clazzEnrolmentClazzUid, clazzEnrolmentDateJoined = NEW.clazzEnrolmentDateJoined, clazzEnrolmentDateLeft = NEW.clazzEnrolmentDateLeft, clazzEnrolmentRole = NEW.clazzEnrolmentRole, clazzEnrolmentAttendancePercentage = NEW.clazzEnrolmentAttendancePercentage, clazzEnrolmentActive = NEW.clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid = NEW.clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome = NEW.clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum = NEW.clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum = NEW.clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy = NEW.clazzEnrolmentLastChangedBy, clazzEnrolmentLct = NEW.clazzEnrolmentLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.clazzEnrolmentLct AS BIGINT) >
            |                       COALESCE((SELECT ClazzEnrolment_Existing.clazzEnrolmentLct
            |                                   FROM ClazzEnrolment ClazzEnrolment_Existing
            |                                  WHERE ClazzEnrolment_Existing.clazzEnrolmentUid = NEW.clazzEnrolmentUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.clazzEnrolmentLct AS BIGINT) >
            |                       COALESCE((SELECT ClazzEnrolment_Existing.clazzEnrolmentLct
            |                                   FROM ClazzEnrolment ClazzEnrolment_Existing
            |                                  WHERE ClazzEnrolment_Existing.clazzEnrolmentUid = NEW.clazzEnrolmentUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        410 to ReplicationEntityMetaData(tableId = 410, 
        entityTableName = "LeavingReason", 
        receiveViewName = "LeavingReason_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("leavingReasonUid",),
        entityVersionIdFieldName = "leavingReasonLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "leavingReasonTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "leavingReasonMCSN",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "leavingReasonCSN",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "leavingReasonLCB",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "leavingReasonLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "leavingReasonUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "leavingreason_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO LeavingReason (leavingReasonUid, leavingReasonTitle, leavingReasonMCSN, leavingReasonCSN, leavingReasonLCB, leavingReasonLct) VALUES( NEW.leavingReasonUid, NEW.leavingReasonTitle, NEW.leavingReasonMCSN, NEW.leavingReasonCSN, NEW.leavingReasonLCB, NEW.leavingReasonLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO LeavingReason (leavingReasonUid, leavingReasonTitle, leavingReasonMCSN, leavingReasonCSN, leavingReasonLCB, leavingReasonLct) VALUES( NEW.leavingReasonUid, NEW.leavingReasonTitle, NEW.leavingReasonMCSN, NEW.leavingReasonCSN, NEW.leavingReasonLCB, NEW.leavingReasonLct)  ON CONFLICT(leavingReasonUid)  DO UPDATE SET leavingReasonTitle = NEW.leavingReasonTitle, leavingReasonMCSN = NEW.leavingReasonMCSN, leavingReasonCSN = NEW.leavingReasonCSN, leavingReasonLCB = NEW.leavingReasonLCB, leavingReasonLct = NEW.leavingReasonLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.leavingReasonLct AS BIGINT) >
            |                       COALESCE((SELECT LeavingReason_Existing.leavingReasonLct
            |                                   FROM LeavingReason LeavingReason_Existing
            |                                  WHERE LeavingReason_Existing.leavingReasonUid = NEW.leavingReasonUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.leavingReasonLct AS BIGINT) >
            |                       COALESCE((SELECT LeavingReason_Existing.leavingReasonLct
            |                                   FROM LeavingReason LeavingReason_Existing
            |                                  WHERE LeavingReason_Existing.leavingReasonUid = NEW.leavingReasonUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        42 to ReplicationEntityMetaData(tableId = 42, 
        entityTableName = "ContentEntry", 
        receiveViewName = "ContentEntry_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("contentEntryUid",),
        entityVersionIdFieldName = "contentEntryLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "title",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "description",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "entryId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "author",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "publisher",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "licenseType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "licenseName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "licenseUrl",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "sourceUrl",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "thumbnailUrl",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "lastModified",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "primaryLanguageUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "languageVariantUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentFlags",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "leaf",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "publik",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceInactive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "completionCriteria",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "minScore",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentTypeFlag",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentOwner",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentOwnerType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentEntryLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentEntryMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentEntryLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentEntryLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contententry_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntry (contentEntryUid, title, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, contentFlags, leaf, publik, ceInactive, completionCriteria, minScore, contentTypeFlag, contentOwner, contentOwnerType, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct) VALUES( NEW.contentEntryUid, NEW.title, NEW.description, NEW.entryId, NEW.author, NEW.publisher, NEW.licenseType, NEW.licenseName, NEW.licenseUrl, NEW.sourceUrl, NEW.thumbnailUrl, NEW.lastModified, NEW.primaryLanguageUid, NEW.languageVariantUid, NEW.contentFlags, NEW.leaf, NEW.publik, NEW.ceInactive, NEW.completionCriteria, NEW.minScore, NEW.contentTypeFlag, NEW.contentOwner, NEW.contentOwnerType, NEW.contentEntryLocalChangeSeqNum, NEW.contentEntryMasterChangeSeqNum, NEW.contentEntryLastChangedBy, NEW.contentEntryLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntry (contentEntryUid, title, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, contentFlags, leaf, publik, ceInactive, completionCriteria, minScore, contentTypeFlag, contentOwner, contentOwnerType, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct) VALUES( NEW.contentEntryUid, NEW.title, NEW.description, NEW.entryId, NEW.author, NEW.publisher, NEW.licenseType, NEW.licenseName, NEW.licenseUrl, NEW.sourceUrl, NEW.thumbnailUrl, NEW.lastModified, NEW.primaryLanguageUid, NEW.languageVariantUid, NEW.contentFlags, NEW.leaf, NEW.publik, NEW.ceInactive, NEW.completionCriteria, NEW.minScore, NEW.contentTypeFlag, NEW.contentOwner, NEW.contentOwnerType, NEW.contentEntryLocalChangeSeqNum, NEW.contentEntryMasterChangeSeqNum, NEW.contentEntryLastChangedBy, NEW.contentEntryLct)  ON CONFLICT(contentEntryUid)  DO UPDATE SET title = NEW.title, description = NEW.description, entryId = NEW.entryId, author = NEW.author, publisher = NEW.publisher, licenseType = NEW.licenseType, licenseName = NEW.licenseName, licenseUrl = NEW.licenseUrl, sourceUrl = NEW.sourceUrl, thumbnailUrl = NEW.thumbnailUrl, lastModified = NEW.lastModified, primaryLanguageUid = NEW.primaryLanguageUid, languageVariantUid = NEW.languageVariantUid, contentFlags = NEW.contentFlags, leaf = NEW.leaf, publik = NEW.publik, ceInactive = NEW.ceInactive, completionCriteria = NEW.completionCriteria, minScore = NEW.minScore, contentTypeFlag = NEW.contentTypeFlag, contentOwner = NEW.contentOwner, contentOwnerType = NEW.contentOwnerType, contentEntryLocalChangeSeqNum = NEW.contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum = NEW.contentEntryMasterChangeSeqNum, contentEntryLastChangedBy = NEW.contentEntryLastChangedBy, contentEntryLct = NEW.contentEntryLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.contentEntryLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntry_Existing.contentEntryLct
            |                                   FROM ContentEntry ContentEntry_Existing
            |                                  WHERE ContentEntry_Existing.contentEntryUid = NEW.contentEntryUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.contentEntryLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntry_Existing.contentEntryLct
            |                                   FROM ContentEntry ContentEntry_Existing
            |                                  WHERE ContentEntry_Existing.contentEntryUid = NEW.contentEntryUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        3 to ReplicationEntityMetaData(tableId = 3, 
        entityTableName = "ContentEntryContentCategoryJoin", 
        receiveViewName = "ContentEntryContentCategoryJoin_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("ceccjUid",),
        entityVersionIdFieldName = "ceccjLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "ceccjContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceccjContentCategoryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceccjLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceccjMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceccjLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceccjLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ceccjUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contententrycontentcategoryjoin_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntryContentCategoryJoin (ceccjUid, ceccjContentEntryUid, ceccjContentCategoryUid, ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum, ceccjLastChangedBy, ceccjLct) VALUES( NEW.ceccjUid, NEW.ceccjContentEntryUid, NEW.ceccjContentCategoryUid, NEW.ceccjLocalChangeSeqNum, NEW.ceccjMasterChangeSeqNum, NEW.ceccjLastChangedBy, NEW.ceccjLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntryContentCategoryJoin (ceccjUid, ceccjContentEntryUid, ceccjContentCategoryUid, ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum, ceccjLastChangedBy, ceccjLct) VALUES( NEW.ceccjUid, NEW.ceccjContentEntryUid, NEW.ceccjContentCategoryUid, NEW.ceccjLocalChangeSeqNum, NEW.ceccjMasterChangeSeqNum, NEW.ceccjLastChangedBy, NEW.ceccjLct)  ON CONFLICT(ceccjUid)  DO UPDATE SET ceccjContentEntryUid = NEW.ceccjContentEntryUid, ceccjContentCategoryUid = NEW.ceccjContentCategoryUid, ceccjLocalChangeSeqNum = NEW.ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum = NEW.ceccjMasterChangeSeqNum, ceccjLastChangedBy = NEW.ceccjLastChangedBy, ceccjLct = NEW.ceccjLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.ceccjLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryContentCategoryJoin_Existing.ceccjLct
            |                                   FROM ContentEntryContentCategoryJoin ContentEntryContentCategoryJoin_Existing
            |                                  WHERE ContentEntryContentCategoryJoin_Existing.ceccjUid = NEW.ceccjUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.ceccjLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryContentCategoryJoin_Existing.ceccjLct
            |                                   FROM ContentEntryContentCategoryJoin ContentEntryContentCategoryJoin_Existing
            |                                  WHERE ContentEntryContentCategoryJoin_Existing.ceccjUid = NEW.ceccjUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        7 to ReplicationEntityMetaData(tableId = 7, 
        entityTableName = "ContentEntryParentChildJoin", 
        receiveViewName = "ContentEntryParentChildJoin_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cepcjUid",),
        entityVersionIdFieldName = "cepcjLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cepcjLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjParentContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjChildContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "childIndex",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepcjUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contententryparentchildjoin_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntryParentChildJoin (cepcjUid, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct, cepcjDeleted, cepcjParentContentEntryUid, cepcjChildContentEntryUid, childIndex) VALUES( NEW.cepcjUid, NEW.cepcjLocalChangeSeqNum, NEW.cepcjMasterChangeSeqNum, NEW.cepcjLastChangedBy, NEW.cepcjLct, NEW.cepcjDeleted, NEW.cepcjParentContentEntryUid, NEW.cepcjChildContentEntryUid, NEW.childIndex) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntryParentChildJoin (cepcjUid, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct, cepcjDeleted, cepcjParentContentEntryUid, cepcjChildContentEntryUid, childIndex) VALUES( NEW.cepcjUid, NEW.cepcjLocalChangeSeqNum, NEW.cepcjMasterChangeSeqNum, NEW.cepcjLastChangedBy, NEW.cepcjLct, NEW.cepcjDeleted, NEW.cepcjParentContentEntryUid, NEW.cepcjChildContentEntryUid, NEW.childIndex)  ON CONFLICT(cepcjUid)  DO UPDATE SET cepcjLocalChangeSeqNum = NEW.cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum = NEW.cepcjMasterChangeSeqNum, cepcjLastChangedBy = NEW.cepcjLastChangedBy, cepcjLct = NEW.cepcjLct, cepcjDeleted = NEW.cepcjDeleted, cepcjParentContentEntryUid = NEW.cepcjParentContentEntryUid, cepcjChildContentEntryUid = NEW.cepcjChildContentEntryUid, childIndex = NEW.childIndex ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cepcjLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryParentChildJoin_Existing.cepcjLct
            |                                   FROM ContentEntryParentChildJoin ContentEntryParentChildJoin_Existing
            |                                  WHERE ContentEntryParentChildJoin_Existing.cepcjUid = NEW.cepcjUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cepcjLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryParentChildJoin_Existing.cepcjLct
            |                                   FROM ContentEntryParentChildJoin ContentEntryParentChildJoin_Existing
            |                                  WHERE ContentEntryParentChildJoin_Existing.cepcjUid = NEW.cepcjUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        8 to ReplicationEntityMetaData(tableId = 8, 
        entityTableName = "ContentEntryRelatedEntryJoin", 
        receiveViewName = "ContentEntryRelatedEntryJoin_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cerejUid",),
        entityVersionIdFieldName = "cerejLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cerejContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejRelatedEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "relType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "comment",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejRelLanguageUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cerejUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contententryrelatedentryjoin_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntryRelatedEntryJoin (cerejUid, cerejContentEntryUid, cerejRelatedEntryUid, cerejLastChangedBy, relType, comment, cerejRelLanguageUid, cerejLocalChangeSeqNum, cerejMasterChangeSeqNum, cerejLct) VALUES( NEW.cerejUid, NEW.cerejContentEntryUid, NEW.cerejRelatedEntryUid, NEW.cerejLastChangedBy, NEW.relType, NEW.comment, NEW.cerejRelLanguageUid, NEW.cerejLocalChangeSeqNum, NEW.cerejMasterChangeSeqNum, NEW.cerejLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntryRelatedEntryJoin (cerejUid, cerejContentEntryUid, cerejRelatedEntryUid, cerejLastChangedBy, relType, comment, cerejRelLanguageUid, cerejLocalChangeSeqNum, cerejMasterChangeSeqNum, cerejLct) VALUES( NEW.cerejUid, NEW.cerejContentEntryUid, NEW.cerejRelatedEntryUid, NEW.cerejLastChangedBy, NEW.relType, NEW.comment, NEW.cerejRelLanguageUid, NEW.cerejLocalChangeSeqNum, NEW.cerejMasterChangeSeqNum, NEW.cerejLct)  ON CONFLICT(cerejUid)  DO UPDATE SET cerejContentEntryUid = NEW.cerejContentEntryUid, cerejRelatedEntryUid = NEW.cerejRelatedEntryUid, cerejLastChangedBy = NEW.cerejLastChangedBy, relType = NEW.relType, comment = NEW.comment, cerejRelLanguageUid = NEW.cerejRelLanguageUid, cerejLocalChangeSeqNum = NEW.cerejLocalChangeSeqNum, cerejMasterChangeSeqNum = NEW.cerejMasterChangeSeqNum, cerejLct = NEW.cerejLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cerejLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryRelatedEntryJoin_Existing.cerejLct
            |                                   FROM ContentEntryRelatedEntryJoin ContentEntryRelatedEntryJoin_Existing
            |                                  WHERE ContentEntryRelatedEntryJoin_Existing.cerejUid = NEW.cerejUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cerejLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryRelatedEntryJoin_Existing.cerejLct
            |                                   FROM ContentEntryRelatedEntryJoin ContentEntryRelatedEntryJoin_Existing
            |                                  WHERE ContentEntryRelatedEntryJoin_Existing.cerejUid = NEW.cerejUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        2 to ReplicationEntityMetaData(tableId = 2, 
        entityTableName = "ContentCategorySchema", 
        receiveViewName = "ContentCategorySchema_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("contentCategorySchemaUid",),
        entityVersionIdFieldName = "contentCategorySchemaLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "schemaName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "schemaUrl",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategorySchemaLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategorySchemaMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategorySchemaLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategorySchemaLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategorySchemaUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contentcategoryschema_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentCategorySchema (contentCategorySchemaUid, schemaName, schemaUrl, contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy, contentCategorySchemaLct) VALUES( NEW.contentCategorySchemaUid, NEW.schemaName, NEW.schemaUrl, NEW.contentCategorySchemaLocalChangeSeqNum, NEW.contentCategorySchemaMasterChangeSeqNum, NEW.contentCategorySchemaLastChangedBy, NEW.contentCategorySchemaLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentCategorySchema (contentCategorySchemaUid, schemaName, schemaUrl, contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy, contentCategorySchemaLct) VALUES( NEW.contentCategorySchemaUid, NEW.schemaName, NEW.schemaUrl, NEW.contentCategorySchemaLocalChangeSeqNum, NEW.contentCategorySchemaMasterChangeSeqNum, NEW.contentCategorySchemaLastChangedBy, NEW.contentCategorySchemaLct)  ON CONFLICT(contentCategorySchemaUid)  DO UPDATE SET schemaName = NEW.schemaName, schemaUrl = NEW.schemaUrl, contentCategorySchemaLocalChangeSeqNum = NEW.contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum = NEW.contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy = NEW.contentCategorySchemaLastChangedBy, contentCategorySchemaLct = NEW.contentCategorySchemaLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.contentCategorySchemaLct AS BIGINT) >
            |                       COALESCE((SELECT ContentCategorySchema_Existing.contentCategorySchemaLct
            |                                   FROM ContentCategorySchema ContentCategorySchema_Existing
            |                                  WHERE ContentCategorySchema_Existing.contentCategorySchemaUid = NEW.contentCategorySchemaUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.contentCategorySchemaLct AS BIGINT) >
            |                       COALESCE((SELECT ContentCategorySchema_Existing.contentCategorySchemaLct
            |                                   FROM ContentCategorySchema ContentCategorySchema_Existing
            |                                  WHERE ContentCategorySchema_Existing.contentCategorySchemaUid = NEW.contentCategorySchemaUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        1 to ReplicationEntityMetaData(tableId = 1, 
        entityTableName = "ContentCategory", 
        receiveViewName = "ContentCategory_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("contentCategoryUid",),
        entityVersionIdFieldName = "contentCategoryLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "ctnCatContentCategorySchemaUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "name",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategoryLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategoryMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategoryLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategoryLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contentCategoryUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contentcategory_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentCategory (contentCategoryUid, ctnCatContentCategorySchemaUid, name, contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy, contentCategoryLct) VALUES( NEW.contentCategoryUid, NEW.ctnCatContentCategorySchemaUid, NEW.name, NEW.contentCategoryLocalChangeSeqNum, NEW.contentCategoryMasterChangeSeqNum, NEW.contentCategoryLastChangedBy, NEW.contentCategoryLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentCategory (contentCategoryUid, ctnCatContentCategorySchemaUid, name, contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy, contentCategoryLct) VALUES( NEW.contentCategoryUid, NEW.ctnCatContentCategorySchemaUid, NEW.name, NEW.contentCategoryLocalChangeSeqNum, NEW.contentCategoryMasterChangeSeqNum, NEW.contentCategoryLastChangedBy, NEW.contentCategoryLct)  ON CONFLICT(contentCategoryUid)  DO UPDATE SET ctnCatContentCategorySchemaUid = NEW.ctnCatContentCategorySchemaUid, name = NEW.name, contentCategoryLocalChangeSeqNum = NEW.contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum = NEW.contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy = NEW.contentCategoryLastChangedBy, contentCategoryLct = NEW.contentCategoryLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.contentCategoryLct AS BIGINT) >
            |                       COALESCE((SELECT ContentCategory_Existing.contentCategoryLct
            |                                   FROM ContentCategory ContentCategory_Existing
            |                                  WHERE ContentCategory_Existing.contentCategoryUid = NEW.contentCategoryUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.contentCategoryLct AS BIGINT) >
            |                       COALESCE((SELECT ContentCategory_Existing.contentCategoryLct
            |                                   FROM ContentCategory ContentCategory_Existing
            |                                  WHERE ContentCategory_Existing.contentCategoryUid = NEW.contentCategoryUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        13 to ReplicationEntityMetaData(tableId = 13, 
        entityTableName = "Language", 
        receiveViewName = "Language_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("langUid",),
        entityVersionIdFieldName = "langLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "name",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "iso_639_1_standard",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "iso_639_2_standard",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "iso_639_3_standard",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "Language_Type",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "languageActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "language_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Language (langUid, name, iso_639_1_standard, iso_639_2_standard, iso_639_3_standard, Language_Type, languageActive, langLocalChangeSeqNum, langMasterChangeSeqNum, langLastChangedBy, langLct) VALUES( NEW.langUid, NEW.name, NEW.iso_639_1_standard, NEW.iso_639_2_standard, NEW.iso_639_3_standard, NEW.Language_Type, NEW.languageActive, NEW.langLocalChangeSeqNum, NEW.langMasterChangeSeqNum, NEW.langLastChangedBy, NEW.langLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Language (langUid, name, iso_639_1_standard, iso_639_2_standard, iso_639_3_standard, Language_Type, languageActive, langLocalChangeSeqNum, langMasterChangeSeqNum, langLastChangedBy, langLct) VALUES( NEW.langUid, NEW.name, NEW.iso_639_1_standard, NEW.iso_639_2_standard, NEW.iso_639_3_standard, NEW.Language_Type, NEW.languageActive, NEW.langLocalChangeSeqNum, NEW.langMasterChangeSeqNum, NEW.langLastChangedBy, NEW.langLct)  ON CONFLICT(langUid)  DO UPDATE SET name = NEW.name, iso_639_1_standard = NEW.iso_639_1_standard, iso_639_2_standard = NEW.iso_639_2_standard, iso_639_3_standard = NEW.iso_639_3_standard, Language_Type = NEW.Language_Type, languageActive = NEW.languageActive, langLocalChangeSeqNum = NEW.langLocalChangeSeqNum, langMasterChangeSeqNum = NEW.langMasterChangeSeqNum, langLastChangedBy = NEW.langLastChangedBy, langLct = NEW.langLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.langLct AS BIGINT) >
            |                       COALESCE((SELECT Language_Existing.langLct
            |                                   FROM Language Language_Existing
            |                                  WHERE Language_Existing.langUid = NEW.langUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.langLct AS BIGINT) >
            |                       COALESCE((SELECT Language_Existing.langLct
            |                                   FROM Language Language_Existing
            |                                  WHERE Language_Existing.langUid = NEW.langUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        10 to ReplicationEntityMetaData(tableId = 10, 
        entityTableName = "LanguageVariant", 
        receiveViewName = "LanguageVariant_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("langVariantUid",),
        entityVersionIdFieldName = "langVariantLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "langUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "countryCode",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "name",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "langVariantLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langVariantMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langVariantLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langVariantLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "langVariantUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "languagevariant_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO LanguageVariant (langVariantUid, langUid, countryCode, name, langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum, langVariantLastChangedBy, langVariantLct) VALUES( NEW.langVariantUid, NEW.langUid, NEW.countryCode, NEW.name, NEW.langVariantLocalChangeSeqNum, NEW.langVariantMasterChangeSeqNum, NEW.langVariantLastChangedBy, NEW.langVariantLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO LanguageVariant (langVariantUid, langUid, countryCode, name, langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum, langVariantLastChangedBy, langVariantLct) VALUES( NEW.langVariantUid, NEW.langUid, NEW.countryCode, NEW.name, NEW.langVariantLocalChangeSeqNum, NEW.langVariantMasterChangeSeqNum, NEW.langVariantLastChangedBy, NEW.langVariantLct)  ON CONFLICT(langVariantUid)  DO UPDATE SET langUid = NEW.langUid, countryCode = NEW.countryCode, name = NEW.name, langVariantLocalChangeSeqNum = NEW.langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum = NEW.langVariantMasterChangeSeqNum, langVariantLastChangedBy = NEW.langVariantLastChangedBy, langVariantLct = NEW.langVariantLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.langVariantLct AS BIGINT) >
            |                       COALESCE((SELECT LanguageVariant_Existing.langVariantLct
            |                                   FROM LanguageVariant LanguageVariant_Existing
            |                                  WHERE LanguageVariant_Existing.langVariantUid = NEW.langVariantUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.langVariantLct AS BIGINT) >
            |                       COALESCE((SELECT LanguageVariant_Existing.langVariantLct
            |                                   FROM LanguageVariant LanguageVariant_Existing
            |                                  WHERE LanguageVariant_Existing.langVariantUid = NEW.langVariantUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        43 to ReplicationEntityMetaData(tableId = 43, 
        entityTableName = "PersonGroup", 
        receiveViewName = "PersonGroup_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("groupUid",),
        entityVersionIdFieldName = "groupLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "groupMasterCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupLocalCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personGroupFlag",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "persongroup_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO PersonGroup (groupUid, groupMasterCsn, groupLocalCsn, groupLastChangedBy, groupLct, groupName, groupActive, personGroupFlag) VALUES( NEW.groupUid, NEW.groupMasterCsn, NEW.groupLocalCsn, NEW.groupLastChangedBy, NEW.groupLct, NEW.groupName, NEW.groupActive, NEW.personGroupFlag) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO PersonGroup (groupUid, groupMasterCsn, groupLocalCsn, groupLastChangedBy, groupLct, groupName, groupActive, personGroupFlag) VALUES( NEW.groupUid, NEW.groupMasterCsn, NEW.groupLocalCsn, NEW.groupLastChangedBy, NEW.groupLct, NEW.groupName, NEW.groupActive, NEW.personGroupFlag)  ON CONFLICT(groupUid)  DO UPDATE SET groupMasterCsn = NEW.groupMasterCsn, groupLocalCsn = NEW.groupLocalCsn, groupLastChangedBy = NEW.groupLastChangedBy, groupLct = NEW.groupLct, groupName = NEW.groupName, groupActive = NEW.groupActive, personGroupFlag = NEW.personGroupFlag ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.groupLct AS BIGINT) >
            |                       COALESCE((SELECT PersonGroup_Existing.groupLct
            |                                   FROM PersonGroup PersonGroup_Existing
            |                                  WHERE PersonGroup_Existing.groupUid = NEW.groupUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.groupLct AS BIGINT) >
            |                       COALESCE((SELECT PersonGroup_Existing.groupLct
            |                                   FROM PersonGroup PersonGroup_Existing
            |                                  WHERE PersonGroup_Existing.groupUid = NEW.groupUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        44 to ReplicationEntityMetaData(tableId = 44, 
        entityTableName = "PersonGroupMember", 
        receiveViewName = "PersonGroupMember_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("groupMemberUid",),
        entityVersionIdFieldName = "groupMemberLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "groupMemberActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberMasterCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberLocalCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "groupMemberUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "persongroupmember_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO PersonGroupMember (groupMemberUid, groupMemberActive, groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy, groupMemberLct) VALUES( NEW.groupMemberUid, NEW.groupMemberActive, NEW.groupMemberPersonUid, NEW.groupMemberGroupUid, NEW.groupMemberMasterCsn, NEW.groupMemberLocalCsn, NEW.groupMemberLastChangedBy, NEW.groupMemberLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO PersonGroupMember (groupMemberUid, groupMemberActive, groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy, groupMemberLct) VALUES( NEW.groupMemberUid, NEW.groupMemberActive, NEW.groupMemberPersonUid, NEW.groupMemberGroupUid, NEW.groupMemberMasterCsn, NEW.groupMemberLocalCsn, NEW.groupMemberLastChangedBy, NEW.groupMemberLct)  ON CONFLICT(groupMemberUid)  DO UPDATE SET groupMemberActive = NEW.groupMemberActive, groupMemberPersonUid = NEW.groupMemberPersonUid, groupMemberGroupUid = NEW.groupMemberGroupUid, groupMemberMasterCsn = NEW.groupMemberMasterCsn, groupMemberLocalCsn = NEW.groupMemberLocalCsn, groupMemberLastChangedBy = NEW.groupMemberLastChangedBy, groupMemberLct = NEW.groupMemberLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.groupMemberLct AS BIGINT) >
            |                       COALESCE((SELECT PersonGroupMember_Existing.groupMemberLct
            |                                   FROM PersonGroupMember PersonGroupMember_Existing
            |                                  WHERE PersonGroupMember_Existing.groupMemberUid = NEW.groupMemberUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.groupMemberLct AS BIGINT) >
            |                       COALESCE((SELECT PersonGroupMember_Existing.groupMemberLct
            |                                   FROM PersonGroupMember PersonGroupMember_Existing
            |                                  WHERE PersonGroupMember_Existing.groupMemberUid = NEW.groupMemberUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        50 to ReplicationEntityMetaData(tableId = 50, 
        entityTableName = "PersonPicture", 
        receiveViewName = "PersonPicture_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("personPictureUid",),
        entityVersionIdFieldName = "personPictureLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "personPictureLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personPictureUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "personPictureThumbnailUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "fileSize",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personPictureActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "personPictureUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "personpicture_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO PersonPicture (personPictureUid, personPictureLct, personPictureUri, personPictureThumbnailUri, fileSize, personPictureActive) VALUES( NEW.personPictureUid, NEW.personPictureLct, NEW.personPictureUri, NEW.personPictureThumbnailUri, NEW.fileSize, NEW.personPictureActive) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO PersonPicture (personPictureUid, personPictureLct, personPictureUri, personPictureThumbnailUri, fileSize, personPictureActive) VALUES( NEW.personPictureUid, NEW.personPictureLct, NEW.personPictureUri, NEW.personPictureThumbnailUri, NEW.fileSize, NEW.personPictureActive)  ON CONFLICT(personPictureUid)  DO UPDATE SET personPictureLct = NEW.personPictureLct, personPictureUri = NEW.personPictureUri, personPictureThumbnailUri = NEW.personPictureThumbnailUri, fileSize = NEW.fileSize, personPictureActive = NEW.personPictureActive ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.personPictureLct AS BIGINT) >
            |                       COALESCE((SELECT PersonPicture_Existing.personPictureLct
            |                                   FROM PersonPicture PersonPicture_Existing
            |                                  WHERE PersonPicture_Existing.personPictureUid = NEW.personPictureUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.personPictureLct AS BIGINT) >
            |                       COALESCE((SELECT PersonPicture_Existing.personPictureLct
            |                                   FROM PersonPicture PersonPicture_Existing
            |                                  WHERE PersonPicture_Existing.personPictureUid = NEW.personPictureUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        62 to ReplicationEntityMetaData(tableId = 62, 
        entityTableName = "VerbEntity", 
        receiveViewName = "VerbEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("verbUid",),
        entityVersionIdFieldName = "verbLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "verbUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "verbUrlId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "verbDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "verbLct",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "verbentity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO VerbEntity (verbUid, verbUrlId, verbDeleted, verbLct) VALUES( NEW.verbUid, NEW.verbUrlId, NEW.verbDeleted, NEW.verbLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO VerbEntity (verbUid, verbUrlId, verbDeleted, verbLct) VALUES( NEW.verbUid, NEW.verbUrlId, NEW.verbDeleted, NEW.verbLct)  ON CONFLICT(verbUid)  DO UPDATE SET verbUrlId = NEW.verbUrlId, verbDeleted = NEW.verbDeleted, verbLct = NEW.verbLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.verbLct AS BIGINT) >
            |                       COALESCE((SELECT VerbEntity_Existing.verbLct
            |                                   FROM VerbEntity VerbEntity_Existing
            |                                  WHERE VerbEntity_Existing.verbUid = NEW.verbUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.verbLct AS BIGINT) >
            |                       COALESCE((SELECT VerbEntity_Existing.verbLct
            |                                   FROM VerbEntity VerbEntity_Existing
            |                                  WHERE VerbEntity_Existing.verbUid = NEW.verbUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        64 to ReplicationEntityMetaData(tableId = 64, 
        entityTableName = "ActivityEntity", 
        receiveViewName = "ActivityEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("actUid",),
        entityVersionIdFieldName = "actLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "actUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "actIdIri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actType",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actMoreInfo",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actInteractionType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "actCorrectResponsePatterns",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actLct",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "activityentity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ActivityEntity (actUid, actIdIri, actType, actMoreInfo, actInteractionType, actCorrectResponsePatterns, actLct) VALUES( NEW.actUid, NEW.actIdIri, NEW.actType, NEW.actMoreInfo, NEW.actInteractionType, NEW.actCorrectResponsePatterns, NEW.actLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ActivityEntity (actUid, actIdIri, actType, actMoreInfo, actInteractionType, actCorrectResponsePatterns, actLct) VALUES( NEW.actUid, NEW.actIdIri, NEW.actType, NEW.actMoreInfo, NEW.actInteractionType, NEW.actCorrectResponsePatterns, NEW.actLct)  ON CONFLICT(actUid)  DO UPDATE SET actIdIri = NEW.actIdIri, actType = NEW.actType, actMoreInfo = NEW.actMoreInfo, actInteractionType = NEW.actInteractionType, actCorrectResponsePatterns = NEW.actCorrectResponsePatterns, actLct = NEW.actLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.actLct AS BIGINT) >
            |                       COALESCE((SELECT ActivityEntity_Existing.actLct
            |                                   FROM ActivityEntity ActivityEntity_Existing
            |                                  WHERE ActivityEntity_Existing.actUid = NEW.actUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.actLct AS BIGINT) >
            |                       COALESCE((SELECT ActivityEntity_Existing.actLct
            |                                   FROM ActivityEntity ActivityEntity_Existing
            |                                  WHERE ActivityEntity_Existing.actUid = NEW.actUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        60 to ReplicationEntityMetaData(tableId = 60, 
        entityTableName = "StatementEntity", 
        receiveViewName = "StatementEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("statementIdHi","statementIdLo",),
        entityVersionIdFieldName = "statementLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "statementIdHi",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementIdLo",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementActorPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementVerbUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementObjectType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementObjectUid1",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementObjectUid2",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "authorityActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "teamUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultCompletion",
            dbFieldType = 16,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultSuccess",
            dbFieldType = 16,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultScoreScaled",
            dbFieldType = 6,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultScoreRaw",
            dbFieldType = 6,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultScoreMin",
            dbFieldType = 6,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultScoreMax",
            dbFieldType = 6,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultDuration",
            dbFieldType = -5,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "resultResponse",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "timestamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "stored",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contextRegistrationHi",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contextRegistrationLo",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contextPlatform",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "contextStatementRefIdHi",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contextStatementRefIdLo",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "contextInstructorActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "extensionProgress",
            dbFieldType = 4,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "completionOrProgress",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementLearnerGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementCbUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "statementDoorNode",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "isSubStatement",
            dbFieldType = 16,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "statemententity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO StatementEntity (statementIdHi, statementIdLo, statementActorPersonUid, statementVerbUid, statementObjectType, statementObjectUid1, statementObjectUid2, statementActorUid, authorityActorUid, teamUid, resultCompletion, resultSuccess, resultScoreScaled, resultScoreRaw, resultScoreMin, resultScoreMax, resultDuration, resultResponse, timestamp, stored, contextRegistrationHi, contextRegistrationLo, contextPlatform, contextStatementRefIdHi, contextStatementRefIdLo, contextInstructorActorUid, statementLct, extensionProgress, completionOrProgress, statementContentEntryUid, statementLearnerGroupUid, statementClazzUid, statementCbUid, statementDoorNode, isSubStatement) VALUES( NEW.statementIdHi, NEW.statementIdLo, NEW.statementActorPersonUid, NEW.statementVerbUid, NEW.statementObjectType, NEW.statementObjectUid1, NEW.statementObjectUid2, NEW.statementActorUid, NEW.authorityActorUid, NEW.teamUid, NEW.resultCompletion, NEW.resultSuccess, NEW.resultScoreScaled, NEW.resultScoreRaw, NEW.resultScoreMin, NEW.resultScoreMax, NEW.resultDuration, NEW.resultResponse, NEW.timestamp, NEW.stored, NEW.contextRegistrationHi, NEW.contextRegistrationLo, NEW.contextPlatform, NEW.contextStatementRefIdHi, NEW.contextStatementRefIdLo, NEW.contextInstructorActorUid, NEW.statementLct, NEW.extensionProgress, NEW.completionOrProgress, NEW.statementContentEntryUid, NEW.statementLearnerGroupUid, NEW.statementClazzUid, NEW.statementCbUid, NEW.statementDoorNode, NEW.isSubStatement) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO StatementEntity (statementIdHi, statementIdLo, statementActorPersonUid, statementVerbUid, statementObjectType, statementObjectUid1, statementObjectUid2, statementActorUid, authorityActorUid, teamUid, resultCompletion, resultSuccess, resultScoreScaled, resultScoreRaw, resultScoreMin, resultScoreMax, resultDuration, resultResponse, timestamp, stored, contextRegistrationHi, contextRegistrationLo, contextPlatform, contextStatementRefIdHi, contextStatementRefIdLo, contextInstructorActorUid, statementLct, extensionProgress, completionOrProgress, statementContentEntryUid, statementLearnerGroupUid, statementClazzUid, statementCbUid, statementDoorNode, isSubStatement) VALUES( NEW.statementIdHi, NEW.statementIdLo, NEW.statementActorPersonUid, NEW.statementVerbUid, NEW.statementObjectType, NEW.statementObjectUid1, NEW.statementObjectUid2, NEW.statementActorUid, NEW.authorityActorUid, NEW.teamUid, NEW.resultCompletion, NEW.resultSuccess, NEW.resultScoreScaled, NEW.resultScoreRaw, NEW.resultScoreMin, NEW.resultScoreMax, NEW.resultDuration, NEW.resultResponse, NEW.timestamp, NEW.stored, NEW.contextRegistrationHi, NEW.contextRegistrationLo, NEW.contextPlatform, NEW.contextStatementRefIdHi, NEW.contextStatementRefIdLo, NEW.contextInstructorActorUid, NEW.statementLct, NEW.extensionProgress, NEW.completionOrProgress, NEW.statementContentEntryUid, NEW.statementLearnerGroupUid, NEW.statementClazzUid, NEW.statementCbUid, NEW.statementDoorNode, NEW.isSubStatement)  ON CONFLICT(statementIdHi, statementIdLo)  DO UPDATE SET statementActorPersonUid = NEW.statementActorPersonUid, statementVerbUid = NEW.statementVerbUid, statementObjectType = NEW.statementObjectType, statementObjectUid1 = NEW.statementObjectUid1, statementObjectUid2 = NEW.statementObjectUid2, statementActorUid = NEW.statementActorUid, authorityActorUid = NEW.authorityActorUid, teamUid = NEW.teamUid, resultCompletion = NEW.resultCompletion, resultSuccess = NEW.resultSuccess, resultScoreScaled = NEW.resultScoreScaled, resultScoreRaw = NEW.resultScoreRaw, resultScoreMin = NEW.resultScoreMin, resultScoreMax = NEW.resultScoreMax, resultDuration = NEW.resultDuration, resultResponse = NEW.resultResponse, timestamp = NEW.timestamp, stored = NEW.stored, contextRegistrationHi = NEW.contextRegistrationHi, contextRegistrationLo = NEW.contextRegistrationLo, contextPlatform = NEW.contextPlatform, contextStatementRefIdHi = NEW.contextStatementRefIdHi, contextStatementRefIdLo = NEW.contextStatementRefIdLo, contextInstructorActorUid = NEW.contextInstructorActorUid, statementLct = NEW.statementLct, extensionProgress = NEW.extensionProgress, completionOrProgress = NEW.completionOrProgress, statementContentEntryUid = NEW.statementContentEntryUid, statementLearnerGroupUid = NEW.statementLearnerGroupUid, statementClazzUid = NEW.statementClazzUid, statementCbUid = NEW.statementCbUid, statementDoorNode = NEW.statementDoorNode, isSubStatement = NEW.isSubStatement ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.statementLct AS BIGINT) >
            |                       COALESCE((SELECT StatementEntity_Existing.statementLct
            |                                   FROM StatementEntity StatementEntity_Existing
            |                                  WHERE StatementEntity_Existing.statementIdHi = NEW.statementIdHi AND StatementEntity_Existing.statementIdLo = NEW.statementIdLo), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.statementLct AS BIGINT) >
            |                       COALESCE((SELECT StatementEntity_Existing.statementLct
            |                                   FROM StatementEntity StatementEntity_Existing
            |                                  WHERE StatementEntity_Existing.statementIdHi = NEW.statementIdHi AND StatementEntity_Existing.statementIdLo = NEW.statementIdLo), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        68 to ReplicationEntityMetaData(tableId = 68, 
        entityTableName = "ActorEntity", 
        receiveViewName = "ActorEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("actorUid",),
        entityVersionIdFieldName = "actorEtag", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "actorPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorMbox",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorMbox_sha1sum",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorOpenid",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorAccountName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorAccountHomePage",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorEtag",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorObjectType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "actorUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "agententity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ActorEntity (actorUid, actorPersonUid, actorName, actorMbox, actorMbox_sha1sum, actorOpenid, actorAccountName, actorAccountHomePage, actorEtag, actorLct, actorObjectType) VALUES( NEW.actorUid, NEW.actorPersonUid, NEW.actorName, NEW.actorMbox, NEW.actorMbox_sha1sum, NEW.actorOpenid, NEW.actorAccountName, NEW.actorAccountHomePage, NEW.actorEtag, NEW.actorLct, NEW.actorObjectType) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ActorEntity (actorUid, actorPersonUid, actorName, actorMbox, actorMbox_sha1sum, actorOpenid, actorAccountName, actorAccountHomePage, actorEtag, actorLct, actorObjectType) VALUES( NEW.actorUid, NEW.actorPersonUid, NEW.actorName, NEW.actorMbox, NEW.actorMbox_sha1sum, NEW.actorOpenid, NEW.actorAccountName, NEW.actorAccountHomePage, NEW.actorEtag, NEW.actorLct, NEW.actorObjectType)  ON CONFLICT(actorUid)  DO UPDATE SET actorPersonUid = NEW.actorPersonUid, actorName = NEW.actorName, actorMbox = NEW.actorMbox, actorMbox_sha1sum = NEW.actorMbox_sha1sum, actorOpenid = NEW.actorOpenid, actorAccountName = NEW.actorAccountName, actorAccountHomePage = NEW.actorAccountHomePage, actorEtag = NEW.actorEtag, actorLct = NEW.actorLct, actorObjectType = NEW.actorObjectType ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.actorLct AS BIGINT) >
            |                       COALESCE((SELECT ActorEntity_Existing.actorLct
            |                                   FROM ActorEntity ActorEntity_Existing
            |                                  WHERE ActorEntity_Existing.actorUid = NEW.actorUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.actorLct AS BIGINT) >
            |                       COALESCE((SELECT ActorEntity_Existing.actorLct
            |                                   FROM ActorEntity ActorEntity_Existing
            |                                  WHERE ActorEntity_Existing.actorUid = NEW.actorUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        208 to ReplicationEntityMetaData(tableId = 208, 
        entityTableName = "Comments", 
        receiveViewName = "Comments_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("commentsUid",),
        entityVersionIdFieldName = "commentsLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "commentsText",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsEntityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsFromPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsForSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsFromSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsFlagged",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsDateTimeAdded",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "commentsUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "comments_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Comments (commentsUid, commentsText, commentsEntityUid, commentsStatus, commentsFromPersonUid, commentsForSubmitterUid, commentsFromSubmitterUid, commentsFlagged, commentsDeleted, commentsDateTimeAdded, commentsLct) VALUES( NEW.commentsUid, NEW.commentsText, NEW.commentsEntityUid, NEW.commentsStatus, NEW.commentsFromPersonUid, NEW.commentsForSubmitterUid, NEW.commentsFromSubmitterUid, NEW.commentsFlagged, NEW.commentsDeleted, NEW.commentsDateTimeAdded, NEW.commentsLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Comments (commentsUid, commentsText, commentsEntityUid, commentsStatus, commentsFromPersonUid, commentsForSubmitterUid, commentsFromSubmitterUid, commentsFlagged, commentsDeleted, commentsDateTimeAdded, commentsLct) VALUES( NEW.commentsUid, NEW.commentsText, NEW.commentsEntityUid, NEW.commentsStatus, NEW.commentsFromPersonUid, NEW.commentsForSubmitterUid, NEW.commentsFromSubmitterUid, NEW.commentsFlagged, NEW.commentsDeleted, NEW.commentsDateTimeAdded, NEW.commentsLct)  ON CONFLICT(commentsUid)  DO UPDATE SET commentsText = NEW.commentsText, commentsEntityUid = NEW.commentsEntityUid, commentsStatus = NEW.commentsStatus, commentsFromPersonUid = NEW.commentsFromPersonUid, commentsForSubmitterUid = NEW.commentsForSubmitterUid, commentsFromSubmitterUid = NEW.commentsFromSubmitterUid, commentsFlagged = NEW.commentsFlagged, commentsDeleted = NEW.commentsDeleted, commentsDateTimeAdded = NEW.commentsDateTimeAdded, commentsLct = NEW.commentsLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.commentsLct AS BIGINT) >
            |                       COALESCE((SELECT Comments_Existing.commentsLct
            |                                   FROM Comments Comments_Existing
            |                                  WHERE Comments_Existing.commentsUid = NEW.commentsUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.commentsLct AS BIGINT) >
            |                       COALESCE((SELECT Comments_Existing.commentsLct
            |                                   FROM Comments Comments_Existing
            |                                  WHERE Comments_Existing.commentsUid = NEW.commentsUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        101 to ReplicationEntityMetaData(tableId = 101, 
        entityTableName = "Report", 
        receiveViewName = "Report_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("reportUid",),
        entityVersionIdFieldName = "reportLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "reportOwnerUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xAxis",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportDateRangeSelection",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "fromDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "fromRelTo",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "fromRelOffSet",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "fromRelUnit",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "toDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "toRelTo",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "toRelOffSet",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "toRelUnit",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportDescription",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportSeries",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportInactive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "isTemplate",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "priority",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportTitleId",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportDescId",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "reportUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "report_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Report (reportUid, reportOwnerUid, xAxis, reportDateRangeSelection, fromDate, fromRelTo, fromRelOffSet, fromRelUnit, toDate, toRelTo, toRelOffSet, toRelUnit, reportTitle, reportDescription, reportSeries, reportInactive, isTemplate, priority, reportTitleId, reportDescId, reportMasterChangeSeqNum, reportLocalChangeSeqNum, reportLastChangedBy, reportLct) VALUES( NEW.reportUid, NEW.reportOwnerUid, NEW.xAxis, NEW.reportDateRangeSelection, NEW.fromDate, NEW.fromRelTo, NEW.fromRelOffSet, NEW.fromRelUnit, NEW.toDate, NEW.toRelTo, NEW.toRelOffSet, NEW.toRelUnit, NEW.reportTitle, NEW.reportDescription, NEW.reportSeries, NEW.reportInactive, NEW.isTemplate, NEW.priority, NEW.reportTitleId, NEW.reportDescId, NEW.reportMasterChangeSeqNum, NEW.reportLocalChangeSeqNum, NEW.reportLastChangedBy, NEW.reportLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Report (reportUid, reportOwnerUid, xAxis, reportDateRangeSelection, fromDate, fromRelTo, fromRelOffSet, fromRelUnit, toDate, toRelTo, toRelOffSet, toRelUnit, reportTitle, reportDescription, reportSeries, reportInactive, isTemplate, priority, reportTitleId, reportDescId, reportMasterChangeSeqNum, reportLocalChangeSeqNum, reportLastChangedBy, reportLct) VALUES( NEW.reportUid, NEW.reportOwnerUid, NEW.xAxis, NEW.reportDateRangeSelection, NEW.fromDate, NEW.fromRelTo, NEW.fromRelOffSet, NEW.fromRelUnit, NEW.toDate, NEW.toRelTo, NEW.toRelOffSet, NEW.toRelUnit, NEW.reportTitle, NEW.reportDescription, NEW.reportSeries, NEW.reportInactive, NEW.isTemplate, NEW.priority, NEW.reportTitleId, NEW.reportDescId, NEW.reportMasterChangeSeqNum, NEW.reportLocalChangeSeqNum, NEW.reportLastChangedBy, NEW.reportLct)  ON CONFLICT(reportUid)  DO UPDATE SET reportOwnerUid = NEW.reportOwnerUid, xAxis = NEW.xAxis, reportDateRangeSelection = NEW.reportDateRangeSelection, fromDate = NEW.fromDate, fromRelTo = NEW.fromRelTo, fromRelOffSet = NEW.fromRelOffSet, fromRelUnit = NEW.fromRelUnit, toDate = NEW.toDate, toRelTo = NEW.toRelTo, toRelOffSet = NEW.toRelOffSet, toRelUnit = NEW.toRelUnit, reportTitle = NEW.reportTitle, reportDescription = NEW.reportDescription, reportSeries = NEW.reportSeries, reportInactive = NEW.reportInactive, isTemplate = NEW.isTemplate, priority = NEW.priority, reportTitleId = NEW.reportTitleId, reportDescId = NEW.reportDescId, reportMasterChangeSeqNum = NEW.reportMasterChangeSeqNum, reportLocalChangeSeqNum = NEW.reportLocalChangeSeqNum, reportLastChangedBy = NEW.reportLastChangedBy, reportLct = NEW.reportLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.reportLct AS BIGINT) >
            |                       COALESCE((SELECT Report_Existing.reportLct
            |                                   FROM Report Report_Existing
            |                                  WHERE Report_Existing.reportUid = NEW.reportUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.reportLct AS BIGINT) >
            |                       COALESCE((SELECT Report_Existing.reportLct
            |                                   FROM Report Report_Existing
            |                                  WHERE Report_Existing.reportUid = NEW.reportUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        189 to ReplicationEntityMetaData(tableId = 189, 
        entityTableName = "Site", 
        receiveViewName = "Site_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("siteUid",),
        entityVersionIdFieldName = "siteLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "sitePcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "siteLcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "siteLcb",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "siteLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "siteName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "guestLogin",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "registrationAllowed",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "authSalt",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "siteUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "site_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Site (siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt) VALUES( NEW.siteUid, NEW.sitePcsn, NEW.siteLcsn, NEW.siteLcb, NEW.siteLct, NEW.siteName, NEW.guestLogin, NEW.registrationAllowed, NEW.authSalt) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Site (siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt) VALUES( NEW.siteUid, NEW.sitePcsn, NEW.siteLcsn, NEW.siteLcb, NEW.siteLct, NEW.siteName, NEW.guestLogin, NEW.registrationAllowed, NEW.authSalt)  ON CONFLICT(siteUid)  DO UPDATE SET sitePcsn = NEW.sitePcsn, siteLcsn = NEW.siteLcsn, siteLcb = NEW.siteLcb, siteLct = NEW.siteLct, siteName = NEW.siteName, guestLogin = NEW.guestLogin, registrationAllowed = NEW.registrationAllowed, authSalt = NEW.authSalt ",
            ),
            conditionSql = """
            |
            |             SELECT ((SELECT COUNT(*) 
            |                        FROM Site) = 0
            |                     OR NEW.authSalt = 
            |                        (SELECT Site.authSalt
            |                           FROM Site
            |                          LIMIT 1))
            |                 AND (SELECT 
            |                   CAST(NEW.siteLct AS BIGINT) >
            |                       COALESCE((SELECT Site_Existing.siteLct
            |                                   FROM Site Site_Existing
            |                                  WHERE Site_Existing.siteUid = NEW.siteUid), 0)
            |                   )          
            |         
            """.trimMargin(),
            conditionSqlPostgres = """
            |
            |             SELECT ((SELECT COUNT(*) 
            |                        FROM Site) = 0
            |                     OR NEW.authSalt = 
            |                        (SELECT Site.authSalt
            |                           FROM Site
            |                          LIMIT 1))
            |                 AND (SELECT 
            |                   CAST(NEW.siteLct AS BIGINT) >
            |                       COALESCE((SELECT Site_Existing.siteLct
            |                                   FROM Site Site_Existing
            |                                  WHERE Site_Existing.siteUid = NEW.siteUid), 0)
            |                   )          
            |         
            """.trimMargin(),
          ),),
        ),
        272 to ReplicationEntityMetaData(tableId = 272, 
        entityTableName = "SiteTerms", 
        receiveViewName = "SiteTerms_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("sTermsUid",),
        entityVersionIdFieldName = "sTermsLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "termsHtml",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsLang",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsLangUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsPrimaryCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsLocalCsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sTermsUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "siteterms_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO SiteTerms (sTermsUid, termsHtml, sTermsLang, sTermsLangUid, sTermsActive, sTermsLastChangedBy, sTermsPrimaryCsn, sTermsLocalCsn, sTermsLct) VALUES( NEW.sTermsUid, NEW.termsHtml, NEW.sTermsLang, NEW.sTermsLangUid, NEW.sTermsActive, NEW.sTermsLastChangedBy, NEW.sTermsPrimaryCsn, NEW.sTermsLocalCsn, NEW.sTermsLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO SiteTerms (sTermsUid, termsHtml, sTermsLang, sTermsLangUid, sTermsActive, sTermsLastChangedBy, sTermsPrimaryCsn, sTermsLocalCsn, sTermsLct) VALUES( NEW.sTermsUid, NEW.termsHtml, NEW.sTermsLang, NEW.sTermsLangUid, NEW.sTermsActive, NEW.sTermsLastChangedBy, NEW.sTermsPrimaryCsn, NEW.sTermsLocalCsn, NEW.sTermsLct)  ON CONFLICT(sTermsUid)  DO UPDATE SET termsHtml = NEW.termsHtml, sTermsLang = NEW.sTermsLang, sTermsLangUid = NEW.sTermsLangUid, sTermsActive = NEW.sTermsActive, sTermsLastChangedBy = NEW.sTermsLastChangedBy, sTermsPrimaryCsn = NEW.sTermsPrimaryCsn, sTermsLocalCsn = NEW.sTermsLocalCsn, sTermsLct = NEW.sTermsLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.sTermsLct AS BIGINT) >
            |                       COALESCE((SELECT SiteTerms_Existing.sTermsLct
            |                                   FROM SiteTerms SiteTerms_Existing
            |                                  WHERE SiteTerms_Existing.sTermsUid = NEW.sTermsUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.sTermsLct AS BIGINT) >
            |                       COALESCE((SELECT SiteTerms_Existing.sTermsLct
            |                                   FROM SiteTerms SiteTerms_Existing
            |                                  WHERE SiteTerms_Existing.sTermsUid = NEW.sTermsUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        512 to ReplicationEntityMetaData(tableId = 512, 
        entityTableName = "PersonParentJoin", 
        receiveViewName = "PersonParentJoin_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("ppjUid",),
        entityVersionIdFieldName = "ppjLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "ppjPcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjLcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjLcb",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjParentPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjMinorPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjRelationship",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjEmail",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjPhone",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjInactive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjApprovalTiemstamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjApprovalIpAddr",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "ppjUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "personparentjoin_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO PersonParentJoin (ppjUid, ppjPcsn, ppjLcsn, ppjLcb, ppjLct, ppjParentPersonUid, ppjMinorPersonUid, ppjRelationship, ppjEmail, ppjPhone, ppjInactive, ppjStatus, ppjApprovalTiemstamp, ppjApprovalIpAddr) VALUES( NEW.ppjUid, NEW.ppjPcsn, NEW.ppjLcsn, NEW.ppjLcb, NEW.ppjLct, NEW.ppjParentPersonUid, NEW.ppjMinorPersonUid, NEW.ppjRelationship, NEW.ppjEmail, NEW.ppjPhone, NEW.ppjInactive, NEW.ppjStatus, NEW.ppjApprovalTiemstamp, NEW.ppjApprovalIpAddr) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO PersonParentJoin (ppjUid, ppjPcsn, ppjLcsn, ppjLcb, ppjLct, ppjParentPersonUid, ppjMinorPersonUid, ppjRelationship, ppjEmail, ppjPhone, ppjInactive, ppjStatus, ppjApprovalTiemstamp, ppjApprovalIpAddr) VALUES( NEW.ppjUid, NEW.ppjPcsn, NEW.ppjLcsn, NEW.ppjLcb, NEW.ppjLct, NEW.ppjParentPersonUid, NEW.ppjMinorPersonUid, NEW.ppjRelationship, NEW.ppjEmail, NEW.ppjPhone, NEW.ppjInactive, NEW.ppjStatus, NEW.ppjApprovalTiemstamp, NEW.ppjApprovalIpAddr)  ON CONFLICT(ppjUid)  DO UPDATE SET ppjPcsn = NEW.ppjPcsn, ppjLcsn = NEW.ppjLcsn, ppjLcb = NEW.ppjLcb, ppjLct = NEW.ppjLct, ppjParentPersonUid = NEW.ppjParentPersonUid, ppjMinorPersonUid = NEW.ppjMinorPersonUid, ppjRelationship = NEW.ppjRelationship, ppjEmail = NEW.ppjEmail, ppjPhone = NEW.ppjPhone, ppjInactive = NEW.ppjInactive, ppjStatus = NEW.ppjStatus, ppjApprovalTiemstamp = NEW.ppjApprovalTiemstamp, ppjApprovalIpAddr = NEW.ppjApprovalIpAddr ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.ppjLct AS BIGINT) >
            |                       COALESCE((SELECT PersonParentJoin_Existing.ppjLct
            |                                   FROM PersonParentJoin PersonParentJoin_Existing
            |                                  WHERE PersonParentJoin_Existing.ppjUid = NEW.ppjUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.ppjLct AS BIGINT) >
            |                       COALESCE((SELECT PersonParentJoin_Existing.ppjLct
            |                                   FROM PersonParentJoin PersonParentJoin_Existing
            |                                  WHERE PersonParentJoin_Existing.ppjUid = NEW.ppjUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        48 to ReplicationEntityMetaData(tableId = 48, 
        entityTableName = "ScopedGrant", 
        receiveViewName = "ScopedGrant_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("sgUid",),
        entityVersionIdFieldName = "sgLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "sgPcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgLcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgLcb",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgTableId",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgEntityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgPermissions",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgIndex",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgFlags",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sgUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "sg_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "UPDATE ScopedGrant SET sgLct = 0 WHERE sgUid = 0",
            ),
            postgreSqlStatements = arrayOf(
              "UPDATE ScopedGrant SET sgLct = 0 WHERE sgUid = 0",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.sgLct AS BIGINT) >
            |                       COALESCE((SELECT ScopedGrant_Existing.sgLct
            |                                   FROM ScopedGrant ScopedGrant_Existing
            |                                  WHERE ScopedGrant_Existing.sgUid = NEW.sgUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.sgLct AS BIGINT) >
            |                       COALESCE((SELECT ScopedGrant_Existing.sgLct
            |                                   FROM ScopedGrant ScopedGrant_Existing
            |                                  WHERE ScopedGrant_Existing.sgUid = NEW.sgUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        419 to ReplicationEntityMetaData(tableId = 419, 
        entityTableName = "ErrorReport", 
        receiveViewName = "ErrorReport_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("errUid",),
        entityVersionIdFieldName = "errLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "errPcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "errLcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "errLcb",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "errLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "severity",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "timestamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "presenterUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "appVersion",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "versionCode",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "errorCode",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "operatingSys",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "osVersion",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "stackTrace",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "message",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "errUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "errorreport_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ErrorReport (errUid, errPcsn, errLcsn, errLcb, errLct, severity, timestamp, presenterUri, appVersion, versionCode, errorCode, operatingSys, osVersion, stackTrace, message) VALUES( NEW.errUid, NEW.errPcsn, NEW.errLcsn, NEW.errLcb, NEW.errLct, NEW.severity, NEW.timestamp, NEW.presenterUri, NEW.appVersion, NEW.versionCode, NEW.errorCode, NEW.operatingSys, NEW.osVersion, NEW.stackTrace, NEW.message) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ErrorReport (errUid, errPcsn, errLcsn, errLcb, errLct, severity, timestamp, presenterUri, appVersion, versionCode, errorCode, operatingSys, osVersion, stackTrace, message) VALUES( NEW.errUid, NEW.errPcsn, NEW.errLcsn, NEW.errLcb, NEW.errLct, NEW.severity, NEW.timestamp, NEW.presenterUri, NEW.appVersion, NEW.versionCode, NEW.errorCode, NEW.operatingSys, NEW.osVersion, NEW.stackTrace, NEW.message)  ON CONFLICT(errUid)  DO UPDATE SET errPcsn = NEW.errPcsn, errLcsn = NEW.errLcsn, errLcb = NEW.errLcb, errLct = NEW.errLct, severity = NEW.severity, timestamp = NEW.timestamp, presenterUri = NEW.presenterUri, appVersion = NEW.appVersion, versionCode = NEW.versionCode, errorCode = NEW.errorCode, operatingSys = NEW.operatingSys, osVersion = NEW.osVersion, stackTrace = NEW.stackTrace, message = NEW.message ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.errLct AS BIGINT) >
            |                       COALESCE((SELECT ErrorReport_Existing.errLct
            |                                   FROM ErrorReport ErrorReport_Existing
            |                                  WHERE ErrorReport_Existing.errUid = NEW.errUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.errLct AS BIGINT) >
            |                       COALESCE((SELECT ErrorReport_Existing.errLct
            |                                   FROM ErrorReport ErrorReport_Existing
            |                                  WHERE ErrorReport_Existing.errUid = NEW.errUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        520 to ReplicationEntityMetaData(tableId = 520, 
        entityTableName = "ClazzAssignment", 
        receiveViewName = "ClazzAssignment_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("caUid",),
        entityVersionIdFieldName = "caLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "caTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "caDescription",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "caGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caClassCommentEnabled",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caPrivateCommentsEnabled",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caCompletionCriteria",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caRequireFileSubmission",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caFileType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caSizeLimit",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caNumberOfFiles",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caSubmissionPolicy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caMarkingType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caRequireTextSubmission",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caTextLimitType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caTextLimit",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caXObjectUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caPeerReviewerCount",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caLocalChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caMasterChangeSeqNum",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caLastChangedBy",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "caUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "clazzassignment_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ClazzAssignment (caUid, caTitle, caDescription, caGroupUid, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caCompletionCriteria, caRequireFileSubmission, caFileType, caSizeLimit, caNumberOfFiles, caSubmissionPolicy, caMarkingType, caRequireTextSubmission, caTextLimitType, caTextLimit, caXObjectUid, caClazzUid, caPeerReviewerCount, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES( NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caGroupUid, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caCompletionCriteria, NEW.caRequireFileSubmission, NEW.caFileType, NEW.caSizeLimit, NEW.caNumberOfFiles, NEW.caSubmissionPolicy, NEW.caMarkingType, NEW.caRequireTextSubmission, NEW.caTextLimitType, NEW.caTextLimit, NEW.caXObjectUid, NEW.caClazzUid, NEW.caPeerReviewerCount, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ClazzAssignment (caUid, caTitle, caDescription, caGroupUid, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caCompletionCriteria, caRequireFileSubmission, caFileType, caSizeLimit, caNumberOfFiles, caSubmissionPolicy, caMarkingType, caRequireTextSubmission, caTextLimitType, caTextLimit, caXObjectUid, caClazzUid, caPeerReviewerCount, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES( NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caGroupUid, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caCompletionCriteria, NEW.caRequireFileSubmission, NEW.caFileType, NEW.caSizeLimit, NEW.caNumberOfFiles, NEW.caSubmissionPolicy, NEW.caMarkingType, NEW.caRequireTextSubmission, NEW.caTextLimitType, NEW.caTextLimit, NEW.caXObjectUid, NEW.caClazzUid, NEW.caPeerReviewerCount, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct)  ON CONFLICT(caUid)  DO UPDATE SET caTitle = NEW.caTitle, caDescription = NEW.caDescription, caGroupUid = NEW.caGroupUid, caActive = NEW.caActive, caClassCommentEnabled = NEW.caClassCommentEnabled, caPrivateCommentsEnabled = NEW.caPrivateCommentsEnabled, caCompletionCriteria = NEW.caCompletionCriteria, caRequireFileSubmission = NEW.caRequireFileSubmission, caFileType = NEW.caFileType, caSizeLimit = NEW.caSizeLimit, caNumberOfFiles = NEW.caNumberOfFiles, caSubmissionPolicy = NEW.caSubmissionPolicy, caMarkingType = NEW.caMarkingType, caRequireTextSubmission = NEW.caRequireTextSubmission, caTextLimitType = NEW.caTextLimitType, caTextLimit = NEW.caTextLimit, caXObjectUid = NEW.caXObjectUid, caClazzUid = NEW.caClazzUid, caPeerReviewerCount = NEW.caPeerReviewerCount, caLocalChangeSeqNum = NEW.caLocalChangeSeqNum, caMasterChangeSeqNum = NEW.caMasterChangeSeqNum, caLastChangedBy = NEW.caLastChangedBy, caLct = NEW.caLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.caLct AS BIGINT) >
            |                       COALESCE((SELECT ClazzAssignment_Existing.caLct
            |                                   FROM ClazzAssignment ClazzAssignment_Existing
            |                                  WHERE ClazzAssignment_Existing.caUid = NEW.caUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.caLct AS BIGINT) >
            |                       COALESCE((SELECT ClazzAssignment_Existing.caLct
            |                                   FROM ClazzAssignment ClazzAssignment_Existing
            |                                  WHERE ClazzAssignment_Existing.caUid = NEW.caUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        522 to ReplicationEntityMetaData(tableId = 522, 
        entityTableName = "CourseAssignmentSubmission", 
        receiveViewName = "CourseAssignmentSubmission_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("casUid",),
        entityVersionIdFieldName = "casTimestamp", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "casAssignmentUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casSubmitterPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casText",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "casType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casTimestamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "courseassignmentsubmission_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseAssignmentSubmission (casUid, casAssignmentUid, casSubmitterUid, casSubmitterPersonUid, casText, casType, casTimestamp, casClazzUid) VALUES( NEW.casUid, NEW.casAssignmentUid, NEW.casSubmitterUid, NEW.casSubmitterPersonUid, NEW.casText, NEW.casType, NEW.casTimestamp, NEW.casClazzUid) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseAssignmentSubmission (casUid, casAssignmentUid, casSubmitterUid, casSubmitterPersonUid, casText, casType, casTimestamp, casClazzUid) VALUES( NEW.casUid, NEW.casAssignmentUid, NEW.casSubmitterUid, NEW.casSubmitterPersonUid, NEW.casText, NEW.casType, NEW.casTimestamp, NEW.casClazzUid)  ON CONFLICT(casUid)  DO UPDATE SET casAssignmentUid = NEW.casAssignmentUid, casSubmitterUid = NEW.casSubmitterUid, casSubmitterPersonUid = NEW.casSubmitterPersonUid, casText = NEW.casText, casType = NEW.casType, casTimestamp = NEW.casTimestamp, casClazzUid = NEW.casClazzUid ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.casTimestamp AS BIGINT) >
            |                       COALESCE((SELECT CourseAssignmentSubmission_Existing.casTimestamp
            |                                   FROM CourseAssignmentSubmission CourseAssignmentSubmission_Existing
            |                                  WHERE CourseAssignmentSubmission_Existing.casUid = NEW.casUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.casTimestamp AS BIGINT) >
            |                       COALESCE((SELECT CourseAssignmentSubmission_Existing.casTimestamp
            |                                   FROM CourseAssignmentSubmission CourseAssignmentSubmission_Existing
            |                                  WHERE CourseAssignmentSubmission_Existing.casUid = NEW.casUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        90 to ReplicationEntityMetaData(tableId = 90, 
        entityTableName = "CourseAssignmentSubmissionFile", 
        receiveViewName = "CourseAssignmentSubmissionFile_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("casaUid",),
        entityVersionIdFieldName = "casaTimestamp", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "casaSubmissionUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaCaUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaMimeType",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaFileName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaSize",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaTimestamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "casaUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "courseassignmentsubmissionattachment_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseAssignmentSubmissionFile (casaUid, casaSubmissionUid, casaSubmitterUid, casaCaUid, casaClazzUid, casaMimeType, casaFileName, casaUri, casaSize, casaTimestamp, casaDeleted) VALUES( NEW.casaUid, NEW.casaSubmissionUid, NEW.casaSubmitterUid, NEW.casaCaUid, NEW.casaClazzUid, NEW.casaMimeType, NEW.casaFileName, NEW.casaUri, NEW.casaSize, NEW.casaTimestamp, NEW.casaDeleted) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseAssignmentSubmissionFile (casaUid, casaSubmissionUid, casaSubmitterUid, casaCaUid, casaClazzUid, casaMimeType, casaFileName, casaUri, casaSize, casaTimestamp, casaDeleted) VALUES( NEW.casaUid, NEW.casaSubmissionUid, NEW.casaSubmitterUid, NEW.casaCaUid, NEW.casaClazzUid, NEW.casaMimeType, NEW.casaFileName, NEW.casaUri, NEW.casaSize, NEW.casaTimestamp, NEW.casaDeleted)  ON CONFLICT(casaUid)  DO UPDATE SET casaSubmissionUid = NEW.casaSubmissionUid, casaSubmitterUid = NEW.casaSubmitterUid, casaCaUid = NEW.casaCaUid, casaClazzUid = NEW.casaClazzUid, casaMimeType = NEW.casaMimeType, casaFileName = NEW.casaFileName, casaUri = NEW.casaUri, casaSize = NEW.casaSize, casaTimestamp = NEW.casaTimestamp, casaDeleted = NEW.casaDeleted ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.casaTimestamp AS BIGINT) >
            |                       COALESCE((SELECT CourseAssignmentSubmissionFile_Existing.casaTimestamp
            |                                   FROM CourseAssignmentSubmissionFile CourseAssignmentSubmissionFile_Existing
            |                                  WHERE CourseAssignmentSubmissionFile_Existing.casaUid = NEW.casaUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.casaTimestamp AS BIGINT) >
            |                       COALESCE((SELECT CourseAssignmentSubmissionFile_Existing.casaTimestamp
            |                                   FROM CourseAssignmentSubmissionFile CourseAssignmentSubmissionFile_Existing
            |                                  WHERE CourseAssignmentSubmissionFile_Existing.casaUid = NEW.casaUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        523 to ReplicationEntityMetaData(tableId = 523, 
        entityTableName = "CourseAssignmentMark", 
        receiveViewName = "CourseAssignmentMark_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("camUid",),
        entityVersionIdFieldName = "camLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "camAssignmentUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camMarkerSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camMarkerPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camMarkerComment",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "camMark",
            dbFieldType = 6,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camMaxMark",
            dbFieldType = 6,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camPenalty",
            dbFieldType = 6,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "camUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "courseassignmentmark_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseAssignmentMark (camUid, camAssignmentUid, camSubmitterUid, camMarkerSubmitterUid, camMarkerPersonUid, camMarkerComment, camMark, camMaxMark, camPenalty, camLct, camClazzUid) VALUES( NEW.camUid, NEW.camAssignmentUid, NEW.camSubmitterUid, NEW.camMarkerSubmitterUid, NEW.camMarkerPersonUid, NEW.camMarkerComment, NEW.camMark, NEW.camMaxMark, NEW.camPenalty, NEW.camLct, NEW.camClazzUid) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseAssignmentMark (camUid, camAssignmentUid, camSubmitterUid, camMarkerSubmitterUid, camMarkerPersonUid, camMarkerComment, camMark, camMaxMark, camPenalty, camLct, camClazzUid) VALUES( NEW.camUid, NEW.camAssignmentUid, NEW.camSubmitterUid, NEW.camMarkerSubmitterUid, NEW.camMarkerPersonUid, NEW.camMarkerComment, NEW.camMark, NEW.camMaxMark, NEW.camPenalty, NEW.camLct, NEW.camClazzUid)  ON CONFLICT(camUid)  DO UPDATE SET camAssignmentUid = NEW.camAssignmentUid, camSubmitterUid = NEW.camSubmitterUid, camMarkerSubmitterUid = NEW.camMarkerSubmitterUid, camMarkerPersonUid = NEW.camMarkerPersonUid, camMarkerComment = NEW.camMarkerComment, camMark = NEW.camMark, camMaxMark = NEW.camMaxMark, camPenalty = NEW.camPenalty, camLct = NEW.camLct, camClazzUid = NEW.camClazzUid ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.camLct AS BIGINT) >
            |                       COALESCE((SELECT CourseAssignmentMark_Existing.camLct
            |                                   FROM CourseAssignmentMark CourseAssignmentMark_Existing
            |                                  WHERE CourseAssignmentMark_Existing.camUid = NEW.camUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.camLct AS BIGINT) >
            |                       COALESCE((SELECT CourseAssignmentMark_Existing.camLct
            |                                   FROM CourseAssignmentMark CourseAssignmentMark_Existing
            |                                  WHERE CourseAssignmentMark_Existing.camUid = NEW.camUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        140 to ReplicationEntityMetaData(tableId = 140, 
        entityTableName = "PeerReviewerAllocation", 
        receiveViewName = "PeerReviewerAllocation_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("praUid",),
        entityVersionIdFieldName = "praLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "praMarkerSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "praToMarkerSubmitterUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "praAssignmentUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "praActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "praLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "praUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "peerreviewerallocation_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO PeerReviewerAllocation (praUid, praMarkerSubmitterUid, praToMarkerSubmitterUid, praAssignmentUid, praActive, praLct) VALUES( NEW.praUid, NEW.praMarkerSubmitterUid, NEW.praToMarkerSubmitterUid, NEW.praAssignmentUid, NEW.praActive, NEW.praLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO PeerReviewerAllocation (praUid, praMarkerSubmitterUid, praToMarkerSubmitterUid, praAssignmentUid, praActive, praLct) VALUES( NEW.praUid, NEW.praMarkerSubmitterUid, NEW.praToMarkerSubmitterUid, NEW.praAssignmentUid, NEW.praActive, NEW.praLct)  ON CONFLICT(praUid)  DO UPDATE SET praMarkerSubmitterUid = NEW.praMarkerSubmitterUid, praToMarkerSubmitterUid = NEW.praToMarkerSubmitterUid, praAssignmentUid = NEW.praAssignmentUid, praActive = NEW.praActive, praLct = NEW.praLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.praLct AS BIGINT) >
            |                       COALESCE((SELECT PeerReviewerAllocation_Existing.praLct
            |                                   FROM PeerReviewerAllocation PeerReviewerAllocation_Existing
            |                                  WHERE PeerReviewerAllocation_Existing.praUid = NEW.praUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.praLct AS BIGINT) >
            |                       COALESCE((SELECT PeerReviewerAllocation_Existing.praLct
            |                                   FROM PeerReviewerAllocation PeerReviewerAllocation_Existing
            |                                  WHERE PeerReviewerAllocation_Existing.praUid = NEW.praUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        678 to ReplicationEntityMetaData(tableId = 678, 
        entityTableName = "PersonAuth2", 
        receiveViewName = "PersonAuth2_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("pauthUid",),
        entityVersionIdFieldName = "pauthLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "pauthUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "pauthMechanism",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "pauthAuth",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "pauthLcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "pauthPcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "pauthLcb",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "pauthLct",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "personauth2_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO PersonAuth2 (pauthUid, pauthMechanism, pauthAuth, pauthLcsn, pauthPcsn, pauthLcb, pauthLct) VALUES( NEW.pauthUid, NEW.pauthMechanism, NEW.pauthAuth, NEW.pauthLcsn, NEW.pauthPcsn, NEW.pauthLcb, NEW.pauthLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO PersonAuth2 (pauthUid, pauthMechanism, pauthAuth, pauthLcsn, pauthPcsn, pauthLcb, pauthLct) VALUES( NEW.pauthUid, NEW.pauthMechanism, NEW.pauthAuth, NEW.pauthLcsn, NEW.pauthPcsn, NEW.pauthLcb, NEW.pauthLct)  ON CONFLICT(pauthUid)  DO UPDATE SET pauthMechanism = NEW.pauthMechanism, pauthAuth = NEW.pauthAuth, pauthLcsn = NEW.pauthLcsn, pauthPcsn = NEW.pauthPcsn, pauthLcb = NEW.pauthLcb, pauthLct = NEW.pauthLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.pauthLct AS BIGINT) >
            |                       COALESCE((SELECT PersonAuth2_Existing.pauthLct
            |                                   FROM PersonAuth2 PersonAuth2_Existing
            |                                  WHERE PersonAuth2_Existing.pauthUid = NEW.pauthUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.pauthLct AS BIGINT) >
            |                       COALESCE((SELECT PersonAuth2_Existing.pauthLct
            |                                   FROM PersonAuth2 PersonAuth2_Existing
            |                                  WHERE PersonAuth2_Existing.pauthUid = NEW.pauthUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        679 to ReplicationEntityMetaData(tableId = 679, 
        entityTableName = "UserSession", 
        receiveViewName = "UserSession_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("usUid",),
        entityVersionIdFieldName = "usLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "usPcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usLcsn",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usLcb",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usClientNodeId",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usStartTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usEndTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usReason",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usAuth",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "usSessionType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "usUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "usersession_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO UserSession (usUid, usPcsn, usLcsn, usLcb, usLct, usPersonUid, usClientNodeId, usStartTime, usEndTime, usStatus, usReason, usAuth, usSessionType) VALUES( NEW.usUid, NEW.usPcsn, NEW.usLcsn, NEW.usLcb, NEW.usLct, NEW.usPersonUid, NEW.usClientNodeId, NEW.usStartTime, NEW.usEndTime, NEW.usStatus, NEW.usReason, NEW.usAuth, NEW.usSessionType) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO UserSession (usUid, usPcsn, usLcsn, usLcb, usLct, usPersonUid, usClientNodeId, usStartTime, usEndTime, usStatus, usReason, usAuth, usSessionType) VALUES( NEW.usUid, NEW.usPcsn, NEW.usLcsn, NEW.usLcb, NEW.usLct, NEW.usPersonUid, NEW.usClientNodeId, NEW.usStartTime, NEW.usEndTime, NEW.usStatus, NEW.usReason, NEW.usAuth, NEW.usSessionType)  ON CONFLICT(usUid)  DO UPDATE SET usPcsn = NEW.usPcsn, usLcsn = NEW.usLcsn, usLcb = NEW.usLcb, usLct = NEW.usLct, usPersonUid = NEW.usPersonUid, usClientNodeId = NEW.usClientNodeId, usStartTime = NEW.usStartTime, usEndTime = NEW.usEndTime, usStatus = NEW.usStatus, usReason = NEW.usReason, usAuth = NEW.usAuth, usSessionType = NEW.usSessionType ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.usLct AS BIGINT) >
            |                       COALESCE((SELECT UserSession_Existing.usLct
            |                                   FROM UserSession UserSession_Existing
            |                                  WHERE UserSession_Existing.usUid = NEW.usUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.usLct AS BIGINT) >
            |                       COALESCE((SELECT UserSession_Existing.usLct
            |                                   FROM UserSession UserSession_Existing
            |                                  WHERE UserSession_Existing.usUid = NEW.usUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        702 to ReplicationEntityMetaData(tableId = 702, 
        entityTableName = "ContentJob", 
        receiveViewName = "ContentJob_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cjUid",),
        entityVersionIdFieldName = "cjLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "toUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cjProgress",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cjTotal",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cjNotificationTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cjIsMeteredAllowed",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "params",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cjLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cjUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contentjob_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentJob (cjUid, toUri, cjProgress, cjTotal, cjNotificationTitle, cjIsMeteredAllowed, params, cjLct) VALUES( NEW.cjUid, NEW.toUri, NEW.cjProgress, NEW.cjTotal, NEW.cjNotificationTitle, NEW.cjIsMeteredAllowed, NEW.params, NEW.cjLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentJob (cjUid, toUri, cjProgress, cjTotal, cjNotificationTitle, cjIsMeteredAllowed, params, cjLct) VALUES( NEW.cjUid, NEW.toUri, NEW.cjProgress, NEW.cjTotal, NEW.cjNotificationTitle, NEW.cjIsMeteredAllowed, NEW.params, NEW.cjLct)  ON CONFLICT(cjUid)  DO UPDATE SET toUri = NEW.toUri, cjProgress = NEW.cjProgress, cjTotal = NEW.cjTotal, cjNotificationTitle = NEW.cjNotificationTitle, cjIsMeteredAllowed = NEW.cjIsMeteredAllowed, params = NEW.params, cjLct = NEW.cjLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cjLct AS BIGINT) >
            |                       COALESCE((SELECT ContentJob_Existing.cjLct
            |                                   FROM ContentJob ContentJob_Existing
            |                                  WHERE ContentJob_Existing.cjUid = NEW.cjUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cjLct AS BIGINT) >
            |                       COALESCE((SELECT ContentJob_Existing.cjLct
            |                                   FROM ContentJob ContentJob_Existing
            |                                  WHERE ContentJob_Existing.cjUid = NEW.cjUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        124 to ReplicationEntityMetaData(tableId = 124, 
        entityTableName = "CourseBlock", 
        receiveViewName = "CourseBlock_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cbUid",),
        entityVersionIdFieldName = "cbLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cbType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbIndentLevel",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbModuleParentBlockUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbDescription",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbCompletionCriteria",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbHideUntilDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbDeadlineDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbLateSubmissionPenalty",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbGracePeriodDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbMaxPoints",
            dbFieldType = 6,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbMinPoints",
            dbFieldType = 6,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbIndex",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbClazzSourcedId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbHidden",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbEntityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbSourcedId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbMetadata",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbCreatedByAppId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "courseblock_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseBlock (cbUid, cbType, cbIndentLevel, cbModuleParentBlockUid, cbTitle, cbDescription, cbCompletionCriteria, cbHideUntilDate, cbDeadlineDate, cbLateSubmissionPenalty, cbGracePeriodDate, cbMaxPoints, cbMinPoints, cbIndex, cbClazzUid, cbClazzSourcedId, cbActive, cbHidden, cbEntityUid, cbLct, cbSourcedId, cbMetadata, cbCreatedByAppId) VALUES( NEW.cbUid, NEW.cbType, NEW.cbIndentLevel, NEW.cbModuleParentBlockUid, NEW.cbTitle, NEW.cbDescription, NEW.cbCompletionCriteria, NEW.cbHideUntilDate, NEW.cbDeadlineDate, NEW.cbLateSubmissionPenalty, NEW.cbGracePeriodDate, NEW.cbMaxPoints, NEW.cbMinPoints, NEW.cbIndex, NEW.cbClazzUid, NEW.cbClazzSourcedId, NEW.cbActive, NEW.cbHidden, NEW.cbEntityUid, NEW.cbLct, NEW.cbSourcedId, NEW.cbMetadata, NEW.cbCreatedByAppId) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseBlock (cbUid, cbType, cbIndentLevel, cbModuleParentBlockUid, cbTitle, cbDescription, cbCompletionCriteria, cbHideUntilDate, cbDeadlineDate, cbLateSubmissionPenalty, cbGracePeriodDate, cbMaxPoints, cbMinPoints, cbIndex, cbClazzUid, cbClazzSourcedId, cbActive, cbHidden, cbEntityUid, cbLct, cbSourcedId, cbMetadata, cbCreatedByAppId) VALUES( NEW.cbUid, NEW.cbType, NEW.cbIndentLevel, NEW.cbModuleParentBlockUid, NEW.cbTitle, NEW.cbDescription, NEW.cbCompletionCriteria, NEW.cbHideUntilDate, NEW.cbDeadlineDate, NEW.cbLateSubmissionPenalty, NEW.cbGracePeriodDate, NEW.cbMaxPoints, NEW.cbMinPoints, NEW.cbIndex, NEW.cbClazzUid, NEW.cbClazzSourcedId, NEW.cbActive, NEW.cbHidden, NEW.cbEntityUid, NEW.cbLct, NEW.cbSourcedId, NEW.cbMetadata, NEW.cbCreatedByAppId)  ON CONFLICT(cbUid)  DO UPDATE SET cbType = NEW.cbType, cbIndentLevel = NEW.cbIndentLevel, cbModuleParentBlockUid = NEW.cbModuleParentBlockUid, cbTitle = NEW.cbTitle, cbDescription = NEW.cbDescription, cbCompletionCriteria = NEW.cbCompletionCriteria, cbHideUntilDate = NEW.cbHideUntilDate, cbDeadlineDate = NEW.cbDeadlineDate, cbLateSubmissionPenalty = NEW.cbLateSubmissionPenalty, cbGracePeriodDate = NEW.cbGracePeriodDate, cbMaxPoints = NEW.cbMaxPoints, cbMinPoints = NEW.cbMinPoints, cbIndex = NEW.cbIndex, cbClazzUid = NEW.cbClazzUid, cbClazzSourcedId = NEW.cbClazzSourcedId, cbActive = NEW.cbActive, cbHidden = NEW.cbHidden, cbEntityUid = NEW.cbEntityUid, cbLct = NEW.cbLct, cbSourcedId = NEW.cbSourcedId, cbMetadata = NEW.cbMetadata, cbCreatedByAppId = NEW.cbCreatedByAppId ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cbLct AS BIGINT) >
            |                       COALESCE((SELECT CourseBlock_Existing.cbLct
            |                                   FROM CourseBlock CourseBlock_Existing
            |                                  WHERE CourseBlock_Existing.cbUid = NEW.cbUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cbLct AS BIGINT) >
            |                       COALESCE((SELECT CourseBlock_Existing.cbLct
            |                                   FROM CourseBlock CourseBlock_Existing
            |                                  WHERE CourseBlock_Existing.cbUid = NEW.cbUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        450 to ReplicationEntityMetaData(tableId = 450, 
        entityTableName = "CourseTerminology", 
        receiveViewName = "CourseTerminology_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("ctUid",),
        entityVersionIdFieldName = "ctLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "ctTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "ctTerminology",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "ctLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "ctUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "courseterminology_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseTerminology (ctUid, ctTitle, ctTerminology, ctLct) VALUES( NEW.ctUid, NEW.ctTitle, NEW.ctTerminology, NEW.ctLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseTerminology (ctUid, ctTitle, ctTerminology, ctLct) VALUES( NEW.ctUid, NEW.ctTitle, NEW.ctTerminology, NEW.ctLct)  ON CONFLICT(ctUid)  DO UPDATE SET ctTitle = NEW.ctTitle, ctTerminology = NEW.ctTerminology, ctLct = NEW.ctLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.ctLct AS BIGINT) >
            |                       COALESCE((SELECT CourseTerminology_Existing.ctLct
            |                                   FROM CourseTerminology CourseTerminology_Existing
            |                                  WHERE CourseTerminology_Existing.ctUid = NEW.ctUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.ctLct AS BIGINT) >
            |                       COALESCE((SELECT CourseTerminology_Existing.ctLct
            |                                   FROM CourseTerminology CourseTerminology_Existing
            |                                  WHERE CourseTerminology_Existing.ctUid = NEW.ctUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        242 to ReplicationEntityMetaData(tableId = 242, 
        entityTableName = "CourseGroupSet", 
        receiveViewName = "CourseGroupSet_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cgsUid",),
        entityVersionIdFieldName = "cgsLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cgsName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgsTotalGroups",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgsActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgsClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgsLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgsUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "coursegroupset_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseGroupSet (cgsUid, cgsName, cgsTotalGroups, cgsActive, cgsClazzUid, cgsLct) VALUES( NEW.cgsUid, NEW.cgsName, NEW.cgsTotalGroups, NEW.cgsActive, NEW.cgsClazzUid, NEW.cgsLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseGroupSet (cgsUid, cgsName, cgsTotalGroups, cgsActive, cgsClazzUid, cgsLct) VALUES( NEW.cgsUid, NEW.cgsName, NEW.cgsTotalGroups, NEW.cgsActive, NEW.cgsClazzUid, NEW.cgsLct)  ON CONFLICT(cgsUid)  DO UPDATE SET cgsName = NEW.cgsName, cgsTotalGroups = NEW.cgsTotalGroups, cgsActive = NEW.cgsActive, cgsClazzUid = NEW.cgsClazzUid, cgsLct = NEW.cgsLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cgsLct AS BIGINT) >
            |                       COALESCE((SELECT CourseGroupSet_Existing.cgsLct
            |                                   FROM CourseGroupSet CourseGroupSet_Existing
            |                                  WHERE CourseGroupSet_Existing.cgsUid = NEW.cgsUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cgsLct AS BIGINT) >
            |                       COALESCE((SELECT CourseGroupSet_Existing.cgsLct
            |                                   FROM CourseGroupSet CourseGroupSet_Existing
            |                                  WHERE CourseGroupSet_Existing.cgsUid = NEW.cgsUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        243 to ReplicationEntityMetaData(tableId = 243, 
        entityTableName = "CourseGroupMember", 
        receiveViewName = "CourseGroupMember_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cgmUid",),
        entityVersionIdFieldName = "cgmLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cgmSetUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgmGroupNumber",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgmPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgmLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cgmUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "coursegroupmember_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseGroupMember (cgmUid, cgmSetUid, cgmGroupNumber, cgmPersonUid, cgmLct) VALUES( NEW.cgmUid, NEW.cgmSetUid, NEW.cgmGroupNumber, NEW.cgmPersonUid, NEW.cgmLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseGroupMember (cgmUid, cgmSetUid, cgmGroupNumber, cgmPersonUid, cgmLct) VALUES( NEW.cgmUid, NEW.cgmSetUid, NEW.cgmGroupNumber, NEW.cgmPersonUid, NEW.cgmLct)  ON CONFLICT(cgmUid)  DO UPDATE SET cgmSetUid = NEW.cgmSetUid, cgmGroupNumber = NEW.cgmGroupNumber, cgmPersonUid = NEW.cgmPersonUid, cgmLct = NEW.cgmLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cgmLct AS BIGINT) >
            |                       COALESCE((SELECT CourseGroupMember_Existing.cgmLct
            |                                   FROM CourseGroupMember CourseGroupMember_Existing
            |                                  WHERE CourseGroupMember_Existing.cgmUid = NEW.cgmUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cgmLct AS BIGINT) >
            |                       COALESCE((SELECT CourseGroupMember_Existing.cgmLct
            |                                   FROM CourseGroupMember CourseGroupMember_Existing
            |                                  WHERE CourseGroupMember_Existing.cgmUid = NEW.cgmUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        138 to ReplicationEntityMetaData(tableId = 138, 
        entityTableName = "ContentEntryPicture", 
        receiveViewName = "ContentEntryPicture_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cepUid",),
        entityVersionIdFieldName = "cepTimestamp", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cepContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepMd5",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepFileSize",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepTimestamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepMimeType",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "ceppicture_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntryPicture (cepUid, cepContentEntryUid, cepUri, cepMd5, cepFileSize, cepTimestamp, cepMimeType, cepActive) VALUES( NEW.cepUid, NEW.cepContentEntryUid, NEW.cepUri, NEW.cepMd5, NEW.cepFileSize, NEW.cepTimestamp, NEW.cepMimeType, NEW.cepActive) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntryPicture (cepUid, cepContentEntryUid, cepUri, cepMd5, cepFileSize, cepTimestamp, cepMimeType, cepActive) VALUES( NEW.cepUid, NEW.cepContentEntryUid, NEW.cepUri, NEW.cepMd5, NEW.cepFileSize, NEW.cepTimestamp, NEW.cepMimeType, NEW.cepActive)  ON CONFLICT(cepUid)  DO UPDATE SET cepContentEntryUid = NEW.cepContentEntryUid, cepUri = NEW.cepUri, cepMd5 = NEW.cepMd5, cepFileSize = NEW.cepFileSize, cepTimestamp = NEW.cepTimestamp, cepMimeType = NEW.cepMimeType, cepActive = NEW.cepActive ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cepTimestamp AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryPicture_Existing.cepTimestamp
            |                                   FROM ContentEntryPicture ContentEntryPicture_Existing
            |                                  WHERE ContentEntryPicture_Existing.cepUid = NEW.cepUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cepTimestamp AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryPicture_Existing.cepTimestamp
            |                                   FROM ContentEntryPicture ContentEntryPicture_Existing
            |                                  WHERE ContentEntryPicture_Existing.cepUid = NEW.cepUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        6_401 to ReplicationEntityMetaData(tableId = 6_401, 
        entityTableName = "ActivityInteractionEntity", 
        receiveViewName = "ActivityInteractionEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("aieActivityUid","aieHash",),
        entityVersionIdFieldName = "aieLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "aieActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aieHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aieProp",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aieId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "aieLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aieIsDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "activityinteractionentity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ActivityInteractionEntity (aieActivityUid, aieHash, aieProp, aieId, aieLastMod, aieIsDeleted) VALUES( NEW.aieActivityUid, NEW.aieHash, NEW.aieProp, NEW.aieId, NEW.aieLastMod, NEW.aieIsDeleted) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ActivityInteractionEntity (aieActivityUid, aieHash, aieProp, aieId, aieLastMod, aieIsDeleted) VALUES( NEW.aieActivityUid, NEW.aieHash, NEW.aieProp, NEW.aieId, NEW.aieLastMod, NEW.aieIsDeleted)  ON CONFLICT(aieActivityUid, aieHash)  DO UPDATE SET aieProp = NEW.aieProp, aieId = NEW.aieId, aieLastMod = NEW.aieLastMod, aieIsDeleted = NEW.aieIsDeleted ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.aieLastMod AS BIGINT) >
            |                       COALESCE((SELECT ActivityInteractionEntity_Existing.aieLastMod
            |                                   FROM ActivityInteractionEntity ActivityInteractionEntity_Existing
            |                                  WHERE ActivityInteractionEntity_Existing.aieActivityUid = NEW.aieActivityUid AND ActivityInteractionEntity_Existing.aieHash = NEW.aieHash), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.aieLastMod AS BIGINT) >
            |                       COALESCE((SELECT ActivityInteractionEntity_Existing.aieLastMod
            |                                   FROM ActivityInteractionEntity ActivityInteractionEntity_Existing
            |                                  WHERE ActivityInteractionEntity_Existing.aieActivityUid = NEW.aieActivityUid AND ActivityInteractionEntity_Existing.aieHash = NEW.aieHash), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        125 to ReplicationEntityMetaData(tableId = 125, 
        entityTableName = "CoursePicture", 
        receiveViewName = "CoursePicture_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("coursePictureUid",),
        entityVersionIdFieldName = "coursePictureLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "coursePictureLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "coursePictureUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "coursePictureThumbnailUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "coursePictureActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "coursePictureUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "coursepicture_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CoursePicture (coursePictureUid, coursePictureLct, coursePictureUri, coursePictureThumbnailUri, coursePictureActive) VALUES( NEW.coursePictureUid, NEW.coursePictureLct, NEW.coursePictureUri, NEW.coursePictureThumbnailUri, NEW.coursePictureActive) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CoursePicture (coursePictureUid, coursePictureLct, coursePictureUri, coursePictureThumbnailUri, coursePictureActive) VALUES( NEW.coursePictureUid, NEW.coursePictureLct, NEW.coursePictureUri, NEW.coursePictureThumbnailUri, NEW.coursePictureActive)  ON CONFLICT(coursePictureUid)  DO UPDATE SET coursePictureLct = NEW.coursePictureLct, coursePictureUri = NEW.coursePictureUri, coursePictureThumbnailUri = NEW.coursePictureThumbnailUri, coursePictureActive = NEW.coursePictureActive ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.coursePictureLct AS BIGINT) >
            |                       COALESCE((SELECT CoursePicture_Existing.coursePictureLct
            |                                   FROM CoursePicture CoursePicture_Existing
            |                                  WHERE CoursePicture_Existing.coursePictureUid = NEW.coursePictureUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.coursePictureLct AS BIGINT) >
            |                       COALESCE((SELECT CoursePicture_Existing.coursePictureLct
            |                                   FROM CoursePicture CoursePicture_Existing
            |                                  WHERE CoursePicture_Existing.coursePictureUid = NEW.coursePictureUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        132 to ReplicationEntityMetaData(tableId = 132, 
        entityTableName = "DiscussionPost", 
        receiveViewName = "DiscussionPost_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("discussionPostUid",),
        entityVersionIdFieldName = "discussionPostLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "discussionPostReplyToPostUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostTitle",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostMessage",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostStartDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostCourseBlockUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "dpDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostStartedPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostVisible",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostArchive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "discussionPostUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "discussionpost_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO DiscussionPost (discussionPostUid, discussionPostReplyToPostUid, discussionPostTitle, discussionPostMessage, discussionPostStartDate, discussionPostCourseBlockUid, dpDeleted, discussionPostStartedPersonUid, discussionPostClazzUid, discussionPostLct, discussionPostVisible, discussionPostArchive) VALUES( NEW.discussionPostUid, NEW.discussionPostReplyToPostUid, NEW.discussionPostTitle, NEW.discussionPostMessage, NEW.discussionPostStartDate, NEW.discussionPostCourseBlockUid, NEW.dpDeleted, NEW.discussionPostStartedPersonUid, NEW.discussionPostClazzUid, NEW.discussionPostLct, NEW.discussionPostVisible, NEW.discussionPostArchive) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO DiscussionPost (discussionPostUid, discussionPostReplyToPostUid, discussionPostTitle, discussionPostMessage, discussionPostStartDate, discussionPostCourseBlockUid, dpDeleted, discussionPostStartedPersonUid, discussionPostClazzUid, discussionPostLct, discussionPostVisible, discussionPostArchive) VALUES( NEW.discussionPostUid, NEW.discussionPostReplyToPostUid, NEW.discussionPostTitle, NEW.discussionPostMessage, NEW.discussionPostStartDate, NEW.discussionPostCourseBlockUid, NEW.dpDeleted, NEW.discussionPostStartedPersonUid, NEW.discussionPostClazzUid, NEW.discussionPostLct, NEW.discussionPostVisible, NEW.discussionPostArchive)  ON CONFLICT(discussionPostUid)  DO UPDATE SET discussionPostReplyToPostUid = NEW.discussionPostReplyToPostUid, discussionPostTitle = NEW.discussionPostTitle, discussionPostMessage = NEW.discussionPostMessage, discussionPostStartDate = NEW.discussionPostStartDate, discussionPostCourseBlockUid = NEW.discussionPostCourseBlockUid, dpDeleted = NEW.dpDeleted, discussionPostStartedPersonUid = NEW.discussionPostStartedPersonUid, discussionPostClazzUid = NEW.discussionPostClazzUid, discussionPostLct = NEW.discussionPostLct, discussionPostVisible = NEW.discussionPostVisible, discussionPostArchive = NEW.discussionPostArchive ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.discussionPostLct AS BIGINT) >
            |                       COALESCE((SELECT DiscussionPost_Existing.discussionPostLct
            |                                   FROM DiscussionPost DiscussionPost_Existing
            |                                  WHERE DiscussionPost_Existing.discussionPostUid = NEW.discussionPostUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.discussionPostLct AS BIGINT) >
            |                       COALESCE((SELECT DiscussionPost_Existing.discussionPostLct
            |                                   FROM DiscussionPost DiscussionPost_Existing
            |                                  WHERE DiscussionPost_Existing.discussionPostUid = NEW.discussionPostUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        126 to ReplicationEntityMetaData(tableId = 126, 
        entityTableName = "Message", 
        receiveViewName = "Message_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("messageUid",),
        entityVersionIdFieldName = "messageLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "messageSenderPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "messageToPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "messageText",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "messageTimestamp",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "messageLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "messageUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "message_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO Message (messageUid, messageSenderPersonUid, messageToPersonUid, messageText, messageTimestamp, messageLct) VALUES( NEW.messageUid, NEW.messageSenderPersonUid, NEW.messageToPersonUid, NEW.messageText, NEW.messageTimestamp, NEW.messageLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO Message (messageUid, messageSenderPersonUid, messageToPersonUid, messageText, messageTimestamp, messageLct) VALUES( NEW.messageUid, NEW.messageSenderPersonUid, NEW.messageToPersonUid, NEW.messageText, NEW.messageTimestamp, NEW.messageLct)  ON CONFLICT(messageUid)  DO UPDATE SET messageSenderPersonUid = NEW.messageSenderPersonUid, messageToPersonUid = NEW.messageToPersonUid, messageText = NEW.messageText, messageTimestamp = NEW.messageTimestamp, messageLct = NEW.messageLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.messageLct AS BIGINT) >
            |                       COALESCE((SELECT Message_Existing.messageLct
            |                                   FROM Message Message_Existing
            |                                  WHERE Message_Existing.messageUid = NEW.messageUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.messageLct AS BIGINT) >
            |                       COALESCE((SELECT Message_Existing.messageLct
            |                                   FROM Message Message_Existing
            |                                  WHERE Message_Existing.messageUid = NEW.messageUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        471 to ReplicationEntityMetaData(tableId = 471, 
        entityTableName = "StudentResult", 
        receiveViewName = "StudentResult_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("srUid",),
        entityVersionIdFieldName = "srLastModified", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "srUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srSourcedId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srCourseBlockUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srLineItemSourcedId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srLineItemHref",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srAssignmentUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srMetaData",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srStudentPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srStudentPersonSourcedId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srStudentGroupId",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srMarkerPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srMarkerGroupId",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srScoreStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srScore",
            dbFieldType = 6,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srScoreDate",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srLastModified",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "srComment",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srAppId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "srDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "studentresult_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO StudentResult (srUid, srSourcedId, srCourseBlockUid, srLineItemSourcedId, srLineItemHref, srClazzUid, srAssignmentUid, srStatus, srMetaData, srStudentPersonUid, srStudentPersonSourcedId, srStudentGroupId, srMarkerPersonUid, srMarkerGroupId, srScoreStatus, srScore, srScoreDate, srLastModified, srComment, srAppId, srDeleted) VALUES( NEW.srUid, NEW.srSourcedId, NEW.srCourseBlockUid, NEW.srLineItemSourcedId, NEW.srLineItemHref, NEW.srClazzUid, NEW.srAssignmentUid, NEW.srStatus, NEW.srMetaData, NEW.srStudentPersonUid, NEW.srStudentPersonSourcedId, NEW.srStudentGroupId, NEW.srMarkerPersonUid, NEW.srMarkerGroupId, NEW.srScoreStatus, NEW.srScore, NEW.srScoreDate, NEW.srLastModified, NEW.srComment, NEW.srAppId, NEW.srDeleted) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO StudentResult (srUid, srSourcedId, srCourseBlockUid, srLineItemSourcedId, srLineItemHref, srClazzUid, srAssignmentUid, srStatus, srMetaData, srStudentPersonUid, srStudentPersonSourcedId, srStudentGroupId, srMarkerPersonUid, srMarkerGroupId, srScoreStatus, srScore, srScoreDate, srLastModified, srComment, srAppId, srDeleted) VALUES( NEW.srUid, NEW.srSourcedId, NEW.srCourseBlockUid, NEW.srLineItemSourcedId, NEW.srLineItemHref, NEW.srClazzUid, NEW.srAssignmentUid, NEW.srStatus, NEW.srMetaData, NEW.srStudentPersonUid, NEW.srStudentPersonSourcedId, NEW.srStudentGroupId, NEW.srMarkerPersonUid, NEW.srMarkerGroupId, NEW.srScoreStatus, NEW.srScore, NEW.srScoreDate, NEW.srLastModified, NEW.srComment, NEW.srAppId, NEW.srDeleted)  ON CONFLICT(srUid)  DO UPDATE SET srSourcedId = NEW.srSourcedId, srCourseBlockUid = NEW.srCourseBlockUid, srLineItemSourcedId = NEW.srLineItemSourcedId, srLineItemHref = NEW.srLineItemHref, srClazzUid = NEW.srClazzUid, srAssignmentUid = NEW.srAssignmentUid, srStatus = NEW.srStatus, srMetaData = NEW.srMetaData, srStudentPersonUid = NEW.srStudentPersonUid, srStudentPersonSourcedId = NEW.srStudentPersonSourcedId, srStudentGroupId = NEW.srStudentGroupId, srMarkerPersonUid = NEW.srMarkerPersonUid, srMarkerGroupId = NEW.srMarkerGroupId, srScoreStatus = NEW.srScoreStatus, srScore = NEW.srScore, srScoreDate = NEW.srScoreDate, srLastModified = NEW.srLastModified, srComment = NEW.srComment, srAppId = NEW.srAppId, srDeleted = NEW.srDeleted ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.srLastModified AS BIGINT) >
            |                       COALESCE((SELECT StudentResult_Existing.srLastModified
            |                                   FROM StudentResult StudentResult_Existing
            |                                  WHERE StudentResult_Existing.srUid = NEW.srUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.srLastModified AS BIGINT) >
            |                       COALESCE((SELECT StudentResult_Existing.srLastModified
            |                                   FROM StudentResult StudentResult_Existing
            |                                  WHERE StudentResult_Existing.srUid = NEW.srUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        738 to ReplicationEntityMetaData(tableId = 738, 
        entityTableName = "ContentEntryVersion", 
        receiveViewName = "ContentEntryVersion_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cevUid",),
        entityVersionIdFieldName = "cevLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cevContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevOpenUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevContentType",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevManifestUrl",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevSize",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevInActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevLastModified",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevStorageSize",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevOriginalSize",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cevUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "content_entry_version_remote_ins",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntryVersion (cevUid, cevContentEntryUid, cevOpenUri, cevContentType, cevManifestUrl, cevSize, cevInActive, cevLastModified, cevLct, cevStorageSize, cevOriginalSize) VALUES( NEW.cevUid, NEW.cevContentEntryUid, NEW.cevOpenUri, NEW.cevContentType, NEW.cevManifestUrl, NEW.cevSize, NEW.cevInActive, NEW.cevLastModified, NEW.cevLct, NEW.cevStorageSize, NEW.cevOriginalSize) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntryVersion (cevUid, cevContentEntryUid, cevOpenUri, cevContentType, cevManifestUrl, cevSize, cevInActive, cevLastModified, cevLct, cevStorageSize, cevOriginalSize) VALUES( NEW.cevUid, NEW.cevContentEntryUid, NEW.cevOpenUri, NEW.cevContentType, NEW.cevManifestUrl, NEW.cevSize, NEW.cevInActive, NEW.cevLastModified, NEW.cevLct, NEW.cevStorageSize, NEW.cevOriginalSize)  ON CONFLICT(cevUid)  DO UPDATE SET cevContentEntryUid = NEW.cevContentEntryUid, cevOpenUri = NEW.cevOpenUri, cevContentType = NEW.cevContentType, cevManifestUrl = NEW.cevManifestUrl, cevSize = NEW.cevSize, cevInActive = NEW.cevInActive, cevLastModified = NEW.cevLastModified, cevLct = NEW.cevLct, cevStorageSize = NEW.cevStorageSize, cevOriginalSize = NEW.cevOriginalSize ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cevLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryVersion_Existing.cevLct
            |                                   FROM ContentEntryVersion ContentEntryVersion_Existing
            |                                  WHERE ContentEntryVersion_Existing.cevUid = NEW.cevUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cevLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryVersion_Existing.cevLct
            |                                   FROM ContentEntryVersion ContentEntryVersion_Existing
            |                                  WHERE ContentEntryVersion_Existing.cevUid = NEW.cevUid), 0)
            |                   
            """.trimMargin(),
          ),Trigger(
            name = "content_entry_version_offline_item",
            order = Trigger.Order.AFTER,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.ENTITY,
            sqlStatements = arrayOf(
              """
              |
              |                INSERT INTO OfflineItemPendingTransferJob(oiptjOiUid, oiptjTableId, oiptjEntityUid, oiptjType)
              |                VALUES ((SELECT COALESCE((
              |                 SELECT OfflineItem.oiUid
              |                   FROM OfflineItem
              |                  WHERE OfflineItem.oiContentEntryUid = NEW.cevContentEntryUid
              |                    AND CAST(OfflineItem.oiActive AS INTEGER) = 1
              |                    AND OfflineItem.oiNodeId = 
              |            (SELECT COALESCE(
              |                    (SELECT nodeClientId 
              |                       FROM SyncNode 
              |                      LIMIT 1), 0))
              |        
              |        ), 0)),
              |                        738, NEW.cevUid, 2)
              |            
              """.trimMargin(),
            ),
            postgreSqlStatements = arrayOf(
              """
              |
              |                INSERT INTO OfflineItemPendingTransferJob(oiptjOiUid, oiptjTableId, oiptjEntityUid, oiptjType)
              |                VALUES ((SELECT COALESCE((
              |                 SELECT OfflineItem.oiUid
              |                   FROM OfflineItem
              |                  WHERE OfflineItem.oiContentEntryUid = NEW.cevContentEntryUid
              |                    AND CAST(OfflineItem.oiActive AS INTEGER) = 1
              |                    AND OfflineItem.oiNodeId = 
              |            (SELECT COALESCE(
              |                    (SELECT nodeClientId 
              |                       FROM SyncNode 
              |                      LIMIT 1), 0))
              |        
              |        ), 0)),
              |                        738, NEW.cevUid, 2)
              |            
              """.trimMargin(),
            ),
            conditionSql = """
            |
            |                 SELECT EXISTS(
            |                 SELECT OfflineItem.oiUid
            |                   FROM OfflineItem
            |                  WHERE OfflineItem.oiContentEntryUid = NEW.cevContentEntryUid
            |                    AND CAST(OfflineItem.oiActive AS INTEGER) = 1
            |                    AND OfflineItem.oiNodeId = 
            |            (SELECT COALESCE(
            |                    (SELECT nodeClientId 
            |                       FROM SyncNode 
            |                      LIMIT 1), 0))
            |        
            |        )
            |                    AND NOT EXISTS
            |                        (SELECT TransferJob.tjUid
            |                           FROM TransferJob
            |                          WHERE TransferJob.tjTableId = 738
            |                            AND TransferJob.tjEntityUid = NEW.cevUid)
            |                 
            """.trimMargin(),
            conditionSqlPostgres = """
            |
            |                 SELECT EXISTS(
            |                 SELECT OfflineItem.oiUid
            |                   FROM OfflineItem
            |                  WHERE OfflineItem.oiContentEntryUid = NEW.cevContentEntryUid
            |                    AND CAST(OfflineItem.oiActive AS INTEGER) = 1
            |                    AND OfflineItem.oiNodeId = 
            |            (SELECT COALESCE(
            |                    (SELECT nodeClientId 
            |                       FROM SyncNode 
            |                      LIMIT 1), 0))
            |        
            |        )
            |                    AND NOT EXISTS
            |                        (SELECT TransferJob.tjUid
            |                           FROM TransferJob
            |                          WHERE TransferJob.tjTableId = 738
            |                            AND TransferJob.tjEntityUid = NEW.cevUid)
            |                 
            """.trimMargin(),
          ),),
        ),
        971 to ReplicationEntityMetaData(tableId = 971, 
        entityTableName = "OfflineItem", 
        receiveViewName = "OfflineItem_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("oiUid",),
        entityVersionIdFieldName = "oiLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "oiNodeId",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "oiClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "oiCourseBlockUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "oiContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "oiActive",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "oiLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "oiUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "offline_item_remote_ins",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO OfflineItem (oiUid, oiNodeId, oiClazzUid, oiCourseBlockUid, oiContentEntryUid, oiActive, oiLct) VALUES( NEW.oiUid, NEW.oiNodeId, NEW.oiClazzUid, NEW.oiCourseBlockUid, NEW.oiContentEntryUid, NEW.oiActive, NEW.oiLct) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO OfflineItem (oiUid, oiNodeId, oiClazzUid, oiCourseBlockUid, oiContentEntryUid, oiActive, oiLct) VALUES( NEW.oiUid, NEW.oiNodeId, NEW.oiClazzUid, NEW.oiCourseBlockUid, NEW.oiContentEntryUid, NEW.oiActive, NEW.oiLct)  ON CONFLICT(oiUid)  DO UPDATE SET oiNodeId = NEW.oiNodeId, oiClazzUid = NEW.oiClazzUid, oiCourseBlockUid = NEW.oiCourseBlockUid, oiContentEntryUid = NEW.oiContentEntryUid, oiActive = NEW.oiActive, oiLct = NEW.oiLct ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.oiLct AS BIGINT) >
            |                       COALESCE((SELECT OfflineItem_Existing.oiLct
            |                                   FROM OfflineItem OfflineItem_Existing
            |                                  WHERE OfflineItem_Existing.oiUid = NEW.oiUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.oiLct AS BIGINT) >
            |                       COALESCE((SELECT OfflineItem_Existing.oiLct
            |                                   FROM OfflineItem OfflineItem_Existing
            |                                  WHERE OfflineItem_Existing.oiUid = NEW.oiUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        999 to ReplicationEntityMetaData(tableId = 999, 
        entityTableName = "DeletedItem", 
        receiveViewName = "DeletedItem_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("delItemUid",),
        entityVersionIdFieldName = "delItemLastModTime", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "delItemName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemIconUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemLastModTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemTimeDeleted",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemEntityTable",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemEntityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemDeletedByPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemIsFolder",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "delItemUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "deleteditem_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO DeletedItem (delItemUid, delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder) VALUES( NEW.delItemUid, NEW.delItemName, NEW.delItemIconUri, NEW.delItemLastModTime, NEW.delItemTimeDeleted, NEW.delItemEntityTable, NEW.delItemEntityUid, NEW.delItemDeletedByPersonUid, NEW.delItemStatus, NEW.delItemIsFolder) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO DeletedItem (delItemUid, delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder) VALUES( NEW.delItemUid, NEW.delItemName, NEW.delItemIconUri, NEW.delItemLastModTime, NEW.delItemTimeDeleted, NEW.delItemEntityTable, NEW.delItemEntityUid, NEW.delItemDeletedByPersonUid, NEW.delItemStatus, NEW.delItemIsFolder)  ON CONFLICT(delItemUid)  DO UPDATE SET delItemName = NEW.delItemName, delItemIconUri = NEW.delItemIconUri, delItemLastModTime = NEW.delItemLastModTime, delItemTimeDeleted = NEW.delItemTimeDeleted, delItemEntityTable = NEW.delItemEntityTable, delItemEntityUid = NEW.delItemEntityUid, delItemDeletedByPersonUid = NEW.delItemDeletedByPersonUid, delItemStatus = NEW.delItemStatus, delItemIsFolder = NEW.delItemIsFolder ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.delItemLastModTime AS BIGINT) >
            |                       COALESCE((SELECT DeletedItem_Existing.delItemLastModTime
            |                                   FROM DeletedItem DeletedItem_Existing
            |                                  WHERE DeletedItem_Existing.delItemUid = NEW.delItemUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.delItemLastModTime AS BIGINT) >
            |                       COALESCE((SELECT DeletedItem_Existing.delItemLastModTime
            |                                   FROM DeletedItem DeletedItem_Existing
            |                                  WHERE DeletedItem_Existing.delItemUid = NEW.delItemUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        10_070 to ReplicationEntityMetaData(tableId = 10_070, 
        entityTableName = "EnrolmentRequest", 
        receiveViewName = "EnrolmentRequest_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("erUid",),
        entityVersionIdFieldName = "erLastModified", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "erClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erClazzName",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "erPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erPersonFullname",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "erPersonPictureUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "erPersonUsername",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "erRole",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erRequestTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erStatus",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erStatusSetByPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erStatusSetAuth",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "erLastModified",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "erUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "enrolmentrequest_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO EnrolmentRequest (erUid, erClazzUid, erClazzName, erPersonUid, erPersonFullname, erPersonPictureUri, erPersonUsername, erRole, erRequestTime, erStatus, erStatusSetByPersonUid, erDeleted, erStatusSetAuth, erLastModified) VALUES( NEW.erUid, NEW.erClazzUid, NEW.erClazzName, NEW.erPersonUid, NEW.erPersonFullname, NEW.erPersonPictureUri, NEW.erPersonUsername, NEW.erRole, NEW.erRequestTime, NEW.erStatus, NEW.erStatusSetByPersonUid, NEW.erDeleted, NEW.erStatusSetAuth, NEW.erLastModified) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO EnrolmentRequest (erUid, erClazzUid, erClazzName, erPersonUid, erPersonFullname, erPersonPictureUri, erPersonUsername, erRole, erRequestTime, erStatus, erStatusSetByPersonUid, erDeleted, erStatusSetAuth, erLastModified) VALUES( NEW.erUid, NEW.erClazzUid, NEW.erClazzName, NEW.erPersonUid, NEW.erPersonFullname, NEW.erPersonPictureUri, NEW.erPersonUsername, NEW.erRole, NEW.erRequestTime, NEW.erStatus, NEW.erStatusSetByPersonUid, NEW.erDeleted, NEW.erStatusSetAuth, NEW.erLastModified)  ON CONFLICT(erUid)  DO UPDATE SET erClazzUid = NEW.erClazzUid, erClazzName = NEW.erClazzName, erPersonUid = NEW.erPersonUid, erPersonFullname = NEW.erPersonFullname, erPersonPictureUri = NEW.erPersonPictureUri, erPersonUsername = NEW.erPersonUsername, erRole = NEW.erRole, erRequestTime = NEW.erRequestTime, erStatus = NEW.erStatus, erStatusSetByPersonUid = NEW.erStatusSetByPersonUid, erDeleted = NEW.erDeleted, erStatusSetAuth = NEW.erStatusSetAuth, erLastModified = NEW.erLastModified ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.erLastModified AS BIGINT) >
            |                       COALESCE((SELECT EnrolmentRequest_Existing.erLastModified
            |                                   FROM EnrolmentRequest EnrolmentRequest_Existing
            |                                  WHERE EnrolmentRequest_Existing.erUid = NEW.erUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.erLastModified AS BIGINT) >
            |                       COALESCE((SELECT EnrolmentRequest_Existing.erLastModified
            |                                   FROM EnrolmentRequest EnrolmentRequest_Existing
            |                                  WHERE EnrolmentRequest_Existing.erUid = NEW.erUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        10_012 to ReplicationEntityMetaData(tableId = 10_012, 
        entityTableName = "CoursePermission", 
        receiveViewName = "CoursePermission_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cpUid",),
        entityVersionIdFieldName = "cpLastModified", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cpLastModified",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpToEnrolmentRole",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpToPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpToGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpPermissionsFlag",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpIsDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cpUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "coursepermission_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CoursePermission (cpUid, cpLastModified, cpClazzUid, cpToEnrolmentRole, cpToPersonUid, cpToGroupUid, cpPermissionsFlag, cpIsDeleted) VALUES( NEW.cpUid, NEW.cpLastModified, NEW.cpClazzUid, NEW.cpToEnrolmentRole, NEW.cpToPersonUid, NEW.cpToGroupUid, NEW.cpPermissionsFlag, NEW.cpIsDeleted) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CoursePermission (cpUid, cpLastModified, cpClazzUid, cpToEnrolmentRole, cpToPersonUid, cpToGroupUid, cpPermissionsFlag, cpIsDeleted) VALUES( NEW.cpUid, NEW.cpLastModified, NEW.cpClazzUid, NEW.cpToEnrolmentRole, NEW.cpToPersonUid, NEW.cpToGroupUid, NEW.cpPermissionsFlag, NEW.cpIsDeleted)  ON CONFLICT(cpUid)  DO UPDATE SET cpLastModified = NEW.cpLastModified, cpClazzUid = NEW.cpClazzUid, cpToEnrolmentRole = NEW.cpToEnrolmentRole, cpToPersonUid = NEW.cpToPersonUid, cpToGroupUid = NEW.cpToGroupUid, cpPermissionsFlag = NEW.cpPermissionsFlag, cpIsDeleted = NEW.cpIsDeleted ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cpLastModified AS BIGINT) >
            |                       COALESCE((SELECT CoursePermission_Existing.cpLastModified
            |                                   FROM CoursePermission CoursePermission_Existing
            |                                  WHERE CoursePermission_Existing.cpUid = NEW.cpUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cpLastModified AS BIGINT) >
            |                       COALESCE((SELECT CoursePermission_Existing.cpLastModified
            |                                   FROM CoursePermission CoursePermission_Existing
            |                                  WHERE CoursePermission_Existing.cpUid = NEW.cpUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        10_011 to ReplicationEntityMetaData(tableId = 10_011, 
        entityTableName = "SystemPermission", 
        receiveViewName = "SystemPermission_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("spUid",),
        entityVersionIdFieldName = "spLastModified", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "spToPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "spToGroupUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "spPermissionsFlag",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "spLastModified",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "spIsDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "spUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "systempermission_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO SystemPermission (spUid, spToPersonUid, spToGroupUid, spPermissionsFlag, spLastModified, spIsDeleted) VALUES( NEW.spUid, NEW.spToPersonUid, NEW.spToGroupUid, NEW.spPermissionsFlag, NEW.spLastModified, NEW.spIsDeleted) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO SystemPermission (spUid, spToPersonUid, spToGroupUid, spPermissionsFlag, spLastModified, spIsDeleted) VALUES( NEW.spUid, NEW.spToPersonUid, NEW.spToGroupUid, NEW.spPermissionsFlag, NEW.spLastModified, NEW.spIsDeleted)  ON CONFLICT(spUid)  DO UPDATE SET spToPersonUid = NEW.spToPersonUid, spToGroupUid = NEW.spToGroupUid, spPermissionsFlag = NEW.spPermissionsFlag, spLastModified = NEW.spLastModified, spIsDeleted = NEW.spIsDeleted ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.spLastModified AS BIGINT) >
            |                       COALESCE((SELECT SystemPermission_Existing.spLastModified
            |                                   FROM SystemPermission SystemPermission_Existing
            |                                  WHERE SystemPermission_Existing.spUid = NEW.spUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.spLastModified AS BIGINT) >
            |                       COALESCE((SELECT SystemPermission_Existing.spLastModified
            |                                   FROM SystemPermission SystemPermission_Existing
            |                                  WHERE SystemPermission_Existing.spUid = NEW.spUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        6_677 to ReplicationEntityMetaData(tableId = 6_677, 
        entityTableName = "CourseBlockPicture", 
        receiveViewName = "CourseBlockPicture_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cbpUid",),
        entityVersionIdFieldName = "cbpLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cbpUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbpLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbpPictureUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cbpThumbnailUri",
            dbFieldType = -1,
            nullable = true,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "courseblockpicture_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO CourseBlockPicture (cbpUid, cbpLct, cbpPictureUri, cbpThumbnailUri) VALUES( NEW.cbpUid, NEW.cbpLct, NEW.cbpPictureUri, NEW.cbpThumbnailUri) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO CourseBlockPicture (cbpUid, cbpLct, cbpPictureUri, cbpThumbnailUri) VALUES( NEW.cbpUid, NEW.cbpLct, NEW.cbpPictureUri, NEW.cbpThumbnailUri)  ON CONFLICT(cbpUid)  DO UPDATE SET cbpLct = NEW.cbpLct, cbpPictureUri = NEW.cbpPictureUri, cbpThumbnailUri = NEW.cbpThumbnailUri ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cbpLct AS BIGINT) >
            |                       COALESCE((SELECT CourseBlockPicture_Existing.cbpLct
            |                                   FROM CourseBlockPicture CourseBlockPicture_Existing
            |                                  WHERE CourseBlockPicture_Existing.cbpUid = NEW.cbpUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cbpLct AS BIGINT) >
            |                       COALESCE((SELECT CourseBlockPicture_Existing.cbpLct
            |                                   FROM CourseBlockPicture CourseBlockPicture_Existing
            |                                  WHERE CourseBlockPicture_Existing.cbpUid = NEW.cbpUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        6_678 to ReplicationEntityMetaData(tableId = 6_678, 
        entityTableName = "ContentEntryPicture2", 
        receiveViewName = "ContentEntryPicture2_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("cepUid",),
        entityVersionIdFieldName = "cepLct", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "cepUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepLct",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepPictureUri",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "cepThumbnailUri",
            dbFieldType = -1,
            nullable = true,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "contententrypicture2_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ContentEntryPicture2 (cepUid, cepLct, cepPictureUri, cepThumbnailUri) VALUES( NEW.cepUid, NEW.cepLct, NEW.cepPictureUri, NEW.cepThumbnailUri) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ContentEntryPicture2 (cepUid, cepLct, cepPictureUri, cepThumbnailUri) VALUES( NEW.cepUid, NEW.cepLct, NEW.cepPictureUri, NEW.cepThumbnailUri)  ON CONFLICT(cepUid)  DO UPDATE SET cepLct = NEW.cepLct, cepPictureUri = NEW.cepPictureUri, cepThumbnailUri = NEW.cepThumbnailUri ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.cepLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryPicture2_Existing.cepLct
            |                                   FROM ContentEntryPicture2 ContentEntryPicture2_Existing
            |                                  WHERE ContentEntryPicture2_Existing.cepUid = NEW.cepUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.cepLct AS BIGINT) >
            |                       COALESCE((SELECT ContentEntryPicture2_Existing.cepLct
            |                                   FROM ContentEntryPicture2 ContentEntryPicture2_Existing
            |                                  WHERE ContentEntryPicture2_Existing.cepUid = NEW.cepUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        620 to ReplicationEntityMetaData(tableId = 620, 
        entityTableName = "VerbLangMapEntry", 
        receiveViewName = "VerbLangMapEntry_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("vlmeVerbUid","vlmeLangHash",),
        entityVersionIdFieldName = "vlmeLastModified", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "vlmeVerbUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "vlmeLangHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "vlmeLangCode",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "vlmeEntryString",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "vlmeLastModified",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "verblangmapentry_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO VerbLangMapEntry (vlmeVerbUid, vlmeLangHash, vlmeLangCode, vlmeEntryString, vlmeLastModified) VALUES( NEW.vlmeVerbUid, NEW.vlmeLangHash, NEW.vlmeLangCode, NEW.vlmeEntryString, NEW.vlmeLastModified) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO VerbLangMapEntry (vlmeVerbUid, vlmeLangHash, vlmeLangCode, vlmeEntryString, vlmeLastModified) VALUES( NEW.vlmeVerbUid, NEW.vlmeLangHash, NEW.vlmeLangCode, NEW.vlmeEntryString, NEW.vlmeLastModified)  ON CONFLICT(vlmeVerbUid, vlmeLangHash)  DO UPDATE SET vlmeLangCode = NEW.vlmeLangCode, vlmeEntryString = NEW.vlmeEntryString, vlmeLastModified = NEW.vlmeLastModified ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.vlmeLastModified AS BIGINT) >
            |                       COALESCE((SELECT VerbLangMapEntry_Existing.vlmeLastModified
            |                                   FROM VerbLangMapEntry VerbLangMapEntry_Existing
            |                                  WHERE VerbLangMapEntry_Existing.vlmeVerbUid = NEW.vlmeVerbUid AND VerbLangMapEntry_Existing.vlmeLangHash = NEW.vlmeLangHash), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.vlmeLastModified AS BIGINT) >
            |                       COALESCE((SELECT VerbLangMapEntry_Existing.vlmeLastModified
            |                                   FROM VerbLangMapEntry VerbLangMapEntry_Existing
            |                                  WHERE VerbLangMapEntry_Existing.vlmeVerbUid = NEW.vlmeVerbUid AND VerbLangMapEntry_Existing.vlmeLangHash = NEW.vlmeLangHash), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        4_232 to ReplicationEntityMetaData(tableId = 4_232, 
        entityTableName = "GroupMemberActorJoin", 
        receiveViewName = "GroupMemberActorJoin_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("gmajGroupActorUid","gmajMemberActorUid",),
        entityVersionIdFieldName = "gmajLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "gmajGroupActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "gmajMemberActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "gmajLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "groupmemberactorjoin_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO GroupMemberActorJoin (gmajGroupActorUid, gmajMemberActorUid, gmajLastMod) VALUES( NEW.gmajGroupActorUid, NEW.gmajMemberActorUid, NEW.gmajLastMod) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO GroupMemberActorJoin (gmajGroupActorUid, gmajMemberActorUid, gmajLastMod) VALUES( NEW.gmajGroupActorUid, NEW.gmajMemberActorUid, NEW.gmajLastMod)  ON CONFLICT(gmajGroupActorUid, gmajMemberActorUid)  DO UPDATE SET gmajLastMod = NEW.gmajLastMod ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.gmajLastMod AS BIGINT) >
            |                       COALESCE((SELECT GroupMemberActorJoin_Existing.gmajLastMod
            |                                   FROM GroupMemberActorJoin GroupMemberActorJoin_Existing
            |                                  WHERE GroupMemberActorJoin_Existing.gmajGroupActorUid = NEW.gmajGroupActorUid AND GroupMemberActorJoin_Existing.gmajMemberActorUid = NEW.gmajMemberActorUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.gmajLastMod AS BIGINT) >
            |                       COALESCE((SELECT GroupMemberActorJoin_Existing.gmajLastMod
            |                                   FROM GroupMemberActorJoin GroupMemberActorJoin_Existing
            |                                  WHERE GroupMemberActorJoin_Existing.gmajGroupActorUid = NEW.gmajGroupActorUid AND GroupMemberActorJoin_Existing.gmajMemberActorUid = NEW.gmajMemberActorUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        6_442 to ReplicationEntityMetaData(tableId = 6_442, 
        entityTableName = "ActivityLangMapEntry", 
        receiveViewName = "ActivityLangMapEntry_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("almeActivityUid","almeHash",),
        entityVersionIdFieldName = "almeLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "almeActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "almeHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "almeLangCode",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "almeValue",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "almeAieHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "almeLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "activitylangmapentry_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ActivityLangMapEntry (almeActivityUid, almeHash, almeLangCode, almeValue, almeAieHash, almeLastMod) VALUES( NEW.almeActivityUid, NEW.almeHash, NEW.almeLangCode, NEW.almeValue, NEW.almeAieHash, NEW.almeLastMod) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ActivityLangMapEntry (almeActivityUid, almeHash, almeLangCode, almeValue, almeAieHash, almeLastMod) VALUES( NEW.almeActivityUid, NEW.almeHash, NEW.almeLangCode, NEW.almeValue, NEW.almeAieHash, NEW.almeLastMod)  ON CONFLICT(almeActivityUid, almeHash)  DO UPDATE SET almeLangCode = NEW.almeLangCode, almeValue = NEW.almeValue, almeAieHash = NEW.almeAieHash, almeLastMod = NEW.almeLastMod ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.almeLastMod AS BIGINT) >
            |                       COALESCE((SELECT ActivityLangMapEntry_Existing.almeLastMod
            |                                   FROM ActivityLangMapEntry ActivityLangMapEntry_Existing
            |                                  WHERE ActivityLangMapEntry_Existing.almeActivityUid = NEW.almeActivityUid AND ActivityLangMapEntry_Existing.almeHash = NEW.almeHash), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.almeLastMod AS BIGINT) >
            |                       COALESCE((SELECT ActivityLangMapEntry_Existing.almeLastMod
            |                                   FROM ActivityLangMapEntry ActivityLangMapEntry_Existing
            |                                  WHERE ActivityLangMapEntry_Existing.almeActivityUid = NEW.almeActivityUid AND ActivityLangMapEntry_Existing.almeHash = NEW.almeHash), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        6_405 to ReplicationEntityMetaData(tableId = 6_405, 
        entityTableName = "ActivityExtensionEntity", 
        receiveViewName = "ActivityExtensionEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("aeeActivityUid","aeeKeyHash",),
        entityVersionIdFieldName = "aeeLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "aeeActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aeeKeyHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aeeKey",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "aeeJson",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "aeeLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "aeeIsDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "activityextensionentity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO ActivityExtensionEntity (aeeActivityUid, aeeKeyHash, aeeKey, aeeJson, aeeLastMod, aeeIsDeleted) VALUES( NEW.aeeActivityUid, NEW.aeeKeyHash, NEW.aeeKey, NEW.aeeJson, NEW.aeeLastMod, NEW.aeeIsDeleted) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO ActivityExtensionEntity (aeeActivityUid, aeeKeyHash, aeeKey, aeeJson, aeeLastMod, aeeIsDeleted) VALUES( NEW.aeeActivityUid, NEW.aeeKeyHash, NEW.aeeKey, NEW.aeeJson, NEW.aeeLastMod, NEW.aeeIsDeleted)  ON CONFLICT(aeeActivityUid, aeeKeyHash)  DO UPDATE SET aeeKey = NEW.aeeKey, aeeJson = NEW.aeeJson, aeeLastMod = NEW.aeeLastMod, aeeIsDeleted = NEW.aeeIsDeleted ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.aeeLastMod AS BIGINT) >
            |                       COALESCE((SELECT ActivityExtensionEntity_Existing.aeeLastMod
            |                                   FROM ActivityExtensionEntity ActivityExtensionEntity_Existing
            |                                  WHERE ActivityExtensionEntity_Existing.aeeActivityUid = NEW.aeeActivityUid AND ActivityExtensionEntity_Existing.aeeKeyHash = NEW.aeeKeyHash), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.aeeLastMod AS BIGINT) >
            |                       COALESCE((SELECT ActivityExtensionEntity_Existing.aeeLastMod
            |                                   FROM ActivityExtensionEntity ActivityExtensionEntity_Existing
            |                                  WHERE ActivityExtensionEntity_Existing.aeeActivityUid = NEW.aeeActivityUid AND ActivityExtensionEntity_Existing.aeeKeyHash = NEW.aeeKeyHash), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        44_044 to ReplicationEntityMetaData(tableId = 44_044, 
        entityTableName = "StatementContextActivityJoin", 
        receiveViewName = "StatementContextActivityJoin_ReceiveView", 
        entityPrimaryKeyFieldNames =
            listOf("scajFromStatementIdHi","scajFromStatementIdLo","scajToHash",),
        entityVersionIdFieldName = "scajEtag", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "scajFromStatementIdHi",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scajFromStatementIdLo",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scajToHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scajContextType",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scajToActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "scajToActivityId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "scajEtag",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "statementcontextactivityjoin_remoteinsert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO StatementContextActivityJoin (scajFromStatementIdHi, scajFromStatementIdLo, scajToHash, scajContextType, scajToActivityUid, scajToActivityId, scajEtag) VALUES( NEW.scajFromStatementIdHi, NEW.scajFromStatementIdLo, NEW.scajToHash, NEW.scajContextType, NEW.scajToActivityUid, NEW.scajToActivityId, NEW.scajEtag) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO StatementContextActivityJoin (scajFromStatementIdHi, scajFromStatementIdLo, scajToHash, scajContextType, scajToActivityUid, scajToActivityId, scajEtag) VALUES( NEW.scajFromStatementIdHi, NEW.scajFromStatementIdLo, NEW.scajToHash, NEW.scajContextType, NEW.scajToActivityUid, NEW.scajToActivityId, NEW.scajEtag)  ON CONFLICT(scajFromStatementIdHi, scajFromStatementIdLo, scajToHash)  DO UPDATE SET scajContextType = NEW.scajContextType, scajToActivityUid = NEW.scajToActivityUid, scajToActivityId = NEW.scajToActivityId, scajEtag = NEW.scajEtag ",
            ),
            conditionSql = """
            |SELECT 
            |               CAST(NEW.scajEtag AS BIGINT) != 
            |                   COALESCE((SELECT StatementContextActivityJoin_Existing.scajEtag
            |                                   FROM StatementContextActivityJoin StatementContextActivityJoin_Existing
            |                                  WHERE StatementContextActivityJoin_Existing.scajFromStatementIdHi = NEW.scajFromStatementIdHi AND StatementContextActivityJoin_Existing.scajFromStatementIdLo = NEW.scajFromStatementIdLo AND StatementContextActivityJoin_Existing.scajToHash = NEW.scajToHash), 0)
            |            
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |               CAST(NEW.scajEtag AS BIGINT) != 
            |                   COALESCE((SELECT StatementContextActivityJoin_Existing.scajEtag
            |                                   FROM StatementContextActivityJoin StatementContextActivityJoin_Existing
            |                                  WHERE StatementContextActivityJoin_Existing.scajFromStatementIdHi = NEW.scajFromStatementIdHi AND StatementContextActivityJoin_Existing.scajFromStatementIdLo = NEW.scajFromStatementIdLo AND StatementContextActivityJoin_Existing.scajToHash = NEW.scajToHash), 0)
            |            
            """.trimMargin(),
          ),),
        ),
        400_122 to ReplicationEntityMetaData(tableId = 400_122, 
        entityTableName = "XapiSessionEntity", 
        receiveViewName = "XapiSessionEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("xseUid",),
        entityVersionIdFieldName = "xseLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "xseLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseRegistrationHi",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseRegistrationLo",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseUsUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseAccountPersonUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseAccountUsername",
            dbFieldType = -1,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseClazzUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseCbUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseContentEntryUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseContentEntryVersionUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseRootActivityId",
            dbFieldType = -1,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseRootActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseStartTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseExpireTime",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseAuth",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseCompleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "knownActorUidToPersonUids",
            dbFieldType = -1,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "xseUid",
            dbFieldType = -5,
            nullable = false,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "xapisessionentity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO XapiSessionEntity (xseUid, xseLastMod, xseRegistrationHi, xseRegistrationLo, xseUsUid, xseAccountPersonUid, xseActorUid, xseAccountUsername, xseClazzUid, xseCbUid, xseContentEntryUid, xseContentEntryVersionUid, xseRootActivityId, xseRootActivityUid, xseStartTime, xseExpireTime, xseAuth, xseCompleted, knownActorUidToPersonUids) VALUES( NEW.xseUid, NEW.xseLastMod, NEW.xseRegistrationHi, NEW.xseRegistrationLo, NEW.xseUsUid, NEW.xseAccountPersonUid, NEW.xseActorUid, NEW.xseAccountUsername, NEW.xseClazzUid, NEW.xseCbUid, NEW.xseContentEntryUid, NEW.xseContentEntryVersionUid, NEW.xseRootActivityId, NEW.xseRootActivityUid, NEW.xseStartTime, NEW.xseExpireTime, NEW.xseAuth, NEW.xseCompleted, NEW.knownActorUidToPersonUids) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO XapiSessionEntity (xseUid, xseLastMod, xseRegistrationHi, xseRegistrationLo, xseUsUid, xseAccountPersonUid, xseActorUid, xseAccountUsername, xseClazzUid, xseCbUid, xseContentEntryUid, xseContentEntryVersionUid, xseRootActivityId, xseRootActivityUid, xseStartTime, xseExpireTime, xseAuth, xseCompleted, knownActorUidToPersonUids) VALUES( NEW.xseUid, NEW.xseLastMod, NEW.xseRegistrationHi, NEW.xseRegistrationLo, NEW.xseUsUid, NEW.xseAccountPersonUid, NEW.xseActorUid, NEW.xseAccountUsername, NEW.xseClazzUid, NEW.xseCbUid, NEW.xseContentEntryUid, NEW.xseContentEntryVersionUid, NEW.xseRootActivityId, NEW.xseRootActivityUid, NEW.xseStartTime, NEW.xseExpireTime, NEW.xseAuth, NEW.xseCompleted, NEW.knownActorUidToPersonUids)  ON CONFLICT(xseUid)  DO UPDATE SET xseLastMod = NEW.xseLastMod, xseRegistrationHi = NEW.xseRegistrationHi, xseRegistrationLo = NEW.xseRegistrationLo, xseUsUid = NEW.xseUsUid, xseAccountPersonUid = NEW.xseAccountPersonUid, xseActorUid = NEW.xseActorUid, xseAccountUsername = NEW.xseAccountUsername, xseClazzUid = NEW.xseClazzUid, xseCbUid = NEW.xseCbUid, xseContentEntryUid = NEW.xseContentEntryUid, xseContentEntryVersionUid = NEW.xseContentEntryVersionUid, xseRootActivityId = NEW.xseRootActivityId, xseRootActivityUid = NEW.xseRootActivityUid, xseStartTime = NEW.xseStartTime, xseExpireTime = NEW.xseExpireTime, xseAuth = NEW.xseAuth, xseCompleted = NEW.xseCompleted, knownActorUidToPersonUids = NEW.knownActorUidToPersonUids ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.xseLastMod AS BIGINT) >
            |                       COALESCE((SELECT XapiSessionEntity_Existing.xseLastMod
            |                                   FROM XapiSessionEntity XapiSessionEntity_Existing
            |                                  WHERE XapiSessionEntity_Existing.xseUid = NEW.xseUid), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.xseLastMod AS BIGINT) >
            |                       COALESCE((SELECT XapiSessionEntity_Existing.xseLastMod
            |                                   FROM XapiSessionEntity XapiSessionEntity_Existing
            |                                  WHERE XapiSessionEntity_Existing.xseUid = NEW.xseUid), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        602 to ReplicationEntityMetaData(tableId = 602, 
        entityTableName = "StatementEntityJson", 
        receiveViewName = "StatementEntityJson_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("stmtJsonIdHi","stmtJsonIdLo",),
        entityVersionIdFieldName = "stmtEtag", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "stmtJsonIdHi",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "stmtJsonIdLo",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "stmtEtag",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "fullStatement",
            dbFieldType = -1,
            nullable = true,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "statemententityjson_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO StatementEntityJson (stmtJsonIdHi, stmtJsonIdLo, stmtEtag, fullStatement) VALUES( NEW.stmtJsonIdHi, NEW.stmtJsonIdLo, NEW.stmtEtag, NEW.fullStatement) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO StatementEntityJson (stmtJsonIdHi, stmtJsonIdLo, stmtEtag, fullStatement) VALUES( NEW.stmtJsonIdHi, NEW.stmtJsonIdLo, NEW.stmtEtag, NEW.fullStatement)  ON CONFLICT(stmtJsonIdHi, stmtJsonIdLo)  DO UPDATE SET stmtEtag = NEW.stmtEtag, fullStatement = NEW.fullStatement ",
            ),
            conditionSql = """
            |SELECT 
            |               CAST(NEW.stmtEtag AS BIGINT) != 
            |                   COALESCE((SELECT StatementEntityJson_Existing.stmtEtag
            |                                   FROM StatementEntityJson StatementEntityJson_Existing
            |                                  WHERE StatementEntityJson_Existing.stmtJsonIdHi = NEW.stmtJsonIdHi AND StatementEntityJson_Existing.stmtJsonIdLo = NEW.stmtJsonIdLo), 0)
            |            
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |               CAST(NEW.stmtEtag AS BIGINT) != 
            |                   COALESCE((SELECT StatementEntityJson_Existing.stmtEtag
            |                                   FROM StatementEntityJson StatementEntityJson_Existing
            |                                  WHERE StatementEntityJson_Existing.stmtJsonIdHi = NEW.stmtJsonIdHi AND StatementEntityJson_Existing.stmtJsonIdLo = NEW.stmtJsonIdLo), 0)
            |            
            """.trimMargin(),
          ),),
        ),
        3_289 to ReplicationEntityMetaData(tableId = 3_289, 
        entityTableName = "StateEntity", 
        receiveViewName = "StateEntity_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("seActorUid","seHash",),
        entityVersionIdFieldName = "seLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "seActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seStateId",
            dbFieldType = -1,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seTimeStored",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seContentType",
            dbFieldType = -1,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seCompressed",
            dbFieldType = 4,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seContent",
            dbFieldType = -1,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seDeleted",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seRegistrationHi",
            dbFieldType = -5,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "seRegistrationLo",
            dbFieldType = -5,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "seH5PPreloaded",
            dbFieldType = 16,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "seH5PSubContentId",
            dbFieldType = -1,
            nullable = true,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "stateentity_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO StateEntity (seActorUid, seHash, seActivityUid, seStateId, seLastMod, seTimeStored, seContentType, seCompressed, seContent, seDeleted, seRegistrationHi, seRegistrationLo, seH5PPreloaded, seH5PSubContentId) VALUES( NEW.seActorUid, NEW.seHash, NEW.seActivityUid, NEW.seStateId, NEW.seLastMod, NEW.seTimeStored, NEW.seContentType, NEW.seCompressed, NEW.seContent, NEW.seDeleted, NEW.seRegistrationHi, NEW.seRegistrationLo, NEW.seH5PPreloaded, NEW.seH5PSubContentId) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO StateEntity (seActorUid, seHash, seActivityUid, seStateId, seLastMod, seTimeStored, seContentType, seCompressed, seContent, seDeleted, seRegistrationHi, seRegistrationLo, seH5PPreloaded, seH5PSubContentId) VALUES( NEW.seActorUid, NEW.seHash, NEW.seActivityUid, NEW.seStateId, NEW.seLastMod, NEW.seTimeStored, NEW.seContentType, NEW.seCompressed, NEW.seContent, NEW.seDeleted, NEW.seRegistrationHi, NEW.seRegistrationLo, NEW.seH5PPreloaded, NEW.seH5PSubContentId)  ON CONFLICT(seActorUid, seHash)  DO UPDATE SET seActivityUid = NEW.seActivityUid, seStateId = NEW.seStateId, seLastMod = NEW.seLastMod, seTimeStored = NEW.seTimeStored, seContentType = NEW.seContentType, seCompressed = NEW.seCompressed, seContent = NEW.seContent, seDeleted = NEW.seDeleted, seRegistrationHi = NEW.seRegistrationHi, seRegistrationLo = NEW.seRegistrationLo, seH5PPreloaded = NEW.seH5PPreloaded, seH5PSubContentId = NEW.seH5PSubContentId ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.seLastMod AS BIGINT) >
            |                       COALESCE((SELECT StateEntity_Existing.seLastMod
            |                                   FROM StateEntity StateEntity_Existing
            |                                  WHERE StateEntity_Existing.seActorUid = NEW.seActorUid AND StateEntity_Existing.seHash = NEW.seHash), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.seLastMod AS BIGINT) >
            |                       COALESCE((SELECT StateEntity_Existing.seLastMod
            |                                   FROM StateEntity StateEntity_Existing
            |                                  WHERE StateEntity_Existing.seActorUid = NEW.seActorUid AND StateEntity_Existing.seHash = NEW.seHash), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        121_422 to ReplicationEntityMetaData(tableId = 121_422, 
        entityTableName = "StateDeleteCommand", 
        receiveViewName = "StateDeleteCommand_ReceiveView", 
        entityPrimaryKeyFieldNames = listOf("sdcActorUid","sdcHash",),
        entityVersionIdFieldName = "sdcLastMod", 
        entityFields = listOf(
          ReplicationFieldMetaData(
            fieldName = "sdcActorUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sdcHash",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sdcActivityUid",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sdcStateId",
            dbFieldType = -1,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "sdcLastMod",
            dbFieldType = -5,
            nullable = false,
          ),
          ReplicationFieldMetaData(
            fieldName = "sdcRegistrationHi",
            dbFieldType = -5,
            nullable = true,
          ),
          ReplicationFieldMetaData(
            fieldName = "sdcRegistrationLo",
            dbFieldType = -5,
            nullable = true,
          ),
        )
        ,
        batchSize = 1_000,
        remoteInsertStrategy = ReplicateEntity.RemoteInsertStrategy.INSERT_INTO_RECEIVE_VIEW,
        triggers = listOf(
          Trigger(
            name = "statedeletecommand_remote_insert",
            order = Trigger.Order.INSTEAD_OF,
            events = arrayOf(Trigger.Event.INSERT,),
            on = Trigger.On.RECEIVEVIEW,
            sqlStatements = arrayOf(
              "REPLACE INTO StateDeleteCommand (sdcActorUid, sdcHash, sdcActivityUid, sdcStateId, sdcLastMod, sdcRegistrationHi, sdcRegistrationLo) VALUES( NEW.sdcActorUid, NEW.sdcHash, NEW.sdcActivityUid, NEW.sdcStateId, NEW.sdcLastMod, NEW.sdcRegistrationHi, NEW.sdcRegistrationLo) ",
            ),
            postgreSqlStatements = arrayOf(
              "INSERT INTO StateDeleteCommand (sdcActorUid, sdcHash, sdcActivityUid, sdcStateId, sdcLastMod, sdcRegistrationHi, sdcRegistrationLo) VALUES( NEW.sdcActorUid, NEW.sdcHash, NEW.sdcActivityUid, NEW.sdcStateId, NEW.sdcLastMod, NEW.sdcRegistrationHi, NEW.sdcRegistrationLo)  ON CONFLICT(sdcActorUid, sdcHash)  DO UPDATE SET sdcActivityUid = NEW.sdcActivityUid, sdcStateId = NEW.sdcStateId, sdcLastMod = NEW.sdcLastMod, sdcRegistrationHi = NEW.sdcRegistrationHi, sdcRegistrationLo = NEW.sdcRegistrationLo ",
            ),
            conditionSql = """
            |SELECT 
            |                   CAST(NEW.sdcLastMod AS BIGINT) >
            |                       COALESCE((SELECT StateDeleteCommand_Existing.sdcLastMod
            |                                   FROM StateDeleteCommand StateDeleteCommand_Existing
            |                                  WHERE StateDeleteCommand_Existing.sdcActorUid = NEW.sdcActorUid AND StateDeleteCommand_Existing.sdcHash = NEW.sdcHash), 0)
            |                   
            """.trimMargin(),
            conditionSqlPostgres = """
            |SELECT 
            |                   CAST(NEW.sdcLastMod AS BIGINT) >
            |                       COALESCE((SELECT StateDeleteCommand_Existing.sdcLastMod
            |                                   FROM StateDeleteCommand StateDeleteCommand_Existing
            |                                  WHERE StateDeleteCommand_Existing.sdcActorUid = NEW.sdcActorUid AND StateDeleteCommand_Existing.sdcHash = NEW.sdcHash), 0)
            |                   
            """.trimMargin(),
          ),),
        ),
        )
      }

}
