package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.PersonGroupMember
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class PersonGroupMemberDao : BaseDao<PersonGroupMember> {
  @Query(`value` =
      "SELECT * FROM PersonGroupMember WHERE groupMemberPersonUid = :personUid AND PersonGroupMember.groupMemberActive")
  public actual abstract suspend fun findAllGroupWherePersonIsIn(personUid: Long):
      List<PersonGroupMember>

  @Query(`value` =
      "SELECT * FROM PersonGroupMember WHERE groupMemberGroupUid = :groupUid \n             AND groupMemberPersonUid = :personUid AND PersonGroupMember.groupMemberActive")
  public actual abstract suspend fun checkPersonBelongsToGroup(groupUid: Long, personUid: Long):
      List<PersonGroupMember>

  @Query(`value` =
      "\n        UPDATE PersonGroupMember \n           SET groupMemberGroupUid = :newGroup,\n               groupMemberLct = :changeTime\n         WHERE groupMemberPersonUid = :personUid \n           AND groupMemberGroupUid = :oldGroup \n           AND PersonGroupMember.groupMemberActive")
  public actual abstract suspend fun moveGroupAsync(
    personUid: Long,
    newGroup: Long,
    oldGroup: Long,
    changeTime: Long,
  ): Int

  @Query(`value` =
      "\n        UPDATE PersonGroupMember \n           SET groupMemberActive = :activeStatus,\n               groupMemberLct = :updateTime\n        WHERE groupMemberPersonUid = :personUid \n          AND groupMemberGroupUid = :groupUid \n          AND PersonGroupMember.groupMemberActive")
  public actual abstract suspend fun updateGroupMemberActive(
    activeStatus: Boolean,
    personUid: Long,
    groupUid: Long,
    updateTime: Long,
  )

  @Query(`value` =
      "\n        SELECT PersonGroupMember.*\n          FROM PersonGroupMember\n         WHERE PersonGroupMember.groupMemberPersonUid = :personUid\n           AND PersonGroupMember.groupMemberGroupUid = :groupUid\n    ")
  public actual abstract suspend fun findByPersonUidAndGroupUid(personUid: Long, groupUid: Long):
      PersonGroupMember?
}
