/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ContentEntryParentChildJoinDao_Impl
extends ContentEntryParentChildJoinDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentEntryParentChildJoin> __insertionAdapterOfContentEntryParentChildJoin;
    private final EntityInsertionAdapter<ContentEntryParentChildJoin> __insertionAdapterOfContentEntryParentChildJoin_1;
    private final EntityDeletionOrUpdateAdapter<ContentEntryParentChildJoin> __updateAdapterOfContentEntryParentChildJoin;

    public ContentEntryParentChildJoinDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentEntryParentChildJoin = new EntityInsertionAdapter<ContentEntryParentChildJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentEntryParentChildJoin` (`cepcjParentContentEntryUid`,`cepcjChildContentEntryUid`,`childIndex`,`cepcjUid`,`cepcjLocalChangeSeqNum`,`cepcjMasterChangeSeqNum`,`cepcjLastChangedBy`,`cepcjLct`,`cepcjDeleted`) VALUES (?,?,?,nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryParentChildJoin entity) {
                statement.bindLong(1, entity.getCepcjParentContentEntryUid());
                statement.bindLong(2, entity.getCepcjChildContentEntryUid());
                statement.bindLong(3, (long)entity.getChildIndex());
                statement.bindLong(4, entity.getCepcjUid());
                statement.bindLong(5, entity.getCepcjLocalChangeSeqNum());
                statement.bindLong(6, entity.getCepcjMasterChangeSeqNum());
                statement.bindLong(7, (long)entity.getCepcjLastChangedBy());
                statement.bindLong(8, entity.getCepcjLct());
                int _tmp = entity.getCepcjDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp);
            }
        };
        this.__insertionAdapterOfContentEntryParentChildJoin_1 = new EntityInsertionAdapter<ContentEntryParentChildJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ContentEntryParentChildJoin` (`cepcjParentContentEntryUid`,`cepcjChildContentEntryUid`,`childIndex`,`cepcjUid`,`cepcjLocalChangeSeqNum`,`cepcjMasterChangeSeqNum`,`cepcjLastChangedBy`,`cepcjLct`,`cepcjDeleted`) VALUES (?,?,?,nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryParentChildJoin entity) {
                statement.bindLong(1, entity.getCepcjParentContentEntryUid());
                statement.bindLong(2, entity.getCepcjChildContentEntryUid());
                statement.bindLong(3, (long)entity.getChildIndex());
                statement.bindLong(4, entity.getCepcjUid());
                statement.bindLong(5, entity.getCepcjLocalChangeSeqNum());
                statement.bindLong(6, entity.getCepcjMasterChangeSeqNum());
                statement.bindLong(7, (long)entity.getCepcjLastChangedBy());
                statement.bindLong(8, entity.getCepcjLct());
                int _tmp = entity.getCepcjDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp);
            }
        };
        this.__updateAdapterOfContentEntryParentChildJoin = new EntityDeletionOrUpdateAdapter<ContentEntryParentChildJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ContentEntryParentChildJoin` SET `cepcjParentContentEntryUid` = ?,`cepcjChildContentEntryUid` = ?,`childIndex` = ?,`cepcjUid` = ?,`cepcjLocalChangeSeqNum` = ?,`cepcjMasterChangeSeqNum` = ?,`cepcjLastChangedBy` = ?,`cepcjLct` = ?,`cepcjDeleted` = ? WHERE `cepcjUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryParentChildJoin entity) {
                statement.bindLong(1, entity.getCepcjParentContentEntryUid());
                statement.bindLong(2, entity.getCepcjChildContentEntryUid());
                statement.bindLong(3, (long)entity.getChildIndex());
                statement.bindLong(4, entity.getCepcjUid());
                statement.bindLong(5, entity.getCepcjLocalChangeSeqNum());
                statement.bindLong(6, entity.getCepcjMasterChangeSeqNum());
                statement.bindLong(7, (long)entity.getCepcjLastChangedBy());
                statement.bindLong(8, entity.getCepcjLct());
                int _tmp = entity.getCepcjDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp);
                statement.bindLong(10, entity.getCepcjUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ContentEntryParentChildJoin entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfContentEntryParentChildJoin.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ContentEntryParentChildJoin entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentEntryParentChildJoinDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentEntryParentChildJoinDao_Impl.this.__insertionAdapterOfContentEntryParentChildJoin.insertAndReturnId((Object)entity);
                    ContentEntryParentChildJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentEntryParentChildJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ContentEntryParentChildJoin> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentEntryParentChildJoin.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<ContentEntryParentChildJoin> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ContentEntryParentChildJoinDao_Impl.this.__db.beginTransaction();
                try {
                    ContentEntryParentChildJoinDao_Impl.this.__insertionAdapterOfContentEntryParentChildJoin.insert((Iterable)entityList);
                    ContentEntryParentChildJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContentEntryParentChildJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void replaceList(List<ContentEntryParentChildJoin> entries) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentEntryParentChildJoin_1.insert(entries);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertWithReplace(ContentEntryParentChildJoin parentChildJoinDao) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentEntryParentChildJoin_1.insert((Object)parentChildJoinDao);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ContentEntryParentChildJoin entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfContentEntryParentChildJoin.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentEntryParentChildJoin> publicContentEntryParentChildJoins() {
        String _sql = "SELECT ContentEntryParentChildJoin.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntry parentEntry ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = parentEntry.contentEntryUid LEFT JOIN ContentEntry childEntry ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = childEntry.contentEntryUid WHERE parentEntry.publik AND childEntry.publik";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentEntryParentChildJoin.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntry parentEntry ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = parentEntry.contentEntryUid LEFT JOIN ContentEntry childEntry ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = childEntry.contentEntryUid WHERE parentEntry.publik AND childEntry.publik", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
            int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
            int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
            int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
            int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
            int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
            int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
            int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
            int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
            ArrayList<ContentEntryParentChildJoin> _result2 = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                ContentEntryParentChildJoin _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                _item.setCepcjUid(_tmpCepcjUid);
                long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                _item.setCepcjLct(_tmpCepcjLct);
                int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                boolean _tmpCepcjDeleted = _tmp != 0;
                _item.setCepcjDeleted(_tmpCepcjDeleted);
                _result2.add(_item);
            }
            ArrayList<ContentEntryParentChildJoin> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentEntryParentChildJoin> all() {
        String _sql = "SELECT * FROM ContentEntryParentChildJoin";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntryParentChildJoin", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
            int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
            int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
            int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
            int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
            int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
            int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
            int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
            int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
            ArrayList<ContentEntryParentChildJoin> _result2 = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                ContentEntryParentChildJoin _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                _item.setCepcjUid(_tmpCepcjUid);
                long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                _item.setCepcjLct(_tmpCepcjLct);
                int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                boolean _tmpCepcjDeleted = _tmp != 0;
                _item.setCepcjDeleted(_tmpCepcjDeleted);
                _result2.add(_item);
            }
            ArrayList<ContentEntryParentChildJoin> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentEntryParentChildJoin findParentByChildUuids(long childEntryContentUid) {
        String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, childEntryContentUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ContentEntryParentChildJoin _result2;
            int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
            int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
            int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
            int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
            int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
            int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
            int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
            int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
            int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
            if (_cursor.moveToFirst()) {
                long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                _result2 = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                _result2.setCepcjUid(_tmpCepcjUid);
                long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _result2.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _result2.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _result2.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                _result2.setCepcjLct(_tmpCepcjLct);
                int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                boolean _tmpCepcjDeleted = _tmp != 0;
                _result2.setCepcjDeleted(_tmpCepcjDeleted);
            } else {
                _result2 = null;
            }
            ContentEntryParentChildJoin contentEntryParentChildJoin = _result2;
            return contentEntryParentChildJoin;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentEntryParentChildJoin> findListOfParentsByChildUuid(long childEntryContentUid) {
        String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, childEntryContentUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
            int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
            int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
            int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
            int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
            int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
            int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
            int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
            int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
            ArrayList<ContentEntryParentChildJoin> _result2 = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                ContentEntryParentChildJoin _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                _item.setCepcjUid(_tmpCepcjUid);
                long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                _item.setCepcjLct(_tmpCepcjLct);
                int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                boolean _tmpCepcjDeleted = _tmp != 0;
                _item.setCepcjDeleted(_tmpCepcjDeleted);
                _result2.add(_item);
            }
            ArrayList<ContentEntryParentChildJoin> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findListOfChildsByParentUuid(long parentUid, Continuation<? super List<ContentEntryParentChildJoin>> $completion) {
        String _sql = "\n        SELECT * \n          FROM ContentEntryParentChildJoin \n         WHERE cepcjParentContentEntryUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ContentEntryParentChildJoin \n         WHERE cepcjParentContentEntryUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ContentEntryParentChildJoin>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntryParentChildJoin> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryParentChildJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
                    int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
                    int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
                    int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
                    int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
                    int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
                    int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
                    int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
                    int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
                    ArrayList<ContentEntryParentChildJoin> _result2 = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                        long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                        int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                        ContentEntryParentChildJoin _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                        long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                        _item.setCepcjUid(_tmpCepcjUid);
                        long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                        _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                        long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                        _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                        int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                        _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                        long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                        _item.setCepcjLct(_tmpCepcjLct);
                        int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                        boolean _tmpCepcjDeleted = _tmp != 0;
                        _item.setCepcjDeleted(_tmpCepcjDeleted);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntryParentChildJoin> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentEntryParentChildJoin findJoinByParentChildUuids(long parentUid, long childUid) {
        String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ? AND cepcjChildContentEntryUid = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ? AND cepcjChildContentEntryUid = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, childUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ContentEntryParentChildJoin _result2;
            int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
            int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
            int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
            int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
            int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
            int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
            int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
            int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
            int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
            if (_cursor.moveToFirst()) {
                long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                _result2 = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                _result2.setCepcjUid(_tmpCepcjUid);
                long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _result2.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _result2.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _result2.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                _result2.setCepcjLct(_tmpCepcjLct);
                int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                boolean _tmpCepcjDeleted = _tmp != 0;
                _result2.setCepcjDeleted(_tmpCepcjDeleted);
            } else {
                _result2 = null;
            }
            ContentEntryParentChildJoin contentEntryParentChildJoin = _result2;
            return contentEntryParentChildJoin;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object selectTopEntries(Continuation<? super List<? extends ContentEntry>> $completion) {
        String _sql = "SELECT ContentEntry.* FROM ContentEntry WHERE NOT EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ContentEntry.contentEntryUid) AND EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ContentEntry.contentEntryUid)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentEntry.* FROM ContentEntry WHERE NOT EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ContentEntry.contentEntryUid) AND EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ContentEntry.contentEntryUid)", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ContentEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntry> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryParentChildJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    ArrayList<ContentEntry> _result2 = new ArrayList<ContentEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ContentEntry _item = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _item.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _item.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _item.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _item.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _item.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _item.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _item.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _item.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _item.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _item.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _item.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _item.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _item.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _item.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _item.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _item.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _item.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _item.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _item.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _item.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _item.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _item.setContentEntryLct(_tmpContentEntryLct);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntry> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUid(long uid, Continuation<? super ContentEntryParentChildJoin> $completion) {
        String _sql = "\n        SELECT ContentEntryParentChildJoin.*\n          FROM ContentEntryParentChildJoin\n         WHERE  ContentEntryParentChildJoin.cepcjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryParentChildJoin.*\n          FROM ContentEntryParentChildJoin\n         WHERE  ContentEntryParentChildJoin.cepcjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryParentChildJoin>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryParentChildJoin call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryParentChildJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryParentChildJoin _result2;
                    int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjParentContentEntryUid");
                    int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjChildContentEntryUid");
                    int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childIndex");
                    int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjUid");
                    int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLocalChangeSeqNum");
                    int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjMasterChangeSeqNum");
                    int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLastChangedBy");
                    int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjLct");
                    int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepcjDeleted");
                    if (_cursor.moveToFirst()) {
                        long _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                        long _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                        int _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
                        _result2 = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                        long _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
                        _result2.setCepcjUid(_tmpCepcjUid);
                        long _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                        _result2.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                        long _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                        _result2.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                        int _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                        _result2.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                        long _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
                        _result2.setCepcjLct(_tmpCepcjLct);
                        int _tmp = _cursor.getInt(_cursorIndexOfCepcjDeleted);
                        boolean _tmpCepcjDeleted = _tmp != 0;
                        _result2.setCepcjDeleted(_tmpCepcjDeleted);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryParentChildJoin contentEntryParentChildJoin = _result2;
                    return contentEntryParentChildJoin;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object moveListOfEntriesToNewParent(final long contentEntryUid, final List<Long> selectedItems, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE ContentEntryParentChildJoin ");
                _stringBuilder.append("\n");
                _stringBuilder.append("           SET cepcjParentContentEntryUid = ");
                _stringBuilder.append("?");
                _stringBuilder.append(", ");
                _stringBuilder.append("\n");
                _stringBuilder.append("               cepcjLct = ");
                _stringBuilder.append("?");
                _stringBuilder.append(" ");
                _stringBuilder.append("\n");
                _stringBuilder.append("               WHERE cepcjUid IN (");
                int _inputSize = selectedItems.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                _stringBuilder.append("\n");
                _stringBuilder.append("    ");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContentEntryParentChildJoinDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, contentEntryUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                Unit unit = selectedItems.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                ContentEntryParentChildJoinDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContentEntryParentChildJoinDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContentEntryParentChildJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object setEntriesDeleted(final List<Long> selectedUids, final boolean isDeleted, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE ContentEntryParentChildJoin");
                _stringBuilder.append("\n");
                _stringBuilder.append("           SET cepcjDeleted = ");
                _stringBuilder.append("?");
                _stringBuilder.append(",");
                _stringBuilder.append("\n");
                _stringBuilder.append("               cepcjLct = ");
                _stringBuilder.append("?");
                _stringBuilder.append("\n");
                _stringBuilder.append("         WHERE cepcjUid IN (");
                int _inputSize = selectedUids.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(") ");
                _stringBuilder.append("\n");
                _stringBuilder.append("    ");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContentEntryParentChildJoinDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                int _tmp = isDeleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                Unit unit = selectedUids.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                ContentEntryParentChildJoinDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContentEntryParentChildJoinDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContentEntryParentChildJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

