/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentEntryPictureDao;
import com.ustadmobile.lib.db.entities.ContentEntryPicture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ContentEntryPictureDao_Impl
extends ContentEntryPictureDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentEntryPicture> __insertionAdapterOfContentEntryPicture;
    private final EntityDeletionOrUpdateAdapter<ContentEntryPicture> __updateAdapterOfContentEntryPicture;

    public ContentEntryPictureDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentEntryPicture = new EntityInsertionAdapter<ContentEntryPicture>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentEntryPicture` (`cepUid`,`cepContentEntryUid`,`cepUri`,`cepMd5`,`cepFileSize`,`cepTimestamp`,`cepMimeType`,`cepActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryPicture entity) {
                statement.bindLong(1, entity.getCepUid());
                statement.bindLong(2, entity.getCepContentEntryUid());
                if (entity.getCepUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCepUri());
                }
                if (entity.getCepMd5() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCepMd5());
                }
                statement.bindLong(5, (long)entity.getCepFileSize());
                statement.bindLong(6, entity.getCepTimestamp());
                if (entity.getCepMimeType() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getCepMimeType());
                }
                int _tmp = entity.getCepActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
            }
        };
        this.__updateAdapterOfContentEntryPicture = new EntityDeletionOrUpdateAdapter<ContentEntryPicture>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ContentEntryPicture` SET `cepUid` = ?,`cepContentEntryUid` = ?,`cepUri` = ?,`cepMd5` = ?,`cepFileSize` = ?,`cepTimestamp` = ?,`cepMimeType` = ?,`cepActive` = ? WHERE `cepUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryPicture entity) {
                statement.bindLong(1, entity.getCepUid());
                statement.bindLong(2, entity.getCepContentEntryUid());
                if (entity.getCepUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCepUri());
                }
                if (entity.getCepMd5() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCepMd5());
                }
                statement.bindLong(5, (long)entity.getCepFileSize());
                statement.bindLong(6, entity.getCepTimestamp());
                if (entity.getCepMimeType() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getCepMimeType());
                }
                int _tmp = entity.getCepActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                statement.bindLong(9, entity.getCepUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ContentEntryPicture entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfContentEntryPicture.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ContentEntryPicture entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentEntryPictureDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentEntryPictureDao_Impl.this.__insertionAdapterOfContentEntryPicture.insertAndReturnId((Object)entity);
                    ContentEntryPictureDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentEntryPictureDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ContentEntryPicture> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentEntryPicture.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ContentEntryPicture entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfContentEntryPicture.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final ContentEntryPicture ContentEntryPicture3, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ContentEntryPictureDao_Impl.this.__db.beginTransaction();
                try {
                    ContentEntryPictureDao_Impl.this.__updateAdapterOfContentEntryPicture.handle((Object)ContentEntryPicture3);
                    ContentEntryPictureDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContentEntryPictureDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByContentEntryUidAsync(long entryUid, Continuation<? super ContentEntryPicture> $completion) {
        String _sql = "\n        SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = ?\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = ?\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryPicture call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryPictureDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryPicture _result2;
                    int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUid");
                    int _cursorIndexOfCepContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepContentEntryUid");
                    int _cursorIndexOfCepUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUri");
                    int _cursorIndexOfCepMd5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepMd5");
                    int _cursorIndexOfCepFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepFileSize");
                    int _cursorIndexOfCepTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepTimestamp");
                    int _cursorIndexOfCepMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepMimeType");
                    int _cursorIndexOfCepActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepActive");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntryPicture();
                        long _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
                        _result2.setCepUid(_tmpCepUid);
                        long _tmpCepContentEntryUid = _cursor.getLong(_cursorIndexOfCepContentEntryUid);
                        _result2.setCepContentEntryUid(_tmpCepContentEntryUid);
                        String _tmpCepUri = _cursor.isNull(_cursorIndexOfCepUri) ? null : _cursor.getString(_cursorIndexOfCepUri);
                        _result2.setCepUri(_tmpCepUri);
                        String _tmpCepMd5 = _cursor.isNull(_cursorIndexOfCepMd5) ? null : _cursor.getString(_cursorIndexOfCepMd5);
                        _result2.setCepMd5(_tmpCepMd5);
                        int _tmpCepFileSize = _cursor.getInt(_cursorIndexOfCepFileSize);
                        _result2.setCepFileSize(_tmpCepFileSize);
                        long _tmpCepTimestamp = _cursor.getLong(_cursorIndexOfCepTimestamp);
                        _result2.setCepTimestamp(_tmpCepTimestamp);
                        String _tmpCepMimeType = _cursor.isNull(_cursorIndexOfCepMimeType) ? null : _cursor.getString(_cursorIndexOfCepMimeType);
                        _result2.setCepMimeType(_tmpCepMimeType);
                        int _tmp = _cursor.getInt(_cursorIndexOfCepActive);
                        boolean _tmpCepActive = _tmp != 0;
                        _result2.setCepActive(_tmpCepActive);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryPicture contentEntryPicture = _result2;
                    return contentEntryPicture;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ContentEntryPicture> findByContentEntryUidLive(long entryUid) {
        String _sql = "\n         SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = ?\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = ?\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ContentEntryPicture"}, (Callable)new Callable<ContentEntryPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryPicture call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryPictureDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ContentEntryPicture _result2;
                    int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUid");
                    int _cursorIndexOfCepContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepContentEntryUid");
                    int _cursorIndexOfCepUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUri");
                    int _cursorIndexOfCepMd5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepMd5");
                    int _cursorIndexOfCepFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepFileSize");
                    int _cursorIndexOfCepTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepTimestamp");
                    int _cursorIndexOfCepMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepMimeType");
                    int _cursorIndexOfCepActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepActive");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntryPicture();
                        long _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
                        _result2.setCepUid(_tmpCepUid);
                        long _tmpCepContentEntryUid = _cursor.getLong(_cursorIndexOfCepContentEntryUid);
                        _result2.setCepContentEntryUid(_tmpCepContentEntryUid);
                        String _tmpCepUri = _cursor.isNull(_cursorIndexOfCepUri) ? null : _cursor.getString(_cursorIndexOfCepUri);
                        _result2.setCepUri(_tmpCepUri);
                        String _tmpCepMd5 = _cursor.isNull(_cursorIndexOfCepMd5) ? null : _cursor.getString(_cursorIndexOfCepMd5);
                        _result2.setCepMd5(_tmpCepMd5);
                        int _tmpCepFileSize = _cursor.getInt(_cursorIndexOfCepFileSize);
                        _result2.setCepFileSize(_tmpCepFileSize);
                        long _tmpCepTimestamp = _cursor.getLong(_cursorIndexOfCepTimestamp);
                        _result2.setCepTimestamp(_tmpCepTimestamp);
                        String _tmpCepMimeType = _cursor.isNull(_cursorIndexOfCepMimeType) ? null : _cursor.getString(_cursorIndexOfCepMimeType);
                        _result2.setCepMimeType(_tmpCepMimeType);
                        int _tmp = _cursor.getInt(_cursorIndexOfCepActive);
                        boolean _tmpCepActive = _tmp != 0;
                        _result2.setCepActive(_tmpCepActive);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryPicture contentEntryPicture = _result2;
                    return contentEntryPicture;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

