/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CoursePictureDao;
import com.ustadmobile.lib.db.entities.CoursePicture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class CoursePictureDao_Impl
extends CoursePictureDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CoursePicture> __insertionAdapterOfCoursePicture;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUri;

    public CoursePictureDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCoursePicture = new EntityInsertionAdapter<CoursePicture>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CoursePicture` (`coursePictureUid`,`coursePictureLct`,`coursePictureUri`,`coursePictureThumbnailUri`,`coursePictureActive`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CoursePicture entity) {
                statement.bindLong(1, entity.getCoursePictureUid());
                statement.bindLong(2, entity.getCoursePictureLct());
                if (entity.getCoursePictureUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCoursePictureUri());
                }
                if (entity.getCoursePictureThumbnailUri() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCoursePictureThumbnailUri());
                }
                int _tmp = entity.getCoursePictureActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
            }
        };
        this.__preparedStmtOfUpdateUri = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CoursePicture\n           SET coursePictureUri = ?,\n               coursePictureThumbnailUri = ?,\n               coursePictureLct = ?\n        WHERE coursePictureUid = ?       \n    ";
                return "\n        UPDATE CoursePicture\n           SET coursePictureUri = ?,\n               coursePictureThumbnailUri = ?,\n               coursePictureLct = ?\n        WHERE coursePictureUid = ?       \n    ";
            }
        };
    }

    @Override
    public Object upsertAsync(final CoursePicture coursePicture, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CoursePictureDao_Impl.this.__db.beginTransaction();
                try {
                    CoursePictureDao_Impl.this.__insertionAdapterOfCoursePicture.insert((Object)coursePicture);
                    CoursePictureDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CoursePictureDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateUri(final long uid, final String uri, final String thumbnailUri, final long time, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CoursePictureDao_Impl.this.__preparedStmtOfUpdateUri.acquire();
                int _argIndex = 1;
                if (uri == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, uri);
                }
                _argIndex = 2;
                if (thumbnailUri == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, thumbnailUri);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, time);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, uid);
                try {
                    Unit unit;
                    CoursePictureDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CoursePictureDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CoursePictureDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CoursePictureDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CoursePictureDao_Impl.this.__preparedStmtOfUpdateUri.release(_stmt);
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

