/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.DiscussionPostAndPosterNames;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.DiscussionPost;
import com.ustadmobile.lib.db.entities.DiscussionPostWithDetails;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH'J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00152\u0006\u0010\u0011\u001a\u00020\tH'J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u00052\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH'J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0018\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0018\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010\"\u00a8\u0006$"}, d2={"Lcom/ustadmobile/core/db/dao/DiscussionPostDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/DiscussionPost;", "()V", "findByPostIdWithAllReplies", "Landroidx/paging/PagingSource;", "", "Lcom/ustadmobile/lib/db/composites/DiscussionPostAndPosterNames;", "postUid", "", "includeDeleted", "", "findByPostIdWithAllRepliesPersons", "", "Lcom/ustadmobile/lib/db/composites/PersonAndPicture;", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "uid", "getPostTitle", "", "getTitleByUidAsFlow", "Lkotlinx/coroutines/flow/Flow;", "getTopLevelPostsByCourseBlockUid", "Lcom/ustadmobile/lib/db/entities/DiscussionPostWithDetails;", "courseBlockUid", "getTopLevelPostsByCourseBlockUidLatestMessage", "getTopLevelPostsByCourseBlockUidPersons", "setDeletedAsync", "", "deleted", "updateTime", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/DiscussionPost;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsertAsync", "lib-database_debug"})
@Dao
public abstract class DiscussionPostDao
implements BaseDao<DiscussionPost> {
    @Query(value="\n        SELECT DiscussionPost.*,\n               Person.firstNames as authorPersonFirstNames,\n               Person.lastName as authorPersonLastName,\n               PersonPicture.personPictureThumbnailUri AS authorPictureUri,\n               MostRecentReply.discussionPostMessage AS postLatestMessage,\n               COALESCE(MostRecentReply.discussionPostStartDate, 0) AS postLatestMessageTimestamp,\n               (SELECT COUNT(*)\n                  FROM DiscussionPost DiscussionPostReplies\n                 WHERE DiscussionPostReplies.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                   AND NOT DiscussionPostReplies.dpDeleted\n               ) AS postRepliesCount\n          FROM DiscussionPost\n               LEFT JOIN DiscussionPost AS MostRecentReply\n                         ON MostRecentReply.discussionPostUid = \n                            (SELECT MostRecentReplyInner.discussionPostUid\n                               FROM DiscussionPost AS MostRecentReplyInner\n                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n                              LIMIT 1  \n                            )\n               LEFT JOIN Person \n                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE DiscussionPost.discussionPostCourseBlockUid = :courseBlockUid\n           AND DiscussionPost.discussionPostReplyToPostUid = 0\n           AND (NOT DiscussionPost.dpDeleted OR CAST(:includeDeleted AS INTEGER) = 1)\n      ORDER BY DiscussionPost.discussionPostStartDate DESC          \n    ")
    @NotNull
    public abstract PagingSource<Integer, DiscussionPostWithDetails> getTopLevelPostsByCourseBlockUid(long var1, boolean var3);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostCourseBlockUid = :courseBlockUid\n                   AND DiscussionPost.discussionPostReplyToPostUid = 0)\n    ")
    @Nullable
    public abstract Object getTopLevelPostsByCourseBlockUidPersons(long var1, @NotNull Continuation<? super List<PersonAndPicture>> var3);

    @Query(value="\n        SELECT MostRecentReply.*\n          FROM DiscussionPost\n               JOIN DiscussionPost AS MostRecentReply\n                         ON MostRecentReply.discussionPostUid = \n                            (SELECT MostRecentReplyInner.discussionPostUid\n                               FROM DiscussionPost AS MostRecentReplyInner\n                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n                              LIMIT 1  \n                            )\n         WHERE DiscussionPost.discussionPostCourseBlockUid = :courseBlockUid\n           AND DiscussionPost.discussionPostReplyToPostUid = 0 \n    ")
    @Nullable
    public abstract Object getTopLevelPostsByCourseBlockUidLatestMessage(long var1, @NotNull Continuation<? super List<? extends DiscussionPost>> var3);

    @Query(value="\n        SELECT DiscussionPost.discussionPostTitle \n          FROM DiscussionPost \n         WHERE DiscussionPost.discussionPostUid = :postUid\n    ")
    @Nullable
    public abstract Object getPostTitle(long var1, @NotNull Continuation<? super String> var3);

    @Query(value="\n        SELECT * \n         FROM DiscussionPost\n        WHERE DiscussionPost.discussionPostUid = :uid\n    ")
    @Nullable
    public abstract Object findByUid(long var1, @NotNull Continuation<? super DiscussionPost> var3);

    @Query(value="\n        SELECT DiscussionPost.discussionPostTitle\n          FROM DiscussionPost\n         WHERE DiscussionPost.discussionPostUid = :uid\n    ")
    @NotNull
    public abstract Flow<String> getTitleByUidAsFlow(long var1);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull DiscussionPost var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n        SELECT DiscussionPost.*,\n               Person.firstNames,\n               Person.lastName,\n               PersonPicture.personPictureThumbnailUri AS personPictureUri\n          FROM DiscussionPost\n               LEFT JOIN Person\n                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE (DiscussionPost.discussionPostUid = :postUid\n                 OR DiscussionPost.discussionPostReplyToPostUid= :postUid)\n           AND (NOT DiscussionPost.dpDeleted OR CAST(:includeDeleted AS INTEGER) = 1)      \n            -- Always get the starting post first, followed by replies\n      ORDER BY CASE(DiscussionPost.discussionPostReplyToPostUid)\n               WHEN 0 THEN 0\n               ELSE 1 END ASC,\n               DiscussionPost.discussionPostStartDate DESC \n    ")
    @NotNull
    public abstract PagingSource<Integer, DiscussionPostAndPosterNames> findByPostIdWithAllReplies(long var1, boolean var3);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = :postUid\n                    OR DiscussionPost.discussionPostReplyToPostUid= :postUid)\n    ")
    @Nullable
    public abstract Object findByPostIdWithAllRepliesPersons(long var1, @NotNull Continuation<? super List<PersonAndPicture>> var3);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertAsync(@NotNull DiscussionPost var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        UPDATE DiscussionPost\n           SET dpDeleted = :deleted,\n               discussionPostLct = :updateTime\n         WHERE discussionPostUid = :uid   \n    ")
    @Nullable
    public abstract Object setDeletedAsync(long var1, boolean var3, long var4, @NotNull Continuation<? super Unit> var6);
}

