/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.StudentResultDao;
import com.ustadmobile.lib.db.composites.StudentResultAndCourseBlockSourcedId;
import com.ustadmobile.lib.db.entities.StudentResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class StudentResultDao_Impl
extends StudentResultDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StudentResult> __insertionAdapterOfStudentResult;
    private final EntityInsertionAdapter<StudentResult> __insertionAdapterOfStudentResult_1;

    public StudentResultDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStudentResult = new EntityInsertionAdapter<StudentResult>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `StudentResult` (`srUid`,`srSourcedId`,`srCourseBlockUid`,`srLineItemSourcedId`,`srLineItemHref`,`srClazzUid`,`srAssignmentUid`,`srStatus`,`srMetaData`,`srStudentPersonUid`,`srStudentPersonSourcedId`,`srStudentGroupId`,`srMarkerPersonUid`,`srMarkerGroupId`,`srScoreStatus`,`srScore`,`srScoreDate`,`srLastModified`,`srComment`,`srAppId`,`srDeleted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull StudentResult entity) {
                statement.bindLong(1, entity.getSrUid());
                if (entity.getSrSourcedId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getSrSourcedId());
                }
                statement.bindLong(3, entity.getSrCourseBlockUid());
                if (entity.getSrLineItemSourcedId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getSrLineItemSourcedId());
                }
                if (entity.getSrLineItemHref() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getSrLineItemHref());
                }
                statement.bindLong(6, entity.getSrClazzUid());
                statement.bindLong(7, entity.getSrAssignmentUid());
                statement.bindLong(8, (long)entity.getSrStatus());
                if (entity.getSrMetaData() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getSrMetaData());
                }
                statement.bindLong(10, entity.getSrStudentPersonUid());
                if (entity.getSrStudentPersonSourcedId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getSrStudentPersonSourcedId());
                }
                statement.bindLong(12, (long)entity.getSrStudentGroupId());
                statement.bindLong(13, entity.getSrMarkerPersonUid());
                statement.bindLong(14, (long)entity.getSrMarkerGroupId());
                statement.bindLong(15, (long)entity.getSrScoreStatus());
                statement.bindDouble(16, (double)entity.getSrScore());
                statement.bindLong(17, entity.getSrScoreDate());
                statement.bindLong(18, entity.getSrLastModified());
                if (entity.getSrComment() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindString(19, entity.getSrComment());
                }
                if (entity.getSrAppId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindString(20, entity.getSrAppId());
                }
                int _tmp = entity.getSrDeleted() ? 1 : 0;
                statement.bindLong(21, (long)_tmp);
            }
        };
        this.__insertionAdapterOfStudentResult_1 = new EntityInsertionAdapter<StudentResult>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `StudentResult` (`srUid`,`srSourcedId`,`srCourseBlockUid`,`srLineItemSourcedId`,`srLineItemHref`,`srClazzUid`,`srAssignmentUid`,`srStatus`,`srMetaData`,`srStudentPersonUid`,`srStudentPersonSourcedId`,`srStudentGroupId`,`srMarkerPersonUid`,`srMarkerGroupId`,`srScoreStatus`,`srScore`,`srScoreDate`,`srLastModified`,`srComment`,`srAppId`,`srDeleted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull StudentResult entity) {
                statement.bindLong(1, entity.getSrUid());
                if (entity.getSrSourcedId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getSrSourcedId());
                }
                statement.bindLong(3, entity.getSrCourseBlockUid());
                if (entity.getSrLineItemSourcedId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getSrLineItemSourcedId());
                }
                if (entity.getSrLineItemHref() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getSrLineItemHref());
                }
                statement.bindLong(6, entity.getSrClazzUid());
                statement.bindLong(7, entity.getSrAssignmentUid());
                statement.bindLong(8, (long)entity.getSrStatus());
                if (entity.getSrMetaData() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getSrMetaData());
                }
                statement.bindLong(10, entity.getSrStudentPersonUid());
                if (entity.getSrStudentPersonSourcedId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getSrStudentPersonSourcedId());
                }
                statement.bindLong(12, (long)entity.getSrStudentGroupId());
                statement.bindLong(13, entity.getSrMarkerPersonUid());
                statement.bindLong(14, (long)entity.getSrMarkerGroupId());
                statement.bindLong(15, (long)entity.getSrScoreStatus());
                statement.bindDouble(16, (double)entity.getSrScore());
                statement.bindLong(17, entity.getSrScoreDate());
                statement.bindLong(18, entity.getSrLastModified());
                if (entity.getSrComment() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindString(19, entity.getSrComment());
                }
                if (entity.getSrAppId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindString(20, entity.getSrAppId());
                }
                int _tmp = entity.getSrDeleted() ? 1 : 0;
                statement.bindLong(21, (long)_tmp);
            }
        };
    }

    @Override
    public Object insertListAsync(final List<StudentResult> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                StudentResultDao_Impl.this.__db.beginTransaction();
                try {
                    StudentResultDao_Impl.this.__insertionAdapterOfStudentResult.insert((Iterable)list);
                    StudentResultDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    StudentResultDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertAsync(final StudentResult studentResult, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                StudentResultDao_Impl.this.__db.beginTransaction();
                try {
                    StudentResultDao_Impl.this.__insertionAdapterOfStudentResult_1.insert((Object)studentResult);
                    StudentResultDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    StudentResultDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByClazzAndStudent(long clazzUid, long studentPersonUid, long accountPersonUid, Continuation<? super List<StudentResultAndCourseBlockSourcedId>> $completion) {
        String _sql = "\n        SELECT StudentResult.*,\n               CourseBlock.cbSourcedId AS cbSourcedId\n          FROM StudentResult\n               LEFT JOIN CourseBlock\n                         ON StudentResult.srCourseBlockUid = CourseBlock.cbUid \n         WHERE StudentResult.srClazzUid = ?\n           AND StudentResult.srStudentPersonUid = ?\n           AND ? = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StudentResult.*,\n               CourseBlock.cbSourcedId AS cbSourcedId\n          FROM StudentResult\n               LEFT JOIN CourseBlock\n                         ON StudentResult.srCourseBlockUid = CourseBlock.cbUid \n         WHERE StudentResult.srClazzUid = ?\n           AND StudentResult.srStudentPersonUid = ?\n           AND ? = ?\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, studentPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StudentResultAndCourseBlockSourcedId>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StudentResultAndCourseBlockSourcedId> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StudentResultDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSrUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srUid");
                    int _cursorIndexOfSrSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srSourcedId");
                    int _cursorIndexOfSrCourseBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srCourseBlockUid");
                    int _cursorIndexOfSrLineItemSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srLineItemSourcedId");
                    int _cursorIndexOfSrLineItemHref = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srLineItemHref");
                    int _cursorIndexOfSrClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srClazzUid");
                    int _cursorIndexOfSrAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srAssignmentUid");
                    int _cursorIndexOfSrStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srStatus");
                    int _cursorIndexOfSrMetaData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srMetaData");
                    int _cursorIndexOfSrStudentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srStudentPersonUid");
                    int _cursorIndexOfSrStudentPersonSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srStudentPersonSourcedId");
                    int _cursorIndexOfSrStudentGroupId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srStudentGroupId");
                    int _cursorIndexOfSrMarkerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srMarkerPersonUid");
                    int _cursorIndexOfSrMarkerGroupId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srMarkerGroupId");
                    int _cursorIndexOfSrScoreStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srScoreStatus");
                    int _cursorIndexOfSrScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srScore");
                    int _cursorIndexOfSrScoreDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srScoreDate");
                    int _cursorIndexOfSrLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srLastModified");
                    int _cursorIndexOfSrComment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srComment");
                    int _cursorIndexOfSrAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srAppId");
                    int _cursorIndexOfSrDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"srDeleted");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    ArrayList<StudentResultAndCourseBlockSourcedId> _result2 = new ArrayList<StudentResultAndCourseBlockSourcedId>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        long _tmpSrUid = _cursor.getLong(_cursorIndexOfSrUid);
                        String _tmpSrSourcedId = _cursor.isNull(_cursorIndexOfSrSourcedId) ? null : _cursor.getString(_cursorIndexOfSrSourcedId);
                        long _tmpSrCourseBlockUid = _cursor.getLong(_cursorIndexOfSrCourseBlockUid);
                        String _tmpSrLineItemSourcedId = _cursor.isNull(_cursorIndexOfSrLineItemSourcedId) ? null : _cursor.getString(_cursorIndexOfSrLineItemSourcedId);
                        String _tmpSrLineItemHref = _cursor.isNull(_cursorIndexOfSrLineItemHref) ? null : _cursor.getString(_cursorIndexOfSrLineItemHref);
                        long _tmpSrClazzUid = _cursor.getLong(_cursorIndexOfSrClazzUid);
                        long _tmpSrAssignmentUid = _cursor.getLong(_cursorIndexOfSrAssignmentUid);
                        int _tmpSrStatus = _cursor.getInt(_cursorIndexOfSrStatus);
                        String _tmpSrMetaData = _cursor.isNull(_cursorIndexOfSrMetaData) ? null : _cursor.getString(_cursorIndexOfSrMetaData);
                        long _tmpSrStudentPersonUid = _cursor.getLong(_cursorIndexOfSrStudentPersonUid);
                        String _tmpSrStudentPersonSourcedId = _cursor.isNull(_cursorIndexOfSrStudentPersonSourcedId) ? null : _cursor.getString(_cursorIndexOfSrStudentPersonSourcedId);
                        int _tmpSrStudentGroupId = _cursor.getInt(_cursorIndexOfSrStudentGroupId);
                        long _tmpSrMarkerPersonUid = _cursor.getLong(_cursorIndexOfSrMarkerPersonUid);
                        int _tmpSrMarkerGroupId = _cursor.getInt(_cursorIndexOfSrMarkerGroupId);
                        int _tmpSrScoreStatus = _cursor.getInt(_cursorIndexOfSrScoreStatus);
                        float _tmpSrScore = _cursor.getFloat(_cursorIndexOfSrScore);
                        long _tmpSrScoreDate = _cursor.getLong(_cursorIndexOfSrScoreDate);
                        long _tmpSrLastModified = _cursor.getLong(_cursorIndexOfSrLastModified);
                        String _tmpSrComment = _cursor.isNull(_cursorIndexOfSrComment) ? null : _cursor.getString(_cursorIndexOfSrComment);
                        String _tmpSrAppId = _cursor.isNull(_cursorIndexOfSrAppId) ? null : _cursor.getString(_cursorIndexOfSrAppId);
                        int _tmp = _cursor.getInt(_cursorIndexOfSrDeleted);
                        boolean _tmpSrDeleted = _tmp != 0;
                        StudentResult _tmpStudentResult = new StudentResult(_tmpSrUid, _tmpSrSourcedId, _tmpSrCourseBlockUid, _tmpSrLineItemSourcedId, _tmpSrLineItemHref, _tmpSrClazzUid, _tmpSrAssignmentUid, _tmpSrStatus, _tmpSrMetaData, _tmpSrStudentPersonUid, _tmpSrStudentPersonSourcedId, _tmpSrStudentGroupId, _tmpSrMarkerPersonUid, _tmpSrMarkerGroupId, _tmpSrScoreStatus, _tmpSrScore, _tmpSrScoreDate, _tmpSrLastModified, _tmpSrComment, _tmpSrAppId, _tmpSrDeleted);
                        StudentResultAndCourseBlockSourcedId _item = new StudentResultAndCourseBlockSourcedId(_tmpStudentResult, _tmpCbSourcedId);
                        _result2.add(_item);
                    }
                    ArrayList<StudentResultAndCourseBlockSourcedId> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findUidBySourcedId(String sourcedId, Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT COALESCE(\n               (SELECT StudentResult.srUid  \n                  FROM StudentResult \n                 WHERE srSourcedId = ?), 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n               (SELECT StudentResult.srUid  \n                  FROM StudentResult \n                 WHERE srSourcedId = ?), 0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, sourcedId);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StudentResultDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object existsByUid(long srUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS(\n               SELECT StudentResult.srUid\n                 FROM StudentResult\n                WHERE StudentResult.srUid = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS(\n               SELECT StudentResult.srUid\n                 FROM StudentResult\n                WHERE StudentResult.srUid = ?)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, srUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StudentResultDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

