/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.ActivityEntityDao;
import com.ustadmobile.lib.db.entities.xapi.ActivityEntity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ActivityEntityDao_Impl
extends ActivityEntityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ActivityEntity> __insertionAdapterOfActivityEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateIfMoreInfoChanged;
    private final SharedSQLiteStatement __preparedStmtOfUpdateIfNotYetDefined;

    public ActivityEntityDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfActivityEntity = new EntityInsertionAdapter<ActivityEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `ActivityEntity` (`actUid`,`actIdIri`,`actType`,`actMoreInfo`,`actInteractionType`,`actCorrectResponsePatterns`,`actLct`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ActivityEntity entity) {
                statement.bindLong(1, entity.getActUid());
                if (entity.getActIdIri() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getActIdIri());
                }
                if (entity.getActType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getActType());
                }
                if (entity.getActMoreInfo() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getActMoreInfo());
                }
                statement.bindLong(5, (long)entity.getActInteractionType());
                if (entity.getActCorrectResponsePatterns() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getActCorrectResponsePatterns());
                }
                statement.bindLong(7, entity.getActLct());
            }
        };
        this.__preparedStmtOfUpdateIfMoreInfoChanged = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ActivityEntity\n           SET actMoreInfo = ?,\n               actLct = ?\n        WHERE actUid = ?\n          AND actMoreInfo != ?      \n    ";
                return "\n        UPDATE ActivityEntity\n           SET actMoreInfo = ?,\n               actLct = ?\n        WHERE actUid = ?\n          AND actMoreInfo != ?      \n    ";
            }
        };
        this.__preparedStmtOfUpdateIfNotYetDefined = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ActivityEntity\n           SET actType = ?,\n               actMoreInfo = ?,\n               actInteractionType = ?,\n               actCorrectResponsePatterns = ?\n         WHERE actUid = ?\n           AND (SELECT ActivityEntityInternal.actType \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = ?) IS NULL\n           AND (SELECT ActivityEntityInternal.actInteractionType \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = ?) = 0\n           AND (SELECT ActivityEntityInternal.actCorrectResponsePatterns \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = ?) IS NULL      \n    ";
                return "\n        UPDATE ActivityEntity\n           SET actType = ?,\n               actMoreInfo = ?,\n               actInteractionType = ?,\n               actCorrectResponsePatterns = ?\n         WHERE actUid = ?\n           AND (SELECT ActivityEntityInternal.actType \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = ?) IS NULL\n           AND (SELECT ActivityEntityInternal.actInteractionType \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = ?) = 0\n           AND (SELECT ActivityEntityInternal.actCorrectResponsePatterns \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = ?) IS NULL      \n    ";
            }
        };
    }

    @Override
    public Object insertOrIgnoreAsync(final List<ActivityEntity> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ActivityEntityDao_Impl.this.__db.beginTransaction();
                try {
                    ActivityEntityDao_Impl.this.__insertionAdapterOfActivityEntity.insert((Iterable)entities);
                    ActivityEntityDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActivityEntityDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateIfMoreInfoChanged(final long activityUid, final String actMoreInfo, final long actLct, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ActivityEntityDao_Impl.this.__preparedStmtOfUpdateIfMoreInfoChanged.acquire();
                int _argIndex = 1;
                if (actMoreInfo == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, actMoreInfo);
                }
                _argIndex = 2;
                _stmt.bindLong(_argIndex, actLct);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, activityUid);
                _argIndex = 4;
                if (actMoreInfo == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, actMoreInfo);
                }
                try {
                    Unit unit;
                    ActivityEntityDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ActivityEntityDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ActivityEntityDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ActivityEntityDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ActivityEntityDao_Impl.this.__preparedStmtOfUpdateIfMoreInfoChanged.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateIfNotYetDefined(final long actUid, final String actType, final String actMoreInfo, final int actInteractionType, final String actCorrectResponsePatterns, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ActivityEntityDao_Impl.this.__preparedStmtOfUpdateIfNotYetDefined.acquire();
                int _argIndex = 1;
                if (actType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, actType);
                }
                _argIndex = 2;
                if (actMoreInfo == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, actMoreInfo);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)actInteractionType);
                _argIndex = 4;
                if (actCorrectResponsePatterns == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, actCorrectResponsePatterns);
                }
                _argIndex = 5;
                _stmt.bindLong(_argIndex, actUid);
                _argIndex = 6;
                _stmt.bindLong(_argIndex, actUid);
                _argIndex = 7;
                _stmt.bindLong(_argIndex, actUid);
                _argIndex = 8;
                _stmt.bindLong(_argIndex, actUid);
                try {
                    Unit unit;
                    ActivityEntityDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ActivityEntityDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ActivityEntityDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ActivityEntityDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ActivityEntityDao_Impl.this.__preparedStmtOfUpdateIfNotYetDefined.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long activityUid, Continuation<? super ActivityEntity> $completion) {
        String _sql = "\n        SELECT ActivityEntity.*\n          FROM ActivityEntity\n         WHERE ActivityEntity.actUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActivityEntity.*\n          FROM ActivityEntity\n         WHERE ActivityEntity.actUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, activityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ActivityEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ActivityEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActivityEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ActivityEntity _result2;
                    int _cursorIndexOfActUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actUid");
                    int _cursorIndexOfActIdIri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actIdIri");
                    int _cursorIndexOfActType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actType");
                    int _cursorIndexOfActMoreInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actMoreInfo");
                    int _cursorIndexOfActInteractionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actInteractionType");
                    int _cursorIndexOfActCorrectResponsePatterns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actCorrectResponsePatterns");
                    int _cursorIndexOfActLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpActUid = _cursor.getLong(_cursorIndexOfActUid);
                        String _tmpActIdIri = _cursor.isNull(_cursorIndexOfActIdIri) ? null : _cursor.getString(_cursorIndexOfActIdIri);
                        String _tmpActType = _cursor.isNull(_cursorIndexOfActType) ? null : _cursor.getString(_cursorIndexOfActType);
                        String _tmpActMoreInfo = _cursor.isNull(_cursorIndexOfActMoreInfo) ? null : _cursor.getString(_cursorIndexOfActMoreInfo);
                        int _tmpActInteractionType = _cursor.getInt(_cursorIndexOfActInteractionType);
                        String _tmpActCorrectResponsePatterns = _cursor.isNull(_cursorIndexOfActCorrectResponsePatterns) ? null : _cursor.getString(_cursorIndexOfActCorrectResponsePatterns);
                        long _tmpActLct = _cursor.getLong(_cursorIndexOfActLct);
                        _result2 = new ActivityEntity(_tmpActUid, _tmpActIdIri, _tmpActType, _tmpActMoreInfo, _tmpActInteractionType, _tmpActCorrectResponsePatterns, _tmpActLct);
                    } else {
                        _result2 = null;
                    }
                    ActivityEntity activityEntity = _result2;
                    return activityEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

