"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const alias_setup_1 = require("./alias-setup");
const create_object_store_1 = require("./create-object-store");
const delete_database_1 = require("./delete-database");
const object_store_CRUD_1 = require("./object-store-CRUD");
const object_store_metadata_1 = require("./object-store-metadata");
const open_database_1 = require("./open-database");
function setupIDBHelpers() {
    Cypress.Commands.overwriteQuery('as', alias_setup_1.overrideAs);
    Cypress.Commands.add(`clearIndexedDb`, delete_database_1.deleteDatabase);
    Cypress.Commands.add(`openIndexedDb`, open_database_1.openIndexedDb);
    Cypress.Commands.add(`getIndexedDb`, alias_setup_1.getDatabase);
    Cypress.Commands.add(`createObjectStore`, { prevSubject: true }, create_object_store_1.createObjectStore);
    Cypress.Commands.add(`getStore`, alias_setup_1.getStore);
    Cypress.Commands.add(`createItem`, { prevSubject: true }, object_store_CRUD_1.createItem);
    Cypress.Commands.add(`updateItem`, { prevSubject: true }, object_store_CRUD_1.updateItem);
    Cypress.Commands.add(`deleteItem`, { prevSubject: true }, object_store_CRUD_1.deleteItem);
    Cypress.Commands.add(`readItem`, { prevSubject: true }, object_store_CRUD_1.readItem);
    Cypress.Commands.add(`addItem`, { prevSubject: true }, object_store_CRUD_1.addItem);
    Cypress.Commands.add(`keys`, { prevSubject: true }, object_store_metadata_1.keys);
    Cypress.Commands.add(`entries`, { prevSubject: true }, object_store_metadata_1.entries);
}
setupIDBHelpers();
//# sourceMappingURL=cypress-indexeddb.js.map