"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteDatabase = void 0;
/**
 * Deletes the database based on the provided string.
 *
 * @param databaseName - The database name you want to delete
 *
 * @returns An Promise<void>.
 * @throws {Error} If the database does not exist or is blocked by open connections.
 */
function deleteDatabase(databaseName) {
    let error;
    let warning;
    const log = Cypress.log({
        name: `delete`,
        type: 'parent',
        message: `IDBDatabase - ${databaseName}`,
        consoleProps: () => ({
            'database name': databaseName,
            error: error || 'no',
            warning: warning || 'no',
        }),
        autoEnd: false,
    });
    return new Promise((resolve, reject) => {
        const deleteDb = window.indexedDB.deleteDatabase(databaseName);
        const errorHandler = (e) => {
            error = e;
            log.error(e).end();
            reject();
        };
        const warningHandler = (e) => {
            warning = e;
        };
        deleteDb.onsuccess = () => {
            log.end();
            resolve();
        };
        deleteDb.onerror = errorHandler;
        deleteDb.onblocked = warningHandler;
        deleteDb.onupgradeneeded = errorHandler;
    });
}
exports.deleteDatabase = deleteDatabase;
//# sourceMappingURL=delete-database.js.map