"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCommandArguments = exports.isIDBDatabase = exports.isIDBObjectStore = void 0;
function isIDBObjectStore(subject) {
    var _a;
    return typeof subject === 'object' && ((_a = subject === null || subject === void 0 ? void 0 : subject.constructor) === null || _a === void 0 ? void 0 : _a.name) === 'IDBObjectStore';
}
exports.isIDBObjectStore = isIDBObjectStore;
function isIDBDatabase(subject) {
    var _a;
    return typeof subject === 'object' && ((_a = subject === null || subject === void 0 ? void 0 : subject.constructor) === null || _a === void 0 ? void 0 : _a.name) === 'IDBDatabase';
}
exports.isIDBDatabase = isIDBDatabase;
function getCommandArguments(key, value) {
    return key ? getCommandArgumentsBasedOnValue(key, value) : [value];
}
exports.getCommandArguments = getCommandArguments;
function getCommandArgumentsBasedOnValue(key, value) {
    return value ? [value, key] : [key];
}
//# sourceMappingURL=helpers.js.map