/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.SSLConfigurableSocket;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ConfigurableSSLSocketFactory
extends SocketFactory {
    private final SSLParametersConfiguration parameters;
    private final SSLSocketFactory delegate;

    public ConfigurableSSLSocketFactory(SSLParametersConfiguration parameters2, SSLSocketFactory delegate) {
        this.parameters = parameters2;
        this.delegate = delegate;
    }

    @Override
    public Socket createSocket(InetAddress address2, int port2, InetAddress localAddress2, int localPort2) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(address2, port2, localAddress2, localPort2);
        this.parameters.configure(new SSLConfigurableSocket(socket));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host2, int port2) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host2, port2);
        this.parameters.configure(new SSLConfigurableSocket(socket));
        return socket;
    }

    @Override
    public Socket createSocket(String host2, int port2, InetAddress localHost2, int localPort2) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host2, port2, localHost2, localPort2);
        this.parameters.configure(new SSLConfigurableSocket(socket));
        return socket;
    }

    @Override
    public Socket createSocket(String host2, int port2) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host2, port2);
        this.parameters.configure(new SSLConfigurableSocket(socket));
        return socket;
    }
}

