/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.door;

import com.ustadmobile.door.RepositoryConfig;
import com.ustadmobile.door.RepositoryConnectivityListener;
import com.ustadmobile.door.ext.ListExtKt;
import com.ustadmobile.door.ext.RoomDatabaseInternalExtKt;
import com.ustadmobile.door.nodeevent.NodeEventManager;
import com.ustadmobile.door.nodeevent.NodeEventSseClient;
import com.ustadmobile.door.replication.DoorRepositoryReplicationClient;
import com.ustadmobile.door.room.RoomDatabase;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\r\u0010&\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006("}, d2={"Lcom/ustadmobile/door/RepositoryHelper;", "", "db", "Lcom/ustadmobile/door/room/RoomDatabase;", "repoConfig", "Lcom/ustadmobile/door/RepositoryConfig;", "(Lcom/ustadmobile/door/room/RoomDatabase;Lcom/ustadmobile/door/RepositoryConfig;)V", "client", "Lcom/ustadmobile/door/replication/DoorRepositoryReplicationClient;", "clientState", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/door/replication/DoorRepositoryReplicationClient$ClientState;", "getClientState", "()Lkotlinx/coroutines/flow/Flow;", "connectivityListeners", "", "Lcom/ustadmobile/door/RepositoryConnectivityListener;", "newValue", "", "connectivityStatus", "getConnectivityStatus", "()I", "setConnectivityStatus", "(I)V", "connectivityStatusAtomic", "Lkotlinx/atomicfu/AtomicInt;", "eventClient", "Lcom/ustadmobile/door/nodeevent/NodeEventSseClient;", "nodeEventManager", "Lcom/ustadmobile/door/nodeevent/NodeEventManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "close", "", "remoteNodeIdOrFake", "", "remoteNodeIdOrNull", "()Ljava/lang/Long;", "door-runtime"})
@SourceDebugExtension(value={"SMAP\nRepositoryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryHelper.kt\ncom/ustadmobile/door/RepositoryHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 RepositoryHelper.kt\ncom/ustadmobile/door/RepositoryHelper\n*L\n53#1:84,2\n*E\n"})
public final class RepositoryHelper {
    @NotNull
    private final RoomDatabase db;
    @NotNull
    private final RepositoryConfig repoConfig;
    @NotNull
    private final AtomicInt connectivityStatusAtomic;
    @NotNull
    private final List<RepositoryConnectivityListener> connectivityListeners;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final NodeEventManager<?> nodeEventManager;
    @NotNull
    private final DoorRepositoryReplicationClient client;
    @NotNull
    private final NodeEventSseClient eventClient;

    public RepositoryHelper(@NotNull RoomDatabase db, @NotNull RepositoryConfig repoConfig) {
        Intrinsics.checkNotNullParameter(db, "db");
        Intrinsics.checkNotNullParameter(repoConfig, "repoConfig");
        this.db = db;
        this.repoConfig = repoConfig;
        this.connectivityStatusAtomic = AtomicFU.atomic(0);
        this.connectivityListeners = ListExtKt.concurrentSafeListOf(new RepositoryConnectivityListener[0]);
        this.scope = CoroutineScopeKt.CoroutineScope(Dispatchers.getDefault().plus(JobKt.Job$default(null, 1, null)));
        this.nodeEventManager = RoomDatabaseInternalExtKt.getDoorWrapper(this.db).getNodeEventManager();
        this.client = new DoorRepositoryReplicationClient(this.db, this.repoConfig, this.scope, this.nodeEventManager, 1000);
        this.eventClient = new NodeEventSseClient(this.repoConfig, this.nodeEventManager, this.scope);
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final Flow<DoorRepositoryReplicationClient.ClientState> getClientState() {
        return this.client.getState();
    }

    public final int getConnectivityStatus() {
        return this.connectivityStatusAtomic.getValue();
    }

    public final void setConnectivityStatus(int newValue) {
        this.connectivityStatusAtomic.setValue(newValue);
        Iterable $this$forEach$iv = this.connectivityListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RepositoryConnectivityListener it = (RepositoryConnectivityListener)element$iv;
            boolean bl = false;
            try {
                it.onConnectivityStatusChanged(newValue);
            }
            catch (Exception e) {
                System.out.println((Object)("Exception with weakConnectivityListener " + e));
            }
        }
    }

    @Nullable
    public final Long remoteNodeIdOrNull() {
        return this.client.remoteNodeIdOrNull$door_runtime();
    }

    public final long remoteNodeIdOrFake() {
        return this.client.remoteNodeIdOrFake$door_runtime();
    }

    public final void close() {
        this.client.close();
        this.eventClient.close();
        CoroutineScopeKt.cancel$default(this.scope, null, 1, null);
    }
}

