/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.core.Encoding;

public class EncodingPredictor {
    private static final Translation[] FATAL_TRANSLATIONS = new Translation[]{new Translation("\u0412\u0410\u0416\u041d\u041e", null, "ru", "WIN", "ALT", "KOI8"), new Translation("\u81f4\u547d\u9519\u8bef", null, "zh_CN", "EUC_CN", "GBK", "BIG5"), new Translation("KATASTROFALNY", null, "pl", "LATIN2"), new Translation("FATALE", null, "it", "LATIN1", "LATIN9"), new Translation("FATAL", new String[]{"\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", "\u30ed\u30fc\u30eb", "\u30e6\u30fc\u30b6"}, "ja", "EUC_JP", "SJIS"), new Translation(null, null, "fr/de/es/pt_BR", "LATIN1", "LATIN3", "LATIN4", "LATIN5", "LATIN7", "LATIN9")};

    public static @Nullable DecodeResult decode(byte[] bytes, int offset, int length) {
        Encoding defaultEncoding = Encoding.defaultEncoding();
        for (Translation tr2 : FATAL_TRANSLATIONS) {
            for (String encoding : tr2.encodings) {
                Encoding encoder2 = Encoding.getDatabaseEncoding(encoding);
                if (encoder2 == defaultEncoding) continue;
                if (tr2.fatalText != null) {
                    byte[] encoded2;
                    try {
                        byte[] tmp = encoder2.encode(tr2.fatalText);
                        encoded2 = new byte[tmp.length + 2];
                        encoded2[0] = 83;
                        encoded2[encoded2.length - 1] = 0;
                        System.arraycopy(tmp, 0, encoded2, 1, tmp.length);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    if (!EncodingPredictor.arrayContains(bytes, offset, length, encoded2, 0, encoded2.length)) continue;
                }
                if (tr2.texts != null) {
                    boolean foundOne = false;
                    for (String text2 : tr2.texts) {
                        try {
                            byte[] textBytes = encoder2.encode(text2);
                            if (!EncodingPredictor.arrayContains(bytes, offset, length, textBytes, 0, textBytes.length)) continue;
                            foundOne = true;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!foundOne) continue;
                }
                try {
                    String decoded = encoder2.decode(bytes, offset, length);
                    if (decoded.indexOf(65533) != -1) continue;
                    return new DecodeResult(decoded, encoder2.name());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static boolean arrayContains(byte[] first2, int firstOffset, int firstLength, byte[] second2, int secondOffset, int secondLength) {
        if (firstLength < secondLength) {
            return false;
        }
        for (int i2 = 0; i2 < firstLength; ++i2) {
            int j;
            while (i2 < firstLength && first2[firstOffset + i2] != second2[secondOffset]) {
                ++i2;
            }
            for (j = 1; j < secondLength && first2[firstOffset + i2 + j] == second2[secondOffset + j]; ++j) {
            }
            if (j != secondLength) continue;
            return true;
        }
        return false;
    }

    static class Translation {
        public final @Nullable String fatalText;
        private final String @Nullable [] texts;
        public final String language;
        public final String[] encodings;

        Translation(@Nullable String fatalText, String @Nullable [] texts, String language, String ... encodings) {
            this.fatalText = fatalText;
            this.texts = texts;
            this.language = language;
            this.encodings = encodings;
        }
    }

    public static class DecodeResult {
        public final String result;
        public final @Nullable String encoding;

        DecodeResult(String result2, @Nullable String encoding) {
            this.result = result2;
            this.encoding = encoding;
        }
    }
}

