/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.Classes;
import org.junit.runner.Computer;
import org.junit.runner.FilterFactories;
import org.junit.runner.FilterFactory;
import org.junit.runner.Request;
import org.junit.runner.manipulation.Filter;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JUnitCommandLineParseResult {
    private final List<String> filterSpecs = new ArrayList<String>();
    private final List<Class<?>> classes = new ArrayList();
    private final List<Throwable> parserErrors = new ArrayList<Throwable>();

    JUnitCommandLineParseResult() {
    }

    public List<String> getFilterSpecs() {
        return Collections.unmodifiableList(this.filterSpecs);
    }

    public List<Class<?>> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    public static JUnitCommandLineParseResult parse(String[] args2) {
        JUnitCommandLineParseResult result2 = new JUnitCommandLineParseResult();
        result2.parseArgs(args2);
        return result2;
    }

    private void parseArgs(String[] args2) {
        this.parseParameters(this.parseOptions(args2));
    }

    /*
     * Enabled aggressive block sorting
     */
    String[] parseOptions(String ... args2) {
        int i2 = 0;
        while (i2 != args2.length) {
            String arg = args2[i2];
            if (arg.equals("--")) {
                return this.copyArray(args2, i2 + 1, args2.length);
            }
            if (!arg.startsWith("--")) return this.copyArray(args2, i2, args2.length);
            if (arg.startsWith("--filter=") || arg.equals("--filter")) {
                String filterSpec;
                if (arg.equals("--filter")) {
                    if (++i2 >= args2.length) {
                        this.parserErrors.add(new CommandLineParserError(arg + " value not specified"));
                        return new String[0];
                    }
                    filterSpec = args2[i2];
                } else {
                    filterSpec = arg.substring(arg.indexOf(61) + 1);
                }
                this.filterSpecs.add(filterSpec);
            } else {
                this.parserErrors.add(new CommandLineParserError("JUnit knows nothing about the " + arg + " option"));
            }
            ++i2;
        }
        return new String[0];
    }

    private String[] copyArray(String[] args2, int from2, int to) {
        String[] result2 = new String[to - from2];
        for (int j = from2; j != to; ++j) {
            result2[j - from2] = args2[j];
        }
        return result2;
    }

    void parseParameters(String[] args2) {
        for (String arg : args2) {
            try {
                this.classes.add(Classes.getClass(arg));
            }
            catch (ClassNotFoundException e) {
                this.parserErrors.add(new IllegalArgumentException("Could not find class [" + arg + "]", e));
            }
        }
    }

    private Request errorReport(Throwable cause) {
        return Request.errorReport(JUnitCommandLineParseResult.class, cause);
    }

    public Request createRequest(Computer computer) {
        if (this.parserErrors.isEmpty()) {
            Request request2 = Request.classes(computer, this.classes.toArray(new Class[this.classes.size()]));
            return this.applyFilterSpecs(request2);
        }
        return this.errorReport(new InitializationError(this.parserErrors));
    }

    private Request applyFilterSpecs(Request request2) {
        try {
            for (String filterSpec : this.filterSpecs) {
                Filter filter2 = FilterFactories.createFilterFromFilterSpec(request2, filterSpec);
                request2 = request2.filterWith(filter2);
            }
            return request2;
        }
        catch (FilterFactory.FilterNotCreatedException e) {
            return this.errorReport(e);
        }
    }

    public static class CommandLineParserError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CommandLineParserError(String message) {
            super(message);
        }
    }
}

