/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbcurlresolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.PGEnvironment;
import org.postgresql.PGProperty;
import org.postgresql.util.OSUtil;
import org.postgresql.util.PGPropertyUtil;

public class PgServiceConfParser {
    private static final Logger LOGGER = Logger.getLogger(PgServiceConfParser.class.getName());
    private final String serviceName;
    private boolean ignoreIfOpenFails = true;

    private PgServiceConfParser(String serviceName) {
        this.serviceName = serviceName;
    }

    public static @Nullable Properties getServiceProperties(String serviceName) {
        PgServiceConfParser pgServiceConfParser = new PgServiceConfParser(serviceName);
        return pgServiceConfParser.findServiceDescription();
    }

    private @Nullable Properties findServiceDescription() {
        String resourceName = this.findPgServiceConfResourceName();
        if (resourceName == null) {
            return null;
        }
        Properties result2 = null;
        try (InputStream inputStream2 = this.openInputStream(resourceName);){
            result2 = this.parseInputStream(inputStream2);
        }
        catch (IOException e) {
            Level level = this.ignoreIfOpenFails ? Level.FINE : Level.WARNING;
            LOGGER.log(level, "Failed to handle resource [{0}] with error [{1}]", new Object[]{resourceName, e.getMessage()});
        }
        return result2;
    }

    private InputStream openInputStream(String resourceName) throws IOException {
        try {
            URL url2 = new URL(resourceName);
            return url2.openStream();
        }
        catch (MalformedURLException ex) {
            File file2 = new File(resourceName);
            return new FileInputStream(file2);
        }
    }

    private @Nullable String findPgServiceConfResourceName() {
        String pgServiceConfFileDefaultName = PGEnvironment.PGSERVICEFILE.getDefaultValue();
        String propertyName = PGEnvironment.ORG_POSTGRESQL_PGSERVICEFILE.getName();
        String resourceName = System.getProperty(propertyName);
        if (resourceName != null && !resourceName.trim().isEmpty()) {
            this.ignoreIfOpenFails = false;
            LOGGER.log(Level.FINE, "Value [{0}] selected from property [{1}]", new Object[]{resourceName, propertyName});
            return resourceName;
        }
        String envVariableName = PGEnvironment.PGSERVICEFILE.getName();
        resourceName = System.getenv().get(envVariableName);
        if (resourceName != null && !resourceName.trim().isEmpty()) {
            this.ignoreIfOpenFails = false;
            LOGGER.log(Level.FINE, "Value [{0}] selected from environment variable [{1}]", new Object[]{resourceName, envVariableName});
            return resourceName;
        }
        String resourceName2 = "." + pgServiceConfFileDefaultName;
        File resourceFile = new File(OSUtil.getUserConfigRootDirectory(), resourceName2);
        if (resourceFile.canRead()) {
            LOGGER.log(Level.FINE, "Value [{0}] selected because file exist in user home directory", new Object[]{resourceFile.getAbsolutePath()});
            return resourceFile.getAbsolutePath();
        }
        envVariableName = PGEnvironment.PGSYSCONFDIR.getName();
        String pgSysconfDir = System.getenv().get(envVariableName);
        if (pgSysconfDir != null && !pgSysconfDir.trim().isEmpty()) {
            String resourceName3 = pgSysconfDir + File.separator + pgServiceConfFileDefaultName;
            LOGGER.log(Level.FINE, "Value [{0}] selected using environment variable [{1}]", new Object[]{resourceName3, envVariableName});
            return resourceName3;
        }
        LOGGER.log(Level.FINE, "Value for resource [{0}] not found", pgServiceConfFileDefaultName);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable Properties parseInputStream(InputStream inputStream2) throws IOException {
        Set allowedServiceKeys = Arrays.stream(PGProperty.values()).map(PGProperty::getName).map(PGPropertyUtil::translatePGPropertyToPGService).collect(Collectors.toSet());
        Properties result2 = new Properties();
        boolean isFound = false;
        try (InputStreamReader reader = new InputStreamReader(inputStream2, StandardCharsets.UTF_8);
             BufferedReader br2 = new BufferedReader(reader);){
            String originalLine;
            int lineNumber = 0;
            while ((originalLine = br2.readLine()) != null) {
                ++lineNumber;
                String line = originalLine.trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                int indexOfEqualSign = line.indexOf("=");
                if (line.startsWith("[") && line.endsWith("]")) {
                    if (!isFound) {
                        String sectionName = line.substring(1, line.length() - 1);
                        if (!this.serviceName.equals(sectionName)) continue;
                        isFound = true;
                        continue;
                    }
                    break;
                }
                if (!isFound) continue;
                if (indexOfEqualSign <= 1) {
                    LOGGER.log(Level.WARNING, "Not valid line: line number [{0}], value [{1}]", new Object[]{lineNumber, originalLine});
                    Properties properties2 = null;
                    return properties2;
                }
                String key2 = line.substring(0, indexOfEqualSign);
                String value = line.substring(indexOfEqualSign + 1);
                if (!allowedServiceKeys.contains(key2)) {
                    String allowedValuesCommaSeparated = allowedServiceKeys.stream().sorted().collect(Collectors.joining(","));
                    LOGGER.log(Level.SEVERE, "Got invalid key: line number [{0}], value [{1}], allowed values [{2}]", new Object[]{lineNumber, originalLine, allowedValuesCommaSeparated});
                    Properties properties3 = null;
                    return properties3;
                }
                if (value.isEmpty()) continue;
                result2.putIfAbsent(PGPropertyUtil.translatePGServiceToPGProperty(key2), value);
            }
        }
        if (!isFound) return null;
        Properties properties4 = result2;
        return properties4;
    }
}

