/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.transform.HueAdjustments;
import com.github.ajalt.colormath.transform.Interpolator;
import com.github.ajalt.colormath.transform.InterpolatorBuilder;
import com.github.ajalt.colormath.transform.InterpolatorBuilderImpl;
import com.github.ajalt.colormath.transform.PremultiplyKt;
import com.github.ajalt.colormath.transform.Stop;
import com.github.ajalt.colormath.transform.TransformKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000|\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u001ah\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u000723\b\u0002\u0010\b\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0002`\t\u00a2\u0006\u0002\u0010\u0010\u001a9\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0012\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\n\u00a2\u0006\u0002\b\u0017\u001aC\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0012\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00132\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0019\"\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001a\u001a(\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00010\u001f\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00122\u0006\u0010 \u001a\u00020!\u001aZ\u0010\"\u001a\u00020\u00162\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001321\u0010\b\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0002`\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000bH\u0002\u00a2\u0006\u0002\u0010&\u001a<\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u00072\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u001a\u001c\u0010.\u001a\u00020/2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000e\u001a\u00020/H\u0002\u001a$\u00102\u001a\u00020(2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00103\u001a\u00020(H\u0002\u001a$\u00104\u001a\u00020(2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00103\u001a\u00020(H\u0002\u001a \u00105\u001a\u00020\f2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fH\u0002\";\u00100\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0002`\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101*X\u0010\u001b\")\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2)\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n*,\u0010\u001c\"\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\n\u00a2\u0006\u0002\b\u00172\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\n\u00a2\u0006\u0002\b\u0017\u00a8\u00066"}, d2={"interpolate", "T", "Lcom/github/ajalt/colormath/Color;", "other", "t", "", "premultiplyAlpha", "", "hueAdjustment", "Lcom/github/ajalt/colormath/transform/ComponentAdjustment;", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "hues", "(Lcom/github/ajalt/colormath/Color;Lcom/github/ajalt/colormath/Color;Ljava/lang/Number;ZLkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "interpolator", "Lcom/github/ajalt/colormath/transform/Interpolator;", "Lcom/github/ajalt/colormath/ColorSpace;", "builder", "Lcom/github/ajalt/colormath/transform/InterpolatorBuilder;", "", "Lkotlin/ExtensionFunctionType;", "stops", "", "(Lcom/github/ajalt/colormath/ColorSpace;[Lcom/github/ajalt/colormath/Color;Z)Lcom/github/ajalt/colormath/transform/Interpolator;", "ComponentAdjustment", "InterpolatorStopBuilderContext", "Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilder;", "sequence", "Lkotlin/sequences/Sequence;", "length", "", "fixupHues", "space", "entries", "Lcom/github/ajalt/colormath/transform/Stop;", "(Lcom/github/ajalt/colormath/ColorSpace;Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "interpolateComponents", "", "l", "r", "out", "amount", "divideAlpha", "requireComponentName", "", "alphaAdjustment", "Lkotlin/jvm/functions/Function1;", "mult", "components", "div", "lerp", "colormath"})
@SourceDebugExtension(value={"SMAP\nInterpolate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolateKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,449:1\n1#2:450\n1557#3:451\n1628#3,3:452\n1872#3,3:455\n1755#3,3:458\n1557#3:461\n1628#3,3:462\n1734#3,3:467\n1557#3:470\n1628#3,3:471\n13346#4,2:465\n*S KotlinDebug\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolateKt\n*L\n388#1:451\n388#1:452,3\n388#1:455,3\n409#1:458,3\n411#1:461\n411#1:462,3\n418#1:467,3\n419#1:470\n419#1:471,3\n72#1:465,2\n*E\n"})
public final class InterpolateKt {
    @NotNull
    private static final Function1<List<Float>, List<Float>> alphaAdjustment = InterpolateKt::alphaAdjustment$lambda$12;

    @NotNull
    public static final <T extends Color> T interpolate(@NotNull T $this$interpolate, @NotNull Color other, @NotNull Number t, boolean premultiplyAlpha, @NotNull Function1<? super List<Float>, ? extends List<Float>> hueAdjustment) {
        Intrinsics.checkNotNullParameter($this$interpolate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter(hueAdjustment, (String)"hueAdjustment");
        return TransformKt.map($this$interpolate, (arg_0, arg_1) -> InterpolateKt.interpolate$lambda$0(premultiplyAlpha, other, hueAdjustment, t, $this$interpolate, arg_0, arg_1));
    }

    public static /* synthetic */ Color interpolate$default(Color color, Color color2, Number number, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = HueAdjustments.INSTANCE.getShorter();
        }
        return InterpolateKt.interpolate(color, color2, number, bl, function1);
    }

    @NotNull
    public static final <T extends Color> Interpolator<T> interpolator(@NotNull ColorSpace<T> $this$interpolator, @NotNull Function1<? super InterpolatorBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter($this$interpolator, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        InterpolatorBuilderImpl<T> interpolatorBuilderImpl = new InterpolatorBuilderImpl<T>($this$interpolator);
        builder.invoke(interpolatorBuilderImpl);
        return interpolatorBuilderImpl.build();
    }

    @NotNull
    public static final <T extends Color> Interpolator<T> interpolator(@NotNull ColorSpace<T> $this$interpolator, @NotNull Color[] stops, boolean premultiplyAlpha) {
        Intrinsics.checkNotNullParameter($this$interpolator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stops, (String)"stops");
        if (!(stops.length > 1)) {
            boolean bl = false;
            String string = "interpolators require at least two stops";
            throw new IllegalArgumentException(string.toString());
        }
        return InterpolateKt.interpolator($this$interpolator, (Function1<? super InterpolatorBuilder, Unit>)((Function1)arg_0 -> InterpolateKt.interpolator$lambda$3(premultiplyAlpha, stops, arg_0)));
    }

    public static /* synthetic */ Interpolator interpolator$default(ColorSpace colorSpace, Color[] colorArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return InterpolateKt.interpolator(colorSpace, colorArray, bl);
    }

    @NotNull
    public static final <T extends Color> Sequence<T> sequence(@NotNull Interpolator<T> $this$sequence, int length) {
        Intrinsics.checkNotNullParameter($this$sequence, (String)"<this>");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)length))), arg_0 -> InterpolateKt.sequence$lambda$4($this$sequence, length, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void fixupHues(ColorSpace<?> space, Function1<? super List<Float>, ? extends List<Float>> hueAdjustment, List<Stop> entries) {
        Iterator iterator = ((Iterable)space.getComponents()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int i = n++;
            ColorComponentInfo c = (ColorComponentInfo)iterator.next();
            if (!c.isPolar()) continue;
            Iterable iterable = entries;
            Function1<? super List<Float>, ? extends List<Float>> function1 = hueAdjustment;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stop stop = (Stop)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(it.getComponents()[i]));
            }
            Iterable $this$forEachIndexed$iv = (Iterable)function1.invoke((Object)((List)destination$iv$iv));
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void hue;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float item$iv$iv = ((Number)item$iv).floatValue();
                int j = n2;
                boolean bl = false;
                entries.get((int)j).getComponents()[i] = hue;
            }
        }
    }

    private static final float[] interpolateComponents(float[] l, float[] r, float[] out, float amount, boolean divideAlpha, ColorSpace<?> space) {
        int n = out.length;
        for (int i = 0; i < n; ++i) {
            out[i] = InterpolateKt.lerp(l[i], r[i], amount);
        }
        return InterpolateKt.div(space, divideAlpha, out);
    }

    /*
     * WARNING - void declaration
     */
    private static final String requireComponentName(ColorSpace<?> space, String name) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = space.getComponents();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ColorComponentInfo it = (ColorComponentInfo)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it.getName(), (String)name, (boolean)true)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl3 = false;
            Iterable iterable = space.getComponents();
            StringBuilder stringBuilder = new StringBuilder().append("Unknown component name \"").append(name).append("\" for color model ").append(space.getName()).append(". Valid names are ");
            boolean $i$f$map = false;
            void bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColorComponentInfo colorComponentInfo = (ColorComponentInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getName());
            }
            String string = stringBuilder.append((List)destination$iv$iv).toString();
            throw new IllegalArgumentException(string.toString());
        }
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final float[] mult(ColorSpace<?> space, boolean premultiplyAlpha, float[] components) {
        if (premultiplyAlpha) {
            PremultiplyKt.multiplyAlphaInPlace(space, components);
        }
        return components;
    }

    private static final float[] div(ColorSpace<?> space, boolean premultiplyAlpha, float[] components) {
        if (premultiplyAlpha) {
            PremultiplyKt.divideAlphaInPlace(space, components);
        }
        return components;
    }

    private static final float lerp(float l, float r, float amount) {
        return Float.isNaN(l) ? r : (Float.isNaN(r) ? l : l + amount * (r - l));
    }

    private static final float[] interpolate$lambda$0(boolean $premultiplyAlpha, Color $other, Function1 $hueAdjustment, Number $t, Color $this_interpolate, ColorSpace $this$map, float[] components) {
        Intrinsics.checkNotNullParameter((Object)$other, (String)"$other");
        Intrinsics.checkNotNullParameter((Object)$hueAdjustment, (String)"$hueAdjustment");
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)$this_interpolate, (String)"$this_interpolate");
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$this$map");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        float[] l = InterpolateKt.mult($this$map, $premultiplyAlpha, components);
        float[] r = InterpolateKt.mult($this$map, $premultiplyAlpha, $this$map.convert($other).toArray());
        Object[] objectArray = new Stop[]{new Stop(l, 0.0f), new Stop(r, 1.0f)};
        InterpolateKt.fixupHues($this$map, (Function1<? super List<Float>, ? extends List<Float>>)$hueAdjustment, CollectionsKt.listOf((Object[])objectArray));
        return InterpolateKt.interpolateComponents(l, r, new float[components.length], $t.floatValue(), $premultiplyAlpha, $this_interpolate.getSpace());
    }

    private static final Unit interpolator$lambda$3(boolean $premultiplyAlpha, Color[] $stops, InterpolatorBuilder $this$interpolator) {
        Intrinsics.checkNotNullParameter((Object)$stops, (String)"$stops");
        Intrinsics.checkNotNullParameter((Object)$this$interpolator, (String)"$this$interpolator");
        $this$interpolator.setPremultiplyAlpha($premultiplyAlpha);
        Color[] $this$forEach$iv = $stops;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Color element$iv;
            Color it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            InterpolatorBuilder.DefaultImpls.stop$default($this$interpolator, it, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Color sequence$lambda$4(Interpolator $this_sequence, int $length, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_sequence, (String)"$this_sequence");
        return $this_sequence.interpolate(Float.valueOf((float)it / (float)RangesKt.coerceAtLeast((int)($length - 1), (int)1)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List alphaAdjustment$lambda$12(List l) {
        List list;
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            Iterable $this$all$iv = l;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    float it = ((Number)element$iv).floatValue();
                    boolean bl2 = false;
                    if (Float.isNaN(it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            list = l;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = l;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(Float.valueOf(Float.isNaN((float)it) ? 1.0f : it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public static final /* synthetic */ String access$requireComponentName(ColorSpace space, String name) {
        return InterpolateKt.requireComponentName(space, name);
    }

    public static final /* synthetic */ float[] access$div(ColorSpace space, boolean premultiplyAlpha, float[] components) {
        return InterpolateKt.div(space, premultiplyAlpha, components);
    }

    public static final /* synthetic */ Function1 access$getAlphaAdjustment$p() {
        return alphaAdjustment;
    }

    public static final /* synthetic */ float access$lerp(float l, float r, float amount) {
        return InterpolateKt.lerp(l, r, amount);
    }

    public static final /* synthetic */ float[] access$mult(ColorSpace space, boolean premultiplyAlpha, float[] components) {
        return InterpolateKt.mult(space, premultiplyAlpha, components);
    }
}

