/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.model.SRGB;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\"\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/github/ajalt/colormath/model/HUSLColorConverter;", "", "<init>", "()V", "maxSafeChromaForL", "", "L", "maxChromaForLH", "H", "getBounds", "", "Lkotlin/Pair;", "intersectLineLine", "x1", "y1", "x2", "y2", "distanceFromPole", "x", "y", "lengthOfRayUntilIntersect", "theta", "a", "b", "colormath"})
@SourceDebugExtension(value={"SMAP\nHSLuv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSLuv.kt\ncom/github/ajalt/colormath/model/HUSLColorConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class HUSLColorConverter {
    @NotNull
    public static final HUSLColorConverter INSTANCE = new HUSLColorConverter();

    private HUSLColorConverter() {
    }

    public final double maxSafeChromaForL(double L) {
        Iterator iterator2 = ((Iterable)this.getBounds(L)).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair pair = (Pair)iterator2.next();
        boolean bl = false;
        double m1 = ((Number)pair.component1()).doubleValue();
        double b1 = ((Number)pair.component2()).doubleValue();
        double x = INSTANCE.intersectLineLine(m1, b1, (double)-1 / m1, 0.0);
        double d = INSTANCE.distanceFromPole(x, b1 + x * m1);
        while (iterator2.hasNext()) {
            Pair pair2 = (Pair)iterator2.next();
            $i$a$-minOf-HUSLColorConverter$maxSafeChromaForL$1 = false;
            double m12 = ((Number)pair2.component1()).doubleValue();
            double b12 = ((Number)pair2.component2()).doubleValue();
            double x2 = INSTANCE.intersectLineLine(m12, b12, (double)-1 / m12, 0.0);
            double d2 = INSTANCE.distanceFromPole(x2, b12 + x2 * m12);
            d = Math.min(d, d2);
        }
        return d;
    }

    public final double maxChromaForLH(double L, double H) {
        double hrad = H / (double)360 * Math.PI * (double)2;
        Iterator iterator2 = ((Iterable)this.getBounds(L)).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair pair = (Pair)iterator2.next();
        boolean bl = false;
        double mi = ((Number)pair.component1()).doubleValue();
        double hi = ((Number)pair.component2()).doubleValue();
        double it = INSTANCE.lengthOfRayUntilIntersect(hrad, mi, hi);
        boolean bl2 = false;
        double d = it < 0.0 ? Double.MAX_VALUE : it;
        while (iterator2.hasNext()) {
            Pair pair2 = (Pair)iterator2.next();
            $i$a$-minOf-HUSLColorConverter$maxChromaForLH$1 = false;
            double mi2 = ((Number)pair2.component1()).doubleValue();
            double hi2 = ((Number)pair2.component2()).doubleValue();
            double it2 = INSTANCE.lengthOfRayUntilIntersect(hrad, mi2, hi2);
            $i$a$-let-HUSLColorConverter$maxChromaForLH$1$1 = false;
            double d2 = it2 < 0.0 ? Double.MAX_VALUE : it2;
            d = Math.min(d, d2);
        }
        return d;
    }

    private final List<Pair<Double, Double>> getBounds(double L) {
        ArrayList<Pair<Double, Double>> result = new ArrayList<Pair<Double, Double>>(6);
        double sub1 = Math.pow(L + (double)16, 3) / (double)1560896;
        double sub2 = sub1 > 0.008856451679035631 ? sub1 : L / 903.2962962962963;
        for (int c = 0; c < 3; ++c) {
            float m1 = Matrix.get-impl(Matrix.constructor-impl(SRGB.INSTANCE.getMatrixFromXyz()), 0, c);
            float m2 = Matrix.get-impl(Matrix.constructor-impl(SRGB.INSTANCE.getMatrixFromXyz()), 1, c);
            float m3 = Matrix.get-impl(Matrix.constructor-impl(SRGB.INSTANCE.getMatrixFromXyz()), 2, c);
            for (int t = 0; t < 2; ++t) {
                double top1 = (double)((float)284517 * m1 - (float)94839 * m3) * sub2;
                double top2 = (double)((float)838422 * m3 + (float)769860 * m2 + (float)731718 * m1) * L * sub2 - (double)(769860 * t) * L;
                double bottom = (double)((float)632260 * m3 - (float)126452 * m2) * sub2 + (double)(126452 * t);
                result.add(TuplesKt.to(top1 / bottom, top2 / bottom));
            }
        }
        return result;
    }

    private final double intersectLineLine(double x1, double y1, double x2, double y2) {
        return (y1 - y2) / (x2 - x1);
    }

    private final double distanceFromPole(double x, double y) {
        return Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
    }

    private final double lengthOfRayUntilIntersect(double theta, double a, double b) {
        return b / (Math.sin(theta) - a * Math.cos(theta));
    }
}

