/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\b\b\u0002\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016Ja\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192K\u0010\u001a\u001aG\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b( \u0012\u0004\u0012\u0002H\u00190\u001bH\u0082\b\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0000H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0000H\u0016J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J1\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00066"}, d2={"Lcom/github/ajalt/colormath/model/Oklab;", "Lcom/github/ajalt/colormath/Color;", "l", "", "a", "b", "alpha", "<init>", "(FFFF)V", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getL", "()F", "getA", "getB", "getAlpha", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "calculateConeResponse", "T", "block", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "m", "s", "(Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "toOklch", "Lcom/github/ajalt/colormath/model/Oklch;", "toOklab", "toArray", "", "clamp", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nOklab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oklab.kt\ncom/github/ajalt/colormath/model/Oklab\n+ 2 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n+ 3 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,78:1\n62#1,9:79\n62#1,9:88\n31#2,3:97\n89#3,12:100\n*S KotlinDebug\n*F\n+ 1 Oklab.kt\ncom/github/ajalt/colormath/model/Oklab\n*L\n41#1:79,9\n52#1:88,9\n73#1:97,3\n76#1:100,12\n*E\n"})
public final class Oklab
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float a;
    private final float b;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.threeComponentInfo("l", 0.0f, 1.0f, "a", -0.4f, 0.4f, "b", -0.4f, 0.4f);

    public Oklab(float l, float a, float b, float alpha) {
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
    }

    public /* synthetic */ Oklab(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getL() {
        return this.l;
    }

    public final float getA() {
        return this.a;
    }

    public final float getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public Oklab(@NotNull Number l, @NotNull Number a, @NotNull Number b, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(l.floatValue(), a.floatValue(), b.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ Oklab(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<Oklab> getSpace() {
        return Companion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB toSRGB() {
        void s;
        void m;
        double s$iv;
        Oklab this_$iv = this;
        boolean $i$f$calculateConeResponse = false;
        double ll$iv = (double)this_$iv.l + 0.3963377774 * (double)this_$iv.a + 0.2158037573 * (double)this_$iv.b;
        double mm$iv = (double)this_$iv.l - 0.1055613458 * (double)this_$iv.a - 0.0638541728 * (double)this_$iv.b;
        double ss$iv = (double)this_$iv.l - 0.0894841775 * (double)this_$iv.a - 1.291485548 * (double)this_$iv.b;
        double l$iv = ll$iv * ll$iv * ll$iv;
        double m$iv = mm$iv * mm$iv * mm$iv;
        double d = s$iv = ss$iv * ss$iv * ss$iv;
        double d2 = m$iv;
        double l = l$iv;
        boolean bl = false;
        double r = 4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s;
        double g = -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s;
        double b = -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s;
        RGBColorSpace.TransferFunctions f = RGB.Companion.getTransferFunctions();
        return RGB.Companion.invoke(f.oetf((float)r), f.oetf((float)g), f.oetf((float)b), this.getAlpha());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public XYZ toXYZ() {
        void s;
        void m;
        double s$iv;
        Oklab this_$iv = this;
        boolean $i$f$calculateConeResponse = false;
        double ll$iv = (double)this_$iv.l + 0.3963377774 * (double)this_$iv.a + 0.2158037573 * (double)this_$iv.b;
        double mm$iv = (double)this_$iv.l - 0.1055613458 * (double)this_$iv.a - 0.0638541728 * (double)this_$iv.b;
        double ss$iv = (double)this_$iv.l - 0.0894841775 * (double)this_$iv.a - 1.291485548 * (double)this_$iv.b;
        double l$iv = ll$iv * ll$iv * ll$iv;
        double m$iv = mm$iv * mm$iv * mm$iv;
        double d = s$iv = ss$iv * ss$iv * ss$iv;
        double d2 = m$iv;
        double l = l$iv;
        boolean bl = false;
        return XYZ.Companion.invoke(1.2270138511 * l - 0.5577999807 * m + 0.281256149 * s, -0.0405801784 * l + 1.1122568696 * m - 0.0716766787 * s, -0.0763812845 * l - 0.4214819784 * m + 1.5861632204 * s, Float.valueOf(this.getAlpha()));
    }

    private final <T> T calculateConeResponse(Function3<? super Double, ? super Double, ? super Double, ? extends T> block) {
        boolean $i$f$calculateConeResponse = false;
        double ll = (double)this.l + 0.3963377774 * (double)this.a + 0.2158037573 * (double)this.b;
        double mm = (double)this.l - 0.1055613458 * (double)this.a - 0.0638541728 * (double)this.b;
        double ss = (double)this.l - 0.0894841775 * (double)this.a - 1.291485548 * (double)this.b;
        double l = ll * ll * ll;
        double m = mm * mm * mm;
        double s = ss * ss * ss;
        return block.invoke(l, m, s);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Oklch toOklch() {
        void h;
        void a$iv;
        float f = this.a;
        float b$iv = this.b;
        boolean $i$f$toPolarModel = false;
        float c$iv = (float)Math.sqrt((double)(a$iv * a$iv + b$iv * b$iv));
        float h$iv = (double)c$iv > -1.0E-7 && (double)c$iv < 1.0E-7 ? Float.NaN : InternalMathKt.radToDeg((float)Math.atan2(b$iv, (double)a$iv));
        float f2 = InternalMathKt.normalizeDeg(h$iv);
        float c = c$iv;
        boolean bl = false;
        return new Oklch(this.l, c, (float)h, this.getAlpha());
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.a, this.b, this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Oklab clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clamp3$iv;
        Color color2 = this;
        float f = this.l;
        float f2 = this.a;
        float f3 = this.b;
        float alpha$iv = this.getAlpha();
        boolean $i$f$clamp3 = false;
        List<ColorComponentInfo> list = $this$clamp3$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clamp3$iv;
                        return (Oklab)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn(alpha$iv, 0.0f, 1.0f);
        float f6 = RangesKt.coerceIn((float)v3$iv, c3$iv.getMin(), c3$iv.getMax());
        float f7 = RangesKt.coerceIn((float)v2$iv, c2$iv.getMin(), c2$iv.getMax());
        float p0 = RangesKt.coerceIn((float)v1$iv, c1$iv.getMin(), c1$iv.getMax());
        boolean bl5 = false;
        color = this.copy(p0, (float)p1, (float)p2, (float)p3);
        return (Oklab)color;
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.a;
    }

    public final float component3() {
        return this.b;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final Oklab copy(float l, float a, float b, float alpha) {
        return new Oklab(l, a, b, alpha);
    }

    public static /* synthetic */ Oklab copy$default(Oklab oklab, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = oklab.l;
        }
        if ((n & 2) != 0) {
            f2 = oklab.a;
        }
        if ((n & 4) != 0) {
            f3 = oklab.b;
        }
        if ((n & 8) != 0) {
            f4 = oklab.alpha;
        }
        return oklab.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "Oklab(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.l);
        result = result * 31 + Float.hashCode(this.a);
        result = result * 31 + Float.hashCode(this.b);
        result = result * 31 + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Oklab)) {
            return false;
        }
        Oklab oklab = (Oklab)other;
        if (Float.compare(this.l, oklab.l) != 0) {
            return false;
        }
        if (Float.compare(this.a, oklab.a) != 0) {
            return false;
        }
        if (Float.compare(this.b, oklab.b) != 0) {
            return false;
        }
        return Float.compare(this.alpha, oklab.alpha) == 0;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/colormath/model/Oklab$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/Oklab;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nOklab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oklab.kt\ncom/github/ajalt/colormath/model/Oklab$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n26#2:79\n15#2,13:80\n1#3:93\n*S KotlinDebug\n*F\n+ 1 Oklab.kt\ncom/github/ajalt/colormath/model/Oklab$Companion\n*L\n32#1:79\n32#1:80,13\n32#1:93\n*E\n"})
    public static final class Companion
    implements ColorSpace<Oklab> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "Oklab";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public Oklab convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toOklab();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Oklab create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 < fArray.length) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (Oklab)((Color)new Oklab(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

