/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.DumbTerminalInterface;
import com.github.ajalt.mordant.internal.JvmAtomicInt;
import com.github.ajalt.mordant.internal.JvmAtomicRef;
import com.github.ajalt.mordant.internal.JvmTerminalCursor;
import com.github.ajalt.mordant.internal.MppAtomicInt;
import com.github.ajalt.mordant.internal.MppAtomicRef;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import com.github.ajalt.mordant.terminal.TerminalInterfaceProvider;
import java.io.Console;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a!\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\rH\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\rH\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a&\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0000\u001a\b\u0010%\u001a\u00020!H\u0000\u001a\b\u0010)\u001a\u00020\rH\u0000\u001a\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0003H\u0000\u001a\u0012\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020\nH\u0000\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010&\u001a\u00020\rX\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\"\u000e\u0010.\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"MppAtomicInt", "Lcom/github/ajalt/mordant/internal/MppAtomicInt;", "initial", "", "MppAtomicRef", "Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "T", "value", "(Ljava/lang/Object;)Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "getEnv", "", "key", "runningInIdeaJavaAgent", "", "codepointSequence", "Lkotlin/sequences/Sequence;", "string", "printStderr", "", "message", "newline", "readLineOrNullMpp", "hideInput", "makePrintingTerminalCursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "printRequestLock", "", "sendInterceptedPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "getStandardTerminalInterface", "CR_IMPLIES_LF", "getCR_IMPLIES_LF", "()Z", "testsHaveFileSystem", "exitProcessMpp", "status", "readFileIfExists", "filename", "DUMB_RAW_MODE_ERROR", "mordant"})
@SourceDebugExtension(value={"SMAP\nMppInternal.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppInternal.jvm.kt\ncom/github/ajalt/mordant/internal/MppInternal_jvmKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1755#2,3:181\n1797#2,3:184\n1202#2,2:187\n1230#2,4:189\n*S KotlinDebug\n*F\n+ 1 MppInternal.jvm.kt\ncom/github/ajalt/mordant/internal/MppInternal_jvmKt\n*L\n55#1:181,3\n120#1:184,3\n127#1:187,2\n127#1:189,4\n*E\n"})
public final class MppInternal_jvmKt {
    @NotNull
    private static final Object printRequestLock = new Object();
    private static final boolean CR_IMPLIES_LF;
    @NotNull
    private static final String DUMB_RAW_MODE_ERROR = "Cannot find terminal interface that supports raw mode.\n\nYou need at least one of the `:mordant-jvm-*` modules on your classpath.\nThe `:mordant` module includes all of them as transitive dependencies.\nIf you're using `:mordant-core` instead, you need to add one or more manually.\nIf you're using only `:mordant-jvm-ffm`, make sure you're running with JVM 22+, and are passing\n`--enable-native-access=ALL-UNNAMED` as a JVM argument.\n";

    @NotNull
    public static final MppAtomicInt MppAtomicInt(int initial) {
        return new JvmAtomicInt(initial);
    }

    @NotNull
    public static final <T> MppAtomicRef<T> MppAtomicRef(T value) {
        return new JvmAtomicRef<T>(value);
    }

    @Nullable
    public static final String getEnv(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getenv(key);
    }

    public static final boolean runningInIdeaJavaAgent() {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = bean.getInputArguments();
                Intrinsics.checkNotNull(jvmArgs);
                Iterable $this$any$iv = jvmArgs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull(it);
                        if (!(StringsKt.startsWith$default(it, "-javaagent", false, 2, null) && StringsKt.contains$default((CharSequence)it, "idea_rt.jar", false, 2, null))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Sequence<Integer> codepointSequence(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt, "iterator(...)");
        return SequencesKt.asSequence(ofInt);
    }

    public static final void printStderr(@NotNull String message, boolean newline) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (newline) {
            System.err.println(message);
        } else {
            System.err.print(message);
        }
    }

    @Nullable
    public static final String readLineOrNullMpp(boolean hideInput) {
        Console console;
        if (hideInput && (console = System.console()) != null) {
            char[] cArray = console.readPassword();
            Intrinsics.checkNotNullExpressionValue(cArray, "readPassword(...)");
            return StringsKt.concatToString(cArray);
        }
        return ConsoleKt.readlnOrNull();
    }

    @NotNull
    public static final TerminalCursor makePrintingTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        return new JvmTerminalCursor(terminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void sendInterceptedPrintRequest(@NotNull PrintRequest request, @NotNull TerminalInterface terminalInterface, @NotNull List<? extends TerminalInterceptor> interceptors) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(terminalInterface, "terminalInterface");
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        Object object = printRequestLock;
        synchronized (object) {
            void $this$fold$iv;
            boolean bl = false;
            Iterable iterable = interceptors;
            TerminalInterface terminalInterface2 = terminalInterface;
            boolean $i$f$fold = false;
            PrintRequest accumulator$iv = request;
            for (Object element$iv : $this$fold$iv) {
                void it;
                TerminalInterceptor terminalInterceptor = (TerminalInterceptor)element$iv;
                PrintRequest acc = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = it.intercept(acc);
            }
            terminalInterface2.completePrintRequest(accumulator$iv);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TerminalInterface getStandardTerminalInterface() {
        void $this$associateByTo$iv$iv;
        ServiceLoader<TerminalInterfaceProvider> serviceLoader = ServiceLoader.load(TerminalInterfaceProvider.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
        Iterable $this$associateBy$iv = serviceLoader;
        boolean $i$f$associateBy232 = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TerminalInterfaceProvider terminalInterfaceProvider = (TerminalInterfaceProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName(), element$iv$iv);
        }
        Map providers = destination$iv$iv;
        String[] $i$f$associateBy232 = new String[]{"com.github.ajalt.mordant.terminal.terminalinterface.ffm.TerminalInterfaceProviderFfm", "com.github.ajalt.mordant.terminal.terminalinterface.nativeimage.TerminalInterfaceProviderNativeImage", "com.github.ajalt.mordant.terminal.terminalinterface.jna.TerminalInterfaceProviderJna"};
        List<String> builtins = CollectionsKt.listOf($i$f$associateBy232);
        List<String> allProviders = CollectionsKt.plus((Collection)builtins, (Iterable)SetsKt.minus(providers.keySet(), (Iterable)builtins));
        for (String provider : allProviders) {
            Object object = (TerminalInterfaceProvider)providers.get(provider);
            if (object == null || (object = object.load()) == null) continue;
            return object;
        }
        return DumbTerminalInterface.INSTANCE;
    }

    public static final boolean getCR_IMPLIES_LF() {
        return CR_IMPLIES_LF;
    }

    public static final boolean testsHaveFileSystem() {
        return true;
    }

    public static final void exitProcessMpp(int status) {
        System.exit(status);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @Nullable
    public static final String readFileIfExists(@NotNull String filename) {
        String string;
        Intrinsics.checkNotNullParameter(filename, "filename");
        try {
            Path path2 = Path.of(filename, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "of(...)");
            string = PathsKt.readText$default(path2, null, 1, null);
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }
}

