/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface.jna;

import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfaceJvmPosix;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfacePosix;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.PosixLibC;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/TerminalInterfaceJnaLinux;", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceJvmPosix;", "<init>", "()V", "TIOCGWINSZ", "", "TCSADRAIN", "termiosConstants", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$TermiosConstants;", "getTermiosConstants", "()Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$TermiosConstants;", "libC", "Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/PosixLibC;", "isatty", "", "fd", "getTerminalSize", "Lcom/github/ajalt/mordant/rendering/Size;", "getStdinTermios", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$Termios;", "setStdinTermios", "", "termios", "mordant-jvm-jna"})
public final class TerminalInterfaceJnaLinux
extends TerminalInterfaceJvmPosix {
    private final int TIOCGWINSZ;
    private final int TCSADRAIN;
    @NotNull
    private final PosixLibC libC;

    public TerminalInterfaceJnaLinux() {
        this.TIOCGWINSZ = 21523;
        this.TCSADRAIN = 1;
        PosixLibC posixLibC = Native.load(Platform.C_LIBRARY_NAME, PosixLibC.class);
        Intrinsics.checkNotNullExpressionValue(posixLibC, "load(...)");
        this.libC = posixLibC;
    }

    @Override
    @NotNull
    public TerminalInterfacePosix.TermiosConstants getTermiosConstants() {
        return TerminalInterfacePosix.Companion.getLinuxTermiosConstants();
    }

    @Override
    protected boolean isatty(int fd) {
        return this.libC.isatty(fd) != 0;
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        PosixLibC.winsize size = new PosixLibC.winsize();
        return this.libC.ioctl(0, this.TIOCGWINSZ, size) < 0 ? null : new Size(size.ws_col, size.ws_row);
    }

    @Override
    @NotNull
    public TerminalInterfacePosix.Termios getStdinTermios() {
        PosixLibC.termios termios2 = new PosixLibC.termios();
        this.libC.tcgetattr(0, termios2);
        int n = UInt.constructor-impl(termios2.c_iflag);
        int n2 = UInt.constructor-impl(termios2.c_oflag);
        int n3 = UInt.constructor-impl(termios2.c_cflag);
        int n4 = UInt.constructor-impl(termios2.c_lflag);
        byte[] byArray = Arrays.copyOf(termios2.c_cc, termios2.c_cc.length);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        return new TerminalInterfacePosix.Termios(n, n2, n3, n4, byArray, null);
    }

    @Override
    public void setStdinTermios(@NotNull TerminalInterfacePosix.Termios termios2) {
        Intrinsics.checkNotNullParameter(termios2, "termios");
        PosixLibC.termios nativeTermios = new PosixLibC.termios();
        this.libC.tcgetattr(0, nativeTermios);
        nativeTermios.c_iflag = termios2.getIflag-pVg5ArA();
        nativeTermios.c_oflag = termios2.getOflag-pVg5ArA();
        nativeTermios.c_cflag = termios2.getCflag-pVg5ArA();
        nativeTermios.c_lflag = termios2.getLflag-pVg5ArA();
        ArraysKt.copyInto$default(termios2.getCc(), nativeTermios.c_cc, 0, 0, 0, 14, null);
        this.libC.tcsetattr(0, this.TCSADRAIN, nativeTermios);
    }
}

