/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.zim2xapi;

import com.ustadmobile.zim2xapi.AddxAPIStatementUseCase;
import com.ustadmobile.zim2xapi.ProcessBuilderUseCase;
import com.ustadmobile.zim2xapi.models.ActivityDefinition;
import com.ustadmobile.zim2xapi.models.XapiObject;
import com.ustadmobile.zim2xapi.models.opdsfeed.OpdsFeed;
import com.ustadmobile.zim2xapi.models.opdsfeed.OpdsFeedMetadata;
import com.ustadmobile.zim2xapi.models.opdsfeed.OpdsWebMetadata;
import com.ustadmobile.zim2xapi.models.opdsfeed.OpdsWebPublication;
import com.ustadmobile.zim2xapi.models.opdsfeed.OpdsWebPublicationLink;
import com.ustadmobile.zim2xapi.models.opdsfeed.ReadiumLink;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/zim2xapi/CreateXapiFileUseCase;", "", "zimDumpProcess", "Lcom/ustadmobile/zim2xapi/ProcessBuilderUseCase;", "addXApi", "Lcom/ustadmobile/zim2xapi/AddxAPIStatementUseCase;", "json", "Lkotlinx/serialization/json/Json;", "<init>", "(Lcom/ustadmobile/zim2xapi/ProcessBuilderUseCase;Lcom/ustadmobile/zim2xapi/AddxAPIStatementUseCase;Lkotlinx/serialization/json/Json;)V", "invoke", "Ljava/io/File;", "zimFolder", "outputFolder", "fileName", "", "zimFile", "passingGrade", "", "generateResourceLinks", "", "Lcom/ustadmobile/zim2xapi/models/opdsfeed/OpdsWebPublicationLink;", "topic", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nCreateXapiFileUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateXapiFileUseCase.kt\ncom/ustadmobile/zim2xapi/CreateXapiFileUseCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,186:1\n1#2:187\n1317#3,2:188\n*S KotlinDebug\n*F\n+ 1 CreateXapiFileUseCase.kt\ncom/ustadmobile/zim2xapi/CreateXapiFileUseCase\n*L\n133#1:188,2\n*E\n"})
public final class CreateXapiFileUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessBuilderUseCase zimDumpProcess;
    @NotNull
    private final AddxAPIStatementUseCase addXApi;
    @NotNull
    private final Json json;
    @NotNull
    public static final String TINCAN_XML = "tincan.xml";
    @NotNull
    public static final String INDEX_HTML = "index.html";
    @NotNull
    public static final String XAPI_OBJECT_JSON = "xapiobject.json";
    @NotNull
    public static final String OPDS_JSON = "opds.json";
    @NotNull
    public static final String PUBLICATION_JSON = "publication.json";
    @NotNull
    public static final String ASSESTS = "assets";
    @NotNull
    public static final String SELF_LINK = "self";
    @NotNull
    public static final String ACQUISITION_LINK = "http://opds-spec.org/acquisition/open-access";
    @NotNull
    public static final String ACTIVITY_TYPE = "http://adlnet.gov/expapi/activities/module";

    public CreateXapiFileUseCase(@NotNull ProcessBuilderUseCase zimDumpProcess, @NotNull AddxAPIStatementUseCase addXApi, @NotNull Json json) {
        Intrinsics.checkNotNullParameter(zimDumpProcess, "zimDumpProcess");
        Intrinsics.checkNotNullParameter(addXApi, "addXApi");
        Intrinsics.checkNotNullParameter(json, "json");
        this.zimDumpProcess = zimDumpProcess;
        this.addXApi = addXApi;
        this.json = json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File invoke(@NotNull File zimFolder, @NotNull File outputFolder, @NotNull String fileName, @NotNull File zimFile, int passingGrade) {
        String uuidLine;
        Object object;
        Object v0;
        Object it;
        Object object2;
        String[] stringArray;
        String lang;
        String description;
        OpdsWebPublicationLink[] title;
        block18: {
            Intrinsics.checkNotNullParameter(zimFolder, "zimFolder");
            Intrinsics.checkNotNullParameter(outputFolder, "outputFolder");
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            Intrinsics.checkNotNullParameter(zimFile, "zimFile");
            File indexHtml = new File(zimFolder, INDEX_HTML);
            Document doc = Jsoup.parse(indexHtml, "UTF-8");
            title = doc.title();
            description = doc.select("meta[name=description]").attr("content");
            lang = doc.select("html").attr("lang");
            String output = ProcessBuilderUseCase.invoke$default(this.zimDumpProcess, "info " + zimFile.getAbsolutePath(), false, 2, null);
            Iterable iterable = StringsKt.lines(output);
            stringArray = iterable.iterator();
            while (stringArray.hasNext()) {
                object2 = stringArray.next();
                it = (String)object2;
                boolean bl = false;
                if (!StringsKt.startsWith$default(((Object)StringsKt.trim((CharSequence)it)).toString(), "uuid:", false, 2, null)) continue;
                v0 = object2;
                break block18;
            }
            v0 = null;
        }
        if ((object = (uuidLine = (String)v0)) == null || (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{":"}, false, 0, 6, null)) == null || (object = (String)object.get(1)) == null || (object = ((Object)StringsKt.trim((CharSequence)object)).toString()) == null) {
            throw new Exception("uuid not provided by zimdump");
        }
        Object uuid = object;
        String activityId = "https://ustadmobile.com/ns/zim2xapi/" + (String)uuid;
        File tinCanFile = new File(zimFolder, TINCAN_XML);
        object2 = new PrintWriter(tinCanFile);
        it = null;
        try {
            Object writer = (PrintWriter)object2;
            boolean bl = false;
            ((PrintWriter)writer).println(StringsKt.trimIndent("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n           <tincan xmlns=\"http://projecttincan.com/tincan.xsd\">\n                <activities>\n                    <activity id=\"" + activityId + "\" type=\"http://adlnet.gov/expapi/activities/module\">\n                        <name>" + (String)title + "</name>\n                        <description lang=\"" + lang + "\">" + description + "</description>\n                        <launch lang=\"" + lang + "\">index.html</launch>\n                    </activity>\n                </activities>\n            </tincan>\n        "));
            writer = Unit.INSTANCE;
        }
        catch (Throwable writer) {
            it = writer;
            throw writer;
        }
        finally {
            CloseableKt.closeFinally(object2, (Throwable)it);
        }
        File xapiObjectJsonFile = new File(zimFolder, XAPI_OBJECT_JSON);
        FilesKt.writeText$default(xapiObjectJsonFile, this.json.encodeToString((SerializationStrategy)XapiObject.Companion.serializer(), new XapiObject(activityId, null, new ActivityDefinition(MapsKt.mapOf(TuplesKt.to(lang, title)), MapsKt.mapOf(TuplesKt.to(lang, description)), ACTIVITY_TYPE), 2, null)), null, 2, null);
        String path2 = zimFolder.getAbsolutePath().toString();
        String[] bl = new String[]{"/"};
        String topic = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)path2, bl, false, 0, 6, null));
        List<OpdsWebPublicationLink> assetResources = this.generateResourceLinks(zimFolder, topic);
        File opdsWebPublication = new File(zimFolder, PUBLICATION_JSON);
        SerializationStrategy serializationStrategy = OpdsWebPublication.Companion.serializer();
        Intrinsics.checkNotNull(title);
        OpdsWebPublicationLink[] opdsWebPublicationLinkArray = title;
        OpdsWebMetadata opdsWebMetadata = new OpdsWebMetadata(null, (String)opdsWebPublicationLinkArray, null, topic, null, null, description, 53, null);
        opdsWebPublicationLinkArray = new OpdsWebPublicationLink[]{new OpdsWebPublicationLink(SELF_LINK, topic + "/index.html"), new OpdsWebPublicationLink(ACQUISITION_LINK, topic + "/index.html")};
        FilesKt.writeText$default(opdsWebPublication, this.json.encodeToString(serializationStrategy, new OpdsWebPublication("", opdsWebMetadata, CollectionsKt.listOf(opdsWebPublicationLinkArray), null, assetResources, 8, null)), null, 2, null);
        File opdsFeedJsonFile = new File(zimFolder, OPDS_JSON);
        FilesKt.writeText$default(opdsFeedJsonFile, this.json.encodeToString((SerializationStrategy)OpdsFeed.Companion.serializer(), new OpdsFeed(new OpdsFeedMetadata((String)title, description), CollectionsKt.listOf(new ReadiumLink(topic + "/opds.json", (String)title)), null, CollectionsKt.listOf(new ReadiumLink(topic + "/publication.json", (String)title)), 4, null)), null, 2, null);
        this.addXApi.invoke(zimFolder, passingGrade);
        File xapiFile = new File(outputFolder, fileName + ".zip");
        Closeable closeable = new ZipOutputStream(new FileOutputStream(xapiFile));
        Throwable throwable = null;
        try {
            ZipOutputStream zipOut = (ZipOutputStream)closeable;
            boolean bl2 = false;
            Sequence $this$forEach$iv = FilesKt.walk$default(zimFolder, null, 1, null);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                File file2 = (File)element$iv;
                boolean bl3 = false;
                if (!file2.isFile()) continue;
                String relativePath = ((Object)zimFolder.toPath().relativize(file2.toPath())).toString();
                zipOut.putNextEntry(new ZipEntry(relativePath));
                Closeable closeable2 = new FileInputStream(file2);
                Throwable throwable2 = null;
                try {
                    FileInputStream input = (FileInputStream)closeable2;
                    boolean bl4 = false;
                    long l = ByteStreamsKt.copyTo$default(input, zipOut, 0, 2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                zipOut.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return xapiFile;
    }

    private final List<OpdsWebPublicationLink> generateResourceLinks(File zimFolder, String topic) {
        File assetsFolder = new File(zimFolder, ASSESTS);
        if (!assetsFolder.exists() || !assetsFolder.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(FilesKt.walk$default(assetsFolder, null, 1, null), CreateXapiFileUseCase::generateResourceLinks$lambda$5), arg_0 -> CreateXapiFileUseCase.generateResourceLinks$lambda$6(zimFolder, topic, arg_0)));
    }

    private static final boolean generateResourceLinks$lambda$5(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isFile();
    }

    private static final OpdsWebPublicationLink generateResourceLinks$lambda$6(File $zimFolder, String $topic, File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        String relativePath = ((Object)$zimFolder.toPath().relativize(file2.toPath())).toString();
        return new OpdsWebPublicationLink(null, $topic + "/" + relativePath, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/zim2xapi/CreateXapiFileUseCase$Companion;", "", "<init>", "()V", "TINCAN_XML", "", "INDEX_HTML", "XAPI_OBJECT_JSON", "OPDS_JSON", "PUBLICATION_JSON", "ASSESTS", "SELF_LINK", "ACQUISITION_LINK", "ACTIVITY_TYPE", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

