/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.zim2xapi;

import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.PrintMessage;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionDelegate;
import com.github.ajalt.clikt.parameters.options.OptionTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import com.ustadmobile.zim2xapi.AddxAPIStatementUseCase;
import com.ustadmobile.zim2xapi.Client;
import com.ustadmobile.zim2xapi.CreateXapiFileUseCase;
import com.ustadmobile.zim2xapi.DownloadKolibriZimUseCase;
import com.ustadmobile.zim2xapi.ExtractZimUseCase;
import com.ustadmobile.zim2xapi.FindKolibri2ZimUseCase;
import com.ustadmobile.zim2xapi.FixExtractZimExceptionsUseCase;
import com.ustadmobile.zim2xapi.KhanChannels;
import com.ustadmobile.zim2xapi.ProcessBuilderUseCase;
import com.ustadmobile.zim2xapi.utils.SysPathUtil;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010-\u001a\u00020.H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0017\u0010\u0014R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u001a\u0010\u0014R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001d\u0010\u0014R\u001b\u0010\u001f\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b \u0010\u0014R\u001d\u0010\"\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\r\u001a\u0004\b#\u0010\u000bR\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\r\u001a\u0004\b'\u0010(R\u001b\u0010*\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\r\u001a\u0004\b+\u0010\u0007\u00a8\u0006/"}, d2={"Lcom/ustadmobile/zim2xapi/DownloadTopic;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "printHelpOnEmptyArgs", "", "getPrintHelpOnEmptyArgs", "()Z", "channelId", "", "getChannelId", "()Ljava/lang/String;", "channelId$delegate", "Lkotlin/properties/ReadOnlyProperty;", "topicId", "getTopicId", "topicId$delegate", "zimDumpPath", "Ljava/io/File;", "getZimDumpPath", "()Ljava/io/File;", "zimDumpPath$delegate", "zimFile", "getZimFile", "zimFile$delegate", "kolibiri2zimPath", "getKolibiri2zimPath", "kolibiri2zimPath$delegate", "dockerPath", "getDockerPath", "dockerPath$delegate", "outputDir", "getOutputDir", "outputDir$delegate", "fileName", "getFileName", "fileName$delegate", "passingGrade", "", "getPassingGrade", "()I", "passingGrade$delegate", "keepTempFiles", "getKeepTempFiles", "keepTempFiles$delegate", "run", "", "app"})
@SourceDebugExtension(value={"SMAP\nApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 App.kt\ncom/ustadmobile/zim2xapi/DownloadTopic\n+ 2 Validate.kt\ncom/github/ajalt/clikt/parameters/options/ValidateKt\n*L\n1#1,221:1\n25#2:222\n*S KotlinDebug\n*F\n+ 1 App.kt\ncom/ustadmobile/zim2xapi/DownloadTopic\n*L\n107#1:222\n*E\n"})
public final class DownloadTopic
extends CliktCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final boolean printHelpOnEmptyArgs;
    @NotNull
    private final ReadOnlyProperty channelId$delegate;
    @NotNull
    private final ReadOnlyProperty topicId$delegate;
    @NotNull
    private final ReadOnlyProperty zimDumpPath$delegate;
    @NotNull
    private final ReadOnlyProperty zimFile$delegate;
    @NotNull
    private final ReadOnlyProperty kolibiri2zimPath$delegate;
    @NotNull
    private final ReadOnlyProperty dockerPath$delegate;
    @NotNull
    private final ReadOnlyProperty outputDir$delegate;
    @NotNull
    private final ReadOnlyProperty fileName$delegate;
    @NotNull
    private final ReadOnlyProperty passingGrade$delegate;
    @NotNull
    private final ReadOnlyProperty keepTempFiles$delegate;

    public DownloadTopic() {
        super("convert");
        this.printHelpOnEmptyArgs = true;
        String[] stringArray = new String[]{"-channel-id"};
        this.channelId$delegate = OptionWithValuesKt.option$default(this, stringArray, "The channel ID", null, false, null, null, null, null, false, 508, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[0]);
        stringArray = new String[]{"-topic-id"};
        this.topicId$delegate = OptionWithValuesKt.option$default(this, stringArray, "The topic ID to download", null, false, null, null, null, null, false, 508, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[1]);
        stringArray = new String[]{"-zim-dump-path"};
        this.zimDumpPath$delegate = FileKt.file$default(OptionWithValuesKt.option$default(this, stringArray, "The path to the zimdump binary - can be downloaded from https://download.openzim.org/release/zim-tools/", null, false, null, null, null, null, false, 508, null), true, false, false, false, false, false, 58, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[2]);
        stringArray = new String[]{"-zim-file"};
        this.zimFile$delegate = FileKt.file$default(OptionWithValuesKt.option$default(this, stringArray, "Path to an existing ZIM file", null, false, null, null, null, null, false, 508, null), true, false, false, false, true, false, 42, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[3]);
        stringArray = new String[]{"-kolibri2zim-path"};
        this.kolibiri2zimPath$delegate = FileKt.file$default(OptionWithValuesKt.option$default(this, stringArray, "The path to the kolibri2zim binary - can be downloaded from https://github.com/openzim/kolibri", null, false, null, null, null, null, false, 508, null), true, false, false, false, false, false, 58, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[4]);
        stringArray = new String[]{"-docker"};
        this.dockerPath$delegate = FileKt.file$default(OptionWithValuesKt.option$default(this, stringArray, "The path to docker - can be downloaded from https://docs.docker.com/get-docker/", null, false, null, null, null, null, false, 508, null), true, false, false, false, false, false, 58, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[5]);
        stringArray = new String[]{"-dir", "-output"};
        OptionWithValues optionWithValues = FileKt.file$default(OptionWithValuesKt.option$default(this, stringArray, "The output directory for the xApi file", null, false, null, null, null, null, false, 508, null), false, false, false, true, false, false, 53, null);
        File file2 = new File(".").getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue(file2, "getCanonicalFile(...)");
        this.outputDir$delegate = OptionWithValuesKt.default$default(optionWithValues, file2, null, 2, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[6]);
        stringArray = new String[]{"-name"};
        this.fileName$delegate = OptionWithValuesKt.option$default(this, stringArray, "The name of the xApi file", null, false, null, null, null, null, false, 508, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[7]);
        stringArray = new String[]{"-grade"};
        OptionWithValues $this$validate$iv = OptionWithValuesKt.default$default(IntKt.int$default(OptionWithValuesKt.option$default(this, stringArray, "The passing grade as a percentage (0-100). Default is 50%", null, false, null, null, null, null, false, 508, null), false, 1, null), 50, null, 2, null);
        boolean $i$f$validate = false;
        this.passingGrade$delegate = ((OptionDelegate)OptionWithValues.DefaultImpls.copy$default($this$validate$iv, $this$validate$iv.getTransformValue(), $this$validate$iv.getTransformEach(), $this$validate$iv.getTransformAll(), new Function2<OptionTransformContext, Integer, Unit>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final void invoke(OptionTransformContext $this$copy, Object it) {
                Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                if (it != null) {
                    void it2;
                    int n = ((Number)it).intValue();
                    OptionTransformContext $this$passingGrade_delegate_u24lambda_u241 = $this$copy;
                    boolean bl = false;
                    OptionTransformContext optionTransformContext = $this$passingGrade_delegate_u24lambda_u241;
                    boolean value$iv = false <= it2 ? it2 < 101 : false;
                    boolean $i$f$require = false;
                    if (!value$iv) {
                        void this_$iv;
                        void var9_9 = this_$iv;
                        boolean bl2 = false;
                        var9_9.fail("Passing grade must be between 0 and 100.");
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }, null, null, null, null, false, null, null, null, null, null, null, false, false, false, 262128, null)).provideDelegate(this, (KProperty<?>)$$delegatedProperties[8]);
        stringArray = new String[]{"-k", "-keep-temp"};
        this.keepTempFiles$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.option$default(this, stringArray, "Keep temporary files", null, false, null, null, null, null, false, 508, null), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[9]);
    }

    @Override
    public boolean getPrintHelpOnEmptyArgs() {
        return this.printHelpOnEmptyArgs;
    }

    @Nullable
    public final String getChannelId() {
        return (String)this.channelId$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Nullable
    public final String getTopicId() {
        return (String)this.topicId$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Nullable
    public final File getZimDumpPath() {
        return (File)this.zimDumpPath$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Nullable
    public final File getZimFile() {
        return (File)this.zimFile$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Nullable
    public final File getKolibiri2zimPath() {
        return (File)this.kolibiri2zimPath$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Nullable
    public final File getDockerPath() {
        return (File)this.dockerPath$delegate.getValue(this, $$delegatedProperties[5]);
    }

    @NotNull
    public final File getOutputDir() {
        return (File)this.outputDir$delegate.getValue(this, $$delegatedProperties[6]);
    }

    @Nullable
    public final String getFileName() {
        return (String)this.fileName$delegate.getValue(this, $$delegatedProperties[7]);
    }

    public final int getPassingGrade() {
        return ((Number)this.passingGrade$delegate.getValue(this, $$delegatedProperties[8])).intValue();
    }

    public final boolean getKeepTempFiles() {
        return (Boolean)this.keepTempFiles$delegate.getValue(this, $$delegatedProperties[9]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String channelId = this.getChannelId();
        String topicId = this.getTopicId();
        File zimFile = this.getZimFile();
        Object object = zimFile;
        if (object == null) {
            if (channelId != null && topicId != null) {
                Object kolibri2zimPath;
                boolean isKhan = KhanChannels.INSTANCE.getChannels().contains(channelId);
                if (isKhan) {
                    String string;
                    URL uRL = this.getClass().getClassLoader().getResource("khan-license-notice.txt");
                    if (uRL != null) {
                        URL uRL2 = uRL;
                        Charset charset = Charsets.UTF_8;
                        byte[] byArray = TextStreamsKt.readBytes(uRL2);
                        string = new String(byArray, charset);
                    } else {
                        string = "";
                    }
                    String licenseText = string;
                    BaseCliktCommand.echo$default(this, licenseText, false, false, 6, null);
                }
                try {
                    kolibri2zimPath = new FindKolibri2ZimUseCase().invoke(this.getKolibiri2zimPath(), this.getDockerPath(), this.getOutputDir());
                    ProcessBuilderUseCase kolbir2zimProcess = new ProcessBuilderUseCase((List<String>)kolibri2zimPath);
                    DownloadKolibriZimUseCase downloadKolibriZimUseCase = new DownloadKolibriZimUseCase(kolbir2zimProcess);
                    File file2 = this.getOutputDir();
                    String string = this.getFileName();
                    if (string == null) {
                        string = topicId;
                    }
                    kolibri2zimPath = downloadKolibriZimUseCase.invoke(channelId, topicId, file2, string);
                }
                catch (Exception e) {
                    BaseCliktCommand baseCliktCommand = this;
                    e.printStackTrace();
                    BaseCliktCommand.echo$default(baseCliktCommand, Unit.INSTANCE, false, true, 2, null);
                    throw new PrintMessage("An error occurred: " + e.getMessage(), 1, true);
                }
                object = kolibri2zimPath;
            } else {
                throw new PrintMessage("You must provide either a ZIM file or a Kolibri channel ID and topic.", 1, true);
            }
        }
        File createdZimFile = object;
        String string = this.getFileName();
        if (string == null) {
            string = FilesKt.getNameWithoutExtension(createdZimFile);
        }
        String fileName = string;
        File extractedZimFolder = new File(this.getOutputDir(), fileName);
        extractedZimFolder.mkdirs();
        try {
            File file3 = SysPathUtil.findCommandInPath$default(SysPathUtil.INSTANCE, "zimdump", this.getZimDumpPath(), null, null, null, null, 60, null);
            if (file3 == null) {
                throw new PrintMessage("zimdump not found. Please install it from https://download.openzim.org/release/zim-tools/", 1, true);
            }
            File zimDump = file3;
            ProcessBuilderUseCase zimDumpProcess = new ProcessBuilderUseCase(CollectionsKt.listOf(zimDump.getAbsolutePath()));
            new ExtractZimUseCase(zimDumpProcess).invoke(createdZimFile, extractedZimFolder);
            new FixExtractZimExceptionsUseCase(zimDumpProcess).invoke(createdZimFile, extractedZimFolder);
            File xapiFile = new CreateXapiFileUseCase(zimDumpProcess, new AddxAPIStatementUseCase(), Client.INSTANCE.getJson()).invoke(extractedZimFolder, this.getOutputDir(), fileName, createdZimFile, this.getPassingGrade());
            BaseCliktCommand.echo$default(this, "Process completed. Output filename: " + xapiFile.getName(), false, false, 6, null);
            BaseCliktCommand.echo$default(this, "File Location: " + xapiFile.getAbsolutePath(), false, false, 6, null);
        }
        catch (Exception e) {
            BaseCliktCommand baseCliktCommand = this;
            e.printStackTrace();
            BaseCliktCommand.echo$default(baseCliktCommand, Unit.INSTANCE, false, true, 2, null);
            throw new PrintMessage("An error occurred: " + e.getMessage(), 1, true);
        }
        finally {
            if (!this.getKeepTempFiles()) {
                FilesKt.deleteRecursively(extractedZimFolder);
            }
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "channelId", "getChannelId()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "topicId", "getTopicId()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "zimDumpPath", "getZimDumpPath()Ljava/io/File;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "zimFile", "getZimFile()Ljava/io/File;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "kolibiri2zimPath", "getKolibiri2zimPath()Ljava/io/File;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "dockerPath", "getDockerPath()Ljava/io/File;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "outputDir", "getOutputDir()Ljava/io/File;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "fileName", "getFileName()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "passingGrade", "getPassingGrade()I", 0)), Reflection.property1(new PropertyReference1Impl(DownloadTopic.class, "keepTempFiles", "getKeepTempFiles()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

