/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.SchoolTypeConverters;
import world.respect.datalayer.db.school.daos.PersonRoleEntityDao;
import world.respect.datalayer.db.school.entities.PersonRoleEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonRoleEntityDao_Impl;", "Lworld/respect/datalayer/db/school/daos/PersonRoleEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfPersonRoleEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/school/entities/PersonRoleEntity;", "__schoolTypeConverters", "Lworld/respect/datalayer/db/school/SchoolTypeConverters;", "upsertList", "", "personRoleEntities", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteByPersonGuidHash", "personGuidHash", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-datalayer-db"})
public final class PersonRoleEntityDao_Impl
implements PersonRoleEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<PersonRoleEntity> __insertAdapterOfPersonRoleEntity;
    @NotNull
    private final SchoolTypeConverters __schoolTypeConverters;

    public PersonRoleEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__schoolTypeConverters = new SchoolTypeConverters();
        this.__db = __db;
        this.__insertAdapterOfPersonRoleEntity = (EntityInsertAdapter)new EntityInsertAdapter<PersonRoleEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PersonRoleEntity` (`prUid`,`prPersonGuidHash`,`prIsPrimaryRole`,`prRoleEnum`,`prBeginDate`,`prEndDate`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, PersonRoleEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, (long)entity.getPrUid());
                statement.bindLong(2, entity.getPrPersonGuidHash());
                int _tmp = entity.getPrIsPrimaryRole() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                int _tmp_1 = __schoolTypeConverters.fromPersonRoleType(entity.getPrRoleEnum());
                statement.bindLong(4, (long)_tmp_1);
                LocalDate _tmpPrBeginDate = entity.getPrBeginDate();
                Long _tmp_2 = __schoolTypeConverters.fromLocalDate(_tmpPrBeginDate);
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindLong(5, _tmp_2.longValue());
                }
                LocalDate _tmpPrEndDate = entity.getPrEndDate();
                Long _tmp_3 = __schoolTypeConverters.fromLocalDate(_tmpPrEndDate);
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindLong(6, _tmp_3.longValue());
                }
            }
        };
    }

    @Override
    @Nullable
    public Object upsertList(@NotNull List<PersonRoleEntity> personRoleEntities, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PersonRoleEntityDao_Impl.upsertList$lambda$0(this, personRoleEntities, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteByPersonGuidHash(long personGuidHash, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        DELETE FROM PersonRoleEntity\n         WHERE prPersonGuidHash = ?\n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PersonRoleEntityDao_Impl.deleteByPersonGuidHash$lambda$0(_sql, personGuidHash, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit upsertList$lambda$0(PersonRoleEntityDao_Impl this$0, List $personRoleEntities, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfPersonRoleEntity.insert(_connection, (Iterable)$personRoleEntities);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit deleteByPersonGuidHash$lambda$0(String $_sql, long $personGuidHash, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $personGuidHash);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonRoleEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

