/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\u001a-\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u001a$\u0010\n\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a8\u0006\f"}, d2={"getSelectionHandleCoordinates", "Landroidx/compose/ui/geometry/Offset;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "offset", "", "isStart", "", "areHandlesCrossed", "(Landroidx/compose/ui/text/TextLayoutResult;IZZ)J", "getHorizontalPosition", "", "foundation"})
@SourceDebugExtension(value={"SMAP\nTextSelectionDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextSelectionDelegate.kt\nandroidx/compose/foundation/text/selection/TextSelectionDelegateKt\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,69:1\n54#2:70\n59#2:72\n85#3:71\n90#3:73\n53#3,3:75\n30#4:74\n*S KotlinDebug\n*F\n+ 1 TextSelectionDelegate.kt\nandroidx/compose/foundation/text/selection/TextSelectionDelegateKt\n*L\n47#1:70\n49#1:72\n47#1:71\n49#1:73\n50#1:75,3\n50#1:74\n*E\n"})
public final class TextSelectionDelegateKt {
    public static final long getSelectionHandleCoordinates(@NotNull TextLayoutResult textLayoutResult, int offset, boolean isStart, boolean areHandlesCrossed) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        int line = textLayoutResult.getLineForOffset(offset);
        if (line >= textLayoutResult.getLineCount()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        long arg0$iv = textLayoutResult.getSize-YbymL2g();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        float x = RangesKt.coerceIn((float)TextSelectionDelegateKt.getHorizontalPosition(textLayoutResult, offset, isStart, areHandlesCrossed), (float)0.0f, (float)((int)(value$iv$iv >> 32)));
        long arg0$iv2 = textLayoutResult.getSize-YbymL2g();
        boolean bl2 = false;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackInt2 = false;
        float y = RangesKt.coerceIn((float)textLayoutResult.getLineBottom(line), (float)0.0f, (float)((int)(value$iv$iv2 & 0xFFFFFFFFL)));
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits(x);
        long v2$iv$iv = Float.floatToRawIntBits(y);
        return Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
    }

    public static final float getHorizontalPosition(@NotNull TextLayoutResult $this$getHorizontalPosition, int offset, boolean isStart, boolean areHandlesCrossed) {
        Intrinsics.checkNotNullParameter((Object)$this$getHorizontalPosition, (String)"<this>");
        int offsetToCheck = isStart && !areHandlesCrossed || !isStart && areHandlesCrossed ? offset : Math.max(offset - 1, 0);
        ResolvedTextDirection bidiRunDirection = $this$getHorizontalPosition.getBidiRunDirection(offsetToCheck);
        ResolvedTextDirection paragraphDirection = $this$getHorizontalPosition.getParagraphDirection(offset);
        return $this$getHorizontalPosition.getHorizontalPosition(offset, bidiRunDirection == paragraphDirection);
    }
}

