/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.io;

import com.ustadmobile.libcache.io.InputStreamExtKt;
import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ustadmobile/libcache/io/RangeInputStream;", "Ljava/io/FilterInputStream;", "src", "Ljava/io/InputStream;", "fromByte", "", "toByte", "<init>", "(Ljava/io/InputStream;JJ)V", "pos", "read", "", "b", "", "off", "len", "markSupported", "", "respect-lib-cache_release"})
public final class RangeInputStream
extends FilterInputStream {
    @NotNull
    private final InputStream src;
    private final long fromByte;
    private final long toByte;
    private volatile long pos;

    public RangeInputStream(@NotNull InputStream src, long fromByte, long toByte) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        super(src);
        this.src = src;
        this.fromByte = fromByte;
        this.toByte = toByte;
        InputStreamExtKt.skipExactly(this, this.fromByte);
        this.pos = this.fromByte;
    }

    @Override
    public int read() {
        int n;
        if (this.pos <= this.toByte) {
            int n2;
            int it = n2 = this.src.read();
            boolean bl = false;
            long l = this.pos;
            this.pos = l + 1L;
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        long bytesRemaining = this.toByte - this.pos + 1L;
        if (bytesRemaining <= 0L) {
            return -1;
        }
        int effectiveLen = (long)len <= bytesRemaining ? len : (int)bytesRemaining;
        int it = n = super.read(b, off, effectiveLen);
        boolean bl = false;
        this.pos += (long)it;
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

