/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.launchapp;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.compatibleapps.model.RespectAppManifest;
import world.respect.shared.domain.launchapp.LaunchAppUseCase;
import world.respect.shared.navigation.NavCommand;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lworld/respect/shared/domain/launchapp/LaunchAppUseCaseAndroid;", "Lworld/respect/shared/domain/launchapp/LaunchAppUseCase;", "appContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "invoke", "", "app", "Lworld/respect/datalayer/compatibleapps/model/RespectAppManifest;", "learningUnitId", "Lio/ktor/http/Url;", "navigateFn", "Lkotlin/Function1;", "Lworld/respect/shared/navigation/NavCommand;", "Companion", "respect-lib-shared_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLaunchAppUseCaseAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchAppUseCaseAndroid.kt\nworld/respect/shared/domain/launchapp/LaunchAppUseCaseAndroid\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,74:1\n29#2:75\n*S KotlinDebug\n*F\n+ 1 LaunchAppUseCaseAndroid.kt\nworld/respect/shared/domain/launchapp/LaunchAppUseCaseAndroid\n*L\n40#1:75\n*E\n"})
public final class LaunchAppUseCaseAndroid
implements LaunchAppUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    public static final int $stable = 8;
    @NotNull
    private static final String WEBVIEW_ACTIVITY_NAME = "world.respect.WebViewActivity";
    @NotNull
    public static final String EXTRA_URL = "url";

    public LaunchAppUseCaseAndroid(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
    }

    @Override
    public void invoke(@NotNull RespectAppManifest app, @Nullable Url learningUnitId, @NotNull Function1<? super NavCommand, Unit> navigateFn) {
        Intent intent;
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter(navigateFn, (String)"navigateFn");
        RespectAppManifest.AndroidDetails androidDetails = app.getAndroid();
        String androidPackageId = androidDetails != null ? androidDetails.getPackageId() : null;
        Url url = learningUnitId;
        if (url == null) {
            url = URLUtilsKt.Url((String)app.getDefaultLaunchUri().toString());
        }
        Url launchUrlBase = url;
        URLBuilder $this$invoke_u24lambda_u240 = uRLBuilder = URLUtilsKt.URLBuilder((Url)launchUrlBase);
        boolean bl = false;
        $this$invoke_u24lambda_u240.getParameters().append("respectLaunchVersion", "1");
        Url launchUrl = uRLBuilder.build();
        Log.i((String)"LaunchUseCase", (String)("Launching URL: " + launchUrl));
        if (androidPackageId != null) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setPackage(androidPackageId);
            String $this$toUri$iv = launchUrl.toString();
            boolean $i$f$toUri = false;
            intent.setData(Uri.parse((String)$this$toUri$iv));
            try {
                this.appContext.startActivity(intent);
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        intent = new Intent(this.appContext, Class.forName(WEBVIEW_ACTIVITY_NAME));
        intent.setFlags(0x10000000);
        intent.putExtra(EXTRA_URL, launchUrl.toString());
        this.appContext.startActivity(intent);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lworld/respect/shared/domain/launchapp/LaunchAppUseCaseAndroid$Companion;", "", "<init>", "()V", "WEBVIEW_ACTIVITY_NAME", "", "EXTRA_URL", "respect-lib-shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

