package com.ustadmobile.port.android.view;

import java.lang.System;

/**
 * Table of Contents (ToC) list view component. This is used to show a hierarchical table of
 * contents where the user can expand or collapse items. It supports an unlimited number of levels.
 * An expand/collapse arrow appears to the end of the text. If the user taps on the arrow, the
 * group is expanded and the onItemClick method is not called. If the user taps on the view for the
 * item itself, the onItemClick event is fired and the view is not expanded.
 *
 * To create a TocListView a TocListViewAdapter needs to be provided.
 */
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\"#B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0004J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u001a\u0010\u001f\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0004J\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2 = {"Lcom/ustadmobile/port/android/view/TocListView;", "Landroid/widget/LinearLayout;", "Landroid/view/View$OnClickListener;", "Lcom/ustadmobile/port/android/view/TocItemView$OnClickExpandListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "adapter", "Lcom/ustadmobile/port/android/view/TocListView$TocListViewAdapter;", "onItemClickListener", "Lcom/ustadmobile/port/android/view/TocListView$OnItemClickListener;", "viewToNodeMap", "Ljava/util/HashMap;", "Lcom/ustadmobile/port/android/view/TocItemView;", "", "addChildren", "", "node", "startPos", "depth", "onClick", "view", "Landroid/view/View;", "onClickExpand", "itemView", "removeChildren", "setAdapter", "setOnItemClickListener", "OnItemClickListener", "TocListViewAdapter", "app-android_release"})
public final class TocListView extends android.widget.LinearLayout implements android.view.View.OnClickListener, com.ustadmobile.port.android.view.TocItemView.OnClickExpandListener {
    private com.ustadmobile.port.android.view.TocListView.TocListViewAdapter adapter;
    private final java.util.HashMap<com.ustadmobile.port.android.view.TocItemView, java.lang.Object> viewToNodeMap = null;
    private com.ustadmobile.port.android.view.TocListView.OnItemClickListener onItemClickListener;
    
    public TocListView(@org.jetbrains.annotations.NotNull()
    android.content.Context context) {
        super(null);
    }
    
    public TocListView(@org.jetbrains.annotations.NotNull()
    android.content.Context context, @org.jetbrains.annotations.Nullable()
    android.util.AttributeSet attrs) {
        super(null);
    }
    
    public TocListView(@org.jetbrains.annotations.NotNull()
    android.content.Context context, @org.jetbrains.annotations.Nullable()
    android.util.AttributeSet attrs, int defStyleAttr) {
        super(null);
    }
    
    /**
     * Set the adapter to use for this view
     *
     * @param adapter TocListViewAdapter to be used
     */
    public final void setAdapter(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.port.android.view.TocListView.TocListViewAdapter adapter) {
    }
    
    /**
     * Adds children to the view when a node is expanded.
     *
     * @param node Node to add from
     * @param startPos Position to start adding from (inclusive)
     * @param depth depth of the node to add from
     */
    protected final void addChildren(@org.jetbrains.annotations.Nullable()
    java.lang.Object node, int startPos, int depth) {
    }
    
    /**
     * Remove children (and their descendants) from the view when a node is collapsed
     *
     * @param node The node to remove children
     * @param startPos The position of the node from which to remove from
     */
    protected final void removeChildren(@org.jetbrains.annotations.Nullable()
    java.lang.Object node, int startPos) {
    }
    
    @java.lang.Override()
    public void onClick(@org.jetbrains.annotations.NotNull()
    android.view.View view) {
    }
    
    @java.lang.Override()
    public void onClickExpand(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.port.android.view.TocItemView itemView) {
    }
    
    /**
     * Set the listener for when an item is clicked
     *
     * @param onItemClickListener Listener for when an item itself is clicked.
     */
    public final void setOnItemClickListener(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.port.android.view.TocListView.OnItemClickListener onItemClickListener) {
    }
    
    /**
     * Adapter class used to provide items for the TocListView. This currently does not support
     * changing the content.
     */
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&J\"\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH&J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&R\u0012\u0010\u0003\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2 = {"Lcom/ustadmobile/port/android/view/TocListView$TocListViewAdapter;", "", "()V", "root", "getRoot", "()Ljava/lang/Object;", "getChildren", "", "node", "getNodeView", "Landroid/view/View;", "recycleView", "depth", "", "getNumChildren", "app-android_release"})
    public static abstract class TocListViewAdapter {
        
        public TocListViewAdapter() {
            super();
        }
        
        /**
         * Must return the root object, which should provide a List of child objects when the
         * getChildren method is called.
         *
         * @return Object representing the root node.
         */
        @org.jetbrains.annotations.NotNull()
        public abstract java.lang.Object getRoot();
        
        /**
         * Must return a list of child objects for the given node.
         *
         * @param node Object representing the node to list children for.
         *
         * @return A list of objects representing the children for this node. If this object has no
         * children returning null or an empty list are both acceptable.
         */
        @org.jetbrains.annotations.Nullable()
        public abstract java.util.List<?> getChildren(@org.jetbrains.annotations.Nullable()
        java.lang.Object node);
        
        /**
         * Return a view representing this node
         *
         * @param node Object for which the view is being created
         * @param recycleView A leftover view that is to be re-used. Might be null
         * @param depth The depth of this child from the root node
         *
         * @return A View object representing the given node
         */
        @org.jetbrains.annotations.NotNull()
        public abstract android.view.View getNodeView(@org.jetbrains.annotations.NotNull()
        java.lang.Object node, @org.jetbrains.annotations.Nullable()
        android.view.View recycleView, int depth);
        
        /**
         * Return the number of children for a specific node.
         *
         * @param node The node being queried
         *
         * @return The number of children for this node.
         */
        public abstract int getNumChildren(@org.jetbrains.annotations.Nullable()
        java.lang.Object node);
    }
    
    /**
     * Listener for when a node itself is clicked.
     */
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2 = {"Lcom/ustadmobile/port/android/view/TocListView$OnItemClickListener;", "", "onClick", "", "item", "view", "Landroid/view/View;", "app-android_release"})
    public static abstract interface OnItemClickListener {
        
        /**
         * Fired when the view for a given node has been clicked
         *
         * @param item The node object that was clicked
         * @param view The view object that was clicked
         */
        public abstract void onClick(@org.jetbrains.annotations.Nullable()
        java.lang.Object item, @org.jetbrains.annotations.NotNull()
        android.view.View view);
    }
}