KAdefine("javascript/perseus-merged-extra-widgets-package/perseus-with-extra-widgets.js", function(require, module, exports) {
var Perseus=require("../perseus-all-package/perseus.js")
var Widgets=require("../perseus-all-package/widgets.js")
var extraWidgets=require("./extra-widgets.js")
Widgets.registerWidgets(extraWidgets)
module.exports=Perseus

});
KAdefine("javascript/perseus-merged-extra-widgets-package/extra-widgets.js", function(require, module, exports) {
module.exports=[require("./widgets/categorizer.jsx"),require("./widgets/cs-program.jsx"),require("./widgets/dropdown.jsx"),require("./widgets/explanation.jsx"),require("./widgets/definition.jsx"),require("./widgets/grapher.jsx"),require("./widgets/graded-group.jsx"),require("./widgets/graded-group-set.jsx"),require("./widgets/group.jsx"),require("./widgets/iframe.jsx"),require("./widgets/image.jsx"),require("./widgets/interaction.jsx"),require("./widgets/interactive-graph.jsx"),require("./widgets/label-image.jsx"),require("./widgets/lights-puzzle.jsx"),require("./widgets/matrix.jsx"),require("./widgets/matcher.jsx"),require("./widgets/measurer.jsx"),require("./widgets/molecule.jsx"),require("./widgets/number-line.jsx"),require("./widgets/orderer.jsx"),require("./widgets/passage.jsx"),require("../perseus-all-package/widgets/passage-ref.jsx"),require("./widgets/passage-ref-target.jsx"),require("./widgets/plotter.jsx"),require("./widgets/reaction-diagram.jsx"),require("./widgets/sequence.jsx"),require("./widgets/simulator.jsx"),require("./widgets/sorter.jsx"),require("./widgets/table.jsx"),require("./widgets/transformer.jsx"),require("./widgets/unit.jsx"),require("./widgets/video.jsx")]

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/categorizer.jsx", function(require, module, exports) {
var _mobileTable,_fullBleedContainer
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var React=require("react")
var PropTypes=require("prop-types")
var classNames=require("classnames")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var WidgetJsonifyDeprecated=require("../../perseus-all-package/mixins/widget-jsonify-deprecated.jsx")
var _=require("underscore")
var ApiClassNames=require("../../perseus-all-package/perseus-api.jsx").ClassNames
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var _require2=require("../../perseus-all-package/icon-paths.js"),iconCircle=_require2.iconCircle,iconCircleThin=_require2.iconCircleThin
var InlineIcon=require("../../perseus-all-package/components/inline-icon.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var Util=require("../../perseus-all-package/util.js")
var mediaQueries=require("../../perseus-all-package/styles/media-queries.js")
var sharedStyles=require("../../perseus-all-package/styles/shared.js")
var _require3=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require3.linterContextProps,linterContextDefault=_require3.linterContextDefault
var Categorizer=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,s
babelHelpers.classCallCheck(this,r)
for(var i=arguments.length,n=Array(i),l=0;l<i;l++){n[l]=arguments[l]}return s=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(n))),a),_initialiseProps.call(a),t),babelHelpers.possibleConstructorReturn(a,s)}r.prototype.render=function e(){var r=this
var t=this
var a=this.props.apiOptions.isMobile
var s=this.props.items.map(function(e,r){return[e,r]})
if(this.props.randomizeItems){s=Util.shuffle(s,this.props.problemNum)}var i=React.createElement("table",{className:"categorizer-table "+css(styles.mobileTable)},React.createElement("thead",null,React.createElement("tr",null,React.createElement("th",null," "),this.props.categories.map(function(e,t){return React.createElement("th",{className:css(styles.header),key:t},React.createElement(Renderer,{content:e,linterContext:r.props.linterContext}))}))),React.createElement("tbody",null,s.map(function(e){var s=e[0]
var i=e[1]
var n=t.state.uniqueId+"_"+i
return React.createElement("tr",{key:i},React.createElement("td",null,React.createElement(Renderer,{content:s,linterContext:r.props.linterContext})),_.range(t.props.categories.length).map(function(e){var s=t.props.values[i]===e
return React.createElement("td",{className:"category "+css(styles.cell,styles.responsiveCell),key:e},React.createElement("div",{className:ApiClassNames.INTERACTIVE,onClick:r.onChange.bind(r,i,e)},a&&React.createElement("input",{type:"radio",name:n,className:css(sharedStyles.responsiveInput,sharedStyles.responsiveRadioInput),checked:s,onChange:r.onChange.bind(r,i,e),onClick:function e(r){return r.stopPropagation()}}),!a&&React.createElement("span",{className:css(styles.responsiveSpan,styles.radioSpan,s&&styles.checkedRadioSpan,r.props.static&&s&&styles.staticCheckedRadioSpan)},s?React.createElement(InlineIcon,iconCircle):React.createElement(InlineIcon,iconCircleThin))))}))})))
var n=classNames({"categorizer-container":true,"static-mode":this.props.static})
var l=this.props.apiOptions.isMobile?[styles.fullBleedContainer]:[]
return React.createElement("div",{className:n+" "+css.apply(undefined,l)},i)}
return r}(React.Component)
Categorizer.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:ApiOptions.propTypes,categories:PropTypes.arrayOf(PropTypes.string),items:PropTypes.arrayOf(PropTypes.string),trackInteraction:PropTypes.func.isRequired,values:PropTypes.arrayOf(PropTypes.number),linterContext:linterContextProps})
Categorizer.defaultProps={items:[],categories:[],values:[],linterContext:linterContextDefault}
var _initialiseProps=function e(){var r=this
this.state={uniqueId:_.uniqueId("perseus_radio_")}
this.change=function(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++){t[a]=arguments[a]}return Changeable.change.apply(r,t)}
this.getUserInput=function(){return Categorizer.getUserInputFromProps(r.props)}
this.onChange=function(e,t){var a=_.clone(r.props.values)
a[e]=t
r.change("values",a)
r.props.trackInteraction()}
this.simpleValidate=function(e){return Categorizer.validate(r.getUserInput(),e)}}
_.extend(Categorizer,{validate:function e(r,t){var a=true
var s=true
_.each(t.values,function(e,t){if(r.values[t]==null){a=false}if(r.values[t]!==e){s=false}})
if(!a){return{type:"invalid",message:i18n._("Make sure you select something for every row.")}}return{type:"points",earned:s?1:0,total:1,message:null}},getUserInputFromProps:function e(r){return WidgetJsonifyDeprecated.getUserInputFromProps(r)}})
var pageMargin=16
var styles=StyleSheet.create({mobileTable:(_mobileTable={},_mobileTable[mediaQueries.smOrSmaller]={minWidth:"auto"},_mobileTable),fullBleedContainer:(_fullBleedContainer={},_fullBleedContainer[mediaQueries.mdOrSmaller]={marginLeft:-pageMargin,marginRight:-pageMargin,overflowX:"auto"},_fullBleedContainer),header:{textAlign:"center",verticalAlign:"bottom"},cell:{textAlign:"center",padding:0,color:"#ccc",verticalAlign:"middle"},radioSpan:{fontSize:30,paddingRight:3,":hover":{color:"#999"}},checkedRadioSpan:{color:"#333"},staticCheckedRadioSpan:{color:"#888"}})
module.exports={name:"categorizer",displayName:"Categorizer",widget:Categorizer,transform:function e(r){return _.pick(r,"items","categories","randomizeItems")},staticTransform:function e(r){return _.pick(r,"items","categories","values","randomizeItems")},isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/cs-program.jsx", function(require, module, exports) {
var _staticUrl=require("../../shared-package/static-url.js")
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var $=require("jquery")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var updateQueryString=require("../../perseus-all-package/util.js").updateQueryString
var ARTICLE_WIDTH=688
function getUrlFromProgramID(e){var r="/computer-programming/program/"+(e+"/embedded?embed=yes&author=no")
var t=window.location.protocol
if(t&&t.toLowerCase()==="file:"){return"https://khanacademy.org"+r}return(0,_staticUrl.absoluteUrlFromPath)(r)}var CSProgram=function(e){babelHelpers.inherits(r,e)
function r(){var t,s,a
babelHelpers.classCallCheck(this,r)
for(var o=arguments.length,i=Array(o),n=0;n<o;n++){i[n]=arguments[n]}return a=(t=(s=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),s),_initialiseProps.call(s),t),babelHelpers.possibleConstructorReturn(s,a)}r.validate=function e(r,t){if(r.status==="correct"){return{type:"points",earned:1,total:1,message:r.message||null}}else if(r.status==="incorrect"){return{type:"points",earned:0,total:1,message:r.message||null}}else{return{type:"invalid",message:"Keep going, you're not there yet!"}}}
r.prototype.componentDidMount=function e(){$(window).on("message",this.handleMessageEvent)}
r.prototype.componentWillUnmount=function e(){$(window).off("message",this.handleMessageEvent)}
r.prototype.render=function e(){if(!this.props.programID){return React.createElement("div",null)}var r=false
var t=getUrlFromProgramID(this.props.programID)
var s=void 0
var a={height:this.props.height,width:"100%"}
if(this.props.showEditor){t+="&editor=yes"
s="perseus-scratchpad-editor"}else{t+="&editor=no&width="+ARTICLE_WIDTH
s="perseus-scratchpad"
if(this.props.programType!=="webpage"){r=true}}if(this.props.showButtons){t+="&buttons=yes"
a.height+=50}else{t+="&buttons=no"}if(this.props.settings){var o={}
_.each(this.props.settings,function(e){if(e.name&&e.value){o[e.name]=e.value}})
t=updateQueryString(t,"settings",JSON.stringify(o))}var i=["allow-popups","allow-same-origin","allow-scripts","allow-top-navigation"].join(" ")
return React.createElement("div",{className:css(styles.widthOverride,r&&styles.container)},React.createElement("iframe",{sandbox:i,src:t,style:a,className:s,allowFullScreen:true}))}
return r}(React.Component)
CSProgram.propTypes=babelHelpers.extends({},Changeable.propTypes,{programID:PropTypes.string,programType:PropTypes.oneOf(["pjs","sql","webpage"]),width:PropTypes.number,height:PropTypes.number,settings:PropTypes.array,showEditor:PropTypes.bool,showButtons:PropTypes.bool,status:PropTypes.oneOf(["incomplete","incorrect","correct"]),message:PropTypes.string})
CSProgram.defaultProps={showEditor:false,showButtons:false,status:"incomplete",message:null}
var _initialiseProps=function e(){var r=this
this.handleMessageEvent=function(e){var t={}
try{t=JSON.parse(e.originalEvent.data)}catch(e){return}if(_.isUndefined(t.testsPassed)){return}var s=t.testsPassed?"correct":"incorrect"
r.change({status:s,message:t.message})}
this.change=function(){for(var e=arguments.length,t=Array(e),s=0;s<e;s++){t[s]=arguments[s]}return Changeable.change.apply(r,t)}
this.simpleValidate=function(e){return CSProgram.validate({status:r.props.status,message:r.props.message},e)}}
var styles=StyleSheet.create({widthOverride:{width:820},container:{margin:"auto"}})
module.exports={name:"cs-program",displayName:"CS Program",supportedAlignments:["block","full-width"],widget:CSProgram,hidden:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/dropdown.jsx", function(require, module, exports) {
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var classNames=require("classnames")
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var ApiClassNames=require("../../perseus-all-package/perseus-api.jsx").ClassNames
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var InlineIcon=require("../../perseus-all-package/components/inline-icon.jsx")
var styleConstants=require("../../perseus-all-package/styles/constants.js")
var _require2=require("../../perseus-all-package/icon-paths.js"),iconDropdownArrow=_require2.iconDropdownArrow
var dropdownArrowSize=24
var Dropdown=function(e){babelHelpers.inherits(r,e)
function r(){var o,n,s
babelHelpers.classCallCheck(this,r)
for(var t=arguments.length,a=Array(t),p=0;p<t;p++){a[p]=arguments[p]}return s=(o=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),n),n.focus=function(){ReactDOM.findDOMNode(n).focus()
return true},n._handleChangeEvent=function(e){n._handleChange(parseInt(e.target.value))},n._handleChange=function(e){n.props.trackInteraction()
n.props.onChange({selected:e})},n.getUserInput=function(){return{value:n.props.selected}},n.simpleValidate=function(e){return r.validate(n.getUserInput(),e)},o),babelHelpers.possibleConstructorReturn(n,s)}r.prototype.render=function e(){var r=this.props.choices.slice()
var o=classNames({"perseus-widget-dropdown":true})
return React.createElement("div",null,React.createElement("select",{onChange:this._handleChangeEvent,onClick:function e(r){r.stopPropagation()
r.target.focus()},onTouchStart:function e(r){r.stopPropagation()
r.target.focus()},className:o+" nofastclick "+css(styles.dropdown)+" "+ApiClassNames.INTERACTIVE,disabled:this.props.apiOptions.readOnly,value:this.props.selected},React.createElement("option",{value:0,disabled:true},this.props.placeholder),r.map(function(e,r){return React.createElement("option",{key:""+(r+1),value:r+1},e)})),React.createElement(InlineIcon,babelHelpers.extends({},iconDropdownArrow,{style:{marginLeft:"-"+dropdownArrowSize+"px",height:dropdownArrowSize,width:dropdownArrowSize}})))}
return r}(React.Component)
Dropdown.propTypes={apiOptions:ApiOptions.propTypes,choices:PropTypes.arrayOf(PropTypes.string),onChange:PropTypes.func.isRequired,placeholder:PropTypes.string,selected:PropTypes.number,trackInteraction:PropTypes.func.isRequired}
Dropdown.defaultProps={choices:[],selected:0,placeholder:"",apiOptions:ApiOptions.defaults}
_.extend(Dropdown,{validate:function e(r,o){var n=r.value
if(n===0){return{type:"invalid",message:null}}else{var s=o.choices[n-1].correct
return{type:"points",earned:s?1:0,total:1,message:null}}}})
var propTransform=function e(r){return{placeholder:r.placeholder,choices:_.map(r.choices,function(e){return e.content})}}
var styles=StyleSheet.create({dropdown:{appearance:"none",backgroundColor:"transparent",border:"1px solid "+styleConstants.gray76,borderRadius:4,boxShadow:"none",fontFamily:styleConstants.baseFontFamily,padding:"9px "+(dropdownArrowSize+1)+"px 9px 9px",":focus":{outline:"none",border:"2px solid "+styleConstants.kaGreen,padding:"8px "+dropdownArrowSize+"px 8px 8px"},":focus + svg":{color:""+styleConstants.kaGreen},":disabled":{color:styleConstants.gray68},":disabled + svg":{color:styleConstants.gray68}}})
module.exports={name:"dropdown",displayName:"Drop down",defaultAlignment:"inline-block",accessible:true,widget:Dropdown,transform:propTransform}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/explanation.jsx", function(require, module, exports) {
var _explanationLink,_mobileExplanationLin
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var PerseusApi=require("../../perseus-all-package/perseus-api.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var mediaQueries=require("../../perseus-all-package/styles/media-queries.js")
var styleConstants=require("../../perseus-all-package/styles/constants.js")
var _require2=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require2.linterContextProps,linterContextDefault=_require2.linterContextDefault
var defaultExplanationProps={showPrompt:"Explain",hidePrompt:"Hide explanation",explanation:"explanation goes here\n\nmore explanation",widgets:{},linterContext:linterContextDefault}
var Explanation=function(e){babelHelpers.inherits(t,e)
function t(){var n,a,i
babelHelpers.classCallCheck(this,t)
for(var r=arguments.length,o=Array(r),s=0;s<r;s++){o[s]=arguments[s]}return i=(n=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),a),_initialiseProps.call(a),n),babelHelpers.possibleConstructorReturn(a,i)}t.prototype.render=function e(){var t=this.props.apiOptions.baseElements.Link
var n=this.props.apiOptions,a=n.readOnly,i=n.isMobile
var r=this.state.expanded?this.props.hidePrompt:this.props.showPrompt
var o=void 0
var s=a?null:"javascript:void(0)"
var l=a?null:this._onClick
if(i){o=React.createElement("div",{className:css(styles.linkContainer)},React.createElement("a",{className:css(styles.mobileExplanationLink),href:s,onClick:l},r),this.state.expanded&&React.createElement("svg",{className:css(styles.disclosureArrow)},React.createElement("polygon",{style:{fill:backgroundColor},points:"0,"+arrowHeight+" "+(arrowWidth+","+arrowHeight+" ")+(arrowWidth/2+",0")})))}else{o=React.createElement("div",{className:css(styles.linkContainer)},React.createElement(t,{className:css(styles.explanationLink),href:s,onClick:l},"["+r+"]"))}var p=i?styles.contentExpandedMobile:styles.contentExpanded
return React.createElement("div",{className:css(styles.container)},o,React.createElement("div",{className:css(styles.content,i&&styles.contentMobile,this.state.expanded&&p),style:{height:this.state.expanded?"auto":0,overflow:this.state.expanded?"visible":"hidden"},ref:"content"},React.createElement(Renderer,{apiOptions:this.props.apiOptions,content:this.props.explanation,widgets:this.props.widgets,linterContext:this.props.linterContext})))}
return t}(React.Component)
Explanation.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:PerseusApi.Options.propTypes,explanation:PropTypes.string,hidePrompt:PropTypes.string,showPrompt:PropTypes.string,trackInteraction:PropTypes.func.isRequired,widgets:PropTypes.object,linterContext:linterContextProps})
Explanation.defaultProps=defaultExplanationProps
var _initialiseProps=function e(){var t=this
this.state={expanded:false}
this.change=function(){for(var e=arguments.length,n=Array(e),a=0;a<e;a++){n[a]=arguments[a]}return Changeable.change.apply(t,n)}
this._onClick=function(){t.setState({expanded:!t.state.expanded})
t.props.trackInteraction()}
this.getUserInput=function(){return{}}
this.simpleValidate=function(e){return Explanation.validate(t.getUserInput(),e)}}
var leftBorderSpacing=23
var verticalContentPadding=10
var arrowWidth=30
var arrowHeight=14
var backgroundColor=styleConstants.gray95
var styles=StyleSheet.create({container:{display:"inline",position:"relative"},linkContainer:{display:"inline-block"},explanationLink:(_explanationLink={fontStyle:"italic",color:"#007d96"},_explanationLink[mediaQueries.xl]={fontSize:20,lineHeight:1.1},_explanationLink[mediaQueries.lgOrSmaller]={fontSize:17,lineHeight:1.4},_explanationLink[mediaQueries.smOrSmaller]={fontSize:14,lineHeight:1.3},_explanationLink),mobileExplanationLink:(_mobileExplanationLin={color:styleConstants.kaGreen,borderBottom:"dashed 1px "+styleConstants.kaGreen,textDecoration:"none"},_mobileExplanationLin[mediaQueries.xl]={fontSize:22,lineHeight:1.4},_mobileExplanationLin[mediaQueries.lgOrSmaller]={fontSize:20,lineHeight:1.5},_mobileExplanationLin[mediaQueries.smOrSmaller]={fontSize:18,lineHeight:1.2},_mobileExplanationLin),content:{position:"relative",transition:"margin-top 0.1s"},contentExpanded:{borderLeft:"5px solid #ccc",marginLeft:-leftBorderSpacing,paddingLeft:leftBorderSpacing,paddingBottom:verticalContentPadding,marginBottom:arrowHeight,marginTop:arrowHeight},contentExpandedMobile:{boxSizing:"content-box",paddingTop:32,paddingBottom:32,marginTop:arrowHeight},contentMobile:{background:backgroundColor,marginLeft:styleConstants.negativePhoneMargin,marginRight:styleConstants.negativePhoneMargin,paddingLeft:styleConstants.phoneMargin,paddingRight:styleConstants.phoneMargin},disclosureArrow:{bottom:-(arrowHeight+5),height:arrowHeight,left:"50%",marginLeft:-(arrowWidth/2),position:"absolute",width:arrowWidth}})
_.extend(Explanation,{validate:function e(t,n){return{type:"points",earned:0,total:0,message:null}}})
module.exports={name:"explanation",displayName:"Explanation",defaultAlignment:"inline",widget:Explanation,transform:_.identity,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/definition.jsx", function(require, module, exports) {
var _wonderBlocksColorV=require("@khanacademy/wonder-blocks-color-v1")
var _wonderBlocksColorV2=babelHelpers.interopRequireDefault(_wonderBlocksColorV)
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _wonderBlocksSpacingV=require("@khanacademy/wonder-blocks-spacing-v2")
var _wonderBlocksSpacingV2=babelHelpers.interopRequireDefault(_wonderBlocksSpacingV)
var _wonderBlocksTooltipV=require("@khanacademy/wonder-blocks-tooltip-v1")
var _wonderBlocksTooltipV2=babelHelpers.interopRequireDefault(_wonderBlocksTooltipV)
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var PerseusApi=require("../../perseus-all-package/perseus-api.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var DefinitionContent=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.componentDidMount=function e(){this.props.trackInteraction()}
t.prototype.render=function e(){return React.createElement(_wonderBlocksCoreV.View,{style:styles.tooltipBody},React.createElement(Renderer,{apiOptions:this.props.apiOptions,content:this.props.content,widgets:this.props.widgets}))}
return t}(React.Component)
DefinitionContent.propTypes={apiOptions:PerseusApi.Options.propTypes,content:PropTypes.string,trackInteraction:PropTypes.func.isRequired,widgets:PropTypes.objectOf(PropTypes.any)}
var Definition=function(e){babelHelpers.inherits(t,e)
function t(){var o,r,n
babelHelpers.classCallCheck(this,t)
for(var i=arguments.length,s=Array(i),p=0;p<i;p++){s[p]=arguments[p]}return n=(o=(r=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),r),r.getUserInput=function(){return{}},r.simpleValidate=function(e){return t.validate(r.getUserInput(),e)},o),babelHelpers.possibleConstructorReturn(r,n)}t.prototype.render=function e(){var t=React.createElement(DefinitionContent,{apiOptions:this.props.apiOptions,content:this.props.definition,key:this.props.definition,trackInteraction:this.props.trackInteraction,widgets:this.props.widgets})
return React.createElement(_wonderBlocksTooltipV2.default,{content:t,placement:"left"},React.createElement(_wonderBlocksCoreV.View,{style:styles.definitionLink},this.props.togglePrompt))}
return t}(React.Component)
Definition.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:PerseusApi.Options.propTypes,definition:PropTypes.string,togglePrompt:PropTypes.string,trackInteraction:PropTypes.func.isRequired,widgets:PropTypes.objectOf(PropTypes.any)})
Definition.defaultProps={togglePrompt:"define me",definition:"definition goes here"}
var styles={tooltipBody:{color:_wonderBlocksColorV2.default.offBlack,display:"block",fontSize:20,fontWeight:500,lineHeight:"30px",margin:_wonderBlocksSpacingV2.default.xSmall},definitionLink:{borderBottom:"dashed 1px "+_wonderBlocksColorV2.default.blue,color:_wonderBlocksColorV2.default.blue,cursor:"pointer",display:"inline-block",fontSize:20,lineHeight:"30px",textDecoration:"none"}}
_.extend(Definition,{validate:function e(t,o){return{type:"points",earned:0,total:0,message:null}}})
module.exports={name:"definition",displayName:"Definition",defaultAlignment:"inline",widget:Definition,transform:_.identity}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/grapher.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var createReactClass=require("create-react-class")
var _=require("underscore")
var $=require("jquery")
var Interactive2=require("../../perseus-all-package/interactive2.js")
var SvgImage=require("../../perseus-all-package/components/svg-image.jsx")
var Util=require("../../perseus-all-package/util.js")
var ButtonGroup=require("../../react-components-package/button-group.jsx")
var Graphie=require("../../perseus-all-package/components/graphie.jsx")
var MovablePoint=Graphie.MovablePoint
var MovableLine=Graphie.MovableLine
var WrappedLine=require("../../perseus-all-package/interactive2/wrapped-line.js")
var knumber=require("kmath").number
var kvector=require("kmath").vector
var kpoint=require("kmath").point
var KhanColors=require("../../perseus-all-package/util/colors.js")
var _require=require("../../perseus-all-package/util/sizing-utils.js"),containerSizeClassPropType=_require.containerSizeClassPropType
var _require2=require("../../perseus-all-package/styles/constants.js"),interactiveSizes=_require2.interactiveSizes
var _require3=require("../../perseus-all-package/util/sizing-utils.js"),getInteractiveBoxFromSizeClass=_require3.getInteractiveBoxFromSizeClass
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var _require4=require("./grapher/util.jsx"),GrapherUtil=_require4.GrapherUtil,typeToButton=_require4.typeToButton,functionForType=_require4.functionForType,DEFAULT_GRAPHER_PROPS=_require4.DEFAULT_GRAPHER_PROPS
function isFlipped(e,r,t){var a=function e(r,t,a){return(t[0]-r[0])*(a[1]-r[1])-(a[0]-r[0])*(t[1]-r[1])}
return a(t[0],t[1],r)>0!==a(t[0],t[1],e)>0}var typeSelectorStyle={padding:"5px 5px"}
var FunctionGrapher=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,i
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,o=Array(s),p=0;p<s;p++){o[p]=arguments[p]}return i=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),a),_initialiseProps.call(a),t),babelHelpers.possibleConstructorReturn(a,i)}r.prototype.render=function e(){var r=this
var t=function e(t,a){return React.createElement(MovablePoint,{key:a,coord:t,static:r.props.static,constraints:[Interactive2.MovablePoint.constraints.bound(),Interactive2.MovablePoint.constraints.snap(),function(e){var t=_.all(r._coords(),function(r,t){return a===t||!r||!knumber.equal(e[0],r[0])})
if(!t){return false}if(r.props.model&&r.props.model.extraCoordConstraint){var i=r.props.model.extraCoordConstraint
var s=_.clone(r._coords())
var o=_.clone(s[a])
s[a]=e
return i(e,o,s,r._asymptote(),r.props.graph)}return t}],onMove:function e(t,i){var s
var o=r._asymptote()
if(o&&r.props.model.allowReflectOverAsymptote&&isFlipped(t,i,o)){s=_.map(r._coords(),function(e){return kpoint.reflectOverLine(e,o)})}else{s=_.clone(r._coords())}s[a]=t
r.props.onChange({coords:s})},showHairlines:r.props.showHairlines,hideHairlines:r.props.hideHairlines,showTooltips:r.props.showTooltips,isMobile:r.props.isMobile})}
var a=_.map(this._coords(),t)
var i=this.props.graph.box
var s=this.props.graph.backgroundImage
var o=null
if(s.url){var p=i[0]/interactiveSizes.defaultBoxSize
o=React.createElement(SvgImage,{src:s.url,width:s.width,height:s.height,scale:p})}return React.createElement("div",{className:"perseus-widget "+"perseus-widget-grapher",style:{width:i[0],height:this.props.flexibleType?"auto":i[1],boxSizing:"initial"}},React.createElement("div",{className:"graphie-container above-scratchpad",style:{width:i[0],height:i[1]}},o,React.createElement(Graphie,babelHelpers.extends({},this.props.graph,{setDrawingAreaAvailable:this.props.setDrawingAreaAvailable}),this.props.model&&this.renderPlot(),this.props.model&&this.renderAsymptote(),this.props.model&&a)))}
return r}(React.Component)
FunctionGrapher.propTypes=babelHelpers.extends({},Changeable.propTypes,{flexibleType:PropTypes.bool,graph:PropTypes.any,hideHairlines:PropTypes.func,isMobile:PropTypes.bool,model:PropTypes.any,onChange:PropTypes.func,setDrawingAreaAvailable:PropTypes.func,showHairlines:PropTypes.func,showTooltips:PropTypes.bool,static:PropTypes.bool})
FunctionGrapher.defaultProps={graph:{range:[[-10,10],[-10,10]],step:[1,1]},coords:null,asymptote:null,isMobile:false}
var _initialiseProps=function e(){var r=this
this._coords=function(e){e=e||r.props
var t=e.graph
var a=e.model&&GrapherUtil.maybePointsFromNormalized(e.model.defaultCoords,t.range,t.step,t.snapStep)
return e.coords||a||null}
this._asymptote=function(e){e=e||r.props
return e.asymptote}
this.change=function(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++){t[a]=arguments[a]}return Changeable.change.apply(r,t)}
this.renderPlot=function(){var e=r.props.model
var t=r.props.graph.range[0]
var a=babelHelpers.extends({stroke:r.props.isMobile?KhanColors.BLUE_C:KhanColors.DYNAMIC},r.props.isMobile?{"stroke-width":3}:{})
var i=e.getCoefficients(r._coords(),r._asymptote())
if(!i){return}var s=e.getPropsForCoeffs(i,t)
return React.createElement(e.Movable,babelHelpers.extends({},s,{key:r.props.model.url,range:t,style:a}))}
this.renderAsymptote=function(){var e=r.props.model
var t=r.props.graph
var a=r._asymptote()
var i={strokeDasharray:"- "}
return a&&React.createElement(MovableLine,{onMove:function e(t,a){var i=kvector.subtract(t,a)
var s=_.map(r._asymptote(),function(e){return kvector.add(e,i)})
r.props.onChange({asymptote:s})},constraints:[Interactive2.MovableLine.constraints.bound(),Interactive2.MovableLine.constraints.snap(),function(a,i){var s=kvector.subtract(a,i)
var o=_.map(r._asymptote(),function(e){return kvector.add(e,s)})
if(e.extraAsymptoteConstraint){return e.extraAsymptoteConstraint(a,i,r._coords(),o,t)}return true}],normalStyle:i,highlightStyle:i},_.map(a,function(e,t){return React.createElement(MovablePoint,{key:"asymptoteCoord-"+t,coord:e,static:true,draw:null,extendLine:true,showHairlines:r.props.showHairlines,hideHairlines:r.props.hideHairlines,showTooltips:r.props.showTooltips,isMobile:r.props.isMobile})}))}}
var Grapher=createReactClass({displayName:"Grapher",propTypes:{apiOptions:PropTypes.any,availableTypes:PropTypes.arrayOf(PropTypes.any),containerSizeClass:containerSizeClassPropType.isRequired,graph:PropTypes.any,markings:PropTypes.string,onChange:PropTypes.func,plot:PropTypes.any,static:PropTypes.bool,trackInteraction:PropTypes.func.isRequired},getDefaultProps:function e(){return DEFAULT_GRAPHER_PROPS},render:function e(){var r=this.props.plot.type
var t=this.props.plot.coords
var a=this.props.plot.asymptote
var i=React.createElement("div",{style:typeSelectorStyle,className:"above-scratchpad"},React.createElement(ButtonGroup,{value:r,allowEmpty:true,buttons:_.map(this.props.availableTypes,typeToButton),onChange:this.handleActiveTypeChange}))
var s=getInteractiveBoxFromSizeClass(this.props.containerSizeClass)
var o=babelHelpers.extends({},this.props.graph,GrapherUtil.getGridAndSnapSteps(this.props.graph,s[0]),{gridConfig:this._getGridConfig(babelHelpers.extends({},this.props.graph,{box:s},GrapherUtil.getGridAndSnapSteps(this.props.graph,s[0])))})
var p={graph:{box:s,range:o.range,step:o.step,snapStep:o.snapStep,backgroundImage:o.backgroundImage,options:o,setup:this._setupGraphie},onChange:this.handlePlotChanges,model:r&&functionForType(r),coords:t,asymptote:a,static:this.props.static,setDrawingAreaAvailable:this.props.apiOptions.setDrawingAreaAvailable,isMobile:this.props.apiOptions.isMobile,showTooltips:this.props.graph.showTooltips,showHairlines:this.showHairlines,hideHairlines:this.hideHairlines}
return React.createElement("div",null,React.createElement(FunctionGrapher,p),this.props.availableTypes.length>1&&i)},handlePlotChanges:function e(r){var t=_.extend({},this.props.plot,r)
this.props.onChange({plot:t})
this.props.trackInteraction()},handleActiveTypeChange:function e(r){var t=this.props.graph
var a=_.extend({},this.props.plot,GrapherUtil.defaultPlotProps(r,t))
this.props.onChange({plot:a})},_getGridConfig:function e(r){return _.map(r.step,function(e,t){return Util.gridDimensionConfig(e,r.range[t],r.box[t],r.gridStep[t])})},_calculateMobileTickStep:function e(r,t,a){var i=Util.constrainedTickStepsFromTickSteps(t,a)
i[0]=i[0]/r[0]
i[1]=i[1]/r[1]
return i},_setupGraphie:function e(r,t){var a=this.props.apiOptions.isMobile
if(t.markings==="graph"){r.graphInit({range:t.range,scale:_.pluck(t.gridConfig,"scale"),axisArrows:"<->",labelFormat:function e(r){return"\\small{"+r+"}"},gridStep:t.gridStep,snapStep:t.snapStep,tickStep:a?this._calculateMobileTickStep(t.gridStep,t.step,t.range):_.pluck(t.gridConfig,"tickStep"),labelStep:1,unityLabels:_.pluck(t.gridConfig,"unityLabel"),isMobile:a})
r.label([0,t.range[1][1]],t.labels[1],a?"below right":"above")
r.label([t.range[0][1],0],t.labels[0],a?"above left":"right")}else if(t.markings==="grid"){r.graphInit({range:t.range,scale:_.pluck(t.gridConfig,"scale"),gridStep:t.gridStep,axes:false,ticks:false,labels:false,isMobile:a})}else if(t.markings==="none"){r.init({range:t.range,scale:_.pluck(t.gridConfig,"scale")})}if(this.props.apiOptions.isMobile){var i={normalStyle:{strokeWidth:1}}
this.horizHairline=new WrappedLine(r,[0,0],[0,0],i)
this.horizHairline.attr({stroke:KhanColors.INTERACTIVE})
this.horizHairline.hide()
this.vertHairline=new WrappedLine(r,[0,0],[0,0],i)
this.vertHairline.attr({stroke:KhanColors.INTERACTIVE})
this.vertHairline.hide()}},showHairlines:function e(r){if(this.props.apiOptions.isMobile&&this.props.markings!=="none"){this.horizHairline.moveTo([this.props.graph.range[0][0],r[1]],[this.props.graph.range[0][1],r[1]])
this.horizHairline.show()
this.vertHairline.moveTo([r[0],this.props.graph.range[1][0]],[r[0],this.props.graph.range[1][1]])
this.vertHairline.show()}},hideHairlines:function e(){if(this.props.apiOptions.isMobile){this.horizHairline.hide()
this.vertHairline.hide()}},simpleValidate:function e(r){return GrapherUtil.validate(this.getUserInput(),r)},getUserInput:function e(){return Grapher.getUserInputFromProps(this.props)},focus:$.noop})
var propTransform=function e(r){var t={availableTypes:r.availableTypes,graph:r.graph}
if(t.availableTypes.length===1){var a=t.graph
var i=GrapherUtil.chooseType(t.availableTypes)
t.plot=GrapherUtil.defaultPlotProps(i,a)}return t}
var staticTransform=function e(r){return _.extend({},propTransform(r),{availableTypes:[r.correct.type],plot:r.correct})}
_.extend(Grapher,{validate:function e(r,t){return GrapherUtil.validate(r,t)},getUserInputFromProps:function e(r){return r.plot}})
module.exports={name:"grapher",displayName:"Grapher",widget:Grapher,transform:propTransform,staticTransform:staticTransform}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/graded-group.jsx", function(require, module, exports) {
var classNames=require("classnames")
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var i18n=require("../../shared-package/i18n.js")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var _require=require("../../perseus-all-package/icon-paths.js"),iconOk=_require.iconOk,iconRemove=_require.iconRemove
var InlineIcon=require("../../perseus-all-package/components/inline-icon.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var GradedGroupAnswerBar=require("./graded-group-answer-bar.jsx")
var _require2=require("../../perseus-all-package/styles/constants.js"),gray76=_require2.gray76,phoneMargin=_require2.phoneMargin,negativePhoneMargin=_require2.negativePhoneMargin,tableBackgroundAccent=_require2.tableBackgroundAccent,kaGreen=_require2.kaGreen
var _require3=require("aphrodite"),StyleSheet=_require3.StyleSheet,css=_require3.css
var _require4=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require4.linterContextProps,linterContextDefault=_require4.linterContextDefault
var GRADING_STATUSES={ungraded:"ungraded",correct:"correct",incorrect:"incorrect",invalid:"invalid"}
var ANSWER_BAR_STATES=GradedGroupAnswerBar.ANSWER_BAR_STATES
var getNextState=function e(t,r){switch(t){case ANSWER_BAR_STATES.HIDDEN:return r?ANSWER_BAR_STATES.ACTIVE:t
case ANSWER_BAR_STATES.ACTIVE:return!r?ANSWER_BAR_STATES.INACTIVE:t
case ANSWER_BAR_STATES.INACTIVE:return r?ANSWER_BAR_STATES.ACTIVE:t
case ANSWER_BAR_STATES.INCORRECT:return r?ANSWER_BAR_STATES.ACTIVE:ANSWER_BAR_STATES.INACTIVE
default:return t}}
var INVALID_MESSAGE_PREFIX="We couldn't grade your answer."
var DEFAULT_INVALID_MESSAGE="It looks like you left something blank or "+"entered in an invalid answer."
var GradedGroup=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,s
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,i=Array(a),o=0;o<a;o++){i[o]=arguments[o]}return s=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),n),_initialiseProps.call(n),r),babelHelpers.possibleConstructorReturn(n,s)}t.prototype.shouldComponentUpdate=function e(t,r){return t!==this.props||r!==this.state}
t.prototype.render=function e(){var t=this,r
var n=_.extend({},ApiOptions.defaults,this.props.apiOptions,{onFocusChange:function e(r,n){if(n){t.props.onBlur(n)}if(r){t.props.onFocus(r)}}})
var s=null
if(this.state.status===GRADING_STATUSES.correct){s=React.createElement(InlineIcon,babelHelpers.extends({},iconOk,{style:{color:"#526f03"}}))}else if(this.state.status===GRADING_STATUSES.incorrect){s=React.createElement(InlineIcon,babelHelpers.extends({},iconRemove,{style:{color:"#ff5454"}}))}var a=this.props.inGradedGroupSet?css(styles.gradedGroupInSet):css(styles.gradedGroup)
var i=classNames((r={},r[a]=n.isMobile,r["perseus-graded-group"]=true,r["answer-correct"]=n.isMobile?false:this.state.status===GRADING_STATUSES.correct,r["answer-incorrect"]=n.isMobile?false:this.state.status===GRADING_STATUSES.incorrect,r))
var o=this.state.answerBarState
var p=o===ANSWER_BAR_STATES.CORRECT
var l=n.readOnly||n.isMobile&&p
return React.createElement("div",{className:i},!!this.props.title&&React.createElement("div",{className:css(styles.title)},this.props.title),React.createElement(Renderer,babelHelpers.extends({},this.props,{ref:"renderer",apiOptions:babelHelpers.extends({},n,{readOnly:l}),onInteractWithWidget:this._onInteractWithWidget,linterContext:this.props.linterContext})),!n.isMobile&&s&&React.createElement("div",{className:"group-icon"},s),!n.isMobile&&React.createElement("p",null,this.state.message),!n.isMobile&&React.createElement("input",{type:"button",value:i18n._("Check"),className:"simple-button",disabled:this.props.apiOptions.readOnly,onClick:this._checkAnswer}),!n.isMobile&&p&&this.props.onNextQuestion&&React.createElement("input",{type:"button",value:i18n._("Next question"),className:"simple-button",disabled:this.props.apiOptions.readOnly,onClick:this.props.onNextQuestion,style:{marginLeft:5}}),this.props.hint&&this.props.hint.content&&(this.state.showHint?React.createElement("div",null,React.createElement("div",{className:css(styles.explanationTitle),onClick:function e(){return t.setState({showHint:false})}},i18n._("Hide explanation")),React.createElement(Renderer,babelHelpers.extends({},this.props.hint,{ref:"hints-renderer",apiOptions:n,linterContext:this.props.linterContext}))):React.createElement("div",{onClick:function e(){return t.setState({showHint:true})},className:css(styles.showHintLink)},i18n._("Explain"))),n.isMobile&&o!==ANSWER_BAR_STATES.HIDDEN&&React.createElement(GradedGroupAnswerBar,{apiOptions:n,answerBarState:o,onCheckAnswer:this._checkAnswer,onNextQuestion:this.props.onNextQuestion}))}
return t}(React.Component)
GradedGroup.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:ApiOptions.propTypes,content:PropTypes.string,hasHint:PropTypes.bool,hint:PropTypes.object,images:PropTypes.object,inGradedGroupSet:PropTypes.bool,onBlur:PropTypes.func,onFocus:PropTypes.func,onNextQuestion:PropTypes.func,title:PropTypes.string,trackInteraction:PropTypes.func.isRequired,widgets:PropTypes.object,linterContext:linterContextProps})
GradedGroup.defaultProps={title:"",content:"",widgets:{},images:{},hint:null,hasHint:false,linterContext:linterContextDefault}
var _initialiseProps=function e(){var t=this
this.state={status:GRADING_STATUSES.ungraded,showHint:false,message:"",answerBarState:ANSWER_BAR_STATES.HIDDEN}
this.change=function(){for(var e=arguments.length,r=Array(e),n=0;n<e;n++){r[n]=arguments[n]}return Changeable.change.apply(t,r)}
this._onInteractWithWidget=function(e){t.setState({status:GRADING_STATUSES.ungraded,message:""})
if(t.refs.renderer){t.change("widgets",t.props.widgets)
var r=t.refs.renderer.emptyWidgets()
var n=r.length===0
var s=t.state.answerBarState
t.setState({answerBarState:getNextState(s,n)})}}
this._checkAnswer=function(){t.refs.renderer.showRationalesForCurrentlySelectedChoices()
var e=t.refs.renderer.score()
var r=void 0
var n=void 0
if(e.type==="points"){r=e.total===e.earned?GRADING_STATUSES.correct:GRADING_STATUSES.incorrect
n=e.message||""}else{r=GRADING_STATUSES.invalid
n=e.message?INVALID_MESSAGE_PREFIX+" "+e.message:INVALID_MESSAGE_PREFIX+" "+DEFAULT_INVALID_MESSAGE}t.setState({status:r,message:n,answerBarState:r==="correct"?ANSWER_BAR_STATES.CORRECT:ANSWER_BAR_STATES.INCORRECT})
t.props.trackInteraction({status:r})}
this.getInputPaths=function(){return t.refs.renderer.getInputPaths()}
this.setInputValue=function(e,r,n){return t.refs.renderer.setInputValue(e,r,n)}
this.getAcceptableFormatsForInputPath=function(e){return t.refs.renderer.getAcceptableFormatsForInputPath(e)}
this.focus=function(){return t.refs.renderer.focus()}
this.focusInputPath=function(e){t.refs.renderer.focusPath(e)}
this.blurInputPath=function(e){t.refs.renderer.blurPath(e)}}
var traverseChildWidgets=function e(t,r){return _.extend({},t,r(t))}
module.exports={name:"graded-group",displayName:"Graded group (articles only)",widget:GradedGroup,traverseChildWidgets:traverseChildWidgets,hidden:false,tracking:"all",isLintable:true}
var styles=StyleSheet.create({gradedGroupInSet:{marginLeft:0,paddingLeft:0},gradedGroup:{borderTop:"1px solid "+gray76,borderBottom:"1px solid "+gray76,backgroundColor:tableBackgroundAccent,marginLeft:negativePhoneMargin,marginRight:negativePhoneMargin,paddingBottom:phoneMargin,paddingLeft:phoneMargin,paddingRight:phoneMargin,paddingTop:10,width:"auto"},showHintLink:{marginTop:20,color:kaGreen,cursor:"pointer"},explanationTitle:{marginTop:20,color:kaGreen,marginBottom:10,cursor:"pointer"},title:{fontSize:12,color:gray76,textTransform:"uppercase",marginBottom:11,letterSpacing:.8}})

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/graded-group-set.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var KA=require("../../shared-package/ka.js")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var GradedGroup=require("./graded-group.jsx").widget
var _require2=require("../../perseus-all-package/styles/constants.js"),grayLight=_require2.grayLight,gray76=_require2.gray76,tableBackgroundAccent=_require2.tableBackgroundAccent,kaGreen=_require2.kaGreen,phoneMargin=_require2.phoneMargin,negativePhoneMargin=_require2.negativePhoneMargin
var _require3=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require3.linterContextProps,linterContextDefault=_require3.linterContextDefault
var i18n=require("../../shared-package/i18n.js")
var Indicators=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this
var t=[]
var n=function e(n){t.push(React.createElement("div",{key:n,className:css(styles.indicator,n===r.props.currentGroup&&styles.selectedIndicator),onClick:function e(){return r.props.onChangeCurrentGroup(n)}}))}
for(var a=0;a<this.props.numGroups;a++){n(a)}return React.createElement("div",{className:css(styles.indicatorContainer)},t)}
return r}(React.Component)
Indicators.propTypes={currentGroup:PropTypes.number.isRequired,numGroups:PropTypes.number.isRequired,onChangeCurrentGroup:PropTypes.func.isRequired}
var GradedGroupSet=function(e){babelHelpers.inherits(r,e)
function r(){var t,n,a
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,i=Array(s),o=0;o<s;o++){i[o]=arguments[o]}return a=(t=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),n),_initialiseProps.call(n),t),babelHelpers.possibleConstructorReturn(n,a)}r.prototype.shouldComponentUpdate=function e(r,t){return r!==this.props||t!==this.state}
r.prototype.render=function e(){var r=this
if(this.inTranslationEditorContext(this.props,this.state)&&this.props.gradedGroups.length>1){return React.createElement("div",{className:css(styles.container)},this.props.gradedGroups.map(function(e,t){return React.createElement(GradedGroup,babelHelpers.extends({key:t},r.props,e,{inGradedGroupSet:false,linterContext:r.props.linterContext}))}))}var t=this.props.gradedGroups[this.state.currentGroup]
if(!t){return React.createElement("span",null,i18n.doNotTranslate("No current group..."))}var n=this.props.gradedGroups.length
var a=this.state.currentGroup<n-1?this.handleNextQuestion:null
return React.createElement("div",{className:css(styles.container)},React.createElement("div",{className:css(styles.top)},React.createElement("div",{className:css(styles.title)},t.title),React.createElement("div",{className:css(styles.spacer)}),React.createElement(Indicators,{numGroups:n,currentGroup:this.state.currentGroup,onChangeCurrentGroup:function e(t){return r.setState({currentGroup:t})}})),React.createElement(GradedGroup,babelHelpers.extends({key:this.state.currentGroup,ref:function e(t){return r._childGroup=t}},this.props,t,{inGradedGroupSet:true,title:null,onNextQuestion:a,linterContext:this.props.linterContext})))}
return r}(React.Component)
GradedGroupSet.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:ApiOptions.propTypes,gradedGroups:PropTypes.array,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps})
GradedGroupSet.defaultProps={gradedGroups:[],linterContext:linterContextDefault}
var _initialiseProps=function e(){var r=this
this.state={currentGroup:0}
this.change=function(){for(var e=arguments.length,t=Array(e),n=0;n<e;n++){t[n]=arguments[n]}return Changeable.change.apply(r,t)}
this.getInputPaths=function(){return r._childGroup.getInputPaths()}
this.setInputValue=function(e,t,n){return r._childGroup.setInputValue(e,t,n)}
this.getAcceptableFormatsForInputPath=function(e){return r._childGroup.getAcceptableFormatsForInputPath(e)}
this.focus=function(){return r._childGroup.focus()}
this.focusInputPath=function(e){r._childGroup.focusInputPath(e)}
this.blurInputPath=function(e){r._childGroup.blurInputPath(e)}
this.handleNextQuestion=function(){var e=r.state.currentGroup
var t=r.props.gradedGroups.length
if(e<t-1){r.setState({currentGroup:e+1})}}
this.inTranslationEditorContext=function(e,r){return typeof KA!=="undefined"&&KA.language==="en-pt"}}
var traverseChildWidgets=function e(r,t){return{groups:r.gradedGroups.map(t)}}
module.exports={name:"graded-group-set",displayName:"Graded group set (articles only)",widget:GradedGroupSet,traverseChildWidgets:traverseChildWidgets,hidden:false,tracking:"all",isLintable:true}
var styles=StyleSheet.create({top:{display:"flex",flexDirection:"row"},spacer:{flex:1},title:{fontSize:12,color:gray76,textTransform:"uppercase",marginBottom:11,letterSpacing:.8},indicatorContainer:{display:"flex",flexDirection:"row"},indicator:{width:10,height:10,borderRadius:5,backgroundColor:grayLight,marginLeft:5,cursor:"pointer"},selectedIndicator:{backgroundColor:kaGreen},container:{borderTop:"1px solid "+gray76,borderBottom:"1px solid "+gray76,backgroundColor:tableBackgroundAccent,marginLeft:negativePhoneMargin,marginRight:negativePhoneMargin,paddingBottom:phoneMargin,paddingLeft:phoneMargin,paddingRight:phoneMargin,paddingTop:10,width:"auto"}})

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/group.jsx", function(require, module, exports) {
var classNames=require("classnames")
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var _require=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require.linterContextProps,linterContextDefault=_require.linterContextDefault
var Group=function(e){babelHelpers.inherits(r,e)
function r(){var t,n,s
babelHelpers.classCallCheck(this,r)
for(var i=arguments.length,o=Array(i),a=0;a<i;a++){o[a]=arguments[a]}return s=(t=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),n),_initialiseProps.call(n),t),babelHelpers.possibleConstructorReturn(n,s)}r.prototype.componentDidMount=function e(){this.forceUpdate()}
r.prototype.render=function e(){var r=this
var t=_.extend({},ApiOptions.defaults,this.props.apiOptions,{onFocusChange:function e(t,n){if(n){r.props.onBlur(n)}if(t){r.props.onFocus(t)}}})
var n=_.indexOf(this.props.findWidgets("group"),this)
var s=this.props.apiOptions.groupAnnotator(n,this.props.widgetId)
var i=function e(t){if(r.refs.renderer){r.change("widgets",r.refs.renderer.props.widgets)}}
var o=this.refs.renderer&&this.refs.renderer.score()
var a=o&&o.type!=="invalid"
var p=o&&o.type==="invalid"
return React.createElement("div",{className:classNames({"perseus-group":true,"perseus-group-valid-answer":a,"perseus-group-invalid-answer":p})},s,React.createElement(Renderer,babelHelpers.extends({},this.props,{ref:"renderer",apiOptions:t,findExternalWidgets:this.props.findWidgets,reviewMode:!!this.props.reviewModeRubric,onInteractWithWidget:i,linterContext:this.props.linterContext})),this.props.icon&&React.createElement("div",{className:"group-icon"},this.props.icon))}
return r}(React.Component)
Group.propTypes=babelHelpers.extends({},Changeable.propTypes,{content:PropTypes.string,widgets:PropTypes.object,images:PropTypes.object,icon:PropTypes.object,reviewModeRubric:PropTypes.object,linterContext:linterContextProps})
Group.defaultProps={content:"",widgets:{},images:{},icon:null,linterContext:linterContextDefault}
var _initialiseProps=function e(){var r=this
this.change=function(){for(var e=arguments.length,t=Array(e),n=0;n<e;n++){t[n]=arguments[n]}return Changeable.change.apply(r,t)}
this.getUserInput=function(){return r.refs.renderer.getUserInput()}
this.getSerializedState=function(){return r.refs.renderer.getSerializedState()}
this.restoreSerializedState=function(e,t){r.refs.renderer.restoreSerializedState(e,t)
return null}
this.simpleValidate=function(e){return r.refs.renderer.score()}
this.getInputPaths=function(){return r.refs.renderer.getInputPaths()}
this.setInputValue=function(e,t,n){return r.refs.renderer.setInputValue(e,t,n)}
this.getAcceptableFormatsForInputPath=function(e){return r.refs.renderer.getAcceptableFormatsForInputPath(e)}
this.getRenderer=function(){return r.refs.renderer}
this.focus=function(){return r.refs.renderer.focus()}
this.focusInputPath=function(e){r.refs.renderer.focusPath(e)}
this.blurInputPath=function(e){r.refs.renderer.blurPath(e)}
this.showRationalesForCurrentlySelectedChoices=function(){r.refs.renderer.showRationalesForCurrentlySelectedChoices()}}
var traverseChildWidgets=function e(r,t){return _.extend({},r,t(r))}
module.exports={name:"group",displayName:"Group (SAT only)",widget:Group,traverseChildWidgets:traverseChildWidgets,hidden:false,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/iframe.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var $=require("jquery")
var KA=require("../../shared-package/ka.js")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var WidgetJsonifyDeprecated=require("../../perseus-all-package/mixins/widget-jsonify-deprecated.jsx")
var updateQueryString=require("../../perseus-all-package/util.js").updateQueryString
var Iframe=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,n
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,i=Array(s),o=0;o<s;o++){i[o]=arguments[o]}return n=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),a),_initialiseProps.call(a),t),babelHelpers.possibleConstructorReturn(a,n)}r.prototype.componentDidMount=function e(){$(window).on("message",this.handleMessageEvent)}
r.prototype.componentWillUnmount=function e(){$(window).off("message",this.handleMessageEvent)}
r.prototype.render=function e(){var r={width:String(this.props.width),height:String(this.props.height)}
Object.entries(r).forEach(function(e){var t=e[0],a=e[1]
if(!a.endsWith("%")&&!a.endsWith("px")){r[t]=a+"px"}})
var t=this.props.url
if(t&&t.length&&t.indexOf("http")!==0){t="https://www.khanacademy.org/computer-programming/program/"+t+"/embedded?buttons=no&embed=yes&editor=no&author=no"
t=updateQueryString(t,"width",this.props.width)
t=updateQueryString(t,"height",this.props.height)
t=updateQueryString(t,"origin",window.location.origin)}if(typeof KA!=="undefined"&&KA.isZeroRated){if(t.match(/https?:\/\/[^\/]*khanacademy.org/)){if(!t.match(/zero.khanacademy.org/)){t=t.replace("khanacademy.org","zero.khanacademy.org")}}else{t="/zero/external-link?context=iframe&url="+encodeURIComponent(t)}}if(this.props.settings){var a={}
_.each(this.props.settings,function(e){if(e.name&&e.value){a[e.name]=e.value}})
t=updateQueryString(t,"settings",JSON.stringify(a))}var n="allow-same-origin allow-scripts"
n+=" allow-top-navigation"
return React.createElement("iframe",{sandbox:n,style:r,src:t,allowFullScreen:this.props.allowFullScreen})}
return r}(React.Component)
Iframe.propTypes=babelHelpers.extends({},Changeable.propTypes,{width:PropTypes.oneOfType([PropTypes.string,PropTypes.number]),height:PropTypes.oneOfType([PropTypes.string,PropTypes.number]),url:PropTypes.string,settings:PropTypes.array,status:PropTypes.oneOf(["incomplete","incorrect","correct"]),message:PropTypes.string,allowFullScreen:PropTypes.bool,allowTopNavigation:PropTypes.bool})
Iframe.defaultProps={status:"incomplete",message:null,allowFullScreen:false,allowTopNavigation:false}
var _initialiseProps=function e(){var r=this
this.getUserInput=function(){return WidgetJsonifyDeprecated.getUserInput.call(r)}
this.handleMessageEvent=function(e){var t={}
try{t=JSON.parse(e.originalEvent.data)}catch(e){return}if(_.isUndefined(t.testsPassed)){return}var a=t.testsPassed?"correct":"incorrect"
r.change({status:a,message:t.message})}
this.change=function(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++){t[a]=arguments[a]}return Changeable.change.apply(r,t)}
this.simpleValidate=function(e){return Iframe.validate(r.getUserInput(),e)}}
_.extend(Iframe,{validate:function e(r,t){if(r.status==="correct"){return{type:"points",earned:1,total:1,message:r.message||null}}else if(r.status==="incorrect"){return{type:"points",earned:0,total:1,message:r.message||null}}else{return{type:"invalid",message:"Keep going, you're not there yet!"}}}})
module.exports={name:"iframe",displayName:"Iframe",widget:Iframe,hidden:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/image.jsx", function(require, module, exports) {
var _caption
var classNames=require("classnames")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var React=require("react")
var PropTypes=require("prop-types")
var createReactClass=require("create-react-class")
var _=require("underscore")
var $=require("jquery")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var _require2=require("../../perseus-all-package/styles/constants.js"),baseUnitPx=_require2.baseUnitPx
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var mediaQueries=require("../../perseus-all-package/styles/media-queries.js")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var SvgImage=require("../../perseus-all-package/components/svg-image.jsx")
var _require3=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require3.linterContextProps,linterContextDefault=_require3.linterContextDefault
var defaultBoxSize=400
var defaultRange=[0,10]
var defaultBackgroundImage={url:null,width:0,height:0}
var supportedAlignments=["block","float-left","float-right","full-width"]
var editorAlignments=["block","full-width"]
var DEFAULT_ALIGNMENT="block"
var ImageWidget=createReactClass({displayName:"ImageWidget",propTypes:babelHelpers.extends({},Changeable.propTypes,{alignment:PropTypes.oneOf(supportedAlignments),alt:PropTypes.string,apiOptions:ApiOptions.propTypes,backgroundImage:PropTypes.shape({url:PropTypes.string,width:PropTypes.number,height:PropTypes.number}),box:PropTypes.arrayOf(PropTypes.number),caption:PropTypes.string,labels:PropTypes.arrayOf(PropTypes.shape({content:PropTypes.string,coordinates:PropTypes.arrayOf(PropTypes.number),alignment:PropTypes.string})),range:PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.number)),title:PropTypes.string,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps}),statics:{styles:StyleSheet.create({caption:(_caption={display:"inline-block",marginTop:baseUnitPx,maxWidth:640},_caption[mediaQueries.lgOrSmaller]={maxWidth:540},_caption[mediaQueries.smOrSmaller]={maxWidth:450},_caption)})},getDefaultProps:function e(){return{alignment:DEFAULT_ALIGNMENT,title:"",range:[defaultRange,defaultRange],box:[defaultBoxSize,defaultBoxSize],backgroundImage:defaultBackgroundImage,labels:[],alt:"",caption:"",linterContext:linterContextDefault}},render:function e(){var t
var r
var a=this.props.apiOptions
var s=this.props.backgroundImage
if(s.url){t=React.createElement(SvgImage,{src:s.url,alt:this.props.alt,width:s.width,height:s.height,preloader:a.imagePreloader,extraGraphie:{box:this.props.box,range:this.props.range,labels:this.props.labels},trackInteraction:this.props.trackInteraction,zoomToFullSizeOnMobile:a.isMobile,constrainHeight:a.isMobile,allowFullBleed:a.isMobile})}if(this.props.alt){r=React.createElement("span",{className:"perseus-sr-only"},React.createElement(Renderer,{content:this.props.alt,apiOptions:a,linterContext:this.props.linterContext}))}if(a.isMobile){var i
if(this.props.title||this.props.caption){var n=this.props.title
if(n){if(this.props.caption&&!/[.?!"']\s*$/.test(n)){n+="."}n="**"+n+"** "}var p=classNames({"perseus-image-caption":true,"has-title":!!n})
var l=this.props.alignment
var o=l==="block"||l==="full-width"
var c=o?null:"0 !important"
i=React.createElement("div",{className:p},React.createElement("div",{className:css(ImageWidget.styles.caption),style:{minWidth:c}},React.createElement(Renderer,{content:n+this.props.caption,apiOptions:a,linterContext:this.props.linterContext})))}return React.createElement("div",{className:"perseus-image-widget"},t,r,i)}else{var u
var g
if(this.props.title){u=React.createElement("div",{className:"perseus-image-title"},React.createElement(Renderer,{content:this.props.title,apiOptions:a,linterContext:this.props.linterContext}))}if(this.props.caption){g=React.createElement("div",{className:"perseus-image-caption"},React.createElement(Renderer,{content:this.props.caption,apiOptions:a,linterContext:this.props.linterContext}))}return React.createElement("div",{className:"perseus-image-widget"},u,t,r,g)}},change:function e(){for(var t=arguments.length,r=Array(t),a=0;a<t;a++){r[a]=arguments[a]}return Changeable.change.apply(this,r)},getUserInput:function e(){return null},simpleValidate:function e(t){return ImageWidget.validate(this.getUserInput(),t)},focus:$.noop})
_.extend(ImageWidget,{validate:function e(t,r){return{type:"points",earned:0,total:0,message:null}}})
module.exports={name:"image",accessible:function e(t){var r=t.backgroundImage
return!(r&&r.url&&!t.alt)},defaultAlignment:DEFAULT_ALIGNMENT,supportedAlignments:editorAlignments,displayName:"Image",widget:ImageWidget,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/interaction.jsx", function(require, module, exports) {
var _util=require("../../perseus-all-package/util.js")
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var KAS=require("../../../third_party/javascript-khansrc/kas/kas.js")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var Graphie=require("../../perseus-all-package/components/graphie.jsx")
var Label=Graphie.Label
var Line=Graphie.Line
var MovablePoint=Graphie.MovablePoint
var MovableLine=Graphie.MovableLine
var Plot=Graphie.Plot
var PlotParametric=Graphie.PlotParametric
var Point=Graphie.Point
var Rect=Graphie.Rect
var kvector=require("kmath").vector
var KAShashFunc=function t(e,a){a=a||{}
var r=e+"||"+a.decimal_separatpr+"||"
var n=a.functions
var o=n?n.length:0
for(var i=0;i<o;i++){r+=n[i]+"|"}return r}
var _parseCache=Object.create(null)
var KASparse=function t(e,a){var r=KAShashFunc(e,a)
var n=_parseCache[r]
if(n){return n}n=KAS.parse(e,a)
_parseCache[r]=n
return n}
var _compileCache=Object.create(null)
var KAScompile=function t(e,a){var r=KAShashFunc(e,a)
var n=_compileCache[r]
if(n){return n}var o=KAS.parse(e,a).expr
n=o?o.compile():function(){return 0}
_compileCache[r]=n
return n}
var defaultInteractionProps={graph:{box:[400,400],labels:["x","y"],range:[[-10,10],[-10,10]],tickStep:[1,1],gridStep:[1,1],markings:"graph"},elements:[]}
var Interaction=function(t){babelHelpers.inherits(e,t)
function e(){var a,r,n
babelHelpers.classCallCheck(this,e)
for(var o=arguments.length,i=Array(o),s=0;s<o;s++){i[s]=arguments[s]}return n=(a=(r=babelHelpers.possibleConstructorReturn(this,t.call.apply(t,[this].concat(i))),r),_initialiseProps.call(r),a),babelHelpers.possibleConstructorReturn(r,n)}e.prototype.UNSAFE_componentWillReceiveProps=function t(e){this.setState({variables:this._getInitialVariables(e.elements),functions:this._getInitialFunctions(e.elements)})}
e.prototype.render=function t(){var e=this.props.graph.range
var a=this.props.graph.labels
if(this.props.graph.markings==="graph"){a=this.props.graph.labels.map(function(t){return t.startsWith("$")&&t.endsWith("$")?t.slice(1,-1):t})}return React.createElement(Graphie,{box:this.props.graph.box,range:this.props.graph.range,options:this.props.graph,setup:this._setupGraphie,setDrawingAreaAvailable:this.props.apiOptions.setDrawingAreaAvailable},this.props.graph.markings==="graph"&&React.createElement(Label,{coord:[0,e[1][1]],text:a[1],direction:"above"}),this.props.graph.markings==="graph"&&React.createElement(Label,{coord:[e[0][1],0],text:a[0],direction:"right"}),_.map(this.props.elements,function(t,e){var a=this
if(t.type==="point"){return React.createElement(Point,{key:t.key,coord:[this._eval(t.options.coordX),this._eval(t.options.coordY)],color:t.options.color})}else if(t.type==="line"){var r=[this._eval(t.options.startX),this._eval(t.options.startY)]
var n=[this._eval(t.options.endX),this._eval(t.options.endY)]
return React.createElement(Line,{key:t.key,start:r,end:n,style:{stroke:t.options.color,strokeWidth:t.options.strokeWidth,strokeDasharray:t.options.strokeDasharray,arrows:t.options.arrows}})}else if(t.type==="movable-point"){var o=[function(e){var r=Math.max(a._eval(t.options.constraintXMin),Math.min(a._eval(t.options.constraintXMax),e[0]))
var n=Math.max(a._eval(t.options.constraintYMin),Math.min(a._eval(t.options.constraintYMax),e[1]))
return[r,n]}]
if(t.options.constraint==="snap"){o.push(MovablePoint.constraints.snap(t.options.snap))}else if(t.options.constraint==="x"){o.push(function(e){return[a._eval(t.options.constraintFn,{y:e[1]}),e[1]]})}else if(t.options.constraint==="y"){o.push(function(e){return[e[0],a._eval(t.options.constraintFn,{x:e[0]})]})}return React.createElement(MovablePoint,{key:t.key,coord:[this.state.variables["x_"+t.options.varSubscript],this.state.variables["y_"+t.options.varSubscript]],constraints:o,foo_x:t.options.constraint,foo_y:t.options.constraintFn,foo_z:t.options.snap,onMove:_.partial(this._updatePointLocation,t.options.varSubscript)})}else if(t.type==="movable-line"){var o=[function(e){var r=Math.max(a._eval(t.options.constraintXMin),Math.min(a._eval(t.options.constraintXMax),e[0]))
var n=Math.max(a._eval(t.options.constraintYMin),Math.min(a._eval(t.options.constraintYMax),e[1]))
return[r,n]}]
if(t.options.constraint==="snap"){o.push(MovablePoint.constraints.snap(t.options.snap))}else if(t.options.constraint==="x"){o.push(function(e){return[a._eval(t.options.constraintFn,{y:e[1]}),e[1]]})}else if(t.options.constraint==="y"){o.push(function(e){return[e[0],a._eval(t.options.constraintFn,{x:e[0]})]})}var r=[this.state.variables["x_"+t.options.startSubscript],this.state.variables["y_"+t.options.startSubscript]]
var n=[this.state.variables["x_"+t.options.endSubscript],this.state.variables["y_"+t.options.endSubscript]]
return React.createElement(MovableLine,{key:t.key,constraints:o,onMove:_.bind(this._updateLineLocation,this,t.options),foo_x:t.options.constraint,foo_y:t.options.constraintFn,foo_z:t.options.snap},React.createElement(MovablePoint,{coord:r,static:true,normalStyle:{stroke:"none",fill:"none"}}),React.createElement(MovablePoint,{coord:n,static:true,normalStyle:{stroke:"none",fill:"none"}}))}else if(t.type==="function"){var i=function e(r){return a._eval(t.options.value,{x:r})}
var s=_.without(this._extractVars(KASparse(t.options.value).expr),"x")
var p=_.object(s,_.map(s,function(t){return a.state.variables[t]}))
var l=[this._eval(t.options.rangeMin,this.state.variables),this._eval(t.options.rangeMax,this.state.variables)]
return React.createElement(Plot,{key:t.key,fn:i,foo_fn:t.options.value,foo_varvalues:p,range:l,style:{stroke:t.options.color,strokeWidth:t.options.strokeWidth,strokeDasharray:t.options.strokeDasharray,plotPoints:100}})}else if(t.type==="parametric"){var i=function e(r){return[a._eval(t.options.x,{t:r}),a._eval(t.options.y,{t:r})]}
var s=_.without(this._extractVars(KASparse(t.options.x).expr).concat(this._extractVars(KASparse(t.options.y).expr)),"t")
var p=_.object(s,_.map(s,function(t){return a.state.variables[t]}))
var l=[this._eval(t.options.rangeMin,this.state.variables),this._eval(t.options.rangeMax,this.state.variables)]
return React.createElement(PlotParametric,{key:t.key,fn:i,foo_fnx:t.options.x,foo_fny:t.options.y,foo_varvalues:p,range:l,style:{stroke:t.options.color,strokeWidth:t.options.strokeWidth,strokeDasharray:t.options.strokeDasharray,plotPoints:100}})}else if(t.type==="label"){var c=[this._eval(t.options.coordX),this._eval(t.options.coordY)]
return React.createElement(Label,{key:e+1,coord:c,text:(0,_util.unescapeMathMode)(t.options.label),style:{color:t.options.color}})}else if(t.type==="rectangle"){return React.createElement(Rect,{key:e+1,x:this._eval(t.options.coordX),y:this._eval(t.options.coordY),width:_.max([this._eval(t.options.width),0]),height:_.max([this._eval(t.options.height),0]),style:{stroke:"none",fill:t.options.color}})}},this))}
return e}(React.Component)
Interaction.propTypes=babelHelpers.extends({},Changeable.propTypes,{graph:PropTypes.object,elements:PropTypes.arrayOf(PropTypes.object)})
Interaction.defaultProps=defaultInteractionProps
var _initialiseProps=function t(){var e=this
this._getInitialVariables=function(t){var a={}
_.each(_.where(t,{type:"movable-point"}),function(t){var e=t.options.varSubscript
var r=KASparse(t.options.startX||"0").expr
var n=KASparse(t.options.startY||"0").expr
var o=0
var i=0
if(r){o=r.eval({})||0}if(n){i=n.eval({})||0}a["x_"+e]=o
a["y_"+e]=i},e)
_.each(_.where(t,{type:"movable-line"}),function(t){var e=t.options.startSubscript
var r=t.options.endSubscript
var n=KASparse(t.options.startX||"0").expr
var o=KASparse(t.options.startY||"0").expr
var i=KASparse(t.options.endX||"0").expr
var s=KASparse(t.options.endY||"0").expr
var p=0
var l=0
var c=0
var h=0
if(n){p=n.eval({})||0}if(o){l=o.eval({})||0}if(i){c=i.eval({})||0}if(s){h=s.eval({})||0}a["x_"+e]=p
a["y_"+e]=l
a["x_"+r]=c
a["y_"+r]=h},e)
_.each(_.where(t,{type:"function"}),function(t){a[t.options.funcName]=t.options.value})
return a}
this._getInitialFunctions=function(t){return _.map(_.where(t,{type:"function"}),function(t){return t.options.funcName})}
this._setupGraphie=function(t,a){t.graphInit(_.extend({},a,{grid:_.contains(["graph","grid"],e.props.graph.markings),axes:_.contains(["graph"],e.props.graph.markings),ticks:_.contains(["graph"],e.props.graph.markings),labels:_.contains(["graph"],e.props.graph.markings),labelFormat:function t(e){return"\\small{"+e+"}"},axisArrows:"<->",unityLabels:false}))}
this._updatePointLocation=function(t,a){var r=_.clone(e.state.variables)
r["x_"+t]=a[0]
r["y_"+t]=a[1]
e.setState({variables:r})
e.props.trackInteraction()}
this._updateLineLocation=function(t,a){var r=e._eval("("+t.endX+")-("+t.startX+")")
var n=e._eval("("+t.endY+")-("+t.startY+")")
var o=kvector.add(a,[r,n])
var i=_.clone(e.state.variables)
i["x_"+t.startSubscript]=a[0]
i["y_"+t.startSubscript]=a[1]
i["x_"+t.endSubscript]=o[0]
i["y_"+t.endSubscript]=o[1]
e.setState({variables:i})
e.props.trackInteraction()}
this._eval=function(t,a){var r=KAScompile(t,{functions:e.state.functions})
var n=_.extend({},e.state.variables,a)
_.each(_.keys(n),function(t){if(_.isString(n[t])){var a=KAScompile(n[t],{functions:e.state.functions})
n[t]=function(t){return a(_.extend({},n,{x:t}))}}})
return r(n)||0}
this._extractVars=function(t){if(t==null){return[]}var a=[]
_.each(t.args(),function(t){if(t&&t.constructor.name==="Expr"){a=a.concat(this._extractVars(t))}},e)
if(t.name()==="Var"){a.push(t.prettyPrint())}return a}
this.change=function(){for(var t=arguments.length,a=Array(t),r=0;r<t;r++){a[r]=arguments[r]}return Changeable.change.apply(e,a)}
this.getUserInput=function(){return{}}
this.simpleValidate=function(t){return Interaction.validate(e.getUserInput(),t)}
this.state={variables:this._getInitialVariables(this.props.elements),functions:this._getInitialFunctions(this.props.elements)}}
_.extend(Interaction,{validate:function t(e,a){return{type:"points",earned:0,total:0,message:null}}})
module.exports={name:"interaction",displayName:"Interaction",widget:Interaction,transform:_.identity,hidden:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/interactive-graph.jsx", function(require, module, exports) {
var _react=require("react")
var _react2=babelHelpers.interopRequireDefault(_react)
var _propTypes=require("prop-types")
var _propTypes2=babelHelpers.interopRequireDefault(_propTypes)
var _createReactClass=require("create-react-class")
var _createReactClass2=babelHelpers.interopRequireDefault(_createReactClass)
var _underscore=require("underscore")
var _underscore2=babelHelpers.interopRequireDefault(_underscore)
var _jquery=require("jquery")
var _jquery2=babelHelpers.interopRequireDefault(_jquery)
var _kmath=require("kmath")
var _kmath2=babelHelpers.interopRequireDefault(_kmath)
var _lodash=require("../../../third_party/javascript-khansrc/lodash/lodash.js")
var _graph=require("../../perseus-all-package/components/graph.jsx")
var _graph2=babelHelpers.interopRequireDefault(_graph)
var _infoTip=require("../../perseus-all-package/components/info-tip.jsx")
var _infoTip2=babelHelpers.interopRequireDefault(_infoTip)
var _interactive=require("../../perseus-all-package/interactive2.js")
var _interactive2=babelHelpers.interopRequireDefault(_interactive)
var _numberInput=require("../../perseus-all-package/components/number-input.jsx")
var _numberInput2=babelHelpers.interopRequireDefault(_numberInput)
var _util=require("../../perseus-all-package/util.js")
var _util2=babelHelpers.interopRequireDefault(_util)
var _colors=require("../../perseus-all-package/util/colors.js")
var _colors2=babelHelpers.interopRequireDefault(_colors)
var _graphUtils=require("../../perseus-all-package/util/graph-utils.js")
var _graphUtils2=babelHelpers.interopRequireDefault(_graphUtils)
var _sizingUtils=require("../../perseus-all-package/util/sizing-utils.js")
var _sizingUtils2=babelHelpers.interopRequireDefault(_sizingUtils)
var _wrappedLine=require("../../perseus-all-package/interactive2/wrapped-line.js")
var _wrappedLine2=babelHelpers.interopRequireDefault(_wrappedLine)
var i18n=require("../../shared-package/i18n.js")
var knumber=_kmath2.default.number,kpoint=_kmath2.default.point
var containerSizeClassPropType=_sizingUtils2.default.containerSizeClassPropType,getInteractiveBoxFromSizeClass=_sizingUtils2.default.getInteractiveBoxFromSizeClass
var DeprecationMixin=_util2.default.DeprecationMixin
var TRASH_ICON_URI="https://ka-perseus-graphie.s3.amazonaws.com/b1452c0d79fd0f7ff4c3af9488474a0a0decb361.png"
var defaultBackgroundImage={url:null}
var eq=_util2.default.eq
var deepEq=_util2.default.deepEq
var UNLIMITED="unlimited"
function ccw(e,t,r){return(t[0]-e[0])*(r[1]-e[1])-(r[0]-e[0])*(t[1]-e[1])}function collinear(e,t,r){return eq(ccw(e,t,r),0)}function sign(e){if(eq(e,0)){return 0}else{return e>0?1:-1}}function defaultVal(e,t){return e==null?t:e}function pointInRect(e,t,r){return r[0]<=Math.max(e[0],t[0])&&r[0]>=Math.min(e[0],t[0])&&r[1]<=Math.max(e[1],t[1])&&r[1]>=Math.min(e[1],t[1])}function intersects(e,t){var r=[[e[0],e[1],t[0]],[e[0],e[1],t[1]],[t[0],t[1],e[0]],[t[0],t[1],e[1]]]
var n=_underscore2.default.map(r,function(e){return sign(ccw.apply(undefined,e))})
if(n[0]!==n[1]&&n[2]!==n[3]){return true}for(var a=0;a<4;a++){if(n[a]===0&&pointInRect.apply(undefined,r[a])){return true}}return false}function vector(e,t){return _underscore2.default.map(_underscore2.default.zip(e,t),function(e){return e[0]-e[1]})}function magnitude(e){return Math.sqrt(_underscore2.default.reduce(e,function(e,t){return e+Math.pow(t,2)},0))}function dotProduct(e,t){return _underscore2.default.reduce(_underscore2.default.zip(e,t),function(e,t){return e+t[0]*t[1]},0)}function sideLengths(e){var t=_underscore2.default.zip(e,rotate(e))
return _underscore2.default.map(t,function(e){return magnitude(vector.apply(undefined,e))})}function angleMeasures(e){var t=_underscore2.default.zip(rotate(e,-1),e,rotate(e,1))
var r=_underscore2.default.map(t,function(e){var t=vector(e[1],e[0])
var r=vector(e[2],e[1])
var n=Math.acos(dotProduct(t,r)/(magnitude(t)*magnitude(r)))
return sign(ccw.apply(undefined,e))>0?n:-n})
var n=_underscore2.default.reduce(r,function(e,t){return e+t},0)
return _underscore2.default.map(r,function(e){return n>0?Math.PI-e:Math.PI+e})}function similar(e,t,r){if(e.length!==t.length){return false}var n=e.length
var a=angleMeasures(e)
var o=angleMeasures(t)
var i=sideLengths(e)
var s=sideLengths(t)
for(var l=0;l<2*n;l++){var u=o.slice()
var p=s.slice()
if(l>=n){u.reverse()
p.reverse()
p=rotate(p,1)}u=rotate(u,l)
p=rotate(p,l)
if(deepEq(a,u)){var d=function(){var e=_underscore2.default.zip(i,p)
var t=_underscore2.default.map(e,function(e){return e[0]/e[1]})
var n=_underscore2.default.all(t,function(e){return eq(t[0],e)})
var a=_underscore2.default.all(e,function(e){return knumber.equal(e[0],e[1],r)})
if(n&&a){return{v:true}}}()
if((typeof d==="undefined"?"undefined":babelHelpers.typeof(d))==="object")return d.v}}return false}function leq(e,t){return e<t||eq(e,t)}function lawOfCosines(e,t,r){return Math.acos((e*e+t*t-r*r)/(2*e*t))*180/Math.PI}function canonicalSineCoefficients(e){var t=e[0]
var r=e[1]
var n=e[2]
var a=e[3]
if(t<0){t*=-1
r*=-1
n*=-1}var o=2*Math.PI
if(r<0){r*=-1
n*=-1
n+=o/2}while(n>0){n-=o}while(n<0){n+=o}return[t,r,n,a]}function rotate(e,t){t=typeof t==="undefined"?1:t%e.length
return e.slice(t).concat(e.slice(0,t))}function capitalize(e){return e.replace(/(?:^|-)(.)/g,function(e,t){return t.toUpperCase()})}function getLineEquation(e,t){if(eq(e[0],t[0])){return"x = "+e[0].toFixed(3)}else{var r=(t[1]-e[1])/(t[0]-e[0])
var n=e[1]-r*e[0]
return"y = "+r.toFixed(3)+"x + "+n.toFixed(3)}}function getLineIntersection(e,t){var r=e[0][0]
var n=e[0][1]
var a=e[1][0]
var o=e[1][1]
var i=t[0][0]
var s=t[0][1]
var l=t[1][0]
var u=t[1][1]
var p=(r-a)*(s-u)-(n-o)*(i-l)
if(Math.abs(p)<1e-9){return"Lines are parallel"}else{var d=((r*o-n*a)*(i-l)-(r-a)*(i*u-s*l))/p
var c=((r*o-n*a)*(s-u)-(n-o)*(i*u-s*l))/p
return"Intersection: ("+d.toFixed(3)+", "+c.toFixed(3)+")"}}function numSteps(e,t){return Math.floor((e[1]-e[0])/t)}var deprecatedProps={showGraph:function e(t){return{markings:t.showGraph?"graph":"none"}}}
var InteractiveGraph=(0,_createReactClass2.default)({displayName:"InteractiveGraph",propTypes:{containerSizeClass:containerSizeClassPropType.isRequired,trackInteraction:_propTypes2.default.func.isRequired},getDefaultProps:function e(){return{labels:["x","y"],range:[[-10,10],[-10,10]],step:[1,1],backgroundImage:defaultBackgroundImage,markings:"graph",showTooltips:false,showProtractor:false,showRuler:false,rulerLabel:"",rulerTicks:10,graph:{type:"linear"}}},getInitialState:function e(){return{shouldShowInstructions:this._getShouldShowInstructions()}},UNSAFE_componentWillMount:function e(){DeprecationMixin.UNSAFE_componentWillMount.call(this)},componentDidMount:function e(){this.setGraphie(this.refs.graph.graphie())},UNSAFE_componentWillReceiveProps:function e(t){if(this.isClickToAddPoints()!==this.isClickToAddPoints(t)){this.shouldResetGraphie=true
this.setState({shouldShowInstructions:this._getShouldShowInstructions(t)})}if(this.props.backgroundImage.url!==t.backgroundImage.url||this.props.backgroundImage!==t.backgroundImage||this.props.containerSizeClass!==t.containerSizeClass){this.shouldResetGraphie=true}},componentDidUpdate:function e(t,r){var n=t.graph.type
var a=this.props.graph.type
if(n!==a||t.graph.allowReflexAngles!==this.props.graph.allowReflexAngles||t.graph.angleOffsetDeg!==this.props.graph.angleOffsetDeg||t.graph.numPoints!==this.props.graph.numPoints||t.graph.numSides!==this.props.graph.numSides||t.graph.numSegments!==this.props.graph.numSegments||t.graph.showAngles!==this.props.graph.showAngles||t.graph.showSides!==this.props.graph.showSides||t.graph.snapTo!==this.props.graph.snapTo||t.graph.snapDegrees!==this.props.graph.snapDegrees){this["remove"+capitalize(n)+"Controls"]()
this["add"+capitalize(a)+"Controls"]()}if(this.shouldResetGraphie){this.resetGraphie()}},_getShouldShowInstructions:function e(t){t=t||this.props
return this.isClickToAddPoints(t)&&(t.graph.coords==null||t.graph.coords.length===0)},deprecatedProps:deprecatedProps,setGraphie:function e(t){this.graphie=t
this.setupGraphie()},handleAddPointsMouseDown:function e(t){if(!this.isClickToAddPoints()){throw new Error("handleAddPointsClick should not be registered"+"when isClickToAddPoints() is false")}if(!this.isCoordInTrash(t)){var r=void 0
if(this.props.graph.type==="point"){r=this.createPointForPointsType(t,this.points.length)
if(!r.constrain()){r.remove()
return}this.points.push(r)
var n=this.points.length-1
this.points[n].grab(t)
this.updateCoordsFromPoints()}else if(this.props.graph.type==="polygon"){if(this.polygon.closed()){return}r=this.createPointForPolygonType(t,this.points.length)
this.points.push(r)
var a=this.points.length-1
this.points[a].grab(t)
this.updatePolygon()}this.setState({shouldShowInstructions:false})}},resetGraphie:function e(){this.shouldResetGraphie=false
this.parabola=null
this.sinusoid=null
this.refs.graph.reset()},setupGraphie:function e(){this.setTrashCanVisibility(0)
if(this.isClickToAddPoints()){this.setTrashCanVisibility(.5)}if(this.props.apiOptions.isMobile){this.horizHairline=new _wrappedLine2.default(this.graphie,[0,0],[0,0],{normalStyle:{strokeWidth:1}})
this.horizHairline.attr({stroke:_colors2.default.INTERACTIVE})
this.horizHairline.hide()
this.vertHairline=new _wrappedLine2.default(this.graphie,[0,0],[0,0],{normalStyle:{strokeWidth:1}})
this.vertHairline.attr({stroke:_colors2.default.INTERACTIVE})
this.vertHairline.hide()}var t=this.props.graph.type
this["add"+capitalize(t)+"Controls"]()},showHairlines:function e(t){if(this.props.apiOptions.isMobile&&this.props.markings!=="none"){this.horizHairline.moveTo([this.props.range[0][0],t[1]],[this.props.range[0][1],t[1]])
this.horizHairline.show()
this.vertHairline.moveTo([t[0],this.props.range[1][0]],[t[0],this.props.range[1][1]])
this.vertHairline.show()}},hideHairlines:function e(){if(this.props.apiOptions.isMobile){this.horizHairline.hide()
this.vertHairline.hide()}},setTrashCanVisibility:function e(t){var r=this.graphie
if(knumber.equal(t,0)){if(this.trashCan){this.trashCan.remove()
this.trashCan=null}}else if(!this.props.apiOptions.isMobile){if(!this.trashCan){this.trashCan=r.raphael.image(TRASH_ICON_URI,r.xpixels-40,r.ypixels-40,40,40)}this.trashCan.attr({opacity:t})}},isClickToAddPoints:function e(t){t=t||this.props
return t.graph.type==="point"&&t.graph.numPoints===UNLIMITED||t.graph.type==="polygon"&&t.graph.numSides===UNLIMITED},_lineStroke:function e(){return this.props.isMobile?{"stroke-width":3}:{}},addLine:function e(t){var r=this
var n=this
var a=n.graphie
var o=InteractiveGraph.getLineCoords(n.props.graph,n.props)
var i=n.points=_underscore2.default.map(o,function(e){return _interactive2.default.addMaybeMobileMovablePoint(r,{coord:e,constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap()],onMove:function e(){var t=_underscore2.default.extend({},n.props.graph,{coords:_underscore2.default.invoke(i,"coord")})
n.onChange({graph:t})}})})
var s={points:i,static:true,normalStyle:babelHelpers.extends({stroke:this.props.apiOptions.isMobile?_colors2.default.BLUE_C:_colors2.default.INTERACTIVE},this._lineStroke())}
if(t==="line"){s.extendLine=true}else if(t==="ray"){s.extendRay=true}n.line=_interactive2.default.addMovableLine(a,s)
i[0].listen("constraints","isLine",function(e){return!kpoint.equal(e,i[1].coord())})
i[1].listen("constraints","isLine",function(e){return!kpoint.equal(e,i[0].coord())})},removeLine:function e(){_underscore2.default.invoke(this.points,"remove")
this.line.remove()},addLinearControls:function e(){this.addLine("line")},removeLinearControls:function e(){this.removeLine()},addQuadraticControls:function e(){var t=this
var r=this.props.graph.coords
if(!r){r=InteractiveGraph.defaultQuadraticCoords(this.props)}var n=function e(){var r=_underscore2.default.extend({},t.props.graph,{coords:[a.coord(),o.coord(),i.coord()]})
t.onChange({graph:r})
t.updateQuadratic()}
var a=this.pointA=_interactive2.default.addMaybeMobileMovablePoint(this,{coord:r[0],constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){return!a||e[0]!==o.coord()[0]&&e[0]!==i.coord()[0]}],onMove:n})
var o=this.pointB=_interactive2.default.addMaybeMobileMovablePoint(this,{coord:r[1],constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){return!o||e[0]!==a.coord()[0]&&e[0]!==i.coord()[0]}],onMove:n})
var i=this.pointC=_interactive2.default.addMaybeMobileMovablePoint(this,{coord:r[2],constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){return!i||e[0]!==a.coord()[0]&&e[0]!==o.coord()[0]}],onMove:n})
this.updateQuadratic()},updateQuadratic:function e(){var t=InteractiveGraph.getCurrentQuadraticCoefficients(this.props)
if(!t){return}var r=t[0]
var n=t[1]
var a=t[2]
if(this.parabola){var o=this.graphie.svgParabolaPath(r,n,a)
this.parabola.attr({path:o})}else{this.parabola=this.graphie.parabola(r,n,a)
this.parabola.attr(babelHelpers.extends({stroke:this.props.apiOptions.isMobile?_colors2.default.BLUE_C:_colors2.default.DYNAMIC},this._lineStroke()))
this.parabola.toBack()}},removeQuadraticControls:function e(){this.pointA.remove()
this.pointB.remove()
this.pointC.remove()
if(this.parabola){this.parabola.remove()
this.parabola=null}},addSinusoidControls:function e(){var t=this
var r=this.props.graph.coords
if(!r){r=InteractiveGraph.defaultSinusoidCoords(this.props)}var n=function e(){var r=_underscore2.default.extend({},t.props.graph,{coords:[a.coord(),o.coord()]})
t.onChange({graph:r})
t.updateSinusoid()}
var a=this.pointA=_interactive2.default.addMaybeMobileMovablePoint(this,{coord:r[0],constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){return!a||e[0]!==o.coord()[0]}],onMove:n})
var o=this.pointB=_interactive2.default.addMaybeMobileMovablePoint(this,{coord:r[1],constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){return!a||e[0]!==a.coord()[0]}],onMove:n})
this.updateSinusoid()},updateSinusoid:function e(){var t=InteractiveGraph.getCurrentSinusoidCoefficients(this.props)
if(!t){return}var r=t[0]
var n=t[1]
var a=t[2]
var o=t[3]
if(this.sinusoid){var i=this.graphie.svgSinusoidPath(r,n,a,o)
this.sinusoid.attr({path:i})}else{this.sinusoid=this.graphie.sinusoid(r,n,a,o)
this.sinusoid.attr(babelHelpers.extends({stroke:this.props.apiOptions.isMobile?_colors2.default.BLUE_C:_colors2.default.DYNAMIC},this._lineStroke()))
this.sinusoid.toBack()}},removeSinusoidControls:function e(){this.pointA.remove()
this.pointB.remove()
if(this.sinusoid){this.sinusoid.remove()
this.sinusoid=null}},addCircleControls:function e(){var t=this
var r=this.graphie
var n=_underscore2.default.min(r.snap)
var a=this.circle=r.addCircleGraph({center:this.props.graph.center||[0,0],radius:this.props.graph.radius||_underscore2.default.min(this.props.step),snapX:r.snap[0],snapY:r.snap[1],minRadius:n,snapRadius:n});(0,_jquery2.default)(a).on("move",function(){var e=_underscore2.default.extend({},t.props.graph,{center:a.center,radius:a.radius})
t.onChange({graph:e})})},removeCircleControls:function e(){this.circle.remove()},addLinearSystemControls:function e(){var t=this
var r=this.graphie
var n=InteractiveGraph.getLinearSystemCoords(this.props.graph,this.props)
var a=[_colors2.default.INTERACTIVE,_colors2.default.GREEN]
var o=this.points=_underscore2.default.map(n,function(e,r){var n=_underscore2.default.map(e,function(e,o){return _interactive2.default.addMaybeMobileMovablePoint(t,{coord:e,constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){if(!n){return}return!kpoint.equal(e,n[1-o].coord())}],onMove:function e(){var r=_underscore2.default.extend({},t.props.graph,{coords:_underscore2.default.map(t.points,function(e){return _underscore2.default.invoke(e,"coord")})})
t.onChange({graph:r})},normalStyle:{fill:a[r]},highlightStyle:{fill:a[r]}})})
return n})
this.lines=_underscore2.default.map(o,function(e,t){return _interactive2.default.addMovableLine(r,{points:e,static:true,extendLine:true,normalStyle:{stroke:a[t]}})})},removeLinearSystemControls:function e(){_underscore2.default.invoke(this.lines,"remove")
_underscore2.default.map(this.points,function(e){return _underscore2.default.invoke(e,"remove")})},isCoordInTrash:function e(t){if(this.props.apiOptions.isMobile){return false}var r=this.graphie
var n=r.scalePoint(t)
return n[0]>=r.xpixels-40&&n[1]>=r.ypixels-40},createPointForPointsType:function e(t,r){var n=this
var a=function e(){n.points=_underscore2.default.filter(n.points,function(e){return e!==o})
n.updateCoordsFromPoints()
setTimeout(o.remove.bind(o),0)}
var o=_interactive2.default.addMaybeMobileMovablePoint(this,babelHelpers.extends({coord:t,constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){return _underscore2.default.all(n.points,function(t){return o===t||!kpoint.equal(e,t.coord())})}],onMoveStart:function e(){if(n.isClickToAddPoints()){n.setTrashCanVisibility(1)}},onMove:n.updateCoordsFromPoints,onMoveEnd:function e(t){if(n.isClickToAddPoints()){if(n.isCoordInTrash(t)){a()}n.setTrashCanVisibility(.5)}}},this.props.apiOptions.isMobile&&n.isClickToAddPoints()?{onRemove:a}:{}))
return o},removePoint:function e(t){var r=null
this.points=_underscore2.default.filter(this.points,function(e,n){if(e===t){r=n
return false}else{return true}})
return r},createPointForPolygonType:function e(t,r){var n=this
var a=!_underscore2.default.contains(["angles","sides"],this.props.graph.snapTo)
var o=function e(t){return(r+t+n.points.length)%n.points.length}
var i=function e(){var t=n.removePoint(p)
if(n.polygon.closed()){n.points=rotate(n.points,t)
n.polygon.update({closed:false})}n.updatePolygon()
n.clearCoords()
setTimeout(p.remove.bind(p),0)}
var s=(0,_lodash.debounce)(function(e,t){e.state.isInitialMove=t},1e3)
var l=function e(t){var r=n.points.length>1&&(p===n.points[0]&&kpoint.equal(t,_underscore2.default.last(n.points).coord())||p===_underscore2.default.last(n.points)&&kpoint.equal(t,n.points[0].coord()))
if(n.isClickToAddPoints()){if(n.isCoordInTrash(t)){i()}else if(r){var a=n.points.pop()
if(n.points.length>2){n.polygon.update({closed:true})
n.updateCoordsFromPoints()}else{n.polygon.update({closed:false})
n.clearCoords()}n.updatePolygon()
setTimeout(a.remove.bind(a),0)}else{var o=_underscore2.default.any(n.points,function(e){return e!==p&&kpoint.equal(e.coord(),t)})
if(o){n.removePoint(p)
if(n.points.length<3){n.polygon.update({closed:false})
n.clearCoords()}else if(n.polygon.closed()){n.updateCoordsFromPoints()}n.updatePolygon()
setTimeout(p.remove.bind(p),0)}else{var l=p===_underscore2.default.head(n.points)||p===_underscore2.default.last(n.points)
var u=!p.hasMoved()
var d=!p.state.isInitialMove
var c=!n.polygon.closed()
var h=n.points.length>2
var f=l&&u&&d&&c&&h
if(f){n.polygon.update({closed:true})
n.updatePolygon()
n.updateCoordsFromPoints()}}}n.setTrashCanVisibility(.5)}s(p,false)}
var u=function e(t){if(n.points==null||n.points.length===0){return true}var a=_underscore2.default.invoke(n.points,"coord")
a[r]=t
if(!n.isClickToAddPoints()){if(collinear(a[o(-2)],a[o(-1)],a[r])||collinear(a[o(-1)],a[r],a[o(1)])||collinear(a[r],a[o(1)],a[o(2)])){return false}var i=_underscore2.default.zip(a,rotate(a))
if(n.points.length>3){for(var s=-1;s<=0;s++){var l=i[o(s)]
var u=_underscore2.default.without(i,l,i[o(s-1)],i[o(s+1)])
for(var p=0;p<u.length;p++){var d=u[p]
if(intersects(l,d)){return false}}}}}if(n.props.graph.snapTo==="angles"&&n.points.length>2){var c=_underscore2.default.map(angleMeasures(a),function(e){return e*180/Math.PI})
_underscore2.default.each([-1,1],function(e){c[o(e)]=Math.round(c[o(e)])})
var h=function e(t,r,n){var i=_graphUtils2.default.findAngle(a[o(t)],a[o(n)],a[o(r)])
return(i+360)%360}
var f=[c[o(-1)]-h(-2,-1,1),c[o(1)]-h(-1,1,2)]
f[2]=180-(f[0]+f[1])
if(_underscore2.default.any(f,function(e){return leq(e,1)})){return false}var v=magnitude(vector(a[o(-1)],a[o(1)]))
var g=sign(ccw(a[o(-1)],a[o(1)],a[r]))===1
var m=Math.sin(f[1]*Math.PI/180)/Math.sin(f[2]*Math.PI/180)*v
var b=_graphUtils2.default.findAngle(a[o(1)],a[o(-1)])
var C=n.graphie.polar(m,b+(g?1:-1)*f[0])
return n.graphie.addPoints(a[o(-1)],C)}else if(n.props.graph.snapTo==="sides"&&n.points.length>1){var y=_underscore2.default.map([[a[o(-1)],a[r]],[a[r],a[o(1)]],[a[o(-1)],a[o(1)]]],function(e){return magnitude(vector.apply(undefined,e))})
_underscore2.default.each([0,1],function(e){y[e]=Math.round(y[e])})
if(leq(y[1]+y[2],y[0])||leq(y[0]+y[2],y[1])||leq(y[0]+y[1],y[2])){return false}var M=lawOfCosines(y[0],y[2],y[1])
var T=_graphUtils2.default.findAngle(a[o(1)],a[o(-1)])
var I=sign(ccw(a[o(-1)],a[o(1)],a[r]))===1
var P=n.graphie.polar(y[0],T+(I?1:-1)*M)
return n.graphie.addPoints(a[o(-1)],P)}else{return true}}
var p=_interactive2.default.addMaybeMobileMovablePoint(this,babelHelpers.extends({coord:t,constraints:[_interactive2.default.MovablePoint.constraints.bound(),a?_interactive2.default.MovablePoint.constraints.snap():null,u],onMoveStart:function e(){if(n.isClickToAddPoints()){n.setTrashCanVisibility(1)}},onMove:function e(){if(n.polygon.closed()){n.updateCoordsFromPoints()}},onMoveEnd:l},this.props.apiOptions.isMobile&&this.isClickToAddPoints()?{onRemove:i}:{}))
p.state.isInitialMove=true
return p},updateCoordsFromPoints:function e(){var t=_underscore2.default.extend({},this.props.graph,{coords:_underscore2.default.map(this.points,function(e){return _underscore2.default.result(e,"coord")})})
this.onChange({graph:t})},clearCoords:function e(){var t=_underscore2.default.extend({},this.props.graph,{coords:null})
this.onChange({graph:t})},onChange:function e(t){this.props.onChange(t)
this.props.trackInteraction()},addPointControls:function e(){var t=InteractiveGraph.getPointCoords(this.props.graph,this.props)
this.points=[]
this.points=_underscore2.default.map(t,this.createPointForPointsType,this)},removePointControls:function e(){_underscore2.default.invoke(this.points,"remove")},addSegmentControls:function e(){var t=this
var r=this
var n=this.graphie
var a=InteractiveGraph.getSegmentCoords(this.props.graph,this.props)
var o=function e(r){return _interactive2.default.addMaybeMobileMovablePoint(t,r)}
this.points=[]
this.lines=_underscore2.default.map(a,function(e,t){var a=function e(){var t=_underscore2.default.extend({},r.props.graph,{coords:_underscore2.default.invoke(r.lines,"coords")})
r.onChange({graph:t})}
var i=_underscore2.default.map(e,function(e,t){return o({coord:e,constraints:[_interactive2.default.MovablePoint.constraints.bound(),_interactive2.default.MovablePoint.constraints.snap(),function(e){if(!i){return}return!kpoint.equal(e,i[1-t].coord())}],onMove:a})})
r.points=r.points.concat(i)
var s=_interactive2.default.addMovableLine(n,{points:i,static:false,constraints:[_interactive2.default.MovableLine.constraints.bound(),_interactive2.default.MovableLine.constraints.snap()],onMove:[_interactive2.default.MovableLine.onMove.updatePoints,a],normalStyle:babelHelpers.extends({stroke:this.props.apiOptions.isMobile?_colors2.default.BLUE_C:_colors2.default.INTERACTIVE},this._lineStroke()),highlightStyle:babelHelpers.extends({stroke:this.props.apiOptions.isMobile?_colors2.default.BLUE_C:_colors2.default.INTERACTING},this._lineStroke())})
_underscore2.default.invoke(i,"toFront")
return s},this)},removeSegmentControls:function e(){_underscore2.default.invoke(this.points,"remove")
_underscore2.default.invoke(this.lines,"remove")},addRayControls:function e(){this.addLine("ray")},removeRayControls:function e(){this.removeLine()},addPolygonControls:function e(){this.polygon=null
var t=InteractiveGraph.getPolygonCoords(this.props.graph,this.props)
this.points=[]
this.points=_underscore2.default.map(t,this.createPointForPolygonType,this)
this.updatePolygon()},updatePolygon:function e(){var t=void 0
if(this.polygon){t=this.polygon.closed()}else if(this.points.length>=3){t=true}else{t=false}var r=this.graphie
var n=this.points.length
var a=!_underscore2.default.contains(["angles","sides"],this.props.graph.snapTo)
var o=_underscore2.default.times(n,function(e){if(!this.props.graph.showAngles||!t&&(e===0||e===n-1)){return""}else if(this.props.graph.snapTo==="angles"){return"$deg0"}else{return"$deg1"}},this)
var i=_underscore2.default.times(n,function(e){return t||e!==0&&e!==n-1},this)
var s=_underscore2.default.times(n,function(e){if(this.props.graph.showAngles&&(t||e!==0&&e!==n-1)){return 1}else{return 0}},this)
var l=_underscore2.default.times(n,function(e){if(!this.props.graph.showSides||!t&&e===n-1){return""}else if(this.props.graph.snapTo==="sides"){return"$len0"}else{return"$len1"}},this)
if(this.polygon==null){var u=this
u.polygon=_interactive2.default.addMovablePolygon(r,{constraints:[_interactive2.default.MovablePolygon.constraints.bound(),a?_interactive2.default.MovablePolygon.constraints.snap():null],closed:t,points:u.points,angleLabels:o,showRightAngleMarkers:i,numArcs:s,sideLabels:l,onMove:[_interactive2.default.MovablePolygon.onMove.updatePoints,function(){if(this.closed()){u.updateCoordsFromPoints()}}],normalStyle:babelHelpers.extends({stroke:this.props.apiOptions.isMobile?_colors2.default.BLUE_C:_colors2.default.INTERACTIVE},this._lineStroke())})}else{this.polygon.update({closed:t,points:this.points,angleLabels:o,showRightAngleMarkers:i,numArcs:s,sideLabels:l})}},removePolygonControls:function e(){_underscore2.default.invoke(this.points,"remove")
this.polygon.remove()},addAngleControls:function e(){var t=this
var r=this.graphie
var n=InteractiveGraph.getAngleCoords(this.props.graph,this.props)
this.points=_underscore2.default.map(n,function(e,t){return r.addMovablePoint(_underscore2.default.extend({coord:e,normalStyle:{stroke:_colors2.default.INTERACTIVE,fill:_colors2.default.INTERACTIVE}},t===1?{snapX:r.snap[0],snapY:r.snap[1]}:{}))})
this.angle=r.addMovableAngle({points:this.points,snapDegrees:this.props.graph.snapDegrees||1,snapOffsetDeg:this.props.graph.angleOffsetDeg||0,angleLabel:this.props.graph.showAngles?"$deg0":"",pushOut:2,allowReflex:defaultVal(this.props.graph.allowReflexAngles,true)});(0,_jquery2.default)(this.angle).on("move",function(){var e=_underscore2.default.extend({},t.props.graph,{coords:t.angle.getClockwiseCoords()})
t.onChange({graph:e})})},removeAngleControls:function e(){_underscore2.default.invoke(this.points,"remove")
this.angle.remove()},toggleShowAngles:function e(){var t=_underscore2.default.extend({},this.props.graph,{showAngles:!this.props.graph.showAngles})
this.onChange({graph:t})},toggleShowSides:function e(){var t=_underscore2.default.extend({},this.props.graph,{showSides:!this.props.graph.showSides})
this.onChange({graph:t})},getUserInput:function e(){return InteractiveGraph.getUserInputFromProps(this.props)},simpleValidate:function e(t){return InteractiveGraph.validate(this.getUserInput(),t,this)},focus:_jquery2.default.noop,render:function e(){var t=this
var r=void 0
var n=void 0
if(this.props.flexibleType){r=_react2.default.createElement("select",{value:this.props.graph.type,onChange:function e(r){var n=r.target.value
t.onChange({graph:{type:n}})}},_react2.default.createElement("option",{value:"linear"},i18n.doNotTranslate("Linear function")),_react2.default.createElement("option",{value:"quadratic"},i18n.doNotTranslate("Quadratic function")),_react2.default.createElement("option",{value:"sinusoid"},i18n.doNotTranslate("Sinusoid function")),_react2.default.createElement("option",{value:"circle"},i18n.doNotTranslate("Circle")),_react2.default.createElement("option",{value:"point"},i18n.doNotTranslate("Point(s)")),_react2.default.createElement("option",{value:"linear-system"},i18n.doNotTranslate("Linear System")),_react2.default.createElement("option",{value:"polygon"},i18n.doNotTranslate("Polygon")),_react2.default.createElement("option",{value:"segment"},i18n.doNotTranslate("Line Segment(s)")),_react2.default.createElement("option",{value:"ray"},i18n.doNotTranslate("Ray")),_react2.default.createElement("option",{value:"angle"},i18n.doNotTranslate("Angle")))
if(this.props.graph.type==="point"){n=_react2.default.createElement("select",{key:"point-select",value:this.props.graph.numPoints||1,onChange:function e(r){var n=+r.target.value||r.target.value
t.onChange({graph:{type:"point",numPoints:n,coords:null}})}},_underscore2.default.map(_underscore2.default.range(1,7),function(e){return _react2.default.createElement("option",{value:e},e,i18n.doNotTranslate(" ","point"),e>1&&i18n.doNotTranslate('"s"'))}),_react2.default.createElement("option",{value:UNLIMITED},i18n.doNotTranslate("unlimited")))}else if(this.props.graph.type==="polygon"){n=_react2.default.createElement("div",null,_react2.default.createElement("div",null,_react2.default.createElement("select",{key:"polygon-select",value:this.props.graph.numSides||3,onChange:function e(r){var n=+r.target.value||r.target.value
var a=_underscore2.default.extend({},t.props.graph,{numSides:n,coords:null,snapTo:"grid"})
t.onChange({graph:a})}},_underscore2.default.map(_underscore2.default.range(3,13),function(e){return _react2.default.createElement("option",{value:e},i18n.doNotTranslate(e," sides"))}),_react2.default.createElement("option",{value:UNLIMITED},i18n.doNotTranslate("unlimited sides")))),_react2.default.createElement("div",null,_react2.default.createElement("label",null,i18n.doNotTranslate(" ","Snap to"," "),_react2.default.createElement("select",{key:"polygon-snap",value:this.props.graph.snapTo,onChange:function e(r){var n=_underscore2.default.extend({},t.props.graph,{snapTo:r.target.value,coords:null})
t.onChange({graph:n})}},_react2.default.createElement("option",{value:"grid"},i18n.doNotTranslate("grid")),this.props.graph.numSides!==UNLIMITED&&[_react2.default.createElement("option",{value:"angles"}," ",i18n.doNotTranslate("interior angles")," "),_react2.default.createElement("option",{value:"sides"}," ",i18n.doNotTranslate("side measures")," ")])),_react2.default.createElement(_infoTip2.default,null,_react2.default.createElement("p",null,i18n.doNotTranslate("These options affect the movement of the vertex points. The grid option will guide the points to the nearest half step along the grid.")),_react2.default.createElement("p",null,i18n.doNotTranslate("The interior angle and side measure options guide the points to the nearest whole angle or side"))," ",i18n.doNotTranslate("measure respectively.")," ")),_react2.default.createElement("div",null,_react2.default.createElement("label",null,i18n.doNotTranslate("Show angle measures:"," "),_react2.default.createElement("input",{type:"checkbox",checked:this.props.graph.showAngles,onChange:this.toggleShowAngles})),_react2.default.createElement(_infoTip2.default,null,_react2.default.createElement("p",null,i18n.doNotTranslate("Displays the interior angle measures.")))),_react2.default.createElement("div",null,_react2.default.createElement("label",null,i18n.doNotTranslate("Show side measures:")," ",_react2.default.createElement("input",{type:"checkbox",checked:this.props.graph.showSides,onChange:this.toggleShowSides})),_react2.default.createElement(_infoTip2.default,null,_react2.default.createElement("p",null,i18n.doNotTranslate("Displays the side lengths.")))))}else if(this.props.graph.type==="segment"){n=_react2.default.createElement("select",{key:"segment-select",value:this.props.graph.numSegments||1,onChange:function e(r){var n=+r.target.value
t.onChange({graph:{type:"segment",numSegments:n,coords:null}})}},_underscore2.default.map(_underscore2.default.range(1,7),function(e){return _react2.default.createElement("option",{value:e},e," ",i18n.doNotTranslate("segment"),e>1&&i18n.doNotTranslate("s"))}))}else if(this.props.graph.type==="angle"){var a=defaultVal(this.props.graph.allowReflexAngles,true)
n=_react2.default.createElement("div",null,_react2.default.createElement("div",null,_react2.default.createElement("label",null,i18n.doNotTranslate("Show angle measure:")," ",_react2.default.createElement("input",{type:"checkbox",checked:this.props.graph.showAngles,onChange:this.toggleShowAngles}))),_react2.default.createElement("div",null,_react2.default.createElement("label",null,i18n.doNotTranslate("Allow reflex angles:")," ",_react2.default.createElement("input",{type:"checkbox",checked:a,onChange:function e(r){t.onChange({graph:_underscore2.default.extend({},t.props.graph,{allowReflexAngles:!a,coords:null})})}})),_react2.default.createElement(_infoTip2.default,null,_react2.default.createElement("p",null,i18n.doNotTranslate("Reflex angles are angles with a measure greater than 180 degrees.")),_react2.default.createElement("p",null,i18n.doNotTranslate("By default, these should remain enabled.")))),_react2.default.createElement("div",null,_react2.default.createElement("label",null,i18n.doNotTranslate("Snap to increments of")," ",_react2.default.createElement(_numberInput2.default,{key:"degree-snap",placeholder:1,value:this.props.graph.snapDegrees,onChange:function e(r){t.onChange({graph:_underscore2.default.extend({},t.props.graph,{snapDegrees:Math.abs(r),coords:null})})}})," ",i18n.doNotTranslate("degrees")," ")),_react2.default.createElement("div",null,_react2.default.createElement("label",null," ",i18n.doNotTranslate("With an offset of")," ",_react2.default.createElement(_numberInput2.default,{key:"angle-offset",placeholder:0,value:this.props.graph.angleOffsetDeg,onChange:function e(r){t.onChange({graph:_underscore2.default.extend({},t.props.graph,{angleOffsetDeg:r,coords:null})})}})," ",i18n.doNotTranslate("degrees")," ")))}}var o=getInteractiveBoxFromSizeClass(this.props.containerSizeClass)
var i=void 0
if(this.isClickToAddPoints()&&this.state.shouldShowInstructions){if(this.props.graph.type==="point"){i=i18n._("Click to add points")}else if(this.props.graph.type==="polygon"){i=i18n._("Click to add vertices")}}else{i=undefined}var s=this.isClickToAddPoints()?this.handleAddPointsMouseDown:null
var l=this.props.gridStep||_util2.default.getGridStep(this.props.range,this.props.step,o[0])
var u=this.props.snapStep||_util2.default.snapStepFromGridStep(l)
var p=this.props.apiOptions.isMobile
return _react2.default.createElement("div",{className:"perseus-widget "+"perseus-widget-interactive-graph",style:{width:o[0],height:this.props.flexibleType?"auto":o[1]}},_react2.default.createElement(_graph2.default,{instructions:i,ref:"graph",box:o,labels:this.props.labels,range:this.props.range,step:p?_util2.default.constrainedTickStepsFromTickSteps(this.props.step,this.props.range):this.props.step,gridStep:l,snapStep:u,markings:this.props.markings,backgroundImage:this.props.backgroundImage,showProtractor:this.props.showProtractor,showRuler:this.props.showRuler,rulerLabel:this.props.rulerLabel,rulerTicks:this.props.rulerTicks,onMouseDown:s,onGraphieUpdated:this.setGraphie,setDrawingAreaAvailable:this.props.apiOptions.setDrawingAreaAvailable,isMobile:p}),r,n)}})
_underscore2.default.extend(InteractiveGraph,{getQuadraticCoefficients:function e(t){var r=t[0]
var n=t[1]
var a=t[2]
var o=(r[0]-n[0])*(r[0]-a[0])*(n[0]-a[0])
if(o===0){return}var i=(a[0]*(n[1]-r[1])+n[0]*(r[1]-a[1])+r[0]*(a[1]-n[1]))/o
var s=(a[0]*a[0]*(r[1]-n[1])+n[0]*n[0]*(a[1]-r[1])+r[0]*r[0]*(n[1]-a[1]))/o
var l=(n[0]*a[0]*(n[0]-a[0])*r[1]+a[0]*r[0]*(a[0]-r[0])*n[1]+r[0]*n[0]*(r[0]-n[0])*a[1])/o
return[i,s,l]},getSinusoidCoefficients:function e(t){var r=t[0]
var n=t[1]
var a=n[1]-r[1]
var o=Math.PI/(2*(n[0]-r[0]))
var i=r[0]*o
var s=r[1]
return[a,o,i,s]},getLineCoords:function e(t,r){return t.coords||InteractiveGraph.pointsFromNormalized(r,[[.25,.75],[.75,.75]])},getPointCoords:function e(t,r){var n=t.numPoints||1
var a=t.coords
if(a){return a}else{switch(n){case 1:a=[t.coord||[0,0]]
break
case 2:a=[[-5,0],[5,0]]
break
case 3:a=[[-5,0],[0,0],[5,0]]
break
case 4:a=[[-6,0],[-2,0],[2,0],[6,0]]
break
case 5:a=[[-6,0],[-3,0],[0,0],[3,0],[6,0]]
break
case 6:a=[[-5,0],[-3,0],[-1,0],[1,0],[3,0],[5,0]]
break
case UNLIMITED:a=[]
break}var o=[[-10,10],[-10,10]]
var i=InteractiveGraph.normalizeCoords(a,o)
return InteractiveGraph.pointsFromNormalized(r,i)}},getLinearSystemCoords:function e(t,r){return t.coords||_underscore2.default.map([[[.25,.75],[.75,.75]],[[.25,.25],[.75,.25]]],function(e){return InteractiveGraph.pointsFromNormalized(r,e)})},getPolygonCoords:function e(t,r){var n=t.coords
if(n){return n}var a=t.numSides||3
if(a===UNLIMITED){n=[]}else{var o=2*Math.PI/a
var i=(1/a-1/2)*Math.PI
var s=t.snapTo==="sides"?Math.sqrt(3)/3*7:4
n=_underscore2.default.times(a,function(e){return[s*Math.cos(e*o+i),s*Math.sin(e*o+i)]})}var l=[[-10,10],[-10,10]]
n=InteractiveGraph.normalizeCoords(n,l)
var u=!_underscore2.default.contains(["angles","sides"],t.snapTo)
n=InteractiveGraph.pointsFromNormalized(r,n,!u)
return n},getSegmentCoords:function e(t,r){var n=t.coords
if(n){return n}var a=t.numSegments||1
var o={1:[5],2:[5,-5],3:[5,0,-5],4:[6,2,-2,-6],5:[6,3,0,-3,-6],6:[5,3,1,-1,-3,-5]}[a]
var i=[[-10,10],[-10,10]]
return _underscore2.default.map(o,function(e){var t=[[-5,e],[5,e]]
t=InteractiveGraph.normalizeCoords(t,i)
t=InteractiveGraph.pointsFromNormalized(r,t)
return t})},getAngleCoords:function e(t,r){var n=t.coords
if(n){return n}var a=t.snapDegrees||1
var o=a
while(o<20){o+=a}o=o*Math.PI/180
var i=(t.angleOffsetDeg||0)*Math.PI/180
n=InteractiveGraph.pointsFromNormalized(r,[[.85,.5],[.5,.5]])
var s=magnitude(vector.apply(undefined,n))
n[0]=[n[1][0]+s*Math.cos(i),n[1][1]+s*Math.sin(i)]
n[2]=[n[1][0]+s*Math.cos(o+i),n[1][1]+s*Math.sin(o+i)]
return n},normalizeCoords:function e(t,r){return _underscore2.default.map(t,function(e){return _underscore2.default.map(e,function(e,t){var n=r[t][1]-r[t][0]
return(e+r[t][1])/n})})},getEquationString:function e(t){var r=t.graph.type
var n="get"+capitalize(r)+"EquationString"
return InteractiveGraph[n](t)},pointsFromNormalized:function e(t,r,n){return _underscore2.default.map(r,function(e){return _underscore2.default.map(e,function(e,r){var a=t.range[r]
if(n){return a[0]+(a[1]-a[0])*e}else{var o=t.step[r]
var i=numSteps(a,o)
var s=Math.round(e*i)
return a[0]+o*s}})})},getLinearEquationString:function e(t){var r=InteractiveGraph.getLineCoords(t.graph,t)
if(eq(r[0][0],r[1][0])){return"x = "+r[0][0].toFixed(3)}else{var n=(r[1][1]-r[0][1])/(r[1][0]-r[0][0])
var a=r[0][1]-n*r[0][0]
if(eq(n,0)){return"y = "+a.toFixed(3)}else{return"y = "+n.toFixed(3)+"x + "+a.toFixed(3)}}},getCurrentQuadraticCoefficients:function e(t){var r=t.graph.coords||InteractiveGraph.defaultQuadraticCoords(t)
return InteractiveGraph.getQuadraticCoefficients(r)},defaultQuadraticCoords:function e(t){var r=[[.25,.75],[.5,.25],[.75,.75]]
return InteractiveGraph.pointsFromNormalized(t,r)},getQuadraticEquationString:function e(t){var r=InteractiveGraph.getCurrentQuadraticCoefficients(t)
return"y = "+r[0].toFixed(3)+"x^2 + "+r[1].toFixed(3)+"x + "+r[2].toFixed(3)},getCurrentSinusoidCoefficients:function e(t){var r=t.graph.coords||InteractiveGraph.defaultSinusoidCoords(t)
return InteractiveGraph.getSinusoidCoefficients(r)},defaultSinusoidCoords:function e(t){var r=[[.5,.5],[.65,.6]]
return InteractiveGraph.pointsFromNormalized(t,r)},getSinusoidEquationString:function e(t){var r=InteractiveGraph.getCurrentSinusoidCoefficients(t)
return"y = "+r[0].toFixed(3)+"sin("+r[1].toFixed(3)+"x - "+r[2].toFixed(3)+") + "+r[3].toFixed(3)},getCircleEquationString:function e(t){var r=t.graph
var n=r.center||[0,0]
var a=r.radius||2
return"center ("+n[0]+", "+n[1]+"), radius "+a},getLinearSystemEquationString:function e(t){var r=InteractiveGraph.getLinearSystemCoords(t.graph,t)
return"\n"+getLineEquation(r[0][0],r[0][1])+"\n"+getLineEquation(r[1][0],r[1][1])+"\n"+getLineIntersection(r[0],r[1])},getPointEquationString:function e(t){var r=InteractiveGraph.getPointCoords(t.graph,t)
return r.map(function(e){return"("+e[0]+", "+e[1]+")"}).join(", ")},getSegmentEquationString:function e(t){var r=InteractiveGraph.getSegmentCoords(t.graph,t)
return _underscore2.default.map(r,function(e){return"["+_underscore2.default.map(e,function(e){return"("+e.join(", ")+")"}).join(" ")+"]"}).join(" ")},getRayEquationString:function e(t){var r=InteractiveGraph.getLineCoords(t.graph,t)
var n=r[0]
var a=r[1]
var o=InteractiveGraph.getLinearEquationString(t)
if(n[0]>a[0]){o+=" (for x <= "+n[0].toFixed(3)+")"}else if(n[0]<a[0]){o+=" (for x >= "+n[0].toFixed(3)+")"}else if(n[1]>a[1]){o+=" (for y <= "+n[1].toFixed(3)+")"}else{o+=" (for y >= "+n[1].toFixed(3)+")"}return o},getPolygonEquationString:function e(t){var r=InteractiveGraph.getPolygonCoords(t.graph,t)
return _underscore2.default.map(r,function(e){return"("+e.join(", ")+")"}).join(" ")},getAngleEquationString:function e(t){var r=InteractiveGraph.getAngleCoords(t.graph,t)
var n=_graphUtils2.default.findAngle(r[2],r[0],r[1])
return n.toFixed(0)+"° angle"+" at ("+r[1].join(", ")+")"},validate:function e(t,r,n){var a=!!(t.coords||t.center&&t.radius)
if(t.type===r.correct.type&&a){if(t.type==="linear"){var o=t.coords
var i=r.correct.coords
if(collinear(i[0],i[1],o[0])&&collinear(i[0],i[1],o[1])){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="linear-system"){var s=t.coords
var l=r.correct.coords
if(collinear(l[0][0],l[0][1],s[0][0])&&collinear(l[0][0],l[0][1],s[0][1])&&collinear(l[1][0],l[1][1],s[1][0])&&collinear(l[1][0],l[1][1],s[1][1])||collinear(l[0][0],l[0][1],s[1][0])&&collinear(l[0][0],l[0][1],s[1][1])&&collinear(l[1][0],l[1][1],s[0][0])&&collinear(l[1][0],l[1][1],s[0][1])){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="quadratic"){var u=this.getQuadraticCoefficients(t.coords)
var p=this.getQuadraticCoefficients(r.correct.coords)
if(deepEq(u,p)){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="sinusoid"){var d=this.getSinusoidCoefficients(t.coords)
var c=this.getSinusoidCoefficients(r.correct.coords)
var h=canonicalSineCoefficients(d)
var f=canonicalSineCoefficients(c)
if(deepEq(h,f)){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="circle"){if(deepEq(t.center,r.correct.center)&&eq(t.radius,r.correct.radius)){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="point"){var v=t.coords
var g=InteractiveGraph.getPointCoords(r.correct,n)
v=v.slice()
g=g.slice()
v.sort()
g.sort()
if(deepEq(v,g)){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="polygon"){var m=t.coords.slice()
var b=r.correct.coords.slice()
var C=void 0
if(r.correct.match==="similar"){C=similar(m,b,Number.POSITIVE_INFINITY)}else if(r.correct.match==="congruent"){C=similar(m,b,knumber.DEFAULT_TOLERANCE)}else if(r.correct.match==="approx"){C=similar(m,b,.1)}else{m.sort()
b.sort()
C=deepEq(m,b)}if(C){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="segment"){var y=t.coords.slice()
var M=r.correct.coords.slice()
y=_underscore2.default.invoke(y,"sort").sort()
M=_underscore2.default.invoke(M,"sort").sort()
if(deepEq(y,M)){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="ray"){var T=t.coords
var I=r.correct.coords
if(deepEq(T[0],I[0])&&collinear(I[0],I[1],T[1])){return{type:"points",earned:1,total:1,message:null}}}else if(t.type==="angle"){var P=t.coords
var S=r.correct.coords
var k=void 0
if(r.correct.match==="congruent"){var E=_underscore2.default.map([P,S],function(e){var t=_graphUtils2.default.findAngle(e[2],e[0],e[1])
return(t+360)%360})
k=eq.apply(undefined,E)}else{k=deepEq(P[1],S[1])&&collinear(S[1],S[0],P[0])&&collinear(S[1],S[2],P[2])}if(k){return{type:"points",earned:1,total:1,message:null}}}}if(!a||_underscore2.default.isEqual(t,r.graph)){return{type:"invalid",message:null}}else{return{type:"points",earned:0,total:1,message:null}}},getUserInputFromProps:function e(t){return t.graph}})
module.exports={name:"interactive-graph",displayName:"Interactive graph",widget:InteractiveGraph}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/lights-puzzle.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var i18n=require("../../shared-package/i18n.js")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var WidgetJsonifyDeprecated=require("../../perseus-all-package/mixins/widget-jsonify-deprecated.jsx")
var MAX_SIZE=8
var CELL_PADDING=5
var TABLE_STYLE={display:"table",tableLayout:"fixed"}
var ROW_STYLE={display:"table-row"}
var CELL_STYLE={display:"table-cell",padding:CELL_PADDING}
var BASE_TILE_STYLE={borderRadius:10,cursor:"pointer"}
var MOVE_COUNT_STYLE={padding:CELL_PADDING,display:"inline-block"}
var RESET_BUTTON_STYLE={float:"right",paddingRight:CELL_PADDING}
var MAIN_TILE_SIZE=50
var mapCells=function e(t,r){return _.map(t,function(e,t){return _.map(e,function(e,n){return r(e,t,n)})})}
var genCells=function e(t,r,n){return _.times(t,function(e){return _.times(r,function(t){return n(e,t)})})}
var PATTERNS={plus:function e(){return[[false,true,false],[true,true,true],[false,true,false]]},x:function e(){return[[true,false,true],[false,true,false],[true,false,true]]},"plus/x":function e(t){return t%2?PATTERNS.x():PATTERNS.plus()}}
var clampToInt=function e(t,r,n){t=Math.floor(t)
t=Math.max(t,r)
t=Math.min(t,n)
return t}
var Tile=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,a
babelHelpers.classCallCheck(this,t)
for(var s=arguments.length,l=Array(s),i=0;i<s;i++){l[i]=arguments[i]}return a=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(l))),n),n._flip=function(){n.props.onChange(!n.props.value)},r),babelHelpers.possibleConstructorReturn(n,a)}t.prototype.render=function e(){var t=this.props.value?"#55dd55":"#115511"
var r=_.extend({},BASE_TILE_STYLE,{width:this.props.size,height:this.props.size,backgroundColor:t})
return React.createElement("div",{style:r,onClick:this._flip})}
return t}(React.Component)
Tile.propTypes={value:PropTypes.bool.isRequired,size:PropTypes.number.isRequired}
var TileGrid=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=this
return React.createElement("div",{style:TABLE_STYLE,className:"no-select"},_.map(this.props.cells,function(e,r){return React.createElement("div",{key:r,style:ROW_STYLE},_.map(e,function(e,n){return React.createElement("div",{key:n,style:CELL_STYLE},React.createElement(Tile,{value:e,size:t.props.size,onChange:_.partial(t.props.onChange,r,n)}))}))}))}
return t}(React.Component)
TileGrid.propTypes={cells:PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.bool)).isRequired,size:PropTypes.number.isRequired}
var flipTilesPredicate=function e(t,r){return _.map(t,function(e,t){return _.map(e,function(e,n){return r(t,n)?!e:e})})}
var flipTilesPattern=function e(t,r,n,a){return flipTilesPredicate(t,function(e,t){var s=e-r
var l=t-n
if(Math.abs(s)<=1&&Math.abs(l)<=1){return a[s+1][l+1]}else{return false}})}
var LightsPuzzle=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,a
babelHelpers.classCallCheck(this,t)
for(var s=arguments.length,l=Array(s),i=0;i<s;i++){l[i]=arguments[i]}return a=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(l))),n),_initialiseProps.call(n),r),babelHelpers.possibleConstructorReturn(n,a)}t.prototype.render=function e(){var t=this._width()
var r=MAIN_TILE_SIZE
var n=t*(r+2*CELL_PADDING)
return React.createElement("div",null,React.createElement(TileGrid,{cells:this.props.cells,size:r,onChange:this._flipTile}),React.createElement("div",{style:{width:n}},React.createElement("div",{style:MOVE_COUNT_STYLE},i18n.ngettext("Moves: %(num)s","Moves: %(num)s",this.props.moveCount)),React.createElement("div",{style:RESET_BUTTON_STYLE},React.createElement("input",{type:"button",value:"Reset",onClick:this._reset,className:"simple-button"}))),React.createElement("div",{className:"clearfix"}))}
t.prototype.componentDidMount=function e(){this._initNextPatterns()}
t.prototype.componentDidUpdate=function e(t){if(t.flipPattern!==this.props.flipPattern){this._initNextPatterns()}}
return t}(React.Component)
LightsPuzzle.propTypes=babelHelpers.extends({},Changeable.propTypes,{cells:PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.bool)),startCells:PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.bool)),flipPattern:PropTypes.string.isRequired,moveCount:PropTypes.number.isRequired})
LightsPuzzle.defaultProps={cells:[[false,false,false],[false,false,false],[false,false,false]],startCells:[[false,false,false],[false,false,false],[false,false,false]],flipPattern:"plus",moveCount:0}
var _initialiseProps=function e(){var t=this
this.getUserInput=function(){return WidgetJsonifyDeprecated.getUserInput.call(t)}
this.change=function(){for(var e=arguments.length,r=Array(e),n=0;n<e;n++){r[n]=arguments[n]}return Changeable.change.apply(t,r)}
this._width=function(){if(t.props.cells.length!==0){return t.props.cells[0].length}else{return 0}}
this._initNextPatterns=function(){t._currPattern=PATTERNS[t.props.flipPattern](0)
t._nextPattern=PATTERNS[t.props.flipPattern](1)
t._patternIndex=2}
this._shiftPatterns=function(){t._currPattern=t._nextPattern
t._nextPattern=PATTERNS[t.props.flipPattern](t._patternIndex)
t._patternIndex++}
this._flipTile=function(e,r){var n=flipTilesPattern(t.props.cells,e,r,t._currPattern)
t._shiftPatterns()
t.change({cells:n,moveCount:t.props.moveCount+1})}
this._reset=function(){t.change({cells:t.props.startCells,moveCount:0})}
this.simpleValidate=function(e){return validate(e,t.getUserInput())}}
var validate=function e(t,r){var n=_.all(r.cells,function(e,r){return _.all(e,function(e,n){return e===t.startCells[r][n]})})
if(n){return{type:"invalid",message:i18n._("Click on the tiles to change the lights.")}}var a=_.all(r.cells,function(e){return _.all(e,function(e){return e})})
if(a){return{type:"points",earned:1,total:1,message:null}}else if(t.gradeIncompleteAsWrong){return{type:"points",earned:0,total:1,message:null}}else{return{type:"invalid",message:i18n._("You must turn on all of the lights to continue.")}}}
var transformProps=function e(t){return{cells:t.startCells,startCells:t.startCells,flipPattern:t.flipPattern}}
module.exports={name:"lights-puzzle",displayName:"Lights Puzzle",hidden:true,widget:LightsPuzzle,transform:transformProps}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/matrix.jsx", function(require, module, exports) {
var classNames=require("classnames")
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var NumberInput=require("../../perseus-all-package/components/number-input.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var TextInput=require("../../perseus-all-package/components/text-input.jsx")
var MathOutput=require("../../perseus-all-package/components/math-output.jsx")
var SimpleKeypadInput=require("../../perseus-all-package/components/simple-keypad-input.jsx")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var KhanAnswerTypes=require("../../perseus-all-package/util/answer-types.js")
var keypadElementPropType=require("math-input").propTypes.keypadElementPropType
var assert=require("../../perseus-all-package/interactive2/interactive-util.js").assert
var stringArrayOfSize=require("../../perseus-all-package/util.js").stringArrayOfSize
var _require=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require.linterContextProps,linterContextDefault=_require.linterContextDefault
var STATIC_INPUT_DIMENSIONS={INPUT_MARGIN:4,INPUT_HEIGHT:38,INPUT_WIDTH:82}
var NORMAL_DIMENSIONS={INPUT_MARGIN:3,INPUT_HEIGHT:30,INPUT_WIDTH:40}
var KEYPAD_INPUT_DIMENSIONS={INPUT_MARGIN:4,INPUT_HEIGHT:36,INPUT_WIDTH:64}
var getInputPath=function e(r,t){return[""+r,""+t]}
var getDefaultPath=function e(){return getInputPath(0,0)}
var getRowFromPath=function e(r){assert(_.isArray(r)&&r.length===2)
return+r[0]}
var getColumnFromPath=function e(r){assert(_.isArray(r)&&r.length===2)
return+r[1]}
var getRefForPath=function e(r){var t=getRowFromPath(r)
var a=getColumnFromPath(r)
return"answer"+t+","+a}
var getMatrixSize=function e(r){var t=[1,1]
_(r).each(function(e,r){var a=0
_(e).each(function(e,r){if(e!=null&&e.toString().length){a=r+1}})
t[1]=Math.max(t[1],a)
if(a>0){t[0]=Math.max(t[0],r+1)}})
return t}
var Matrix=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,n
babelHelpers.classCallCheck(this,r)
for(var i=arguments.length,s=Array(i),o=0;o<i;o++){s[o]=arguments[o]}return n=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),a),a.state={enterTheMatrix:0},a.getInputPaths=function(){var e=[]
var r=a.props.matrixBoardSize[0]
var t=a.props.matrixBoardSize[1]
_(r).times(function(r){_(t).times(function(t){var a=getInputPath(r,t)
e.push(a)})})
return e},a.getGrammarTypeForPath=function(e){return"number"},a._handleFocus=function(e,r){a.props.onFocus(getInputPath(e,r))},a._handleBlur=function(e,r){a.props.onBlur(getInputPath(e,r))},a.focus=function(){a.focusInputPath(getDefaultPath())
return true},a.focusInputPath=function(e){var r=getRefForPath(e)
a.refs[r].focus()},a.blurInputPath=function(e){if(e.length===0){e=getDefaultPath()}var r=getRefForPath(e)
a.refs[r].blur()},a.getDOMNodeForPath=function(e){var r=getRefForPath(e)
return ReactDOM.findDOMNode(a.refs[r])},a.setInputValue=function(e,r,t){var n=getRowFromPath(e)
var i=getColumnFromPath(e)
a.onValueChange(n,i,r,t)},a.handleKeyDown=function(e,r,t){var n=a.props.matrixBoardSize[0]
var i=a.props.matrixBoardSize[1]
var s=null
var o=a.refs[getRefForPath(getInputPath(e,r))]
var p=o.getStringValue()
var u=o.getSelectionStart()
var l=o.getSelectionEnd()
var c=null
if(t.key==="ArrowUp"&&e>0){c=getInputPath(e-1,r)}else if(t.key==="ArrowDown"&&e+1<n){c=getInputPath(e+1,r)}else if(t.key==="ArrowLeft"&&r>0){if(u===0&&l===0){c=getInputPath(e,r-1)}}else if(t.key==="ArrowRight"&&r+1<i){if(u===p.length){c=getInputPath(e,r+1)}}else if(t.key==="Enter"){s=a.state.enterTheMatrix+1}else if(t.key==="Escape"){s=0}if(c){t.preventDefault()
var f=a.refs[getRefForPath(c)]
var m=f.getStringValue()
var h=m.length*2
f.focus()
if(t.key==="ArrowRight"){f.setSelectionRange(0,0)}else{f.setSelectionRange(h,h)}}if(s!=null){a.setState({enterTheMatrix:s})}},a.onValueChange=function(e,r,t,n){var i=_.map(a.props.answers,_.clone)
if(!i[e]){i[e]=[]}i[e][r]=t
a.props.onChange({answers:i},n)
a.props.trackInteraction()},a.getUserInput=function(){return{answers:a.props.answers}},a.simpleValidate=function(e){return r.validate(a.getUserInput(),e)},t),babelHelpers.possibleConstructorReturn(a,n)}r.prototype.componentDidMount=function e(){this.cursorPosition=[0,0]}
r.prototype.render=function e(){var r=this
var t=void 0
if(this.props.apiOptions.customKeypad){t=KEYPAD_INPUT_DIMENSIONS}else if(this.props.apiOptions.staticRender){t=STATIC_INPUT_DIMENSIONS}else{t=NORMAL_DIMENSIONS}var a=t,n=a.INPUT_MARGIN,i=a.INPUT_HEIGHT,s=a.INPUT_WIDTH
var o=getMatrixSize(this.props.answers)
var p=this.props.matrixBoardSize[0]
var u=this.props.matrixBoardSize[1]
var l=this.props.cursorPosition[0]
var c=this.props.cursorPosition[1]
var f=Math.max(l,o[0]-1)
var m=Math.max(c,o[1]-1)
var h=(f+1)*(i+2*n)
var v=(m+1)*(s+2*n)
var g=classNames({"perseus-matrix":true,"static-mode":this.props.static,"the-matrix":this.state.enterTheMatrix>=5})
return React.createElement("div",{className:g},this.props.prefix&&React.createElement("div",{className:"matrix-prefix"},React.createElement(Renderer,{content:this.props.prefix,linterContext:this.props.linterContext})),React.createElement("div",{className:"matrix-input"},React.createElement("div",{className:"matrix-bracket bracket-left",style:{height:h}}),React.createElement("div",{className:"matrix-bracket bracket-right",style:{height:h,left:v}}),_(p).times(function(e){var t=r.props.answers[e]
return React.createElement("div",{className:"matrix-row",key:e},_(u).times(function(a){var o=e>f||a>m
var p={className:o?"outside":"inside",ref:getRefForPath(getInputPath(e,a)),value:t?t[a]:null,style:{height:i,width:s,margin:n},disabled:r.props.apiOptions.readOnly,onFocus:function t(){r.cursorPosition=[e,a]
r.props.onChange({cursorPosition:[e,a]},function(){return false})
r._handleFocus(e,a)},onBlur:function t(){if(e===r.cursorPosition[0]&&a===r.cursorPosition[1]){r.props.onChange({cursorPosition:[0,0]},function(){return false})}r._handleBlur(e,a)},onKeyDown:function t(n){r.handleKeyDown(e,a,n)},onChange:function t(n,i){r.onValueChange(e,a,n,i)}}
var u=void 0
if(r.props.apiOptions.customKeypad){var l={margin:n,minWidth:s,minHeight:i,boxSizing:"border-box",backgroundColor:o?"#f3f3f3":"#fff"}
u=React.createElement(SimpleKeypadInput,babelHelpers.extends({},p,{style:l,scrollable:true,keypadElement:r.props.keypadElement}))}else if(r.props.apiOptions.staticRender){u=React.createElement(MathOutput,p)}else if(r.props.numericInput){u=React.createElement(NumberInput,p)}else{u=React.createElement(TextInput,p)}return React.createElement("span",{key:a,className:"matrix-input-field"},u)}))})),this.props.suffix&&React.createElement("div",{className:"matrix-suffix"},React.createElement(Renderer,{content:this.props.suffix,linterContext:this.props.linterContext})))}
return r}(React.Component)
Matrix.propTypes={answers:PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string,PropTypes.number]))),apiOptions:ApiOptions.propTypes,cursorPosition:PropTypes.arrayOf(PropTypes.number),keypadElement:keypadElementPropType,matrixBoardSize:PropTypes.arrayOf(PropTypes.number).isRequired,prefix:PropTypes.string,suffix:PropTypes.string,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps}
Matrix.defaultProps={matrixBoardSize:[3,3],answers:[[]],prefix:"",suffix:"",cursorPosition:[0,0],apiOptions:ApiOptions.defaults,linterContext:linterContextDefault}
_.extend(Matrix,{validate:function e(r,t){var a=t.answers
var n=r.answers
var i=getMatrixSize(a)
var s=getMatrixSize(n)
var o=i[0]!==s[0]||i[1]!==s[1]
var p=KhanAnswerTypes.number.createValidatorFunctional
var u=null
var l=false
var c=false
_(s[0]).times(function(e){_(s[1]).times(function(r){if(n[e][r]==null||n[e][r].toString().length===0){l=true}if(!o){var t=p(a[e][r],{simplify:true})
var i=t(n[e][r])
if(i.message){u=i.message}if(!i.correct){c=true}}})})
if(l){return{type:"invalid",message:i18n._("Make sure you fill in all cells in the matrix.")}}if(o){return{type:"points",earned:0,total:1,message:null}}return{type:"points",earned:c?0:1,total:1,message:u}}})
var propTransform=function e(r){var t=_(r.matrixBoardSize[0]).times(function(){return stringArrayOfSize(r.matrixBoardSize[1])})
r=_.pick(r,"matrixBoardSize","prefix","suffix")
return _.extend(r,{answers:t})}
var staticTransform=function e(r){var t=_.pick(r,"matrixBoardSize","prefix","suffix")
t.answers=_.map(r.answers,function(e){return _.map(e,function(e){return e!=null?String(e):""})})
return t}
module.exports={name:"matrix",displayName:"Matrix",widget:Matrix,transform:propTransform,staticTransform:staticTransform,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/matcher.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var _=require("underscore")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var Sortable=require("../../perseus-all-package/components/sortable.jsx")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var shuffle=require("../../perseus-all-package/util.js").shuffle
var seededRNG=require("../../perseus-all-package/util.js").seededRNG
var _require2=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require2.linterContextProps,linterContextDefault=_require2.linterContextDefault
var HACKY_CSS_CLASSNAME="perseus-widget-matcher"
var Matcher=function(e){babelHelpers.inherits(t,e)
function t(){var r,s,a
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,i=Array(n),l=0;l<n;l++){i[l]=arguments[l]}return a=(r=(s=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),s),s.state={leftHeight:0,rightHeight:0},s.changeAndTrack=function(e){s.props.onChange(e)
s.props.trackInteraction()},s.onMeasureLeft=function(e){var t=_.max(e.heights)
s.setState({leftHeight:t})},s.onMeasureRight=function(e){var t=_.max(e.heights)
s.setState({rightHeight:t})},s.getUserInput=function(){return{left:s.refs.left.getOptions(),right:s.refs.right.getOptions()}},s.simpleValidate=function(e){return t.validate(s.getUserInput(),e)},r),babelHelpers.possibleConstructorReturn(s,a)}t.prototype.render=function e(){var t=seededRNG(this.props.problemNum)
var r
if(!this.props.orderMatters){r=this.props.left}else{r=shuffle(this.props.left,t,true)}var s=shuffle(this.props.right,t,true)
var a=_.any(this.props.labels)
var n={height:_.max([this.state.leftHeight,this.state.rightHeight])}
var i=this.props.apiOptions.isMobile?8:5
return React.createElement("table",{className:css(styles.widget)+" "+HACKY_CSS_CLASSNAME},React.createElement("tbody",null,a&&React.createElement("tr",{className:css(styles.row)},React.createElement("th",{className:css(styles.column,styles.columnLabel)},React.createElement(Renderer,{content:this.props.labels[0]||"...",linterContext:this.props.linterContext})),React.createElement("th",{className:css(styles.column,styles.columnRight,styles.columnLabel)},React.createElement(Renderer,{content:this.props.labels[1]||"...",linterContext:this.props.linterContext}))),React.createElement("tr",{className:css(styles.row)},React.createElement("td",{className:css(styles.column)},React.createElement(Sortable,{options:r,layout:"vertical",padding:this.props.padding,disabled:!this.props.orderMatters,constraints:n,onMeasure:this.onMeasureLeft,onChange:this.changeAndTrack,margin:i,linterContext:this.props.linterContext,ref:"left"})),React.createElement("td",{className:css(styles.column,styles.columnRight)},React.createElement(Sortable,{options:s,layout:"vertical",padding:this.props.padding,constraints:n,onMeasure:this.onMeasureRight,onChange:this.changeAndTrack,margin:i,linterContext:this.props.linterContext,ref:"right"})))))}
return t}(React.Component)
Matcher.propTypes={apiOptions:ApiOptions.propTypes,labels:PropTypes.array,left:PropTypes.array,onChange:PropTypes.func,orderMatters:PropTypes.bool,padding:PropTypes.bool,problemNum:PropTypes.number,right:PropTypes.array,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps}
Matcher.defaultProps={left:[],right:[],labels:["",""],orderMatters:false,padding:true,problemNum:0,onChange:function e(){},linterContext:linterContextDefault}
_.extend(Matcher,{validate:function e(t,r){var s=_.isEqual(t.left,r.left)&&_.isEqual(t.right,r.right)
return{type:"points",earned:s?1:0,total:1,message:null}}})
var padding=5
var border="1px solid #444"
var styles=StyleSheet.create({widget:{paddingTop:padding,maxWidth:"100%",minWidth:"auto"},row:{border:0},column:{padding:0,border:0},columnRight:{borderLeft:border},columnLabel:{fontWeight:"inherit",borderBottom:border,padding:"0 "+padding+"px "+padding+"px "+padding+"px",textAlign:"center"}})
module.exports={name:"matcher",displayName:"Two column matcher",widget:Matcher,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/measurer.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var createReactClass=require("create-react-class")
var ReactDOM=require("react-dom")
var _2=require("underscore")
var $=require("jquery")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var GraphUtils=require("../../perseus-all-package/util/graph-utils.js")
var SvgImage=require("../../perseus-all-package/components/svg-image.jsx")
var defaultImage={url:null,top:0,left:0}
var Measurer=createReactClass({displayName:"Measurer",propTypes:{apiOptions:ApiOptions.propTypes,box:PropTypes.arrayOf(PropTypes.number),image:PropTypes.shape({url:PropTypes.string,top:PropTypes.number,left:PropTypes.number}),showProtractor:PropTypes.bool,protractorX:PropTypes.number,protractorY:PropTypes.number,showRuler:PropTypes.bool,rulerLabel:PropTypes.string,rulerTicks:PropTypes.number,rulerPixels:PropTypes.number,rulerLength:PropTypes.number},getDefaultProps:function r(){return{box:[480,480],image:{},showProtractor:true,protractorX:7.5,protractorY:.5,showRuler:false,rulerLabel:"",rulerTicks:10,rulerPixels:40,rulerLength:10}},getInitialState:function r(){return{}},render:function r(){var e=_2.extend({},defaultImage,this.props.image)
return React.createElement("div",{className:"perseus-widget perseus-widget-measurer "+"graphie-container above-scratchpad",style:{width:this.props.box[0],height:this.props.box[1]}},e.url&&React.createElement("div",{style:{position:"relative",top:e.top,left:e.left}},React.createElement(SvgImage,{src:e.url})),React.createElement("div",{className:"graphie",ref:"graphieDiv"}))},componentDidMount:function r(){this.setupGraphie()},componentDidUpdate:function r(e){var t=_2.any(["box","showProtractor","showRuler","rulerLabel","rulerTicks","rulerPixels","rulerLength"],function(r){return e[r]!==this.props[r]},this)
if(t){this.setupGraphie()}},setupGraphie:function r(){var e=ReactDOM.findDOMNode(this.refs.graphieDiv)
$(e).empty()
var t=this.graphie=GraphUtils.createGraphie(e)
var a=[40,40]
var s=[[0,this.props.box[0]/a[0]],[0,this.props.box[1]/a[1]]]
t.init({range:s,scale:a})
t.addMouseLayer({allowScratchpad:true,setDrawingAreaAvailable:this.props.apiOptions.setDrawingAreaAvailable})
if(this.protractor){this.protractor.remove()}if(this.props.showProtractor){this.protractor=t.protractor([this.props.protractorX,this.props.protractorY])}if(this.ruler){this.ruler.remove()}if(this.props.showRuler){this.ruler=t.ruler({center:[(s[0][0]+s[0][1])/2,(s[1][0]+s[1][1])/2],label:this.props.rulerLabel,pixelsPerUnit:this.props.rulerPixels,ticksPerUnit:this.props.rulerTicks,units:this.props.rulerLength})}},getUserInput:function r(){return{}},simpleValidate:function r(e){return Measurer.validate(this.getUserInput(),e)},focus:$.noop})
_2.extend(Measurer,{validate:function r(e,t){return{type:"points",earned:1,total:1,message:null}}})
var propUpgrades={1:function _(r){var e=_2(r).chain().omit("imageUrl","imageTop","imageLeft").extend({image:{url:r.imageUrl,top:r.imageTop,left:r.imageLeft}}).value()
return e}}
module.exports={name:"measurer",displayName:"Measurer",widget:Measurer,version:{major:1,minor:0},propUpgrades:propUpgrades}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/molecule.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var draw=require("./molecule/molecule-drawing.jsx")
var _require=require("./molecule/molecule-layout.jsx"),layout=_require.layout
var SmilesParser=require("./molecule/smiles-parser.jsx")
var i18n=require("../../shared-package/i18n.js")
var parse=SmilesParser.parse
var ParseError=SmilesParser.ParseError
var borderSize=30
var Molecule=function(e){babelHelpers.inherits(r,e)
function r(){var t,s,a
babelHelpers.classCallCheck(this,r)
for(var n=arguments.length,o=Array(n),i=0;i<n;i++){o[i]=arguments[i]}return a=(t=(s=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),s),s.state={parsedSmiles:null,error:null},s.stateFromSmiles=function(e){try{s.setState({parsedSmiles:parse(e),error:null})}catch(e){if(e instanceof ParseError){s.setState({error:e.message})}else{throw e}}},s.setCanvasBounds=function(e,r){var t=Math.max.apply(Math,r.map(function(e){return e.pos?e.pos[0]:-Infinity}))
var s=Math.max.apply(Math,r.map(function(e){return e.pos?e.pos[1]:-Infinity}))
var a=Math.min.apply(Math,r.map(function(e){return e.pos?e.pos[0]:Infinity}))
var n=Math.min.apply(Math,r.map(function(e){return e.pos?e.pos[1]:Infinity}))
var o=t-a+2*borderSize
var i=s-n+2*borderSize
e.width=o
e.height=i
return[borderSize-a,borderSize-n]},s.canvasRender=function(){if(!!s.state.error||!s.state.parsedSmiles){return}var e=layout(s.state.parsedSmiles,s.props.rotationAngle)
var r=s.refs.canvas
var t=s.setCanvasBounds(r,e)
var a=r.getContext("2d")
a.clearRect(0,0,r.width,r.height)
a.save()
a.translate(t[0],t[1])
draw(a,e)
a.restore()},t),babelHelpers.possibleConstructorReturn(s,a)}r.prototype.UNSAFE_componentWillMount=function e(){this.stateFromSmiles(this.props.smiles)}
r.prototype.componentDidMount=function e(){this.canvasRender()}
r.prototype.UNSAFE_componentWillReceiveProps=function e(r){this.stateFromSmiles(r.smiles)}
r.prototype.componentDidUpdate=function e(){this.canvasRender()}
r.prototype.render=function e(){var r=React.createElement("canvas",{className:"molecule-canvas",id:this.props.id+"-molecule",ref:"canvas"},i18n.$_("A molecular structure drawing. SMILES notation: %(content)s",{content:this.props.smiles}))
if(this.state.error){r=React.createElement("div",{className:"error"},this.state.error)}return React.createElement("div",{className:"molecule-canvas"},r)}
return r}(React.Component)
Molecule.propTypes={id:PropTypes.string.isRequired,rotationAngle:PropTypes.number,smiles:PropTypes.string}
var MoleculeWidget=function(e){babelHelpers.inherits(r,e)
function r(){var t,s,a
babelHelpers.classCallCheck(this,r)
for(var n=arguments.length,o=Array(n),i=0;i<n;i++){o[i]=arguments[i]}return a=(t=(s=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),s),s.simpleValidate=function(){return{type:"points",earned:0,total:0,message:null}},s.getUserInput=function(){return[]},s.validate=function(e,r){return{type:"points",earned:0,total:0,message:null}},t),babelHelpers.possibleConstructorReturn(s,a)}r.prototype.render=function e(){return React.createElement(Molecule,{id:this.props.widgetId,smiles:this.props.smiles,rotationAngle:this.props.rotationAngle})}
return r}(React.Component)
MoleculeWidget.propTypes={rotationAngle:PropTypes.number,smiles:PropTypes.string,widgetId:PropTypes.string}
MoleculeWidget.defaultProps={rotationAngle:0}
module.exports={name:"molecule-renderer",displayName:"Molecule renderer",hidden:true,widget:MoleculeWidget,molecule:Molecule}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/number-line.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var NumberInput=require("../../perseus-all-package/components/number-input.jsx")
var MathOutput=require("../../perseus-all-package/components/math-output.jsx")
var SimpleKeypadInput=require("../../perseus-all-package/components/simple-keypad-input.jsx")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var keypadElementPropType=require("math-input").propTypes.keypadElementPropType
var Graphie=require("../../perseus-all-package/components/graphie.jsx")
var MovablePoint=Graphie.MovablePoint
var Line=Graphie.Line
var knumber=require("kmath").number
var KhanMath=require("../../perseus-all-package/util/math.js")
var KhanColors=require("../../perseus-all-package/util/colors.js")
var i18n=require("../../shared-package/i18n.js")
var bound=function e(i,r,n){return Math.min(Math.max(i,r),n)}
var assert=require("../../perseus-all-package/interactive2/interactive-util.js").assert
var EN_DASH="–"
var horizontalPadding=30
var reverseRel={ge:"le",gt:"lt",le:"ge",lt:"gt"}
var toggleStrictRel={ge:"gt",gt:"ge",le:"lt",lt:"le"}
function formatImproper(e,i){if(i===1){return""+e}else{return"\\dfrac{"+e+"}{"+i+"}"}}function formatMixed(e,i){if(e<0){return"-"+formatMixed(-e,i)}var r=Math.floor(e/i)
if(r===0){return formatImproper(e,i)}else if(e-r*i===0){return""+r}else{return r+formatImproper(e-r*i,i)}}function formatNonReduced(e,i,r){var n=Math.floor(r/i)
return formatImproper(e*n,r)}var _label=function e(i,r,n,t,s){t=t||n
if(r==="decimal"||r==="decimal ticks"){return i.label([n,-.53],Math.round(t*100)/100,"center")}else if(r==="improper"){var a=KhanMath.toFraction(t)
return i.label([n,-.17],formatImproper(a[0],a[1]),"below")}else if(r==="mixed"){var o=KhanMath.toFraction(t)
return i.label([n,-.17],formatMixed(o[0],o[1]),"below")}else if(r==="non-reduced"){var l=KhanMath.toFraction(t)
return i.label([n,-.17],formatNonReduced(l[0],l[1],s),"below")}}
var TickMarks=Graphie.createSimpleClass(function(e,i){if(!_.isFinite(i.tickStep)||i.tickStep<=0){return[]}var r=[]
var n=i.range
var t=i.labelRange
var s=t[0]==null?n[0]:t[0]
var a=t[1]==null?n[1]:t[1]
var o
if(i.labelStyle==="non-reduced"){var l=[s,a]
for(var p=0;p<=i.numDivisions;p++){var u=n[0]+p*i.tickStep
l.push(u)}var c=function e(i){return knumber.toFraction(i)[1]}
var v=_.map(l,c)
o=_.reduce(v,function(e,i){return KhanMath.getLCM(e,i)})}else{o=undefined}for(var m=0;m<=i.numDivisions;m++){var h=n[0]+m*i.tickStep
r.push(e.line([h,-.2],[h,.2]))
var d=i.labelTicks
if(d||i.labelStyle==="decimal ticks"){r.push(_label(e,i.labelStyle,h,h,o))}}r.push(e.style(i.isMobile?{color:KhanColors.BLUE_D}:{},function(){return _label(e,i.labelStyle,s,s,o)}))
r.push(e.style(i.isMobile?{color:KhanColors.BLUE_D}:{},function(){return _label(e,i.labelStyle,a,a,o)}))
e.style({stroke:i.isMobile?KhanColors.BLUE_D:KhanColors.DYNAMIC,strokeWidth:3.5},function(){r.push(e.line([s,-.2],[s,.2]))
r.push(e.line([a,-.2],[a,.2]))})
return r})
var NumberLine=function(e){babelHelpers.inherits(i,e)
function i(){var r,n,t
babelHelpers.classCallCheck(this,i)
for(var s=arguments.length,a=Array(s),o=0;o<s;o++){a[o]=arguments[o]}return t=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),n),_initialiseProps.call(n),r),babelHelpers.possibleConstructorReturn(n,t)}i.prototype.render=function e(){var i=this.props.divisionRange
var r=i[0]+EN_DASH+i[1]
var n=this.props.numDivisions<i[0]||this.props.numDivisions>i[1]
var t=React.createElement("div",null,React.createElement("input",{type:"button",className:"simple-button",value:i18n._("Switch direction"),onClick:this.handleReverse}),React.createElement("input",{type:"button",className:"simple-button",value:_(["le","ge"]).contains(this.props.rel)?i18n._("Make circle open"):i18n._("Make circle filled"),onClick:this.handleToggleStrict}))
var s
if(this.props.isTickCtrl){var a
if(this.props.apiOptions.customKeypad){a=SimpleKeypadInput}else if(this.props.apiOptions.staticRender){a=MathOutput}else{a=NumberInput}s=React.createElement("label",null,i18n._("Number of divisions:")," ",React.createElement(a,{ref:"tick-ctrl",value:this.state.numDivisionsEmpty?null:this.props.numDivisions||i[0],checkValidity:function e(r){return r>=i[0]&&r<=i[1]},onChange:this.onNumDivisionsChange,onFocus:this._handleTickCtrlFocus,onBlur:this._handleTickCtrlBlur,useArrowKeys:true,keypadElement:this.props.keypadElement}))}return React.createElement("div",{className:"perseus-widget "+"perseus-widget-interactive-number-line"},s,!this.isValid()?React.createElement("div",{className:"perseus-error"},i18n.doNotTranslate("Invalid number line configuration.")):this.props.isTickCtrl&&n?React.createElement("div",{className:"perseus-error"},i18n.$_("Please make sure the number of divisions is "+"in the range %(divRangeString)s.",{divRangeString:r})):this._renderGraphie(),!this.props.static&&this.props.isInequality&&t)}
return i}(React.Component)
NumberLine.propTypes=babelHelpers.extends({},Changeable.propTypes,{range:PropTypes.arrayOf(PropTypes.number).isRequired,labelRange:PropTypes.arrayOf(PropTypes.number).isRequired,labelStyle:PropTypes.string.isRequired,labelTicks:PropTypes.bool.isRequired,divisionRange:PropTypes.arrayOf(PropTypes.number).isRequired,numDivisions:PropTypes.number.isRequired,snapDivisions:PropTypes.number.isRequired,isTickCtrl:PropTypes.bool.isRequired,isInequality:PropTypes.bool.isRequired,numLinePosition:PropTypes.number.isRequired,rel:PropTypes.oneOf(["lt","gt","le","ge"]),onFocus:PropTypes.func.isRequired,onBlur:PropTypes.func.isRequired,onChange:PropTypes.func.isRequired,apiOptions:ApiOptions.propTypes,keypadElement:keypadElementPropType,static:PropTypes.bool,showTooltips:PropTypes.bool,trackInteraction:PropTypes.func.isRequired})
NumberLine.defaultProps={range:[0,10],labelStyle:"decimal",labelRange:[null,null],divisionRange:[1,12],labelTicks:true,isTickCtrl:false,isInequality:false,numLinePosition:0,snapDivisions:2,showTooltips:false,rel:"ge",apiOptions:ApiOptions.defaults}
var _initialiseProps=function e(){var i=this
this.state={numDivisionsEmpty:false}
this.change=function(){for(var e=arguments.length,r=Array(e),n=0;n<e;n++){r[n]=arguments[n]}return Changeable.change.apply(i,r)}
this.isValid=function(){var e=i.props.range
var r=i.props.numLinePosition
var n=i.props.divisionRange
r=r==null?e[0]:r
return e[0]<e[1]&&knumber.sign(r-e[0])>=0&&knumber.sign(r-e[1])<=0&&n[0]<n[1]&&0<i.props.numDivisions&&0<i.props.snapDivisions}
this.onNumDivisionsChange=function(e,r){var n=i.props.divisionRange.slice()
var t=i.props.range[1]-i.props.range[0]
e=Math.round(e)
e=e<0?e*-1:e
if(e){var s=_.extend({},i.props,{tickStep:t/e})
var a=i.snapNumLinePosition(s,i.props.numLinePosition)
i.setState({numDivisionsEmpty:false},function(){i.props.onChange({divisionRange:n,numDivisions:e,numLinePosition:a},r)})}else{i.setState({numDivisionsEmpty:true},r)}}
this._handleTickCtrlFocus=function(){i.props.onFocus(["tick-ctrl"])}
this._handleTickCtrlBlur=function(){i.props.onBlur(["tick-ctrl"])}
this.focus=function(){if(i.props.isTickCtrl){i.refs["tick-ctrl"].focus()
return true}}
this.focusInputPath=function(e){if(e.length===1){i.refs[e[0]].focus()}}
this.blurInputPath=function(e){if(e.length===1){i.refs[e[0]].blur()}}
this.getInputPaths=function(){if(i.props.isTickCtrl){return[["tick-ctrl"]]}else{return[]}}
this.getDOMNodeForPath=function(e){if(e.length===1){return ReactDOM.findDOMNode(i.refs[e[0]])}}
this.getGrammarTypeForPath=function(e){if(e.length===1&&e[0]==="tick-ctrl"){return"number"}}
this.setInputValue=function(e,r,n){if(e.length===1&&e[0]==="tick-ctrl"){i.onNumDivisionsChange(r,n)}}
this._renderGraphie=function(){var e=i.props.range
var r=e[1]-e[0]
var n=_.pick(i.props,["range","isTickCtrl"])
var t=_.extend({},i.props,{tickStep:r/i.props.numDivisions})
return React.createElement(Graphie,{ref:"graphie",key:i.props.labelStyle,box:[i.props.apiOptions.isMobile?288:460,80],options:n,onMouseDown:function e(r){i.refs.graphie.movables.numberLinePoint.grab(r)},setup:i._setupGraphie,setDrawingAreaAvailable:i.props.apiOptions.setDrawingAreaAvailable,isMobile:i.props.apiOptions.isMobile},React.createElement(TickMarks,babelHelpers.extends({},_.pick(t,["range","numDivisions","labelTicks","labelStyle","labelRange","tickStep"]),{isMobile:i.props.apiOptions.isMobile})),i._renderInequality(t),i._renderNumberLinePoint(t))}
this.snapNumLinePosition=function(e,i){var r=e.range[0]
var n=e.range[1]
var t=e.tickStep/e.snapDivisions
var s=bound(i,r,n)
s=r+knumber.roundTo(s-r,t)
assert(_.isFinite(s))
return s}
this._renderNumberLinePoint=function(e){var r=_(["lt","gt"]).contains(e.rel)
var n
if(r){n=KhanColors._BACKGROUND}else if(e.static){n=KhanColors.DYNAMIC}else{n=KhanColors.INTERACTIVE}var t={fill:n,stroke:e.static?KhanColors.DYNAMIC:KhanColors.INTERACTIVE,"stroke-width":r?3:1}
var s={fill:r?KhanColors._BACKGROUND:KhanColors.INTERACTING,"stroke-width":r?3:1}
var a=e.isInequality?{stroke:KhanColors.INTERACTIVE,"fill-opacity":r?0:1}:{}
return React.createElement(MovablePoint,{ref:"numberLinePoint",pointSize:6,coord:[e.numLinePosition,0],constraints:[function(e,i){return[e[0],i[1]]},function(r,n){var t=i.snapNumLinePosition(e,r[0])
return[t,r[1]]}],normalStyle:t,highlightStyle:s,onMove:function e(r){i.change({numLinePosition:r[0]})
i.props.trackInteraction()},isMobile:i.props.apiOptions.isMobile,mobileStyleOverride:a,showTooltips:i.props.showTooltips,xOnlyTooltip:true})}
this.handleReverse=function(){var e=reverseRel[i.props.rel]
i.props.onChange({rel:e})}
this.handleToggleStrict=function(){var e=toggleStrictRel[i.props.rel]
i.props.onChange({rel:e})}
this._getInequalityEndpoint=function(e){var i=_(["ge","gt"]).contains(e.rel)
var r=400
var n=e.range
var t=(n[1]-n[0])/r
var s=horizontalPadding*t
var a=n[0]-s
var o=n[1]+s
var l=i?[o,0]:[a,0]
return l}
this._renderInequality=function(e){if(e.isInequality){var r=i._getInequalityEndpoint(e)
var n={arrows:"->",stroke:i.props.apiOptions.isMobile?KhanColors.INTERACTIVE:KhanColors.DYNAMIC,strokeWidth:3.5}
var t=["ge","gt"].includes(e.rel)
return React.createElement(Line,{start:[(t?.4:-.4)+e.numLinePosition,0],end:r,style:n})}else{return null}}
this._setupGraphie=function(e,r){if(!i.isValid()){return}var n=i.props.apiOptions.isMobile?288-horizontalPadding*2:400
var t=r.range
var s=(t[1]-t[0])/n
var a=horizontalPadding*s
var o=t[0]-a
var l=t[1]+a
var p=i.props.labelStyle==="improper"||i.props.labelStyle==="mixed"||i.props.labelStyle==="non-reduced"
var u=p?-1.5:-1
var c=1
e.init({range:[[o,l],[u,c]],scale:[1/s,40],isMobile:i.props.apiOptions.isMobile})
var v=(t[0]+t[1])/2
e.line([v,0],[l,0],{arrows:"->"})
e.line([v,0],[o,0],{arrows:"->"})}
this.getUserInput=function(){return{numLinePosition:i.props.numLinePosition,rel:i.props.isInequality?i.props.rel:"eq",numDivisions:i.props.numDivisions,divisionRange:i.props.divisionRange}}
this.simpleValidate=function(e){return NumberLine.validate(i.getUserInput(),e)}}
_.extend(NumberLine,{validate:function e(i,r){var n=r.range
var t=i.divisionRange
var s=r.initialX!=null?r.initialX:n[0]
var a=r.isInequality?"ge":"eq"
var o=r.correctRel||"eq"
var l=knumber.equal(i.numLinePosition,r.correctX||0)
var p=i.numDivisions>t[1]||i.numDivisions<t[0]
if(i.isTickCrtl&&p){return{type:"invalid",message:"Number of divisions is outside the allowed range."}}else if(l&&o===i.rel){return{type:"points",earned:1,total:1,message:null}}else if(i.numLinePosition===s&&i.rel===a){return{type:"invalid",message:null}}else{return{type:"points",earned:0,total:1,message:null}}}})
var numberLineTransform=function e(i){var r=_.pick(i,["range","labelRange","labelStyle","labelTicks","divisionRange","snapDivisions","isTickCtrl","isInequality","showTooltips"])
var n=i.initialX!=null?i.initialX:i.range[0]
var t=i.range[1]-i.range[0]
var s
if(i.numDivisions!=null){s=i.numDivisions}else if(i.tickStep!=null){s=t/i.tickStep}else{s=undefined}_.extend(r,{numLinePosition:n,numDivisions:s,snapDivisions:r.snapDivisions||undefined})
return r}
var staticTransform=function e(i){var r=_.pick(i,["range","labelRange","labelStyle","labelTicks","divisionRange","snapDivisions","isInequality"])
var n=i.correctX!=null?i.correctX:i.range[0]
var t=i.range[1]-i.range[0]
var s
if(i.numDivisions!=null){s=i.numDivisions}else if(i.tickStep!=null){s=t/i.tickStep}else{s=undefined}_.extend(r,{numLinePosition:n,numDivisions:s,rel:i.isInequality?i.correctRel:null,snapDivisions:r.snapDivisions||undefined})
return r}
module.exports={name:"number-line",displayName:"Number line",widget:NumberLine,transform:numberLineTransform,staticTransform:staticTransform}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/orderer.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var $=require("jquery")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var Util=require("../../perseus-all-package/util.js")
var ApiClassNames=require("../../perseus-all-package/perseus-api.jsx").ClassNames
var _require=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require.linterContextProps,linterContextDefault=_require.linterContextDefault
var PlaceholderCard=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){return React.createElement("div",{className:"card-wrap "+ApiClassNames.INTERACTIVE,style:{width:this.props.width}},React.createElement("div",{className:"card placeholder",style:{height:this.props.height}}))}
return t}(React.Component)
PlaceholderCard.propTypes={width:PropTypes.number.isRequired,height:PropTypes.number.isRequired}
var DragHintCard=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){return React.createElement("div",{className:"card-wrap "+ApiClassNames.INTERACTIVE},React.createElement("div",{className:"card drag-hint"}))}
return t}(React.Component)
var PropTypePosition=PropTypes.shape({left:PropTypes.number,top:PropTypes.number})
var Card=function(e){babelHelpers.inherits(t,e)
function t(){var r,o,n
babelHelpers.classCallCheck(this,t)
for(var s=arguments.length,a=Array(s),i=0;i<s;i++){a[i]=arguments[i]}return n=(r=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),o),o.state={dragging:false},o.bindMouseMoveUp=function(){o.mouseMoveUpBound=true
$(document).on("mousemove",o.onMouseMove)
$(document).on("mouseup",o.onMouseUp)},o.unbindMouseMoveUp=function(){o.mouseMoveUpBound=false
$(document).off("mousemove",o.onMouseMove)
$(document).off("mouseup",o.onMouseUp)},o.onMouseDown=function(e){e.preventDefault()
var t=Util.extractPointerLocation(e)
if(t){o.setState({dragging:true})
o.bindMouseMoveUp()
o.props.onMouseDown&&o.props.onMouseDown(t,o)}},o.onMouseMove=function(e){if(!o.state.dragging){return}e.preventDefault()
var t=Util.extractPointerLocation(e)
if(t){o.props.onMouseMove&&o.props.onMouseMove(t)}},o.onMouseUp=function(e){e.preventDefault()
var t=Util.extractPointerLocation(e)
if(t){o.setState({dragging:false})
o.unbindMouseMoveUp()
o.props.onMouseUp&&o.props.onMouseUp(t)}},r),babelHelpers.possibleConstructorReturn(o,n)}t.prototype.render=function e(){var t={}
if(this.props.floating){t={position:"absolute",left:this.props.startOffset.left,top:this.props.startOffset.top}}if(this.props.width){t.width=this.props.width}var r=["card"]
if(this.props.stack){r.push("stack")}if(this.props.floating&&!this.props.animating){r.push("dragging")
t.left+=this.props.mouse.left-this.props.startMouse.left
t.top+=this.props.mouse.top-this.props.startMouse.top}var o=_.pick(this.props,"content")
var n=this.props.animating?$.noop:this.onMouseDown
return React.createElement("div",{className:"card-wrap "+ApiClassNames.INTERACTIVE,style:t,onMouseDown:n,onTouchStart:n,onTouchEnd:this.onMouseUp,onTouchCancel:this.onMouseUp},React.createElement("div",{className:r.join(" ")},React.createElement(Renderer,babelHelpers.extends({},o,{linterContext:this.props.linterContext}))))}
t.prototype.shouldComponentUpdate=function e(t,r){return this.props.floating||t.floating||this.props.content!==t.content||this.props.fakeRef!==t.fakeRef}
t.prototype.componentDidMount=function e(){this.mouseMoveUpBound=false
document.addEventListener("touchmove",this.onMouseMove,Util.supportsPassiveEvents()?{passive:false}:false)}
t.prototype.componentDidUpdate=function e(t,r){if(this.props.animating&&!t.animating){var o=15*Math.sqrt(Math.sqrt(Math.pow(this.props.animateTo.left-this.props.startOffset.left,2)+Math.pow(this.props.animateTo.top-this.props.startOffset.top,2)))
$(ReactDOM.findDOMNode(this)).animate(this.props.animateTo,Math.max(o,1),this.props.onAnimationEnd)}}
t.prototype.componentWillUnmount=function e(){if(this.mouseMoveUpBound){console.warn("Removing an element with bound event handlers.")
this.unbindMouseMoveUp()
Util.resetTouchHandlers()}document.removeEventListener("touchmove",this.onMouseMove)}
return t}(React.Component)
Card.propTypes={floating:PropTypes.bool.isRequired,animating:PropTypes.bool,width:PropTypes.number,stack:PropTypes.bool,onMouseDown:PropTypes.func,onMouseMove:PropTypes.func,onMouseUp:PropTypes.func,startMouse:PropTypePosition,startOffset:PropTypePosition,animateTo:PropTypePosition,onAnimationEnd:PropTypes.func,linterContext:linterContextProps}
Card.defaultProps={stack:false,animating:false,linterContext:linterContextDefault}
var NORMAL="normal",AUTO="auto",HORIZONTAL="horizontal",VERTICAL="vertical"
var Orderer=function(e){babelHelpers.inherits(t,e)
function t(){var r,o,n
babelHelpers.classCallCheck(this,t)
for(var s=arguments.length,a=Array(s),i=0;i<s;i++){a[i]=arguments[i]}return n=(r=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),o),o.state={current:[],dragging:false,placeholderIndex:null},o.onClick=function(e,t,r,n){var s=$(ReactDOM.findDOMNode(n))
var a=o.state.current.slice()
var i
var p=null
if(e==="current"){a.splice(t,1)
i=o.state.current[t]
p=t}else if(e==="bank"){i=o.props.options[t]}o.setState({current:a,dragging:true,placeholderIndex:p,dragKey:i.key,dragContent:i.content,dragWidth:s.width(),dragHeight:s.height(),grabPos:r,mousePos:r,offsetPos:s.position()})},o.onRelease=function(e){var t=o.refs.dragging
if(t==null){return}var r=o.isCardInBank(t)
var n=o.state.placeholderIndex
var s=function e(){var t=o.state.current.slice()
if(!r){var s={content:o.state.dragContent,key:_.uniqueId("perseus_draggable_card_"),width:o.state.dragWidth}
t.splice(n,0,s)}o.props.onChange({current:t})
o.setState({current:t,dragging:false,placeholderIndex:null,animating:false})
o.props.trackInteraction()}
var a=$(ReactDOM.findDOMNode(t)).position()
var i=null
if(r){_.each(o.props.options,function(e,t){if(e.content===this.state.dragContent){var r=ReactDOM.findDOMNode(this.refs["bank"+t])
i=$(r).position()}},o)}else if(o.refs.placeholder!=null){i=$(ReactDOM.findDOMNode(o.refs.placeholder)).position()}if(i==null){s()}else{o.setState({offsetPos:a,animateTo:i,onAnimationEnd:s,animating:true,dragging:false})}},o.onMouseMove=function(e){var t=o.refs.dragging
if(t==null){return}var r
if(o.isCardInBank(t)){r=null}else{r=o.findCorrectIndex(t,o.state.current)}o.setState({mousePos:e,placeholderIndex:r})},o.findCorrectIndex=function(e,t){var r=o.props.layout===HORIZONTAL,n=$(ReactDOM.findDOMNode(o.refs.dragList)),s=n.offset().left,a=n.offset().top,i=$(ReactDOM.findDOMNode(e)).offset().left-s,p=$(ReactDOM.findDOMNode(e)).offset().top-a,l=0,u=0,c=0
if(r){_.each(t,function(e,t){var r=ReactDOM.findDOMNode(this.refs["sortable"+t])
var o=$(r).outerWidth(true)
if(i>u+o/2){l+=1}u+=o},o)}else{_.each(t,function(e,t){var r=ReactDOM.findDOMNode(this.refs["sortable"+t])
var o=$(r).outerHeight(true)
if(p>c+o/2){l+=1}c+=o},o)}return l},o.isCardInBank=function(e){if(e==null){return false}var t=o.props.layout===HORIZONTAL,r=$(ReactDOM.findDOMNode(e)),n=$(ReactDOM.findDOMNode(o.refs.bank)),s=r.offset(),a=n.offset(),i=r.outerHeight(true),p=n.outerHeight(true),l=n.outerWidth(true),u=ReactDOM.findDOMNode(o.refs.dragList),c=$(u).width(),d=r.outerWidth(true)
if(t){return s.top+i/2<a.top+p}else{return s.left+d/2<a.left+l}},o.getUserInput=function(){return{current:_.map(o.props.current,function(e){return e.content})}},o.simpleValidate=function(e){return t.validate(o.getUserInput(),e)},r),babelHelpers.possibleConstructorReturn(o,n)}t.prototype.UNSAFE_componentWillReceiveProps=function e(t){if(!_.isEqual(this.props.current,t.current)){this.setState({current:t.current})}}
t.prototype.render=function e(){var t=this
var r=this.state.dragging&&React.createElement(Card,{ref:"dragging",floating:true,content:this.state.dragContent,startOffset:this.state.offsetPos,startMouse:this.state.grabPos,mouse:this.state.mousePos,width:this.state.dragWidth,onMouseUp:this.onRelease,onMouseMove:this.onMouseMove,key:this.state.dragKey||"draggingCard",linterContext:this.props.linterContext})
var o=this.state.animating&&React.createElement(Card,{floating:true,animating:true,content:this.state.dragContent,startOffset:this.state.offsetPos,width:this.state.dragWidth,animateTo:this.state.animateTo,onAnimationEnd:this.state.onAnimationEnd,key:this.state.dragKey||"draggingCard",linterContext:this.props.linterContext})
var n=_.map(this.state.current,function(e,t){return React.createElement(Card,{ref:"sortable"+t,fakeRef:"sortable"+t,floating:false,content:e.content,width:e.width,key:e.key,linterContext:this.props.linterContext,onMouseDown:this.state.animating?$.noop:this.onClick.bind(null,"current",t)})},this)
if(this.state.placeholderIndex!=null){var s=React.createElement(PlaceholderCard,{ref:"placeholder",width:this.state.dragWidth,height:this.state.dragHeight,key:"placeholder"})
n.splice(this.state.placeholderIndex,0,s)}var a=n.length>0
n.push(r,o)
var i=React.createElement("div",{className:"perseus-clearfix draggable-box"},!a&&React.createElement(DragHintCard,null),React.createElement("div",{ref:"dragList"},n))
var p=React.createElement("div",{ref:"bank",className:"bank perseus-clearfix"},_.map(this.props.options,function(e,r){return React.createElement(Card,{ref:"bank"+r,floating:false,content:e.content,stack:true,key:r,linterContext:t.props.linterContext,onMouseDown:t.state.animating?$.noop:t.onClick.bind(null,"bank",r),onMouseMove:t.onMouseMove,onMouseUp:t.onRelease})},this))
return React.createElement("div",{className:"draggy-boxy-thing orderer "+"height-"+this.props.height+" "+"layout-"+this.props.layout+" "+"above-scratchpad blank-background "+"perseus-clearfix "+ApiClassNames.INTERACTIVE,ref:"orderer"},p,i)}
return t}(React.Component)
Orderer.propTypes={correctOptions:PropTypes.array,current:PropTypes.array,height:PropTypes.oneOf([NORMAL,AUTO]),layout:PropTypes.oneOf([HORIZONTAL,VERTICAL]),options:PropTypes.array,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps}
Orderer.defaultProps={current:[],options:[],correctOptions:[],height:NORMAL,layout:HORIZONTAL,linterContext:linterContextDefault}
_.extend(Orderer,{validate:function e(t,r){if(t.current.length===0){return{type:"invalid",message:null}}var o=_.isEqual(t.current,_.pluck(r.correctOptions,"content"))
return{type:"points",earned:o?1:0,total:1,message:null}}})
module.exports={name:"orderer",displayName:"Orderer",widget:Orderer,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/passage.jsx", function(require, module, exports) {
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var React=require("react")
var ReactDOM=require("react-dom")
var _=require("underscore")
var $=require("jquery")
var KA=require("../../shared-package/ka.js")
var HighlightableContent=require("../../perseus-all-package/components/highlighting/highlightable-content.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var PassageMarkdown=require("./passage/passage-markdown.jsx")
var _require2=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextDefault=_require2.linterContextDefault
var i18n=require("../../shared-package/i18n.js")
var LineHeightMeasurer=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.measureLineHeight=function e(){if(typeof this._cachedLineHeight!=="number"){this.forceMeasureLineHeight()}return this._cachedLineHeight}
t.prototype.forceMeasureLineHeight=function e(){this.$body.text(" ")
this._cachedLineHeight=this.$end.offset().top-this.$body.offset().top
this.$body.text("")}
t.prototype.render=function e(){var t=this
return React.createElement("div",{className:css(styles.measurer)},React.createElement("div",null,React.createElement("div",{ref:function e(r){return t.$body=$(r)},className:"paragraph"}),React.createElement("div",{ref:function e(r){return t.$end=$(r)}})))}
return t}(React.Component)
var styles=StyleSheet.create({measurer:{position:"absolute",width:"100%",top:0,left:0}})
var Passage=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,s
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,i=Array(a),o=0;o<a;o++){i[o]=arguments[o]}return s=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),n),n.state={nLines:null,startLineNumbersAfter:0,stylesAreApplied:false},n._handleSerializedHighlightsUpdate=function(e){n.props.onChange({highlights:e})},r),babelHelpers.possibleConstructorReturn(n,s)}t.prototype.componentDidMount=function e(){var t=this
this._updateState()
this._onResize=_.throttle(function(){if(t.shouldRenderJipt()){return}t._lineHeightMeasurer.forceMeasureLineHeight()
t._updateState()},500)
window.addEventListener("resize",this._onResize)
window.setTimeout(function(){t.setState({stylesAreApplied:true})},0)}
t.prototype.shouldComponentUpdate=function e(t,r){return!_.isEqual(this.props,t)||!_.isEqual(this.state,r)}
t.prototype.componentDidUpdate=function e(){this._updateState()}
t.prototype.componentWillUnmount=function e(){window.removeEventListener("resize",this._onResize)}
t.prototype._updateState=function e(){if(this.shouldRenderJipt()){return}this.setState({nLines:this._measureLines(),startLineNumbersAfter:this._getInitialLineNumber()})}
t.prototype._measureLines=function e(){var t=$(ReactDOM.findDOMNode(this.refs.content))
var r=t.height()
var n=this._getLineHeight()
var s=Math.round(r/n)
return s}
t.prototype._getInitialLineNumber=function e(){var t=this
var r=true
var n=this.props.findWidgets(function(e,n){if(n.type!=="passage"){return false}if(e===t.props.widgetId){r=false}return r})
return n.map(function(e){return e.getLineCount()}).reduce(function(e,t){return e+t},0)}
t.prototype._getLineHeight=function e(){return this._lineHeightMeasurer.measureLineHeight()}
t.prototype.getLineCount=function e(){if(this.state.nLines!=null){return this.state.nLines}else{return this._measureLines()}}
t.prototype._getStartRefLineNumber=function e(t){var r=PassageMarkdown.START_REF_PREFIX+t
var n=this.refs[r]
if(!n){return null}var s=$(ReactDOM.findDOMNode(n))
var a=s.next()
if(a.length===0){a=s}var i=a.offset().top
return this.state.startLineNumbersAfter+1+this._convertPosToLineNumber(i)}
t.prototype._getEndRefLineNumber=function e(t){var r=PassageMarkdown.END_REF_PREFIX+t
var n=this.refs[r]
if(!n){return null}var s=$(ReactDOM.findDOMNode(n))
var a=s.prev()
if(a.length===0){a=s}var i=a.height()
var o=a.offset().top
var u=this._convertPosToLineNumber(o+i)
if(i===0){u+=1}return this.state.startLineNumbersAfter+u}
t.prototype._convertPosToLineNumber=function e(t){var r=$(ReactDOM.findDOMNode(this.refs.content))
var n=t-r.offset().top
var s=this._getLineHeight()
var a=Math.round(n/s)
return a}
t.prototype._getRefContent=function e(t){var r=PassageMarkdown.START_REF_PREFIX+t
var n=this.refs[r]
if(!n){return null}return n.getRefContent()}
t.prototype.getReference=function e(t){var r=this._getStartRefLineNumber(t)
var n=this._getEndRefLineNumber(t)
if(r==null||n==null){return null}var s=this._getRefContent(t)
return{startLine:r,endLine:n,content:s}}
t.prototype.getUserInput=function e(){return null}
t.prototype.simpleValidate=function e(r){return t.validate(this.getUserInput(),r)}
t.validate=function e(t,r){return{type:"points",earned:0,total:0,message:null}}
t.prototype._renderInstructions=function e(t){var r=t.firstQuestionRef
var n=t.firstSentenceRef
var s=""
if(r){s+=i18n._("The symbol %(questionSymbol)s indicates that question "+"%(questionNumber)s references this portion of the "+"passage.",{questionSymbol:"[["+r+"]]",questionNumber:r})}if(n){s+=i18n._(" The symbol %(sentenceSymbol)s indicates that the "+"following sentence is referenced in a question.",{sentenceSymbol:"["+n+"]"})}var a=PassageMarkdown.parse(s)
return React.createElement("div",{className:"perseus-widget-passage-instructions"},PassageMarkdown.output(a))}
t.prototype.shouldRenderJipt=function e(){return typeof KA!=="undefined"&&KA.language==="en-pt"&&this.props.passageText.indexOf("crwdns")!==-1}
t.prototype._renderContent=function e(t){var r=this
var n=this.state.stylesAreApplied
var s=!this.props.reviewModeRubric
return React.createElement(HighlightableContent,{editable:s,enabled:n,onSerializedHighlightsUpdate:this._handleSerializedHighlightsUpdate,serializedHighlights:this.props.highlights},React.createElement("div",{ref:"content"},React.createElement(LineHeightMeasurer,{ref:function e(t){return r._lineHeightMeasurer=t}}),PassageMarkdown.output(t)))}
t.prototype._hasFootnotes=function e(){var t=this.props.footnotes
var r=/^\s*$/.test(t)
return!r}
t.prototype._renderFootnotes=function e(){var t=this.props.footnotes
var r=PassageMarkdown.parse(t)
return PassageMarkdown.output(r)}
t.prototype.render=function e(){var t=this
var r=void 0
var n=this.state.nLines
if(this.props.showLineNumbers&&n){r=_.range(1,n+1).map(function(e){if(e===4&&n>4){return React.createElement("span",{key:"line-marker",className:"line-marker"},i18n._("Line"))}else{return React.createElement("span",{key:e},e+t.state.startLineNumbersAfter)}})}var s={firstSentenceRef:null,firstQuestionRef:null}
var a=/("{1})([^"]*)("{1})/g
var i=this.props.passageText.replace(a,"“$2”")
var o=PassageMarkdown.parse(i,s)
var u=/\S/.test(this.props.passageTitle)
return React.createElement("div",null,React.createElement("div",{className:"perseus-widget-passage-container"},this._renderInstructions(s),React.createElement("div",{className:"perseus-widget-passage"},u&&React.createElement("h3",{className:"passage-title"},React.createElement(Renderer,{content:this.props.passageTitle,linterContext:this.props.linterContext})),r&&React.createElement("div",{className:"line-numbers","aria-hidden":true},r),!u&&React.createElement("h3",{className:"perseus-sr-only"},i18n._("Beginning of reading passage.")),React.createElement("div",{className:"passage-text"},this.shouldRenderJipt()?React.createElement(Renderer,{content:this.props.passageText}):this._renderContent(o)),this._hasFootnotes()&&[React.createElement("h4",{key:"footnote-start",className:"perseus-sr-only"},i18n._("Beginning of reading passage footnotes.")),React.createElement("div",{key:"footnotes",className:"footnotes"},this._renderFootnotes())],React.createElement("div",{className:"perseus-sr-only"},i18n._("End of reading passage.")))))}
return t}(React.Component)
Passage.defaultProps={passageTitle:"",passageText:"",footnotes:"",showLineNumbers:true,highlights:{},linterContext:linterContextDefault}
module.exports={name:"passage",displayName:"Passage (SAT only)",widget:Passage,transform:function e(t){return _.pick(t,"passageTitle","passageText","footnotes","showLineNumbers")},isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/passage-ref-target.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var WidgetJsonifyDeprecated=require("../../perseus-all-package/mixins/widget-jsonify-deprecated.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var _require=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require.linterContextProps,linterContextDefault=_require.linterContextDefault
var PassageRefTarget=function(e){babelHelpers.inherits(r,e)
function r(){var t,n,a
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,i=Array(s),l=0;l<s;l++){i[l]=arguments[l]}return a=(t=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),n),_initialiseProps.call(n),t),babelHelpers.possibleConstructorReturn(n,a)}r.prototype.render=function e(){return React.createElement(Renderer,{content:this.props.content,inline:true,apiOptions:this.props.apiOptions,linterContext:this.props.linterContext})}
return r}(React.Component)
PassageRefTarget.propTypes=babelHelpers.extends({},Changeable.propTypes,{content:PropTypes.string,linterContext:linterContextProps})
PassageRefTarget.defaultProps={content:"",linterContext:linterContextDefault}
var _initialiseProps=function e(){var r=this
this.getUserInput=function(){return WidgetJsonifyDeprecated.getUserInput.call(r)}
this.change=function(){for(var e=arguments.length,t=Array(e),n=0;n<e;n++){t[n]=arguments[n]}return Changeable.change.apply(r,t)}
this.simpleValidate=function(e){return PassageRefTarget.validate(r.getUserInput(),e)}}
_.extend(PassageRefTarget,{validate:function e(r,t){return{type:"points",earned:0,total:0,message:null}}})
module.exports={name:"passage-ref-target",displayName:"PassageRefTarget",defaultAlignment:"inline",widget:PassageRefTarget,hidden:true,transform:function e(r){return _.pick(r,"content")},version:{major:0,minor:0},isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/plotter.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var $=require("jquery")
var ApiClassNames=require("../../perseus-all-package/perseus-api.jsx").ClassNames
var deepEq=require("../../perseus-all-package/util.js").deepEq
var KhanMath=require("../../perseus-all-package/util/math.js")
var KhanColors=require("../../perseus-all-package/util/colors.js")
var GraphUtils=require("../../perseus-all-package/util/graph-utils.js")
var Interactive2=require("../../perseus-all-package/interactive2.js")
var WrappedLine=require("../../perseus-all-package/interactive2/wrapped-line.js")
var BAR="bar",LINE="line",PIC="pic",HISTOGRAM="histogram",DOTPLOT="dotplot"
var widgetPropTypes={type:PropTypes.oneOf([BAR,LINE,PIC,HISTOGRAM,DOTPLOT]),labels:PropTypes.arrayOf(PropTypes.string),categories:PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.number,PropTypes.string])),scaleY:PropTypes.number,maxY:PropTypes.number,snapsPerLine:PropTypes.number,picSize:PropTypes.number,pixBoxHeight:PropTypes.number,picUrl:PropTypes.string,plotDimensions:PropTypes.arrayOf(PropTypes.number),labelInterval:PropTypes.number,starting:PropTypes.arrayOf(PropTypes.number),static:PropTypes.bool}
var Plotter=function(e){babelHelpers.inherits(a,e)
function a(){var r,t,i
babelHelpers.classCallCheck(this,a)
for(var s=arguments.length,o=Array(s),n=0;n<s;n++){o[n]=arguments[n]}return i=(r=(t=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),t),_initialiseProps.call(t),r),babelHelpers.possibleConstructorReturn(t,i)}a.prototype.render=function e(){var a=75
var r={marginBottom:this.props.labels[0]?a:0}
return React.createElement("div",{className:"perseus-widget-plotter graphie "+ApiClassNames.INTERACTIVE,ref:"graphieDiv",style:r})}
a.prototype.componentDidUpdate=function e(a,r){if(this.shouldSetupGraphie){this.setupGraphie(r)}}
a.prototype.componentDidMount=function e(){this.setupGraphie(this.state)}
a.prototype.UNSAFE_componentWillReceiveProps=function e(a){var r=["type","labels","categories","scaleY","maxY","snapsPerLine","picUrl","labelInterval","static"]
this.shouldSetupGraphie=_.any(r,function(e){return!_.isEqual(this.props[e],a[e])},this)
if(!_.isEqual(this.props.starting,a.starting)&&!_.isEqual(this.state.values,a.starting)){this.shouldSetupGraphie=true
this.setState({values:a.starting})}}
return a}(React.Component)
Plotter.propTypes={onChange:PropTypes.func.isRequired,trackInteraction:PropTypes.func.isRequired}
Plotter.defaultProps={type:BAR,labels:["",""],categories:[""],scaleY:1,maxY:10,snapsPerLine:2,picSize:40,picBoxHeight:48,picUrl:"",plotDimensions:[380,300],labelInterval:1}
var _initialiseProps=function e(){var a=this
this.state={values:this.props.starting||[1]}
this.DOT_PLOT_POINT_SIZE=function(){return a.props.apiOptions.isMobile?6:4}
this.DOT_PLOT_POINT_PADDING=function(){return 8}
this.DOT_TICK_POINT_SIZE=function(){return 2}
this.setupGraphie=function(e){var r=a
r.shouldSetupGraphie=false
var t=ReactDOM.findDOMNode(r.refs.graphieDiv)
$(t).empty()
var i=GraphUtils.createGraphie(t)
r.graphie=i
r.graphie.pics=[]
r.graphie.dotTicks=[]
var s=r.props.type===BAR,o=r.props.type===LINE,n=r.props.type===PIC,p=r.props.type===HISTOGRAM,l=r.props.type===DOTPLOT
var c=n||l
var h={}
var u=h
var d=a.props.apiOptions.isMobile
u.graph={lines:[],bars:[],points:[],dividers:[]}
u.scaleY=r.props.scaleY
u.dimX=r.props.categories.length
var v=d?[288,336]:r.props.plotDimensions
if(o){u.dimX+=d?-.2:1}else if(p){u.barPad=0
u.barWidth=1}else if(s){u.barPad=d?.08:.15
u.barWidth=1-2*u.barPad
u.dimX+=(d?-2:2)*u.barPad}else if(c){u.picBoxHeight=r.props.picBoxHeight
u.picBoxWidthPx=v[0]/r.props.categories.length
var f=v[0]-u.dimX*u.picBoxWidthPx
u.picPad=f/(2*u.dimX+2)
var g=u.picBoxWidthPx+2*u.picPad
u.picPad=u.picPad/g
u.picBoxWidth=u.picBoxWidthPx/g
u.dimX+=2*u.picPad}if(l){u.picBoxHeight=a.DOT_PLOT_POINT_SIZE()*2+a.DOT_PLOT_POINT_PADDING()}u.dimY=Math.ceil(r.props.maxY/u.scaleY)*u.scaleY
var m=25
var P=25
if((s||o)&&d){m=r.props.labels[1].length!==0?17:11}if(l){m/=2}if(d&&c&&r.props.labels[1].length===0){m=0}if(d){u.scale=_.map([[u.dimX,m],[u.dimY,P]],function(e,a){var r=e[0],t=e[1]
return(v[a]-t*4)/r})}else{u.scale=_.map([u.dimX,u.dimY],function(e,a){return v[a]/e})}m/=u.scale[0]
P/=u.scale[1]
if(c){u.scale[1]=u.picBoxHeight/u.scaleY}i.init({range:[[-3*m,u.dimX+m],[-3*P,u.dimY+P]],scale:u.scale,isMobile:a.props.apiOptions.isMobile})
i.addMouseLayer({allowScratchpad:true,setDrawingAreaAvailable:a.props.apiOptions.setDrawingAreaAvailable})
if(!c){var y=d?u.scaleY:0
for(var T=y;T<=u.dimY;T+=u.scaleY){i.label([0,T],KhanMath.roundToApprox(T,2),"left",true)
i.style({stroke:d?"#e9ebec":"#000",strokeWidth:1,opacity:d?1:.3},function(){i.line([0,T],[u.dimX,T])})}}if((s||o)&&d){r.graphie.dragPrompt=i.label([u.dimX/2,u.dimY/2],"Drag handles to make graph","center",false).css("font-weight","bold").css("color",KhanColors.KA_GREEN).css("display","none")}r.setupCategories(h)
if(c&&d){r.graphie.dotPrompt=i.label([u.dimX/2,u.dimY/2],"Tap to add points","center",false).css("font-weight","bold").css("color",KhanColors.KA_GREEN).css("display","none")}if(c){r.drawPicHeights(r.state.values,e.values)}i.style({stroke:"#000",strokeWidth:2,opacity:1},function(){if(c){if(l){i.style({stroke:d?KhanColors.GRAY_G:"#000",strokeWidth:d?1:2},function(){return i.line([d?0:.5,0],[u.dimX-(d?0:.5),0])})}else{i.line([0,0],[u.dimX,0])
if(r.props.labels[1].length!==0||!d){i.style({stroke:d?KhanColors.GRAY_G:"#000",strokeWidth:d?1:2},function(){return i.line([0,0],[0,u.dimY])})}}}else{i.style({stroke:d?KhanColors.GRAY_G:"#000",strokeWidth:d?1:2},function(){return i.line([d?-m*3:0,0],[u.dimX+(d?m:0),0])})
if(!((s||o)&&d)){i.style({stroke:d?KhanColors.GRAY_G:"#000",strokeWidth:d?1:2},function(){return i.line([0,0],[0,u.dimY])})}}})
i.label([u.dimX/2,d?-P*3:-35/u.scale[1]],r.props.labels[0],d?"above":"below",false).css("font-weight","bold").css("color",d&&KhanColors.GRAY_F)
i.label([(d?-35:-60)/u.scale[0],u.dimY/2],r.props.labels[1],"center",false).css("font-weight","bold").css("color",d&&KhanColors.GRAY_F).addClass("rotate")
if(a.props.apiOptions.isMobile){a.horizHairline=new WrappedLine(a.graphie,[0,0],[0,0],{normalStyle:{strokeWidth:1}})
a.horizHairline.attr({stroke:KhanColors.INTERACTIVE})
a.horizHairline.hide()
a.hairlineRange=[[0,u.dimX],[0,u.dimY]]}}
this.showHairlines=function(e){if(a.props.apiOptions.isMobile&&a.props.markings!=="none"){a.horizHairline.moveTo([a.hairlineRange[0][0],e[1]],[a.hairlineRange[0][1],e[1]])
a.horizHairline.show()}}
this.hideHairlines=function(){if(a.props.apiOptions.isMobile){a.horizHairline.hide()}}
this.labelCategory=function(e,r){var t=a.props.apiOptions.isMobile
var i=a.graphie
r=r+""
var s=false
var o=r.match(/^\$(.*)\$$/)
if(o){r=o[1]
s=true}var n=a.props.labels[0].length!==0
var p="translateX(-50%) translateX(5px) "+"translateY(-50%) rotate(-45deg)"
i.style({color:t?KhanColors.GRAY_G:"inherit",transform:t&&!o?p:"none",transformOrigin:"100%"},function(){return i.label([e,t?-.5:0],r,"below",s)})}
this.setupCategories=function(e){var r=a
var t=e
var i=r.graphie
var s=a.props.apiOptions.isMobile
if(r.props.type===HISTOGRAM){_.times(r.props.categories.length-1,function(a){r.setupBar({index:a,startHeight:r.state.values[a],config:e,isHistogram:true})})
_.each(r.props.categories,function(e,a){var o=.5+a*t.barWidth
r.labelCategory(o,e)
var n=6/t.scale[1]
i.style({stroke:"#000",strokeWidth:s?1:2,opacity:1},function(){i.line([o,-n],[o,0])})})}else{_.each(r.props.categories,function(a,o){var n=r.state.values[o]
var p
if(r.props.type===BAR){p=r.setupBar({index:o,startHeight:n,config:e,isHistogram:false})}else if(r.props.type===LINE){p=r.setupLine(o,n,e)}else if(r.props.type===PIC){p=r.setupPic(o,e)}else if(r.props.type===DOTPLOT){p=r.setupDotplot(o,e)}var l=0
var c=-6/t.scale[1]
if(r.props.type===DOTPLOT&&!s){l=-c}if(r.props.type===DOTPLOT){if(o%r.props.labelInterval===0||o===r.props.categories.length-1){r.labelCategory(p,a)
l*=1.5
c*=1.5}}else{r.labelCategory(p,a)}i.style({stroke:s?KhanColors.GRAY_G:"#000",strokeWidth:s?1:2,opacity:1},function(){i.line([p,l],[p,c])})})}}
this._clampValue=function(e,a,r){return Math.max(Math.min(e,r),a)}
this._maybeShowDragPrompt=function(){if(a.graphie.dragPrompt!=null){a.graphie.dragPrompt[0].style.display="inline"}}
this._maybeHideDragPrompt=function(){if(a.graphie.dragPrompt!=null){a.graphie.dragPrompt[0].style.display="none"}}
this.setupBar=function(e){var r=a.props.apiOptions.isMobile
var t=e.index
var i=e.startHeight
var s=e.config
var o=e.isHistogram
var n=a
var p=n.graphie
var l=s.barWidth/2
var c
if(o){c=.5+t*s.barWidth+l}else{c=(r?l:.5+s.barPad)+t}var h=function e(a,t){var i=p.scalePoint(0)
s.graph.bars[a].scale(1,Math.max(r?.2:.01,t/s.scaleY),i[0],i[1])
if(o){var l=s.graph.dividers[a-1],c=s.graph.dividers[a]
if(l){var h=Math.min(n.state.values[a-1],t)
l.scale(1,Math.max(.01,h/s.scaleY),i[0],i[1])}if(c){var h=Math.min(n.state.values[a+1],t)
c.scale(1,Math.max(.01,h/s.scaleY),i[0],i[1])}}}
p.style({stroke:"none",fill:r?KhanColors.BLUE_C:KhanColors.LIGHT_BLUE,opacity:1},function(){s.graph.bars[t]=p.path([[c-l,0],[c-l,s.scaleY],[c+l,s.scaleY],[c+l,0],[c-l,0]])})
if(o){if(t>0){p.style({stroke:"#000",strokeWidth:1,opacity:.3},function(){s.graph.dividers.push(p.path([[c-l,0],[c-l,s.scaleY]]))})}}if(r){var u=s.scaleY/n.props.snapsPerLine
s.graph.lines[t]=Interactive2.addMaybeMobileMovablePoint(a,{coord:[c,i],constraints:[function(e,r,t){return[c,a._clampValue(Math.round(e[1]/u)*u,0,s.dimY)]}],onMoveStart:function e(){s.graph.bars[t].attr({fill:KhanColors.INTERACTIVE})},onMove:function e(){var a=s.graph.lines[t].coord()[1]
var r=_.clone(n.state.values)
r[t]=a
n.setState({values:r})
n.changeAndTrack({values:r})
n._maybeHideDragPrompt()
h(t,a)},onMoveEnd:function e(){s.graph.bars[t].attr({fill:KhanColors.BLUE_C})}})
s.graph.lines[t].state.visibleShape.wrapper.style.zIndex="1"
n._maybeShowDragPrompt()}else{s.graph.lines[t]=p.addMovableLineSegment({coordA:[c-l,i],coordZ:[c+l,i],snapY:s.scaleY/n.props.snapsPerLine,constraints:{constrainX:true},normalStyle:{stroke:KhanColors.INTERACTIVE,"stroke-width":a.props.static?0:4}})
s.graph.lines[t].onMove=function(e,a){var r=this.coordA[1]
if(r<0||r>s.dimY){r=Math.min(Math.max(r,0),s.dimY)
this.coordA[1]=this.coordZ[1]=r
this.transform()}var i=_.clone(n.state.values)
i[t]=r
n.setState({values:i})
n.changeAndTrack({values:i})
h(t,r)}}h(t,i)
return c}
this.setupLine=function(e,r,t){var i=a.props.apiOptions.isMobile
var s=a
var o=t
var n=s.graphie
var p=e+(i?.4:1)
if(i){var l=t.scaleY/s.props.snapsPerLine
o.graph.points[e]=Interactive2.addMaybeMobileMovablePoint(a,{coord:[p,r],constraints:[function(e,r,i){return[p,a._clampValue(Math.round(e[1]/l)*l,0,t.dimY)]}],onMove:function a(){var r=o.graph.points[e].coord()[1]
var t=_.clone(s.state.values)
t[e]=r
s.setState({values:t})
s.changeAndTrack({values:t})
s._maybeHideDragPrompt()}})
s._maybeShowDragPrompt()
if(e>0){o.graph.lines[e]=Interactive2.addMovableLine(n,{points:[o.graph.points[e-1],o.graph.points[e]],constraints:Interactive2.MovablePoint.constraints.fixed(),normalStyle:{stroke:KhanColors.BLUE_C,"stroke-width":2},highlightStyle:{stroke:KhanColors.BLUE_C,"stroke-width":2}})}}else{o.graph.points[e]=n.addMovablePoint({coord:[p,r],constraints:{constrainX:true},normalStyle:{fill:KhanColors.INTERACTIVE,stroke:KhanColors.INTERACTIVE},snapY:o.scaleY/s.props.snapsPerLine})
o.graph.points[e].onMove=function(a,r){r=Math.min(Math.max(r,0),o.dimY)
var t=_.clone(s.state.values)
t[e]=r
s.setState({values:t})
s.changeAndTrack({values:t})
return[a,r]}
if(e>0){o.graph.lines[e]=n.addMovableLineSegment({pointA:o.graph.points[e-1],pointZ:o.graph.points[e],constraints:{fixed:true},normalStyle:{stroke:"#9ab8ed","stroke-width":2}})}}return p}
this.setupDotplot=function(e,r){var t=a.graphie
var i=a.props.apiOptions.isMobile
return a.setupTiledPlot(e,i?.5:1,r,function(e,r){return t.ellipse([e,r],[a.DOT_PLOT_POINT_SIZE()/t.scale[0],a.DOT_PLOT_POINT_SIZE()/t.scale[1]],{fill:KhanColors.INTERACTIVE,stroke:KhanColors.INTERACTIVE})})}
this.setupPic=function(e,r){var t=a.graphie
return a.setupTiledPlot(e,0,r,function(e,r){var i=t.scalePoint([e,r])
var s=a.props.picSize
return t.raphael.image(a.props.picUrl,i[0]-s/2,i[1]-s/2,s,s)})}
this.setupTiledPlot=function(e,r,t,i){var s=a
var o=t
var n=s.graphie
var p=n.pics
var l=n.dotTicks
var c=e+.5+o.picPad
n.mouselayer.canvas.style.touchAction="none"
p[e]=[]
l[e]=[]
var h=Math.round(o.dimY/o.scaleY)+1
_(h).times(function(a){a-=1
var t=(a+.5)*o.scaleY
var h=c-o.picBoxWidth/2
var u=t+.5*o.scaleY
var d=n.scalePoint([h,u+r])
var v=n.mouselayer.rect(d[0],d[1],o.picBoxWidthPx,o.picBoxHeight)
$(v[0]).css({fill:"#000",opacity:0,cursor:"pointer"}).on("vmousedown",function(a){a.preventDefault()
s.whichPicClicked=e
s.setPicHeight(e,u)
$(document).on("vmouseup.plotTile",function(e){$(document).unbind(".plotTile")})
$(document).on("vmousemove.plotTile",function(e){e.preventDefault()
var a=n.getMouseCoord(e)[1]
var t=Math.floor(a-r)
var i=Math.max(-1,Math.floor(t/o.scaleY))
var p=(i+.5)*o.scaleY
var l=p+.5*o.scaleY
s.setPicHeight(s.whichPicClicked,l)})})
if(a<0){return}p[e][a]=i(c,t+r)
l[e][a]=n.ellipse([c,t+r],[s.DOT_TICK_POINT_SIZE()/n.scale[0],s.DOT_TICK_POINT_SIZE()/n.scale[1]],{fill:"#dee1e3",stroke:"#dee1e3"})})
return c}
this.setPicHeight=function(e,r){var t=_.clone(a.state.values)
t[e]=r
a.drawPicHeights(t,a.state.values)
a.setState({values:t})
a.changeAndTrack({values:t})}
this.changeAndTrack=function(e){a.props.onChange(e)
a.props.trackInteraction()}
this.drawPicHeights=function(e,r){var t=a
var i=t.graphie
var s=i.pics
var o=a.props.apiOptions.isMobile
if(o){var n=e.every(function(e){return e===0})
i.dotPrompt[0].style.display=n?"inline":"none"}_.each(s,function(a,s){_.each(a,function(a,n){var p=(n+1)*t.props.scaleY
var l=p<=e[s]
if(t.props.type===DOTPLOT){var c=p<=r[s]
var h=l&&!c
if(h){a.animate({"stroke-width":8},75,function(){return a.animate({"stroke-width":2},75)})}}$(a[0]).css({display:l?"inline":"none"})
i.dotTicks[s][n][0].style.display=l||!o?"none":"inline"})})}
this.getUserInput=function(){return a.state.values}
this.simpleValidate=function(e){return Plotter.validate(a.getUserInput(),e)}}
_.extend(Plotter,{validate:function e(a,r){if(deepEq(a,r.starting)){return{type:"invalid",message:null}}else{return{type:"points",earned:deepEq(a,r.correct)?1:0,total:1,message:null}}}})
var staticTransform=_.identity
module.exports={name:"plotter",displayName:"Plotter",widget:Plotter,staticTransform:staticTransform}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/reaction-diagram.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var i18n=require("../../shared-package/i18n.js")
var Molecule=require("./molecule.jsx").molecule
var Separator=function(e){babelHelpers.inherits(t,e)
function t(){var r,a,o
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,i=Array(n),s=0;s<n;s++){i[s]=arguments[s]}return o=(r=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),a),a.arrowLength=100,a.drawArrow=function(){var e=a.refs["arrowCanvas"+a.props.index]
var t=e.getContext("2d")
t.clearRect(0,0,e.width,e.height)
var r=new Path2D
t.strokeStyle="rgb(0,0,0)"
t.lineWidth=1.2
t.lineCap="round"
var o=5
r.moveTo(o,e.height/2)
r.lineTo(e.width-o,e.height/2)
r.moveTo(e.width-2*o,e.height/2-o)
r.lineTo(e.width-o,e.height/2)
r.moveTo(e.width-2*o,e.height/2+o)
r.lineTo(e.width-o,e.height/2)
t.stroke(r)},r),babelHelpers.possibleConstructorReturn(a,o)}t.prototype.componentDidMount=function e(){this.drawArrow()}
t.prototype.componentDidUpdate=function e(){this.drawArrow()}
t.prototype.render=function e(){return React.createElement("div",{className:"arrow-container"},React.createElement("div",{className:"above-text"},this.props.data.topText),React.createElement("canvas",{height:"30",id:"arrowCanvas"+this.props.index,ref:"arrowCanvas"+this.props.index,width:this.arrowLength},i18n._("Reaction arrow pointing to the right.")),React.createElement("div",{className:"below-text"},this.props.data.bottomText))}
return t}(React.Component)
Separator.propTypes={data:PropTypes.any,index:PropTypes.number}
var ReactionDiagramWidget=function(e){babelHelpers.inherits(t,e)
function t(){var r,a,o
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,i=Array(n),s=0;s<n;s++){i[s]=arguments[s]}return o=(r=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),a),a.simpleValidate=function(){return{type:"points",earned:0,total:0,message:null}},a.getUserInput=function(){return[]},a.validate=function(e,t){return{type:"points",earned:0,total:0,message:null}},a.focus=function(){return true},r),babelHelpers.possibleConstructorReturn(a,o)}t.prototype.render=function e(){var t=this
return React.createElement("div",{className:"reaction",ref:"reaction"},this.props.smiles.map(function(e,r){var a=t.props.widgetId+"-"+r
return React.createElement("div",{key:a,className:"molecule-container"},React.createElement(Molecule,{id:a,rotationAngle:t.props.rotationAngle[r],smiles:e}),r===t.props.smiles.length-1?null:React.createElement(Separator,{data:t.props.separators[r],index:r}))}))}
return t}(React.Component)
ReactionDiagramWidget.propTypes={rotationAngle:PropTypes.arrayOf(PropTypes.number),separators:PropTypes.arrayOf(PropTypes.object),smiles:PropTypes.arrayOf(PropTypes.string),widgetId:PropTypes.string}
ReactionDiagramWidget.defaultProps={smiles:[],rotationAngle:[],separators:[]}
module.exports={name:"reaction-diagram",displayName:"Chemical reaction",hidden:true,widget:ReactionDiagramWidget}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/sequence.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var _require=require("../../perseus-all-package/icon-paths.js"),iconOk=_require.iconOk
var InlineIcon=require("../../perseus-all-package/components/inline-icon.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var Util=require("../../perseus-all-package/util.js")
var _require2=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require2.linterContextProps,linterContextDefault=_require2.linterContextDefault
var Sequence=function(e){babelHelpers.inherits(r,e)
function r(){var t,n,s
babelHelpers.classCallCheck(this,r)
for(var i=arguments.length,a=Array(i),o=0;o<i;o++){a[o]=arguments[o]}return s=(t=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),n),_initialiseProps.call(n),t),babelHelpers.possibleConstructorReturn(n,s)}r.prototype.shouldComponentUpdate=function e(r,t){return r!==this.props||t!==this.state}
r.prototype.render=function e(){var r=this
var t=React.createElement(InlineIcon,babelHelpers.extends({},iconOk,{style:{color:"green"}}))
var n=_.chain(this.props.json).first(this.state.visible).map(function(e,r){return"[["+Util.snowman+" group "+r+"]]"}).join("\n\n").value()
var s={}
_.each(this.props.json,function(e,n){var i="group "+n
s[i]={type:"group",graded:true,version:{major:0,minor:0},options:_.extend({},e,{icon:n<r.state.visible-1?t:null})}})
return React.createElement("div",{className:"perseus-sequence"},React.createElement(Renderer,{ref:"renderer",content:n,widgets:s,onInteractWithWidget:this._handleInteraction,apiOptions:this.props.apiOptions,linterContext:this.props.linterContext}))}
return r}(React.Component)
Sequence.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:ApiOptions.propTypes,json:PropTypes.arrayOf(PropTypes.shape({content:PropTypes.string,images:PropTypes.object,widgets:PropTypes.object})),trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps})
Sequence.defaultProps={json:[{content:"",widgets:{},images:{}}],linterContext:linterContextDefault}
var _initialiseProps=function e(){var r=this
this.state={visible:1}
this.change=function(){for(var e=arguments.length,t=Array(e),n=0;n<e;n++){t[n]=arguments[n]}return Changeable.change.apply(r,t)}
this._handleInteraction=function(e){var t=parseInt(e.split(" ")[1])
if(t===r.state.visible-1){var n=r.refs.renderer.getWidgetInstance("group "+t)
n.showRationalesForCurrentlySelectedChoices()
var s=n.simpleValidate()
if(s.type==="points"&&s.total===s.earned){r.setState({visible:r.state.visible+1})
r.props.trackInteraction({visible:r.state.visible+1})}}}}
var traverseChildWidgets=function e(r,t){var n=r.json
if(!_.isArray(n)){n=[n]}var s=_.map(n,function(e){return t(e)})
return _.extend({},r,{json:s})}
module.exports={name:"sequence",displayName:"Graded Sequence",widget:Sequence,traverseChildWidgets:traverseChildWidgets,tracking:"all",hidden:true,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/simulator.jsx", function(require, module, exports) {
var InfoTip=require("../../perseus-all-package/components/info-tip.jsx")
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var assert=require("../../perseus-all-package/interactive2/interactive-util.js").assert
var Graphie=require("../../perseus-all-package/components/graphie.jsx")
var Path=Graphie.Path,Arc=Graphie.Arc,Circle=Graphie.Circle,Label=Graphie.Label,Line=Graphie.Line,MovablePoint=Graphie.MovablePoint,MovableLine=Graphie.MovableLine
var NumberInput=require("../../perseus-all-package/components/number-input.jsx")
var MathOutput=require("../../perseus-all-package/components/math-output.jsx")
var seededRNG=require("../../perseus-all-package/util.js").seededRNG
var Util=require("../../perseus-all-package/util.js")
var knumber=require("kmath").number
var KhanColors=require("../../perseus-all-package/util/colors.js")
var KhanMath=require("../../perseus-all-package/util/math.js")
var i18n=require("../../shared-package/i18n.js")
var defaultBoxSize=400
var maxSampleSize=1e3
var maxTrials=5e3
var Histogram=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,n
babelHelpers.classCallCheck(this,r)
for(var o=arguments.length,i=Array(o),s=0;s<o;s++){i[s]=arguments[s]}return n=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),a),a._renderThresholdLine=function(){var e=[0,a._range()[1][1]]
var r=_.map(e,function(e){return[a.state.threshold,e]})
var t=function e(r,t){return React.createElement(MovablePoint,{key:t,static:true,coord:r,normalStyle:{stroke:"none",fill:"none"}})}
return React.createElement(MovableLine,{onMove:a.handleMouseInteraction},_.map(r,t))},a._renderCircle=function(){var e=a.props.data
var r=_.reduce(e,function(e,r){return e+r},0)
var t=_.reduce(e,function(e,r,t){if(a.state.threshold!=null&&t<=a.state.threshold){return e+r}else{return e}},0)
var n=t/r
var o=1e-5
var i=20
var s=[a.props.box[0]-1.5*i,1.5*i]
var l=function e(){var r={key:"below",center:s,radius:i,startAngle:0,endAngle:n<1?360*n:360-o,sector:n!==1,unscaled:true,style:{fill:KhanColors.LIGHT_RED,stroke:KhanColors.RED}}
return React.createElement(Arc,r)}
var p=function e(){var r={key:"above",center:s,radius:i,startAngle:n>0?360*n:o,endAngle:360,sector:n!==0,unscaled:true,style:{fill:KhanColors.LIGHT_BLUE,stroke:KhanColors.BLUE}}
return React.createElement(Arc,r)}
var u=a._range()[0]
var c=Math.min(Math.max(a.state.threshold,u[0]),u[1]).toFixed(2)
var h=function e(){var a={key:"label",coord:[s[0],s[1]+1.5*i],text:t+" of "+r+" results below "+c+"%",direction:"center",tex:false,unscaled:true,style:{fontSize:"12px"}}
return React.createElement(Label,a)}
return[n>0&&l(),n<1&&p(),h()]},a._renderData=function(){var e=a.props.data
var r=a._range()
var t=1
var n=function e(r,n){if(!r){return}var o=a.state.threshold!=null&&n<=a.state.threshold
var i={fill:o?KhanColors.LIGHT_RED:KhanColors.LIGHT_BLUE,stroke:o?KhanColors.RED:KhanColors.BLUE}
var s=[[n,0],[n,r],[n+t,r],[n+t,0]]
return React.createElement(Path,{key:n,coords:s,style:i})}
return _.map(e,n)},a._setupGraphie=function(e,r){var t=r.data
var a=r.range
var n=r.scale
var o=a[0][1]-a[0][0]
var i=a[1][1]-0
var s=20
var l=Math.ceil(i/s)
_.each(_.range(0,a[1][1],l),function(r){if(t){e.label([a[0][0],r],KhanMath.roundToApprox(r,2),"left",true)}e.line([a[0][0],r],[a[0][1],r],{stroke:"#000",strokeWidth:1,opacity:.3})})
if(t){var p=15
var u=Math.ceil(o/p)
_.each(_.range(a[0][0],a[0][1],u),function(r){e.label([r,0],knumber.round(r,2),"below",true)
var t=8
e.line([r,0],[r,-t/n[1]],{stroke:"#000",strokeWidth:1})})}var c={stroke:"#000",strokeWidth:2,opacity:1}
var h=[a[0][0],0]
var d=[a[0][0],a[1][1]]
e.line(h,d,c)
var m=a[0][0]+o/2
var v=t?25:0
e.label([m,-v/n[1]],r.xAxisLabel,"below",false).css("font-weight","bold")
var f=0+i/2
var b=t?55:28
e.label([a[0][0]-b/n[0],f],r.yAxisLabel,"center",false).css("font-weight","bold").css("-webkit-transform","rotate(-90deg)")},a.handleMouseInteraction=function(e){a.setState({threshold:e[0]})},a._range=function(e){var r=[[0,100],[-1,10]]
e=e||a.props
return e.data?a._getRangeForData(e.data):r},a._getRangeForData=function(e){var r=10
var t=_.indexOf(e,_.find(e,function(e){return e>0}))
var a=Math.max(0,t-r)
var n=_.lastIndexOf(e,_.last(_.filter(e,function(e){return e>0})))
var o=Math.min(100+1,n+1+r)
var i=-1
var s=_.max(e)
return[[a,o],[i,s]]},a._getInitialThreshold=function(e){var r=e[0]
return r[0]+(r[1]-r[0])/3},a.state={threshold:a._getInitialThreshold(a._range())},t),babelHelpers.possibleConstructorReturn(a,n)}r.prototype.UNSAFE_componentWillReceiveProps=function e(r){var t=this._range()
var a=this._range(r)
if(!Util.deepEq(t,a)){this.setState({threshold:this._getInitialThreshold(a)})}}
r.prototype.render=function e(){var r=this.props.data
var t=this._range()
var a={xAxisLabel:this.props.xAxisLabel,yAxisLabel:this.props.yAxisLabel,box:this.props.box,range:t,data:r,scale:[Util.scaleFromExtent(t[0],this.props.box[0]),Util.scaleFromExtent(t[1],this.props.box[1])]}
var n={stroke:"#000",strokeWidth:1,opacity:1}
var o=[t[0][0],0]
var i=[t[0][1],0]
return React.createElement(Graphie,{box:a.box,range:a.range,options:a,setup:this._setupGraphie,onMouseMove:this.handleMouseInteraction,onMouseDown:this.handleMouseInteraction,setDrawingAreaAvailable:this.props.setDrawingAreaAvailable},React.createElement(Line,{start:o,end:i,style:n}),r&&this._renderData(),r&&this._renderCircle(),r&&this._renderThresholdLine())}
return r}(React.Component)
Histogram.propTypes={data:PropTypes.arrayOf(PropTypes.number),xAxisLabel:PropTypes.string,yAxisLabel:PropTypes.string,box:PropTypes.arrayOf(PropTypes.number)}
Histogram.defaultProps={data:null,xAxisLabel:"Proportion (%)",yAxisLabel:"Number of times seen",box:[defaultBoxSize,defaultBoxSize]}
var Simulator=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,n
babelHelpers.classCallCheck(this,r)
for(var o=arguments.length,i=Array(o),s=0;s<o;s++){i[s]=arguments[s]}return n=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),a),_initialiseProps.call(a),t),babelHelpers.possibleConstructorReturn(a,n)}r.prototype.UNSAFE_componentWillMount=function e(){if(this.props.randomSeed!=null){this.generateNumber=Util.seededRNG(this.props.randomSeed)}}
r.prototype.UNSAFE_componentWillReceiveProps=function e(r){if(r.randomSeed!==this.props.randomSeed){this.generateNumber=Util.seededRNG(r.randomSeed)}}
r.prototype.render=function e(){var r=this
var t={marginLeft:"5px"}
var a="0px 0px 0px 2px rgba(255, 165, 0, 1)"
var n=_.extend({},t,{WebkitBoxShadow:a,MozBoxShadow:a,boxShadow:a,transition:"all 0.15s"})
var o=_.extend({},t,{transition:"all 0.15s"})
var i=this.state.invalidInput?n:o
var s=this.props.apiOptions.staticRender?MathOutput:NumberInput
var l=React.createElement("div",null,React.createElement(s,{ref:"userProportion",style:i,value:this.calculateDisplayProportion(),checkValidity:this.checkProportionValidity,disabled:this.props.apiOptions.readOnly,onChange:this.handleUserProportionChange,onFocus:function e(){return r.props.onFocus(["userProportion"])},onBlur:function e(){return r.props.onBlur(["userProportion"])}}),React.createElement(InfoTip,null,React.createElement("p",null,i18n._("This controls the proportion or percentage that will be used in your simulation."))))
var p=React.createElement("div",null,React.createElement(s,{ref:"sampleSize",style:i,value:this.props.sampleSize,checkValidity:function e(r){return r>=0},disabled:this.props.apiOptions.readOnly,onChange:this.handleSampleSizeChange,onFocus:function e(){return r.props.onFocus(["sampleSize"])},onBlur:function e(){return r.props.onBlur(["sampleSize"])}}),React.createElement(InfoTip,null,React.createElement("p",null,i18n._("This controls the sample size that will be used in your simulation. For example, if you set this to 100, then for each trial, responses from 100 participants will be simulated."))))
var u=React.createElement("div",{style:{textAlign:"right"}},React.createElement("b",null,this.props.numTrials),React.createElement(InfoTip,null,React.createElement("p",null,i18n._("This is the number of trials used in the simulation. For example, if set to 50, then the survey will be conducted 50 times."))))
var c=function e(r){var t=React.createElement("thead",null,React.createElement("tr",null,React.createElement("th",null,i18n._("Parameter")),React.createElement("th",null,i18n._("Value"))))
var a=React.createElement("tbody",null,_.map(r,function(e,r){return React.createElement("tr",{key:r},React.createElement("td",null,e.title),React.createElement("td",null,e.value))}))
return React.createElement("table",null,t,a)}
var h=[{title:this.props.proportionLabel+":",value:l},{title:i18n._("Sample size:"),value:p},{title:i18n._("Number of trials:"),value:u}]
var d={margin:"20px 0"}
var m=React.createElement("button",{className:"simple-button",style:d,disabled:this.props.apiOptions.readOnly,onClick:this.handleRunSimulation},i18n._("Run simulation"))
var v={paddingBottom:this.props.data?40:0}
var f=React.createElement("div",{style:v},React.createElement(Histogram,{data:this.props.data,xAxisLabel:this.props.xAxisLabel,yAxisLabel:this.props.yAxisLabel,setDrawingAreaAvailable:this.props.apiOptions.setDrawingAreaAvailable}))
return React.createElement("div",null,c(h),m,f)}
return r}(React.Component)
Simulator.propTypes=babelHelpers.extends({},Changeable.propTypes,{apiOptions:ApiOptions.propTypes,data:PropTypes.arrayOf(PropTypes.number),numTrials:PropTypes.number,proportionLabel:PropTypes.string,proportionOrPercentage:PropTypes.string,randomSeed:PropTypes.number,sampleSize:PropTypes.number,trackInteraction:PropTypes.func.isRequired,userProportion:PropTypes.number,xAxisLabel:PropTypes.string,yAxisLabel:PropTypes.string})
Simulator.defaultProps={data:null,userProportion:null,sampleSize:null,numTrials:null,randomSeed:0,xAxisLabel:"Proportion (%)",yAxisLabel:"Number of times seen",proportionLabel:"Underlying proportion",proportionOrPercentage:"proportion",apiOptions:ApiOptions.defaults}
var _initialiseProps=function e(){var r=this
this.state={invalidInput:false}
this.calculateDisplayProportion=function(){var e=r.props.userProportion
if(r.props.proportionOrPercentage==="percentage"){return Math.round(100*e)}else{return e}}
this.change=function(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++){t[a]=arguments[a]}return Changeable.change.apply(r,t)}
this.checkProportionValidity=function(e){return e>=0&&r.props.proportionOrPercentage==="proportion"&&e<=1||r.props.proportionOrPercentage==="percentage"&&e<=100}
this.handleUserProportionChange=function(e,t){var a
if(r.props.proportionOrPercentage==="percentage"){a=e/100}else{a=e}if(a!=null){a=Math.min(1,Math.max(0,a))}r.props.onChange({userProportion:a},t)}
this.handleSampleSizeChange=function(e,t){if(e!=null){e=Math.min(maxSampleSize,Math.max(0,Math.floor(e)))}r.props.onChange({sampleSize:e},t)}
this.handleRunSimulation=function(){if(r.props.numTrials==null||r.props.userProportion==null||r.props.sampleSize==null){r.setState({invalidInput:true})
return}else{r.setState({invalidInput:false})}r.props.onChange({data:r.generateData()})
r.props.trackInteraction()}
this.generateData=function(e){e=e||r.props
var t=function e(t,a,n){var o=function e(){return r.generateNumber()<n}
var i=_.times(100+1,function(){return 0})
_.times(a,function(){var e=_.times(t,o)
var r=_.filter(e,_.identity).length
var a=Math.floor(100*r/t)
i[a]++})
return i}
return t(e.sampleSize,e.numTrials,e.userProportion)}
this.getInputPaths=function(){return[["userProportion"],["sampleSize"]]}
this.focus=function(){var e=_.head(r.getInputPaths())
r.focusInputPath(e)
return true}
this.focusInputPath=function(e){assert(e.length>0)
var t=_.head(e)
var a=r.refs[t]
a.focus()}
this.blurInputPath=function(e){assert(e.length>0)
var t=_.head(e)
var a=r.refs[t]
a.blur()}
this.getDOMNodeForPath=function(e){assert(e.length>0)
var t=_.head(e)
return ReactDOM.findDOMNode(r.refs[t])}
this.getGrammarTypeForPath=function(e){assert(e.length>0)
return"number"}
this.setInputValue=function(e,t,a){assert(e.length>0)
var n=_.head(e)
var o=n.charAt(0).toUpperCase()+n.slice(1)
var i="handle"+o+"Change"
r[i](t,a)}
this.getUserInput=function(){return null}
this.simpleValidate=function(e){return Simulator.validate(r.getUserInput(),e)}}
_.extend(Simulator,{validate:function e(r,t){return{type:"points",earned:0,total:0,message:null}}})
var propTransform=function e(r){var t=_.clone(r)
t.randomSeed=r.problemNum
return t}
module.exports={name:"simulator",displayName:"Simulator",widget:Simulator,transform:propTransform,hidden:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/sorter.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var Sortable=require("../../perseus-all-package/components/sortable.jsx")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var shuffle=require("../../perseus-all-package/util.js").shuffle
var _require=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require.linterContextProps,linterContextDefault=_require.linterContextDefault
var HORIZONTAL="horizontal"
var VERTICAL="vertical"
var Sorter=function(e){babelHelpers.inherits(r,e)
function r(){var t,o,n
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,a=Array(s),p=0;p<s;p++){a[p]=arguments[p]}return n=(t=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),o),o.state={changed:false},o.handleChange=function(e){if(!o._isMounted){return}o.setState({changed:true},function(){setTimeout(function(){o.props.onChange(e)
o.props.trackInteraction()},0)})},o.getUserInput=function(){return{options:o.refs.sortable.getOptions()}},o.simpleValidate=function(e){if(!o.state.changed){return{type:"invalid",message:null}}return r.validate(o.getUserInput(),e)},t),babelHelpers.possibleConstructorReturn(o,n)}r.prototype.componentDidMount=function e(){this._isMounted=true}
r.prototype.componentWillUnmount=function e(){this._isMounted=false}
r.prototype.render=function e(){var r=shuffle(this.props.correct,this.props.problemNum,true)
var t=this.props.apiOptions
var o=t.isMobile?8:5
return React.createElement("div",{className:"perseus-widget-sorter perseus-clearfix"},React.createElement(Sortable,{options:r,layout:this.props.layout,margin:o,padding:this.props.padding,onChange:this.handleChange,linterContext:this.props.linterContext,ref:"sortable"}))}
return r}(React.Component)
Sorter.propTypes={apiOptions:ApiOptions.propTypes,correct:PropTypes.array,layout:PropTypes.oneOf([HORIZONTAL,VERTICAL]),onChange:PropTypes.func,padding:PropTypes.bool,problemNum:PropTypes.number,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps}
Sorter.defaultProps={correct:[],layout:HORIZONTAL,padding:true,problemNum:0,onChange:function e(){},linterContext:linterContextDefault}
_.extend(Sorter,{validate:function e(r,t){var o=_.isEqual(r.options,t.correct)
return{type:"points",earned:o?1:0,total:1,message:null}}})
module.exports={name:"sorter",displayName:"Sorter",widget:Sorter,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/table.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var MathOutput=require("../../perseus-all-package/components/math-output.jsx")
var SimpleKeypadInput=require("../../perseus-all-package/components/simple-keypad-input.jsx")
var Renderer=require("../../perseus-all-package/renderer.jsx")
var Util=require("../../perseus-all-package/util.js")
var keypadElementPropType=require("math-input").propTypes.keypadElementPropType
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var KhanAnswerTypes=require("../../perseus-all-package/util/answer-types.js")
var _require=require("../../perseus-all-package/gorgon/proptypes.js"),linterContextProps=_require.linterContextProps,linterContextDefault=_require.linterContextDefault
var assert=require("../../perseus-all-package/interactive2/interactive-util.js").assert
var getInputPath=function e(r,t){return[""+r,""+t]}
var getDefaultPath=function e(){return getInputPath(0,0)}
var getRowFromPath=function e(r){assert(_.isArray(r)&&r.length===2)
return+r[0]}
var getColumnFromPath=function e(r){assert(_.isArray(r)&&r.length===2)
return+r[1]}
var getRefForPath=function e(r){var t=getRowFromPath(r)
var a=getColumnFromPath(r)
return"answer"+t+","+a}
var Table=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,n
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,o=Array(s),p=0;p<s;p++){o[p]=arguments[p]}return n=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),a),a._getRows=function(){return a.props.answers.length},a._getColumns=function(){return a.props.answers[0].length},a.getUserInput=function(){return _.map(a.props.answers,_.clone)},a.onValueChange=function(e,r,t){var n=_.map(a.props.answers,_.clone)
n[e][r]=t.target?t.target.value:t
a.props.onChange({answers:n})
a.props.trackInteraction()},a.onHeaderChange=function(e,r){var t=a.props.headers.slice()
t[e]=r.content
a.props.onChange({headers:t})},a.simpleValidate=function(e){return r.validate(a.getUserInput(),e)},a._handleFocus=function(e){a.props.onFocus(e)},a._handleBlur=function(e){a.props.onBlur(e)},a.focus=function(){a.focusInputPath(getDefaultPath())
return true},a.focusInputPath=function(e){var r=getRefForPath(e)
var t=a.refs[r]
if(a.props.apiOptions.customKeypad){t.focus()}else if(a.props.apiOptions.staticRender){t.focus()}else{ReactDOM.findDOMNode(t).focus()}},a.blurInputPath=function(e){var r=getRefForPath(e)
var t=a.refs[r]
if(a.props.apiOptions.customKeypad){t.blur()}else if(a.props.apiOptions.staticRender){t.blur()}else{ReactDOM.findDOMNode(t).blur()}},a.getDOMNodeForPath=function(e){var r=getRefForPath(e)
return ReactDOM.findDOMNode(a.refs[r])},a.getInputPaths=function(){var e=a._getRows()
var r=a._getColumns()
var t=[]
_(e).times(function(e){_(r).times(function(r){var a=getInputPath(e,r)
t.push(a)})})
return t},a.getGrammarTypeForPath=function(e){return"number"},a.setInputValue=function(e,r,t){var n=getRowFromPath(e)
var s=getColumnFromPath(e)
var o=_.map(a.props.answers,_.clone)
o[n][s]=r
a.props.onChange({answers:o},t)},t),babelHelpers.possibleConstructorReturn(a,n)}r.prototype.render=function e(){var r=this
var t=this._getRows()
var a=this._getColumns()
var n=this.props.headers
var s=void 0
var o=void 0
var p={}
if(this.props.apiOptions.customKeypad){s=SimpleKeypadInput
o={width:80}
p.keypadElement=this.props.keypadElement}else if(this.props.apiOptions.staticRender){s=MathOutput
o={}}else{s="input"
o={}}return React.createElement("table",{className:"perseus-widget-table-of-values non-markdown"},React.createElement("thead",null,React.createElement("tr",null,_.map(n,function(e,t){if(r.props.editableHeaders){return React.createElement("th",{key:t},React.createElement(r.props.Editor,{ref:"columnHeader"+t,apiOptions:r.props.apiOptions,content:e,widgetEnabled:false,onChange:_.partial(r.onHeaderChange,t)}))}else{return React.createElement("th",{key:t},React.createElement(Renderer,{content:e,linterContext:r.props.linterContext}))}}))),React.createElement("tbody",null,_(t).times(function(e){return React.createElement("tr",{key:e},_(a).times(function(t){return React.createElement("td",{key:t},React.createElement(s,babelHelpers.extends({ref:getRefForPath(getInputPath(e,t)),type:"text",value:r.props.answers[e][t],disabled:r.props.apiOptions.readOnly,onFocus:_.partial(r._handleFocus,getInputPath(e,t)),onBlur:_.partial(r._handleBlur,getInputPath(e,t)),onChange:_.partial(r.onValueChange,e,t),style:o},p)))}))})))}
return r}(React.Component)
Table.propTypes={answers:PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.string)),editableHeaders:PropTypes.bool,Editor:PropTypes.func,headers:PropTypes.arrayOf(PropTypes.string),keypadElement:keypadElementPropType,trackInteraction:PropTypes.func.isRequired,linterContext:linterContextProps}
Table.defaultProps=function(){var e=4
var r=1
var t=_(e).times(function(){return Util.stringArrayOfSize(r)})
return{apiOptions:ApiOptions.defaults,headers:[""],editableHeaders:false,rows:e,columns:r,answers:t,linterContext:linterContextDefault}}()
_.extend(Table,{validate:function e(r,t){var a=function e(r){return _.filter(r,function(e){return _.some(e,_.identity)})}
var n=a(t.answers)
var s=a(r)
var o=_.some(s,function(e){return _.some(e,function(e){return e===""})})
if(o||!s.length){return{type:"invalid",message:null}}if(s.length!==n.length){return{type:"points",earned:0,total:1,message:null}}var p=KhanAnswerTypes.number.createValidatorFunctional
var i=null
var u=_.every(n,function(e){var r
for(r=0;r<s.length;r++){var t=s[r]
var a=_.every(t,function(r,t){var a=e[t]
var n=p(a,{simplify:true})
var s=n(r)
if(s.message){i=s.message}return s.correct})
if(a){s.splice(r,1)
return true}}return false})
return{type:"points",earned:u?1:0,total:1,message:i}}})
var propTransform=function e(r){var t=r.answers.length
var a=r.answers[0].length
var n=_(t).times(function(){return Util.stringArrayOfSize(a)})
return _.extend({},r,{answers:n})}
module.exports={name:"table",displayName:"Table of values",accessible:true,widget:Table,transform:propTransform,hidden:true,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/transformer.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var createReactClass=require("create-react-class")
var ReactDOM=require("react-dom")
var _=require("underscore")
var $=require("jquery")
var Graph=require("../../perseus-all-package/components/graph.jsx")
var InlineIcon=require("../../perseus-all-package/components/inline-icon.jsx")
var NumberInput=require("../../perseus-all-package/components/number-input.jsx")
var MathOutput=require("../../perseus-all-package/components/math-output.jsx")
var TeX=require("../../react-components-package/tex.jsx")
var SimpleKeypadInput=require("../../perseus-all-package/components/simple-keypad-input.jsx")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var keypadElementPropType=require("math-input").propTypes.keypadElementPropType
var ROTATE_SNAP_DEGREES=15
var DEGREE_SIGN="°"
var RENDER_TRANSFORM_DELAY_IN_MS=300
var ROTATE_HANDLE_DIST=1.5
var REFLECT_ROTATE_HANDLE_DIST=2
var REFLECT_BUTTON_SIZE=1
var _require=require("../../perseus-all-package/icon-paths.js"),iconPlus=_require.iconPlus,iconUndo=_require.iconUndo
var deepEq=require("../../perseus-all-package/util.js").deepEq
var getGridStep=require("../../perseus-all-package/util.js").getGridStep
var captureScratchpadTouchStart=require("../../perseus-all-package/util.js").captureScratchpadTouchStart
var knumber=require("kmath").number
var kvector=require("kmath").vector
var kpoint=require("kmath").point
var kray=require("kmath").ray
var kline=require("kmath").line
var KhanMath=require("../../perseus-all-package/util/math.js")
var KhanColors=require("../../perseus-all-package/util/colors.js")
var i18n=require("../../shared-package/i18n.js")
var assert=require("../../perseus-all-package/interactive2/interactive-util.js").assert
var defaultBoxSize=400
var defaultBackgroundImage={url:null}
function pluckObject(e,t){return _.object(_.map(e,function(e,r){return[r,e[t]]}))}var defaultGraphProps=function e(t,r){t=t||{}
var n=t.labels||["x","y"]
var o=t.range||[[-10,10],[-10,10]]
var a=t.step||[1,1]
var s=t.gridStep||getGridStep(o,a,r)
return{box:[r,r],labels:n,range:o,step:a,gridStep:s,valid:true,backgroundImage:defaultBackgroundImage,markings:"grid",showProtractor:false}}
var defaultTransformerProps={apiOptions:ApiOptions.defaults,gradeEmpty:false,graphMode:"interactive",listMode:"dynamic",graph:{},tools:{translation:{enabled:true,required:false,constraints:{}},rotation:{enabled:true,required:false,constraints:{fixed:false},coord:[1,6]},reflection:{enabled:true,required:false,constraints:{fixed:false},coords:[[2,-4],[2,2]]},dilation:{enabled:true,required:false,constraints:{fixed:false},coord:[6,6]}},drawSolutionShape:true,starting:{shape:{type:"polygon-3",coords:[[2,2],[2,6],[7,2]]},transformations:[]},correct:{shape:{type:"polygon-3",coords:[[2,2],[2,6],[7,2]]},transformations:[]}}
function colorForTool(e){return e.constraints.fixed?KhanColors.DYNAMIC:KhanColors.INTERACTIVE}function scaleToRange(e,t){var r=t[0][1]-t[0][0]
var n=t[1][1]-t[1][0]
return e*Math.max(r,n)/20}function dilatePointFromCenter(e,t,r){var n=kvector.subtract(e,t)
var o=kvector.scale(n,r)
var a=kvector.add(t,o)
return a}function stringFromDecimal(e){return String(KhanMath.roundTo(9,e))}function stringFromFraction(e){var t=KhanMath.toFraction(e,knumber.DEFAULT_TOLERANCE)
if(t[1]===1){return stringFromDecimal(e)}else{return stringFromDecimal(t[0])+"/"+stringFromDecimal(t[1])}}function texFromPoint(e){return[React.createElement(TeX,null,"("),stringFromDecimal(e[0]),React.createElement(TeX,null,", {}"),stringFromDecimal(e[1]),React.createElement(TeX,null,")")]}function texFromVector(e){return[React.createElement(TeX,null,i18n.doNotTranslate("\\langle")),stringFromDecimal(e[0]),React.createElement(TeX,null,", {}"),stringFromDecimal(e[1]),React.createElement(TeX,null,i18n.doNotTranslate("\\rangle"))]}function texFromAngleDeg(e){return stringFromDecimal(e)+DEGREE_SIGN}function orderInsensitiveCoordsEqual(e,t){e=_.clone(e).sort(kpoint.compare)
t=_.clone(t).sort(kpoint.compare)
return _.all(_.map(e,function(e,r){var n=t[r]
return kpoint.equal(e,n)}))}var inputComponentForApiOptions=function e(t){if(t.customKeypad){return SimpleKeypadInput}else if(t.staticRender){return MathOutput}else{return NumberInput}}
var TransformOps={apply:function e(t){if(!Transformations[t.type].isValid(t)){return _.identity}else{return Transformations[t.type].apply(t)}},append:function e(t,r){var n=TransformOps._appendAndCollapseLastTwo(t,r)
return TransformOps._collapseFinalNoOps(n)},_collapseFinalNoOps:function e(t){if(t.length&&TransformOps.isNoOp(_.last(t))){return _.initial(t)}else{return t}},_appendAndCollapseLastTwo:function e(t,r){if(!t.length){return[r]}else{var n=TransformOps.collapse(_.last(t),r)
return _.initial(t).concat(n)}},isNoOp:function e(t){return Transformations[t.type].isNoOp(t)},collapse:function e(t,r){if(t.type!==r.type){return[t,r]}if(TransformOps.isEmpty(t)&&TransformOps.isEmpty(r)){return[]}if(!TransformOps.isValid(t)||!TransformOps.isValid(r)){return[t,r]}return TransformOps._collapseValidMonotypedTransforms(t,r)},isValid:function e(t){return Transformations[t.type].isValid(t)},isEmpty:function e(t){return Transformations[t.type].isEmpty(t)},_collapseValidMonotypedTransforms:function e(t,r){var n=Transformations[t.type].collapse(t,r)
if(n){if(!_.isArray(n)){n=[n]}_.each(n,function(e){e.type=t.type})
return n}else{return[t,r]}},toTeX:function e(t){return Transformations[t.type].toTeX(t)},ListItem:createReactClass({displayName:"ListItem",render:function e(){if(this.props.mode==="dynamic"){return React.createElement("div",null,TransformOps.toTeX(this.props.transform))}else if(this.props.mode==="interactive"){var t=Transformations[this.props.transform.type].Input
return React.createElement(t,babelHelpers.extends({ref:"transform",onChange:this.handleChange,onFocus:this.props.onFocus,onBlur:this.props.onBlur,keypadElement:this.props.keypadElement,apiOptions:this.props.apiOptions},this.props.transform))}else{throw new Error("Invalid mode: "+this.props.mode)}},value:function e(){if(this.props.mode==="interactive"){return _.extend({type:this.props.transform.type},this.refs.transform.value())}else{return this.props.transform}},handleChange:_.debounce(function(e){this.props.onChange(this.value(),e)},RENDER_TRANSFORM_DELAY_IN_MS),_getComponentAtPath:function e(t){var r=this.refs.transform
var n=_.head(t)
return r.refs[n]},focus:function e(){var t=this.refs.transform
var r=_.head(t.getInputPaths())
if(r){this.focusInputPath(r)}},focusInputPath:function e(t){this._getComponentAtPath(t).focus()},blurInputPath:function e(t){this._getComponentAtPath(t).blur()},getDOMNodeForPath:function e(t){return ReactDOM.findDOMNode(this._getComponentAtPath(t))},getGrammarTypeForPath:function e(t){return"number"},setInputValue:function e(t,r,n){if(r.length){r=parseFloat(r)
if(isNaN(r)){return}}this.refs.transform.setInputValue(t,r,n)},getInputPaths:function e(){if(this.props.mode==="dynamic"){return[]}else{return this.refs.transform.getInputPaths()}}})}
var Transformations={translation:{verbName:i18n._("Translate"),nounName:i18n._("Translation"),lowerNounName:i18n._("translation"),apply:function e(t){return function(e){return kvector.add(e,t.vector)}},isValid:function e(t){return _.isFinite(t.vector[0])&&_.isFinite(t.vector[1])},isEmpty:function e(t){return t.vector[0]===null&&t.vector[1]===null},isNoOp:function e(t){return kvector.equal(t.vector,[0,0])},collapse:function e(t,r){return{vector:kvector.add(t.vector,r.vector)}},toTeX:function e(t){return i18n.$_("Translation by %(vector)s",{vector:texFromVector(t.vector)})},Input:function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.state={vector:n.props.vector||[null,null]},n.value=function(){var e=n.refs.x.getValue()
var t=n.refs.y.getValue()
return{vector:[e,t]}},n.setInputValue=function(e,t,r){var o=_.first(e)
var a=_.clone(n.state.vector)
if(o==="x"){a[0]=t}else if(o==="y"){a[1]=t}n.setState({vector:a},function(){n.props.onChange(r)})},n.getInputPaths=function(){return[["x"],["y"]]},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.componentDidUpdate=function e(t){if(!deepEq(this.props,t)){this.setState({vector:this.props.vector})}}
t.prototype.render=function e(){var t=this
var r=inputComponentForApiOptions(this.props.apiOptions)
var n=[React.createElement(TeX,null,i18n.doNotTranslate("\\langle")),React.createElement(r,{ref:"x",placeholder:0,value:this.state.vector[0],useArrowKeys:true,onChange:function e(r){var n=t.state.vector[1]
t.setState({vector:[r,n]},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"x"),onBlur:_.partial(this.props.onBlur,"x"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,", {}"),React.createElement(r,{ref:"y",placeholder:0,value:this.state.vector[1],useArrowKeys:true,onChange:function e(r){var n=t.state.vector[0]
t.setState({vector:[n,r]},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"y"),onBlur:_.partial(this.props.onBlur,"y"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,i18n.doNotTranslate("\\rangle"))]
return React.createElement("div",null,i18n.$_("Translation by %(vector)s",{vector:n}))}
return t}(React.Component)},rotation:{verbName:i18n._("Rotate"),nounName:i18n._("Rotation"),lowerNounName:i18n._("rotation"),apply:function e(t){return function(e){return kpoint.rotateDeg(e,t.angleDeg,t.center)}},isValid:function e(t){return _.isFinite(t.angleDeg)&&_.isFinite(t.center[0])&&_.isFinite(t.center[1])},isEmpty:function e(t){return t.angleDeg===null&&t.center[0]===null&&t.center[1]===null},isNoOp:function e(t){return knumber.equal(t.angleDeg,0)},collapse:function e(t,r){if(!kpoint.equal(t.center,r.center)){return false}return{center:t.center,angleDeg:t.angleDeg+r.angleDeg}},toTeX:function e(t){return i18n.$_("Rotation by %(degrees)s about %(point)s",{degrees:texFromAngleDeg(t.angleDeg),point:texFromPoint(t.center)})},Input:function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.state={center:n.props.center||[null,null],angleDeg:n.props.angleDeg||null},n.value=function(){var e=n.refs.angleDeg.getValue()
var t=n.refs.centerX.getValue()
var r=n.refs.centerY.getValue()
return{angleDeg:e,center:[t,r]}},n.setInputValue=function(e,t,r){var o=_.first(e)
var a=_.clone(n.state.angleDeg)
var s=_.clone(n.state.center)
if(o==="angleDeg"){a=t}else if(o==="centerX"){s[0]=t}else if(o==="centerY"){s[1]=t}n.setState({angleDeg:a,center:s},function(){n.props.onChange(r)})},n.getInputPaths=function(){return[["centerX"],["centerY"],["angleDeg"]]},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.componentDidUpdate=function e(t){if(!deepEq(this.props,t)){this.setState({center:this.props.center,angleDeg:this.props.angleDeg})}}
t.prototype.render=function e(){var t=this
var r=inputComponentForApiOptions(this.props.apiOptions)
var n=[React.createElement(TeX,null,"("),React.createElement(r,{ref:"centerX",placeholder:0,value:this.state.center[0],useArrowKeys:true,onChange:function e(r){var n=t.state.center[1]
t.setState({center:[r,n]},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"centerX"),onBlur:_.partial(this.props.onBlur,"centerX"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,", {}"),React.createElement(r,{ref:"centerY",placeholder:0,value:this.state.center[1],useArrowKeys:true,onChange:function e(r){var n=t.state.center[0]
t.setState({center:[n,r]},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"centerY"),onBlur:_.partial(this.props.onBlur,"centerY"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,")")]
var o=[React.createElement(r,{ref:"angleDeg",placeholder:0,value:this.state.angleDeg,useArrowKeys:true,onChange:function e(r){t.setState({angleDeg:r},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"angleDeg"),onBlur:_.partial(this.props.onBlur,"angleDeg"),keypadElement:this.props.keypadElement}),DEGREE_SIGN]
var a=i18n.$_("Rotation about %(point)s by %(degrees)s",{point:n,degrees:o})
return React.createElement("div",null,a)}
return t}(React.Component)},reflection:{verbName:i18n._("Reflect"),nounName:i18n._("Reflection"),lowerNounName:i18n._("reflection"),apply:function e(t){return function(e){return kpoint.reflectOverLine(e,t.line)}},isValid:function e(t){return _.all(_.flatten(t.line),_.isFinite)&&!kpoint.equal(t.line[0],t.line[1])},isEmpty:function e(t){return _.all(_.flatten(t.line),_.isNull)},isNoOp:function e(t){return false},collapse:function e(t,r){if(!kline.equal(t.line,r.line)){return false}return[]},toTeX:function e(t){var r=t.line[0]
var n=t.line[1]
return i18n.$_("Reflection over the line from %(point1)s to %(point2)s",{point1:texFromPoint(r),point2:texFromPoint(n)})},Input:function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.state={line:n.props.line||[[null,null],[null,null]]},n.changePoint=function(e,t,r,o){var a=_.map(n.state.line,_.clone)
a[e][t]=r
n.setState({line:a},function(){n.props.onChange(o)})},n.value=function(){var e=n.refs.x1.getValue()
var t=n.refs.y1.getValue()
var r=n.refs.x2.getValue()
var o=n.refs.y2.getValue()
return{line:[[e,t],[r,o]]}},n.setInputValue=function(e,t,r){var o=_.first(e)
var a
if(o[0]==="x"){a=0}else if(o[0]==="y"){a=1}var s
if(o[1]==="1"){s=0}else if(o[1]==="2"){s=1}n.changePoint(s,a,t,r)},n.getInputPaths=function(){return[["x1"],["y1"],["x2"],["y2"]]},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.componentDidUpdate=function e(t){if(!deepEq(this.props,t)){this.setState({line:this.props.line})}}
t.prototype.render=function e(){var t=inputComponentForApiOptions(this.props.apiOptions)
var r=[React.createElement(TeX,null,"("),React.createElement(t,{ref:"x1",value:this.state.line[0][0],useArrowKeys:true,onChange:this.changePoint.bind(this,0,0),onFocus:_.partial(this.props.onFocus,"x1"),onBlur:_.partial(this.props.onBlur,"x1"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,", {}"),React.createElement(t,{ref:"y1",value:this.state.line[0][1],useArrowKeys:true,onChange:this.changePoint.bind(this,0,1),onFocus:_.partial(this.props.onFocus,"y1"),onBlur:_.partial(this.props.onBlur,"y1"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,")")]
var n=[React.createElement(TeX,null,"("),React.createElement(t,{ref:"x2",value:this.state.line[1][0],useArrowKeys:true,onChange:this.changePoint.bind(this,1,0),onFocus:_.partial(this.props.onFocus,"x2"),onBlur:_.partial(this.props.onBlur,"x2"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,", {}"),React.createElement(t,{ref:"y2",value:this.state.line[1][1],useArrowKeys:true,onChange:this.changePoint.bind(this,1,1),onFocus:_.partial(this.props.onFocus,"y2"),onBlur:_.partial(this.props.onBlur,"y2"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,")")]
return React.createElement("div",null,i18n.$_("Reflection over the line from "+"%(point1)s to %(point2)s",{point1:r,point2:n}))}
return t}(React.Component)},dilation:{verbName:i18n._("Dilate"),nounName:i18n._("Dilation"),lowerNounName:i18n._("dilation"),apply:function e(t){return function(e){return dilatePointFromCenter(e,t.center,t.scale)}},isValid:function e(t){return _.isFinite(t.scale)&&_.isFinite(t.center[0])&&_.isFinite(t.center[1])},isEmpty:function e(t){return t.scale===null&&t.center[0]===null&&t.center[1]===null},isNoOp:function e(t){return knumber.equal(t.scale,1)},collapse:function e(t,r){if(!kpoint.equal(t.center,r.center)){return false}return{center:t.center,scale:t.scale*r.scale}},toTeX:function e(t){var r=stringFromFraction(t.scale)
return i18n.$_("Dilation of scale %(scale)s about %(point)s",{scale:r,point:texFromPoint(t.center)})},Input:function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.state={center:n.props.center||[null,null],scale:n.props.scale||null},n.value=function(){var e=n.refs.scale.getValue()
var t=n.refs.x.getValue()
var r=n.refs.y.getValue()
return{scale:e,center:[t,r]}},n.setInputValue=function(e,t,r){var o=_.first(e)
var a=n.state.scale
var s=_.clone(n.state.center)
if(o==="x"){s[0]=t}else if(o==="y"){s[1]=t}else if(o==="scale"){a=t}n.setState({scale:a,center:s},function(){n.props.onChange(r)})},n.getInputPaths=function(){return[["x"],["y"],["scale"]]},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.componentDidUpdate=function e(t){if(!deepEq(this.props,t)){this.setState({center:this.props.center,scale:this.props.scale})}}
t.prototype.render=function e(){var t=this
var r=inputComponentForApiOptions(this.props.apiOptions)
var n=[React.createElement(TeX,null,"("),React.createElement(r,{ref:"x",placeholder:0,value:this.state.center[0],useArrowKeys:true,onChange:function e(r){var n=t.state.center[1]
t.setState({center:[r,n]},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"x"),onBlur:_.partial(this.props.onBlur,"x"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,", {}"),React.createElement(r,{ref:"y",placeholder:0,value:this.state.center[1],useArrowKeys:true,onChange:function e(r){var n=t.state.center[0]
t.setState({center:[n,r]},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"y"),onBlur:_.partial(this.props.onBlur,"y"),keypadElement:this.props.keypadElement}),React.createElement(TeX,null,")")]
var o=React.createElement(r,{ref:"scale",placeholder:1,value:this.state.scale,useArrowKeys:true,onChange:function e(r){t.setState({scale:r},function(){t.props.onChange()})},onFocus:_.partial(this.props.onFocus,"scale"),onBlur:_.partial(this.props.onBlur,"scale"),keypadElement:this.props.keypadElement})
return React.createElement("div",null,i18n.$_("Dilation about %(point)s by %(scale)s",{point:n,scale:o}))}
return t}(React.Component)}}
var ShapeTypes={getPointCountForType:function e(t){var r=t.split("-")
if(r[0]==="polygon"){return r[1]||3}else if(r[0]==="line"||r[0]==="lineSegment"){return 2}else if(r[0]==="angle"){return 3}else if(r[0]==="circle"){return 2}else if(r[0]==="point"){return 1}},addMovableShape:function e(t,r){if(r.editable&&r.translatable){throw new Error("It doesn't make sense to have a movable shape "+"where you can stretch the points and translate them "+"simultaneously. options: "+JSON.stringify(r))}var n
var o=_.map(r.shape.coords,function(e){var a
var s=false
var i=e
var l=function e(t,l){if(!s){i=a.coord
s=true}var p=kvector.subtract([t,l],a.coord)
if(r.onMove){p=r.onMove(p[0],p[1])}if(r.translatable){_.each(o,function(e){if(e!==a){e.setCoord(kvector.add(e.coord,p))}})}var c=a.coord
var u=kvector.add(a.coord,p)
a.coord=u
n.update()
a.coord=c
return u}
var p=function e(){if(r.onMoveEnd&&s){s=false
var t=kvector.subtract(a.coord,i)
r.onMoveEnd(t[0],t[1])}n.update()}
a=t.addMovablePoint({coord:e,normalStyle:r.normalPointStyle,highlightStyle:r.highlightPointStyle,constraints:{fixed:!r.translatable&&!r.editable},visible:r.showPoints,snapX:r.snap&&r.snap[0]||0,snapY:r.snap&&r.snap[1]||0,bounded:false,onMove:l,onMoveEnd:p})
a.bounded=true
return a})
n=ShapeTypes.addShape(t,r,o)
var a=n.remove
n.remove=function(){a.apply(n)
_.invoke(o,"remove")}
return n},addShape:function e(t,r,n){n=n||r.shape.coords
var o=ShapeTypes._typesOf(r.shape)
var a=r.shape.options||ShapeTypes.defaultOptions(o)
var s=ShapeTypes._mapTypes(o,n,function(e,n,o){var s=_.extend({},r,a[o])
return ShapeTypes._addType(t,e,n,s)})
var i=_.filter(_.pluck(s,"update"),_.identity)
var l=function e(){_.invoke(i,"call")}
var p=_.filter(_.pluck(s,"remove"),_.identity)
var c=function e(){_.invoke(p,"call")}
var u=function e(){return _.map(s,function(e){if(e.getOptions){return e.getOptions()}else{return{}}})}
var h=function e(){var t=_.map(n,function(e){if(_.isArray(e)){return e}else{return e.coord}})
return{type:o,coords:t,options:u()}}
return{type:o,points:n,update:l,remove:c,toJSON:h,getOptions:u}},equal:function e(t,r){var n=ShapeTypes._typesOf(t)
var o=ShapeTypes._typesOf(r)
if(n.length!==o.length){return false}var a=ShapeTypes._mapTypes(n,t.coords,ShapeTypes._combine)
var s=ShapeTypes._mapTypes(o,r.coords,ShapeTypes._combine)
return _.all(_.map(a,function(e,t){var r=s[t]
if(e.type!==r.type){return false}return ShapeTypes._forType(e.type).equal(e.coords,r.coords)}))},_typesOf:function e(t){var r=t.type
if(!_.isArray(r)){r=[r]}return _.map(r,function(e){if(e==="polygon"){return"polygon-3"}else{return e}})},defaultOptions:function e(t){return _.map(t,function(e){var t=ShapeTypes._forType(e).defaultOptions
return _.extend({},t)})},_forType:function e(t){var r=t.split("-")[0]
return ShapeTypes[r]},_mapTypes:function e(t,r,n,o){return _.map(t,function(e,t){var a=ShapeTypes.getPointCountForType(e)
var s=_.first(r,a)
r=_.rest(r,a)
return n.call(o,e,s,t)})},_addType:function e(t,r,n,o){var a=_.isArray(n[0])?{coordA:n[0],coordZ:n[1]}:{pointA:n[0],pointZ:n[1]}
r=r.split("-")[0]
if(r==="polygon"){var s=t.addMovablePolygon(_.extend({},o,{fixed:!o.editable,snapX:o.snap&&o.snap[0]||0,snapY:o.snap&&o.snap[1]||0,points:n,constrainToGraph:false}))
return{update:s.transform.bind(s),remove:s.remove.bind(s)}}else if(r==="line"||r==="lineSegment"){var i=t.addMovableLineSegment(_.extend({},o,a,{movePointsWithLine:true,fixed:true,constraints:{fixed:true},extendLine:r==="line"}))
return{update:i.transform.bind(i,true),remove:i.remove.bind(i)}}else if(r==="angle"){var l=o.editable?null:false
var p=t.addMovableAngle({angleLabel:"$deg0",fixed:true,points:n,normalStyle:o.normalStyle,reflex:o.reflex})
if(!_.isArray(n[0])&&!o.editable){n[0].remove()
n[2].remove()}return{update:p.update.bind(p,l),remove:p.remove.bind(p),getOptions:function e(){return{reflex:p.isReflex()}}}}else if(r==="circle"){var c={remove:_.identity}
var u=function e(){var r=n[0].coord||n[0]
var a=n[1].coord||n[1]
var s=kpoint.distanceToPoint(r,a)
c.remove()
c=t.circle(r,s,_.extend({stroke:KhanColors.DYNAMIC,"stroke-width":2},o.normalStyle))}
u()
if(n[1].remove&&!o.editable){n[1].remove()}return{update:u,remove:function e(){c.remove()}}}else if(r==="point"){return{update:null,remove:null}}else{throw new Error("Invalid shape type "+r)}},_combine:function e(t,r){return{type:t,coords:r}},polygon:{equal:orderInsensitiveCoordsEqual},line:{equal:kline.equal},lineSegment:{equal:orderInsensitiveCoordsEqual},angle:{equal:function e(t,r){if(!kpoint.equal(t[1],r[1])){return false}var n=[t[1],t[0]]
var o=[t[1],t[2]]
var a=[r[1],r[0]]
var s=[r[1],r[2]]
var i=kray.equal(n,a)&&kray.equal(o,s)
var l=kray.equal(n,s)&&kray.equal(o,a)
return i||l},defaultOptions:{reflex:false}},circle:{equal:function e(t,r){var n=kpoint.distanceToPoint(t[0],t[1])
var o=kpoint.distanceToPoint(r[0],r[1])
return kpoint.equal(t[0],r[0])&&knumber.equal(n,o)}},point:{equal:kpoint.equal}}
var TransformationListItem=TransformOps.ListItem
var TransformationList=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n._transformationRefs=function(){return _.times(n.props.transformations.length,function(e){return n.refs["transformation"+e]})},n.value=function(){return _.invoke(n._transformationRefs(),"value")},n.handleChange=function(e,t){n.props.onChange(n.value(),t)},n.focusLast=function(){var e=n._transformationRefs()
if(e.length!==0){_.last(e).focus()}},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.render=function e(){if(this.props.mode==="static"){return React.createElement("span",null)}var t=_.map(this.props.transformations,function(e,t){return React.createElement(TransformationListItem,{ref:"transformation"+t,key:"transformation"+t,transform:e,mode:this.props.mode,onChange:this.handleChange,onFocus:_.partial(this.props.onFocus,""+t),onBlur:_.partial(this.props.onBlur,""+t),keypadElement:this.props.keypadElement,apiOptions:this.props.apiOptions})},this)
return React.createElement("div",{className:"perseus-transformation-list"},t)}
return t}(React.Component)
var ToolButton=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=this.props.toggled?"simple-button exercise-orange toggled highlighted-tool-button":"simple-button"
return React.createElement("button",{type:"button",className:t,disabled:this.props.disabled,onClick:this.props.onClick,onTouchStart:captureScratchpadTouchStart},this.props.children)}
return t}(React.Component)
var ToolsBar=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.state={selected:null},n.changeSelected=function(e){n.props.removeTool(n.state.selected)
if(!e||e===n.state.selected){n.setState({selected:null})}else{n.props.addTool(e)
n.setState({selected:e})}},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.render=function e(){var t=_.map(Transformations,function(e,t){if(this.props.enabled[t]){return React.createElement(ToolButton,{key:t,disabled:this.props.apiOptions.readOnly,toggled:this.state.selected===t,onClick:this.changeSelected.bind(this,t)},e.verbName)}},this)
return React.createElement("div",{className:"transformer-tools-bar"},React.createElement("span",{className:"simple-button-group"},t),React.createElement("button",{className:"transformer-undo-button simple-button",type:"button",disabled:this.props.apiOptions.readOnly,onClick:this.props.onUndoClick,onTouchStart:captureScratchpadTouchStart},React.createElement(InlineIcon,iconUndo)," "+i18n._("Undo")),React.createElement("div",{className:"clear"}))}
return t}(React.Component)
var AddTransformBar=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,o
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),i=0;i<a;i++){s[i]=arguments[i]}return o=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.changeSelected=function(e){if(e){n.props.addTool(e)}},r),babelHelpers.possibleConstructorReturn(n,o)}t.prototype.render=function e(){var t=_.map(Transformations,function(e,t){if(this.props.enabled[t]){return React.createElement(ToolButton,{key:t,toggled:false,disabled:this.props.apiOptions.readOnly,onClick:this.changeSelected.bind(this,t)},React.createElement(InlineIcon,iconPlus)," ",e.nounName)}},this)
return React.createElement("div",{className:"transformer-tools-bar"},t,React.createElement("button",{className:"transformer-undo-button simple-button",type:"button",onClick:this.props.onUndoClick,disabled:this.props.apiOptions.readOnly,onTouchStart:captureScratchpadTouchStart},React.createElement(InlineIcon,iconUndo)," "+i18n._("Undo")),React.createElement("div",{className:"clear"}))}
return t}(React.Component)
var Transformer=createReactClass({displayName:"Transformer",propTypes:{apiOptions:ApiOptions.propTypes,keypadElement:keypadElementPropType,trackInteraction:PropTypes.func.isRequired},getDefaultProps:function e(){return _.defaults({transformations:[]},defaultTransformerProps)},render:function e(){var t=_.extend(defaultGraphProps(this.props.graph,defaultBoxSize),this.props.graph)
var r=this.props.graphMode==="interactive"
var n=r?ToolsBar:AddTransformBar
var o=React.createElement("div",{style:{width:t.box[0]}},React.createElement(n,{ref:"toolsBar",enabled:pluckObject(this.props.tools,"enabled"),apiOptions:this.props.apiOptions,addTool:this.addTool,removeTool:this.removeTool,onUndoClick:this.handleUndoClick}))
return React.createElement("div",{className:"perseus-widget "+"perseus-widget-transformer"},React.createElement(Graph,{ref:"graph",box:t.box,range:t.range,labels:t.labels,step:t.step,gridStep:t.gridStep,markings:t.markings,backgroundImage:t.backgroundImage,showProtractor:t.showProtractor,onGraphieUpdated:this.setupGraphie,setDrawingAreaAvailable:this.props.apiOptions.setDrawingAreaAvailable}),!r&&i18n._("Add transformations below:"),this.props.graphMode==="static"&&[React.createElement("br",{key:"static-br"}),React.createElement("em",{key:"static-nomove"}," ",i18n._("Note: For this question, the shape will not move.")," ")],r&&o,React.createElement(TransformationList,{ref:"transformationList",mode:this.props.listMode,transformations:this.props.transformations,onChange:this.setTransformationProps,onFocus:this._handleFocus,onBlur:this._handleBlur,keypadElement:this.props.keypadElement,apiOptions:this.props.apiOptions}),!r&&o)},componentDidMount:function e(){this.setupGraphie(this.graphie())},componentDidUpdate:function e(t){if(this.shouldSetupGraphie(this.props,t)){this.refs.graph.reset()}else if(!deepEq(this.props.transformations,this.transformations)){this.setTransformations(this.props.transformations)}},shouldSetupGraphie:function e(t,r){if(!deepEq(r.starting,t.starting)){return true}else if(r.graphMode!==t.graphMode){return true}else if(r.listMode!==t.listMode){return true}else if(r.drawSolutionShape!==t.drawSolutionShape){return true}else if(t.drawSolutionShape&&!deepEq(r.correct.shape,t.correct.shape)){return true}else if(!deepEq(this.tools,t.tools)){return true}else{return false}},graphie:function e(){return this.refs.graph.graphie()},setupGraphie:function e(t){if(this.props.drawSolutionShape&&this.props.correct.shape&&this.props.correct.shape.coords){ShapeTypes.addShape(t,{fixed:true,shape:this.props.correct.shape,normalStyle:{stroke:KhanColors.GRAY,"stroke-dasharray":"","stroke-width":2}})}this.currentTool=null
this.refs.toolsBar.changeSelected(null)
this.addTransformerShape(this.props.starting.shape,false)
this.setTransformations(this.props.transformations)
this.tools={translation:_.clone(this.props.tools.translation),rotation:_.clone(this.props.tools.rotation),reflection:_.clone(this.props.tools.reflection),dilation:_.clone(this.props.tools.dilation)}},setTransformations:function e(t){this.resetCoords()
this.transformations=_.clone(t)
_.each(this.transformations,this.applyTransform)},addTransformerShape:function e(t,r){var n=this
var o=this.graphie()
this.shape=ShapeTypes.addMovableShape(o,{shape:t,editable:false,showPoints:this.props.graphMode!=="static",translatable:r,onMove:function e(t,r){t=KhanMath.roundToNearest(o.snap[0],t)
r=KhanMath.roundToNearest(o.snap[1],r)
n.addTransform({type:"translation",vector:[t,r]})
return[t,r]},normalPointStyle:{fill:r?KhanColors.INTERACTIVE:KhanColors.DYNAMIC,stroke:r?KhanColors.INTERACTIVE:KhanColors.DYNAMIC},highlightPointStyle:{fill:KhanColors.INTERACTING,stroke:KhanColors.INTERACTING}})},addTool:function e(t){var r=this
if(this.props.graphMode==="interactive"){if(t==="translation"){this.currentTool=this.addTranslationTool()}else if(t==="rotation"){this.currentTool=this.addRotationTool()}else if(t==="reflection"){this.currentTool=this.addReflectionTool()}else if(t==="dilation"){this.currentTool=this.addDilationTool()}else{throw new Error("Invalid tool id: "+t)}}else{var n
if(t==="translation"){n={type:t,vector:[null,null]}}else if(t==="rotation"){n={type:t,center:[null,null],angleDeg:null}}else if(t==="reflection"){n={type:t,line:[[null,null],[null,null]]}}else if(t==="dilation"){n={type:t,center:[null,null],scale:null}}else{throw new Error("Invalid tool id: "+t)}this.doTransform(n,function(){r.refs.transformationList.focusLast()})}},removeTool:function e(t){if(this.currentTool){this.currentTool.remove()}this.currentTool=null},addTranslationTool:function e(){var t=this
this.shape.remove()
this.addTransformerShape(this.shape.toJSON(),true)
return{remove:function e(){t.shape.remove()
t.addTransformerShape(t.shape.toJSON(),false)}}},snapCoord:function e(t){var r=this.graphie()
return _.map(t,function(e,t){return KhanMath.roundToNearest(r.snap[t],e)})},normalizeReflectionCoords:function e(t){var r=this.snapCoord(kline.midpoint(t))
var n=kvector.polarDegFromCart(kvector.subtract(t[0],t[1]))
var o=[1,KhanMath.roundToNearest(45,n[1])]
var a=kvector.cartFromPolarDeg(o)
var s=_.map([-1,1],function(e){var t=kvector.add(r,kvector.scale(a,e*this.scaleToCurrentRange(REFLECT_ROTATE_HANDLE_DIST)))
return this.snapCoord(t)},this)
return s},addReflectionTool:function e(){var t=this.props.tools.reflection
if(!t.enabled){return}var r=this
var n=this.refs.graph.graphie()
var o=function e(){r.changeTool("reflection",{coords:_.pluck(s,"coord")})}
var a=this.normalizeReflectionCoords(t.coords)
var s=_.map(a,function(e){return n.addMovablePoint({coord:e,visible:false})},this)
var i
var l=colorForTool(t)
n.style({},function(){i=n.addMovableLineSegment({fixed:t.constraints.fixed,constraints:t.constraints,pointA:s[0],pointZ:s[1],snapX:n.snap[0],snapY:n.snap[1],extendLine:true,normalStyle:{stroke:l,"stroke-width":2,"stroke-dasharray":"- "},highlightStyle:{stroke:KhanColors.INTERACTING,"stroke-width":2,"stroke-dasharray":"- "},movePointsWithLine:true,onMoveEnd:o})})
var p=n.addReflectButton({fixed:t.constraints.fixed,line:i,size:this.scaleToCurrentRange(REFLECT_BUTTON_SIZE),onClick:function e(){r.doTransform({type:"reflection",line:_.pluck(s,"coord")})
if(c){c.setCoord(kvector.add(p.coord,kvector.subtract(p.coord,c.coord)))
c.update()}},normalStyle:{stroke:l,"stroke-width":2,fill:l},highlightStyle:{stroke:KhanColors.INTERACTING,"stroke-width":3,fill:KhanColors.INTERACTING},onMoveEnd:o})
var c=null
if(!t.constraints.fixed){var u=kvector.polarDegFromCart(kvector.subtract(s[1].coord,s[0].coord))[1]+90
c=n.addRotateHandle({center:p,radius:this.scaleToCurrentRange(REFLECT_ROTATE_HANDLE_DIST),angleDeg:u,width:this.scaleToCurrentRange(.24),hoverWidth:this.scaleToCurrentRange(.4),lengthAngle:17,onMove:function e(t){return KhanMath.roundToNearest(45,t)},onMoveEnd:o})}$(i).on("move",function(){p.update()
$(p).trigger("move")})
if(c){$(c).on("move",function(){var e=r.snapCoord(c.coord)
var t=kvector.subtract(e,p.coord)
var n=p.isFlipped()?1:0
s[n].setCoord(kvector.add(p.coord,kvector.rotateDeg(t,90)))
s[1-n].setCoord(kvector.add(p.coord,kvector.rotateDeg(t,-90)))
i.transform(true)
p.update()})}return{remove:function e(){p.remove()
if(c){c.remove()}i.remove()
s[0].remove()
s[1].remove()}}},scaleToCurrentRange:function e(t){return scaleToRange(t,this.refs.graph.props.range)},addRotationTool:function e(){var t=this.props.tools.rotation
if(!t.enabled){return}var r=this
var n=this.refs.graph.graphie()
var o=colorForTool(t)
this.rotatePoint=n.addMovablePoint({constraints:t.constraints,coord:t.coord,snapX:n.snap[0],snapY:n.snap[1],normalStyle:{"stroke-dasharray":"",stroke:o,fill:o},highlightStyle:{"stroke-dasharray":"",stroke:KhanColors.INTERACTING,fill:KhanColors.INTERACTING}})
this.rotateHandle=n.addRotateHandle({center:this.rotatePoint,radius:this.scaleToCurrentRange(ROTATE_HANDLE_DIST),width:this.scaleToCurrentRange(.24),hoverWidth:this.scaleToCurrentRange(.4),onMove:function e(t,n){var o=r.getRotationTransformFromAngle(r.rotatePoint.coord,t-n)
r.doTransform(o)
return n+o.angleDeg}})
this.rotatePoint.onMoveEnd=function(e,t){r.changeTool("rotation",{coord:[e,t]})}
return{remove:function e(){r.rotateHandle.remove()
r.rotatePoint.remove()}}},addDilationTool:function e(){var t=this.props.tools.dilation
if(!t.enabled){return}var r=this
var n=this.refs.graph.graphie()
var o=colorForTool(t)
r.dilationCircle=n.addCircleGraph({centerConstraints:t.constraints,center:t.coord,radius:r.scaleToCurrentRange(2),snapX:n.snap[0],snapY:n.snap[1],minRadius:r.scaleToCurrentRange(1),snapRadius:r.scaleToCurrentRange(.5),onResize:function e(t,n){r.doTransform({type:"dilation",center:r.dilationCircle.centerPoint.coord,scale:t/n})},circleNormalStyle:{stroke:o,"stroke-width":2,"stroke-dasharray":"- ","fill-opacity":0},circleHighlightStyle:{stroke:KhanColors.INTERACTING,"stroke-width":2,"stroke-dasharray":"",fill:KhanColors.INTERACTING,"fill-opacity":.05},centerNormalStyle:{stroke:o,fill:o,"stroke-width":2,"stroke-dasharray":""},centerHighlightStyle:{stroke:o,fill:o,"stroke-width":2,"stroke-dasharray":""}})
var a=this.dilationCircle.centerPoint.onMoveEnd
this.dilationCircle.centerPoint.onMoveEnd=function(){if(a){a.apply(this,_.toArray(arguments))}r.changeTool("dilation",{coord:r.dilationCircle.centerPoint.coord})}
return{remove:function e(){r.dilationCircle.remove()}}},getRotationTransformFromAngle:function e(t,r){r=(r+360)%360
if(r>180){r-=360}var n=Math.round(r/ROTATE_SNAP_DEGREES)*ROTATE_SNAP_DEGREES
return{type:"rotation",center:t,angleDeg:n}},doTransform:function e(t,r){this.applyTransform(t)
this.addTransform(t,r)},applyTransform:function e(t){if(this.props.graphMode!=="static"){var r=TransformOps.apply(t)
this.applyCoordTransformation(r)}},applyCoordTransformation:function e(t){_.each(this.shape.points,function(e){var r=t(e.coord)
e.setCoord(r)})
this.shape.update()},resetCoords:function e(){var t=this.props.starting.shape.coords
_.each(this.shape.points,function(e,r){e.setCoord(t[r])})
this.shape.update()},handleUndoClick:function e(){this.refs.toolsBar.changeSelected(null)
if(this.props.transformations.length){this.props.onChange({transformations:_.initial(this.props.transformations)})}},setTransformationProps:function e(t,r){this.props.onChange({transformations:t},r)},addTransform:function e(t,r){this.transformations=TransformOps.append(this.transformations,t)
this.props.onChange({transformations:_.clone(this.transformations)},r)},changeTool:function e(t,r){var n=_.clone(this.props.tools)
n[t]=_.extend({},this.props.tools[t],r)
this.tools[t]=_.clone(n[t])
this.props.onChange({tools:n})
this.props.trackInteraction()},simpleValidate:function e(t){return Transformer.validate(this.getUserInput(),t)},getCoords:function e(){var t=this.props.starting.shape.coords
var r=this.props.transformations
return _.reduce(r,function(e,t){return _.map(e,TransformOps.apply(t))},t)},getEditorJSON:function e(){var t=_.pick(this.props,"grading","starting","graphMode","listMode","tools","drawSolutionShape","gradeEmpty")
t.graph=this.refs.graph.toJSON()
t.version=1.2
t.answer=this.getUserInput()
return t},getUserInput:function e(){return{transformations:this.props.transformations,shape:{type:this.shape.type,coords:this.getCoords(),options:this.shape.getOptions()}}},_handleFocus:function e(){var t=Array.prototype.slice.call(arguments)
this.props.onFocus(t)},_handleBlur:function e(){var t=Array.prototype.slice.call(arguments)
this.props.onBlur(t)},_getTransformationForID:function e(t){var r=["transformationList","transformation"+t]
var n=this
_.each(r,function(e){n=n.refs[e]})
return n},getInputPaths:function e(){var t=this
if(this.props.listMode==="static"){return[]}var r=[]
_.each(this.props.transformations,function(e,n){var e=t._getTransformationForID(n)
var o=e.getInputPaths()
var a=_.map(o,function(e){return[""+n].concat(e)})
r=r.concat(a)})
return r},_passToInner:function e(t,r){if(!r||!r.length){return}var n=_.rest(r)
var o=[n].concat(_.rest(arguments,2))
var a=_.head(r)
var s=this._getTransformationForID(a)
return s[t].apply(s,o)},focus:function e(){var t=this.getInputPaths()
if(t.length>0){this.focusInputPath(t[0])
return true}return false},focusInputPath:function e(t){if(t.length===0){return false}assert(t.length>=2)
return this._passToInner("focusInputPath",t)},blurInputPath:function e(t){if(t.length===0){return false}assert(t.length>=2)
return this._passToInner("blurInputPath",t)},setInputValue:function e(t,r,n){assert(t.length>=2)
return this._passToInner("setInputValue",t,r,n)},getDOMNodeForPath:function e(t){assert(t.length>=2)
return this._passToInner("getDOMNodeForPath",t)},getGrammarTypeForPath:function e(t){assert(t.length>=2)
return this._passToInner("getGrammarTypeForPath",t)}})
_.extend(Transformer,{validate:function e(t,r){for(var n in Transformations){if(r.tools[n].required){var o=_.any(_.map(t.transformations,function(e){return e.type===n&&!TransformOps.isEmpty(e)&&!TransformOps.isNoOp(e)}))
if(!o){return{type:"invalid",message:i18n._("Your transformation must use a "+"%(type)s.",{type:Transformations[n].lowerNounName})}}}}if(ShapeTypes.equal(t.shape,r.correct.shape)){return{type:"points",earned:1,total:1,message:null}}else if(!r.gradeEmpty&&deepEq(t.shape.coords,r.starting.shape.coords)){return{type:"invalid",message:i18n._("Use the interactive graph to define a "+"correct transformation.")}}else{return{type:"points",earned:0,total:1,message:null}}}})
module.exports={name:"transformer",displayName:"Transformer",widget:Transformer}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/unit.jsx", function(require, module, exports) {
var lens=require("../../../third_party/javascript-khansrc/hubble/hubble.js")
var React=require("react")
var PropTypes=require("prop-types")
var ReactDOM=require("react-dom")
var _=require("underscore")
var $=require("jquery")
var KAS=require("../../../third_party/javascript-khansrc/kas/kas.js")
var i18n=require("../../shared-package/i18n.js")
var ApiClassNames=require("../../perseus-all-package/perseus-api.jsx").ClassNames
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var MathOutput=require("../../perseus-all-package/components/math-output.jsx")
var _require=require("../../perseus-all-package/sigfigs.jsx"),SignificantFigures=_require.SignificantFigures,displaySigFigs=_require.displaySigFigs
var ALL="all"
var SOME="some"
var MAX_SIGFIGS=10
var countSigfigs=function e(r){return new SignificantFigures(r).sigFigs}
var sigfigPrint=function e(r,i){return displaySigFigs(r,i,-MAX_SIGFIGS,false)}
var OldUnitInput=function(e){babelHelpers.inherits(r,e)
function r(){var i,t,n
babelHelpers.classCallCheck(this,r)
for(var a=arguments.length,s=Array(a),u=0;u<a;u++){s[u]=arguments[u]}return n=(i=(t=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),t),_initialiseProps.call(t),i),babelHelpers.possibleConstructorReturn(t,n)}r.prototype.render=function e(){var r=this.props.apiOptions.staticRender?React.createFactory(MathOutput):function(e){return React.createElement("input",e)}
var i=r({onChange:this.handleChange,ref:"input",className:ApiClassNames.INTERACTIVE,value:this.props.value,onFocus:this.handleFocus,onBlur:this.handleBlur})
return React.createElement("div",{className:"old-unit-input"},i,React.createElement("div",{ref:"error",className:"error",style:{display:"none"}},i18n._("I don't understand that")))}
r.prototype.componentDidUpdate=function e(){clearTimeout(this._errorTimeout)
if(KAS.unitParse(this.props.value).parsed){this._hideError()}else{this._errorTimeout=setTimeout(this._showError,2e3)}}
r.prototype.componentWillUnmount=function e(){clearTimeout(this._errorTimeout)}
return r}(React.Component)
OldUnitInput.propTypes=babelHelpers.extends({},Changeable.propTypes,{value:PropTypes.string})
OldUnitInput.defaultProps={apiOptions:ApiOptions.defaults,value:""}
var _initialiseProps=function e(){var r=this
this._errorTimeout=null
this._showError=function(){if(r.props.value===""){return}var e=$(ReactDOM.findDOMNode(r.refs.error))
if(!e.is(":visible")){e.css({top:50,opacity:.1}).show().animate({top:0,opacity:1},300)}}
this._hideError=function(){var e=$(ReactDOM.findDOMNode(r.refs.error))
if(e.is(":visible")){e.animate({top:50,opacity:.1},300,function(){$(this).hide()})}}
this.change=function(){for(var e=arguments.length,i=Array(e),t=0;t<e;t++){i[t]=arguments[t]}return Changeable.change.apply(r,i)}
this.handleBlur=function(){r.props.onBlur([])
clearTimeout(r._errorTimeout)
if(!KAS.unitParse(r.props.value).parsed){r._showError()}}
this.handleChange=function(e){r._hideError()
r.props.onChange({value:e.target.value})}
this.simpleValidate=function(e,i){i=i||function(){}
return OldUnitInput.validate(r.getUserInput(),e)}
this.getUserInput=function(){return r.props.value}
this.getInputPaths=function(){return[[]]}
this.focusInputPath=function(e){ReactDOM.findDOMNode(r.refs.input).focus()}
this.handleFocus=function(){r.props.onFocus([])}
this.blurInputPath=function(e){ReactDOM.findDOMNode(r.refs.input).blur()}
this.setInputValue=function(e,i,t){r.props.onChange({value:i},t)}
this.getDOMNodeForPath=function(){return ReactDOM.findDOMNode(r.refs.input)}
this.getGrammarTypeForPath=function(e){return"unit"}}
var primUnits=function e(r){return r.simplify().asMul().partition()[1].flatten().simplify()}
_.extend(OldUnitInput,{validate:function e(r,i){var t=KAS.unitParse(i.value).expr
var n=KAS.unitParse(r)
if(!n.parsed){return{type:"invalid",message:i18n._("I couldn't understand those units.")}}var a=null
var s=i.sigfigs
var u=countSigfigs(n.coefficient)===s
if(!u){a=i18n._("Check your significant figures.")}var o
try{var p=new KAS.Var("x")
var l=new KAS.Eq(t.simplify(),"=",new KAS.Mul(p,n.expr.simplify()))
var c=l.solveLinearEquationForVariable(p)
o=Number(c.eval()).toPrecision(s)===Number(1).toPrecision(s)}catch(e){o=false}if(!o){a=i18n._("That answer is numerically incorrect.")}var f
var h=primUnits(n.expr.simplify())
var v=primUnits(t.simplify())
if(i.accepting===ALL){f=KAS.compare(h,v).equal}else{f=_(i.acceptingUnits).any(function(e){var r=primUnits(KAS.unitParse(e).unit.simplify())
return KAS.compare(r,h).equal})}if(!f){var a=i18n._("Check your units.")}var d=f&&o&&u
return{type:"points",earned:d?1:0,total:1,message:a}}})
module.exports={name:"unit-input",displayName:"Unit",defaultAlignment:"inline-block",widget:OldUnitInput,transform:function e(r){return lens(r).del(["value"]).freeze()},version:{major:0,minor:1},countSigfigs:countSigfigs,sigfigPrint:sigfigPrint,hidden:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/video.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _=require("underscore")
var i18n=require("../../shared-package/i18n.js")
var Changeable=require("../../perseus-all-package/mixins/changeable.jsx")
var FixedToResponsive=require("../../perseus-all-package/components/fixed-to-responsive.jsx")
var DEFAULT_WIDTH=1280
var DEFAULT_HEIGHT=720
var KA_EMBED="{host}/embed_video?slug={slug}"+"&internal_video_only=1"
var IS_URL=/^https?:\/\//
var IS_KA_SITE=/(khanacademy\.org|localhost)/
var Video=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,i
babelHelpers.classCallCheck(this,r)
for(var n=arguments.length,l=Array(n),o=0;o<n;o++){l[o]=arguments[o]}return i=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(l))),a),_initialiseProps.call(a),t),babelHelpers.possibleConstructorReturn(a,i)}r.prototype.render=function e(){var r=this.props.location
if(!r){return React.createElement("div",null)}var t
if(IS_URL.test(r)){t=r}else{t=KA_EMBED.replace("{slug}",r)
var a=document.location.host
var i="https://www.khanacademy.org"
if(IS_KA_SITE.test(a)){i=document.location.protocol+"//"+a}t=t.replace("{host}",i)}return React.createElement(FixedToResponsive,{width:DEFAULT_WIDTH,height:DEFAULT_HEIGHT,key:r+this.props.alignment},React.createElement("iframe",{title:i18n._("Khan Academy video wrapper"),className:"perseus-video-widget",sandbox:"allow-same-origin allow-scripts",width:DEFAULT_WIDTH,height:DEFAULT_HEIGHT,src:t,allowFullScreen:true}))}
return r}(React.Component)
Video.propTypes=babelHelpers.extends({},Changeable.propTypes,{alignment:PropTypes.string,location:PropTypes.string})
var _initialiseProps=function e(){var r=this
this.getUserInput=function(){return null}
this.simpleValidate=function(e){return Video.validate(null,e)}
this.change=function(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++){t[a]=arguments[a]}return Changeable.change.apply(r,t)}}
_.extend(Video,{validate:function e(r,t){return{type:"points",earned:0,total:0,message:null}}})
module.exports={name:"video",displayName:"Video",defaultAlignment:"block",supportedAlignments:["block","float-left","float-right","full-width"],widget:Video}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/passage/passage-markdown.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var SimpleMarkdown=require("simple-markdown")
var _=require("underscore")
var i18n=require("../../../shared-package/i18n.js")
var START_REF_PREFIX="start-ref-"
var END_REF_PREFIX="end-ref-"
var REF_STYLE={display:"inline-block",width:0,visibility:"hidden"}
var LABEL_OUTER_STYLE={display:"inline",whiteSpace:"nowrap"}
var SQUARE_LABEL_STYLE={display:"inline-block",color:"rgb(255, 255, 255)",backgroundColor:"rgb(90, 90, 90)",paddingLeft:10,paddingRight:10,userSelect:"none",WebkitUserSelect:"none"}
var CIRCLE_LABEL_STYLE={display:"inline-block",color:"rgb(255, 255, 255)",backgroundColor:"rgb(90, 90, 90)",userSelect:"none",WebkitUserSelect:"none",width:22,height:22,borderRadius:"50%",textAlign:"center"}
var RefStart=function(e){babelHelpers.inherits(r,e)
function r(){var t,n,a
babelHelpers.classCallCheck(this,r)
for(var l=arguments.length,s=Array(l),i=0;i<l;i++){s[i]=arguments[i]}return a=(t=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.getRefContent=function(){return n.props.refContent},t),babelHelpers.possibleConstructorReturn(n,a)}r.prototype.render=function e(){return React.createElement("span",{style:REF_STYLE},i18n.doNotTranslate("_"))}
return r}(React.Component)
RefStart.propTypes={refContent:PropTypes.node.isRequired}
var RefEnd=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){return React.createElement("span",{style:REF_STYLE},i18n.doNotTranslate("_"))}
return r}(React.Component)
var rules={newline:SimpleMarkdown.defaultRules.newline,paragraph:SimpleMarkdown.defaultRules.paragraph,escape:SimpleMarkdown.defaultRules.escape,passageFootnote:{order:SimpleMarkdown.defaultRules.escape.order+.1,match:SimpleMarkdown.inlineRegex(/^\^/),parse:function e(r,t,n){var a=n.lastFootnote.id+1
var l={id:a,text:a===1?"*":""+a}
if(n.lastFootnote.text==="*"){n.lastFootnote.text=""+n.lastFootnote.id}n.lastFootnote=l
return l},react:function e(r,t,n){return React.createElement("sup",{key:n.key},r.text)}},refStart:{order:SimpleMarkdown.defaultRules.escape.order+.2,match:function e(r,t){var n=/^\{\{/.exec(r)
if(n){var a=2
var l=0
while(a<r.length){var s=r.slice(a,a+2)
if(s==="{{"){l++
a++}else if(s==="}}"){if(l>0){l--
a++}else{break}}a++}var i=r.slice(2,a)
return[n[0],i]}else{return null}},parse:function e(r,t,n){if(!n.useRefs){return{ref:null,refContent:null}}var a=n.lastRef+1
n.lastRef=a
n.currentRef.push(a)
var l=t("(“"+r[1]+"”)\n\n",_.defaults({useRefs:false},INITIAL_PARSE_STATE))
return{ref:a,refContent:l}},react:function e(r,t,n){if(r.ref==null){return null}var a=t(r.refContent,{})
return React.createElement(RefStart,{ref:START_REF_PREFIX+r.ref,key:START_REF_PREFIX+r.ref,refContent:a})}},refEnd:{order:SimpleMarkdown.defaultRules.escape.order+.3,match:SimpleMarkdown.inlineRegex(/^\}\}/),parse:function e(r,t,n){if(!n.useRefs){return{ref:null}}var a=n.currentRef.pop()||null
return{ref:a}},react:function e(r,t,n){if(r.ref!=null){return React.createElement(RefEnd,{ref:END_REF_PREFIX+r.ref,key:END_REF_PREFIX+r.ref})}else{return null}}},squareLabel:{order:SimpleMarkdown.defaultRules.escape.order+.4,match:SimpleMarkdown.inlineRegex(/^\[\[(\w+)\]\]( *)/),parse:function e(r,t,n){if(!n.firstQuestionRef){n.firstQuestionRef=r[1]}return{content:r[1],space:r[2].length>0}},react:function e(r,t,n){return[React.createElement("span",{key:"visual-square",className:"perseus-passage-square-label",style:LABEL_OUTER_STYLE,"aria-hidden":"true"},React.createElement("span",{style:SQUARE_LABEL_STYLE},r.content)),React.createElement("span",{key:"alt-text",className:"perseus-sr-only"},i18n.$_("[Marker for question %(number)s]",{number:r.content})),r.space?" ":null]}},circleLabel:{order:SimpleMarkdown.defaultRules.escape.order+.5,match:SimpleMarkdown.inlineRegex(/^\(\((\w+)\)\)( *)/),parse:function e(r,t,n){return{content:r[1],space:r[2].length>0}},react:function e(r,t,n){return[React.createElement("span",{key:"visual-circle",className:"perseus-passage-circle-label",style:LABEL_OUTER_STYLE,"aria-hidden":true},React.createElement("span",{style:CIRCLE_LABEL_STYLE},r.content)),React.createElement("span",{key:"alt-text",className:"perseus-sr-only"},i18n.$_("[Circle marker %(number)s]",{number:r.content})),r.space?" ":null]}},squareBracketRef:{order:SimpleMarkdown.defaultRules.escape.order+.6,match:SimpleMarkdown.inlineRegex(/^\[(\d+)\]( *)/),parse:function e(r,t,n){if(!n.firstSentenceRef){n.firstSentenceRef=r[1]}return{content:r[1],space:r[2].length>0}},react:function e(r,t,n){return[React.createElement("span",{key:"visual-brackets",className:"perseus-passage-bracket-label","aria-hidden":"true"},"[",r.content,"]"),React.createElement("span",{key:"alt-text",className:"perseus-sr-only"},i18n.$_("[Sentence %(number)s]",{number:r.content})),r.space?" ":null]}},highlight:{order:SimpleMarkdown.defaultRules.escape.order+.7,match:SimpleMarkdown.inlineRegex(/^{highlighting.start}(.+?){highlighting.end}/),parse:function e(r,t,n){return{content:r[1]}},react:function e(r,t,n){return[React.createElement("span",{className:"perseus-highlight"},r.content)]}},reviewHighlight:{order:SimpleMarkdown.defaultRules.escape.order+.7,match:SimpleMarkdown.inlineRegex(/^{review-highlighting.start}(.+?){review-highlighting.end}/),parse:function e(r,t,n){return{content:r[1]}},react:function e(r,t,n){return[React.createElement("span",{className:"perseus-review-highlight"},r.content)]}},strong:SimpleMarkdown.defaultRules.strong,u:SimpleMarkdown.defaultRules.u,em:SimpleMarkdown.defaultRules.em,del:SimpleMarkdown.defaultRules.del,text:babelHelpers.extends({},SimpleMarkdown.defaultRules.text,{react:function e(r,t,n){return React.createElement("span",{key:n.key},r.content)}})}
var INITIAL_PARSE_STATE={currentRef:[],useRefs:true,lastRef:0,lastFootnote:{id:0,text:""}}
var builtParser=SimpleMarkdown.parserFor(rules)
var parse=function e(r,t){t=t||{}
var n=r+"\n\n"
return builtParser(n,_.extend(t,INITIAL_PARSE_STATE))}
module.exports={parse:parse,output:SimpleMarkdown.reactFor(SimpleMarkdown.ruleOutput(rules,"react")),START_REF_PREFIX:START_REF_PREFIX,END_REF_PREFIX:END_REF_PREFIX,_rulesForTesting:rules}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/molecule/molecule-drawing.jsx", function(require, module, exports) {
function drawText(e,t){if(t.value===null){return}e.fillStyle=styles.fgColor
e.font=styles.font
e.fillText(t.value,t.pos[0]-styles.fontSizePx/2+1,t.pos[1]+styles.fontSizePx/2)}function drawDoubleLine(e,t){var o=new Path2D
e.lineWidth=5*styles.lineWidth
e.strokeStyle=styles.fgColor
o.moveTo(t.startPos[0],t.startPos[1])
o.lineTo(t.endPos[0],t.endPos[1])
e.stroke(o)
o=new Path2D
e.lineWidth=3*styles.lineWidth
e.strokeStyle=styles.bgColor
o.moveTo(t.startPos[0],t.startPos[1])
o.lineTo(t.endPos[0],t.endPos[1])
e.stroke(o)}function drawTripleLine(e,t){var o=new Path2D
e.lineWidth=7*styles.lineWidth
e.strokeStyle=styles.fgColor
o.moveTo(t.startPos[0],t.startPos[1])
o.lineTo(t.endPos[0],t.endPos[1])
e.stroke(o)
o=new Path2D
e.lineWidth=5*styles.lineWidth
e.strokeStyle=styles.bgColor
o.moveTo(t.startPos[0],t.startPos[1])
o.lineTo(t.endPos[0],t.endPos[1])
e.stroke(o)
drawLine(e,t)}function drawLine(e,t){var o=new Path2D
e.lineWidth=styles.lineWidth
e.strokeStyle=styles.fgColor
o.moveTo(t.startPos[0],t.startPos[1])
o.lineTo(t.endPos[0],t.endPos[1])
e.stroke(o)}var drawingFuncs={text:drawText,"line:single":drawLine,"line:double":drawDoubleLine,"line:triple":drawTripleLine}
function drawItem(e){return function(t){drawingFuncs[t.type](e,t)}}var ordering={"line:single":0,"line:double":0,"line:triple":0,text:1}
function compareElements(e,t){return ordering[e.type]-ordering[t.type]}function draw(e,t){t.sort(compareElements).forEach(drawItem(e))}var styles={bgColor:"rgb(255, 255, 255)",fgColor:"rgb(0, 0, 0)",fontSizePx:12,lineWidth:1}
styles.font=styles.fontSizePx+"px sans"
module.exports=draw

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/molecule/molecule-layout.jsx", function(require, module, exports) {
var bondLength=30
function polarAdd(o,n,t){var e=o[0]
var r=o[1]
return[e+Math.cos(n*2*Math.PI/360)*t,r+-1*Math.sin(n*2*Math.PI/360)*t]}function atomLayout(o,n,t,e){var r=o.symbol
if(r==="C"&&Object.keys(n).length!==1){r=null}if(o.idx==="1,0"){var a=[0,0]
o.pos=a
o.baseAngle=-30+e
return{type:"text",value:r,pos:a,idx:o.idx}}var i=n[o.connections.find(function(o){return n[o].pos})]
var s=i.connections.indexOf(o.idx)
var u=60
var p=120
if(i.connections.length===4){p=90
u=90}else if(t.find(function(n){return n.bondType==="triple"&&n.to===o.idx})||t.find(function(o){return o.bondType==="triple"&&o.to===i.idx})){p=0
u=0}var d=0
var c=i.idx.split(":")
var l=c[c.length-1].split(",")[0]
if(parseInt(l)%2!==0){d=i.baseAngle-(u-p*s)}else{d=i.baseAngle+(u-p*s)}var f=polarAdd(i.pos,d,bondLength)
o.pos=f
o.baseAngle=d
return{type:"text",value:r,pos:f,idx:o.idx}}function maybeShrinkLines(o,n){var t=.25
var e=[o.pos[0],o.pos[1]]
var r=[n.pos[0],n.pos[1]]
if(o.symbol!=="C"){e=[n.pos[0]-(1-t)*(n.pos[0]-o.pos[0]),n.pos[1]-(1-t)*(n.pos[1]-o.pos[1])]}if(n.symbol!=="C"){r=[o.pos[0]-(1-t)*(o.pos[0]-n.pos[0]),o.pos[1]-(1-t)*(o.pos[1]-n.pos[1])]}return[e,r]}function bondLayout(o,n){var t=n[o.from]
var e=n[o.to]
var r=maybeShrinkLines(t,e)
return{type:"line:"+o.bondType,startPos:r[0],endPos:r[1]}}function idxString(o){return o.join(":")}function convertTree(o,n,t){if(t===null){return[o,n]}if(t.type==="atom"){var e=idxString(t.idx)
o[e]={idx:e,symbol:t.symbol,connections:[]}
if(t.bonds){t.bonds.forEach(function(t){var r=idxString(t.to.idx)
o[e].connections.push(r)
n.push({from:e,to:r,bondType:t.bondType})
convertTree(o,n,t.to)
o[r].connections.push(e)})}}return[o,n]}function atomLayoutHelper(o,n,t,e,r){if(n.length===0){return o}var a=n.shift()
var i=t[a]
i.connections.forEach(function(o){if(!t[o].pos){n.push(o)}})
return atomLayoutHelper(o.concat(atomLayout(i,t,e,r)),n,t,e,r)}function bondLayoutHelper(o,n,t){if(t.length===0){return o}return bondLayoutHelper(o.concat(bondLayout(t[0],n)),n,t.slice(1))}function layout(o,n){var t=convertTree({},[],o)
var e=t[0]
var r=t[1]
var a=atomLayoutHelper([],["1,0"],e,r,n)
return bondLayoutHelper(a,e,r)}module.exports={layout:layout,_atomLayout:atomLayout,_bondLayout:bondLayout,_bondLength:bondLength,_convertTree:convertTree}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/molecule/smiles-parser.jsx", function(require, module, exports) {
var smilesRe=new RegExp("^[A-Za-z\\[\\]()=#+-]*$")
var atomRe=new RegExp("^(Cl|Br|[CONPSFBI]|\\[)")
function ParseError(e){this.message=e}function _mset(e,r,n){var a=r[0]
var t=r.slice(1)
var s=void 0
if(Array.isArray(e)){s=[].concat(e)}else{s=babelHelpers.extends({},e||{})}var i=n
if(t.length>0){i=_mset(s[a],t,n)}s[a]=i
return s}function _inc(e,r){var n=r.reduce(function(e,r){return e[r]},e)
return _mset(e,r,n+1)}function validate(e){return smilesRe.test(e)}function parseBondModifier(e,r){var n=e[0]
var a=e.slice(1)
if(n==="="){return parse(a,_mset(r,["bond","bondType"],"double"))}else if(n==="#"){return parse(a,_mset(r,["bond","bondType"],"triple"))}throw new ParseError("Invalid character: "+n)}function sliceFromMatchingCloseParen(e,r){if(r.length===0){return e}if(e===""){throw new ParseError("Mismatched parentheses")}var n=e[0]
var a=e.slice(1)
if(n==="("){return sliceFromMatchingCloseParen(a,r.concat(n))}if(n===")"){return sliceFromMatchingCloseParen(a,r.slice(1))}return sliceFromMatchingCloseParen(a,r)}function parseParenthesizedExpression(e,r){var n=e[0]
var a=e.slice(1)
if(n==="("){var t=babelHelpers.extends({},r,{parens:r.parens+"("})
t=_inc(r,["idx",r.idx.length-1,1])
var s=-1
if(r.idx[r.idx.length-1][0]%2===0){s=0}var i=babelHelpers.extends({},t,{idx:t.idx.concat([[s,0]]),parens:t.parens.concat("(")})
var o=parse(a,i)
var l=parse(sliceFromMatchingCloseParen(a,["("]),t)
return[o].concat(l)}else if(n===")"){if(r.parens[r.parens.length-1]!=="("){throw new ParseError("Mismatched parentheses")}return null}else{throw new ParseError("Invalid bare character: "+n)}}function readAtomSymbol(e,r){var n=null
var a=null
if(e[0]==="["){var t=e.indexOf("]")
if(t===-1){return["",e]}n=e.slice(1,t)
a=e.slice(t+1)}else{var s=atomRe.exec(e)
n=s[1]
a=e.slice(n.length)}return[n,a]}function parseAtom(e,r){var n=readAtomSymbol(e,r)
var a=n[0]
if(a===""){return["error","Unable to parse bracketed atom."]}var t=n[1]
var s=_mset(r,["idx",r.idx.length-1],[1+r.idx[r.idx.length-1][0],0])
var i=parse(t,_mset(s,["bond","bondType"],"single"))
if(!Array.isArray(i)&&!!i){i=[i]}var o={type:"atom",symbol:a,bonds:i,idx:s.idx}
if(r.bond){return{type:"bond",bondType:r.bond.bondType,to:o}}return o}function startsWithAtom(e){return atomRe.test(e)}function isModifierChar(e){return e==="="||e==="#"}function parse(e,r){if(!validate(e)){throw new ParseError("Invalid input.")}if(!e||e.length===0){return null}if(startsWithAtom(e)){return parseAtom(e,r||{idx:[[0,0]],parens:[],stack:[],bondModifiers:[]})}else if(isModifierChar(e[0])){return parseBondModifier(e,r)}else{return parseParenthesizedExpression(e,r)}}module.exports={parse:parse,ParseError:ParseError}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/grapher/util.jsx", function(require, module, exports) {
var _=require("underscore")
var Util=require("../../../perseus-all-package/util.js")
var Graphie=require("../../../perseus-all-package/components/graphie.jsx")
var Plot=Graphie.Plot
var kpoint=require("kmath").point
var DEFAULT_BACKGROUND_IMAGE={url:null}
function canonicalSineCoefficients(t){var e=t[0]
var r=t[1]
var n=t[2]
var a=t[3]
if(e<0){e*=-1
r*=-1
n*=-1}var o=2*Math.PI
if(r<0){r*=-1
n*=-1
n+=o/2}while(n>0){n-=o}while(n<0){n+=o}return[e,r,n,a]}function canonicalTangentCoefficients(t){var e=t[0]
var r=t[1]
var n=t[2]
var a=t[3]
if(e<0){e*=-1
r*=-1
n*=-1}var o=Math.PI
if(r<0){r*=-1
n*=-1
n+=o/2}while(n>0){n-=o}while(n<0){n+=o}return[e,r,n,a]}var PlotDefaults={areEqual:function t(e,r){return Util.deepEq(e,r)},Movable:Plot,getPropsForCoeffs:function t(e){return{fn:_.partial(this.getFunctionForCoeffs,e)}}}
var Linear=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/67aaf581e6d9ef9038c10558a1f70ac21c11c9f8.png",defaultCoords:[[.25,.75],[.75,.75]],getCoefficients:function t(e){var r=e[0]
var n=e[1]
var a=n[0]-r[0]
var o=n[1]-r[1]
if(a===0){return}var i=o/a
var u=n[1]-i*n[0]
return[i,u]},getFunctionForCoeffs:function t(e,r){var n=e[0],a=e[1]
return n*r+a},getEquationString:function t(e){var r=this.getCoefficients(e)
var n=r[0],a=r[1]
return"y = "+n.toFixed(3)+"x + "+a.toFixed(3)}})
var Quadratic=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/e23d36e6fc29ee37174e92c9daba2a66677128ab.png",defaultCoords:[[.5,.5],[.75,.75]],Movable:Graphie.Parabola,getCoefficients:function t(e){var r=e[0]
var n=e[1]
var a=r[0]
var o=r[1]
var i=(n[1]-o)/((n[0]-a)*(n[0]-a))
var u=-2*a*i
var f=i*a*a+o
return[i,u,f]},getFunctionForCoeffs:function t(e,r){var n=e[0],a=e[1],o=e[2]
return(n*r+a)*r+o},getPropsForCoeffs:function t(e){return{a:e[0],b:e[1],c:e[2]}},getEquationString:function t(e){var r=this.getCoefficients(e)
var n=r[0],a=r[1],o=r[2]
return"y = "+n.toFixed(3)+"x^2 + "+a.toFixed(3)+"x + "+o.toFixed(3)}})
var Sinusoid=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/3d68e7718498475f53b206c2ab285626baf8857e.png",defaultCoords:[[.5,.5],[.6,.6]],Movable:Graphie.Sinusoid,getCoefficients:function t(e){var r=e[0]
var n=e[1]
var a=n[1]-r[1]
var o=Math.PI/(2*(n[0]-r[0]))
var i=r[0]*o
var u=r[1]
return[a,o,i,u]},getFunctionForCoeffs:function t(e,r){var n=e[0],a=e[1],o=e[2],i=e[3]
return n*Math.sin(a*r-o)+i},getPropsForCoeffs:function t(e){return{a:e[0],b:e[1],c:e[2],d:e[3]}},getEquationString:function t(e){var r=this.getCoefficients(e)
var n=r[0],a=r[1],o=r[2],i=r[3]
return"y = "+n.toFixed(3)+" sin("+a.toFixed(3)+"x - "+o.toFixed(3)+") + "+i.toFixed(3)},areEqual:function t(e,r){return Util.deepEq(canonicalSineCoefficients(e),canonicalSineCoefficients(r))}})
var Tangent=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/7db80d23c35214f98659fe1cf0765811c1bbfbba.png",defaultCoords:[[.5,.5],[.75,.75]],getCoefficients:function t(e){var r=e[0]
var n=e[1]
var a=n[1]-r[1]
var o=Math.PI/(4*(n[0]-r[0]))
var i=r[0]*o
var u=r[1]
return[a,o,i,u]},getFunctionForCoeffs:function t(e,r){var n=e[0],a=e[1],o=e[2],i=e[3]
return n*Math.tan(a*r-o)+i},getEquationString:function t(e){var r=this.getCoefficients(e)
var n=r[0],a=r[1],o=r[2],i=r[3]
return"y = "+n.toFixed(3)+" sin("+a.toFixed(3)+"x - "+o.toFixed(3)+") + "+i.toFixed(3)},areEqual:function t(e,r){return Util.deepEq(canonicalTangentCoefficients(e),canonicalTangentCoefficients(r))}})
var Exponential=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/9cbfad55525e3ce755a31a631b074670a5dad611.png",defaultCoords:[[.5,.55],[.75,.75]],defaultAsymptote:[[0,.5],[1,.5]],extraCoordConstraint:function t(e,r,n,a,o){var i=_.head(a)[1]
return _.all(n,function(t){return t[1]!==i})},extraAsymptoteConstraint:function t(e,r,n,a,o){var i=e[1]
var u=_.all(n,function(t){return t[1]>i})||_.all(n,function(t){return t[1]<i})
if(u){return[r[0],i]}else{var f=r[1]
var s=_.all(n,function(t){return t[1]>f})
if(s){var l=_.min(_.map(n,function(t){return t[1]}))
return[r[0],l-o.snapStep[1]]}else{var c=_.max(_.map(n,function(t){return t[1]}))
return[r[0],c+o.snapStep[1]]}}},allowReflectOverAsymptote:true,getCoefficients:function t(e,r){var n=e[0]
var a=e[1]
var o=_.head(r)[1]
var i=Math.log((n[1]-o)/(a[1]-o))/(n[0]-a[0])
var u=(n[1]-o)/Math.exp(i*n[0])
return[u,i,o]},getFunctionForCoeffs:function t(e,r){var n=e[0],a=e[1],o=e[2]
return n*Math.exp(a*r)+o},getEquationString:function t(e,r){if(!r){return null}var n=this.getCoefficients(e,r)
var a=n[0],o=n[1],i=n[2]
return"y = "+a.toFixed(3)+"e^("+o.toFixed(3)+"x) + "+i.toFixed(3)}})
var Logarithm=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/f6491e99d34af34d924bfe0231728ad912068dc3.png",defaultCoords:[[.55,.5],[.75,.75]],defaultAsymptote:[[.5,0],[.5,1]],extraCoordConstraint:function t(e,r,n,a,o){var i=_.head(a)[0]
return _.all(n,function(t){return t[0]!==i})&&n[0][1]!==n[1][1]},extraAsymptoteConstraint:function t(e,r,n,a,o){var i=e[0]
var u=_.all(n,function(t){return t[0]>i})||_.all(n,function(t){return t[0]<i})
if(u){return[i,r[1]]}else{var f=r[0]
var s=_.all(n,function(t){return t[0]>f})
if(s){var l=_.min(_.map(n,function(t){return t[0]}))
return[l-o.snapStep[0],r[1]]}else{var c=_.max(_.map(n,function(t){return t[0]}))
return[c+o.snapStep[0],r[1]]}}},allowReflectOverAsymptote:true,getCoefficients:function t(e,r){var n=function t(e){return[e[1],e[0]]}
var a=Exponential.getCoefficients(_.map(e,n),_.map(r,n))
var o=-a[2]/a[0]
var i=1/a[0]
var u=1/a[1]
return[u,i,o]},getFunctionForCoeffs:function t(e,r,n){var a=e[0],o=e[1],i=e[2]
return a*Math.log(o*r+i)},getEquationString:function t(e,r){if(!r){return null}var n=this.getCoefficients(e,r)
var a=n[0],o=n[1],i=n[2]
return"y = ln("+a.toFixed(3)+"x + "+o.toFixed(3)+") + "+i.toFixed(3)}})
var AbsoluteValue=_.extend({},PlotDefaults,{url:"https://ka-perseus-graphie.s3.amazonaws.com/8256a630175a0cb1d11de223d6de0266daf98721.png",defaultCoords:[[.5,.5],[.75,.75]],getCoefficients:function t(e){var r=e[0]
var n=e[1]
var a=n[0]-r[0]
var o=n[1]-r[1]
if(a===0){return}var i=Math.abs(o/a)
if(n[1]<r[1]){i*=-1}var u=r[0]
var f=r[1]
return[i,u,f]},getFunctionForCoeffs:function t(e,r){var n=e[0],a=e[1],o=e[2]
return n*Math.abs(r-a)+o},getEquationString:function t(e){var r=this.getCoefficients(e)
var n=r[0],a=r[1],o=r[2]
return"y = "+n.toFixed(3)+"| x - "+a.toFixed(3)+"| + "+o.toFixed(3)}})
var functionTypeMapping={linear:Linear,quadratic:Quadratic,sinusoid:Sinusoid,tangent:Tangent,exponential:Exponential,logarithm:Logarithm,absolute_value:AbsoluteValue}
var allTypes=_.keys(functionTypeMapping)
function functionForType(t){return functionTypeMapping[t]}var GrapherUtil={validate:function t(e,r){if(e.type!==r.correct.type){return{type:"points",earned:0,total:1,message:null}}if(e.coords==null){return{type:"invalid",message:null}}var n=functionForType(e.type)
var a=n.getCoefficients(e.coords,e.asymptote)
var o=n.getCoefficients(r.correct.coords,r.correct.asymptote)
if(a==null||o==null){return{type:"invalid",message:null}}else if(n.areEqual(a,o)){return{type:"points",earned:1,total:1,message:null}}else{return{type:"points",earned:0,total:1,message:null}}},getEquationString:function t(e){var r=e.plot
if(r.type&&r.coords){var n=functionForType(r.type)
var a=n.getEquationString(r.coords,r.asymptote)
return a||""}else{return""}},pointsFromNormalized:function t(e,r,n,a){var o=function t(e,r){return Math.floor((e[1]-e[0])/r)}
return _.map(e,function(t){var e=_.map(t,function(t,e){var a=r[e]
var i=n[e]
var u=o(a,i)
var f=Math.round(t*u)
return a[0]+i*f})
return kpoint.roundTo(e,a)})},maybePointsFromNormalized:function t(e,r,n,a){if(e){return this.pointsFromNormalized(e,r,n,a)}else{return e}},defaultPlotProps:function t(e,r){var n=functionForType(e)
var a=[1,1]
var o=Util.snapStepFromGridStep(a)
return{type:e,asymptote:this.maybePointsFromNormalized(n.defaultAsymptote,r.range,r.step,o),coords:null}},chooseType:_.first,getGridAndSnapSteps:function t(e,r){var n=e.gridStep||Util.getGridStep(e.range,e.step,r)
var a=e.snapStep||Util.snapStepFromGridStep(n)
return{gridStep:n,snapStep:a}}}
var DEFAULT_GRAPHER_PROPS={}
DEFAULT_GRAPHER_PROPS.graph={labels:["x","y"],range:[[-10,10],[-10,10]],step:[1,1],backgroundImage:DEFAULT_BACKGROUND_IMAGE,markings:"graph",rulerLabel:"",rulerTicks:10,valid:true,showTooltips:false}
DEFAULT_GRAPHER_PROPS.plot=GrapherUtil.defaultPlotProps("linear",DEFAULT_GRAPHER_PROPS.graph)
DEFAULT_GRAPHER_PROPS.availableTypes=[DEFAULT_GRAPHER_PROPS.plot.type]
function typeToButton(t){var e=t.charAt(0).toUpperCase()+t.substring(1)
return{value:t,title:e,content:React.createElement("img",{src:functionForType(t).url,alt:e})}}module.exports={GrapherUtil:GrapherUtil,allTypes:allTypes,typeToButton:typeToButton,functionForType:functionForType,DEFAULT_GRAPHER_PROPS:DEFAULT_GRAPHER_PROPS,DEFAULT_BACKGROUND_IMAGE:DEFAULT_BACKGROUND_IMAGE}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/graded-group-answer-bar.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var i18n=require("../../shared-package/i18n.js")
var ApiOptions=require("../../perseus-all-package/perseus-api.jsx").Options
var InlineIcon=require("../../perseus-all-package/components/inline-icon.jsx")
var _require=require("../../perseus-all-package/icon-paths.js"),iconStar=_require.iconStar,iconTryAgain=_require.iconTryAgain
var _require2=require("../../perseus-all-package/styles/constants.js"),boldFontFamily=_require2.boldFontFamily,gray68=_require2.gray68,gray76=_require2.gray76,gray85=_require2.gray85,gray95=_require2.gray95,kaGreen=_require2.kaGreen,phoneMargin=_require2.phoneMargin,negativePhoneMargin=_require2.negativePhoneMargin
var ANSWER_BAR_STATES={HIDDEN:Symbol("HIDDEN"),ACTIVE:Symbol("ACTIVE"),INACTIVE:Symbol("INACTIVE"),INCORRECT:Symbol("INCORRECT"),CORRECT:Symbol("CORRECT")}
var GradedGroupAnswerBar=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this.props,n=r.apiOptions,a=r.answerBarState,t=r.onCheckAnswer,i=r.onNextQuestion
var o=babelHelpers.extends({},styles.answerBar,{backgroundColor:a===ANSWER_BAR_STATES.CORRECT?gray95:"white",justifyContent:a===ANSWER_BAR_STATES.CORRECT&&!i?"center":"space-between"})
var s=babelHelpers.extends({},styles.button,{backgroundColor:a===ANSWER_BAR_STATES.ACTIVE||a===ANSWER_BAR_STATES.CORRECT?kaGreen:gray85})
var l=babelHelpers.extends({},styles.text,{color:a===ANSWER_BAR_STATES.CORRECT?kaGreen:gray68})
var p=a===ANSWER_BAR_STATES.INCORRECT?React.createElement("span",{style:l},React.createElement("span",{style:styles.tryAgainIcon},React.createElement(InlineIcon,iconTryAgain)),React.createElement("span",{style:{marginLeft:8}},i18n._("Keep trying"))):React.createElement("span",null)
if(a!==ANSWER_BAR_STATES.CORRECT){var c=a===ANSWER_BAR_STATES.INCORRECT?i18n._("Try again"):i18n._("Check")
return React.createElement("div",{style:o},p,React.createElement("button",{style:s,disabled:n.readOnly||a!==ANSWER_BAR_STATES.ACTIVE,onClick:t},c))}else{return React.createElement("div",{style:o},React.createElement("span",{style:l},React.createElement("span",{style:{fontSize:28,color:"#FFB300"}},React.createElement(InlineIcon,babelHelpers.extends({},iconStar,{style:{marginBottom:5}}))),React.createElement("span",{style:{marginLeft:8}},i18n._("Correct!"))),i&&React.createElement("button",{style:s,onClick:i},i18n._("Next question")))}}
return r}(React.Component)
GradedGroupAnswerBar.propTypes={answerBarState:PropTypes.any.isRequired,apiOptions:ApiOptions.propTypes,onCheckAnswer:PropTypes.func.isRequired,onNextQuestion:PropTypes.func}
var fontSize=17
var styles={answerBar:{display:"flex",alignItems:"center",height:68,marginLeft:negativePhoneMargin,marginRight:negativePhoneMargin,marginBottom:negativePhoneMargin,marginTop:phoneMargin,paddingLeft:phoneMargin,paddingRight:10,borderTop:"1px solid "+gray76},button:{height:48,width:143,borderRadius:4,color:"white",fontFamily:boldFontFamily,fontSize:fontSize,border:"none"},tryAgainIcon:{fontSize:28,color:"#63D9EA",transform:"scale(-1,1) rotate(-268deg)"},text:{display:"flex",flexDirection:"row",alignItems:"center",fontFamily:boldFontFamily,fontSize:fontSize}}
GradedGroupAnswerBar.ANSWER_BAR_STATES=ANSWER_BAR_STATES
module.exports=GradedGroupAnswerBar

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/interaction/arrow-picker.jsx", function(require, module, exports) {
var ButtonGroup=require("../../../react-components-package/button-group.jsx")
var React=require("react")
var _require=require("../../../perseus-all-package/mixins/changeable.jsx"),ChangeableProps=_require.ChangeableProps
var ArrowPicker=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){return React.createElement(ButtonGroup,{value:this.props.value,allowEmpty:false,buttons:[{value:"",content:React.createElement("span",null,"—")},{value:"->",content:React.createElement("span",null,"→")}],onChange:this.props.onChange})}
return r}(React.Component)
ArrowPicker.defaultProps={value:""}
module.exports=ArrowPicker

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/interaction/color-picker.jsx", function(require, module, exports) {
var ButtonGroup=require("../../../react-components-package/button-group.jsx")
var React=require("react")
var _=require("underscore")
var _require=require("../../../perseus-all-package/mixins/changeable.jsx"),ChangeableProps=_require.ChangeableProps
var KhanColors=require("../../../perseus-all-package/util/colors.js")
var COLORS=[KhanColors.BLACK,KhanColors.BLUE,KhanColors.GREEN,KhanColors.PINK,KhanColors.PURPLE,KhanColors.RED,KhanColors.GRAY]
var LIGHT_COLORS=[KhanColors.LIGHT_BLUE,KhanColors.LIGHT_ORANGE,KhanColors.LIGHT_PINK,KhanColors.LIGHT_GREEN,KhanColors.LIGHT_PURPLE,KhanColors.LIGHT_RED,"#fff"]
var ColorPicker=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this.props.lightColors?LIGHT_COLORS:COLORS
return React.createElement(ButtonGroup,{value:this.props.value,allowEmpty:false,buttons:_.map(r,function(e){return{value:e,content:React.createElement("span",null,React.createElement("span",{className:"colorpicker-circle",style:{background:e}})," ")}}),onChange:this.props.onChange})}
return r}(React.Component)
ColorPicker.defaultProps={value:KhanColors.BLACK,lightColors:false}
module.exports=ColorPicker

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/interaction/dash-picker.jsx", function(require, module, exports) {
var ButtonGroup=require("../../../react-components-package/button-group.jsx")
var React=require("react")
var _require=require("../../../perseus-all-package/mixins/changeable.jsx"),ChangeableProps=_require.ChangeableProps
var DashPicker=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){return React.createElement(ButtonGroup,{value:this.props.value,allowEmpty:false,buttons:[{value:"",content:React.createElement("span",null,"—")},{value:"-",content:React.createElement("span",null,"–––")},{value:"- ",content:React.createElement("span",null,"–  –")},{value:".",content:React.createElement("span",null,"····")},{value:". ",content:React.createElement("span",null,"· · ·")}],onChange:this.props.onChange})}
return t}(React.Component)
DashPicker.defaultProps={value:""}
module.exports=DashPicker

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/interaction/element-container.jsx", function(require, module, exports) {
var React=require("react")
var _require=require("../../../perseus-all-package/icon-paths.js"),iconChevronDown=_require.iconChevronDown,iconChevronRight=_require.iconChevronRight,iconCircleArrowDown=_require.iconCircleArrowDown,iconCircleArrowUp=_require.iconCircleArrowUp,iconTrash=_require.iconTrash
var InlineIcon=require("../../../perseus-all-package/components/inline-icon.jsx")
var ElementContainer=function(e){babelHelpers.inherits(n,e)
function n(t){babelHelpers.classCallCheck(this,n)
var r=babelHelpers.possibleConstructorReturn(this,e.call(this,t))
r.toggle=function(e){e.preventDefault()
r.setState({show:!r.state.show})}
r.state={show:t.initiallyVisible}
return r}n.prototype.render=function e(){return React.createElement("div",{className:"perseus-interaction-element"},React.createElement("a",{href:"#",className:"perseus-interaction-element-title "+(this.state.show?"open":"closed"),onClick:this.toggle},this.state.show?React.createElement(InlineIcon,iconChevronDown):React.createElement(InlineIcon,iconChevronRight),this.props.title),React.createElement("div",{className:"perseus-interaction-element-content "+(this.state.show?"enter":"leave")},this.props.children,(this.props.onUp!=null||this.props.onDown!=null||this.props.onDelete!=null)&&React.createElement("div",{className:"edit-controls"},this.props.onUp!=null&&React.createElement("button",{onClick:this.props.onUp},React.createElement(InlineIcon,iconCircleArrowUp)),this.props.onDown!=null&&React.createElement("button",{onClick:this.props.onDown},React.createElement(InlineIcon,iconCircleArrowDown)),this.props.onDelete!=null&&React.createElement("button",{onClick:this.props.onDelete},React.createElement(InlineIcon,iconTrash)))))}
return n}(React.Component)
ElementContainer.defaultProps={initiallyVisible:false,title:"More"}
module.exports=ElementContainer

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/label-image.jsx", function(require, module, exports) {
var _scrollableChoices
var _aphrodite=require("aphrodite")
var _classnames=require("classnames")
var _classnames2=babelHelpers.interopRequireDefault(_classnames)
var _react=require("react")
var _react2=babelHelpers.interopRequireDefault(_react)
var _reactDom=require("react-dom")
var _reactDom2=babelHelpers.interopRequireDefault(_reactDom)
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var _mediaQueries=require("../../shared-styles-package/media-queries.js")
var _mediaQueries2=babelHelpers.interopRequireDefault(_mediaQueries)
var _newTooltip=require("../../components/new-tooltip-package/new-tooltip.jsx")
var _newTooltip2=babelHelpers.interopRequireDefault(_newTooltip)
var _renderer=require("../../perseus-all-package/renderer.jsx")
var _renderer2=babelHelpers.interopRequireDefault(_renderer)
var _svgImage=require("../../perseus-all-package/components/svg-image.jsx")
var _svgImage2=babelHelpers.interopRequireDefault(_svgImage)
var _answerChoices=require("./label-image/answer-choices.jsx")
var _answerChoices2=babelHelpers.interopRequireDefault(_answerChoices)
var _marker=require("./label-image/marker.jsx")
var _marker2=babelHelpers.interopRequireDefault(_marker)
var i18n=require("../../shared-package/i18n.js")
var LabelImage=function(e){babelHelpers.inherits(r,e)
r.gradeMarker=function e(r){var t={hasAnswers:false,isCorrect:false}
if(r.selected&&r.selected.length>0){t.hasAnswers=true}if(r.answers.length>0){if(r.selected&&r.selected.length===r.answers.length){t.isCorrect=r.selected.every(function(e){return r.answers.includes(e)})}}else if(!r.selected||r.selected.length===0){t.isCorrect=true}return t}
r.validate=function e(t,a){var s=0
var n=0
for(var i=t.markers,o=Array.isArray(i),l=0,i=o?i:i[Symbol.iterator]();;){var c
if(o){if(l>=i.length)break
c=i[l++]}else{l=i.next()
if(l.done)break
c=l.value}var d=c
var u=r.gradeMarker(d)
if(u.hasAnswers){s++}if(u.isCorrect){n++}}if(s!==t.markers.length){return{type:"invalid",message:null}}return{type:"points",earned:n===t.markers.length?1:0,total:1,message:null}}
r.pointInTriangle=function e(r,t,a,s){var n=function e(r,t,a){return(r.x-a.x)*(t.y-a.y)-(t.x-a.x)*(r.y-a.y)}
var i=n(r,t,a)<0
var o=n(r,a,s)<0
var l=n(r,s,t)<0
return i===o&&o===l}
r.imageSideForMarkerPosition=function e(t,a){if(t<20){return"left"}else if(t>80){return"right"}var s={x:20,y:0}
var n={x:80,y:0}
var i={x:80,y:100}
var o={x:20,y:100}
var l={x:50,y:50}
var c={top:[s,n,l],right:[l,n,i],bottom:[o,l,i],left:[s,l,o]}
var d={x:t,y:a}
for(var u=Object.keys(c),p=Array.isArray(u),h=0,u=p?u:u[Symbol.iterator]();;){var m
if(p){if(h>=u.length)break
m=u[h++]}else{h=u.next()
if(h.done)break
m=h.value}var f=m
var v=c[f]
if(r.pointInTriangle.apply(r,[d].concat(v))){return f}}return"center"}
r.navigateToMarkerIndex=function e(r,t,a){var s=t[a]
var n=t.map(function(e,r){var t=e.x-s.x
var a=e.y-s.y
var n=Math.sqrt(Math.pow(t,2)+Math.pow(a,2))
return{index:r,dist:n,dir:{x:n!==0?t/n:0,y:n!==0?a/n:0}}}).filter(function(e){if(e.index===a){return false}return t[e.index].showCorrectness!=="correct"}).sort(function(e,t){var a=Math.round(e.dist*(r.x*e.dir.x+r.y*e.dir.y))
var s=Math.round(t.dist*(r.x*t.dir.x+r.y*t.dir.y))
var n=void 0
var i=void 0
if(r.x>0){n=e.dir.x>0&&a!==0
i=t.dir.x>0&&s!==0}else if(r.x<0){n=e.dir.x<0&&a!==0
i=t.dir.x<0&&s!==0}else if(r.y>0){n=e.dir.y>0&&a!==0
i=t.dir.y>0&&s!==0}else if(r.y<0){n=e.dir.y<0&&a!==0
i=t.dir.y<0&&s!==0}if(n!==i){if(n){return-1}else{return 1}}return a-s})
return n.length>0?n[0].index:a}
function r(t){babelHelpers.classCallCheck(this,r)
var a=babelHelpers.possibleConstructorReturn(this,e.call(this,t))
a.handleDocumentClick=function(e){if(a._selectedMarkerPopup&&a._answerChoices){var r=_reactDom2.default.findDOMNode(a._answerChoices)
var t=e.target
var s=function e(r){var a=arguments.length>1&&arguments[1]!==undefined?arguments[1]:3
return r&&(r.contains(t)||a>0&&e(r.parentElement,a-1))}
if(!s(r)){a.dismissMarkerPopup()}}}
a.handleDocumentKeyDown=function(e){if(a._selectedMarkerPopup&&e.keyCode===27){e.stopPropagation()
a.dismissMarkerPopup()}}
a._markers=[]
a.state={selectedMarkerIndex:-1,markersInteracted:false}
return a}r.prototype.componentDidMount=function e(){document.addEventListener("click",this.handleDocumentClick,true)
document.addEventListener("keydown",this.handleDocumentKeyDown,true)}
r.prototype.componentWillUnmount=function e(){document.removeEventListener("click",this.handleDocumentClick,true)
document.removeEventListener("keydown",this.handleDocumentKeyDown,true)}
r.prototype.simpleValidate=function e(t){return r.validate(this.getUserInput(),t)}
r.prototype.getUserInput=function e(){var r=this.props.markers
return{markers:r}}
r.prototype.showRationalesForCurrentlySelectedChoices=function e(t){var a=this.props,s=a.markers,n=a.onChange
var i=s.map(function(e){var t=r.gradeMarker(e)
return babelHelpers.extends({},e,{showCorrectness:t.hasAnswers?t.isCorrect?"correct":"incorrect":undefined})})
n({markers:i},null,true)}
r.prototype.dismissMarkerPopup=function e(){var r=this
var t=this.state.selectedMarkerIndex
if(t===-1){return}this.setState({selectedMarkerIndex:-1},function(){var e=r._markers[t]
if(e){_reactDom2.default.findDOMNode(e).focus()}})}
r.prototype.handleMarkerChange=function e(r,t){var a=this.props,s=a.markers,n=a.onChange
var i=[].concat(s.slice(0,r),[babelHelpers.extends({},t,{showCorrectness:undefined})],s.slice(r+1))
n({markers:i})}
r.prototype.handleMarkerClick=function e(r,t){var a=this
var s=this.state.selectedMarkerIndex
t.preventDefault()
if(s!==r){this.setState({selectedMarkerIndex:r,markersInteracted:true},function(){setTimeout(function(){if(a._answerChoices){a._answerChoices.focusAnswer()}},100)})}else{this.dismissMarkerPopup()}}
r.prototype.handleMarkerKeyDown=function e(t,a){var s=this.props.markers
if(s.length<2){return}var n={ArrowUp:{x:0,y:-1},ArrowRight:{x:1,y:0},ArrowDown:{x:0,y:1},ArrowLeft:{x:-1,y:0}}[a.key]
if(!n){return}a.preventDefault()
var i=this._markers[r.navigateToMarkerIndex(n,s,t)]
if(i){_reactDom2.default.findDOMNode(i).focus()}}
r.prototype.handleAnswerChoicesChangeForMarker=function e(r,t){var a=this.props,s=a.choices,n=a.markers
var i=s.filter(function(e,r){return t[r]})
this.handleMarkerChange(r,babelHelpers.extends({},n[r],{selected:i}))}
r.prototype.renderAnswerChoicesForMarker=function e(r,t){var a=this
var s=this.props,n=s.choices,i=s.multipleAnswers
var o=t.selected
return _react2.default.createElement("div",{className:(0,_classnames2.default)("perseus-label-image-widget-answer-choices",(0,_aphrodite.css)(styles.scrollableChoices))},_react2.default.createElement(_answerChoices2.default,{choices:n.map(function(e){return{content:e,checked:o?o.includes(e):false}}),multipleSelect:i,onChange:function e(t){return a.handleAnswerChoicesChangeForMarker(r,t)},ref:function e(r){return a._answerChoices=r}}))}
r.prototype.renderMarkers=function e(){var t=this
var a=this.props,s=a.markers,n=a.questionCompleted
var i=this.state,o=i.selectedMarkerIndex,l=i.markersInteracted
return s.map(function(e,a){var s=r.gradeMarker(e)
var i=_react2.default.createElement(_marker2.default,babelHelpers.extends({},e,{showCorrectness:n&&s.hasAnswers&&s.isCorrect?"correct":e.showCorrectness,showSelected:a===o,showPulsate:!l,key:e.x+"."+e.y,onClick:function e(r){return t.handleMarkerClick(a,r)},onKeyDown:function e(r){return t.handleMarkerKeyDown(a,r)},ref:function e(r){return t._markers[a]=r}}))
if(a!==o){return i}var c=window.matchMedia(_mediaQueries2.default.xsOrSmaller.replace("@media ","")).matches
var d=void 0
if(c){d=e.y>50?"top":"bottom"}else{d={left:"right",top:"bottom",right:"left",bottom:"top",center:"top"}[r.imageSideForMarkerPosition(e.x,e.y)]}return _react2.default.createElement(_newTooltip2.default,{content:t.renderAnswerChoicesForMarker(a,e),noPadding:true,side:d,offset:5,offsetFrom:"arrow",showOnMount:true,key:e.x+"."+e.y,ref:function e(r){return t._selectedMarkerPopup=r}},i)})}
r.prototype.renderInstructions=function e(){var r=this.props,t=r.apiOptions.isMobile,a=r.choices,s=r.multipleAnswers,n=r.hideChoicesFromInstructions
var i=t?s?i18n._("Tap each dot on the image to select all answers that apply."):i18n._("Tap each dot on the image to select an answer."):s?i18n._("Click each dot on the image to select all answers that apply."):i18n._("Click each dot on the image to select an answer.")
var o=i18n._("Choices:")
return _react2.default.createElement("div",{className:(0,_classnames2.default)("perseus-label-image-widget-instructions",(0,_aphrodite.css)(styles.instructions))},_react2.default.createElement("div",{className:(0,_aphrodite.css)(styles.instructionsCaption)},i," ",!n&&o),!n&&_react2.default.createElement("div",{className:(0,_aphrodite.css)(styles.instructionsChoices)},a.map(function(e,r){return _react2.default.createElement("div",{className:(0,_aphrodite.css)(styles.instructionsChoice),key:r},_react2.default.createElement(_renderer2.default,{content:e}))})))}
r.prototype.render=function e(){var r=this.props,t=r.imageAlt,a=r.imageUrl,s=r.imageWidth,n=r.imageHeight
var i=this.state.selectedMarkerIndex
return _react2.default.createElement("div",null,this.renderInstructions(),_react2.default.createElement("div",{className:(0,_aphrodite.css)(styles.markersCanvas),style:{maxWidth:s,maxHeight:n}},_react2.default.createElement("div",{className:(0,_aphrodite.css)(styles.imageContainer,i!==-1&&styles.imageInteractionDisabled)},_react2.default.createElement(_svgImage2.default,{alt:t,src:a,width:s,height:n})),this.renderMarkers()))}
return r}(_react2.default.Component)
var styles=_aphrodite.StyleSheet.create({instructions:{paddingBottom:16},instructionsCaption:babelHelpers.extends({},_globalStyles.typography.bodyXsmallBold,{paddingBottom:16}),instructionsChoices:{display:"flex",flexWrap:"wrap",margin:"-8px 0"},instructionsChoice:{display:"flex",alignItems:"center",margin:"8px 0",":not(:last-child)":{"::after":{content:"''",display:"inline-block",position:"relative",width:2,height:2,marginLeft:5,marginRight:5,background:"rgba(33, 36, 44, 0.32)",borderRadius:2}}},markersCanvas:{position:"relative"},imageContainer:{display:"flex"},imageInteractionDisabled:{pointerEvents:"none"},scrollableChoices:(_scrollableChoices={paddingTop:8,paddingBottom:8},_scrollableChoices[_mediaQueries2.default.xsOrSmaller]={maxHeight:250,overflowY:"auto"},_scrollableChoices),smallSpacer:{height:16},hide:{display:"none"}})
module.exports={name:"label-image",displayName:"Label Image",widget:LabelImage,accessible:true,isLintable:true}

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/label-image/answer-choices.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _aphrodite=require("aphrodite")
var _react=require("react")
var _react2=babelHelpers.interopRequireDefault(_react)
var _underscore=require("underscore")
var _underscore2=babelHelpers.interopRequireDefault(_underscore)
var _globalStyles=require("../../../shared-styles-package/global-styles.js")
var _icon=require("../../../shared-styles-package/icon.jsx")
var _icon2=babelHelpers.interopRequireDefault(_icon)
var _shared=require("../../../perseus-all-package/styles/shared.js")
var _shared2=babelHelpers.interopRequireDefault(_shared)
var _iconPaths=require("../../../perseus-all-package/icon-paths.js")
var _renderer=require("../../../perseus-all-package/renderer.jsx")
var _renderer2=babelHelpers.interopRequireDefault(_renderer)
var AnswerChoice=function(e){babelHelpers.inherits(r,e)
function r(){var t,n,a
babelHelpers.classCallCheck(this,r)
for(var s=arguments.length,o=Array(s),c=0;c<s;c++){o[c]=arguments[c]}return a=(t=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),n),n.state={isInputFocused:false},t),babelHelpers.possibleConstructorReturn(n,a)}r.prototype.focusInput=function e(){if(this._input){this._input.focus()}}
r.prototype.handleClick=function e(r){var t=this.props,n=t.checked,a=t.onChange
r.preventDefault()
this.focusInput()
a(!n)}
r.prototype.handleKeyDown=function e(r){var t=this.props,n=t.onFocusPrevAnswer,a=t.onFocusNextAnswer
switch(r.key){case"ArrowUp":r.preventDefault()
n()
break
case"ArrowDown":r.preventDefault()
a()
break}}
r.prototype.handleInputChange=function e(r){r.preventDefault()}
r.prototype.handleInputFocus=function e(){this.setState({isInputFocused:true})}
r.prototype.handleInputBlur=function e(){this.setState({isInputFocused:false})}
r.prototype.renderCheckmark=function e(){var r=this.props.checked
return _react2.default.createElement("span",{className:(0,_aphrodite.css)(styles.checkmarkContainer)},r&&_react2.default.createElement(_icon2.default,{icon:_iconPaths.iconCheckMedium,size:16,color:_globalStyles.colors.gray17}))}
r.prototype.render=function e(){var r=this
var t=this.props,n=t.content,a=t.checked,s=t.groupName,o=t.index,c=t.inputType
var u=this.state.isInputFocused
var i=s+"-"+o
return _react2.default.createElement("div",{className:(0,_aphrodite.css)(styles.answerChoice,u&&styles.answerFocused),onClick:function e(t){return r.handleClick(t)},onKeyDown:function e(t){return r.handleKeyDown(t)}},_react2.default.createElement("span",{className:(0,_aphrodite.css)(styles.answerInputWrapper)},_react2.default.createElement("input",{className:(0,_aphrodite.css)(_shared2.default.perseusSrOnly),checked:a,name:s,id:i,type:c,onChange:function e(t){return r.handleInputChange(t)},onFocus:function e(){return r.handleInputFocus()},onBlur:function e(){return r.handleInputBlur()},ref:function e(t){return r._input=t}}),this.renderCheckmark()),_react2.default.createElement("label",{htmlFor:i},_react2.default.createElement(_renderer2.default,{content:n})))}
return r}(_react2.default.Component)
var AnswerChoices=function(e){babelHelpers.inherits(r,e)
function r(t){babelHelpers.classCallCheck(this,r)
var n=babelHelpers.possibleConstructorReturn(this,e.call(this,t))
n._choices=[]
n.state={groupName:_underscore2.default.uniqueId("answer_choices_")}
return n}r.prototype.focusAnswer=function e(){var r=arguments.length>0&&arguments[0]!==undefined?arguments[0]:0
var t=this.props.choices.length
if(r<0){r+=t}else if(r>=t){r-=t}var n=this._choices[r]
if(n){n.focusInput()}}
r.prototype.onAnswerChange=function e(r,t){var n=this.props,a=n.choices,s=n.multipleSelect,o=n.onChange
var c=[]
for(var u=0;u<a.length;u++){c.push(s?u===r?t:a[u].checked:u===r?t:false)}o(c)}
r.prototype.onFocusAnswer=function e(r){this.focusAnswer(r)}
r.prototype.render=function e(){var r=this
var t=this.props,n=t.choices,a=t.multipleSelect
var s=this.state.groupName
return _react2.default.createElement("fieldset",null,n.map(function(e,t){return _react2.default.createElement(AnswerChoice,babelHelpers.extends({},e,{key:e.content,groupName:s,index:t,inputType:a?"checkbox":"radio",onChange:function e(n){return r.onAnswerChange(t,n)},onFocusPrevAnswer:function e(){return r.onFocusAnswer(t-1)},onFocusNextAnswer:function e(){return r.onFocusAnswer(t+1)},ref:function e(n){return r._choices[t]=n}}))}))}
return r}(_react2.default.Component)
exports.default=AnswerChoices
var styles=_aphrodite.StyleSheet.create({answerChoice:{display:"flex",alignItems:"center",userSelect:"none",padding:"10px 16px 10px 0px",border:"solid 2px transparent",borderRadius:2,":active":{backgroundColor:"rgba(33, 36, 44, 0.08)"}},answerFocused:{borderColor:"#1865f2",":active":{borderColor:"transparent"}},answerInputWrapper:{marginRight:8},checkmarkContainer:{display:"flex",position:"relative",width:16,height:16,marginLeft:8}})

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/label-image/marker.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _aphrodite=require("aphrodite")
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _globalStyles=require("../../../shared-styles-package/global-styles.js")
var _icon=require("../../../shared-styles-package/icon.jsx")
var _icon2=babelHelpers.interopRequireDefault(_icon)
var _iconPaths=require("../../../perseus-all-package/icon-paths.js")
var Marker=function(e){babelHelpers.inherits(r,e)
function r(){var o,t,a
babelHelpers.classCallCheck(this,r)
for(var n=arguments.length,i=Array(n),l=0;l<n;l++){i[l]=arguments[l]}return a=(o=(t=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),t),t.state={isFocused:false},o),babelHelpers.possibleConstructorReturn(t,a)}r.prototype.handleFocus=function e(){this.setState({isFocused:true})}
r.prototype.handleBlur=function e(){this.setState({isFocused:false})}
r.prototype.renderIcon=function e(){var r=this
var o=this.props,t=o.selected,a=o.showCorrectness,n=o.showSelected,i=o.showPulsate
var l=this.state.isFocused
var s=n||l
var c=void 0
var d=void 0
if(a){c=React.createElement(_icon2.default,{icon:a==="correct"?_iconPaths.iconCheck:_iconPaths.iconMinus,size:24,color:_globalStyles.colors.white})
if(a==="correct"){d=[styles.markerCorrect,s&&styles.markerCorrectSelected]}else{d=[styles.markerIncorrect,s&&styles.markerIncorrectSelected]}}else if(t&&t.length>0){d=[styles.markerFilled,s&&styles.markerFilledSelected]}else{d=[s?styles.markerUnfilledSelected:i&&styles.markerUnfilledPulsate]}return React.createElement("div",{className:_aphrodite.css.apply(undefined,[styles.markerIcon].concat(d)),ref:function e(o){return r._icon=o}},c)}
r.prototype.render=function e(){var r=this
var o=this.props,t=o.label,a=o.x,n=o.y,i=o.showCorrectness
var l=i==="correct"
return React.createElement("button",{"aria-label":t,className:(0,_aphrodite.css)(styles.unstyledButton,styles.marker,l&&styles.disabled),style:{left:a+"%",top:n+"%"},tabIndex:l?-1:0,onFocus:function e(){return r.handleFocus()},onBlur:function e(){return r.handleBlur()},onClick:function e(o){return r.props.onClick(o)},onKeyDown:function e(o){return r.props.onKeyDown(o)}},this.renderIcon())}
return r}(React.Component)
Marker.defaultProps={selected:[]}
exports.default=Marker
var markerColor="#1865f2"
var selectedColor="#2552b0"
var activeColor=selectedColor
var correctColor="#00a60e"
var correctActiveColor="#167b1f"
var incorrectColor="#909195"
var incorrectActiveColor="#6c6e73"
var markerShadowColor="rgba(33, 36, 44, 0.32)"
var lightShadowColor="rgba(33, 36, 44, 0.16)"
var styles=_aphrodite.StyleSheet.create({unstyledButton:{padding:0,overflow:"visible",color:"inherit",font:"inherit",lineHeight:"normal",background:"none",border:"none"},marker:{position:"absolute",width:30,height:30,marginLeft:-15,marginTop:-15},disabled:{pointerEvents:"none"},markerIcon:{display:"flex",position:"relative",boxSizing:"content-box",width:16,height:16,marginLeft:5,cursor:"pointer",backgroundColor:markerColor,border:"solid 2px #ffffff",borderRadius:16,boxShadow:"0 2px 6px 0 "+markerShadowColor},markerUnfilledPulsate:{animationName:{"0%":{transform:"scale(1)"},"100%":{transform:"scale(1.5)"}},animationDirection:"alternate",animationDuration:"0.8s",animationIterationCount:"infinite",animationTimingFunction:"ease-in",transformOrigin:"50% 50%"},markerUnfilledSelected:{"::before":{content:"''",display:"inline-block",position:"absolute",width:20,height:20,marginLeft:-4,marginTop:-4,border:"solid 2px "+selectedColor,borderRadius:20},":active":{backgroundColor:activeColor,boxShadow:"none","::before":{display:"none"}}},markerFilled:{width:8,height:8,marginLeft:9,borderRadius:8,boxShadow:"0 1px 1px 0 "+lightShadowColor},markerFilledSelected:{"::before":{content:"''",display:"inline-block",position:"absolute",width:12,height:12,marginLeft:-4,marginTop:-4,border:"solid 2px "+selectedColor,borderRadius:12},":active":{backgroundColor:activeColor,boxShadow:"none","::before":{display:"none"}}},markerCorrect:{width:24,height:24,marginLeft:1,marginTop:1,justifyContent:"center",alignItems:"center",background:correctColor,boxShadow:"0 1px 1px 0 "+lightShadowColor},markerCorrectSelected:{"::before":{content:"''",display:"inline-block",position:"absolute",width:28,height:28,border:"solid 2px "+selectedColor,borderRadius:28},":active":{backgroundColor:correctActiveColor,boxShadow:"none","::before":{display:"none"}}},markerIncorrect:{width:24,height:24,marginLeft:1,marginTop:1,justifyContent:"center",alignItems:"center",background:incorrectColor,boxShadow:"0 1px 1px 0 "+lightShadowColor},markerIncorrectSelected:{"::before":{content:"''",display:"inline-block",position:"absolute",width:28,height:28,border:"solid 2px "+selectedColor,borderRadius:28},":active":{backgroundColor:incorrectActiveColor,boxShadow:"none","::before":{display:"none"}}}})

});
KAdefine("javascript/perseus-merged-extra-widgets-package/widgets/label-image/types.js", function(require, module, exports) {

});

//# sourceMappingURL=/genfiles/compressed_js_packages_prod/en/perseus-merged-extra-widgets-package.js.map 