/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.android.impl;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.gson.Gson;
import com.ustadmobile.core.controller.IndexLog;
import com.ustadmobile.core.controller.WebChunkPresenter;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerEntryDao;
import com.ustadmobile.core.io.ext.ContainerEntryDaoExtKt;
import com.ustadmobile.core.io.ext.ContainerEntryFileJvmExtKt;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile;
import com.ustadmobile.lib.util.RangeResponse;
import com.ustadmobile.lib.util.RangeUtilKt;
import com.ustadmobile.port.sharedse.impl.http.RangeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fR\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/ustadmobile/port/android/impl/WebChunkWebViewClient;", "Landroid/webkit/WebViewClient;", "containerUid", "", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "mPresenter", "Lcom/ustadmobile/core/controller/WebChunkPresenter;", "(JLcom/ustadmobile/core/db/UmAppDatabase;Lcom/ustadmobile/core/controller/WebChunkPresenter;)V", "indexMap", "Ljava/util/HashMap;", "", "Lcom/ustadmobile/core/controller/IndexLog$IndexEntry;", "Lcom/ustadmobile/core/controller/IndexLog;", "linkPatterns", "Ljava/util/regex/Pattern;", "presenter", "url", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "checkWithPattern", "requestUrl", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "view", "Landroid/webkit/WebView;", "request", "Landroid/webkit/WebResourceRequest;", "shouldOverrideUrlLoading", "", "app-android_release"})
public final class WebChunkWebViewClient
extends WebViewClient {
    private final long containerUid;
    @NotNull
    private final UmAppDatabase db;
    @Nullable
    private WebChunkPresenter presenter;
    @NotNull
    private final HashMap<String, IndexLog.IndexEntry> indexMap;
    @NotNull
    private final HashMap<Pattern, String> linkPatterns;
    public String url;

    public WebChunkWebViewClient(long containerUid, @NotNull UmAppDatabase db, @Nullable WebChunkPresenter mPresenter) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.containerUid = containerUid;
        this.db = db;
        this.indexMap = new HashMap();
        this.linkPatterns = new HashMap();
        try {
            Object object;
            List indexList;
            byte[] byArray;
            this.presenter = mPresenter;
            InputStream inputStream = ContainerEntryDaoExtKt.openEntryInputStream((ContainerEntryDao)this.db.getContainerEntryDao(), (long)this.containerUid, (String)"index.json");
            byte[] byArray2 = byArray = inputStream == null ? null : ByteStreamsKt.readBytes((InputStream)inputStream);
            if (byArray == null) {
                throw new IOException("Could not find index.json");
            }
            byte[] indexBytes = byArray;
            IndexLog indexLog = (IndexLog)new Gson().fromJson(new String(indexBytes, Charsets.UTF_8), IndexLog.class);
            List list = indexList = indexLog.getEntries();
            Intrinsics.checkNotNull((Object)list);
            IndexLog.IndexEntry firstUrlToOpen = (IndexLog.IndexEntry)list.get(0);
            this.setUrl(firstUrlToOpen.getUrl());
            for (IndexLog.IndexEntry log : indexList) {
                Map map = this.indexMap;
                object = log.getUrl();
                map.put(object, log);
            }
            Map linksMap = indexLog.getLinks();
            if (linksMap != null && !linksMap.isEmpty()) {
                for (String link : linksMap.keySet()) {
                    object = this.linkPatterns;
                    Pattern pattern = Pattern.compile(link);
                    Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(link)");
                    Object object2 = MapsKt.getValue((Map)linksMap, (Object)link);
                    object.put(pattern, object2);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error opening Zip File");
        }
    }

    @NotNull
    public final String getUrl() {
        String string2 = this.url;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
        return null;
    }

    public final void setUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.url = string2;
    }

    public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string2 = request.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toString()");
        String requestUrl = this.checkWithPattern(string2);
        if (requestUrl != null) {
            WebChunkPresenter webChunkPresenter = this.presenter;
            if (webChunkPresenter != null) {
                webChunkPresenter.handleUrlLinkToContentEntry(requestUrl);
            }
            return true;
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request) {
        String pageIndex;
        Uri uri2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        StringBuilder requestUrl = new StringBuilder(request.getUrl().toString());
        String string2 = requestUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requestUrl.toString()");
        String sourceUrl = this.checkWithPattern(string2);
        if (sourceUrl != null) {
            WebChunkPresenter webChunkPresenter = this.presenter;
            if (webChunkPresenter != null) {
                webChunkPresenter.handleUrlLinkToContentEntry(sourceUrl);
            }
            new Handler(Looper.getMainLooper()).post(() -> WebChunkWebViewClient.shouldInterceptRequest$lambda-0(view, this));
            return new WebResourceResponse("text/html", "utf-8", null);
        }
        string2 = requestUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requestUrl.toString()");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"/Take-a-hint", (boolean)false, (int)2, null)) {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = "true".getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new WebResourceResponse("text/plain", "utf-8", (InputStream)new ByteArrayInputStream(byArray));
        }
        IndexLog.IndexEntry log = this.indexMap.get(requestUrl.toString());
        if (log == null) {
            uri2 = ((Map)this.indexMap).entrySet().iterator();
            while (uri2.hasNext()) {
                String string3;
                String key = (String)((Map.Entry)uri2.next()).getKey();
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"plixbrowse", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"plixbrowse", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"https://www.ck12.org/assessment/api/render/questionInstance?qID", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"https://www.ck12.org/assessment/api/render/questionInstance?qID", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"https://www.ck12.org/assessment/api/get/info/test/plix%20practice/plixID/", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"https://www.ck12.org/assessment/api/get/info/test/plix%20practice/plixID/", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"https://www.ck12.org/assessment/api/start/tests/", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"https://www.ck12.org/assessment/api/start/tests/", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"hint", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"hint", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"attempt", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"attempt", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"/api/internal/user/task/practice/", (boolean)false, (int)2, null)) {
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"/api/internal/user/task/practice/", (boolean)false, (int)2, null)) {
                        view.post(() -> WebChunkWebViewClient.shouldInterceptRequest$lambda-1(view, this));
                        return super.shouldInterceptRequest(view, request);
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"/assessment_item", (boolean)false, (int)2, null)) {
                    int langIndex;
                    String newRequestUrl;
                    string3 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"/assessment_item", (boolean)false, (int)2, null) && (log = this.indexMap.get(newRequestUrl = requestUrl.substring(0, langIndex = requestUrl.indexOf("?lang")))) != null) break;
                }
                if (!StringsKt.contains$default((CharSequence)key, (CharSequence)"/Quiz/Answer", (boolean)false, (int)2, null)) continue;
                String langIndex = requestUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)langIndex, (String)"requestUrl.toString()");
                if (!StringsKt.contains$default((CharSequence)langIndex, (CharSequence)"/Quiz/Answer", (boolean)false, (int)2, null)) continue;
                Map headers = request.getRequestHeaders();
                pageIndex = (String)headers.get("PageIndex");
                String answerId = (String)headers.get("AnswerId");
                requestUrl.append("?page=").append(pageIndex);
                if (answerId != null && ((CharSequence)answerId).length() == 0) {
                    requestUrl.append("&answer=").append(answerId);
                }
                log = this.indexMap.get(requestUrl.toString());
                break;
            }
        }
        if (log == null) {
            uri2 = request.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"request.url");
            System.err.println(Intrinsics.stringPlus((String)"did not find match for url in indexMap ", (Object)uri2));
            return new WebResourceResponse("", "utf-8", 200, "OK", null, null);
        }
        try {
            InputStream headers;
            ContainerEntryDao containerEntryDao = this.db.getContainerEntryDao();
            String string4 = log.getPath();
            Intrinsics.checkNotNull((Object)string4);
            ContainerEntryWithContainerEntryFile containerEntryWithContainerEntryFile = containerEntryDao.findByPathInContainer(this.containerUid, string4);
            if (containerEntryWithContainerEntryFile == null) {
                return new WebResourceResponse("", "utf-8", 404, "Not Found", null, null);
            }
            ContainerEntryWithContainerEntryFile entry = containerEntryWithContainerEntryFile;
            Map mutMap = null;
            mutMap = new LinkedHashMap();
            if (log.getHeaders() != null) {
                Map map = log.getHeaders();
                Intrinsics.checkNotNull((Object)map);
                mutMap.putAll(map);
            }
            ContainerEntryFile containerEntryFile = entry.getContainerEntryFile();
            Intrinsics.checkNotNull((Object)containerEntryFile);
            if (containerEntryFile.getCompression() == 1) {
                mutMap.put("Content-Encoding", "gzip");
                ContainerEntryFile containerEntryFile2 = entry.getContainerEntryFile();
                Intrinsics.checkNotNull((Object)containerEntryFile2);
                mutMap.put("Content-Length", String.valueOf(containerEntryFile2.getCeCompressedSize()));
            }
            ContainerEntryFile containerEntryFile3 = entry.getContainerEntryFile();
            InputStream inputStream = headers = containerEntryFile3 == null ? null : ContainerEntryFileJvmExtKt.openInputStream((ContainerEntryFile)containerEntryFile3);
            if (headers == null) {
                throw new IOException(Intrinsics.stringPlus((String)entry.getCePath(), (Object)" has no containerentryfile"));
            }
            InputStream data = headers;
            pageIndex = (String)request.getRequestHeaders().get("Range");
            if (pageIndex == null) {
                return new WebResourceResponse(log.getMimeType(), "utf-8", 200, "OK", mutMap, data);
            }
            String rangeHeader = pageIndex;
            ContainerEntryFile containerEntryFile4 = entry.getContainerEntryFile();
            Intrinsics.checkNotNull((Object)containerEntryFile4);
            long totalLength = containerEntryFile4.getCeTotalSize();
            boolean isHEADRequest = Intrinsics.areEqual((Object)request.getMethod(), (Object)"HEAD");
            RangeResponse range = RangeUtilKt.parseRangeRequestHeader((String)rangeHeader, (long)totalLength);
            if (range != null && range.getStatusCode() == 206) {
                if (!isHEADRequest) {
                    data = (InputStream)new RangeInputStream(data, range.getFromByte(), range.getToByte());
                }
                Map $this$forEach$iv = range.getResponseHeaders();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl = false;
                    mutMap.put(it.getKey(), it.getValue());
                }
                return new WebResourceResponse(log.getMimeType(), "utf-8", 206, "Partial Content", mutMap, isHEADRequest ? null : data);
            }
            RangeResponse rangeResponse = range;
            if (rangeResponse == null ? false : rangeResponse.getStatusCode() == 416) {
                return new WebResourceResponse("text/plain", "utf-8", 416, isHEADRequest ? "" : "Range request not satisfiable", null, null);
            }
            mutMap.put("Content-Length", String.valueOf(totalLength));
            mutMap.put("Connection", "close");
            return new WebResourceResponse(log.getMimeType(), "utf-8", 200, "OK", mutMap, data);
        }
        catch (Exception e) {
            String string5 = log.getUrl();
            Intrinsics.checkNotNull((Object)string5);
            System.err.println(Intrinsics.stringPlus((String)"did not find entry in zip for url ", (Object)string5));
            e.printStackTrace();
            return super.shouldInterceptRequest(view, request);
        }
    }

    private final String checkWithPattern(String requestUrl) {
        for (Pattern linkPattern : this.linkPatterns.keySet()) {
            if (!linkPattern.matcher(requestUrl).lookingAt()) continue;
            return this.linkPatterns.get(linkPattern);
        }
        return null;
    }

    private static final void shouldInterceptRequest$lambda-0(WebView $view, WebChunkWebViewClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $view.loadUrl(this$0.getUrl());
    }

    private static final void shouldInterceptRequest$lambda-1(WebView $view, WebChunkWebViewClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $view.loadUrl(this$0.getUrl());
    }
}

