package com.ustadmobile.port.android.view.ext;

import java.lang.System;

@kotlin.Metadata(mv = {1, 6, 0}, k = 2, d1 = {"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2 = {"adjustHeightToDisplayHeight", "", "Landroid/webkit/WebView;", "adjustHeightToWrapContent", "scrollToAnchor", "anchorName", "", "app-android_debug"})
public final class WebViewExtKt {
    
    /**
     * Used by the EpubActivity to scroll to an anchor (e.g. hash link). It will determine the position
     * of the given anchor and then call UstadEpub.scrollDown so that the recyclerview can scroll to
     * the given position.
     *
     * This is necessary because WebViews in EPUBs have their height set to wrap_content - so there is
     * no 'internal' scrolling within the webview itself.
     */
    public static final void scrollToAnchor(@org.jetbrains.annotations.NotNull()
    android.webkit.WebView $this$scrollToAnchor, @org.jetbrains.annotations.NotNull()
    java.lang.String anchorName) {
    }
    
    /**
     * This will set the height of the WebView to match the height of the display. This is useful when
     * we have the WebView in a RecyclerView as it will avoid the RecyclerView creating too many
     * ViewHolders at the start. This will happen if the WebView's height is set to wrap_content before
     * the page loads, as the height will be considered as 0 before it loads.
     */
    public static final void adjustHeightToDisplayHeight(@org.jetbrains.annotations.NotNull()
    android.webkit.WebView $this$adjustHeightToDisplayHeight) {
    }
    
    /**
     * Adjust the height of the WebView to WRAP_CONTENT (e.g. use this after content has loaded)
     */
    public static final void adjustHeightToWrapContent(@org.jetbrains.annotations.NotNull()
    android.webkit.WebView $this$adjustHeightToWrapContent) {
    }
}