package com.ustadmobile.port.android.view;

import java.lang.System;

@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H&\u00a8\u0006\n"}, d2 = {"Lcom/ustadmobile/port/android/view/ItemTouchHelperAdapter;", "", "onItemDismiss", "", "position", "", "onItemMove", "", "fromPosition", "toPosition", "app-android_release"})
public abstract interface ItemTouchHelperAdapter {
    
    /**
     * Called when an item has been dragged far enough to trigger a move. This is called every time
     * an item is shifted, and **not** at the end of a "drop" event.<br></br>
     * <br></br>
     * Implementations should call {link RecyclerView.Adapter#notifyItemMoved(int, int)} after
     * adjusting the underlying data to reflect this move.
     *
     * @param fromPosition The start position of the moved item.
     * @param toPosition   Then resolved position of the moved item.
     * @return True if the item was moved to the new adapter position.
     *
     *
     * see RecyclerView#getAdapterPositionFor(RecyclerView.ViewHolder)
     * see RecyclerView.ViewHolder#getAdapterPosition()
     */
    public abstract boolean onItemMove(int fromPosition, int toPosition);
    
    /**
     * Called when an item has been dismissed by a swipe.<br></br>
     * <br></br>
     * Implementations should call {link RecyclerView.Adapter#notifyItemRemoved(int)} after
     * adjusting the underlying data to reflect this removal.
     *
     * @param position The position of the item dismissed.
     *
     *
     * see RecyclerView#getAdapterPositionFor(RecyclerView.ViewHolder)
     * see RecyclerView.ViewHolder#getAdapterPosition()
     */
    public abstract void onItemDismiss(int position);
}