package com.ustadmobile.port.android.view.util;

import java.lang.System;

/**
 * This FragmentPagerAdapter is designed to work with Ustad Mobile's views implemented in Fragments.
 * Given a list of viewUris (eg ViewName?arg=val) strings and a map of view names to fragment classes,
 * it will instantiate the correct fragment and set the arguments.
 *
 * @param viewList A list of ViewUris that should be shown as tabs (e.g. ["ViewName1?arg1=val", "ViewName2"])
 * @param viewNameToFragmentClassMap a map of the view names to the class objects for fragments that implement them
 * @param bundleMakerFn A function that will take in the viewUri and index and provide the argument
 * bundle. By default this will simply parse out the argument bundle from the item in the viewList.
 * However if all views have the same arguments you can just provide a single premade bundle.
 */
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00128\b\u0002\u0010\r\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000e\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016RA\u0010\r\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R%\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2 = {"Lcom/ustadmobile/port/android/view/util/ViewNameListFragmentPagerAdapter;", "Landroidx/viewpager2/adapter/FragmentStateAdapter;", "fm", "Landroidx/fragment/app/FragmentManager;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "viewList", "", "", "viewNameToFragmentClassMap", "", "Ljava/lang/Class;", "Landroidx/fragment/app/Fragment;", "bundleMakerFn", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "viewUri", "", "index", "Landroid/os/Bundle;", "(Landroidx/fragment/app/FragmentManager;Landroidx/lifecycle/Lifecycle;Ljava/util/List;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)V", "getBundleMakerFn", "()Lkotlin/jvm/functions/Function2;", "getViewList", "()Ljava/util/List;", "getViewNameToFragmentClassMap", "()Ljava/util/Map;", "createFragment", "position", "getItemCount", "app-android_release"})
public class ViewNameListFragmentPagerAdapter extends androidx.viewpager2.adapter.FragmentStateAdapter {
    @org.jetbrains.annotations.NotNull()
    private final java.util.List<java.lang.String> viewList = null;
    @org.jetbrains.annotations.NotNull()
    private final java.util.Map<java.lang.String, java.lang.Class<? extends androidx.fragment.app.Fragment>> viewNameToFragmentClassMap = null;
    @org.jetbrains.annotations.NotNull()
    private final kotlin.jvm.functions.Function2<java.lang.String, java.lang.Integer, android.os.Bundle> bundleMakerFn = null;
    
    public ViewNameListFragmentPagerAdapter(@org.jetbrains.annotations.NotNull()
    androidx.fragment.app.FragmentManager fm, @org.jetbrains.annotations.NotNull()
    androidx.lifecycle.Lifecycle lifecycle, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> viewList, @org.jetbrains.annotations.NotNull()
    java.util.Map<java.lang.String, ? extends java.lang.Class<? extends androidx.fragment.app.Fragment>> viewNameToFragmentClassMap, @org.jetbrains.annotations.NotNull()
    kotlin.jvm.functions.Function2<? super java.lang.String, ? super java.lang.Integer, android.os.Bundle> bundleMakerFn) {
        super(null);
    }
    
    @org.jetbrains.annotations.NotNull()
    public final java.util.List<java.lang.String> getViewList() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final java.util.Map<java.lang.String, java.lang.Class<? extends androidx.fragment.app.Fragment>> getViewNameToFragmentClassMap() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final kotlin.jvm.functions.Function2<java.lang.String, java.lang.Integer, android.os.Bundle> getBundleMakerFn() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    @java.lang.Override()
    public androidx.fragment.app.Fragment createFragment(int position) {
        return null;
    }
    
    @java.lang.Override()
    public int getItemCount() {
        return 0;
    }
}